"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cluster = exports.ClusterProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const emr_generated_1 = require("./emr.generated");
Object.defineProperty(exports, "ClusterProperty", { enumerable: true, get: function () { return emr_generated_1.RosCluster; } });
/**
 * A ROS resource type:  `ALIYUN::EMR::Cluster`
 */
class Cluster extends ros.Resource {
    /**
     * Create a new `ALIYUN::EMR::Cluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosCluster = new emr_generated_1.RosCluster(this, id, {
            bootstrapAction: props.bootstrapAction,
            securityGroupName: props.securityGroupName,
            config: props.config,
            autoRenew: props.autoRenew,
            hostGroup: props.hostGroup,
            userInfo: props.userInfo,
            highAvailabilityEnable: props.highAvailabilityEnable,
            name: props.name,
            optionSoftWareList: props.optionSoftWareList,
            masterPwd: props.masterPwd,
            sshEnable: props.sshEnable,
            useCustomHiveMetaDb: props.useCustomHiveMetaDb,
            isOpenPublicIp: props.isOpenPublicIp,
            configurations: props.configurations,
            authorizeContent: props.authorizeContent,
            netType: props.netType,
            userDefinedEmrEcsRole: props.userDefinedEmrEcsRole,
            useLocalMetaDb: props.useLocalMetaDb,
            keyPairName: props.keyPairName,
            ioOptimized: props.ioOptimized ? props.ioOptimized : true,
            zoneId: props.zoneId,
            vSwitchId: props.vSwitchId,
            securityGroupId: props.securityGroupId,
            machineType: props.machineType,
            depositType: props.depositType,
            metaStoreType: props.metaStoreType,
            period: props.period,
            emrVer: props.emrVer,
            clusterType: props.clusterType,
            easEnable: props.easEnable,
            relatedClusterId: props.relatedClusterId,
            vpcId: props.vpcId,
            chargeType: props.chargeType,
            whiteListType: props.whiteListType,
            metaStoreConf: props.metaStoreConf,
            instanceGeneration: props.instanceGeneration,
            logPath: props.logPath,
            initCustomHiveMetaDb: props.initCustomHiveMetaDb,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosCluster;
        this.attrClusterId = rosCluster.attrClusterId;
        this.attrHostGroups = rosCluster.attrHostGroups;
        this.attrMasterNodeInnerIps = rosCluster.attrMasterNodeInnerIps;
        this.attrMasterNodePubIps = rosCluster.attrMasterNodePubIps;
    }
}
exports.Cluster = Cluster;
//# sourceMappingURL=data:application/json;base64,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