#!/usr/bin/env python

"""
camcops_server/alembic/versions/0044_mojo_therapy_sessions_planned_comment.py

===============================================================================

    Copyright (C) 2012, University of Cambridge, Department of Psychiatry.
    Created by Rudolf Cardinal (rnc1001@cam.ac.uk).

    This file is part of CamCOPS.

    CamCOPS is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    CamCOPS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with CamCOPS. If not, see <https://www.gnu.org/licenses/>.

===============================================================================

DATABASE REVISION SCRIPT

mojo_therapy_sessions_planned_comment

Revision ID: 0044
Revises: 0043
Creation date: 2020-02-24 12:18:37.252761

"""

# =============================================================================
# Imports
# =============================================================================

from alembic import op
from sqlalchemy.dialects import mysql


# =============================================================================
# Revision identifiers, used by Alembic.
# =============================================================================

revision = "0044"
down_revision = "0043"
branch_labels = None
depends_on = None


# =============================================================================
# The upgrade/downgrade steps
# =============================================================================

# noinspection PyPep8,PyTypeChecker
def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table(
        "khandaker_mojo_therapy_item", schema=None
    ) as batch_op:
        batch_op.alter_column(
            "sessions_planned",
            existing_type=mysql.INTEGER(display_width=11),
            comment="Sessions planned",
            existing_comment="Total number of sessions planned",
            existing_nullable=True,
        )

    # ### end Alembic commands ###


# noinspection PyPep8,PyTypeChecker
def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table(
        "khandaker_mojo_therapy_item", schema=None
    ) as batch_op:
        batch_op.alter_column(
            "sessions_planned",
            existing_type=mysql.INTEGER(display_width=11),
            comment="Total number of sessions planned",
            existing_comment="Sessions planned",
            existing_nullable=True,
        )

    # ### end Alembic commands ###
