#!/usr/bin/env python

"""
camcops_server/alembic/versions/0017_perinatal_poem.py

===============================================================================

    Copyright (C) 2012, University of Cambridge, Department of Psychiatry.
    Created by Rudolf Cardinal (rnc1001@cam.ac.uk).

    This file is part of CamCOPS.

    CamCOPS is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    CamCOPS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with CamCOPS. If not, see <https://www.gnu.org/licenses/>.

===============================================================================

DATABASE REVISION SCRIPT

Perinatal POEM task; also, "tasks" option for export recipients.

Revision ID: 0017
Revises: 0016
Creation date: 2019-02-11 12:30:32.986374

"""

# =============================================================================
# Imports
# =============================================================================

from alembic import op
import sqlalchemy as sa
import cardinal_pythonlib.sqlalchemy.list_types

from camcops_server.cc_modules.cc_sqla_coltypes import (
    PendulumDateTimeAsIsoTextColType,
    SemanticVersionColType,
)


# =============================================================================
# Revision identifiers, used by Alembic.
# =============================================================================

revision = "0017"
down_revision = "0016"
branch_labels = None
depends_on = None


# =============================================================================
# The upgrade/downgrade steps
# =============================================================================

# noinspection PyPep8,PyTypeChecker
def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "perinatal_poem",
        sa.Column(
            "qa",
            sa.Integer(),
            nullable=True,
            comment=(
                "Question A: Is the respondent the patient (1) or other (2)?"
            ),
        ),
        sa.Column(
            "qb",
            sa.Integer(),
            nullable=True,
            comment=(
                "Question B: Was the service type inpatient [mother-and-baby"
                " unit, MBU] (1) or community (2)?"
            ),
        ),
        sa.Column(
            "q1a",
            sa.Integer(),
            nullable=True,
            comment=(
                "Q1A: mental health at first contact (1 very well, 2 well, 3"
                " unwell, 4 very unwell, 5 extremely unwell)"
            ),
        ),
        sa.Column(
            "q1b",
            sa.Integer(),
            nullable=True,
            comment=(
                "Q1B: mental health at discharge (1 very well, 2 well, 3"
                " unwell, 4 very unwell, 5 extremely unwell)"
            ),
        ),
        sa.Column(
            "q2a",
            sa.Integer(),
            nullable=True,
            comment=(
                "Q2a: staff didn't communicate with others (1 strongly agree,"
                " 2 agree, 3 disagree, 4 strongly disagree)"
            ),
        ),
        sa.Column(
            "q2b",
            sa.Integer(),
            nullable=True,
            comment=(
                "Q2b: Staff gave right amount of support (1 strongly agree, 2"
                " agree, 3 disagree, 4 strongly disagree)"
            ),
        ),
        sa.Column(
            "q2c",
            sa.Integer(),
            nullable=True,
            comment=(
                "Q2c: Help not quick enough after referral (1 strongly agree,"
                " 2 agree, 3 disagree, 4 strongly disagree)"
            ),
        ),
        sa.Column(
            "q2d",
            sa.Integer(),
            nullable=True,
            comment=(
                "Q2d: Staff listened/understood (1 strongly agree, 2 agree, 3"
                " disagree, 4 strongly disagree)"
            ),
        ),
        sa.Column(
            "q2e",
            sa.Integer(),
            nullable=True,
            comment=(
                "Q2e: Staff didn't involve pt enough (1 strongly agree, 2"
                " agree, 3 disagree, 4 strongly disagree)"
            ),
        ),
        sa.Column(
            "q2f",
            sa.Integer(),
            nullable=True,
            comment=(
                "Q2f: Service provided information (1 strongly agree, 2 agree,"
                " 3 disagree, 4 strongly disagree)"
            ),
        ),
        sa.Column(
            "q2g",
            sa.Integer(),
            nullable=True,
            comment=(
                "Q2g: Staff not very sensitive to pt (1 strongly agree, 2"
                " agree, 3 disagree, 4 strongly disagree)"
            ),
        ),
        sa.Column(
            "q2h",
            sa.Integer(),
            nullable=True,
            comment=(
                "Q2h: Staff helped understanding of illness (1 strongly agree,"
                " 2 agree, 3 disagree, 4 strongly disagree)"
            ),
        ),
        sa.Column(
            "q2i",
            sa.Integer(),
            nullable=True,
            comment=(
                "Q2i: Staff not very sensitive to baby (1 strongly agree, 2"
                " agree, 3 disagree, 4 strongly disagree)"
            ),
        ),
        sa.Column(
            "q2j",
            sa.Integer(),
            nullable=True,
            comment=(
                "Q2j: Staff helped confidence re baby (1 strongly agree, 2"
                " agree, 3 disagree, 4 strongly disagree)"
            ),
        ),
        sa.Column(
            "q2k",
            sa.Integer(),
            nullable=True,
            comment=(
                "Q2k: Service involved others helpfully (1 strongly agree, 2"
                " agree, 3 disagree, 4 strongly disagree)"
            ),
        ),
        sa.Column(
            "q2l",
            sa.Integer(),
            nullable=True,
            comment=(
                "Q2l: Would recommend service (1 strongly agree, 2 agree, 3"
                " disagree, 4 strongly disagree)"
            ),
        ),
        sa.Column(
            "q3a",
            sa.Integer(),
            nullable=True,
            comment=(
                "Q3a: MBU clean (1 strongly agree, 2 agree, 3 disagree, 4"
                " strongly disagree) [Inpatient services only]"
            ),
        ),
        sa.Column(
            "q3b",
            sa.Integer(),
            nullable=True,
            comment=(
                "Q3b: MBU not a good place to recover (1 strongly agree, 2"
                " agree, 3 disagree, 4 strongly disagree) [Inpatient services"
                " only]"
            ),
        ),
        sa.Column(
            "q3c",
            sa.Integer(),
            nullable=True,
            comment=(
                "Q3c: MBU did not provide helpful activities (1 strongly"
                " agree, 2 agree, 3 disagree, 4 strongly disagree) [Inpatient"
                " services only]"
            ),
        ),
        sa.Column(
            "q3d",
            sa.Integer(),
            nullable=True,
            comment=(
                "Q3d: MBU a good place for baby to be with pt (1 strongly"
                " agree, 2 agree, 3 disagree, 4 strongly disagree) [Inpatient"
                " services only]"
            ),
        ),
        sa.Column(
            "q3e",
            sa.Integer(),
            nullable=True,
            comment=(
                "Q3e: MBU supported contact with family/friends (1 strongly"
                " agree, 2 agree, 3 disagree, 4 strongly disagree) [Inpatient"
                " services only]"
            ),
        ),
        sa.Column(
            "q3f",
            sa.Integer(),
            nullable=True,
            comment=(
                "Q3f: Food not acceptable (1 strongly agree, 2 agree, 3"
                " disagree, 4 strongly disagree) [Inpatient services only]"
            ),
        ),
        sa.Column(
            "general_comments",
            sa.UnicodeText(),
            nullable=True,
            comment="General comments",
        ),
        sa.Column(
            "future_participation",
            sa.Integer(),
            nullable=True,
            comment="Willing to participate in future studies (1 yes, 0 no)",
        ),
        sa.Column(
            "contact_details",
            sa.UnicodeText(),
            nullable=True,
            comment="Contact details",
        ),
        sa.Column(
            "when_created",
            PendulumDateTimeAsIsoTextColType(length=32),
            nullable=False,
            comment=(
                "(TASK) Date/time this task instance was created (ISO 8601)"
            ),
        ),
        sa.Column(
            "when_firstexit",
            PendulumDateTimeAsIsoTextColType(length=32),
            nullable=True,
            comment=(
                "(TASK) Date/time of the first exit from this task (ISO 8601)"
            ),
        ),
        sa.Column(
            "firstexit_is_finish",
            sa.Boolean(),
            nullable=True,
            comment=(
                "(TASK) Was the first exit from the task because it was"
                " finished (1)?"
            ),
        ),
        sa.Column(
            "firstexit_is_abort",
            sa.Boolean(),
            nullable=True,
            comment=(
                "(TASK) Was the first exit from this task because it was"
                " aborted (1)?"
            ),
        ),
        sa.Column(
            "editing_time_s",
            sa.Float(),
            nullable=True,
            comment="(TASK) Time spent editing (s)",
        ),
        sa.Column(
            "_pk",
            sa.Integer(),
            autoincrement=True,
            nullable=False,
            comment="(SERVER) Primary key (on the server)",
        ),
        sa.Column(
            "_device_id",
            sa.Integer(),
            nullable=False,
            comment="(SERVER) ID of the source tablet device",
        ),
        sa.Column(
            "_era",
            sa.String(length=32),
            nullable=False,
            comment=(
                "(SERVER) 'NOW', or when this row was preserved and removed"
                " from the source device (UTC ISO 8601)"
            ),
        ),
        sa.Column(
            "_current",
            sa.Boolean(),
            nullable=False,
            comment="(SERVER) Is the row current (1) or not (0)?",
        ),
        sa.Column(
            "_when_added_exact",
            PendulumDateTimeAsIsoTextColType(length=32),
            nullable=True,
            comment="(SERVER) Date/time this row was added (ISO 8601)",
        ),
        sa.Column(
            "_when_added_batch_utc",
            sa.DateTime(),
            nullable=True,
            comment=(
                "(SERVER) Date/time of the upload batch that added this row"
                " (DATETIME in UTC)"
            ),
        ),
        sa.Column(
            "_adding_user_id",
            sa.Integer(),
            nullable=True,
            comment="(SERVER) ID of user that added this row",
        ),
        sa.Column(
            "_when_removed_exact",
            PendulumDateTimeAsIsoTextColType(length=32),
            nullable=True,
            comment=(
                "(SERVER) Date/time this row was removed, i.e. made not"
                " current (ISO 8601)"
            ),
        ),
        sa.Column(
            "_when_removed_batch_utc",
            sa.DateTime(),
            nullable=True,
            comment=(
                "(SERVER) Date/time of the upload batch that removed this row"
                " (DATETIME in UTC)"
            ),
        ),
        sa.Column(
            "_removing_user_id",
            sa.Integer(),
            nullable=True,
            comment="(SERVER) ID of user that removed this row",
        ),
        sa.Column(
            "_preserving_user_id",
            sa.Integer(),
            nullable=True,
            comment="(SERVER) ID of user that preserved this row",
        ),
        sa.Column(
            "_forcibly_preserved",
            sa.Boolean(),
            nullable=True,
            comment=(
                "(SERVER) Forcibly preserved by superuser (rather than"
                " normally preserved by tablet)?"
            ),
        ),
        sa.Column(
            "_predecessor_pk",
            sa.Integer(),
            nullable=True,
            comment="(SERVER) PK of predecessor record, prior to modification",
        ),
        sa.Column(
            "_successor_pk",
            sa.Integer(),
            nullable=True,
            comment=(
                "(SERVER) PK of successor record  (after modification) or NULL"
                " (whilst live, or after deletion)"
            ),
        ),
        sa.Column(
            "_manually_erased",
            sa.Boolean(),
            nullable=True,
            comment="(SERVER) Record manually erased (content destroyed)?",
        ),
        sa.Column(
            "_manually_erased_at",
            PendulumDateTimeAsIsoTextColType(length=32),
            nullable=True,
            comment="(SERVER) Date/time of manual erasure (ISO 8601)",
        ),
        sa.Column(
            "_manually_erasing_user_id",
            sa.Integer(),
            nullable=True,
            comment="(SERVER) ID of user that erased this row manually",
        ),
        sa.Column(
            "_camcops_version",
            SemanticVersionColType(length=147),
            nullable=True,
            comment="(SERVER) CamCOPS version number of the uploading device",
        ),
        sa.Column(
            "_addition_pending",
            sa.Boolean(),
            nullable=False,
            comment="(SERVER) Addition pending?",
        ),
        sa.Column(
            "_removal_pending",
            sa.Boolean(),
            nullable=True,
            comment="(SERVER) Removal pending?",
        ),
        sa.Column(
            "_group_id",
            sa.Integer(),
            nullable=False,
            comment="(SERVER) ID of group to which this record belongs",
        ),
        sa.Column(
            "id",
            sa.Integer(),
            nullable=False,
            comment="(TASK) Primary key (task ID) on the tablet device",
        ),
        sa.Column(
            "when_last_modified",
            PendulumDateTimeAsIsoTextColType(length=32),
            nullable=True,
            comment=(
                "(STANDARD) Date/time this row was last modified on the source"
                " tablet device (ISO 8601)"
            ),
        ),
        sa.Column(
            "_move_off_tablet",
            sa.Boolean(),
            nullable=True,
            comment="(SERVER/TABLET) Record-specific preservation pending?",
        ),
        sa.ForeignKeyConstraint(
            ["_adding_user_id"],
            ["_security_users.id"],
            name=op.f("fk_perinatal_poem__adding_user_id"),
        ),
        sa.ForeignKeyConstraint(
            ["_device_id"],
            ["_security_devices.id"],
            name=op.f("fk_perinatal_poem__device_id"),
        ),
        sa.ForeignKeyConstraint(
            ["_group_id"],
            ["_security_groups.id"],
            name=op.f("fk_perinatal_poem__group_id"),
        ),
        sa.ForeignKeyConstraint(
            ["_manually_erasing_user_id"],
            ["_security_users.id"],
            name=op.f("fk_perinatal_poem__manually_erasing_user_id"),
        ),
        sa.ForeignKeyConstraint(
            ["_preserving_user_id"],
            ["_security_users.id"],
            name=op.f("fk_perinatal_poem__preserving_user_id"),
        ),
        sa.ForeignKeyConstraint(
            ["_removing_user_id"],
            ["_security_users.id"],
            name=op.f("fk_perinatal_poem__removing_user_id"),
        ),
        sa.PrimaryKeyConstraint("_pk", name=op.f("pk_perinatal_poem")),
        mysql_charset="utf8mb4 COLLATE utf8mb4_unicode_ci",
        mysql_engine="InnoDB",
        mysql_row_format="DYNAMIC",
    )
    with op.batch_alter_table("perinatal_poem", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_perinatal_poem__current"),
            ["_current"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_perinatal_poem__device_id"),
            ["_device_id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_perinatal_poem__era"), ["_era"], unique=False
        )
        batch_op.create_index(
            batch_op.f("ix_perinatal_poem__group_id"),
            ["_group_id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_perinatal_poem__pk"), ["_pk"], unique=False
        )
        batch_op.create_index(
            batch_op.f("ix_perinatal_poem_id"), ["id"], unique=False
        )
        batch_op.create_index(
            batch_op.f("ix_perinatal_poem_when_last_modified"),
            ["when_last_modified"],
            unique=False,
        )

    with op.batch_alter_table("_export_recipients", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "tasks",
                cardinal_pythonlib.sqlalchemy.list_types.StringListType(),
                nullable=True,
                comment=(
                    "Base table names of CamCOPS tasks to export data from (as"
                    " CSV)"
                ),
            )
        )

    # ### end Alembic commands ###


def downgrade():
    with op.batch_alter_table("_export_recipients", schema=None) as batch_op:
        batch_op.drop_column("tasks")

    op.drop_table("perinatal_poem")
