/*
 * Decompiled with CFR 0.152.
 */
package psf.vri_gibsonlanni;

import bilib.commons.math.bessel.Bessel;
import psf.vri_gibsonlanni.VRIGLParameters;

public class KirchhoffDiffractionSimpson {
    private VRIGLParameters p;
    private double TOL = 0.1;
    private int K = 1;
    private double resLateral = 100.0;
    private double resAxial = 250.0;

    public KirchhoffDiffractionSimpson(VRIGLParameters p, int accuracy, int z, double resLateral, double resAxial) {
        this.p = p;
        this.resLateral = resLateral;
        this.resAxial = resAxial;
        this.K = accuracy == 0 ? 5 : (accuracy == 1 ? 7 : (accuracy == 2 ? 9 : 3));
    }

    double calculate(double r) {
        double a = 0.0;
        double b = Math.min(1.0, this.p.ni / this.p.NA);
        double[] sumOddIndex = new double[2];
        double[] sumEvenIndex = new double[2];
        double[] valueX0 = new double[2];
        double[] valueXn = new double[2];
        double[] value = new double[2];
        double curI = 0.0;
        double prevI = 0.0;
        int N = 2;
        double del = (b - a) / 2.0;
        int k = 0;
        int iteration = 1;
        double rho = (b - a) / 2.0;
        sumOddIndex = this.integrand(rho, r);
        sumEvenIndex[0] = 0.0;
        sumEvenIndex[1] = 0.0;
        valueX0 = this.integrand(a, r);
        valueXn = this.integrand(b, r);
        double realSum = valueX0[0] + 2.0 * sumEvenIndex[0] + 4.0 * sumOddIndex[0] + valueXn[0];
        double imagSum = valueX0[1] + 2.0 * sumEvenIndex[1] + 4.0 * sumOddIndex[1] + valueXn[1];
        prevI = curI = (realSum * realSum + imagSum * imagSum) * del * del;
        double curDifference = this.TOL;
        while (k < this.K && iteration < 10000) {
            ++iteration;
            N *= 2;
            del /= 2.0;
            sumEvenIndex[0] = sumEvenIndex[0] + sumOddIndex[0];
            sumEvenIndex[1] = sumEvenIndex[1] + sumOddIndex[1];
            sumOddIndex[0] = 0.0;
            sumOddIndex[1] = 0.0;
            int n = 1;
            while (n < N) {
                rho = (double)n * del;
                value = this.integrand(rho, r);
                sumOddIndex[0] = sumOddIndex[0] + value[0];
                sumOddIndex[1] = sumOddIndex[1] + value[1];
                n += 2;
            }
            realSum = valueX0[0] + 2.0 * sumEvenIndex[0] + 4.0 * sumOddIndex[0] + valueXn[0];
            imagSum = valueX0[1] + 2.0 * sumEvenIndex[1] + 4.0 * sumOddIndex[1] + valueXn[1];
            curI = (realSum * realSum + imagSum * imagSum) * del * del;
            curDifference = prevI == 0.0 ? Math.abs((prevI - curI) / 1.0E-5) : Math.abs((prevI - curI) / curI);
            k = curDifference <= this.TOL ? ++k : 0;
            prevI = curI;
        }
        return curI;
    }

    double[] integrand(double rho, double r) {
        double k0 = Math.PI * 2 / this.p.lambda;
        double BesselValue = Bessel.J0(k0 * this.p.NA * r * rho);
        int zint = (int)Math.ceil(this.p.particleAxialPosition / (this.resAxial * 1.0E-9));
        double[] I = new double[2];
        double OPD1 = this.resLateral * 1.0E-9 * this.angleinterm(zint, this.p.ns1, this.p.ns2, this.p.NA, rho, this.p.type);
        double OPD3 = this.p.ni * (this.p.ti - this.p.ti0) * Math.sqrt(1.0 - this.p.NA * rho / this.p.ni * (this.p.NA * rho / this.p.ni));
        double OPD = OPD1 + OPD3;
        double W = k0 * OPD;
        I[0] = BesselValue * Math.cos(W) * rho;
        I[1] = BesselValue * Math.sin(W) * rho;
        return I;
    }

    private double angleinterm(int zin, double ns1, double ns2, double NA, double rho, int type) {
        double sumaRI;
        block4: {
            block5: {
                block3: {
                    sumaRI = 0.0;
                    if (type != 0) break block3;
                    double b = ns1;
                    double a = (ns2 - b) / (double)zin;
                    int l = 0;
                    while (l < zin) {
                        sumaRI += Math.sqrt(Math.abs(a * (double)l + b - NA * rho));
                        ++l;
                    }
                    break block4;
                }
                if (type != 1) break block5;
                double b = Math.exp(ns1);
                double a = (Math.exp(ns2) - b) / (double)zin;
                int l = 0;
                while (l < zin) {
                    sumaRI += Math.sqrt(Math.abs(Math.log(a * (double)l + b) - NA * rho));
                    ++l;
                }
                break block4;
            }
            if (type != 2) break block4;
            double b = Math.log(ns1);
            double a = (Math.log(ns2) - b) / (double)zin;
            int l = 0;
            while (l < zin) {
                sumaRI += Math.sqrt(Math.abs(Math.exp(a * (double)l + b) - NA * rho));
                ++l;
            }
        }
        return sumaRI;
    }
}

