/*
 * Decompiled with CFR 0.152.
 */
package psf.richardswolf;

import bilib.commons.math.bessel.Bessel;

public class KirchhoffDiffractionSimpson {
    private double defocus = 1.0;
    private double ni = 1.5;
    private double TOL = 0.1;
    private int K;
    private double NA = 1.4;
    private double lambda = 610.0;

    public KirchhoffDiffractionSimpson(double defocus, double ni, int accuracy, double NA, double lambda) {
        this.NA = NA;
        this.lambda = lambda;
        this.ni = ni;
        this.defocus = defocus;
        this.K = accuracy == 0 ? 5 : (accuracy == 1 ? 7 : (accuracy == 2 ? 9 : 3));
    }

    double calculate(double r) {
        int n;
        double[][] value = new double[3][2];
        double[][] valuea = new double[3][2];
        double[][] valueb = new double[3][2];
        double[][] sumOddIndex = new double[3][2];
        double[][] sumEvenIndex = new double[3][2];
        double curI = 0.0;
        double prevI = 0.0;
        double a = 0.0;
        double b = Math.asin(this.NA / this.ni);
        int N = 2;
        double del = b / 2.0;
        int k = 0;
        int iteration = 1;
        double rho = b / 2.0;
        sumOddIndex = this.integrand(rho, r);
        int m = 0;
        while (m < 3) {
            n = 0;
            while (n < 2) {
                sumEvenIndex[m][n] = 0.0;
                ++n;
            }
            ++m;
        }
        valuea = this.integrand(a, r);
        valueb = this.integrand(b, r);
        double realSumI0 = valuea[0][0] + 2.0 * sumEvenIndex[0][0] + 4.0 * sumOddIndex[0][0] + valueb[0][0];
        double imagSumI0 = valuea[0][1] + 2.0 * sumEvenIndex[0][1] + 4.0 * sumOddIndex[0][1] + valueb[0][1];
        double realSumI1 = valuea[1][0] + 2.0 * sumEvenIndex[1][0] + 4.0 * sumOddIndex[1][0] + valueb[1][0];
        double imagSumI1 = valuea[1][1] + 2.0 * sumEvenIndex[1][1] + 4.0 * sumOddIndex[1][1] + valueb[1][1];
        double realSumI2 = valuea[2][0] + 2.0 * sumEvenIndex[2][0] + 4.0 * sumOddIndex[2][0] + valueb[2][0];
        double imagSumI2 = valuea[2][1] + 2.0 * sumEvenIndex[2][1] + 4.0 * sumOddIndex[2][1] + valueb[2][1];
        prevI = curI = (realSumI0 * realSumI0 + imagSumI0 * imagSumI0 + 2.0 * (realSumI1 * realSumI1 + imagSumI1 * imagSumI1) + realSumI2 * realSumI2 + imagSumI2 * imagSumI2) * del * del;
        double curDifference = this.TOL;
        while (k < this.K && iteration < 10000) {
            ++iteration;
            N *= 2;
            del /= 2.0;
            m = 0;
            while (m < 3) {
                n = 0;
                while (n < 2) {
                    double[] dArray = sumEvenIndex[m];
                    int n2 = n;
                    dArray[n2] = dArray[n2] + sumOddIndex[m][n];
                    sumOddIndex[m][n] = 0.0;
                    ++n;
                }
                ++m;
            }
            int n3 = 1;
            while (n3 < N) {
                rho = (double)n3 * del;
                value = this.integrand(rho, r);
                int mm = 0;
                while (mm < 3) {
                    int nn = 0;
                    while (nn < 2) {
                        double[] dArray = sumOddIndex[mm];
                        int n4 = nn;
                        dArray[n4] = dArray[n4] + value[mm][nn];
                        ++nn;
                    }
                    ++mm;
                }
                n3 += 2;
            }
            realSumI0 = valuea[0][0] + 2.0 * sumEvenIndex[0][0] + 4.0 * sumOddIndex[0][0] + valueb[0][0];
            imagSumI0 = valuea[0][1] + 2.0 * sumEvenIndex[0][1] + 4.0 * sumOddIndex[0][1] + valueb[0][1];
            realSumI1 = valuea[1][0] + 2.0 * sumEvenIndex[1][0] + 4.0 * sumOddIndex[1][0] + valueb[1][0];
            imagSumI1 = valuea[1][1] + 2.0 * sumEvenIndex[1][1] + 4.0 * sumOddIndex[1][1] + valueb[1][1];
            realSumI2 = valuea[2][0] + 2.0 * sumEvenIndex[2][0] + 4.0 * sumOddIndex[2][0] + valueb[2][0];
            imagSumI2 = valuea[2][1] + 2.0 * sumEvenIndex[2][1] + 4.0 * sumOddIndex[2][1] + valueb[2][1];
            curI = (realSumI0 * realSumI0 + imagSumI0 * imagSumI0 + 2.0 * (realSumI1 * realSumI1 + imagSumI1 * imagSumI1) + realSumI2 * realSumI2 + imagSumI2 * imagSumI2) * del * del;
            curDifference = prevI == 0.0 ? Math.abs((prevI - curI) / 1.0E-5) : Math.abs((prevI - curI) / curI);
            k = curDifference <= this.TOL ? ++k : 0;
            prevI = curI;
        }
        return curI;
    }

    double[][] integrand(double theta, double r) {
        double sinTheta = Math.sin(theta);
        double cosTheta = Math.cos(theta);
        double sqrtCosThetaSinTheta = Math.sqrt(cosTheta) * sinTheta;
        double k_tag = Math.PI * 2 * this.ni / this.lambda;
        double x = k_tag * sinTheta * r;
        double J0 = Bessel.J0(x);
        double J1 = Bessel.J1(x);
        double J2 = x == 0.0 ? 0.0 : 2.0 * J1 / x + J0;
        double B0 = sqrtCosThetaSinTheta * (1.0 + cosTheta) * J0;
        double B1 = sqrtCosThetaSinTheta * sinTheta * J1;
        double B2 = sqrtCosThetaSinTheta * (1.0 - cosTheta) * J2;
        double OPD = this.defocus * cosTheta;
        double W = k_tag * OPD;
        double cosW = Math.cos(W);
        double sinW = Math.sin(W);
        double[][] I = new double[3][2];
        I[0][0] = B0 * cosW;
        I[1][0] = B1 * cosW;
        I[2][0] = B2 * cosW;
        I[0][1] = B0 * sinW;
        I[1][1] = B1 * sinW;
        I[2][1] = B2 * sinW;
        return I;
    }
}

