/*
 * Decompiled with CFR 0.152.
 */
package bilib.commons.job.callable;

import bilib.commons.job.JobAbstract;
import bilib.commons.job.JobEvent;
import bilib.commons.job.MonitorAbstract;
import bilib.commons.job.PoolAbstract;
import java.util.ArrayList;
import java.util.concurrent.Callable;

public abstract class Job
implements JobAbstract,
MonitorAbstract,
Callable<Object> {
    public boolean live = false;
    public boolean done = false;
    public boolean idle = false;
    private double chrono = -1.0;
    private double timeoutns = -1.0;
    private boolean stopTimeOut = false;
    private ArrayList<MonitorAbstract> monitors = new ArrayList();
    public PoolAbstract pool;
    private String name;

    public abstract Object process() throws RuntimeException;

    public Job() {
    }

    public Job(MonitorAbstract monitor) {
        this.monitors.add(monitor);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public PoolAbstract getPool() {
        return this.pool;
    }

    @Override
    public void setPool(PoolAbstract pool) {
        this.pool = pool;
    }

    @Override
    public void setTimeOut(double timeoutms) {
        this.timeoutns = timeoutms * 1000000.0;
        this.stopTimeOut = true;
    }

    @Override
    public void abort() {
        this.idle = false;
        this.live = false;
        this.done = false;
        if (this.pool != null) {
            this.pool.fire(new JobEvent(this, JobEvent.ABORTED));
        }
    }

    @Override
    public void interrupt() {
        this.idle = false;
        this.live = false;
        this.done = false;
        if (this.pool != null) {
            this.pool.fire(new JobEvent(this, JobEvent.INTERRUPTED));
        }
    }

    @Override
    public void abort(String message) {
        this.idle = false;
        this.live = false;
        this.done = false;
        if (this.pool != null) {
            this.pool.fire(new JobEvent((JobAbstract)this, JobEvent.ABORTED, message));
        }
    }

    @Override
    public void interrupt(String message) {
        this.idle = false;
        this.live = false;
        this.done = false;
        if (this.pool != null) {
            this.pool.fire(new JobEvent((JobAbstract)this, JobEvent.INTERRUPTED, message));
        }
    }

    @Override
    public void init() {
        this.idle = true;
        this.live = true;
        this.done = false;
        this.chrono = System.nanoTime();
    }

    @Override
    public Object call() {
        Object o;
        block5: {
            o = null;
            if (this.pool != null) {
                this.pool.fire(new JobEvent(this, JobEvent.STARTED));
            }
            try {
                this.idle = false;
                o = this.process();
                if (this.live) {
                    this.done = true;
                    this.live = false;
                    if (this.pool != null) {
                        this.pool.fire(new JobEvent(this, JobEvent.COMPLETED));
                    }
                }
            }
            catch (RuntimeException ex) {
                if (this.pool == null) break block5;
                this.pool.fire(new JobEvent((JobAbstract)this, ex, ex.getMessage()));
            }
        }
        this.live = false;
        this.idle = true;
        return o;
    }

    @Override
    public boolean isNotTimeOut() {
        if (!this.live) {
            return false;
        }
        if (this.stopTimeOut && (double)System.nanoTime() - this.chrono > this.timeoutns) {
            if (this.pool != null) {
                this.pool.fire(new JobEvent(this, JobEvent.TIMEOUT));
            }
            this.live = false;
            this.done = false;
            return false;
        }
        return true;
    }

    @Override
    public boolean isJobLive() {
        return this.live;
    }

    @Override
    public boolean isJobDone() {
        return this.done;
    }

    @Override
    public boolean isJobIdle() {
        return this.idle;
    }

    @Override
    public boolean isJobProcessing() {
        return !this.idle;
    }

    @Override
    public boolean isJobIncomplete() {
        return !this.done;
    }

    @Override
    public String toString() {
        return "JobCallable: " + this.getName();
    }

    @Override
    public void rewind() {
        for (MonitorAbstract monitor : this.monitors) {
            monitor.rewind();
        }
    }

    @Override
    public void print(String message) {
        for (MonitorAbstract monitor : this.monitors) {
            monitor.print(message);
        }
    }

    @Override
    public void error(String message) {
        for (MonitorAbstract monitor : this.monitors) {
            monitor.error(message);
        }
    }

    @Override
    public void warning(String message) {
        for (MonitorAbstract monitor : this.monitors) {
            monitor.warning(message);
        }
    }

    @Override
    public void progress(double percentage) {
        for (MonitorAbstract monitor : this.monitors) {
            monitor.progress(percentage);
        }
    }

    @Override
    public void progress(double percentage, String message) {
        for (MonitorAbstract monitor : this.monitors) {
            monitor.progress(percentage, message);
        }
    }

    @Override
    public void increment(double percentageIncrement) {
        for (MonitorAbstract monitor : this.monitors) {
            monitor.increment(percentageIncrement);
        }
    }

    @Override
    public void increment(double percentageIncrement, String message) {
        for (MonitorAbstract monitor : this.monitors) {
            monitor.increment(percentageIncrement, message);
        }
    }

    @Override
    public void addMonitor(MonitorAbstract monitor) {
        this.monitors.add(monitor);
    }

    @Override
    public void removeMonitor(MonitorAbstract monitor) {
        this.monitors.remove(monitor);
    }

    @Override
    public void clearMonitor() {
        this.monitors.clear();
    }

    @Override
    public ArrayList<MonitorAbstract> getMonitor() {
        return this.monitors;
    }
}

