# -*- coding: utf-8 -*-
from defs import SUBTYPES_R101

TAULA_CATEGORIA_SUJETO = [
    ('COM', 'Comercializadora'),
    ('DIS', 'Distribuidor'),
    ('TRA', 'Transportista'),
    ('CLI', 'Cliente Cualificado'),
    ('GTS', 'Gestor Técnico del Sistema'),
    ('OCS', 'Oficina de Cambio de Suministrador (OCSUM)'),
    ('GRE', 'Grupo Empresarial'),
]
TAULA_SUJETO = [
    ('0001', 'GAS NATURAL COMERCIALIZADORA, S.A.'),
    ('0002', 'EDP COMERCIALIZADORA, S.A.U.'),
    ('0004', 'EDP ENERGÍA, S.A.U.'),
    ('0005', 'BP GAS EUROPE, S.A.U.'),
    ('0006', 'COMERCIALIZADORA IBÉRICA DE GAS Y ENERGÍA ELÉCTRICA, S.A.U.'),
    ('0007', 'ENDESA ENERGÍA, S.A.'),
    ('0008', 'SHELL ESPAÑA, S.A.'),
    ('0009', 'CEPSA GAS COMERCIALIZADORA, S.A.'),
    ('0010', 'UNIÓN FENOSA GAS COMERCIALIZADORA, S.A.'),
    ('0016', 'CARBOEX, S.A.U.'),
    ('0028', 'INGENIERÍA Y COMERCIALIZACIÓN DEL GAS, S.A.'),
    ('0032', 'GDF SUEZ ENERGÍA ESPAÑA, S.A.U.'),
    ('0033', 'GAS NATURAL SERVICIOS SDG, S.A.'),
    ('0035', 'NEXUS ENERGÍA, S.A.'),
    ('0037', 'SHELL SPAIN LNG, S.A.'),
    ('0038', 'ENÉRGYA VM GESTIÓN DE ENERGÍA, S.L.U.'),
    ('0039', 'MULTISERVICIOS TECNOLÓGICOS, S.A.'),
    ('0041', 'BAHÍA DE BIZKAIA ELECTRICIDAD, S.L.'),
    ('0042', 'MOLGAS ENERGÍA, S.A.U.'),
    ('0043', 'LIQUID NATURAL GAZ, S.L.'),
    ('0044', 'VIESGO ENERGÍA, S.L.'),
    ('0045', 'SONATRACH GAS COMERCIALIZADORA, S.A.U.'),
    ('0047', 'EDF TRADING LIMITED'),
    ('0048', 'GALP ENERGÍA ESPAÑA, S.A.U.'),
    ('0049', 'AXPO IBERIA, S.L.'),
    ('0051', 'SAMPOL INGENIERÍA Y OBRAS, S.A.'),
    ('0052', 'GAS NATURAL S.U.R., SDG, S.A.'),
    ('0053', 'IBERDROLA GENERACIÓN, S.A.U.'),
    ('0054', 'IBERDROLA C.U.R., S.A.U.'),
    ('0057', 'MADRILEÑA SUMINISTRO DE GAS, S.L.'),
    ('0058', 'MADRILEÑA SUMINISTRO DE GAS S.U.R., S.L.'),
    ('0059', 'ENDESA ENERGÍA XXI, S.L.U.'),
    ('0060', 'EDP C.U.R., S.A.'),
    ('0061', 'SERVIGAS S. XXI, S.A.'),
    ('0062', 'ENOI S.P.A.'),
    ('0063', 'VILLAR MIR ENERGÍA, S.L.U.'),
    ('0064', 'E.ON GLOBAL COMMODITIES S.E.'),
    ('0066', 'FERTIBERIA, S.A.'),
    ('0068', 'FORTIA ENERGÍA, S.L.'),
    ('0069', 'EDP ENERGÍA GAS, S.L.'),
    ('0072', 'GUNVOR INTERNATIONAL B.V.'),
    ('0073', 'ALPIQ ENERGÍA ESPAÑA, S.A.U.'),
    ('0074', 'CENTROGAS GMBH'),
    ('0075', 'ORUS ENERGÍA, S.L.'),
    ('0076', 'ON DEMAND FACILITIES, S.L.'),
    ('0077', 'PETRONAVARRA, S.L.'),
    ('0080', 'GASINDUR, S.L.'),
    ('0081', 'STATOIL ASA'),
    ('0082', 'FACTOR ENERGÍA, S.A.'),
    ('0084', 'SWITCH ENERGY, S.L.'),
    ('0085', 'SOLVAY ENERGY SERVICES'),
    ('0086', 'CAPITAL ENERGY READ, S.L.'),
    ('0087', 'METHANE LOGISTICS, S.L.'),
    ('0088', 'CEPSA COMERCIAL PETRÓLEO, S.A.U.'),
    ('0089', 'CLIDOM ENERGY, S.L.'),
    ('0090', 'PRIMAGAS ENERGÍA, S.A.U.'),
    ('0091', 'VITOGAS ESPAÑA, S.A.U.'),
    ('0093', 'ENI S.P.A.'),
    ('0094', 'NOBLE CLEAN FUELS LIMITED'),
    ('0098', 'GOLD ENERGY-COMERCIALIZADORA DE ENERGÍA, S.A.'),
    ('0099', 'REPSOL LNG HOLDING, S.A.'),
    ('0100', 'ALPIQ AG'),
    ('0201', 'GAS DE ASTURIAS, S.A.'),
    ('0202', 'GAS DE FIGUERES, S.A.'),
    ('0203', 'GAS DIRECTO, S.A.'),
    ('0204', 'DISTRIBUIDORA REGIONAL DEL GAS, S.A.'),
    ('0205', 'REDEXIS GAS DISTRIBUCIÓN, S.A.U.'),
    ('0206', 'GAS ALICANTE, S.A.U.'),
    ('0207', 'DC GAS EXTREMADURA, S.A.'),
    ('0208', 'REDEXIS GAS ARAGÓN, S.A.'),
    ('0209', 'REDEXIS GAS BALEARES, S.A.'),
    ('0210', 'GAS DE EUSKADI, S.A.'),
    ('0211', 'BILBOGAS, S.A.'),
    ('0212', 'GAS Natural de Álava, S.A.'),
    ('0213', 'DONOSTI GAS, S.A.'),
    ('0214', 'GAS HERNANI, S.A.'),
    ('0215', 'GAS PASAIA, S.A.'),
    ('0216', 'TOLOSA GASA, S.A.'),
    ('0218', 'GAS ANDALUCIA, S.A.'),
    ('0219', 'GAS ENERGÍA DISTRIBUCIÓN CANTABRIA, S.A.'),
    ('0220', 'GAS CATILLA-LA MANCHA, S.A.'),
    ('0221', 'GAS CASTILLA Y LEON, S.A.'),
    ('0222', 'GAS NATURAL CEGAS, S.A.'),
    ('0223', 'GAS LA CORUÑA, S.A.'),
    ('0224', 'GAS GALICIA, S.A.'),
    ('0225', 'GAS NATURAL CEGAS, S.A.'),
    ('0226', 'GAS NAVARRA, S.A.'),
    ('0227', 'GAS RIOJA, S.A.'),
    ('0228', 'Gas Mérida, S.A.'),
    ('0229', 'Naturgas Energía Distribución, S.A.U.'),
    ('0230', 'GAS NATURAL CATALUNYA SDG, S.A.'),
    ('0231', 'IBERDROLA DISTRIBUCIÓN DE GAS, S.A.U.'),
    ('0232', 'GASIFICADORA REGIONAL CANARIA, S.A.'),
    ('0233', 'DISTRIBUIDORA SUREUROPEA DE GAS, S.A.'),
    ('0234', 'MADRILEÑA RED DE GAS, S.A.U.'),
    ('0235', 'TRANSMANCHEGA DE GAS, S.A.U.'),
    ('0236', 'MADRILEÑA RED DE GAS II, S.A.U.'),
    ('0237', 'GAS NATURAL MADRID SDG, S.A.'),
    ('0238', 'REDEXIS GAS, S.A.'),
    ('0239', 'GAS NATURAL ARAGÓN SDG, S.A.'),
    ('0240', 'GAS NATURAL REDES DISTRIBUCIÓN GAS SDG, S.A.'),
    ('0241', 'GAS NATURAL BALEARES, S.A.'),
    ('0242', 'EDP ESPAÑA DISTRIBUCIÓN GAS, S.A.U.'),
    ('0101', 'ENAGAS S.A.'),
    ('0102', 'Gas Natural SDG, S.A.'),
    ('0103', 'Transportista Regional del Gas, S.L.'),
    ('0104', 'Naturgas Energía Transporte, S.A.U..'),
    ('0105', 'Infraestructuras Gasistas de Navarra, S.L.'),
    ('0106', 'BBG'),
    ('0108', 'Planta de Regasificación de Sagunto, S.A.'),
    ('0111', 'GAS NATURAL TRANSPORTE SDG, S.L.'),
    ('0500', 'OCSUM'),
    ('0500', 'GASELA GMBH'),
    ('0501', 'COMPAÑÍA ESPAÑOLA DE PETRÓLEOS, S.A.U.'),
    ('0503', 'AUDAX ENERGÍA, S.A.'),
    ('0504', 'SOLVAY ENERGY SERVICES IBÉRICA, S.L.'),
    ('0505', 'AXEGAZ, S.A.S.'),
    ('0506', 'NOVAGAS CRIOGENIA, S.L.'),
    ('0507', 'KOCH COMMODITIES EUROPE LIMITED'),
    ('0509', 'DUFENERGY TRADING, S.A.'),
    ('0510', 'NEXT-E-ADVANCED ENERGY SERVICES, S.L.U.'),
    ('0511', 'NOVA COMERCIALIZADORA DE GAS, S.L.'),
    ('0512', 'GAS NATURAL EUROPE, S.A.S.'),
    ('0513', 'GAS MARINE BUNKER, S.L.'),
    ('0514', 'NEOELECTRA ENERGÍA, S.L.U.'),
    ('0515', 'VITOL, S.A.'),
    ('0516', 'GALP GAS NATURAL, S.A.'),
    ('0517', 'ECONGAS GMBH'),
    ('0518', 'CATGAS ENERGÍA, S.A.'),
    ('0519', 'CEPSA GAS Y ELECTRICIDAD, S.A.U.'),
    ('0520', 'GDF SUEZ, S.A.'),
    ('0521', 'ENI TRADING & SHIPPING, S.P.A.'),
    ('0522', 'LEGAS IBERIA, S.L.'),
    ('0523', 'GDF SUEZ TRADING'),
    ('0524', 'EDP GÁS.COM-COMÉRCIO DE GÁS NATURAL, S.A.'),
    ('0525', 'TRAFIGURA NAT GAS LIMITED'),
    ('0526', 'INVESTMENT SYNERGY GROUP ESPAÑA. S.L.U.'),
    ('0527', 'FENIE ENERGÍA, S.A.'),
    ('0528', 'GDF SUEZ ENERGY MANAGEMENT TRADING S.C.R.L.'),
    ('0529', 'IBERDROLA CLIENTES, S.A.U.'),
    ('0530', 'IBERDROLA GENERACIÓN ESPAÑA, S.A.U.'),
    ('0531', 'MULTIENERGÍA VERDE, S.L.'),
    ('0532', 'PETRO MEETING POINT, S.L.'),
    ('0533', 'SHELL ENERGY EUROPE LIMITED'),
    ('0534', 'PRIMA LNG N.V.'),
    ('0536', 'REPSOL BUTANO, S.A.'),
    ('0537', 'ALDRO ENERGÍA Y SOLUCIONES, S.L.U.'),
    ('0539', 'OGS ENERGÍA, S.L.'),
    ('0540', 'TRAFIGURA PTE, LTD'),
    ('0541', 'GAZPROM MARKETING & TRADING LIMITED'),
    ('0542', 'MET INTERNACIONAL AG'),
    ('0543', 'EURO GAS HOLDING, A.S.'),
    ('0544', 'GNERA ENERGÍA Y TECNOLOGÍA, S.L.'),
    ('0545', 'REPSOL COMERCIAL DE PRODUCTOS PETROLÍFEROS, S.A.'),
    ('0546', 'REMICA COMERCIALIZADORA, S.A.'),
    ('0547', 'BIROU GAS, S.L.'),
    ('0548', 'TRAILSTONE GMBH'),
    ('0549', 'WORLDENERGY, S.A.'),
    ('0550', 'PETROBRAS GLOBAL TRADING, B.V.'),
    ('0551', 'YADE JORMAN ESPAÑA, S.L.'),
    ('0552', 'ENERGY STROM XXI, S.L.'),
    ('0553', 'EDISON S.P.A.'),
    ('0554', 'POWERBRIDGE RESOURCES GROUP LTD'),
    ('0555', 'FUSIONA SOLUCIONES ENERGÉTICAS, S.A.'),
    ('0556', 'CRINGAS, S.L.'),
    ('0557', 'MACQUAIRE BANK LIMITED, LONDON BRANCH'),
    ('0558', 'AGENTE DEL MERCADO ELÉCTRICO, S.A.'),
    ('0559', 'GOLDMAN SACHS INTERNATIONAL'),
    ('0560', 'BETA RENOWABLE GROUP, S.A.'),
    ('0561', 'NUEVA COMERCIALIZADORA ESPAÑOLA, S.L.'),
    ('0562', 'FUTURA ENERGIA Y GAS, S.L.'),
    ('0563', 'DANSKE COMMODITIES A/S'),
    ('0564', 'ARCELORMITTAL ENERGY, S.C.A'),
    ('0565', 'CENTRICA LNG COMPANY LIMITED'),
    ('0566', 'VITA CAPITAL TRADING, S.L.'),
    ('0567', 'ADS ENERGY 8.0, S.L.'),
    ('0568', 'INSERIMOS ENERGÍA, S.L.'),
    ('0569', 'NINOBE SERVICIOS ENERGÉTICOS, S.L.'),
    ('0570', 'IGNIS ENERGÍA, S.L.'),
    ('0571', 'ELYGAS POWER, S.L.'),
    ('0572', 'ENERXIA GALEGA MAIS, S.L.'),
    ('0573', 'INTEGRACIÓN EUROPEA DE ENERGÍA, S.A.U.'),
    ('0574', 'ROLEAR - AUTOMATIZAÇOES, ESTUDOS E REPRESENTAÇOES, S.A.'),
    ('0575', 'MERRILL LYNCH INTERNATIONAL'),
    ('0576', 'ENERKIA ENERGÍA, S.L.'),
    ('0577', 'ENDESA GENERACIÓN, S.A.'),
    ('0578', 'COMERCIALIZADORA GONZÁLEZ ENERGÍA, S.L.'),
    ('0579', 'INER ENERGIA CASTILLA-LA MANCHA, S.L.'),
    ('0580', 'SWAP ENERGÍA, S.A.'),
    ('0582', 'WATIO WHOLESALE, S.L.'),
    ('0584', 'LABOIL ENERGÍA, S.L.'),
    ('0585', 'AURA ENERGÍA, S.L.'),
    ('0586', 'ANOTHER ENERGY OPTION, S.L.'),
    ('0587', 'PASO HONROSO, S.L.'),
    ('0588', 'FLIP ENERGÍA, S.L.'),
    ('0589', 'ENERCOTEC SERVICIOS, S.L.'),
    ('0590', 'DEVAL PETROLEUM, S.L.'),
    ('0591', 'ITAL REFINING, S.L.'),
    ('0592', 'MERIDIUM PETROLEUM, S.L.'),
    ('0593', 'PROT ENERGÍA COMERCIALIZACIÓN, S.L.'),
    ('0594', 'ELEGRAND ENERGÍA, S.L.'),
    ('0595', 'FUSIONA COMERCIALIZADORA, S.A.'),
    ('0596', 'ADELFAS ENERGIA, S.L.'),
    ('0597', 'FORTULUZ, S.L.U.'),
    ('0598', 'CENTRICA ENERGY LIMITED'),
    ('0600', 'MET ENERGÍA ESPAÑA, S.A'),
    ('0601', 'ALCANZIA ENERGÍA, S.L.'),
    ('0602', 'NEAS ENERGY, A/S'),
    ('0603', 'ECO NUEVOS DESARROLLOS ENERGETICOS, S.L.'),
    ('0604', 'LEDESMA COMERCIALIZADORA ELÉCTRICA, S.L.'),
    ('0605', 'XENERA COMPAÑÍA ELÉCTRICA, S.A.'),
    ('0606', 'GEO ALTERNATIVA, S.L.'),
    ('0607', 'GLENCORE ENERGY UK LTD'),
    ('0608', 'ENERPLUS ENERGÍA, S.A.'),
    ('0609', 'WATIUM, S.L.'),
    ('0610', 'TRAFIGURA TRADING (EUROPE), SARL'),
    ('0611', 'ANOTHER ENERGY OPTION, S.L.'),
    ('0612', 'INSIGNIA GAS, S.L.'),
    ('0613', 'IBERELÉCTRICA COMERCIALIZADORA, S.L.'),
    ('0614', 'VIVE ENERGÍA ELÉCTRICA, S.A.'),
    ('0615', 'VIVA ENERGÍA Y SOLUCIONES, S.L.'),
    ('0616', 'CHCUATRO GAS COMERCIALIZADORA, S.L.'),
    ('0617', 'A-DOS ENERGÍA, S.L.'),
    ('0618', 'COX ENERGÍA COMERCIALIZADORA ESPAÑA, S.L.U.'),
    ('0619', 'PETRONIEVES ENERGÍA 1, S.L.'),
    ('0620', 'EMASP SERVICIOS DE VALOR AÑADIDO, S.L.'),
    ('0621', 'HORIZON GAS COMERCIALIZADORA, S.L.'),
    ('0622', 'AGUAS DE BARBASTRO ENERGIA, S.L.'),
    ('0623', 'POTENZIA COMERCIALIZADORA, S.L.'),
    ('0624', 'SUMINISTRO DE GAS Y LUZ EUROPA,S.L.'),
    ('0625', 'ANTEA ENERGÍA COMERCIALIZADORA, S.L.'),
    ('0626', 'NEXT-E-ADVANCED SERVICES,S.L'),
]
TAULA_PROCESO = [
    ('02', 'Solicitud de Cambio'),
    ('03', 'Solicitud de Anulación'),
    ('04', 'Solicitud de Baja'),
    ('05', 'Solicitud de Modificación'),
    ('08', 'Mediciones'),
    ('26', 'Comunicación Datos'),
    ('31', 'Facturación individual por CUPS'),
    ('32', 'Facturación agregada (datos por CUPS)'),
    ('33', 'Facturación agregada (datos por factura)'),
    ('36', 'Petición Datos CUPS Disponible On-Line'),
    ('37', 'Petición Datos CUPS Disponible'),
    ('38', 'Puesta en Servicio Nuevos Suministros'),
    ('41', 'Cambio de Comercializador con Modificación de Datos'),
    ('44', 'Actuaciones domiciliarias'),
    ('45', 'Comunicación operaciones iniciativa distribuidor'),
    ('46', 'Anulación de actuaciones domiciliarias'),
    ('48', 'Reclamaciones'),
]
TAULA_RESULTADO = [
    ('01', 'Aceptada'),
    ('05', 'Rechazada'),
    ('09', 'Realizada'),
    ('13', 'No Realizada'),
]
TAULA_MOTIVO = [
    ('A01', 'No se ha podido realizar la Baja', '05', '02', '02'),
    ('A03', 'INCIDENCIA, existe un error temporal en la base de datos. Por favor, para tramitar esta puesta en servicio deben enviar una solicitud de cambio de suministrador incorporando el teléfono en el campo <extrainfo>', '01', '02'),
    ('A04', 'Existe ya trabajo de cese en campo', '05', '02', '02'),
    ('A05', 'No existe contrato de ATR en vigor', '05', '02', '02'),
    ('A06', 'Solicitud de Puesta en Servicio de NNSS con visita concertada', '05', '02', '02'),
    ('A07', 'El CUPS no está conectado al distribuidor que se indica en la solicitud', '05', '02', '02'),
    ('A09', 'SOLICITUD DUPLICADA CON RESULTADO RECHAZADA', '05', '02', '02'),
    ('A10', 'SOLICITUD DUPLICADA CON DATOS IDENTIFICATIVOS DISTINTOS', '05', '02', '02'),
    ('A11', 'DATOS INCOHERENTES EN SISTEMA', '05', '02', '02'),
    ('A12', 'SITUACIÓN CONTADOR INCORRECTA', '05', '02', '02'),
    ('A13', 'FALTA INFRAESTRUCTURA', '05', '02', '02'),
    ('A14', 'TIPO DOCUMENTO INCORRECTO ', '05', '02', '02'),
    ('A15', 'EMPRESA EMISORA INEXISTENTE', '05', '02', '02'),
    ('A16', 'SOICITUD DUPLICADA CON DATOS DISTINTOS', '05', '02', '02'),
    ('A17', 'MOTIVO BAJA INCORRECTO', '05', '02', '02'),
    ('A18', 'MODELO FECHA EFECTO INCORRECTO', '05', '02', '02'),
    ('A19', 'MODELO FECHA EFECTO SIN INFORMAR', '05', '02', '02'),
    ('A20', 'DURACIÓN CONTRATO INCORRECTA ', '05', '02', '02'),
    ('A21', 'DURACIÓN CONTRATO SIN INFORMAR', '05', '02', '02'),
    ('A22', 'QA-EST SIN INFORMAR', '05', '02', '02'),
    ('A23', 'NI DNI NI PASSPORTE', '05', '02', '02'),
    ('A24', 'SIN TIP-DOC-IDENT', '05', '02', '02'),
    ('A25', 'SIN NUMERO SOLICITUD', '05', '02', '02'),
    ('A26', 'TELEMEDIDA (S/N)', '05', '02', '02'),
    ('A27', 'SIN CONFORMIDAD CLIENTE', '05', '02', '02'),
    ('A28', 'CONFORMIDAD CLIENTE INCORRECTA', '05', '02', '02'),
    ('A29', 'Código Postal Incorrecto o Inexistente', '05', '02', '02'),
    ('A30', 'Municipio Incorrecto o Inexistente', '05', '02', '02'),
    ('A31', 'Provincia Incorrecto o Inexistente', '05', '02', '02'),
    ('A32', 'Finca Incorrecto o Inexistente', '05', '02', '02'),
    ('A33', 'Calle Incorrecto o Inexistente', '05', '02', '02'),
    ('A34', 'SIN APELLIDO 1', '05', '02', '02'),
    ('A35', 'FORMATO HORA SOLICITUD NO NUMERICO', '05', '02', '02'),
    ('A36', 'FORMATO HORA SOLICITUD INCORRECTA (0-23)', '05', '02', '02'),
    ('A37', 'FORMATO MINUTO SOLICITUD INCORRECTO (0-59)', '05', '02', '02'),
    ('A38', 'FORMATO SEGUNDO SOLICITUD INCORRECTO (0-59)', '05', '02', '02'),
    ('A39', 'FECHA SOLICITUD ANTERIOR A ULTIMA LECTURA', '05', '02', '02'),
    ('A40', 'FORMATO FECHA SOLICITUD INCORRECTA', '05', '02', '02'),
    ('A41', 'COMERCIALIZADORA ACTUAL NO DEFINIDA', '05', '02', '02'),
    ('A42', 'COMERCIALIZADORA ACTUAL NO DEFINIDA', '05', '02', '02'),
    ('A43', 'NUEVA COMERCIALIZADORA NO DEFINIDA', '05', '02', '02'),
    ('A44', 'NUEVA COMERCIALIZADORA NO DEFINIDA', '05', '02', '02'),
    ('A45', 'NUEVA COMERCIALIZADORA SIN INFORMAR', '05', '02', '02'),
    ('A46', 'TIPO MENSAJE INCORRECTO', '05', '02', '02'),
    ('A47', 'TIPO MENSAJE SIN INFORMAR', '05', '02', '02'),
    ('A48', 'VERSION SIN INFORMAR', '05', '02', '02'),
    ('A49', 'EMPRESA DISTRIBUIDORA NO DEFINIDA', '05', '02', '02'),
    ('A50', 'EMPRESA DISTRIBUIDORA SIN INFORMAR', '05', '02', '02'),
    ('A51', 'TIPO SOLICITUD NO DEFINIDO', '05', '02', '02'),
    ('A52', 'TIPO SOLICITUD NO ES ALTA/BAJA/CAMBIO (01/02/04)', '05', '02', '02'),
    ('A53', 'CODIGO SOLICITUD SIN INFORMAR', '05', '02', '02'),
    ('A54', 'EMPRESA DISTRIBUIDORA FORMATO INCORRECTO (N4)', '05', '02', '02'),
    ('A55', 'Otros Motivos', '05', '02', '02'),
    ('A56', 'Otros Motivos', '05', '02', '02'),
    ('A57', 'Otros Motivos', '05', '02', '02'),
    ('A58', 'EXISTE SOLICITUD NNSS PREVIA SIN FINALIZAR', '05', '02', '02'),
    ('A59', 'TIPO DOCUMENTO INEXISTENTE ', '05', '02', '02'),
    ('A60', 'Otros Motivos', '05', '02', '02'),
    ('A61', 'FECHA EFECTO SOLICITADA (MODELO 03) CON FORMATO INCORRECTO O NO INFORMADA', '05', '02', '02'),
    ('A62', 'FECHA EFECTO SOLICITADA ANTERIOR A DIA ACTUAL', '05', '02', '02'),
    ('A63', 'COMERCIALIZADORA SOLICITADA PARA LA BAJA NO ES LA ACTUAL DEL CLIENTE', '05', '02', '02'),
    ('A64', 'SOBRE SOLICITUD EXISTENTE, DATOS RECIBIDOS DISTINTOS A LOS ORIGINALES', '05', '02', '02'),
    ('A65', 'COMERCIALIZADORA ACTUAL INACTIVA', '05', '02', '02'),
    ('A66', 'NUEVA COMERCIALIZADORA INACTIVA', '05', '02', '02'),
    ('A67', 'CLIENTE YA LIBERALIZADO', '05', '02', '02'),
    ('A68', 'CLIENTE EN REGULADO', '05', '02', '02'),
    ('A69', 'FECHA BAJA SOLITIADA ANTERIOR A MIGRACIÓN', '05', '02', '02'),
    ('A70', 'CAMBIO DESDE GNS CON NIF B79263893', '05', '02', '02'),
    ('A71', 'Otros Motivos', '05', '02', '02'),
    ('A72', 'EXISTE SOLICITUD DE ALTA PREVIA SIN FINALIZAR', '05', '02', '02'),
    ('A73', 'EXISTE SOLICITUD DE ALTA PREVIA SIN FINALIZAR EN ANULACIÓN', '05', '02', '02'),
    ('A74', 'EXISTE SOLICITUD DE CAMBIO PREVIA SIN FINALIZAR', '05', '02', '02'),
    ('A75', 'EXISTE SOLICITUD DE CAMBIO PREVIA SIN FINALIZAR EN ANULACIÓN', '05', '02', '02'),
    ('A76', 'EXISTE SOLICITUD DE ANULACIÓN PREVIA SIN FINALIZAR', '05', '02', '02'),
    ('A77', 'EXISTE SOLICITUD DE ANULACIÓN PREVIA SIN FINALIZAR EN ANULACIÓN', '05', '02', '02'),
    ('A78', 'EXISTE SOLICITUD DE BAJA PREVIA SIN FINALIZAR', '05', '02', '02'),
    ('A79', 'EXISTE SOLICITUD DE BAJA PREVIA SIN FINALIZAR EN ANULACIÓN', '05', '02', '02'),
    ('A80', 'EXISTE SOLICITUD DE MODIFICACIÓN PREVIA SIN FINALIZAR', '05', '02', '02'),
    ('A81', 'EXISTE SOLICITUD DE MODIFICACIÓN PREVIA SIN FINALIZAR EN ANULACIÓN', '05', '02', '02'),
    ('A84', 'CONTRATO ATR NO INFORMADO PARA EL TIPO ANULACIÓN SOLICITADO', '05', '02', '02'),
    ('A85', '05', '02', '02'),
    ('A87', 'Otros Motivos', '05', '02', '02'),
    ('A88', 'NUEVO TLFNO ', '05', '02', '02'),
    ('A89', 'NUEVO FAX ', '05', '02', '02'),
    ('A90', 'NOMBRE CLIENTE OBLIGATORIO PARA TIPO DOCUMENTO INFORMADO', '05', '02', '02'),
    ('A91', 'CLIENTE NO LIBERALIZADO', '05', '02', '02'),
    ('A92', 'COMERCIALIZADORA NO ES LA QUE HA INICIADO SOLICITUD', '05', '02', '02'),
    ('A93', 'MOTIVO MODIFICACION NO CONTEMPLADO ', '05', '02', '02'),
    ('A94', 'NUEVO TIPO DOCUMENTO INCORRECTO', '05', '02', '02'),
    ('A95', 'MODIFICACIÓN DE TIPO \'01\'/\'04\', NO SE HAN INFORMADO LOS NUEVOS DATOS A MODIFICAR', '05', '02', '02'),
    ('A96', '05', '02', '02'),
    ('A97', 'A, NUEVO DOCUMENTO SIN INFORMAR', '05', '02', '02'),
    ('A98', ', NUEVO DOCUMENTO IGUAL AL ACTUAL', '05', '02', '02'),
    ('A99', 'NUEVO NOMBRE CLIENTE OBLIGATORIO PARA CAMBIO TITULAR', '05', '02', '02'),
    ('B01', ', EN CAMBIO TITULAR ', '05', '02', '02'),
    ('B02', 'NUEVA TARIFA INCORRECTA (3.1, 3.2, 3.3, 3.4)', '05', '02', '02'),
    ('B03', 'IMPOSIBLE CAMBIO DE USOS Y TARIFA', '05', '02', '02'),
    ('B04', 'Existe solicitud pendiente del mismo tipo en el punto de suministro', '05', '02', '01'),
    ('B05', 'Existe trabajo pendiente incompatible con la operación solicitada', '05', '02', '01'),
    ('B06', 'Existe trabajo pendiente del mismo tipo en el punto de suministro', '05', '02', '01'),
    ('B07', 'Existe solicitud pendiente incompatible en el punto de suministro', '05', '02', '01'),
    ('B08', 'Se ha recibido solicitud de cambio para el mismo CUPS', '05', '02', '01'),
    ('B09', 'Operación pendiente concertada', '05', '02', '01'),
    ('B10', 'Excedido tiempo máximo de la solicitud.', '13', '02', '01'),
    ('B11', 'Anulada por nueva petición de Comercializadora', '05', '02', '01'),
    ('B12', 'Anulada a petición de Comercializadora', '05', '02', '01'),
    ('B13', 'Se ha recibido solicitud de cese para el mismo CUPS', '05', '02', '01'),
    ('B14', 'El cliente está cesado/cerrado', '05', '02', '01'),
    ('B15', 'Situación del cliente incoherente con operación', '05', '02', '01'),
    ('B16', 'Contador inexistente', '05', '02', '01'),
    ('B17', 'Contador incoherente', '05', '02', '01'),
    ('B19', 'Punto de suministro con ubicación incoherente', '05', '02', '01'),
    ('B20', 'Rechazo operación suspensión de suministro por contador no accesible', '05', '02', '01'),
    ('B23', 'No existe solicitud previa o conversación incoherente.', '05', '02', '01'),
    ('B24', 'No existe solicitud pendiente para esta anulación', '05', '02', '01'),
    ('B25', 'TIPO USO GAS no es un valor permitido', '05', '02', '02'),
    ('B26', 'En un contrato a corto plazo, la telemedida debe estar operativa', '05', '02', '02'),
    ('B27', 'Si cambio duración de contrato de Corto Plazo ( CP) a NO CP, el Peaje solicitado debe ser idéntico al previo de CP si no ha transcurrido un año de vigencia de este último.', '05', '02', '02'),
    ('B28', 'La Qd solicitada no puede ser inferior a 1Kwh', '05', '02', '02'),
    ('B29', 'En ampliación de Qd la suma del nuevo Qd solicitado para un Contrato ATR y del resto de Qd de otros Contratos ATR del mismo Punto de Suministro dividido entre 24 debe ser menor o igual al valor de Qh', '05', '02', '02'),
    ('B30', 'En disminución de Qd el valor debe ser coherente con el peaje contratado. ', '05', '02', '02'),
    ('B31', 'Proceso no definido o no válido', '05', '02', '02'),
    ('B32', 'Tipo mensaje no coherente con el proceso', '05', '02', '02'),
    ('B33', 'No se permite cambio peaje para un Contrato ATR con origen en una transformación y que además no se ha emitido la primera factura de consumo de gas natural. ', '05', '02', '02'),
    ('B34', 'Si ', '05', '02', '02'),
    ('B35', 'El CUPS da servicio a varias fincas y una de ellas es póliza térmica.', '05', '02', '02'),
    ('B36', 'Motivo anulación no es válido', '05', '02', '02'),
    ('B37', 'En contratos a Corto Plazo, la presión debe ser superior a 4bar', '05', '02', '02'),
    ('B39', 'Para esta tipología es necesario informar una Operación', '05', '02', '01'),
    ('B40', 'El Número de Operación informado no se corresponde con un valor válido', '05', '02', '01'),
    ('B41', 'El Código de Solicitud ya ha sido recibido con anterioridad', '05', '02', '01'),
    ('B42', 'Tipo Solicitante/Reclamante no informado o informado con valor no válido', '05', '02', '01'),
    ('B43', 'Es obligatorio indicar una Descripción', '05', '02', '01'),
    ('B44', 'Es obligatorio informar el teléfono', '05', '02', '01'),
    ('B45', 'El Municipio informado no está asociado a la Provincia', '05', '02', '01'),
    ('B46', 'El Código Postal no está asociado al Municipio', '05', '02', '01'),
    ('B47', 'El Tipo de Reclamación/Actuación/Información no informado o informado con valor no válido', '05', '02', '01'),
    ('B48', 'Si aparece un importe reclamado Banco, Sucursal, DC y Cuenta deben estar vacíos', '05', '02', '01'),
    ('B49', 'El DC informado no es coherente con Banco, Sucursal y Cuenta', '05', '02', '01'),
    ('B50', 'Para esta Reclamación es necesario informar Número de Factura, Fecha Contable e Importe de Factura', '05', '02', '01'),
    ('B51', 'El Número de Factura recibido no es coherente', '05', '02', '01'),
    ('B52', 'El Motivo de Información no informado o informado con valor no válido', '05', '02', '01'),
    ('B53', 'Es necesario informar un CUPS o una Localización', '05', '02', '01'),
    ('B54', 'El Tipo de Localización no informado o informado con valor no válido', '05', '02', '01'),
    ('B55', 'Para el tipo de Actuación/Reclamación recibido es obligatorio informar las lecturas', '05', '02', '01'),
    ('B56', 'La Fecha de Lectura no puede ser futura', '05', '02', '01'),
    ('B57', 'Estructura de Medida no coherente', '05', '02', '01'),
    ('B58', 'El Número de Serie del Contador no es válido para el CUPS', '05', '02', '01'),
    ('B59', 'Es necesario informar un y solo un CUPS si ', '05', '02', '01'),
    ('B60', 'Error de formato', '05', '02', '01'),
    ('B61', 'Tipo persona no es uno de los valores tipificados', '05', '02', '01'),
    ('B62', 'Tarifa/peaje no es uno de los valores tipificados', '05', '02', '01'),
    ('B63', 'Transformación de aparatos no es uno de los valores tipificados', '05', '02', '01'),
    ('B64', 'El número de conceptos informados en la operación no se corresponde con el disponible en el listado de conceptos', '05', '02', '01'),
    ('B65', 'Concepto de Facturación no existente', '05', '02'),
    ('B66', 'Potencia nominal incoherente para peaje solicitado.', '05', '02', '01'),
    ('B67', 'NN.SS: El tipo de gas no se corresponde con gas natural', '05', '02', '01'),
    ('B68', 'Cambio Titular: El país de expedición del tipo de documento no está incluido en el espacio Schengen', '05', '02', '01'),
    ('B69', 'FECHA CONFORMIDAD OBLIGATORIA SI CONFORMIDAD CLIENTE = \'S\'', '05', '02'),
    ('B70', 'FECHA CONFORMIDAD FORMATO INCORRECTO', '05', '02'),
    ('B71', 'USO VIVIENDA OBLIGATORIA PARA PERSONAS FÍSICAS', '05', '02'),
    ('B72', 'USO VIVIENDA VALOR INCORRECTO', '05', '02'),
    ('B73', 'NO SE HA INFORMADO CORRECTAMENTE LA NUEVA DIRECCIÓN DEL TITULAR', '05', '02'),
    ('B74', 'SELECCIÓN CON MÁS DE 300 CALLES, MEJORE CONSULTA', '05', '02'),
    ('B75', 'INFORMACION OBLIGATORIA', '05', '02'),
    ('B76', 'NO EXISTEN REGISTROS SEGUN SELECCIÓN', '05', '02'),
    ('B77', 'COD.NORMALIZACION POBLACION, PROV.Y MPIO.CORRESP.INCORRECTOS', '05', '02'),
    ('B78', 'TIPO VIA, COD.NORMALIZACION VIA O NOM.CALLE CORRESP. INCORRECTOS', '05', '02'),
    ('B79', 'No se ha podido procesar la lectura facilitada.', '05', '02', '01'),
    ('B7A', 'No se puede enviar una factura Anuladora (A): Ya existe una factura Anuladora para el Nº de factura de origen "@replace1@"', '05', '01', '01'),
    ('B7B', 'No se puede enviar una factura Anuladora con Sustituyente (B): ', '05', '01', '01'),
    ('B7R', 'No se puede enviar una factura Rectificadora (R): Ya existe una factura Anuladora para el Nº de factura de origen "@replace1@"', '05', '01', '01'),
    ('B80', 'Fecha de cambio solicitada no valida', '05', '02', '01'),
    ('B84', 'La situación del suministro no permite la ejecución de la solicitud realizada', '05', '02'),
    ('B85', 'No se cumple el ratio entre la nueva Qd y la Qh histórica: Qd / Qh <= 24', '05', '02', '01'),
    ('B86', 'Si el modelo fecha efecto es "04" debe introducir una fecha en el campo Fecha Efecto Solicitada', '05', '02', '01'),
    ('B87', 'Es obligatorio informar el nuevo teléfono', '05', '02', '01'),
    ('B88', 'NO SE HA INFORMADO CORRECTAMENTE LA DIRECCION DEL TITULAR', '05', '02', '01'),
    ('B90', 'Si se envía el concepto de Inspección Periódica @replace1@, debe enviarse obligatoriamente el campo SaldoTotalACobrar y con valor distinto a importetotal', '05', '02', '01'),
    ('B91', 'No se puede realizar el CC por concurrencias con una Baja o Corte por Impago', '13', '02', '01'),
    ('B92', 'No se puede atender la solicitud debido a que el suministro es esencial o no cortable', '05', '02', '01'),
    ('E00', 'No se pueden tramitar solicitudes por migración de datos.', '05', '01', '-'),
    ('E01', 'La solicitud refiere a un CUPS que no está conectado a este sistema.', '05', '01', '-'),
    ('G01', 'El modelo fecha efecto "@replace1@" no es válido.', '05', '02', '02'),
    ('G02', 'El nº de documento "@replace1@" no coincide con el del Contrato ATR en vigor', '05', '02', '02'),
    ('G03', 'El sujeto (código) "@replace1@" no es una comercializadora o Cliente Cualificado.', '05', '02', '02'),
    ('G04', 'El cliente con número de documento "@replace1@" no tiene contrato vigente con el cups "@replace2@" en la fecha efecto indicada', '05', '02', '02'),
    ('R01', 'Cliente suministrado desde planta satélite.', '05', '02', '01'),
    ('R03', 'El CUPS no está conectado al distribuidor que se indica en la solicitud.', '05', '02', '01'),
    ('R04', 'Falta infraestructura.', '05', '02', '01'),
    ('R07', 'Si el modelo fecha efecto que solicita es "03" o “04”debe cumplimentar el campo "Fecha efecto solicitada".', '05', '02', '01'),
    ('R08', 'La fecha de efecto solicitada "@replace1@" no puede ser mayor que la fecha "@replace2@".', '05', '02', '01'),
    ('R11', 'El municipio ', '05', '02', '01'),
    ('R12', 'Error de integridad: DNI no coherente con CUPS. ', '05', '02', '01'),
    ('R14', 'El día de la fecha efecto solicitada es errónea, tiene que ser el 1, 11 ó 21 del mes. ', '05', '02', '01'),
    ('R19', 'Si el motivo de modificación es @replace1@, los campos @replace2@ tienen que ser distintos.', '05', '02', '01'),
    ('R24', 'El nuevo peaje no puede coincidir con el peaje actual del contrato.', '05', '02', '01'),
    ('R26', 'Nuevo Caudal Diario no puede coincidir con el Caudal Diario Actual del contrato.', '05', '02', '01'),
    ('R29', 'CUPS inexistente.', '05', '02', '01'),
    ('R32', 'Fecha efecto solicitada anterior al día actual.', '05', '02', '01'),
    ('R34', 'No existe contrato de ATR en vigor.', '05', '02', '01'),
    ('R35', 'Existe una solicitud previa del tipo nuevo suministro del mismo comercializador.', '05', '02', '02'),
    ('R36', 'Existe una solicitud previa del tipo baja del mismo comercializador.', '05', '02', '02'),
    ('R37', 'Existe una solicitud previa de tipo cambio del mismo comercializador.', '05', '02', '02'),
    ('R38', 'Existe una solicitud previa de tipo modificación del mismo comercializador.', '05', '02', '02'),
    ('R39', 'Existe una solicitud previa de tipo anulación del mismo comercializador.', '05', '02', '02'),
    ('R40', 'El comercializador no es la empresa titular del contrato ATR en vigor.', '05', '02', '01'),
    ('R41', 'No existe una solicitud previa del comercializador de la misma tipología que solicita la Anulación.', '05', '02', '01'),
    ('R42', 'La solicitud que se intenta anular ya está "en trámite" o formalizada.', '05', '02', '01'),
    ('R43', 'El CUPS ya está activo con la comercializadora solicitante.', '05', '02', '01'),
    ('R44', 'Existe una solicitud previa del tipo alta de otra Comercializadora. ', '05', '02', '01'),
    ('R45', 'Existe una solicitud previa de baja de otra comercializadora.', '05', '02', '01'),
    ('R46', 'Existe una solicitud previa de cambio de otra comercializadora.', '05', '02', '01'),
    ('R47', 'Existe una solicitud previa de de otra comercializadora.', '05', '02', '01'),
    ('R48', 'Existe una solicitud previa de de otra comercializadora.', '05', '02', '01'),
    ('R49', 'Suministro a Presión superior a 16 bares. Debe presentarse la solicitud a través del transportista.', '05', '02', '01'),
    ('R51', 'CUPS en servicio con otra comercializadora.', '05', '02', '01'),
    ('R61', 'Si el motivo de modificación es @replace1@, se debe enviar alguno de los campos @replace2@.', '05', '02', '01'),
    ('R62', 'Si la presión solicitada es mayor de 4 bares o el peaje es 3.5, 2.2bis o 2.3 bis es obligatorio que el campo Caudal Diario tenga un valor', '05', '02', '01'),
    ('R64', 'El número de documento informado no cumple con las validaciones definidas para los documentos del tipo enviado', '05', '02', '01'),
    ('R72', 'CUPS inexistente.', '05', '02', '02'),
    ('R75', 'No se puede suspender el suministro Pobreza energética', '13', '02', '01'),
    ('R99', 'Rechazo de solicitudes por corte de operaciones', '05', '01', '01'),
    ('S01', 'No existe SSPP destino para una solicitud enviada al sujeto @replace1@ con el CUPS @replace2@', '05', '02', '02'),
    ('S02', 'El usuario @replace1@ no pertenece al sujeto emisor @replace2@', '05', '01', '02'),
    ('S03', 'La solicitud @replace1@ que se intenta informar ha sido anulada.', '05', '01', '02'),
    ('S05', 'Es obligatorio informar el campo "@replace1@" o el campo "@replace2@".', '05', '01', '02'),
    ('S06', 'No se puede informar el mensaje "@replace1@" si la solicitud no dispone de un mensaje de tipo "@replace2@".', '05', '01', '02'),
    ('S07', 'No se puede informar el mensaje "@replace1@" si la solicitud ya dispone de un mensaje de tipo "@replace2@".', '05', '01', '02'),
    ('S08', 'La solicitud @replace1@ ya dispone de un mensaje de tipo @replace2@', '05', '01', '02'),
    ('S09', 'El campo "@replace1@" no se debe informar si el campo "@replace2@" tiene valor "@replace3@".', '05', '01', '02'),
    ('S10', 'Disponible (+CUPS)', '01', '02'),
    ('S11', 'CUPS en servicio ', '01', '02'),
    ('S12', 'Solicitud en curso', '01', '02'),
    ('S13', 'No existe ruta de lectura', '01', '02'),
    ('S14', 'Falta infraestructura', '01', '02'),
    ('S15', 'Falta infraestructura', '01', '02'),
    ('S16', 'Propiedad IRG no informada (Acometida)', '01', '02'),
    ('S17', 'Fecha conexión Acometida no informada', '01', '02'),
    ('S18', 'Situación Finca incoherente', '01', '02'),
    ('S19', 'Documentación IRG incompleta (Acometida)', '01', '02'),
    ('S20', 'Operación pendiente incompatible con la operación de conexión de contador', '01', '02'),
    ('S21', 'Finca pendiente de transformación a Gas Natural', '01', '02'),
    ('S22', 'En Finca falta Distrito Municipal o Centro de Producción', '01', '02'),
    ('S23', 'Algún campo obligatorio del mensaje B20 no informado', '05', '02', '02'),
    ('S24', 'Provincia incorrecta o inexistente', '05', '01', '02'),
    ('S25', 'Municipio incorrecto o inexistente', '05', '01', '02'),
    ('S26', 'Código Postal incorrecto o inexistente', '05', '02', '02'),
    ('S27', 'Nombre de vía incorrecto o inexistente', '05', '02', '02'),
    ('S28', 'Número de vía incorrecto o inexistente', '05', '02', '02'),
    ('S29', 'Portal incorrecto o inexistente', '05', '02', '02'),
    ('S30', 'Escalera incorrecta o inexistente', '05', '02', '02'),
    ('S31', 'Piso incorrecto o inexistente', '05', '02', '02'),
    ('S32', 'Puerta incorrecta o inexistente', '05', '02', '02'),
    ('S33', 'El proceso "@replace1@" no es válido para la consulta de disponibilidad de Punto de Suministro por fichero', '05', '01', '02'),
    ('S35', 'No existe Sistema Propio destino de las Peticiones de Datos de CUPS disponibles', '05', '01', '02'),
    ('S36', 'El número de conceptos informados en la petición "@replace1@" de Datos de CUPS Disponible no se corresponde con el disponible en el listado de conceptos', '05', '01', '02'),
    ('S37', 'La empresa emisora "@replace1@" no corresponde con la solicitud "@replace2@" enviada en el mensaje B20', '05', '01', '02'),
    ('S38', 'La empresa destino "@replace1@" no corresponde con la solicitud "@replace2@" enviada en el mensaje B20', '05', '01', '02'),
    ('S40', 'Algún campo obligatorio de la solicitud no se ha informado', '05', '01', '02'),
    ('S41', 'Tipo persona no es uno de los valores tipificados', '05', '01', '02'),
    ('S42', 'Tipo de documento no es uno de los valores tipificados', '05', '01', '02'),
    ('S43', 'Nacionalidad no es uno de los valores tipificados', '05', '01', '02'),
    ('S44', 'Idioma no es uno de los valores tipificados', '05', '01', '02'),
    ('S45', 'Usos gas no es uno de los valores tipificados', '05', '01', '02'),
    ('S46', 'Tarifa/peaje no es uno de los valores tipificados', '05', '01', '02'),
    ('S47', 'Transformación de aparatos no es uno de los valores tipificados', '05', '01', '02'),
    ('S48', 'Propiedad del contador no es uno de los valores tipificados', '05', '01', '02'),
    ('S49', 'CUPS no corresponde a dirección', '05', '01', '02'),
    ('S50', 'El número de documento informado no cumple con las validaciones definidas para los documentos de tipo @replace1@', '05', '01', '02'),
    ('S51', 'Provincia incorrecta o inexistente', '05', '01', '02'),
    ('S52', 'Municipio incorrecto o inexistente', '05', '01', '02'),
    ('S53', 'Nombre de vía incorrecto o inexistente', '05', '01', '02'),
    ('S54', 'Número de vía incorrecto o inexistente', '05', '01', '02'),
    ('S55', 'Portal incorrecto o inexistente', '05', '01', '02'),
    ('S56', 'Escalera incorrecta o inexistente', '05', '01', '02'),
    ('S57', 'Piso incorrecto o inexistente', '05', '01', '02'),
    ('S58', 'Puerta incorrecta o inexistente', '05', '01', '02'),
    ('S59', 'CUPS en servicio / CUPS liberalizado', '05', '01', '02'),
    ('S61', 'No existe ruta de lectura', '05', '01', '02'),
    ('S62', 'Punto sin Acometida', '05', '01', '02'),
    ('S63', 'Situación de Acometida incoherente', '05', '01', '02'),
    ('S64', 'Propiedad IRG no informada (Acometida)', '05', '01', '02'),
    ('S65', 'Fecha conexión Acometida no informada', '05', '01', '02'),
    ('S66', 'Situación Finca incoherente', '05', '01', '02'),
    ('S67', 'Documentación IRG incompleta (Acometida)', '05', '01', '02'),
    ('S68', 'Operación pendiente incompatible con la operación de conexión de contador', '05', '01', '02'),
    ('S69', 'Finca pendiente de transformación a Gas Natural', '05', '01', '02'),
    ('S70', 'En Finca falta Distrito Municipal o Centro de Producción', '05', '01', '02'),
    ('S73', 'Existe una solicitud previa de puesta en servicio para el CUPS "@replace1@"', '05', '01', '02'),
    ('S74', 'Existe una solicitud previa de puesta en servicio para el CUPS "@replace1@" de otra Comercializadora.', '05', '01', '02'),
    ('S75', 'El número de conceptos informados en la solicitud "@replace1@" de Nuevos Suministros no se corresponde con el disponible en el listado de conceptos', '05', '01', '02'),
    ('S76', 'El campo "@replace1@" es obligatorio para el sujeto comercializador ', '05', '01', '02'),
    ('S80', 'El motivo de @replace1@ "@replace2@" no se encuentra vigente.', '05', '01', '02'),
    ('S81', 'El campo "@replace1@" es obligatorio si el campo "@replace2@" no está informado.', '05', '01', '02'),
    ('S86', 'La propiedad contador no se ha informado', '01', '02', '02'),
    ('S88', 'Existe instalación Térmica no se ha informado', '01', '02', '02'),
    ('S89', 'Existencia de Instalación térmica no informada', '01', '02', '02'),
    ('S90', 'Situación de Punto de Suministro incoherente', '01', '02'),
    ('S91', 'Expediente no es NE', '01', '02'),
    ('S92', 'Solicitud en curso', '01', '02'),
    ('S93', 'Ya existe una solicitud en curso para el CUPS', '05', '01', '02'),
    ('S94', 'Propiedad del contador no informada', '05', '01', '02'),
    ('S98', 'El campo "@replace1@" ha de ser S o N', '05', '01', '02'),
    ('S99', 'El Sujeto Emisor "@replace1@" no tiene categoría de Distribuidor o Grupo empresarial o Transportista.', '05', '01', '02'),
    ('T00', 'Error Oracle Leve (SELECT, Conversiones...)', '05', '01', '02'),
    ('T01', 'Error Oracle Grave (DML, Instancia...)', '05', '01', '02'),
    ('T02', 'El motivo de error está dado de baja del sistema', '05', '01'),
    ('T10', 'Solicitud en curso', '01', '02'),
    ('T11', 'Ya existe una solicitud en curso para el CUPS', '05', '02', '02'),
    ('T12', 'Falta infraestructura', '01', '02'),
    ('T13', 'Falta infraestructura', '05', '01', '02'),
    ('T14', 'La solicitud "@replace1@" se encuentra en un estado inconsistente: @replace2@', '05', '01', '02'),
    ('T15', 'Existe una solicitud previa de un tipo distinto al de nuevos suministros para el CUPS "@replace1@".', '05', '01', '02'),
    ('T16', 'La solicitud de nuevos suministros para el cups "@replace1@" es de otra comercializadora distinta a "@replace2@"', '05', '01', '02'),
    ('T17', 'No existe una Solicitud de Nuevos Suministros previa del comercializador que solicita la Anulación', '05', '01', '02'),
    ('T18', 'Existe una Solicitud de Modificación diferente del tipo solicitado para el CUPS "@replace1@"', '05', '01', '02'),
    ('T19', 'Se ha realizado un nuevo suministro en el CUPS solicitado posterior a la solicitud que intenta anular.', '05', '01', '02'),
    ('T20', '"@replace1@": Campo obligatorio si el campo "@replace2@" tiene valor @replace3@ o si el campo "@replace4@" tiene valor @replace5@.', '05', '01', '02'),
    ('T21', 'En Solicitud de Anulación de Nuevos Suministros el campo Número de Referencia Cliente del Distribuidor debe ser nulo.', '05', '01', '02'),
    ('T22', 'No hay ningún contrato vigente para el CUPS @replace1@ en la fecha @replace2@.', '01', '01', '03'),
    ('T23', 'El grupo empresarial al que pertenece el CUPS no corresponde con el grupo empresarial del usuario conectado.', '05', '01', '02'),
    ('T24', 'La solicitud realizada ha sido rechazada al no poder completar el proceso de envío a SSPP', '05', '01', '02'),
    ('T25', 'Ha ocurrido un error grave durante la escritura del fichero XML de salida.', '05', '01', '01'),
    ('T26', 'Existe una solicitud previa del tipo petición única de RPS', '05', '01', '02'),
    ('T27', 'El tipo de operación "@replace1@" no es válido con origen Comercializador', '05', '01', '01'),
    ('T28', 'El tipo de operación "@replace1@" ha expirado.', '05', '01', '01'),
    ('T29', 'El Comercializador no está autorizado para enviar Operaciones de tipo "@replace1@"', '05', '01', '01'),
    ('T30', 'Existe una Solicitud de Actuación (corte del suministro) ', '05', '01', '01'),
    ('T31', 'El resultado "@replace1@" debe ser Realizado o No Realizado', '05', '01', '01'),
    ('T32', 'El campo "@replace1@" no debe enviarse si el campo "@replace2@" tiene valor diferente a "@replace3@".', '05', '01', '01'),
    ('T34', 'La empresa distribuidora o transportista <codsupplier> no está informada y la carga se está realizando en un GRE no propietario de este SCTD', '05', '01', '01'),
    ('T35', 'La distribuidora o transportista <codsupplier> "@replace1@" no pertenece al grupo empresarial ', '05', '01', '01'),
    ('T36', 'La solicitud no puede aceptarse al haberse recibido una comunicación de operación para este CUPS con posterioridad', '05', '02', '01'),
    ('T37', 'El tipo de operación "@replace1@" no corresponde con la operación "@replace2@" enviada en el mensaje B1', '05', '01', '01'),
    ('T38', 'La solicitud no puede realizarse al haberse recibido una solicitud de cambio validada con posterioridad', '05', '02', '01'),
    ('T39', 'Se ha recibido comunicación de operación para el mismo CUPS', '05', '01', '01'),
    ('T40', 'El resultado de intervención "@replace1@" no existe', '05', '01', '01'),
    ('T41', 'Los campos "Qd concedida" y "Qh concedida" son obligatorios si el motivo de modificación implica un cambio de capacidad (05, 06, 07 o 08) y el resultado es Realizado (09)', '05', '01', '01'),
    ('T43', 'No se ha podido realizar la baja por ausencia del cliente', '13', '01', '02'),
    ('T44', 'No se ha podido contactar con el cliente', '13', '01', '02'),
    ('T45', 'El motivo de anulación "@replace1@" no es válido para el tipo de operación "@replace2@"', '05', '01', '01'),
    ('T46', 'No existe solicitud de @replace1@ a Anular del tipo "@replace2@"', '05', '01', '01'),
    ('T47', 'La solicitud que se desea anular ha sido rechazada por los SSPP', '05', '01', '01'),
    ('T48', 'La solicitud ha sido anulada a petición del comercializador', '05', '01', '01'),
    ('T49', 'El motivo de anulación "@replace1@" no corresponde con el recibido en el mensaje A1', '05', '01', '01'),
    ('T50', 'El número de conceptos informados en la operación no se corresponde con el disponible en el listado de conceptos', '05', '01', '01'),
    ('T51', 'El número de conceptos informados en la baja de contratación no se corresponde con el disponible en el listado de conceptos', '05', '01', '01'),
    ('T52', 'No se pudo calcular el sistema', '05', '01', '01'),
    ('T53', 'La solicitud no puede aceptarse al haberse recibido una comunicación de operación para este CUPS con posterioridad.', '05', '01', '01'),
    ('T55', 'El SSPP destinatario de la solicitud (@replace1@) no dispone de Canal de Mensajería Online. Esta solicitud debe gestionarse mediante la opción de menú Operaciones / Iniciativa COM / Operaciones / Envío', '05', '01', '01'),
    ('T56', 'No se ha podido realizar la modificación por causas imputables al cliente', '13', '02', '01'),
    ('T57', 'No se ha podido realizar la modificación por causas imputables al Distribuidor', '13', '02', '01'),
    ('T58', 'La solicitud no puede aceptarse al haberse recibido una solicitud de cambio validada con posterioridad', '05', '01'),
    ('T59', 'La solicitud no puede realizarse al haberse recibido una comunicación de cambio con posterioridad', '05', '01'),
    ('T60', 'La solicitud no puede realizarse al haberse recibido una solicitud de cambio validada con posterioridad', '05', '01'),
    ('T61', 'El campo @replace1@ es obligatorio si el peaje es 35 o pertenece a los grupos 01, 02 o 04', '05', '01'),
    ('T62', 'Si el motivo de identificación "@replace1@", alguno de los campos "@replace2@" debe tener un valor diferente a los actuales del cliente', '05', '01', '01'),
    ('T63', 'El valor del campo "@replace1@" no está normalizado según el INE.', '05', '01', '01'),
    ('T64', 'El parámetro Versión actual de SCTD no está definido', '05', '01', '01'),
    ('T65', 'El campo @replace1@ no se debe enviar', '05', '01', '01'),
    ('T66', 'El tipo de reclamación "@replace1@" no corresponde con el tipo actual de la operación "@replace2@" ', '05', '01', '01'),
    ('T67', 'El subtipo de reclamación "@replace1@" no corresponde con el subtipo actual de la operación "@replace2@"', '05', '01', '01'),
    ('T68', 'El grupo empresarial al que pertenece la reclamación no corresponde con el grupo empresarial del usuario conectado.', '05', '01', '01'),
    ('T69', 'Si locationtype es 07 (Dirección) se debe informar obligatoriamente province, city o city2, zipcode, streettype, street y streetnumber.', '05', '01', '01'),
    ('T70', 'Si el tipo de actuación es @replace1@ ', '05', '01', '01'),
    ('T71', 'Si el tipo de actuación es Lectura Facilitada se debe informar "readingdate" y "readingvalue"', '05', '01', '01'),
    ('T72', 'El campo "@replace1@" no se debe informar si el tipo de actuación es @replace2@', '05', '01', '01'),
    ('T73', 'La descripción no corresponde con la solicitud "@replace1@" enviada en el mensaje B1', '05', '01', '01'),
    ('T74', 'Si el tipo de intervención es "@replace1@" debe informarse "@replace2@"', '05', '01', '01'),
    ('T75', 'Si el tipo de reclamación <claimtype> tiene más de un subtipo posible <claimsubtype> éste último es obligatorio', '05', '01', '01'),
    ('T76', 'Si el tipo de anulación es "@replace1@" debe informarse @replace2@"', '05', '01', '01'),
    ('T77', 'El subtipo de reclamación <claimsubtype> no pertenece al tipo de reclamación <claimtype>', '05', '01', '01'),
    ('T78', 'La referencia de reclamación "@replace1@" no aplica para esta reclamación', '05', '01', '01'),
    ('T79', 'Se debe informar al menos uno de los campos "@replace1@"', '05', '01', '01'),
    ('T80', 'Sólo se puede informar un único campo "@replace1@"', '05', '01', '01'),
    ('T81', 'Los campos "@replace1@" sólo pueden enviarse ', '05', '01', '01'),
    ('T82', 'Si se desean enviar los datos bancarios deben indicarse conjuntamente todos los campos "@replace1@" cuándo "@replace2@" disponga un valor asignado.', '05', '01', '01'),
    ('T83', 'Los datos de "@replace1@" deben enviarse si el campo "@replace2@" tiene valor asignado.', '05', '01', '01'),
    ('T84', 'El resultado de reclamación <result> debe ser: 15-Atendida procede, 16-Atendida no procede o 17-Imposible atender', '05', '01', '01'),
    ('T85', 'Existe una Solicitud de Actuación (corte del suministro) en curso del mismo comercializador ', '05', '01', '01'),
    ('T86', 'Existe una Solicitud de Reclamación en curso para el CUPS "@replace1@"', '05', '01', '01'),
    ('T87', 'Existe una Solicitud de "@replace2@" en curso para el CUPS "@replace1@"', '05', '01', '01'),
    ('T88', 'Si el tipo de intervención es @replace1@ ', '05', '01', '01'),
    ('T89', 'El número de conceptos @replace1@ de <conceptnumber> debe ser igual al número de conceptos informados en <conceptlist>', '05', '01', '01'),
    ('T90', 'No existe para el cups enviado una solicitud que no haya recibido el mensaje A2', '05', '01', '01'),
    ('T91', 'No existe para el cups enviado una solicitud que haya recibido un mensaje A2 de rechazo', '05', '01', '01'),
    ('T92', 'No existe para el cups enviado una solicitud que no haya recibido el mensaje A3', '05', '01', '01'),
    ('T93', 'No existe para el cups enviado una solicitud que haya recibido el mensaje A3', '05', '01', '01'),
    ('T94', 'No existe para el cups enviado una operación con el número de operación enviado', '05', '01', '01'),
    ('T95', 'Existe para el cups enviado una telemedida en la fecha enviada', '05', '01', '01'),
    ('T96', 'Existe para el cups enviado una factura en la fecha enviada', '05', '01', '01'),
    ('T97', 'No existe para el cups enviado una factura en la fecha enviada, con el código de factura enviado y que se haya facturado el concepto enviado', '05', '01', '01'),
    ('T98', 'No existe para el cups enviado una solicitud/operación asociada', '05', '01', '01'),
    ('T99', 'No existe para el cups enviado una factura en la fecha enviada y con el código de factura enviado', '05', '01', '01'),
    ('U01', 'El campo "@replace1@" con valor "@replace2@" no se corresponde con el del titular actual.', '05', '01', '01'),
    ('U03', 'El nuevo @replace1@ debe ser mayor que el actual.', '05', '01', '01'),
    ('U04', 'La solicitud de @replace1@ debe de ser de una comercializadora distinta a la del contrato vigente ("@replace2@").', '05', '01', '01'),
    ('U05', 'El motivo de cambio con modificación "@replace1@" no coincide con el de la solicitud "@replace2@".', '05', '01', '01'),
    ('U06', 'Los campos "@replace1@" son obligatorios si ha existido intervención.', '05', '01', '01'),
    ('U07', 'Existe una solicitud previa del tipo cambio de comercializadora con modificación para el CUPS "@replace1@" enviada por Comercializadora "@replace2@"', '05', '01'),
    ('U08', 'Existe una solicitud previa del tipo cambio de comercializadora con modificación para el CUPS "@replace2@" de otra Comercializadora', '05', '01'),
    ('U09', 'El resultado "@replace1@" no esta definido como respuesta de realización de SS.PP.', '05', '01'),
    ('U10', 'El valor @replace1@ no existe en el maestro de @replace2@.', '05', '01', '01'),
    ('U11', 'El punto de conexión \'@replace1@\' de "listpctd" no tiene como punto padre "suprapctd" \'@replace2@\'.', '05', '01', '01'),
    ('U12', 'El "tipodia" \'@replace1@\' no tiene valores permitidos: \'L\'-Laborable, \'F\'-Festivos y fines de semana y \'1-31\'- Día del mes.', '05', '01', '01'),
    ('U13', 'La lista "@replace1@" debe contener un elemento como mínimo.', '05', '01', '01'),
    ('U14', 'No se realizará el corte porque se ha recibido una solicitud de reapertura', '05', '02', '01'),
    ('U15', 'No se realizará la reapertura porque se ha podido cancelar el corte', '05', '02', '01'),
    ('U16', 'Se ha anulado la solicitud de corte porque se ha recibido una solicitud de reapertura', '05', '01', '01'),
    ('U17', 'No se ha realizado el corte porque se ha recibido una solicitud de reapertura', '13', '02', '01'),
    ('U18', 'No se ha realizado la reapertura porque no se ha realizado el corte', '13', '02', '01'),
    ('U19', 'No existe una Solicitud de Cambio con Modificación previa del comercializador que solicita la Anulación', '05', '01', '01'),
    ('U20', 'La solicitud de cambio con modificación para el cups "@replace1@" es de otra comercializadora distinta a "@replace2@"', '05', '01', '01'),
    ('U22', 'No se realizará el corte porque se ha recibido una solicitud de reapertura', '05', '01', '01'),
    ('U24', 'No se ha realizado la reapertura porque no se ha realizado el corte', '05', '02', '01'),
    ('U25', 'No se puede anular el corte porque se ha recibido una solicitud de reapertura', '05', '01', '01'),
    # todo WTF aixo no te data, te un codi, hi ha mes sota
    ('U26', 'Solicitud rechazada por fin de actividad del comercializador', '05', '01', '02', 'F3'),
    ('U27', 'Escenario no definido: Existen dos procesos concurrentes de @replace1@ y @replace2@ sin finalizar', '05', '01', '01', 'F6'),
    ('U28', 'No se puede aceptar la reapertura porque no se ha solicitado / realizado un corte previo o ya se solicitó la reapertura correspondiente', '05', '01', '01', 'F6'),
    ('U29', 'La comercializadora de la solicitud o petición no puede operar en el área de actuación del PS', '05', '01', '01', 'F2'),
    ('U30', 'Uso de la vivienda no es uno de los valores tipificados', '05', '01', '01', 'F6'),
    ('U31', 'El sujeto @replace1@no tiene una categoría válida: @replace2@', '05', '01', '01', 'F2'),
    ('U32', 'No se puede aceptar el corte debido a que existe un corte previo', '05', '01', '01', 'F6'),
    ('U33', 'El tipo de peaje "@replace1@" está obsoleto desde "@replace2@"', '05', '01', '01', 'F6'),
    ('U34', 'Si el modelo fecha efecto es "04" debe introducir una fecha en el campo Fecha Efecto Solicitada.', '05', '01', '01', 'F2'),
    ('U35', '\'El número de conceptos (@replace1@) no se corresponde con el número conceptos detallados (@replace2@)', '05', '01', '01', 'F4'),
    ('U36', 'Si iricertificateneeded="S", se debe informar el código de instalador "reig".', '05', '01', '01'),
    ('U37', 'Si iricertificateneeded="S", se debe informar la fecha de certificado IRI "iricertificatedate".', '05', '01', '01'),
    ('U38', 'El Número de Conceptos "conceptnumber" informados no coincide con los valores informados. conceptnumber = "@replace1@", conceptos informados = @replace2@', '05', '01', '01'),
    ('U39', 'Error Nivel Concepto Facturación level="@replace1@" el código seleccionado no existe', '05', '01', '01'),
    ('U40', 'Error Concepto Facturación level="@replace1@" - code="@replace2@" seleccionado no existe', '05', '01', '01'),
    ('U41', 'Error Periodicidad Facturación periodicity="@replace1@" el código seleccionado no existe', '05', '01', '01'),
    ('U42', 'El tipo de documento "@replace2@" no corresponde con la solicitud "@replace1@" enviada en el mensaje B1', '05', '01', '01'),
    ('U43', 'La nacionalidad "@replace2@" no corresponde con la solicitud "@replace1@" enviada en el mensaje B1', '05', '01', '01'),
    ('U44', 'El tipo de persona "@replace2@" no corresponde con la solicitud "@replace1@" enviada en el mensaje B1', '05', '01', '01'),
    ('U45', 'Si el motivo de modificación es "@replace1@" y el campo @replace2@ es @replace3@ el campo @replace4@ es obligatorio', '05', '01', '01'),
    ('U46', 'Si el motivo de modificación es "@replace1@" y el campo @replace2@ es @replace3@ no puede enviar el campo @replace4@', '05', '01', '01'),
    ('U47', 'No se permiten cargar más mensajes de Petición de información adicional con Tipo de Intervención "@replace1@" para esta solicitud', '05', '01', '01'),
    ('U48', 'Existe una petición de info. adicional anterior para la que no se ha recibido respuesta ni ha expirado', '05', '01', '01'),
    ('U52', 'Si el tipo de comunicación es "@replace1@" debe informarse "@replace2@"', '05', '01', '01'),
    ('U53', 'Si el tipo de comunicación es @replace1@ ', '05', '01', '01'),
    ('U54', 'Se ha sobrepasado el número máximo de envíos de información adicional en Reclamaciones', '05', '01', '01'),
    ('U55', 'El cups no se corresponde con la solicitud de reclamación', '05', '01', '01'),
    ('U56', 'El nº de referencia @replace2@ no corresponde con la solicitud de reclamación @replace1@', '05', '01', '01'),
    ('U57', 'La empresa emisora "@replace1@" no corresponde con la de la solicitud "@replace2@"', '05', '01', '01'),
    ('U58', 'Este campo sólo puede enviarse si la tipología de la actuación es Inspección Periódica (A10009)', '05', '01', '01'),
    ('U59', 'La solicitud se rechaza por estar en periodo de migración a UPGRADE', '05', '01', '01'),
    ('U60', 'El @replace1@ con valor @replace2@ no se encuentra vigente', '05', '01', '01'),
    ('U61', 'La lista "@replace1@" no puede tener más de "@replace2@" ocurrencias', '05', '01', '01'),
    ('U62', 'No hay Intervención en la que se solicite Información Adicional', '05', '01', '01'),
    ('U63', 'Periodo duplicado para la fecha @replace1@', '05', '01', '01'),
    ('U64', 'Si el tipo de intervención es "@replace1@" y el tipo de información adicional es "@replace2@" debe informarse "@replace3@"', '05', '01', '01'),
    ('U65', 'El tipo de titular "@replace1@" no es correcto para el documento aportado', '05', '01', '01'),
    ('U66', 'Rechazo por condiciones CNMC compra puntos de GLP', '05', '01', '01'),
    ('U67', 'No se puede aceptar la solicitud de NNSS porque el PS es un punto GLP que aún no está transformado', '05', '01', '01'),
    ('U68', 'No se puede aceptar la solicitud de NNSS porque el PS es un punto GLP cuya fecha prevista de transformación supera el límite de días de cercanía necesario para contratar', '05', '01', '01'),
    ('U69', 'Reclamación Duplicada', '05', '01', '01'),
    ('U70', 'No se pueden adjuntar documentos si no se proporcionan las claves de acceso al Gestor Documental', '05', '01', '02'),
    ('U71', 'No es posible acceder al Gestor Documental para obtener alguno de los documentos adjuntos', '05', '01', '02'),
    ('U72', 'Tras @replace1@ intentos, no se ha podido acceder al Gestor Documental para obtener alguno de los documentos adjuntos', '05', '01', '02'),
    ('U73', 'El Motivo CNMC asociado al Motivo de Rechazo está dado de baja', '05', '01', '01'),
    ('U74', 'Motivo de rechazo "@replace1@" no válido para el proceso "@replace2@"', '05', '01', '01'),
    ('U75', 'Motivo de rechazo "@replace1@" no válido para el tipo de mensaje "@replace2@"', '05', '01', '01'),
    ('U76', 'No se cumple período mínimo desde la última modificación de peaje o Qd', '05', '02', '02'),
    ('U77', 'Rechazo de integridad: @replace1@', '05', '01', '01'),
    ('U78', 'Incidencia no subsanada en periodo máximo establecido', '05', '02', '01'),
    ('U79', 'Comercializadora inactiva', '05', '01', '01'),
    ('U83', 'No se puede suspender el suministro por trámites judiciales', '05', '02', '01'),
    ('U84', 'Factura inexistente', '05', '02', '01'),
    ('U85', 'Concurrencia con cambio/Traspaso CUR', '13', '02', '02'),
    ('U86', 'Anomalía instalación', '13', '02', '01'),
    ('U87', 'Corte Anulado', '13', '02', '01'),
    ('U88', 'Cliente no quiere gas', '13', '02', '01'),
    ('U89', 'Cliente quiere gas más adelante', '13', '02', '01'),
    ('U90', 'Concurrencia Corte/Reapertura: @replace@', '05', '01', '01'),
    ('U91', 'No se ha podido realizar la reapertura', '13', '02', '01'),
    ('U92', 'No se puede suspender el suministro por esencialidad', '13', '02', '01'),
    ('U93', 'No se puede suspender el suministro por trámites judiciales', '13', '02', '01'),
    ('U94', 'Contrato de ATR en suspensión de suministro', '05', '02', '02'),
    ('U95', 'Se rechaza por concurrencia con baja por impago', '05', '02', '01'),
    ('U96', 'No es posible solicitar un cambio/alta/modificación a fecha fija para una fecha > 30 días naturales', '05', '01', '01'),
    ('U97', 'Existe una solicitud previa de baja ya en campo o realizada (pendiente de activar) de otra comercializadora.', '05', '01', '01'),
    ('U98', 'Tipo de activación solicitada incoherente con el proceso solicitado', '05', '01', '01'),
    ('U99', 'El Resultado de la Intervención enviado "@replace1" no puede estar asociado al Motivo de Rechazo CNMC "@replace2".', '05', '01', '01'),
    ('002', 'El valor del indicador de nuevo cliente "@replace1@" tiene que ser S o N', '05', '01', '02'),
    ('010', 'No se dispone del tipo de telemedida o está averiado (Qa > 100GWh)', '05', '02', '02'),
    ('013', 'Número de contrato ATR en vigor no coincide con el aportado', '05', '01', '02'),
    ('014', 'No existe contrato de ATR en vigor', '05', '01', '02'),
    ('017', 'La solicitud de anulación se produce con posterioridad a la finalización de los trámites originados por la solicitud a anular (rechazo parcial y apertura del proceso de reposición salvo para el caso de baja)', '05', '02', '02'),
    ('020', 'Rechazo por error de formato', '05', '01', '02'),
    ('021', 'Rechazo por error de integridad en los campos: CUPS, DNI o Número de Póliza del Cliente', '05', '02', '02'),
    ('022', 'Existe una solicitud previa del tipo alta para el CUPS "@replace1@" enviada por Comercializadora "@replace2@"', '05', '01', '02'),
    ('023', 'Existe una solicitud previa del tipo baja para el CUPS "@replace1@" enviada por Comercializadora "@replace2@"', '05', '01', '02'),
    ('024', 'Existe una solicitud previa del tipo cambio de comercializadora para el CUPS "@replace1@" enviada por Comercializadora "@replace2@"', '05', '01', '02'),
    ('025', 'Existe una solicitud previa del tipo modificación para el CUPS "@replace1@" enviada por Comercializadora "@replace2@"', '05', '01', '02'),
    ('026', 'Existe una solicitud previa del tipo anulación para el CUPS "@replace1@" enviada por Comercializadora "@replace2@"', '05', '01', '02'),
    ('027', 'Existe una solicitud previa del tipo reposición para el CUPS "@replace1@" enviada por Comercializadora "@replace2@"', '05', '01', '02'),
    ('029', 'El valor del indicador de conformidad cliente "@replace1@" tiene que ser S o N', '05', '01', '02'),
    ('030', 'El campo "@replace1@" es obligatorio.', '05', '01', '02'),
    ('031', 'El campo "@replace1@": "@replace2@" tiene un formato no válido: Formato correcto: "@replace3@".', '05', '01', '02'),
    ('032', 'El campo "@replace1@" tiene un tamaño máximo de @replace2@ caracteres.', '05', '01', '02'),
    ('034', 'El campo "@replace1@: @replace2@" tiene un formato de fecha incorrecto. Formato correcto (@replace3@).', '05', '01', '02'),
    ('035', 'El mes de "@replace1@: @replace2@" no es válido.', '05', '01', '02'),
    ('036', 'El día del mes de "@replace1@: @replace2@" tiene que estar entre el primer día del mes y el ', '05', '01', '02'),
    ('037', 'La hora de "@replace1@: @replace2@" tiene que estar comprendida entre 0 y 23.', '05', '01', '02'),
    ('038', 'Los minutos de "@replace1@: @replace2@" tienen que estar comprendidos entre 0 y 59.', '05', '01', '02'),
    ('039', 'Los segundos de "@replace1@: @replace2@" tienen que estar comprendidos entre 0 y 59.', '05', '01', '02'),
    ('040', 'El tipo de documento "@replace1@" no existe.', '05', '01', '02'),
    ('041', 'El modelo fecha efecto "@replace1@" no es válido.', '05', '01', '02'),
    ('042', 'Si el modelo fecha efecto es "03" debe introducir una fecha en el campo Fecha Efecto Solicitada.', '05', '01', '02'),
    ('043', 'La duración del contrato "@replace1@" no es válida.', '05', '01', '02'),
    ('044', 'La fecha de efecto solicitada es menor que la fecha de entrada.', '05', '01', '02'),
    ('045', 'La fecha de efecto solicitada "@replace1@" no puede ser mayor que la fecha "@replace2@".', '05', '01', '02'),
    ('047', 'El municipio "@replace1@" no existe.', '05', '01', '02'),
    ('048', 'La provincia "@replace1@" no existe.', '05', '01', '02'),
    ('049', 'La población "@replace1@" no pertenece a la provincia "@replace2@".', '05', '01', '02'),
    ('050', 'Si la presión solicitada es mayor de 4 bares es obligatorio que el campo QD tenga un valor.', '05', '01', '02'),
    ('052', 'Ya existe una solicitud con el nº de referencia "@replace1@".', '05', '01', '02'),
    ('053', 'El nº de documento "@replace1@" no coincide con el del Contrato ATR en vigor', '05', '01', '02'),
    ('055', 'El día de la fecha efecto solicitada "@replace1@" tiene que ser el 1,11 ó 21 del mes.', '05', '01', '02'),
    ('057', 'El valor del indicador de telemedida "@replace1@" tiene que ser S o N', '05', '01', '02'),
    ('058', 'Si el motivo de modificación es "@replace1@", no se deben enviar los campos "@replace2@".', '05', '01', '02'),
    ('059', 'El nuevo tipo de documento "@replace1@" no es válido.', '05', '01', '02'),
    ('061', 'El nuevo municipio "@replace1@" no es válido.', '05', '01', '02'),
    ('062', 'La nueva provincia "@replace1@" no es válido.', '05', '01', '02'),
    ('063', 'La nueva población "@replace1@" no pertenece a la nueva provincia "@replace2@".', '05', '01', '02'),
    ('065', 'El motivo de baja "@replace1@" no existe.', '05', '01', '02'),
    ('066', 'El motivo de modificación "@replace1@" no es válido.', '05', '01', '02'),
    ('067', 'El motivo de anulación "@replace1@" no es válido.', '05', '01', '02'),
    ('068', 'El motivo de reposición "@replace1@" no es válido.', '05', '01', '02'),
    ('069', 'El tipo de mensaje "@replace1@" no corresponde a B2', '05', '01', '02'),
    ('070', 'El proceso "@replace1@" no corresponde a solicitud de Alta, Cambio de comercializadora, Baja, Modificación, anulación o Reposición', '05', '01', '02'),
    ('071', 'La @replace1@ "@replace2@" no existe para el tipo de mensaje "@replace3@"', '05', '01', '02'),
    ('072', 'El código de solicitud "@replace1@" no ha sido enviado a SS.PP.', '05', '01', '02'),
    ('073', 'El código de solicitud "@replace1@" ha sido enviado en un mensaje A2', '05', '01', '02'),
    ('074', 'La empresa emisora "@replace1@" no corresponde con la solicitud "@replace2@" enviada en el mensaje B1', '05', '01', '02'),
    ('075', 'La empresa destino "@replace2@" no corresponde con la solicitud "@replace1@" enviada en el mensaje B1', '05', '01', '02'),
    ('076', 'El CUPS "@replace2@" no corresponde con la solicitud "@replace1@" enviada en el mensaje B1', '05', '01', '02'),
    ('077', 'La empresa "@replace1@" no es comercializadora, ni cliente cualificado, ni distribuidora', '05', '01', '02'),
    ('078', 'El nº de referencia "@replace2@" no corresponde con la solicitud "@replace1@" enviada en el mensaje B1', '05', '01', '02'),
    ('079', 'El nº de documento "@replace2@" no corresponde con la solicitud "@replace1@" enviada en el mensaje B1', '05', '01', '02'),
    ('080', 'El resultado "@replace1@" no es válido.', '05', '01', '02'),
    ('081', 'El motivo debe ser nulo si el resultado es 12-Validado', '05', '01', '02'),
    ('082', 'Si el resultado es diferente de Validado, el motivo es obligatorio.', '05', '01', '02'),
    ('083', 'Si el resultado es 12-Validada, el campo "@replace1@" es obligatorio.', '05', '01', '02'),
    ('084', 'La periodicidad de alquiler "@replace1@" no es válida', '05', '01', '02'),
    ('085', 'La periodicidad del canon IRC "@replace1@" no existe', '05', '01', '02'),
    ('086', 'La periodicidad del resto de conceptos "@replace1@" no existe', '05', '01', '02'),
    ('087', 'La periodicidad del tipo de lectura "@replace1@" no existe', '05', '01', '02'),
    ('088', 'El resultado de última inspección "@replace1@" no existe.', '05', '01', '02'),
    ('089', 'El mes que aplica el canon IRC "@replace1@" no es válido', '05', '01', '02'),
    ('090', 'El tipo de peaje "@replace1@" no existe', '05', '01', '02'),
    ('091', 'La fecha prevista efecto "@replace1@" debe ser igual o posterior a hoy', '05', '01', '02'),
    ('092', 'La red de ubicación "@replace1@" no es válida', '05', '01', '02'),
    ('093', 'El valor del indicador de nominación individual "@replace1@" tiene que ser S o N ', '05', '01', '02'),
    ('094', 'El tipo de mensaje "@replace1@" no corresponde a B4', '05', '01', '02'),
    ('095', 'El código de solicitud "@replace1@" ha sido enviado en un mensaje A3', '05', '01', '02'),
    ('096', 'El código de solicitud "@replace1@" no existe.', '05', '01', '02'),
    ('097', 'El código de solicitud "@replace1@" debe tener resultado Aceptado en el mensaje B3', '05', '01', '02'),
    ('098', 'La fecha efectiva solicitud "@replace1@" debe ser igual o posterior a hoy', '05', '01', '02'),
    ('099', 'Otros motivos', '05', '02', '02'),
    ('100', 'El resultado "@replace1@" debe ser ', '05', '01', '02'),
    ('101', 'El resultado "@replace1@" no está definido como respuesta de validación de SS.PP.', '05', '01', '02'),
    ('102', 'El motivo "@replace1@" no es válido para el resultado "@replace2@" y SS.PP.', '05', '01', '02'),
    ('103', 'El tipo corrector 1 "@replace1@" no existe', '05', '01', '02'),
    ('104', 'El tipo corrector 2 "@replace1@" no existe', '05', '01', '02'),
    ('105', 'Si el valor de Nuevo Tipo Documento es 01 ò 03, el campo Nuevo Nombre Cliente es obligatorio.', '05', '01', '02'),
    ('106', 'El código de motivo "@replace1@" no existe.', '05', '01', '02'),
    ('107', 'El tipo de mensaje "@replace1@" no existe.', '05', '01', '02'),
    ('108', 'El suministrador actual enviado en la solicitud "@replace1@" no es la empresa titular del contrato ATR en vigor.', '05', '01', '02'),
    ('109', 'El valor del campo "@replace1@" no existe en la lista de valores permitidos "@replace2@".', '05', '01', '02'),
    ('111', 'La @replace1@ "@replace2@" no existe.', '05', '01', '02'),
    ('112', 'Si el motivo de modificación es "@replace1@", se deben enviar los campos "@replace2@".', '05', '01', '02'),
    ('114', 'Si el motivo de modificación es "@replace1@", no se debe enviar el campo nueva Qd y/ o nueva Qh.', '05', '01', '02'),
    ('117', 'Si el motivo de modificación es "@replace1@", los campos "@replace2@" tienen que ser distintos.', '05', '01', '02'),
    ('118', 'El valor del indicador de detalle "@replace1@" tiene que ser S o N', '05', '01', '02'),
    ('119', 'Existe una petición sin responder para el CUPS "@replace1@" y nº de documento "@replace2@"', '05', '01', '02'),
    ('120', 'Ya existe una petición con el nº de referencia de rpds "@replace1@".', '05', '01', '02'),
    ('121', 'El tipo de peaje/ tarifa "@replace1@" no existe.', '05', '01', '02'),
    ('122', 'El rango de presión "@replace1@" no existe.', '05', '01', '02'),
    ('123', 'El proceso "@replace1@" no corresponde a Registro de Punto de Suministro.', '05', '01', '02'),
    ('124', 'El tipo de mensaje "@replace1@" no corresponde a B6', '05', '01', '02'),
    ('125', 'El código de petición "@replace1@" no ha sido enviado a SS.PP.', '05', '01', '02'),
    ('126', 'La empresa emisora "@replace1@" no corresponde con la petición "@replace2@" enviada en el mensaje B5.', '05', '01', '02'),
    ('127', 'La empresa destino "@replace2@" no corresponde con la petición "@replace1@" enviada en el mensaje B5.', '05', '01', '02'),
    ('128', 'El código de petición "@replace1@" no existe para el proceso "@replace2@".', '05', '01', '02'),
    ('129', 'El CUPS "@replace2@" no corresponde con la petición "@replace1@" enviada en el mensaje B5.', '05', '01', '02'),
    ('130', 'El nº de referencia "@replace2@" no corresponde con la petición "@replace1@" enviada en el mensaje B5.', '05', '01', '02'),
    ('131', 'El nº de documento "@replace2@" no corresponde con la petición "@replace1@" enviada en el mensaje B5.', '05', '01', '02'),
    ('132', 'La fecha de baja solicitada es menor que la fecha de hoy.', '05', '01', '02'),
    ('133', 'La fecha de baja solicitada "@replace1@" no puede ser mayor que la fecha "@replace2@".', '05', '01', '02'),
    ('134', 'Si el resultado es 12-Validada, los campos Qa y Fecha Efecto Prevista son obligatorios.', '05', '01', '02'),
    ('135', 'El valor del campo "@replace1@" no existe en la lista de valores permitidos "@replace2@".', '05', '01', '02'),
    ('136', 'Los resultados posibles para la respuesta de SSPP de Solicitud de acceso al registro de Puntos de Suministro ', '05', '01', '02'),
    ('137', 'El código de Distribuidor "@replace1@" no existe.', '05', '01', '02'),
    ('138', 'El código de Distribuidor "@replace1@" no tiene categoría de Distribuidor o Grupo empresarial.', '05', '01', '02'),
    ('140', 'El código de petición "@replace1@" ', '05', '01', '02'),
    ('141', 'Qd ha de ser positivo en caso de especificarse', '05', '01', '02'),
    ('142', 'La fecha de última inspección debe ser una fecha o "en curso".', '05', '01', '02'),
    ('143', 'Si el resultado es 01-Aceptado, es obligatorio enviar los datos: calle, nº finca, provincia, ', '05', '01', '02'),
    ('144', 'El dato "@replace1@" tiene que ser un municipio o una red.', '05', '01', '02'),
    ('146', 'Si el motivo de modificación es "@replace1@", se debe enviar alguno de los campos "@replace2@".', '05', '01', '02'),
    ('147', 'El campo "@replace1@": "@replace2@" tiene que tener un tamaño exacto de 20 caracteres.', '05', '01', '02'),
    ('148', 'El tipo de mensaje "@replace1@" debe ser "@replace2@"', '05', '01', '02'),
    ('150', 'El valor de Qa tiene que ser mayor que cero.', '05', '01', '02'),
    ('151', 'La empresa emisora "@replace1@" no es la titular del contrato ATR en vigor para el CUPS solicitado.', '05', '01', '02'),
    ('160', 'No existe una Solicitud de Alta previa del comercializador que solicita la Anulación', '05', '01', '02'),
    ('161', 'No existe una Solicitud de Cambio previa del comercializador que solicita la Anulación', '05', '01', '02'),
    ('162', 'No existe una Solicitud de Modificación previa del comercializador que solicita la Anulación', '05', '01', '02'),
    ('163', 'No existe una Solicitud de Baja previa del comercializador que solicita la Anulación', '05', '01', '02'),
    ('164', 'El motivo debe ser nulo si el resultado es 01-Aceptada', '05', '01', '02'),
    ('165', 'El motivo es obligatorio si el resultado es de rechazo', '05', '01', '02'),
    ('166', 'Los resultados posibles para la respuesta de SSPP de Solicitud de Anulación son ', '05', '01', '02'),
    ('171', 'La solicitud que se intenta anular ya está formalizada.', '05', '01', '02'),
    ('172', 'No existe una solicitud de "@replace1@" previa del comercializador solicitante que haya sido formalizada para el CUPS solicitado', '05', '01', '02'),
    ('173', 'El Suministrador "@replace1@" no es válido.', '05', '01', '02'),
    ('174', 'El Suministrador Actual no coincide con el del Contrato vigente.', '05', '01', '02'),
    ('177', 'Si el motivo de anulación es "@replace3@" el campo Código ATR previo es obligatorio.', '05', '01', '02'),
    ('179', 'El municipio "@replace1@" no coincide con el municipio "@replace2@" asociado al CUPS.', '05', '01', '02'),
    ('180', 'En el CUPS solicitado existe un Cambio de Titular posterior al Alta. ', '05', '01', '02'),
    ('181', 'Se ha realizado un cambio de comercializador en el CUPS solicitado posterior al Alta.', '05', '01', '02'),
    ('182', 'No existe una solicitud de "@replace1@" previa del Suministrador Actual que haya sido formalizada para el CUPS solicitado', '05', '01', '02'),
    ('184', 'En el CUPS solicitado se ha realizado un Cambio de Comercializadora posterior en el que el Comercializador Entrante/Saliente no es el Comercializador solicitante "@replace1@"', '05', '01', '02'),
    ('186', 'No existe una solicitud de Alta previa del Suministrador Actual que haya sido formalizada para el CUPS solicitado', '05', '01', '02'),
    ('187', 'El Suministrador Actual ha realizado un Cambio de Comercializadora en el CUPS solicitado posterior al Alta.', '05', '01', '02'),
    ('188', 'El Suministrador Actual no es la empresa titular del contrato ATR en vigor para el CUPS solicitado.', '05', '01', '02'),
    ('192', 'El CUPS "@replace2@" no corresponde con la solicitud "@replace1@" enviada en el mensaje C6', '05', '01', '02'),
    ('193', 'El código de solicitud "@replace1@" no ha sido enviado en un mensaje C6.', '05', '01', '02'),
    ('194', 'El nº de documento "@replace2@" no corresponde con la solicitud "@replace1@" enviada en el mensaje C6', '05', '01', '02'),
    ('195', 'Si el resultado es diferente de Realizado, el motivo es obligatorio.', '05', '01', '02'),
    ('196', 'Si el resultado es 06-Realizada, los datos Qd, Qh, Fecha Efecto e Indicador de Tipo de Nominación son obligatorios.', '05', '01', '02'),
    ('197', 'El motivo debe ser nulo si el resultado es 09 -Realizada', '05', '01', '02'),
    ('199', 'La solicitud que se intenta anular no está formalizada.', '05', '01', '02'),
    ('200', 'El sujeto (código ERM) "@replace1@" ', '05', '02'),
    ('201', 'El sujeto (código) "@replace1@" existe, pero está dado de baja para el periodo de fechas enviado.', '05', '02'),
    ('202', 'El sujeto (código) no es un grupo empresarial o no es el grupo empresarial propietario del SCTD.', '05', '02'),
    ('203', 'El punto de conexión (código ERM) "@replace1@" no existe.', '05', '02'),
    ('204', 'El propietario de la red de alimentación: "@replace1@" no coincide con la distribuidora: "@replace2@".', '05', '02'),
    ('206', 'El sujeto (código) "@replace1@" no es una comercializadora ', '05', '02'),
    ('207', 'El punto de suministro (código CUPS) "@replace1@" no existe.', '05', '02'),
    ('208', 'El contrato correspondiente para el CUPS "@replace1@" y el comercializador "@replace2@" no existe o no está vigente.', '05', '02'),
    ('209', 'No existe la versión : "@replace1@" para el tipo de fichero : B8.', '05', '02'),
    ('210', 'No existe la versión : "@replace1@" para el tipo de fichero : B7.', '05', '02'),
    ('211', 'La(s) fecha(s) de lectura no es(son) anterior(es) a la del sistema.', '05', '02'),
    ('212', 'La fecha final de consumo debe ser posterior a la fecha inicial de consumo.', '05', '02'),
    ('213', 'El valor del indicador cambio contador tiene que ser 0 ó 1.', '05', '02'),
    ('214', 'El valor del indicador cambio corrector tiene que ser 0 ó 1', '05', '02'),
    ('215', 'El valor del indicador de tipo de lectura ', '05', '02'),
    ('216', 'El valor del indicador de tipo de lectura corregida del corrector tiene que ser 0 ó 1.', '05', '02'),
    ('217', 'El valor del indicador de cambio de UR tiene que ser 0 ó 1.', '05', '02'),
    ('218', 'El valor del indicador de tipo de lectura bruta de UR tiene que ser 0 ó 1.', '05', '02'),
    ('219', 'El valor del indicador de tipo de lectura corregida de UR tiene que ser 0 ó 1.', '05', '02'),
    ('220', 'El valor del indicador de tipo de lectura del contador tiene que ser 0,1 ó 2.', '05', '02'),
    ('221', 'La medida o regularización enviada afecta a un periodo ya ocupado del punto de conexión o de suministro "@replace1@".', '05', '02'),
    ('222', 'El intervalo de fechas afecta a un periodo no contratado o bien a un periodo con más de un contrato vigente.', '05', '02'),
    ('223', 'Qh ha de ser positivo en caso de especificarse', '05', '01', '02'),
    ('224', 'No existe ningún contrato vigente para el cups "@replace1@" en la fecha "@replace2@"', '05', '01', '02'),
    ('225', 'Si la solicitud es una solicitud de cambio, la empresa saliente es obligatoria', '05', '01', '02'),
    ('226', 'Si el resultado no es 12-Validada, no se pueden enviar los datos referenciales.', '05', '01', '02'),
    ('227', 'El motivo debe ser nulo si el resultado es 05-Aceptada', '05', '01', '02'),
    ('228', 'El CUPS "@replace2@" no corresponde con la solicitud "@replace1@" enviada en el mensaje C1', '05', '01', '02'),
    ('229', 'El nº de documento "@replace2@" no corresponde con la petición "@replace1@" enviada en el mensaje C1.', '05', '01', '02'),
    ('230', 'Registro duplicado en medida o reparto (ERMs) para DATA_ID : "@replace1@" y COD_USUARIO : "@replace2@ . Actualización de la medida.', '05', '02'),
    ('231', 'Registro duplicado en medida o reparto (CUPS) para DATA_ID : "@replace1@" y COD_USUARIO : "@replace2@ . Actualización de la medida.', '05', '02'),
    ('232', 'Modificación de medida no admitida. Medida original inexistente o de fechas de lectura distintas.', '05', '02'),
    ('233', 'Fallo en la obtención de registros de las tablas temporales de medidas', '05', '02'),
    ('234', 'El tipo de mensaje enviado no es correcto.', '05', '02'),
    ('235', 'El código de proceso enviado no es correcto.', '05', '02'),
    ('236', 'El valor del campo "@replace1@" no existe en la lista de valores permitidos "@replace2@".', '05', '02'),
    ('237', 'Error de formato o integridad en la cabecera. Fichero @replace1@ rechazado. ', '05', '02'),
    ('238', 'La fecha de inicio de consumo es posterior a la ', '05', '02'),
    ('239', 'El código del envío no es GML.', '05', '02'),
    ('240', 'El valor del indicador de regularización tiene que ser 0 ó 1.', '05', '02'),
    ('241', '"@replace1@" no es una red de distribución', '05', '02'),
    ('242', '"@replace1@" no es un municipio', '05', '02'),
    ('243', 'El registro no contiene ni la red de distribución ni el municipio de ubicación', '05', '02'),
    ('244', '"@replace1@" no es un tipo de cliente para este tipo de mensaje y código de proceso.', '05', '02'),
    ('245', 'Se ha producido un error en la inserción del mensaje de Repartos.', '05', '01', '02'),
    ('246', 'El periodo "@replace1@" no es válido en un mensaje de tipo @replace2@.', '05', '02'),
    ('247', 'No existe la versión : "@replace1@" para el tipo de fichero : C12.', '05', '02'),
    ('248', 'El código de la empresa emisora no es de un transportista.', '05', '02'),
    ('249', 'El valor del indicador de regularización tiene que ser "N" o "S".', '05', '02'),
    ('250', 'La empresa emisora (código) "@replace1@" está dada de baja.', '05', '02'),
    ('251', 'La empresadestino (código) "@replace1@" está dada de baja.', '05', '02'),
    ('252', 'El código de la empresa destino no es de un grupo empresarial.', '05', '02'),
    ('253', 'La empresa destino (código) "@replace1@" ', '05', '02'),
    ('254', 'La distribuidora (código) "@replace1@" no pertenece al grupo propietario del SCTD ', '05', '02'),
    ('255', 'Las fechas de consumo son posteriores a la fecha del sistema.', '05', '02'),
    ('256', 'La red no es el punto de conexión (directo) de la red de distribución con la red de transporte ', '05', '02'),
    ('257', 'Los consumos no pueden ser negativos', '05', '02'),
    ('258', 'La red de distribución "@replace1@" no pertenece al sujeto propietario del SCTD.', '05', '02'),
    ('259', 'Las fechas de consumo deben ser anteriores al mes actual', '05', '02'),
    ('260', 'Las fechas de consumo deben ser anteriores al día actual', '05', '02'),
    ('261', 'El código de envió debe ser "GML"', '05', '02'),
    ('262', 'La empresa "@replace1@" no existe o está dada de baja.', '05', '02'),
    ('263', 'El código de la empresa emisora no es de un grupo empresarial.', '05', '02'),
    ('264', 'El código de solicitud "@replace1@" ha sido enviado en un mensaje B4', '05', '01', '02'),
    ('265', 'No se envió un C1 para este código de solicitud', '05', '01', '02'),
    ('267', 'Se han de enviar la red o el municipio de ', '05', '01'),
    ('268', 'Ha de enviarse la red de distribución o el municipio, pero no ambos', '05', '01'),
    ('272', 'No existen contratos para estimar repartos de la comercializadora "@replace1@" con indicador de planta "@replace2@"', '05', '01'),
    ('273', 'No existe ningún contrato en estado de Baja Administrativa para el cups "@replace1@" en la fecha "@replace2@".', '05', '01', '01'),
    ('300', 'La empresa distribuidora "@replace1@" no corresponde con la solicitud "@replace2@" enviada en el mensaje C1', '05', '01', '02'),
    ('301', 'La empresa transportista "@replace1@" no corresponde con la solicitud "@replace2@" enviada en el mensaje C1', '05', '01', '02'),
    ('302', 'El código de solicitud "@replace1@" no ha sido enviado al transportista.', '05', '01', '02'),
    ('303', 'El tipo de solicitud "@replace1@" no se corresponde con el de la solicitud enviada', '05', '01', '02'),
    ('304', 'La posición del transportista "@replace1@" no se corresponde con el de la solicitud "@replace2@" enviada', '05', '01', '02'),
    ('305', 'El resultado "@replace1@" no esta definido como respuesta de validación del transportista.', '05', '01', '02'),
    ('306', 'El motivo "@replace1@" no es válido para el resultado "@replace2@" y Transportista.', '05', '01', '02'),
    ('307', 'El qd es obligatorio si p> 4 bares y el resultado es "Aceptada".', '05', '01', '02'),
    ('308', 'El qh es obligatorio para p>4 bares y si el resultado es \'Aceptada\'.', '05', '01', '02'),
    ('309', 'El nuevo qd es obligatorio, puesto que el motivo de modificación implicaba un cambio de capacidad.', '05', '01', '02'),
    ('310', 'El nuevo qh es obligatorio, puesto que el motivo de modificación implicaba un cambio de capacidad.', '05', '01', '02'),
    ('311', 'No existe la versión : "@replace1@" para el tipo de fichero : C13.', '05', '02'),
    ('312', 'El valor del indicador de regularización tiene que ser "0" ó "1".', '05', '02'),
    ('313', 'La línea de medida (código) "@replace1@" no existe para la posición "@replace2@".', '05', '02'),
    ('314', 'La medida enviada afecta a un periodo ya ocupado.', '05', '02'),
    ('315', 'El campo CODIGORED es obligatorio.', '05', '02'),
    ('316', 'El campo "@replace1@" sólo admite valores positivos.', '05', '02'),
    ('317', 'El grupo empresarial (código) "@replace1@" no es propietario del SCTD ', '05', '02'),
    ('318', 'La red de distribución (código) "@replace1@" no pertenece a ninguna sociedad del grupo.', '05', '02'),
    ('319', 'La hora de "@replace1@" tiene que estar comprendida entre 0 y 23.', '05', '01', '02'),
    ('320', 'Los minutos de "@replace1@" tienen que estar comprendidos entre 0 y 59.', '05', '01', '02'),
    ('321', 'Los segundos de "@replace1@" tienen que estar comprendidos entre 0 y 59.', '05', '01', '02'),
    ('322', 'Error de formato', '05', '01'),
    ('330', 'El peaje "@replace1@"contratado no pertenece al grupo 3.', '05', '01', '02'),
    ('331', 'El valor del campo "ESTIMATEDALLOCATION" tiene que ser "S" ó "N".', '05', '01', '02'),
    ('500', 'Los campos "Fecha de última inspección" y "Resultado de última inspección" deben estar rellenos para Solicitud de Anulación de Alta con resultado 07 (Rechazo Parcial).', '05', '01', '02'),
    ('501', 'Los campos "Fecha de última inspección" y "Resultado última inspección" solo se deben enviar en Solicitud de Anulación de Alta con resultado 07(Rechazo Parcial).', '05', '01', '02'),
    ('503', 'La solicitud "@replace1@" está recibida en un mensaje C8.', '05', '01', '02'),
    ('504', 'El código de solicitud "@replace1@" no ha sido enviado en un mensaje C7.', '05', '01', '02'),
    ('505', 'Si el resultado es 06-Realizada, la Fecha Efecto es obligatoria.', '05', '01', '02'),
    ('506', 'El documento ', '05', '01', '02'),
    ('507', 'Se ha realizado una baja en el CUPS solicitado posterior a la solicitud que intenta anular.', '05', '01', '02'),
    ('508', 'Se ha realizado un alta en el CUPS solicitado posterior a la solicitud que intenta anular.', '05', '01', '02'),
    ('509', 'El código de solicitud "@replace1@" ya ha sido enviado en un mensaje C8.', '05', '01', '02'),
    ('510', 'No se ha encontrado la operación que se ha respondido.', '05', '02'),
    ('511', 'Programación semanal incompleta en la red "@replace1@".', '05', '02'),
    ('512', 'El día de gas debe pertenecer a una semana de gas futura', '05', '02'),
    ('514', 'Para la red "@replace1@" no hay ningún contrato ATR ', '05', '02'),
    ('515', 'No hay ningún contrato vigente para el CUPS "@replace1@" en la fecha "@replace2@".', '05', '02'),
    ('516', 'No existe contrato ATR en vigor en la fecha "@replace1@".', '05', '01', '02'),
    ('517', 'El caudal máximo horario debe ser nulo', '05', '02'),
    ('518', 'La red, el municipio y el cups no pueden ser nulos simultáneamente', '05', '02'),
    ('519', 'Ya existe una nominación para esta semana de gas', '05', '02'),
    ('520', 'La tarifa contratada tiene que ser 3.1, 3.2 o 3.3', '05', '02'),
    ('521', 'No hay ninguna red asociada al municipio "@replace1@".', '05', '02'),
    ('522', 'Para el municipio "@replace1@" no hay ningún contrato ATR en vigor en esta semana de gas', '05', '02'),
    ('523', 'El día de gas de la nominación debe ser "@replace1@" de acuerdo con la hora de recepción.', '05', '02'),
    ('524', 'El día de gas no pertenece a la semana siguiente a la actual', '05', '02'),
    ('525', 'El sujeto (código) "@replace1@" no es una comercializadora, Cliente Cualificado o Grupo Empresarial', '05', '02'),
    ('526', 'La predicción global debe ser nula en sujetos comercializadores o clientes cualificados.', '05', '02'),
    ('527', 'El caudal ATR > 4bar y el caudal máximo horario deben ser nulos en sujetos distribuidores.', '05', '02'),
    ('528', 'El valor Caudal ATR > 4 bar debe ser mayor o igual que el Caudal Máximo Horario.', '05', '02'),
    ('529', 'Programación semanal incompleta en el municipio "@replace1@".', '05', '02'),
    ('530', 'Programación semanal incompleta en el CUPS "@replace1@".', '05', '02'),
    ('531', 'El día "@replace1@" está repetido para la semana de gas de la red "@replace2@".', '05', '02'),
    ('532', 'El día "@replace1@" está repetido para la semana de gas del municipio "@replace2@".', '05', '02'),
    ('533', 'El día "@replace1@" está repetido para la semana de gas del CUPS "@replace2@".', '05', '02'),
    ('534', 'No se ha encontrado el registro enviado al que hace referencia la respuesta de viabilidad.', '05', '02'),
    ('535', 'En redes secundarias no se puede modificar la predicción global.', '05', '02'),
    ('536', 'Semana de gas con días erróneos', '05', '02'),
    ('537', 'No se puede modificar la predicción global por haberse modificado el caudal ATR de los comercializadores.', '05', '02'),
    ('538', 'No se puede modificar el caudal ATR de los comercializadores por haberse modificado la predicción global.', '05', '02'),
    ('539', 'Error en cabecera de programación semanal: "@replace1@".', '05', '02'),
    ('540', 'Programación semanal incompleta o fechas incorrectas en mensaje @replace1@.', '05', '02'),
    ('541', 'Las fechas de la programación semanal no son correctas.', '05', '02'),
    ('542', 'El indicador de tipo de nominación debe ser "S"', '05', '01', '02'),
    ('543', 'El CUPS "@replace1@" no existe.', '05', '02'),
    ('544', 'Para el CUPS "@replace1@" no hay ningún contrato ATR en vigor en esta semana de gas', '05', '02'),
    ('545', 'La tarifa contratada tiene que ser del grupo 1 ó 2', '05', '02'),
    ('546', 'Si el usuario es un CC sólo puede programar para el CUPS que tenga contratado.', '05', '02'),
    ('547', 'El caudal máximo horario es obligatorio.', '05', '02'),
    ('548', 'El indicador de tipo de nominación debe ser "S", "N" ó "A"', '05', '01', '02'),
    ('549', 'Si el indicador de tipo de nominación es "S" la red de ubicación debe ser una red dada de alta y el tipo de peaje debe ser 3.5 o pertenecer a los grupos 1, 2 ó 4', '05', '01', '02'),
    ('550', 'Si el indicador de tipo de nominación es "N", la red de ubicación debe ser un municipio-red dado de alta y el tipo de peaje pertenecer al grupo 3 (excepto el peaje 3.5)', '05', '01', '02'),
    ('551', 'La empresa emisora del cambio ("@replace1@") no puede ser la titular del contrato ATR para el CUPS solicitado.', '05', '01', '02'),
    ('552', 'Se ha sobrepasado la hora límite de recepción del fichero @replace1@.', '05', '02'),
    ('553', 'Solo una de las cantidades MR puede estar rellena.', '05', '02'),
    ('554', 'Al menos una de las cantidades MR debe estar rellena.', '05', '02'),
    ('555', 'Si la presión de la red es mayor de 4 bar, la cantidad MR de presión baja no debe rellenarse', '05', '02'),
    ('556', 'Si la presión de la red es menor de 4 bar, la cantidad MR de presión alta no debe rellenarse', '05', '02'),
    ('557', 'El PCDD "@replace1@" no existe.', '05', '02'),
    ('558', 'Programación semanal incompleta en el PCDD "@replace1@".', '05', '02'),
    ('559', 'El día "@replace1@" está repetido para la semana de gas del PCDD "@replace2@".', '05', '02'),
    ('560', 'El motivo "@replace1@" no es válido para el resultado "@replace2@". ', '05', '01', '02'),
    ('561', 'Desde esta pantalla sólo se admiten envíos de ficheros de @replace1@.', '05', '02'),
    ('562', 'La fecha de la nominación no es correcta.', '05', '02'),
    ('563', 'El caudal ATR >4bar no debe ser nulo en sujetos comercializadores o clientes cualificados.', '05', '02'),
    ('564', 'La predicción global no debe ser nula para el propietario del SCTD.', '05', '02'),
    ('565', 'El punto "@replace1@" no es un punto de conexión aguas arriba con el distribuidor externo "@replace2@".', '05', '02'),
    ('566', 'El punto "@replace1@" no pertenece a un camino de la red de transporte del sujeto "@replace2@".', '05', '02'),
    ('567', 'No se pueden modificar cantidades si el resultado es 01-Aceptada.', '05', '02'),
    ('568', 'Si el caudal máximo horario es cero, el caudal diario también tiene que ser cero.', '05', '02'),
    ('569', 'El caudal máximo horario no puede superar al ', '05', '02'),
    ('570', 'La fecha límite de envío se ha sobrepasado.', '05', '02'),
    ('571', 'El caudal máximo horario debe ser @replace1@ en el mensaje C16 por ser @replace1@ en el correspondiente mensaje C15.', '05', '02'),
    ('572', 'El día de gas es anterior a la fecha de envió.', '05', '02'),
    ('573', 'Si el resultado es 12-Validada, el campo Qa es obligatorio.', '05', '01', '02'),
    ('574', 'La red no pertenece a la empresa emisora', '05', '01', '02'),
    ('575', 'El punto "@replace1@" no es un punto de conexión aguas abajo con el distribuidor externo "@replace2@".', '05', '02'),
    ('576', 'Error en cabecera de nominación: "@replace1@".', '05', '02'),
    ('577', 'La empresa emisora (código) "@replace1@" ', '05', '02'),
    ('578', 'No existe Programación Semanal correspondiente. Nominación rechazada.', '05', '02'),
    ('579', 'La empresa emisora debe tener conexión aguas arriba con alguna red del grupo propietario del SCTD.', '05', '02'),
    ('581', 'La red, el municipio y el cups no se pueden enviar simultáneamente', '05', '02'),
    ('582', 'El cups "@replace1@" debe ser Nominado/Programado por red.', '05', '02'),
    ('583', 'El cups "@replace1@" debe ser Nominado/Programado por municipio.', '05', '02'),
    ('584', 'El cups "@replace1@" no está asociado al sujeto "@replace2@"', '05', '02'),
    ('585', 'El municipio "@replace1@" no está asociado al sujeto "@replace2@"', '05', '02'),
    ('586', 'La red "@replace1@" no está asociada al sujeto "@replace2@"', '05', '02'),
    ('587', 'El municipio de ubicación "@replace1@" tiene que estar asociado a una red.', '05', '01', '01'),
    ('589', 'El suministrador "@replace1@" de la solicitud no se corresponde con el suministrador actual.', '05', '01'),
    ('590', 'El tipo de proceso "@replace1@" no se corresponde con ningún proceso de ejecución manual.', '05', '01', '02'),
    ('591', 'Se ha producido un error durante la ejecución manual de procesos de Contratación.', '05', '01', '02'),
    ('592', 'Se ha producido un error durante la ejecución manual del proceso de Registro de Punto de Suministro.', '05', '01', '02'),
    ('593', 'Se ha producido un error durante la ejecución manual de procesos de Medidas y Repartos.', '05', '01', '02'),
    ('594', 'El tipo de mensaje "@replace1@" no corresponde a B12.', '05', '01', '02'),
    ('595', 'El proceso "@replace1@" no corresponde a Actualización de datos de Contrato ATR.', '05', '01', '02'),
    ('596', 'El proceso "@replace1@" no existe.', '05', '01', '02'),
    ('597', 'La categoría de sujeto "@replace1@" no existe.', '05', '01', '02'),
    ('598', 'La categoría de sujeto "@replace1@" no es válida en un fichero B12.', '05', '01', '02'),
    ('599', 'No existe contrato ATR para el cups "@replace1@" y sujeto "@replace2@".', '05', '01', '02'),
    ('600', 'Fallo en la obtención de registros de las tablas temporales de modificación de datos de Contratos ATR.', '05', '01', '02'),
    ('601', 'El código de modificación "@replace1@" ya existe.', '05', '01', '02'),
    ('602', 'La empresa "@replace1@" no es una distribuidora o grupo empresarial.', '05', '01', '01'),
    ('603', 'La empresa "@replace1@" no es un transportista.', '05', '01', '02'),
    ('604', 'La empresa "@replace1@" no es el Grupo Empresarial ni una Sociedad del Grupo Empresarial propietario del SCTD.', '05', '01', '02'),
    ('605', 'El proceso "@replace1@" no es válido para el proceso de Repartos que se quiere realizar.', '05', '01', '02'),
    ('606', 'El tipo de mensaje "@replace1@" no es válido para el proceso de Repartos que se quiere realizar.', '05', '01', '02'),
    ('607', 'No existe ningún contrato ATR en vigor para la comercializadora "@replace1@".', '05', '01', '02'),
    ('608', 'No existe ningún contrato ATR en vigor para la comercializadora "@replace1@" cuyo CUPS asociado esté situado aguas abajo del PCTD o PCDD "@replace2@".', '05', '01', '02'),
    ('609', 'El indicador de Regularización debe ser "S" o "N".', '05', '01', '02'),
    ('610', 'Fallo en la obtención de registros de las tablas temporales de recepción de repartos ATR del Transportista.', '05', '01', '02'),
    ('611', 'La empresa "@replace1@" no es una comercializadora ni cliente cualificado.', '05', '01', '02'),
    ('612', 'La Red de Distribución no existe o el Municipio no tiene conexión con una Red de Distribución.', '05', '01', '02'),
    ('613', 'Ya existe una Actualización de Contrato ATR con el código "@replace1@".', '05', '01', '02'),
    ('614', 'El consumo anual y la tarifa de peaje no pueden ser nulos en la Actualización "@replace1@".', '05', '01', '02'),
    ('615', 'El tipo de gas "@replace1@" no es válido. Debe ser GNC o GNL.', '05', '01', '02'),
    ('616', 'El tipo de factura "@replace1@" no es válido.', '05', '01', '02'),
    ('617', 'La moneda "@replace1@" no existe.', '05', '01', '02'),
    ('618', 'La forma de pago "@replace1@" no existe.', '05', '01', '02'),
    ('619', 'La Comunidad Autónoma "@replace1@" no existe.', '05', '01', '02'),
    ('620', 'La planta de GNL "@replace1@" no existe.', '05', '01', '02'),
    ('621', 'El código de posición del Transportista "@replace1@" no existe.', '05', '01', '02'),
    ('622', 'No se han encontrado datos que procesar.', '05', '01', '02'),
    ('623', 'No existe mensaje C10 para la posición "@replace1@, inicioconsumo "@replace2@", finconsumo "@replace3@", fecha comunicación "@replace4@", hora comunicación "@replace5@" ', '05', '01', '02'),
    ('624', 'No se pueden recibir confirmaciones de repartos. La fecha de hoy no se encuentra comprendida entre el primer día y el último de recepción de mensajes C18.', '05', '01', '02'),
    ('625', 'El sujeto @replace2@"@replace1@" no existe.', '05', '01', '02'),
    ('626', 'El Municipio "@replace1@" no existe.', '05', '01', '02'),
    ('629', 'El nuevo peaje no puede coincidir con el peaje actual del contrato.', '05', '01', '02'),
    ('631', 'El peaje actual no pertenece al grupo 3.', '05', '01', '02'),
    ('633', 'Si no se está realizando un cambio de titular los campos Nuevo Nombre Cliente, Nuevo Apellido1/Razón Social, Nuevo Apellido2, Teléfono, Fax y Email debe ser nulos.', '05', '01', '02'),
    ('634', 'El contrato correspondiente para el CUPS "@replace1@" y nº de documento "@replace2@" no existe o no está vigente.', '05', '01', '02'),
    ('635', 'El comercializador/CC "@replace1@" no se corresponde con el suministrador actual del contrato en vigor para el CUPS "@replace2@".', '05', '01', '02'),
    ('636', 'La fecha de inspección no puede ser posterior a la fecha actual.', '05', '01', '02'),
    ('637', 'El estado de la inspección "@replace1@" no es válido.', '05', '01', '02'),
    ('638', 'El código de defecto "@replace1@" no existe.', '05', '01', '02'),
    ('639', 'El resultado "@replace1@" debe ser 12-Validada.', '05', '01', '02'),
    ('640', 'No existe una solicitud en curso que pueda ser anulada para el CUPS "@replace1@" y Comercializador/CC "@replace2@".', '05', '01', '02'),
    ('641', 'El grupo del nuevo peaje "@replace1@" no coincide con el grupo de peaje del contrato.', '05', '01', '02'),
    ('642', 'Los campos nuevo nombre, nuevo apellido 2, nuevo teléfono, nuevo email y nuevo fax deben ir vacíos si no se envían los campos Nuevo Num. Documento y Nuevo Apellido1/Razón Social para el cambio de titular.', '05', '01', '02'),
    ('643', 'Existe una solicitud previa del tipo alta para el CUPS "@replace1@" de otra Comercializadora.', '05', '01', '02'),
    ('644', 'Existe una solicitud previa del tipo baja para el CUPS "@replace1@" de otra Comercializadora.', '05', '01', '02'),
    ('645', 'Existe una solicitud previa del tipo cambio de comercializadora para el CUPS "@replace1@" de otra Comercializadora.', '05', '01', '01'),
    ('646', 'Existe una solicitud previa del tipo modificación ', '05', '01', '01'),
    ('647', 'Existe una solicitud previa del tipo anulación para el CUPS "@replace1@" de otra Comercializadora.', '05', '01', '02'),
    ('649', 'El tipo de Reparto "@replace1@" no es correcto.', '05', '01', '02'),
    ('650', 'Se debe enviar uno de los dos campos: Red o Municipio.', '05', '01', '02'),
    ('651', 'Si el tipo de Reparto es Provisional, el código de Proceso debe ser "09-Reparto ATR".', '05', '01', '02'),
    ('656', 'No se ha encontrado ningún dato de repartos agregados (B14) para la comercializadora "@replace1@", indicador planta "@replace3@" y día "@replace2@".', '05', '01', '02'),
    ('657', 'El indicador de regularización no se corresponde con el código de proceso (N -> 09; S -> 11).', '05', '01', '02'),
    ('659', 'El tipo de compañía responsable debe ser distribuidora o transportista', '05', '01', '02'),
    ('660', 'En caso de Tipo Documento 01 (DNI) o 03 (pasaporte) hay que enviar el Nombre del cliente', '05', '01', '02'),
    ('661', 'Si el tipo de peaje es 3.5 o pertenece a los grupos 1, 2 ó 4, hay que especificar el Qd concedido', '05', '01', '02'),
    ('662', 'Si el tipo de peaje pertenece es 3.5 o a los grupos 1,2 ó 4, hay que especificar el Qh concedido', '05', '01', '02'),
    ('663', 'Si el tipo de peaje pertenece al grupo 1, hay que especificar la red de transporte', '05', '01', '02'),
    ('664', 'Si el tipo de peaje pertenece al grupo 1, ha de indicar el código del transportista', '05', '01', '02'),
    ('665', 'Error interno del sistema.', '05', '01', '02'),
    ('666', 'El código de envió "@replace1@" no es válido.', '05', '01', '02'),
    ('667', 'Existe un contrato vigente para el cups "@replace1@" en la fecha "@replace2@"', '05', '01', '01'),
    ('668', 'Existe un contrato de presión mayor de 16 bares vigente para el cups "@replace1@" en la fecha "@replace2@"', '05', '01', '02'),
    ('669', 'No existe un contrato vigente del tipo especificado para el cups "@replace1@" en la fecha "@replace2@"', '05', '01', '01'),
    ('670', 'No existe el punto de suministro "@replace1@" para contratos ATR de presión menor o igual a 16 bares', '05', '01', '02'),
    ('671', 'El cliente con número de documento "@replace1@" no tiene contrato vigente con el cups "@replace2@" en la fecha efecto indicada', '05', '01', '02'),
    ('672', 'El municipio "@replace1@" no está gestionado por la distribuidora "@replace2@"', '05', '01', '02'),
    ('673', 'El tipo de lectura debe ser E o R', '05', '01', '02'),
    ('674', 'El indicador de planta del fichero B14 no coincide con el de la tabla de red para el sujeto "@replace1@" en el punto "@replace2@".', '05', '01', '02'),
    ('675', 'El tipo de reparto 5 (provisional) no es válido para el proceso "@replace1@" que se quiere realizar.', '05', '01', '02'),
    ('676', 'Para el tipo de reparto 5 (provisional) el periodo de consumo debe estar dentro del mes anterior al actual.', '05', '01', '02'),
    ('677', 'Para el tipo de reparto 4 (definitivo) con código de proceso 11, el periodo de consumo debe ser anterior al mes que precede al actual.', '05', '01', '02'),
    ('678', 'En caso de que la compañía responsable sea transportista, ha de indicar el número de póliza del cliente', '05', '01', '02'),
    ('679', 'Si se envían datos de cliente, han de enviarse todos', '05', '01', '02'),
    ('680', 'El indicador de comunicación ha de ser S o N', '05', '01', '02'),
    ('681', 'La solicitud de alta para el cups "@replace2@" es de otra comercializadora distinta a "@replace1@"', '05', '01', '02'),
    ('683', 'La solicitud de baja para el cups "@replace2@" es de otra comercializadora distinta a "@replace1@"', '05', '01', '02'),
    ('684', 'La solicitud de modificación para el cups "@replace1@" es de otra comercializadora distinta a "@replace2@"', '05', '01', '02'),
    ('685', 'El campo propiedad ha de ser S o N', '05', '01', '02'),
    ('686', 'Si la petición es aceptada el campo "@replace1@" no puede ser nulo', '05', '01', '02'),
    ('687', 'Ya existen datos en la tabla T_GNR_LISTADORPS para el cups "@replace1@".', '05', '01', '02'),
    ('688', 'No está dado de alta el sistema "@replace1@" en la tabla T_MAE_SISTEMA.', '05', '01', '02'),
    ('689', 'El sistema "@replace1@" no pertenece al GRE propietario ni a ninguna de sus sociedades distribuidoras.', '05', '01', '02'),
    ('690', 'Si la petición no es aceptada el campo "@replace1@" ha de ser nulo', '05', '01', '02'),
    ('691', 'El resultado de última revisión "@replace1@" no es válido', '05', '01', '02'),
    ('692', 'El perfil consumo "@replace1@" no existe', '05', '01', '02'),
    ('693', 'La empresa en la que está dado de alta el cliente "@replace1@" no es de ninguna categoría correcta (COM, CC, DIS, GRE)', '05', '01', '02'),
    ('694', 'Si la presión es mayor que 4 bares, debe indicarse el caudal máximo diario contratado ', '05', '01', '02'),
    ('695', 'El motivo no pertenece a SSPP', '05', '01', '02'),
    ('696', 'El valor del Motivo no corresponde con el Resultado introducido', '05', '01', '02'),
    ('697', 'El proceso @replace1@ no corresponde a Listado RPS', '05', '01', '02'),
    ('698', 'El tipo de mensaje debe ser B50 y no @replace1@.', '05', '01', '02'),
    ('699', 'El sistema @replace1@ está dado de alta en la tabla T_MAE_SISTEMA pero no es del tipo 02.', '05', '01', '02'),
    ('700', 'El motivo no pertenece al SCTD y tampoco es el recibido en el B6', '05', '01', '02'),
    ('701', 'El sistema @replace1@ no corresponde a la empresa destino @replace2@.', '05', '01', '02'),
    ('702', 'El indicador de bloqueo debe ser S o N', '05', '01', '02'),
    ('703', 'Hora de bloqueo no válida', '05', '01', '02'),
    ('704', 'El sujeto emisor debe tener un sistema asociado', '05', '01', '02'),
    ('705', 'Es obligatorio recibir la carta antes de aceptar una petición', '05', '01', '02'),
    ('706', 'El código de petición "@replace1@" ', '05', '01', '02'),
    ('707', 'Si la carta ha sido recibida, no puede rechazar la petición por no haber recibido la carta', '05', '01', '02'),
    ('708', 'Se ha producido un error durante la ejecución manual del proceso de respuesta de peticiones (A607 erróneas y A630)', '05', '01', '02'),
    ('709', 'El resultado "@replace1@" no existe', '05', '01', '02'),
    ('710', 'Existe una petición sin responder para el CUPS "@replace1@"', '05', '01', '02'),
    ('711', 'La red "@replace1@" no existe', '05', '01', '02'),
    ('712', 'No existe el punto de suministro "@replace1@" para contratos ATR de presión mayor de 16 bares', '05', '01', '02'),
    ('713', 'En caso de que la compañía responsable sea distribuidora, no ha de indicar la referencia del cliente ', '05', '01', '02'),
    ('714', 'Petición de registro de puntos de suministro rechazada', '05', '01', '02'),
    ('715', 'No se ha especificado ruta para el sistema destino de peticiones B5 erróneas (parámetro 54)', '05', '01', '02'),
    ('716', 'No se puede crear fichero "@replace1@". Revise si existe la carpeta y está en el parámetro ORACLE utl_file_dir', '05', '01', '02'),
    ('717', 'No existe el sistema especificado en el parámetro 54', '05', '01', '02'),
    ('718', 'En caso de que la compañía responsable sea transportista, la red de ubicación no puede ser un municipio', '05', '01', '02'),
    ('719', 'En caso de que la compañía responsable sea transportista, el sujeto transportista es obligatorio', '05', '01', '02'),
    ('720', 'En caso de que la compañía responsable sea transportista, la red de transporte es obligatoria', '05', '01', '02'),
    ('721', 'En caso de que la compañía responsable sea distribuidora, no se puede enviar el sujeto ', '05', '01', '02'),
    ('722', 'En caso de que la compañía responsable sea distribuidora, no se puede enviar la red de transporte', '05', '01', '02'),
    ('723', 'Existe un contrato para el cups "@replace1@" posterior a la fecha "@replace2@"', '05', '01', '02'),
    ('724', 'Existe un contrato de presión mayor de 16 bares para el cups "@replace1@" posterior a la fecha "@replace2@"', '05', '01', '02'),
    ('725', 'En caso de que la compañía responsable sea transportista, no se puede enviar el indicador de cálculo estimado de reparto (estimatedallocation)', '05', '01', '02'),
    ('726', 'En caso de que la compañía responsable sea distribuidora, el indicador de cálculo estimado de reparto (estimatedallocation) es obligatorio', '05', '01', '02'),
    ('727', 'La comunicación de cambio debe de ser de una comercializadora distinta a la del contrato vigente', '05', '01', '01'),
    ('728', 'La fecha efecto del contrato "@replace1@" no puede ser posterior a la fecha de fin del mismo "@replace2@"', '05', '01', '02'),
    ('729', 'El mes "@replace1@" no existe', '05', '01', '02'),
    ('730', 'La red de transporte "@replace1@" no existe', '05', '01', '02'),
    ('731', 'No se han especificado todos los directorios de salida de ficheros B529 para el sistema "@replace1@"', '05', '01', '02'),
    ('732', 'Se ha superado el número máximo permitido de peticiones de datos de RPS (batch) diarias correctas', '05', '01', '02'),
    ('733', 'Se ha superado el número máximo permitido de peticiones de datos de consumidor (batch) diarias correctas', '05', '01', '02'),
    ('734', 'Se ha superado el número máximo permitido de peticiones de datos de consumidor (batch) en el mismo fichero', '05', '01', '02'),
    ('735', 'No se dispone de carta de conformidad del cliente para la publicación de datos', '05', '01', '02'),
    ('737', 'Se ha recibido solicitud de alta de distribuidor para el mismo CUPS', '05', '01', '02'),
    ('738', 'Se ha recibido solicitud de cambio de distribuidor para el mismo CUPS', '05', '01', '02'),
    ('750', 'El valor @replace1@ no existe en el maestro de @replace2@', '05', '01', '02'),
    ('751', 'No existe mensaje A1 para la solicitud @replace1@', '05', '01', '02'),
    ('752', 'El código CAE (@replace1@) debe ser nulo si el Tipo Uso de Gas es diferente de "03" ', '05', '01', '02'),
    ('801', 'Si la presión solicitada es mayor de 4 bares o el peaje es 3.5 es obligatorio que el campo QD tenga un valor', '05', '02', '02'),
    ('803', 'Suministro a Presión superior a 16 bares. Debe presentarse la solicitud a través el transportista', '05', '02', '02'),
    ('804', 'Nuevo Caudal Horario debe ser menor o igual que Caudal Horario Actual', '05', '01', '02'),
    ('806', 'Nuevo Peaje es obligatorio', '05', '01', '02'),
    ('807', 'Nuevo Código CAE es obligatorio', '05', '01', '02'),
    ('808', 'Nuevo Código CAE debe ser diferente a Código CAE Actual', '05', '01', '02'),
    ('809', 'Nuevo Uso de Gas es obligatorio', '05', '01', '02'),
    ('810', 'Nuevo Uso de Gas y/o Nuevo Código CAE deben ser distintos a los actuales', '05', '01', '02'),
    ('812', 'La solicitud de anulación se produce con posterioridad a la finalización de los trámites originados por la solicitud a anular', '05', '02', '02'),
    ('814', 'Rechazo por integridad en los datos del cliente: CUPS incorrecto', '05', '02', '02'),
    ('815', 'Rechazo por integridad en los datos del cliente: NIF y contrato no coinciden con el CUPS solicitado', '05', '02', '02'),
    ('816', 'Rechazo por integridad en los datos del cliente: NIF incorrecto. Error en el cambio de nombre ', '05', '02', '02'),
    ('819', 'Existe una solicitud previa del tipo alta', '05', '02', '02'),
    ('820', 'Existe una solicitud previa de cambio', '05', '02', '02'),
    ('821', 'Existe una solicitud previa de baja', '05', '02', '02'),
    ('822', 'Existe una solicitud previa de anulación', '05', '02', '02'),
    ('823', 'Existe una solicitud previa de modificación', '05', '02', '02'),
    ('825', 'El cliente lleva más tiempo en liberalizado del plazo establecido para la reposición', '05', '02', '02'),
    ('826', 'No existe contrato ATR en vigor', '05', '02', '02'),
    ('827', 'No hay solicitud que anular para este CUPS', '05', '02', '02'),
    ('831', 'La empresa entrante es la titular del Contrato ATR en vigor', '05', '02', '02'),
    ('832', 'Cliente suministrado desde planta satélite', '05', '02', '02'),
    ('834', 'Número de documento incorrecto, inexistente o no coherente con el CUPS', '05', '02', '02'),
    ('835', 'CUPS inexistente, pendiente de suministro o cesado', '05', '02', '02'),
    ('840', 'Error de formato', '05', '02', '02'),
    ('841', 'Ya existe inspección para el CUPS y periodo', '05', '02'),
    ('842', 'Los campos @replace1@ y @replace2@ deben ser informados simultáneamente', '05', '01', '02'),
    ('843', 'El valor de los campos @replace1@ y @replace2@ no debe coincidir.', '05', '02'),
    ('844', 'Numerador @replace1@ repetido.', '05', '02'),
    ('845', 'Valor de campos "umconcepto" y "aparatoconcepto" no compatibles con el nivel de aplicación del concepto: @replace1@.', '05', '02'),
    ('846', 'El modelo de fecha efecto no es válido. Debe ser 02 o 04.', '05', '02', '02'),
    ('847', 'Fecha de Baja solicitada errónea (error de formato)', '05', '02', '02'),
    ('849', 'Fecha de Baja solicitada es anterior o igual a la Fecha de Solicitud', '05', '02', '02'),
    ('850', 'El campo @replace1@ no admite valores negativos: @replace2@.', '05', '02'),
    ('851', 'El elemento @replace1@ \'@replace2@\' se encuentra repetido.', '05', '02'),
    ('852', 'No se puede encontrar el objeto \'@replace1@\'', '05', '02'),
    ('853', 'No se debe informar el objeto "@replace1@" en procesos de tipo \'@replace2@\'.', '05', '02'),
    ('854', 'La fecha Desde del \"@replace1@\" debe ser anterior a la fecha Hasta.', '05', '02'),
    ('855', 'El campo "@replace1@" es obligatorio si el campo "@replace2@" tiene valor \'@replace3@\'.', '05', '02'),
    ('856', 'Si el campo "serializada" contiene el valor "S" el campo "restaserializada" no puede ser nulo\'.', '05', '02'),
    ('857', 'El los valores de los campos "cups" y "cupsresta" no pueden coincidir\'.', '05', '02'),
    ('858', 'La fecha de @replace1@ no debe ser posterior a la fecha actual.\'.', '05', '02'),
    ('860', 'Motivo de modificación no aceptado', '05', '02', '02'),
    ('861', 'No se cumple el ratio entre la nueva Qd y la Qh histórica: 1 <= Qd / Qh <= 24', '05', '02', '02'),
    ('862', 'No se admite una disminución de capacidad si el periodo transcurrido desde la última modificación de caudal es inferior a un año', '05', '02', '02'),
    ('863', 'Las disminuciones de capacidad se deben solicitar con tres meses de antelación', '05', '02', '02'),
    ('864', 'La nueva Qd solicitada coincide con la actual', '05', '02', '02'),
    ('865', 'No se cumple el período mínimo sin modificaciones en peaje o Qd', '05', '02', '02'),
    ('866', 'El nuevo peaje solicitado coincide con el actual', '05', '02', '02'),
    ('867', 'El nuevo NIF solicitado coincide con el actual', '05', '02', '02'),
    ('868', 'No se cumple el ratio 220 <= Qa / Qd <= 365', '05', '02', '02'),
    ('870', 'Los campos @replace1@, @replace2@ y @replace3@ deben ser informados simultáneamente.', '05', '01', '01'),
    ('900', 'Otros motivos (causa tipificada)', '05', '01'),
    ('901', 'Otros motivos (problema integridad)', '05', '01'),
    ('902', 'El peaje actual no pertenece al grupo 3.', '05', '02', '02'),
    ('911', 'Nuevo Caudal Horario debe ser mayor o igual que Caudal Horario Actual', '05', '01', '02'),
    ('912', 'Nuevo Caudal Diario debe ser mayor que Caudal Diario Actual', '05', '01', '02'),
    ('914', 'El sujeto asociado a su usuario no se encuentra activo por lo que no se le permite realizar nuevas solicitudes', '05', '01', '01'),
    ('915', 'El sujeto asociado a su usuario no se encuentra activo por lo que no se le permite la actualización de datos', '05', '01', '01'),
    ('916', ': El sujeto asociado a su usuario no se encuentra activo por lo que no se le permite la consulta de datos', '05', '01', '01'),
    ('920', 'Numero de factura de origen informado en factura tipo N', '05', '01', '01'),
    ('921', 'Numero de factura de origen no informado en factura de tipo A, B o R', '05', '01', '01'),
]
TAULA_MOTIVOS_DE_RECHAZO = [
    ('01', 'SCTD (GRE propietario o no propietario)'),
    ('02', 'Sistemas Propios (GRE propietario o DIS del mismo)'),
    ('03', 'Sistema del Comercializador'),
    ('04', 'Sistema del Transportista'),
    ('05', 'Sistema de OCSUM'),
]
TAULA_TIPO_MENSAJE = [
    ('A1', 'Envío de Solicitudes'),
    ('A2', 'Respuesta de Acepto/Rechazo de Solicitudes'),
    ('A2S', 'Aviso de Cambio a Comercializador saliente'),
    ('A3', 'Respuesta de Realización de Solicitudes'),
    ('A3S', 'Respuesta de Activación de Cambio a Comercializador saliente'),
    ('A4', 'Respuesta de rechazo tras actuaciones en campo de Solicitudes'),
    ('A4S', 'Notificación de rechazo tras actuaciones en campo a '
            'Comercializador saliente'),
    ('A7', 'Consulta de lecturas de clientes con consumo 3.4 y '
           'superior (fichero)'),
    ('A12', 'Notificación al COM/CC de Comunicaciones Contrato ATR'),
    ('A19', 'Notificación al COM/CC de Comunicaciones de Operaciones'),
    ('A12S', 'Notificación al COM/CC de Comunicaciones Contrato ATR'),
    ('A20', 'Envío petición datos CUPS disponible'),
    ('A21', 'Extracción respuesta de petición datos CUPS disponible'),
    ('A25', 'Respuesta Estado Intervención/incidencia'),
    ('A26', 'Envío de información adicional reclamación'),
    ('B70', 'Facturación'),
]

# CAUSA DE COMUNICACIÓN no es fa.

TAULA_PERIODICIDAD_LECTURA = [
    ('01', 'Mensual'),
    ('02', 'Bimestral'),
    ('03', 'Anual'),
    ('04', 'Semestral'),
    ('05', 'Diaria (Telemedida)'),
]
TAULA_PERIODICIDAD_ALQUILER = [
    ('01', 'Mensual'),
    ('02', 'Bimestral'),
    ('03', 'Anual'),
    ('04', 'Semestral'),
    ('05', 'Diaria (Telemedida)'),
]
TAULA_PERIODICIDAD_CANON_IRC = [
    ('01', 'Mensual'),
    ('02', 'Bimestral'),
    ('03', 'Anual'),
    ('04', 'Semestral'),
    ('05', 'Diaria (Telemedida)'),
]
TAULA_PERIODICIDAD_RESTO_CONCEPTOS = [
    ('01', 'Mensual'),
    ('02', 'Bimestral'),
    ('03', 'Anual'),
    ('04', 'Semestral'),
    ('05', 'Diaria (Telemedida)'),
]
TAULA_PERIODICIDAD_FACTURACION = [
    ('01', 'MENSUAL'),
    ('02', 'BIMESTRAL'),
    ('03', 'ANUAL'),
    ('04', 'ÚNICA'),
]
TAULA_PROVINCIA = [
    ('01', 'ALAVA', '34'),
    ('02', 'ALBACETE', '34'),
    ('03', 'ALICANTE', '34'),
    ('04', 'ALMERIA', '34'),
    ('05', 'AVILA', '34'),
    ('06', 'BADAJOZ', '34'),
    ('07', 'BALEARES', '34'),
    ('08', 'BARCELONA', '34'),
    ('09', 'BURGOS', '34'),
    ('10', 'CACERES', '34'),
    ('11', 'CADIZ', '34'),
    ('12', 'CASTELLON', '34'),
    ('13', 'CIUDAD REAL', '34'),
    ('14', 'CORDOBA', '34'),
    ('15', 'LA CORUÑA', '34'),
    ('16', 'CUENCA', '34'),
    ('17', 'GERONA', '34'),
    ('18', 'GRANADA', '34'),
    ('19', 'GUADALAJARA', '34'),
    ('20', 'GUIPUZCOA', '34'),
    ('21', 'HUELVA', '34'),
    ('22', 'HUESCA', '34'),
    ('23', 'JAEN', '34'),
    ('24', 'LEON', '34'),
    ('25', 'LERIDA', '34'),
    ('26', 'LA RIOJA', '34'),
    ('27', 'LUGO', '34'),
    ('28', 'MADRID', '34'),
    ('29', 'MALAGA', '34'),
    ('30', 'MURCIA', '34'),
    ('31', 'NAVARRA', '34'),
    ('32', 'ORENSE', '34'),
    ('33', 'ASTURIAS', '34'),
    ('34', 'PALENCIA', '34'),
    ('35', 'LAS PALMAS', '34'),
    ('36', 'PONTEVEDRA', '34'),
    ('37', 'SALAMANCA', '34'),
    ('38', 'SANTA CRUZ DE TENERIFE', '34'),
    ('39', 'CANTABRIA', '34'),
    ('40', 'SEGOVIA', '34'),
    ('41', 'SEVILLA', '34'),
    ('42', 'SORIA', '34'),
    ('43', 'TARRAGONA', '34'),
    ('44', 'TERUEL', '34'),
    ('45', 'TOLEDO', '34'),
    ('46', 'VALENCIA', '34'),
    ('47', 'VALLADOLID', '34'),
    ('48', 'VIZCAYA', '34'),
    ('49', 'ZAMORA', '34'),
    ('50', 'ZARAGOZA', '34'),
    ('51', 'CEUTA', '34'),
    ('52', 'MELILLA', '34'),
]
TAULA_NACIONALIDAD = [
    ('SB', 'ISLAS SALOMON'),
    ('SC', 'ISL. SEYCHELLES'),
    ('SD', 'SUDAN'),
    ('SA', 'ARABIA SAUDI'),
    ('RE', 'REUNION'),
    ('QA', 'QATAR'),
    ('PY', 'PARAGUAY'),
    ('RW', 'RUANDA'),
    ('RU', 'FEDERACION RUSA'),
    ('RO', 'RUMANIA'),
    ('SM', 'SAN MARINO'),
    ('SL', 'SIERRA LEONA'),
    ('SN', 'SENEGAL'),
    ('SR', 'SURINAM'),
    ('SO', 'SOMALIA'),
    ('SK', 'ESLOVAQUIA'),
    ('SG', 'SINGAPUR'),
    ('SE', 'SUECIA'),
    ('SH', 'SANTA ELENA'),
    ('SJ', 'SVALBARD AND JAN MAYEN'),
    ('SI', 'ESLOVENIA'),
    ('PW', 'PALAU'),
    ('NU', 'ISLAS NIUE'),
    ('NR', 'NAURU'),
    ('NZ', 'NUEVA ZELANDA'),
    ('PA', 'PANAMA'),
    ('OM', 'OMAN'),
    ('NI', 'NICARAGUA'),
    ('NG', 'NIGERIA'),
    ('NL', 'HOLANDA'),
    ('NP', 'NEPAL'),
    ('NO', 'NORUEGA'),
    ('PE', 'PERU'),
    ('PN', 'ISLAS PITCAIRN'),
    ('PM', 'SAINT PIERRE AND MIQUELON'),
    ('PR', 'PUERTO RICO'),
    ('PT', 'PORTUGAL'),
    ('PS', 'PALESTINA, TERRITORIO OCUPADO DE'),
    ('PG', 'PAPUA NUEVA GUINEA'),
    ('PF', 'POLINESIA FRANCESA'),
    ('PH', 'FILIPINAS'),
    ('PL', 'POLONIA'),
    ('PK', 'PAQUISTAN'),
    ('VC', 'SAN VICENTE Y LAS GRANADINAS'),
    ('VA', 'CIUDAD DEL VATICANO'),
    ('VE', 'VENEZUELA'),
    ('VI', 'ISLAS VIRGENES (ESTADOUNIDENSES)'),
    ('VG', 'ISLAS VIRGENES (INGLESAS)'),
    ('UM', 'ISLAS MINOR OUTLYNG'),
    ('UG', 'UGANDA'),
    ('US', 'ESTADOS UNIDOS'),
    ('UZ', 'UZBEKISTAN'),
    ('UY', 'URUGUAY'),
    ('ZW', 'ZIMBABWE'),
    ('WS', 'SAMOA'),
    ('YE', 'YEMEN'),
    ('WF', 'WALLIS AND FUTUNA'),
    ('VN', 'VIETNAM'),
    ('VU', 'VANUATU'),
    ('ZM', 'ZAMBIA'),
    ('ZR', 'REPUBLICA DEMOCRATICA DEL CONGO'),
    ('ZA', 'SUDAFRICA'),
    ('YT', 'MAYOTTE'),
    ('YU', 'YUGOSLAVIA'),
    ('UA', 'UCRANIA'),
    ('TF', 'FRENCH SOUTHERN TERRITORIES'),
    ('TD', 'CHAD'),
    ('TG', 'TOGO'),
    ('TJ', 'TAYIKISTAN'),
    ('TH', 'TAILANDIA'),
    ('SV', 'EL SALVADOR'),
    ('ST', 'SANTO TOME Y PRINCIPE'),
    ('SY', 'SIRIA, REPUBLICA ARABE DE'),
    ('TC', 'ISLAS TURKS Y ISLA DE CAICOS'),
    ('SZ', 'SWAZILANDIA'),
    ('TK', 'ISLAS TOKELAU'),
    ('TT', 'TRINIDAD Y TOBAGO'),
    ('TR', 'TURQUIA'),
    ('TV', 'TUVALU'),
    ('TZ', 'TANZANIA, REPUBLICA DE'),
    ('TW', 'TAIWAN, PROVINCIA DE CHINA'),
    ('TM', 'TURKMENISTAN'),
    ('TL', 'TIMOR ORIENTAL'),
    ('TN', 'TUNEZ'),
    ('TP', 'TIMOR ORIENTAL'),
    ('TO', 'TONGA'),
    ('NF', 'ISLA DE NORFOLK'),
    ('BE', 'BELGICA'),
    ('BF', 'BURKINA FASO'),
    ('BB', 'BARBADOS, LAS'),
    ('BD', 'BANGLADESH'),
    ('BG', 'BULGARIA'),
    ('BJ', 'BENIN'),
    ('BM', 'BERMUDAS, LAS'),
    ('BH', 'BAHREIN'),
    ('BI', 'BURUNDI'),
    ('BA', 'BOSNIA Y HERZEGOVINA'),
    ('AQ', 'ANTARTICO'),
    ('AR', 'ARGENTINA'),
    ('AN', 'ANTILLAS HOLANDESAS'),
    ('AO', 'ANGOLA'),
    ('AS', 'SAMOA AMERICANA'),
    ('AW', 'ARUBA'),
    ('AZ', 'AZERBAIYAN'),
    ('AT', 'AUSTRIA'),
    ('AU', 'AUSTRALIA'),
    ('CF', 'REPUBLICA CENTRO – AFRICANA'),
    ('CG', 'CONGO'),
    ('CC', 'ISLAS COCO'),
    ('CD', 'REPUBLICA DEMOCRATICA DEL CONGO'),
    ('CH', 'SUIZA'),
    ('IO', 'TERRITORIOS BRITANICOS DEL OCEANO INDICO'),
    ('IQ', 'IRAK'),
    ('CI', 'COSTA DE MARFIL'),
    ('CK', 'ISLAS COOK'),
    ('CA', 'CANADA'),
    ('BR', 'BRASIL'),
    ('BS', 'BAHAMAS, LAS'),
    ('BN', 'BRUNEI (DARUSSALAM)'),
    ('BO', 'BOLIVIA'),
    ('BT', 'BUTAN'),
    ('BY', 'BIELORRUSIA'),
    ('BZ', 'BELICE'),
    ('BV', 'ISLAS BOUVET'),
    ('BW', 'BOTSWANA'),
    ('AM', 'ARMENIA'),
    ('GM', 'GAMBIA'),
    ('GN', 'GUINEA'),
    ('GI', 'GIBRALTAR'),
    ('GL', 'GROENLANDIA'),
    ('GP', 'GUADALUPE'),
    ('GS', 'GEORGIA DEL SUR Y LAS ISLAS SANDWICH'),
    ('GT', 'GUATEMALA'),
    ('GQ', 'GUINEA ECUATORIAL'),
    ('GR', 'GRECIA'),
    ('GH', 'GHANA'),
    ('FO', 'ISLAS FAROE'),
    ('FR', 'FRANCIA'),
    ('FK', 'ISLAS MALVINAS'),
    ('FM', 'MICRONESIA, ESTADOS FEDERALES DE'),
    ('GA', 'GABON'),
    ('GE', 'GEORGIA'),
    ('GF', 'GUAYANA FRANCESA'),
    ('GB', 'GRAN BRETAÑA'),
    ('GD', 'GRANADA'),
    ('IN', 'INDIA'),
    ('AD', 'ANDORRA'),
    ('IE', 'IRLANDA'),
    ('IL', 'ISRAEL'),
    ('AE', 'EMIRATOS ARABES (UNIDOS)'),
    ('AI', 'ANGUILLA'),
    ('AL', 'ALBANIA'),
    ('AF', 'AFGANISTAN'),
    ('AG', 'ANTIGUA Y BARBUDA'),
    ('ID', 'INDONESIA'),
    ('GY', 'GUAYANA'),
    ('HK', 'HONG KONG'),
    ('GU', 'GUAM'),
    ('GW', 'GUINEA-BISSAU'),
    ('HM', 'ISLA HEARD '),
    ('HT', 'HAITI'),
    ('HU', 'HUNGRIA'),
    ('HN', 'HONDURAS'),
    ('HR', 'CROACIA'),
    ('LV', 'LETONIA'),
    ('LY', 'LIBIA'),
    ('LT', 'LITUANIA'),
    ('LU', 'LUXEMBURGO'),
    ('MA', 'MARRUECOS'),
    ('MG', 'MADAGASCAR'),
    ('MH', 'ISLAS MARSHALL'),
    ('MC', 'MONACO'),
    ('MD', 'MOLDAVIA, REPUBLICA DE'),
    ('LS', 'LESOTHO'),
    ('KZ', 'KAZAJISTAN'),
    ('LA', 'LAOS, REPUBLICA POPULAR DEMOCRATICA DE'),
    ('KW', 'KUWAIT'),
    ('KY', 'ISLAS CAIMAN'),
    ('LB', 'LIBANO'),
    ('LK', 'SRI LANKA'),
    ('LR', 'LIBERIA'),
    ('LC', 'SANTA LUCIA'),
    ('LI', 'LIECHTENSTEIN'),
    ('MW', 'MALAWI'),
    ('MX', 'MEJICO'),
    ('MU', 'MAURICIO(ISL.)'),
    ('MV', 'MALDIVAS, LAS'),
    ('MY', 'MALASIA'),
    ('NC', 'NUEVA CALEDONIA'),
    ('NE', 'NIGER'),
    ('MZ', 'MOZAMBIQUE'),
    ('NA', 'NAMIBIA'),
    ('MT', 'MALTA'),
    ('MM', 'MYANMAR'),
    ('MN', 'MONGOLIA'),
    ('MK', 'MACEDONIA'),
    ('ML', 'MALI'),
    ('MO', 'MACAO'),
    ('MR', 'MAURITANIA'),
    ('MS', 'MONTSERRAT'),
    ('MP', 'ISLA N.MARIANA'),
    ('MQ', 'MARTINICA'),
    ('KR', 'COREA DEL SUR'),
    ('CL', 'CHILE'),
    ('CM', 'CAMERUN'),
    ('KM', 'COMORAS'),
    ('KN', 'SAINT KITTS AND NEVIS'),
    ('CN', 'CHINA'),
    ('CU', 'CUBA'),
    ('CV', 'CABO VERDE'),
    ('CO', 'COLOMBIA'),
    ('CR', 'COSTA RICA'),
    ('KI', 'KIRIBATI'),
    ('JP', 'JAPON'),
    ('JO', 'JORDANIA'),
    ('KG', 'KIRGUIZISTAN'),
    ('KE', 'KENIA'),
    ('JM', 'JAMAICA'),
    ('IR', 'IRAN, REPUBLICA ISLAMICA DE'),
    ('KH', 'CAMBOYA'),
    ('IT', 'ITALIA'),
    ('IS', 'ISLANDIA'),
    ('EH', 'SAHARA OCCIDENTAL'),
    ('ER', 'ERITREA'),
    ('EE', 'ESTONIA'),
    ('EG', 'EGIPTO'),
    ('ES', 'ESPAÑA'),
    ('FJ', 'ISLAS FIJI'),
    ('KP', 'COREA DEL NORTE'),
    ('ET', 'ETIOPIA'),
    ('FI', 'FINLANDIA'),
    ('EC', 'ECUADOR'),
    ('CZ', 'REPUBLICA CHECA'),
    ('DE', 'ALEMANIA'),
    ('CX', 'ISLAS NAVIDAD'),
    ('CY', 'CHIPRE'),
    ('DJ', 'DJIBOUTI'),
    ('DO', 'REPUBLICA DOMINICANA'),
    ('DZ', 'ARGELIA'),
    ('DK', 'DINAMARCA'),
    ('DM', 'DOMINICA'),
]
TAULA_TIPO_VIA = [
    ('ACCE', 'ACCES'),
    ('ACCES', 'ACCESO'),
    ('ACEQ', 'ACEQUIA'),
    ('ACERA', 'ACERA'),
    ('ALAM', 'ALAMEDA'),
    ('ALDAP', 'ALDAPA'),
    ('ALDEA', 'ALDEA'),
    ('ALQUE', 'ALQUERIA'),
    ('ALTO', 'ALTO', ), 
    ('ANDAD', 'ANDADOR', ), 
    ('ANGTA', 'ANGOSTA', ), 
    ('APTES', 'APARTAMENTS', ), 
    ('APTOS', 'APARTAMENTOS', ), 
    ('ARB', 'ARBOLEDA', ), 
    ('ARRAL', 'ARRABAL', ), 
    ('ARRY', 'ARROYO', ), 
    ('ASSEG', 'ASSEGADOR', ), 
    ('ATAJO', 'ATAJO', ), 
    ('ATAL', 'ATALL', ), 
    ('ATALL', 'ATALLO', ), 
    ('ATZUC', 'ATZUCAT', ), 
    ('AUTO', 'AUTOPISTA', ), 
    ('AUZO', 'AUZO', ), 
    ('AUZOT', 'AUZOTEGI', ), 
    ('AUZUN', 'AUZUNEA', ), 
    ('AV', 'AVINGUDA', ), 
    ('AVDA', 'AVENIDA', ), 
    ('AVGDA', 'AVINGUDA', ), 
    ('AVIA', 'AUTOVIA', ), 
    ('BARDA', 'BARRIADA', ), 
    ('BARRI', 'BARRI', ), 
    ('BARRO', 'BARRIO', ), 
    ('BDA', 'BAIXADA', ), 
    ('BELNA', 'BELENA', ), 
    ('BIDE', 'BIDE', ), 
    ('BIDEB', 'BIDEBIETA', ), 
    ('BJADA', 'BAJADA', ), 
    ('BLQUE', 'BLOQUE', ), 
    ('BRANC', 'BARRANCO', ), 
    ('BRDLA', 'BARREDUELA', ), 
    ('BRZAL', 'BRAZAL', ), 
    ('BULEV', 'BULEVAR', ), 
    ('BV', 'BULEVAR', ), 
    ('C', 'CARRER', ), 
    ('C.H.', 'CMNO HONDO', ), 
    ('C.N.', 'CMNO NUEVO', ), 
    ('C.V.', 'CMNO VIEJO', ), 
    ('C/', 'CARRER', ), 
    ('CÑADA', 'CAÑADA', ), 
    ('CALLE', 'CALLE', ), 
    ('CAMI', 'CAMI', ), 
    ('CAMIN', 'CAMIN', ), 
    ('CAMPA', 'CAMPA', ), 
    ('CANÑO', 'CANTIÑO', ), 
    ('CANAL', 'CANAL', ), 
    ('CANT', 'CANTON', ), 
    ('CANTO', 'CANTO', ), 
    ('CARRA', 'CARRERADA', ), 
    ('CARRE', 'CARRER', ), 
    ('CARRY', 'CARRERANY', ), 
    ('CBTIZ', 'COBERTIZO', ), 
    ('CELLA', 'CANELLA', ), 
    ('CERRO', 'CERRO', ), 
    ('CINT', 'CINTURO', ), 
    ('CINY', 'CINYELL', ), 
    ('CIRCU', 'CIRCUMVAL.LACIO', ), 
    ('CJLA', 'CALLEJUELA', ), 
    ('CJTO', 'CONJUNTO', ), 
    ('CLEYA', 'CALEYA', ), 
    ('CLLJA', 'CALLEJA', ), 
    ('CLLON', 'CALLEJON', ), 
    ('CLLZO', 'CALLIZO', ), 
    ('CLYON', 'CALEYON', ), 
    ('CMÑO', 'CAMIÑO', ), 
    ('CMNO', 'CAMINO', ), 
    ('COL', 'COLONIA', ), 
    ('COMPJ', 'COMPLEJO', ), 
    ('COMPX', 'COMPLEXO', ), 
    ('COSTA', 'COSTA', ), 
    ('CRA', 'CARRERA', ), 
    ('CRLLO', 'CORRILLO', ), 
    ('CRO', 'CARRERO', ), 
    ('CRRAL', 'CORRALO', ), 
    ('CRRCI', 'CORREDORCILLO', ), 
    ('CRRDA', 'CORREDOIRA', ), 
    ('CRRDE', 'CORREDERA', ), 
    ('CRRDO', 'CORREDOR', ), 
    ('CRRIL', 'CARRIL', ), 
    ('CRRLO', 'CORRALILLO', ), 
    ('CRROL', 'CORRIOL', ), 
    ('CRTIL', 'CARRETIL', ), 
    ('CRTJO', 'CORTIJO', ), 
    ('CSRIO', 'CASERIO', ), 
    ('CSTAN', 'COSTANILLA', ), 
    ('CTRA', 'CARRETERA', ), 
    ('CTRIN', 'CARRETERIN', ), 
    ('CUSTA', 'CUESTA', ), 
    ('CXON', 'CALEXON', ), 
    ('CXTO', 'CONXUNTO', ), 
    ('CZADA', 'CALZADA', ), 
    ('CZADS', 'CALZADAS', ), 
    ('DEMAR', 'DEMARCACIO', ), 
    ('DRERA', 'DRECERA', ), 
    ('EIRAD', 'EIRADO', ), 
    ('ENTD', 'ENTRADA', ), 
    ('EPTZA', 'ENPARANTZA', ), 
    ('ERREB', 'ERREBAL', ), 
    ('ERREK', 'ERREKA', ), 
    ('ERREP', 'ERREPIDE', ), 
    ('ERRIB', 'ERRIBERA', ), 
    ('ESCA', 'ESCALERA', ), 
    ('ESCAL', 'ESCALINATA', ), 
    ('ESLDA', 'ESPALDA', ), 
    ('ESTDA', 'ESTRADA', ), 
    ('ETDEA', 'ETORBIDE', ), 
    ('ETXAD', 'ETXADI', ), 
    ('ETXAR', 'ETXARTE', ), 
    ('ETXAT', 'ETXATZE', ), 
    ('EXPLA', 'EXPLANADA', ), 
    ('EXTRM', 'EXTRAMUROS', ), 
    ('EXTRR', 'EXTRARRADIO', ), 
    ('FALDA', 'FALDA', ), 
    ('FINCA', 'FINCA', ), 
    ('G.V.', 'GRAN VIA', ), 
    ('GAIN', 'GAIN', ), 
    ('GALE', 'GALERIA', ), 
    ('GORAB', 'GORABIDE', ), 
    ('GRUP', 'GRUPO', ), 
    ('GRUPO', 'GRUPO', ), 
    ('GTA', 'GLORIETA', ), 
    ('HEGI', 'HEGI', ), 
    ('HIRIB', 'HIRIBIDE', ), 
    ('HONDA', 'HONDARTZA', ), 
    ('HOYA', 'HOYA', ), 
    ('IBILB', 'IBILBIDE', ), 
    ('ILLA', 'ILLA', ), 
    ('INDA', 'INDA', ), 
    ('JARD', 'JARDI', ), 
    ('JDIN', 'JARDIN', ), 
    ('JDINS', 'JARDINES', ), 
    ('KAI', 'KAI', ), 
    ('KALE', 'KALE', ), 
    ('KARIK', 'KARRIKA', ), 
    ('KARRE', 'KARRERA', ), 
    ('KARRI', 'KARRICA', ), 
    ('KOSTA', 'KOSTA', ), 
    ('KRRIL', 'KARRIL', ), 
    ('LAGO', 'LAGO', ), 
    ('LASTE', 'LASTERBIDE', ), 
    ('LDERA', 'LADERA', ), 
    ('LEKU', 'LEKU', ), 
    ('LLOC', 'LLOC', ), 
    ('LOMA', 'LOMA', ), 
    ('LORAK', 'LORATEGIAK', ), 
    ('LORAT', 'LORATEGI', ), 
    ('LUGAR', 'LUGAR', ), 
    ('MALEC', 'MALECON', ), 
    ('MAZO', 'MAZO', ), 
    ('MENDI', 'MENDI', ), 
    ('MIRAD', 'MIRADOR', ), 
    ('MOLL', 'MOLL', ), 
    ('MONTE', 'MONTE', ), 
    ('MUELL', 'MUELLE', ), 
    ('ONDAR', 'ONDARTZA', ), 
    ('PAGO', 'PAGO', ), 
    ('PARC', 'PARQUE', ), 
    ('PARKE', 'PARKE', ), 
    ('PARTI', 'PARTICULAR', ), 
    ('PAS', 'PAS', ), 
    ('PASAI', 'PASAI', ), 
    ('PASEA', 'PASEABIDE', ), 
    ('PASEO', 'PASEO', ), 
    ('PBDO', 'POBLADO', ), 
    ('PDA', 'PUJADA', ), 
    ('PDIS', 'PASSADIS', ), 
    ('PG', 'PASSEIG', ), 
    ('PINAR', 'PINAR', ), 
    ('PISTA', 'PISTA', ), 
    ('PJDA', 'PUJADA, SUBIDA', ), 
    ('PL', 'PLACA', ), 
    ('PLA', 'PLA', ), 
    ('PLAÇA', 'PLAÇA', ), 
    ('PLAYA', 'PLAYA', ), 
    ('PLAZA', 'PLAZA', ), 
    ('PLCET', 'PLACETA', ), 
    ('PLLO', 'PASILLO', ), 
    ('PLZLA', 'PLAZUELA', ), 
    ('PNTE', 'PUENTE', ), 
    ('POLIG', 'POLIGONO', ), 
    ('PONT', 'PONT', ), 
    ('PONTE', 'PONTE', ), 
    ('PORT', 'PORT', ), 
    ('PQUE', 'PARQUE', ), 
    ('PRAÑA', 'PRACIÑA', ), 
    ('PRAGE', 'PARATGE', ), 
    ('PRAIA', 'PRAIA', ), 
    ('PRAJE', 'PARAJE', ), 
    ('PRAZA', 'PRAZA', ), 
    ('PROL', 'PORLONGACION', ), 
    ('PSAJE', 'PASAJE', ), 
    ('PSAXE', 'PARAXE', ), 
    ('PTDA', 'PARTIDA', ), 
    ('PTGE', 'PASSATGE', ), 
    ('PTLLO', 'PORTILLO', ), 
    ('PZO', 'PASADIZO', ), 
    ('PZTA', 'PLAZOLETA', ), 
    ('RABAL', 'RABAL', ), 
    ('RACDA', 'RACONADA', ), 
    ('RACO', 'RACO', ), 
    ('RAMAL', 'RAMAL', ), 
    ('RAMPA', 'RAMPA', ), 
    ('RAMPS', 'RAMPAS', ), 
    ('RAVAL', 'RAVAL', ), 
    ('RBLA', 'RAMBLA', ), 
    ('RBRA', 'RIBERA', ), 
    ('RCDA', 'RINCONADA', ), 
    ('RCON', 'RINCON', ), 
    ('RENTO', 'RECANTO', ), 
    ('RIERA', 'RIERA', ), 
    ('RONDA', 'RONDA', ), 
    ('RTDA', 'ROTONDA', ), 
    ('RUA', 'RUA', ), 
    ('RUELA', 'RUELA', ), 
    ('RUERO', 'RUEIRO', ), 
    ('SARBI', 'SARBIDE', ), 
    ('SBIDA', 'SUBIDA', ), 
    ('SECT', 'SECTOR', ), 
    ('SEDER', 'SENDER', ), 
    ('SEDRA', 'SENDERA', ), 
    ('SEKT', 'SEKTORE', ), 
    ('SEND', 'SENDERO', ), 
    ('SENDA', 'SENDA', ), 
    ('SVTIA', 'SERVENTIA', ), 
    ('TALDE', 'TALDE', ), 
    ('TOKI', 'TOKI', ), 
    ('TRANS', 'TRANSITO', ), 
    ('TRAS', 'TRASERA', ), 
    ('TRAV', 'TRAVESSERA', ), 
    ('TRRNT', 'TORRENT', ), 
    ('TRSSI', 'TRAVESSIA', ), 
    ('TRVA', 'TRAVESIA', ), 
    ('TRVAL', 'TRANSVERSAL', ), 
    ('URB', 'URBANIZACION', ), 
    ('URBAT', 'URBANITZACIO', ), 
    ('URBAZ', 'URBANIZAZIO', ), 
    ('VALLE', 'VALLE', ), 
    ('VCTO', 'VIADUCTO', ), 
    ('VEGA', 'VEGA', ), 
    ('VENAT', 'VEINAT', ), 
    ('VENLA', 'VENELA', ), 
    ('VIA', 'VIA', ), 
    ('VIAL', 'VIAL', ), 
    ('VIANY', 'VIARANY', ), 
    ('VREDA', 'VEREDA', ), 
    ('XDIN', 'XARDIN', ), 
    ('ZEHAR', 'ZEARKALETA', ), 
    ('ZONA', 'ZONA', ), 
    ('ZUBI', 'ZUBI', ), 
    ('ZUHAI', 'ZUHAIZTI', ), 
    ('ZUMAR', 'ZUMARDI', ), 
]
TAULA_TIPO_DOCUMENTO = [
    ('01', 'NIF'),
    ('03', 'PASAPORTE'),
    ('04', 'Número de identificación de extranjeros'),
    ('07', 'NIVA'),
    ('08', 'Otros'),
]
TAULA_TIPO_PERSONA = [
    ('F', 'Física'),
    ('J', 'Jurídica'),
]
TAULA_MOTIVOS_DE_RECHAZO_CNMC = [
    ('R01', 'Cliente suministrado desde planta satélite.'),
    ('R03', 'El CUPS no está conectado al distribuidor que se '
            'indica en la solicitud.'),
    ('R04', 'Falta infraestructura.'),
    ('R07', 'Si el modelo fecha efecto que solicita es "03" o “04” debe '
            'cumplimentar el campo "Fecha efecto solicitada" '),
    ('R08', 'La fecha de efecto solicitada "@replace1@" no puede ser '
            'mayor que la fecha "@replace2@".'),
    ('R11', 'El municipio "@replace1@" no pertenece a la '
            'provincia "@replace2@".'),
    ('R12', 'Error de integridad: DNI no coherente con CUPS. '),
    ('R14', 'El día de la fecha efecto solicitada es errónea, tiene que ser el '
            '1, 11 ó 21 del mes. '),
    ('R19', 'Si el motivo de modificación es @replace1@, los '
            'campos @replace2@ tienen que ser distintos.'),
    ('R24', 'El nuevo peaje no puede coincidir con el peaje actual del '
            'contrato.'),
    ('R26', 'Nuevo Caudal Diario no puede coincidir con el '
            'Caudal Diario Actual del contrato.'),
    ('R29', 'CUPS inexistente.'),
    ('R32', 'Fecha efecto solicitada anterior al día actual.'),
    ('R34', 'No existe contrato de ATR en vigor.'),
    ('R35', 'Existe una solicitud previa del tipo nuevo suministro del '
            'mismo comercializador.'),
    ('R36', 'Existe una solicitud previa del tipo baja del '
            'mismo comercializador.'),
    ('R37', 'Existe una solicitud previa de tipo cambio del '
            'mismo comercializador.'),
    ('R38', 'Existe una solicitud previa de tipo modificación del '
            'mismo comercializador.'),
    ('R39', 'Existe una solicitud previa de tipo anulación del '
            'mismo comercializador.'),
    ('R40', 'El comercializador no es la empresa titular del contrato ATR en '
            'vigor.'),
    ('R41', 'No existe una previa del comercializador que solicita la '
            'Anulación.'),
    ('R42', 'La solicitud que se intenta anular ya está "en trámite" o '
            'formalizada.'),
    ('R43', 'El CUPS ya está activo con la comercializadora solicitante.'),
    ('R44', 'Existe una solicitud previa del tipo alta de '
            'otra Comercializadora.'),
    ('R45', 'Existe una solicitud previa de baja de otra comercializadora.'),
    ('R46', 'Existe una solicitud previa de cambio de otra comercializadora.'),
    ('R47', 'Existe una solicitud previa de modificación '),
    ('R48', 'Existe una solicitud previa de anulación de otra comercializadora.'),
    ('R49', 'Suministro a Presión superior a 16 bares. Debe presentarse la '
            'solicitud a través del transportista.'),
    ('R51', 'CUPS en servicio con otra comercializadora.'),
    ('R61', 'Si el motivo de modificación es @replace1@, se debe '
            'enviar alguno de los campos @replace2@.'),
    ('R62', 'Si la presión solicitada es mayor de 4 bares o el peaje es 3.5, '
            'es obligatorio que el campo Caudal Diario tenga un valor'),
    ('R64', 'El número de documento informado no cumple con las '
            'validaciones definidas sobre los documentos del tipo enviado'),
    ('R70', 'Otros motivos no contemplados en el resto del listado.'),
    ('R73', 'No se cumple período mínimo desde la última modificación de '
            'peaje o Qd'),
    ('R74', 'Error de integridad: @replace@'),
    ('R75', 'No se puede suspender el suministro Pobreza energética'),
    ('R76', 'Incidencia no subsanada en periodo máximo establecido'),
    ('R77', 'Comercializadora inactiva'),
    ('R78', 'El Código de Solicitud ya ha sido recibido con '
            'anterioridad para ese mismo agente'),
    ('R79', 'Existe una Solicitud de Actuación (corte del suministro) en '
            'curso del mismo comercializador'),
    ('R80', 'Existe una Solicitud de Actuación (corte del suministro) en '
            'curso de otro comercializador'),
    ('R81', 'Reclamación duplicada'),
    ('R82', 'Factura inexistente'),
    ('R83', 'Concurrencia con cambio/Traspaso CUR'),
    ('R84', 'Anomalía instalación'),
    ('R85', 'Corte Anulado'),
    ('R86', 'Cliente no quiere gas'),
    ('R87', 'Cliente quiere gas más adelante'),
    ('R88', 'Concurrencia Corte/Reapertura: @replace@'),
    ('R89', 'No se ha podido realizar la reapertura'),
    ('R90', 'No se puede suspender el suministro por esencialidad'),
    ('R91', 'No se puede suspender el suministro por trámites judiciales'),
    ('R92', 'Contrato de ATR en suspensión de suministro'),
    ('R93', 'Se rechaza por concurrencia con baja por impago'),
    ('R94', 'No es posible solicitar un cambio/alta/modificación a '
            'fecha fija para una fecha > 30 días naturales'),
    ('R95', 'Existe una solicitud previa de baja ya en campo o '
            'realizada (pendiente de activar) de otra comercializadora.'),
    ('R96', 'Tipo de activación solicita incoherente con el '
            'proceso solicitado'),
]
TAULA_MOTIVO_RECHAZO_OCSUM = TAULA_MOTIVOS_DE_RECHAZO_CNMC
TAULA_MES = [
    ('01', 'Enero'),
    ('02', 'Febrero'),
    ('03', 'Marzo'),
    ('04', 'Abril'),
    ('05', 'Mayo'),
    ('06', 'Junio'),
    ('07', 'Julio'),
    ('08', 'Agosto'),
    ('09', 'Septiembre'),
    ('10', 'Octubre'),
    ('11', 'Noviembre'),
    ('12', 'Diciembre'),
]
TAULA_IDIOMA = [
    ('01', 'Castellano'),
    ('02', 'Català'),
    ('03', 'Galego'),
    ('04', 'Euskera'),
]
TAULA_RESULTADO_INSPECCION = [
    ('01', 'CORRECTO'),
    ('02', 'DEFECTOS NO CRITICOS, MENORES o SECUNDARIOS'),
    ('03', 'AUSENTE'),
    ('04', 'DEFECTOS CRITICOS Y NO DEJA CORTAR'),
    ('05', 'DEFECTOS CRITICOS'),
    ('06', 'NO DEJA PASAR'),
    ('07', 'NO FIRMA INSPECCION'),
    ('08', 'CORRECTO SIN VISITA'),
    ('09', 'SITUACION SINGULAR'),
    ('10', 'CERTIFICADO DE INSTALACIONES EN EDIF.HAB'),
    ('11', 'FINCA UNIFAMILIAR O COMERCIAL UNICA'),
    ('12', 'PROCESO DE INSPECCION EN CURSO'),
    ('13', 'DEFECTOS EN INSTALACIÓN '),
    ('14', 'DESHABITADO'),
]
TAULA_TIPO_DE_INFORMACION_INCIDENCIA = [
    ('002', 'Orden de Trabajo pendiente'),
    ('005', 'Orden de Trabajo creada'),
    ('031', 'Ausente'),
    ('041', 'Programado con el cliente en > 6 días'),
    ('050', 'Concertación de Visita'),
    ('051', 'Concertación anterior anulada. Pendiente concertar'),
    ('907', 'Teléfono erróneo/ Ilocalizable'),
    ('909', 'Deficiencia subsanable/ Trabajos pendientes '),
    ('910', 'Se retrasa visita a campo a petición del cliente'),
]
TAULA_TIPO_DE_ACTIVACION = [
    ('001', 'Realizada puesta en servicio'),
    ('002', 'No realizada técnicamente en campo'),
]
TAULA_ANOMALIA_INSTALACION = [
    ('001', 'FUGA DE GAS'),
    ('002', 'APAR.CIRCUITO ABIERTO BAÑO-DORMITORIO'),
    ('003', 'TUBO FLEXIBLE VISIBLEMENTE DAÑADO'),
    ('004', 'FLEXIBLE NO METALICO CONTACTO P.CAL.HORN'),
    ('005', 'APAR. EN LOCAL <8M3 SIN ORIFICIO SALIDA'),
    ('006', 'DEFICIENCIA EN CONDUCTO EVACUACIÓN PDC.'),
    ('007', 'EXTRACTORES FORZADOS A OTROS COND.DE PDC'),
    ('008', 'INEX.COND.EVAC.EN APARATOS QUE PRECISAN.'),
    ('009', 'AP.TIPO B EN LOCAL <8M3 SIN VENTILACION.'),
    ('010', 'AP.TIPO B EN LOCAL >8M3 SIN VENTILACION.'),
    ('011', 'ESTADO GRAL. INSTAL.DEFECT. ? MAT.INADEC'),
    ('012', 'FLEXIBLE INADEC,DEFECT.O CONTACTO P.CAL.'),
    ('013', 'INCUMP.TRAZADO INST.POR ALT, SOTANOS,ETC'),
    ('014', 'LLAVES AP. SIN CONECT.Y NO CERR.NI TAPON'),
    ('015', 'LOCAL CON VENTILACION INADECUADA.'),
    ('016', 'LOCAL C/VOLUM.INSUF.SI CONSUMO>16KW/H'),
    ('017', 'FALTA SIST.DETECC.Y CORTE GAS S/ 60670-6'),
    ('018', 'REVOCO CONDUC.EVAC.O EXC.CO EN AMBIENTE'),
    ('019', 'COMBUSTION NO HIGIENICA DE LOS APARATOS'),
    ('020', 'INEX.DISP.CTROL.CONTAM.ATMOSFERA AS'),
    ('021', 'CONCENTRACION MODERADA CO AMB. EN LOCAL'),
    ('022', 'INTERF.CAMPANA EXTRACTORA EN FUNC.AP.GAS'),
    ('023', 'FUNC.INCORR.DISP.SEGURIDAD POR EXT.LLAMA'),
    ('024', 'IMPOSIBILIDAD COMPROB.PDC EN AP. TIPO B'),
    ('025', 'FUGA DE GAS'),
    ('026', 'FUGA DE GAS SECUNDARIA'),
    ('027', 'CONJ.REG.INTERIOR ARMARIO NO VENTILADO'),
    ('028', 'VENT.INCORR.REC.CENTRALIZACION CDORES.'),
    ('029', 'ESTADO GRAL.DEFECTUOSO MATERIALES INADE'),
    ('030', 'INCUMP.NORMATIVA TRAZADO ALT, SOT, ETC.'),
    ('031', 'MAL ESTADO CONSERVACION INSTAL.ELECTRICA'),
    ('032', 'INSTALACIONES AJENAS EN RECINTO CDORES.'),
    ('033', 'PUERTA O CERRADURA INCORR.ARMARIO REG.'),
    ('034', 'OTRAS ANOMALIAS'),
    ('035', 'FUNCIONAMIENTO INCORRECTO DISP SEGURIDAD'),
    ('036', 'ESTADO GRAL.DEFECTUOSO MAT.-TRAMOS INAD.'),
    ('037', 'INEXIST.O DIFICIL ACCESO VALVULA GENERAL'),
    ('038', 'ERM SIN TOMA TIERRA O J.DIELEC.'),
    ('039', 'VENTILACION RECINTO ERM INSUF.O INCORR.'),
    ('040', 'UBIC.RECINTO O DISTANCIAS MIN.INCORR.'),
    ('041', 'INEX.DETERIORO O CADUC. EXTINTOR P.SECO'),
    ('042', 'INST.ELECTRICA ERM INCUMPLE NORM.VIGENTE'),
    ('043', 'INEXISTENCIA SEÑALIZACION CORRESPONDIENT'),
    ('044', 'INCUMPL.REGLAM.DISCURRE ALT.TECH.CAM.SOT'),
    ('045', 'FALTA LIBRO MANT.O ACRE.LA REALIZACIÓN'),
    ('046', 'FUGA DE GAS'),
    ('047', 'INSTALACIÓN NO ESTANC(NIVEL FUGA 1y5 l/h'),
    ('048', 'EXISTENCIA DE GRIETAS, APRECIABLES VISUALMENTE, EN LAS '
            'PAREDES INTERIORES DEL RECINTO DE CONTADORES, REGULADORES O '
            'COLECTORES DE LLAVES, QUE POSIBILITEN CANALIZAR POTENCIALES '
            'FUGAS DE GAS A LA ESTRUCTURA DEL EDIFICIO [CS-9]'),
    ('053', 'AUSENCIA CERTIFICADO REVISIÓN'),
    ('064', 'NO INSPECCIONADO OBRAS'),
    ('065', 'NO INSPECCIONADO LOCAL PRECINTADO'),
    ('066', 'NO INSPECCIONADO BAJA GAS'),
    ('067', 'NO INSPECCIONADO INSTAL. PRECINTADA'),
    ('068', 'NO INSPECCIONADO OTRAS'),
    ('074', 'LOCAL CON APARATOS=>25,8TH S VENTILACION'),
    ('075', 'CONDUCCIONES DE OTROS SERVICIOS, DE ACUERDO A LO INDICADO EN EL '
            'APARTADO 4.3 DE LA NORMA UNE 60670-4:2014 EN CONTACTO CON '
            'CONDUCCIONES DE GAS [ISA-8]'),
    ('079', 'INCORRECTA REGULACIÓN DE LOS MÍNIMOS DE LOS '
            'QUEMADORES SUPERIORES DE COCINAS, ENCIMERAS ENCASTRABLES U '
            'OTROS APARATOS DE COCCIÓN [AS-7]'),
    ('080', 'INTERFERENCIA GRAVE DEL EXTRACTOR MECÁNICO O LA '
            'CAMPANA EXTRACTORA EN EL FUNCIONAMIENTO DE UN APARATO DE '
            'GAS [AP-4]'),
    ('081', 'INTERFERENCIA MODERADA DE LA CAMPANA EXTRACTORA EN EL '
            'FUNCIONAMIENTO DE UN APARATO DE GAS [AS-2]'),
    ('082', 'COMBUSTIÓN DEFICIENTE DE APARATOS DE GAS [AS-6]'),
    ('083', 'INCORRECTO FUNCIONAMIENTO DE LOS QUEMADORES DE LOS APARATOS DE '
            'COCCIÓN [AS-8]'),
    ('R1', 'FUGA DE GAS'),
    ('R10', 'CARENCIA DE VAINAS Y/O PROTEC EN TUBERÍA'),
    ('R11', 'TUB. VISTS. SIN ELEMTOS DE SUJE. ADECU'),
    ('R12', 'TUB-EMPOT-EN-PARD-CON-HUECS-O-MUROS-RES.'),
    ('R13', 'TUB-ENTERRDS-EN SUELOS DE VIVDAS O LOCAL'),
    ('R14', 'INST-SOTA-SEMIST. GARJ. APARC. '),
    ('R15', 'INEX-MALA-UBIC-FUNCTO. INCO. LLAVE CORTE'),
    ('R16', 'INEXISTENCIA DE TOMAS DE PRES NECESARIAS'),
    ('R17', 'APARJE-ELEC-REC-CONJ-REG. SIN MED. ADEC.'),
    ('R18', 'CON-RG-CAL-Y-AGU-CAL-MIS-RC-S.MED. ADC.'),
    ('R19', 'CONJ. REG. EN RECINTO INSUF. VENTILADO'),
    ('R2', 'APARATO CIR. ABIERTO EN LOCAL INAPROP.'),
    ('R20', 'UBICACIÓN EN ZONA INUNDABLE'),
    ('R21', 'CONJ-REG-Z-COMUN-SIN-PROT-ARM-CERRDO. V.'),
    ('R22', 'NO VAL. SEG. EXC. PRE. MOP > 150 mbar'),
    ('R23', 'NO-SEG-MIN-IND-NO-EXI-MSMA-SEG-EN-I-COM.'),
    ('R24', 'CONJ-REG-NO-DISP-PLAC-TARJ-O-ADHES-CORR.'),
    ('R25', 'AUSENCIA PRECINTO QUE IMPIDA MANIPUL.'),
    ('R26', 'VENTILACIÓN INCORRECTA DEL RECINTO'),
    ('R27', 'INSTALACIÓN CONTADOR INADECUADA'),
    ('R28', 'DISTCIA-INSUF-ENTRE-CONT-Y-APRTO-DE-GAS'),
    ('R29', 'APJE-MAQ-Y/O-CON-ELEC-DIST-INSUF-CON-GAS'),
    ('R3', 'VENTIL. AIRE LOCAL INCORR. O INEXIST.'),
    ('R30', 'EXIST-RCTO-MAQ-CUAD-CONT-MOT-TRANSF-ELEC'),
    ('R31', 'INST-ELEC. NO ACUER. CON NORMA UNE 60670'),
    ('R32', 'APAR. GAS QUE PRECIS. COND. EVAC. CARECE'),
    ('R33', 'AP. NO PRE. COND. EV. '),
    ('R34', 'CONEX. NO PERM. FLEX. NO HOM. CAD. ETC.'),
    ('R35', 'AP-FI-SIN CONEX RG-O TUB. FLE. Aº INOX '),
    ('R36', 'TUBO FLEXIBLE VISIBLEMENTE DAÑADO'),
    ('R37', 'BOQ-NO-NORM TUBO FLEX. CTO HORNO'),
    ('R38', 'DEFIC-APREC-CONDUC-EVAC-PRODUCT-COMBUST.'),
    ('R39', 'NO-DISPOS-SEG-EN-APAR-REGL-DEBEN LLEVAR'),
    ('R4', 'APAR. UBIC. LOC. VOLUMEN. INF. MINIMO'),
    ('R40', 'FUGA DE GAS'),
    ('R41', 'MAT. NO AUT. EN TUB. '),
    ('R42', 'CONTACTO TUBER. GAS CON OTRAS CONDUCCION'),
    ('R43', 'CARENCIA DE VAINAS Y/O PROTEC EN TUBERÍA'),
    ('R44', 'TUB. VISTS. SIN ELEMTOS DE SUJE. ADECU'),
    ('R45', 'TUB-EMPOT-EN-PARD-CON-HUECS-O-MUROS-RES.'),
    ('R46', 'TUB-ENTERRDS-EN SUELOS DE VIVDAS O LOCAL'),
    ('R47', 'INST-SOTA-SEMIST. GARJ. APARC. '),
    ('R48', 'INEX-MALA-UBIC-FUNCTO. INCO. LLAVE CORTE'),
    ('R49', 'INEXISTENCIA DE TOMAS DE PRES NECESARIAS'),
    ('R5', 'INEXIST. VENT. RAP. LOCAL.  REQUIERA'),
    ('R50', 'APARJE-ELEC-REC-CONJ-REG. SIN MED. ADEC.'),
    ('R51', 'CON-RG-CAL-Y-AGU-CAL-MIS-RC-S.MED. ADC.'),
    ('R52', 'CONJ. REG. EN RECINTO INSUF. VENTILADO'),
    ('R53', 'UBICACIÓN EN ZONA INUNDABLE'),
    ('R54', 'CONJ-REG-Z-COMUN-SIN-PROT-ARM-CERRDO. V.'),
    ('R55', 'NO VAL. SEG. EXC. PRE. MOP > 150 mbar'),
    ('R56', 'NO-SEG-MIN-IND-NO-EXI-MSMA-SEG-EN-I-COM.'),
    ('R57', 'INEX-LLAVE-CORTE-Y/O-TOMA-PRES-ANT-REG.'),
    ('R58', 'CONJ-REG-NO-DISP-PLAC-TARJ-O-ADHES-CORR.'),
    ('R59', 'AUSENCIA PRECINTO QUE IMPIDA MANIPUL.'),
    ('R6', 'EXTRACT. MEC. PROV, DEFIC, EVACUACIÓN'),
    ('R60', 'VENTILACIÓN INCORRECTA DEL RECINTO'),
    ('R61', 'P-ACCE-REC-NO-CERRADA-O-NO-NORM-EMP-DIST'),
    ('R62', 'APJE-MAQ-Y/O-CON-ELEC-DIST-INSUF-CON-GAS'),
    ('R63', 'EXIST-RCTO-MAQ-CUAD-CONT-MOT-TRANSF-ELEC'),
    ('R64', 'INST-ELEC. NO ACUER. CON NORMA UNE 60670'),
    ('R65', 'ILUMINACIÓN ELECTRICA NO REGLAMENTARIA'),
    ('R66', 'PUERTA DE ACCESO INADECUADA'),
    ('R67', 'CARENCIA DE SUPERFICIE NO RESISTENTE'),
    ('R68', 'INCUMP. EMPLAZ. ACCESOS O PROTEC. FUEGO'),
    ('R69', 'CARENCIA DE IDENTIFICACIÓN'),
    ('R7', 'PATIO DE VENTILACIÓN INADECUADO'),
    ('R70', 'DEFECTOS DE CARÁCTER DOCUMENTAL'),
    ('R71', 'OTRAS INADECUACIONES GRAVES'),
    ('R8', 'MAT. NO AUT. EN TUB. '),
    ('R9', 'CONTACTO TUBER. GAS CON OTRAS CONDUCCION'),
    ('A01', 'M - Fuga De Gas'),
    ('A02', 'M - Apar.Circuito Abierto BañO-Dormitorio'),
    ('A03', 'M - Tubo Flexible Visiblemente DañAdo'),
    ('A04', 'M - Flexible No Metalico Contacto P.Cal.Horn'),
    ('A05', 'M - Apar. En Local <8m3 Sin Orificio Salida'),
    ('A06', 'M - Deficiencia En Conducto Evacuación Pdc.'),
    ('A07', 'M - Extractores Forzados A Otros Cond.De Pdc'),
    ('A08', 'M - Inex.Cond.Evac.En Aparatos Que Precisan.'),
    ('A09', 'M - Ap.Tipo B En Local <8m3 Sin Ventilacion.'),
    ('A10', 'N - Ap.Tipo B En Local >8m3 Sin Ventilacion.'),
    ('A11', 'N - Estado Gral. Instal.Defect. ó Mat.Inadec'),
    ('A12', 'N - Flexible Inadec,Defect.O Contacto P.Cal.'),
    ('A13', 'N - Incump.Trazado Inst.Por Alt, Sotanos,Etc'),
    ('A14', 'N - Llaves Ap. Sin Conect.Y No Cerr.Ni Tapon'),
    ('A15', 'N - Local Con Ventilacion Inadecuada.'),
    ('A16', 'N - Local C/Volum.Insuf.Si Consumo>16kw/H'),
    ('A17', 'N - Falta Sist.Detecc.Y Corte Gas S/ 60670-6'),
    ('A18', 'M - Revoco Conduc.Evac.O Exc.Co En Ambiente'),
    ('A19', 'M - Combustion No Higienica De Los Aparatos'),
    ('A20', 'M - Inex.Disp.Ctrol.Contam.Atmosfera As'),
    ('A21', 'N - Concentracion Moderada Co Amb. En Local'),
    ('A22', 'N - Interf.Campana Extractora En Func.Ap.Gas'),
    ('A23', 'N - Func.Incorr.Disp.Seguridad Por Ext.Llama'),
    ('A24', 'N - Imposibilidad Comprob.Pdc En Ap. Tipo B'),
    ('A36', 'N - Estado Gral.Defectuoso Mat.-Tramos Inad.'),
    ('A37', 'N - Inexist.O Dificil Acceso Valvula General'),
    ('A38', 'N - Erm Sin Toma Tierra O J.Dielec.'),
    ('A39', 'N - Ventilacion Recinto Erm Insuf.O Incorr.'),
    ('A40', 'N - Ubic.Recinto O Distancias Min.Incorr.'),
    ('A41', 'N - Inex.Deterioro O Caduc. Extintor P.Seco'),
    ('A42', 'N - Inst.Electrica Erm Incumple Norm.Vigente'),
    ('A43', 'N - Inexistencia Señalizacion Correspondient'),
    ('A44', 'N - Incumpl.Reglam.Discurre Alt.Tech.Cam.Sot'),
    ('A45', 'FALTA LIBRO MANTO ACREDITE '),
    ('A46', 'M - Fuga De Gas'),
    ('A47', 'N - INSTALACIóN NO ESTANC(NIVEL FUGA 1y5 L/H'),
    ('A48', 'Existencia de grietas, apreciables visualmente, en las '
            'paredes interiores del recinto de contadores, reguladores o '
            'colectores de llaves, que posibiliten canalizar potenciales '
            'fugas de gas a la estructura del edificio [CS-9]'),
    ('A51', 'Falta orificio entrada aire'),
    ('A52', 'Entrada aire insuficiente,obstruído, etc'),
    ('A53', 'Entrada orificio entrada gases'),
    ('A54', 'Salida gases insuficiente, obstruída,etc'),
    ('A55', 'Local con volumen insuficiente'),
    ('A56', 'Ausencia ventilación rápida, necesaria'),
    ('A57', 'Distancia inadecuada caldera-cocina'),
    ('A60', 'Observaciones Acta Inspección'),
    ('A64', 'S - No Inspeccionado Obras'),
    ('A65', 'S - No Inspeccionado Local Precintado'),
    ('A66', 'S - No Inspeccionado Baja Gas'),
    ('A67', 'S - No Inspeccionado Instal. Precintada'),
    ('A68', 'S - No Inspeccionado Otras'),
    ('A69', 'Fuga de gas (>70KW)'),
    ('A70', 'Conservación o material inadecuado'),
    ('A71', 'Inexistencia válvula general del usuario'),
    ('A72', 'Incump. condicions reglamentarias > 70KW'),
    ('A73', 'Falta Certificado Mantto. y conserv > 70KW'),
    ('A74', 'Fuga de gas secundaria > 70KW'),
    ('A75', 'Conducciones de otros servicios, de acuerdo a lo indicado en el '
            'apartado 4.3 de la Norma UNE 60670-4:2014 en contacto con '
            'conducciones de gas [ISa-8]'),
    ('A79', 'Incorrecta regulación de los mínimos de '
            'los quemadores superiores de cocinas, encimeras encastrables u '
            'otros aparatos de cocción [AS-7]'),
    ('A80', 'Interferencia grave del extractor mecánico o la '
            'campana extractora en el funcionamiento de un aparato de '
            'gas [AP-4]'),
    ('A81', 'Interferencia moderada de la campana extractora en el '
            'funcionamiento de un aparato de gas [AS-2]'),
    ('A82', 'Combustión deficiente de aparatos de gas [AS-6]'),
    ('A83', 'Incorrecto funcionamiento de los quemadores de '
            'los aparatos de cocción [AS-8]'),
    ('D11', 'Fuga de gas '),
    ('D12', 'Fuga ligera de gas '),
    ('D13', 'Materiales tuberías, etc no autorizados '),
    ('D14', 'Llave corte general malas condiciones '),
    ('D15', 'Afección otras canalizaciones o instalac '),
    ('D16', 'Condiciones no reglamentarias cámaras '),
    ('D17', 'Defectuoso regulador o seguridad mínima '),
    ('D18', 'Toma aparato sin obturar '),
    ('D21', 'Flexible visiblemente dañado o agrietado'),
    ('D22', 'Flexible no adecuado '),
    ('D23', 'Flexible caducado '),
    ('D24', 'Flexible longitud inadecuada '),
    ('D25', 'Boquillas, abrazaderas o conex inadecuad '),
    ('D26', 'Flexible sometido a calor excesivo '),
    ('D31', 'Aparato a gas abierto en dormitorio, etc'),
    ('D32', 'CO amb>30 ppm + CO comb>1.000 ppm '),
    ('D33', 'Inexistencia/Incorrectos seguridad llama'),
    ('D34', 'CO amb entre 15-30/CO comb:400-1000 '),
    ('D35', 'No enclavamiento campana extractora '),
    ('D36', 'Imposibilidad comprobación emisiones '),
    ('D41', 'Revoco de gases al local '),
    ('D42', 'No conducto, siendo necesario o deficien'),
    ('D43', 'Campana o extractor a conducto evacuación'),
    ('D44', 'Conducto evacuación no estanco afectando '),
    ('D51', 'Falta orificio entrada aire '),
    ('D52', 'Entrada aire insuficiente, obstruído, etc '),
    ('D53', 'Falta orificio salida gases '),
    ('D54', 'Salida gases insuficiente, obstruída,etc '),
    ('D55', 'Local con volumen insuficiente '),
    ('D56', 'Ausencia ventilación rápida, necesaria '),
    ('D57', 'Distancia inadecuada caldera-cocina '),
    ('D60', 'Observaciones Acta Inspección '),
    ('D81', 'Estación de Regulación y/o Medida sin toma de tierra y/o '
            'juntas dieléctricas'),
    ('D82', 'Ventilación del recinto de ERM, insuficiente o incorrecta'),
    ('D83', 'Ubicación del recinto de ERM y/o distancias mínimas de '
            'seguridad incorrectas'),
    ('D84', 'Inexistencia, deterioro o caducidad de la revisión del '
            'extintor de polvo seco'),
    ('D85', 'La instalación eléctrica incumple la normativa vigente'),
    ('D86', 'Inexistencia de la señalización correspondiente'),
    ('B01', 'TUBERIAS Y ACCESORIOS'),
    ('B02', 'FLEXIBLE'),
    ('B03', 'APARATOS'),
    ('B04', 'EVACUACION DE GASES'),
    ('B05', 'LOCAL'),
    ('B10', 'TUBERIAS Y ACCESORIOS'),
    ('B11', 'G-Fuga de gas (caud > 5 L/ h)'),
    ('B12', 'Fuga ligera gas (caud entre 1-5 L/h)'),
    ('B13', 'Tuberías/soportes/uniones no aut o defic'),
    ('B14', 'Llave corte malas condic (gral, apar,..)'),
    ('B15', 'Contacto otras instalaci o canalizac'),
    ('B16', 'Cond no reglam en falsos techos, muros,.'),
    ('B17', 'Func defect regulador válvulas seguridad'),
    ('B18', 'Toma aparato sin obturar'),
    ('B19', 'Diseño / trazado tuberías'),
    ('B21', 'G-Flexibe visiblem dañado o '),
    ('B22', 'Flexible no adecuado(no norma UNE...)'),
    ('B23', 'Flexible caducado (cunado tenga fecha)'),
    ('B24', 'Long flexible inadecuada (corto o largo)'),
    ('B25', 'Boquillas, abrazaderas o conex inadecuad'),
    ('B26', 'Flexible sometido a calor excesivo'),
    ('B27', 'Flexible'),
    ('B30', 'APARATOS'),
    ('B31', 'G-Aparato circ abierto '),
    ('B32', 'G-Comb peligr CO ppm loc >30 y apa >1000'),
    ('B33', 'G-Func incorrec o inex detec falta llama'),
    ('B34', 'Mala CombCO ppm loc 15-30 apa 400-1000'),
    ('B35', 'Falta o no funciona encl campana extract'),
    ('B36', 'Imposib comprobac emisiones aparato'),
    ('B37', 'No realización mantenimiento aparato'),
    ('B38', 'inexistencia de disp.control atmosfera'),
    ('B39', 'NO HECHOS/DOCUMENTADOS CONTROLES DETEC GAS'),
    ('B40', 'EVACUACION DE GASES'),
    ('B41', 'G-Revoco de gases al local'),
    ('B42', 'G-No exist conduc '),
    ('B43', 'G-Extract conect a conduc apar tiro natu'),
    ('B44', 'NU-Conducto no estanco con afecc al local'),
    ('B45', 'NU-Aparato tiro forzado conec a cond no ade'),
    ('B46', 'NU-No cumple distancias'),
    ('B50', 'Local / Ventilaciones'),
    ('B51', 'NU-Falta orificio entrada aire'),
    ('B52', 'NU-Orif entrada aire insuf, obstruible/do'),
    ('B53', 'NU-Falta orificio para salida gases comb'),
    ('B54', 'Local ventil. incorre. Rejill.o cond PDC'),
    ('B55', 'Local con volumen insuficiente'),
    ('B56', 'Ausencia ventilación rápida (siendo nec)'),
    ('B57', 'Distancia inadecuada entre cocina-calder'),
    ('B58', 'Falla sistema detección y corte gas'),
    ('B60', 'Contadores'),
    ('B61', 'Fuga de gas '),
    ('B62', 'Instalación no estanca (entre 1 l/h y 5 l/h) '),
    ('B63', 'Estado Gral, Mat Uniones Diseño'),
    ('B70', 'Regulación'),
    ('B71', 'Inexistencia o accesibili. de la válvula'),
    ('B72', 'ERM sin toma d tierra y/o junta dieléct'),
    ('B73', 'Ventilación ERM insuficiente o incorrecta'),
    ('B74', 'Ubicación y/o distancias de seg. incorrectas '),
    ('B75', 'Inexistencia,deterioro o caduc extintor'),
    ('B76', 'Instalación eléctrica '),
    ('B77', 'Inexistencia de la señalización corresp.'),
    ('B90', 'Otros'),
    ('B95', 'Local deshabitado'),
    ('B96', 'IRI sin aparatos'),
    ('B97', 'Avería en aparato'),
    ('B99', 'Falta de los justificantes'),
    ('E00', 'Aparato a gas de tipo B que carece de c.e.p.c. o que '
            'disponiendo del mismo está ubicado en un local de V < 8 m3 que '
            'carece de orificio de ventilación [I-P-8]'),
    ('E01', 'La instalación tiene las siguientes '
            'anomalías principales (P< 70 kW) [IPa]'),
    ('E02', 'La instalación tiene las siguientes '
            'anomalías principales (P> 70 kW) [IPb]'),
    ('E03', 'Los aparatos tienen las siguientes anomalías principales [AP]'),
    ('E04', 'La instalación tiene las siguientes '
            'anomalías secundarias (P< 70 kW) [ISa]'),
    ('E05', 'La instalación tiene las siguientes '
            'anomalías secundarias (P> 70 kW) [ISb]'),
    ('E06', 'Los aparatos tienen las siguientes anomalías secundarias[AS]'),
    ('E07', 'Anomalía Principal Motivo Instalador'),
    ('E08', 'Anomalía Secundaria Motivo Instalador'),
    ('C10', 'Tuberías y accesorios'),
    ('C11', 'G-Fuga gas tram enterrado- interior edif'),
    ('C12', 'G-Fuga gas tramo aéreo ext (Q > 5 L/h)'),
    ('C13', 'Fuga gas tramo aéreo ext no grave'),
    ('C14', 'Mater tuberías,sopor o uniones no autori'),
    ('C15', 'Afección otras canaliz o instalaciones'),
    ('C16', 'Condic no reglam al atrav falsos techos'),
    ('C20', 'Regulación/ estabilizador/ seguridades'),
    ('C21', 'Ubicac en interior edif o armario no est'),
    ('C24', 'Sin protección adecuada'),
    ('C30', 'Contadores'),
    ('C31', 'Identificación incorrecta de usuarios'),
    ('C32', 'Ventilación inexistente o inadecuada'),
    ('C33', 'Instalación eléctrica deficiente'),
    ('C34', 'Existencia de instalaciones ajenas'),
    ('C35', 'Puerta o cerradura/ accesos incorrecta'),
    ('C36', 'Falta estanq.grietas techo centralizac'),
    ('C40', 'Cuarto de máquina'),
    ('C41', 'G-Incum requis ventilac o evac pr comb'),
    ('C42', 'Puerta o cerradura incorrecta cuadro m'),
    ('C43', 'Rótulos inexistentes'),
    ('C44', 'Falta libro mto o no consta última rev'),
    ('C45', 'Falta registro comprob.sist deteccion'),
    ('C50', 'Otros irc'),
    ('C55', 'Patios de ventilación (desbordamiento)'),
    ('B20', 'Flexible'),
    ('B98', 'Documentación / Otros'),
    ('C60', 'Tuberías y Accesorios en Instalaciones Industriales'),
    ('C70', 'Regulación en Instalaciones Industriales'),
    ('C98', 'Documentación / Otros'),
    ('D10', 'Tuberías y Accesorios'),
    ('D20', 'Flexible'),
    ('D30', 'Aparatos'),
    ('D40', 'Evacuación de Gases'),
    ('D50', 'Local / Ventilaciones'),
    ('D70', 'Regulación en Instalaciones Industriales'),
    ('D98', 'Documentación / Otros'),
]

TAULA_SI_NO = [
    ('S', 'Sí'),
    ('N', 'No'),
]
TAULA_INDICATIVO_SI = TAULA_SI_NO

TAULA_MODELO_FECHA_EFECTO = [
    ('01', 'Primer valor posible estimado (1/11/21)'),
    ('02', 'Primer valor posible de lectura (mensual/bimestral)'),
    ('03', 'Fecha de efecto estimada concreta (1/11/21)'),
    ('04', 'Fecha de efecto estimada concreta'),
    ('05', 'Cuanto antes'),
]
TAULA_MODELO_FECHA_EFECTO_PREVISTA = [
    ('01', 'Primer valor posible estimado (1/11/21)'),
    ('02', 'Primer valor posible de lectura (mensual/bimestral)'),
    ('03', 'Fecha de efecto estimada concreta (1/11/21)'),
    ('04', 'Fecha de efecto estimada concreta'),
    ('11', 'Fecha Fija por concurrencia con solicitud de Baja 01'),
    ('12', 'Fecha Fija por concurrencia con solicitud de Baja 02'),
    ('13', 'Fecha Fija por concurrencia con solicitud de Baja 04'),
    ('14', 'Fecha Fija por concurrencia con solicitud de Baja 05'),
    ('15', 'Fecha Fija por actuación de reapertura del PS '),
    ('16', 'Fecha fija por incumplimiento del plazo mínimo de preaviso'),
]

TAULA_TIPO_PEAJE = [
    ('11', '11 - Presión > 60 bares y Consumo <= 200 GWh/año'),
    ('12', '12 - Presión > de 60 bares y  200 GWh/año < Consumo <= 1000 GWh/año'),
    ('13', '13 - Presión > 60 bares y  Consumo > 1000 GWh/año'),
    ('21', '21 - 4 bares < Presión <= 60 bares y Consumo <= 500 MWh/año'),
    ('22', '22 - 4 bares < Presión <= 60 bares y 500 MWh/año < Consumo <= 5000 MWh/año'),
    ('23', '23 - 4 bares < Presión <= 60 bares y 5000 MWh/año < Consumo <= 30000 MWh/año'),
    ('24', '24 - 4 bares < Presión <= 60 bares y 30000 MWh/año < Consumo <= 100000 MWh/año'),
    ('25', '25 - 4 bares < Presión <= 60 bares y  100000 MWh/año < Consumo <= 500000 MWh/año'),
    ('26', '26 - 4 bares < Presión <= 60 bares y  500000 MWh/año < Consumo'),
    ('1B', '1B - Presión <= 4 bares y  Consumo <= 500 MWh/año'),
    ('2B', '2B - Presión <= 4 bares y  500 MWh/año < Consumo <= 5000 MWh/año'),
    ('3B', '3B - Presión <= 4 bares y  5000 MWh/año < Consumo <= 30000 MWh/año'),
    ('4B', '4B - Presión <= 4 bares y  30000 MWh/año < Consumo <= 100000 MWh/año'),
    ('5B', '5B - Presión <= 4 bares y  100000 MWh/año < Consumo <= 500000 MWh/año'),
    ('6B', '6B - Presión <= 4 bares y  500000 MWh/año < Consumo'),
    ('31', '31 - Presión <= 4 bares y  Consumo <= 5000 kWh/año'),
    ('32', '32 - Presión <= 4 bares y  5000 kWh/año < Consumo <= 50000 kWh/año'),
    ('33', '33 - Presión <= 4 bares y  50000 kWh/año < Consumo <= 100000 kWh/año'),
    ('34', '34 - Presión <= 4 bares y 100000 Kwh/año < Consumo <= 100 Gwh/año'),
    ('35', '35 - Presión <= 4 bares y 100 GWh/año < Consumo'),
    ('41', '41 - Presión > 60 bares y consumo <= 200 GWh/año'),
    ('42', '42 - Presión > 60 bares y  200 GWh/año < Consumo <=1.000 GWh/año'),
    ('43', '43 - Presión > 60 bares y consumo > 1.000  GWh/año  '),
    ('44', '44 - 4 bares < Presión <= 60 bares y 10 GWh/año < Consumo <= 30 GWh/año'),
    ('45', '45 - 4 bares < Presión <= 60 bares y 30 GWh/año < Consumo <= 100 GWh/año'),
    ('46', '46 - 4 bares < Presión <= 60 bares y 100 GWh/año < Consumo <= 500 GWh/año'),
    ('47', '47 - 4 bares < Presión <= 60 bares y Consumo > 500 GWh/año'),
    ('A1', 'A1 - Presión > 60 bares y Consumo <= 200 GWh/año'),
    ('A2', 'A2 - Presión > de 60 bares y 200 GWh/año < Consumo <= 1000 GWh/año '),
    ('A3', 'A3 - Presión > 60 bares y Consumo > 1000 GWh/año '),
    ('B1', 'B1 - 4 bares < Presión <= 60 bares y 100000 MWh/año < Consumo <= 500000 MWh/año'),
    ('B2', 'B2 - 4 bares < Presión <= 60 bares y 500000 MWh/año < Consumo '),
    ('C1', 'C1 - Centrales de generación eléctrica (grupo 4)  con  4 bar < Presión  <= 60 bar'),
    ('C2', 'C2 - Centrales de generación eléctrica (grupo 4),  Presión >  60 bar'),
    ('D1', 'D1 - Resto clientes (grupo 4), 4  bar < Presión  <= 60 bar'),
    ('D2', 'D2 - Resto clientes (grupo 4), Presión >  60 bar'),
    ('M1', 'M1 - Materia Prima 1'),
    ('M2', 'M2 - Materia Prima 2'),
    ('99', 'Factura agregada D-C'),
]

TAULA_TIPOS_DE_USO_DEL_GAS_EXTENDED = [
    ('01', '05', 'Combustible', '01/01/2002', 'NO'),
    ('02', '05', 'Carburantes', '01/01/2002', 'NO'),
    ('03', '05', 'Motores Estacionarios', '01/01/2002', 'SI'),
    ('04', '05', 'Depósitos Fiscales', '01/01/2002', 'NO'),
    ('01', '02', 'Combustible', '01/01/2002', 'NO'),
    ('02', '02', 'Carburantes', '01/01/2002', 'NO'),
    ('03', '02', 'Motores Estacionarios', '01/01/2002', 'SI'),
    ('04', '02', 'Depósitos Fiscales', '01/01/2002', 'NO'),
    ('01', '41', 'Combustible', '01/01/2002', 'NO'),
    ('02', '41', 'Carburantes', '01/01/2002', 'NO'),
    ('03', '41', 'Motores Estacionarios', '01/01/2002', 'SI'),
    ('04', '41', 'Depósitos Fiscales', '01/01/2002', 'NO'),
    ('01', '25', 'Combustible', '01/01/2002', 'NO'),
    ('02', '25', 'Carburantes', '01/01/2002', 'NO'),
    ('03', '25', 'Motores Estacionarios', '01/01/2002', 'SI'),
    ('04', '25', 'Depósitos Fiscales', '01/01/2002', 'NO'),
    ('01', '26', 'Combustible', '01/01/2002', 'NO'),
    ('02', '26', 'Carburantes', '01/01/2002', 'NO'),
    ('03', '26', 'Motores Estacionarios', '01/01/2002', 'SI'),
    ('04', '26', 'Depósitos Fiscales', '01/01/2002', 'NO'),
    ('01', '38', 'Doméstico', '01/01/2002', 'NO'),
    ('02', '38', 'Comercial', '01/01/2002', 'NO'),
    ('04', '38', 'Cuarto de Calderas', '01/01/2002', 'NO'),
    ('01', '39', 'Doméstico', '01/01/2002', 'NO'),
    ('02', '39', 'Comercial', '01/01/2002', 'NO'),
    ('04', '39', 'Cuarto de Calderas', '01/01/2002', 'NO'),
    ('11', 'TODOS', 'Combustible calderas centralizadas', 'Pendiente directiva', 'Pendiente directiva', 'NO'),
    ('12', 'TODOS', 'Combustible calderas centralizadas para fines profesionales', 'Pendiente directiva', 'Pendiente directiva', 'NO'),
    ('13', 'TODOS', 'Combustible calderas centralizadas para fines no profesionales', 'Pendiente directiva', 'Pendiente directiva', 'NO'),
    ('14', 'TODOS', 'Carburante motores estacionarios', 'Pendiente directiva', 'Pendiente directiva', 'SI'),
    ('15', 'TODOS', 'Carburante motores no estacionarios', 'Pendiente directiva', 'Pendiente directiva', 'NO'),
    ('16', 'TODOS', 'Carburante motores no estacionarios para vehículos particulares', 'Pendiente directiva', 'Pendiente directiva', 'NO'),
    ('17', 'TODOS', 'Carburante motores no estacionarios para vehículos industriales', 'Pendiente directiva', 'Pendiente directiva', 'NO'),
    ('18', 'TODOS', 'Carburante motores no estacionarios para vehículos comerciales', 'Pendiente directiva', 'Pendiente directiva', 'NO'),
]
TAULA_TIPOS_DE_USO_DEL_GAS = [
    (tipo[0], tipo[2]) for tipo in TAULA_TIPOS_DE_USO_DEL_GAS_EXTENDED
]
TAULA_TIPO_CORRECTOR = [
    ('01', 'PT'),
    ('02', 'PTZ'),
    ('03', 'Unidad Remota '),
    ('04', 'No aplica'),
    ('05', 'Energía'),
    ('06', 'Unidad Remota PTZ'),
]
TAULA_PROPIEDAD_CONTADOR_CORRECTOR = [
    ('04', 'PROPIO-CONTADO'),
    ('06', 'PROPIO-PLAZOS-6'),
    ('01', 'DEPOSITO'),
    ('02', 'ALQUILER'),
    ('11', 'SUSTITUCION'),
    ('12', 'NUEVO'),
    ('08', 'PROPIO-PLAZOS-12'),
    ('10', 'PROPIO'),
]
TAULA_PROPIEDAD_CONTADOR = TAULA_PROPIEDAD_CONTADOR_CORRECTOR

TAULA_PRESION_COMUNITARIA = [
    ('MP', 'ENTRE 0,4 Y BARS MAX. '),
    ('MPA', 'MEDIA PRESION A '),
    ('MPB', 'MEDIA PRESION B '),
    ('B5', 'HASTA 500 MM. C.A. '),
    ('BB', 'PRESION MAX. HASTA 270MMM '),
    ('AP', 'MAS 4 BARS PRES. MAX '),
    ('A12', 'ALTA PRESION 12 BAR '),
    ('A16', 'ALTA PRESION 16 BAR '),
    ('BC', 'PRESIONMAX. HASTA 270MM. C.A. CONREGU'),
    ('MAB', 'MPA DISE¦O MPB '),
    ('MB', 'DE 0,4 A 4 BARS MAX. '),
    ('MA', 'HASTA 1000 MM. C.A. '),
    ('BP', 'BAJA PRESION '),
    ('BV', 'PRESIONMAX. HASTA 270MM. C.A. CONVALV'),
]
TAULA_TIPO_LECTURA = [
    ('0', 'Estimada'),
    ('1', 'Real'),
    ('2', 'Facilitada por cliente'),
]
TAULA_MOTIVO_BAJA = [
    ('01', 'A petición del cliente por cese de su actividad'),
    ('02', 'A solicitud del comercializador por impago del cliente'),
    ('04', 'A solicitud del comercializador por problemas de '
           'seguridad derivados de inspección'),
    ('05', 'A solicitud del comercializador por fin de contrato de energía'),
]
TAULA_MOTIVO_MODIFICACION = [
    ('01', 'Cambio de Titular'),
    ('04', 'Cambio de Datos del Cliente'),
    ('09', 'Cambio Código CAE'),
    ('10', 'Cambio de dirección del titular'),
    ('11', 'Cambio de Peaje'),
    ('12', 'Cambio de Titular y Peaje'),
    ('13', 'Modificación de Capacidad'),
    ('14', 'Cambio de Titular y Modificación de Capacidad'),
    ('15', 'Cambio de Peaje y Modificación de Capacidad'),
    ('16', 'Cambio de Titular, Peaje y Modificación de Capacidad'),
    ('17', 'Cambio de Titular y Dirección de Titular'),
    ('18', 'Cambio de Peaje y Dirección de Titular'),
    ('19', 'Cambio de Titular, Dirección de Titular y Peaje'),
    ('20', 'Modificación de Capacidad y Cambio de Dirección de Titular'),
    ('21', 'Cambio de Titular, Dirección de Titular y Modificación de Capacidad'),
    ('22', 'Cambio de Peaje, Dirección de Titular y Modificación de Capacidad'),
    ('23', 'Cambio de Titular, Dirección de Titular, Peaje y Modificación de Capacidad'),
    ('24', 'Cambio de Dirección del Punto de Suministro'),
]
TAULA_MOTIVO_DE_MODIFICACION_EN_UN_CAMBIO_DE_COMERCIALIZADOR = [
    ('01', 'Cambio de Titular'),
    ('02', 'Ampliación de Caudal.'),
    ('03', 'Cambio de titular y Ampliación de Caudal.'),
]
TAULA_MOTIVO_ANULACION = [
    ('002', 'Anulación de Solicitud de Cambio de Comercializadora'),
    ('004', 'Anulación de Solicitud de Baja'),
    ('014', 'Anulación de Solicitud de Baja desde SCTD por '
            'concurrencia Baja / Cambio'),
    ('016', 'Anulación de Solicitud de Cambio desde SCTD por '
            'concurrencia A102 / B1625'),
    ('017', 'Anulación de Solicitud de Baja desde SCTD por '
            'concurrencia A104 / B1625'),
    ('018', 'Anulación de Solicitud de NNSS'),
    ('019', 'Anulación de Solicitud de Cambio de Comercializadora con '
            'Modificación de datos'),
    ('020', 'Anulación de Solicitud de Cambio con Modificación desde '
            'SCTD por concurrencia A141 / B1625'),
]
TAULA_ESTADO_PUNTO_DE_SUMINISTRO = [
    ('0', 'Sin servicio'),
    ('1', 'En servicio'),
]
TAULA_TIPO_DE_APARATO = [
    ('CO', 'Contador'),
    ('CR', 'Corrector'),
    ('UR', 'Unidad Remota'),
]
TAULA_TIPO_DE_LECTURA_DE_NUMERADOR = [
    ('BR', 'Bruta'),
    ('CR', 'Corregida'),
]
TAULA_MOTIVO_DE_LECTURA = [
    ('01', 'Lectura Inicio'),
    ('02', 'Lectura Fin'),
    ('03', 'Lectura Intermedia'),
    ('04', 'Lectura Periódica o de Cálculo'),
]
TAULA_PERIODICIDAD_DE_DISCRIMINACION_HORARIA = [
    ('01', 'Punta + Llano'),
    ('03', 'Valle'),
    ('10', 'Totalizador'),
]
TAULA_TIPO_DE_DISCRIMINACION_HORARIA = [
    ('00', 'Dos períodos (Tarifa Nocturna)'),
    ('01', 'Sin discriminación horaria'),
]
TAULA_TIPO_FACTURA = [
    ('01', 'Factura ATR Individual'),
    ('11', 'Pseudofactura'),
    ('99', 'Factura ATR Agregada'),
]
TAULA_CLASE_FACTURA_O_TIPO_DE_FACTURA_RECTIFICADORA = [
    ('N', 'Normal'),
    ('A', 'Anuladora'),
    ('R', 'Rectificadora'),
    ('B', 'Anuladora con sustituyente'),
]
TAULA_TIPO_FACTURACION = [
    ('1', 'Regular (periodo completo)'),
    ('2', 'Irregular (periodo incompleto)'),
]
TAULA_NIVEL_CONCEPTOS_FACTURACION = [
    ('0', 'Nivel de Factura'),
    ('1', 'Nivel de CUPS'),
    ('2', 'Nivel de Unidad de Medida'),
    ('3', 'Nivel de Aparato de Medida'),
]
TAULA_CONCEPTOS_FACTURACION = [
    ('0', '0000', 'Importe Total Factura'),
    ('0', '0001', 'SALDO FACTURA'),
    ('0', '0002', 'SALDO COBRO'),
    ('0', '0003', 'Importe Facturación de alquileres'),
    ('1', '0003', 'Importe Facturación de alquileres'),
    ('2', '0003', 'Importe Facturación de alquileres'),
    ('0', '0004', 'IMPORTE DE INTERESES'),
    ('0', '0005', 'CONCEPTO AÑADIDO CON BASE IMPUESTO ESPECIFICO E IVA'),
    ('0', '0006', 'CONCEPTO AÑADIDO CON BASE IVA'),
    ('0', '0007', 'Importe base imponible IVA-IGIC'),
    ('0', '0008', 'Importe impuesto IVA-IGIC'),
    ('0', '0009', 'IMPORTE BASE IMPONIBLE IVA-IGIC REDUCIDO'),
    ('0', '0010', 'IMPORTE IMPUESTO IVA-IGIC REDUCIDO'),
    ('0', '0011', 'BASE IMPONIBLE'),
    ('0', '0012', 'Importe alquiler corrector'),
    ('1', '0012', 'Importe alquiler corrector'),
    ('2', '0012', 'Importe alquiler corrector'),
    ('2', '0013', 'Importe alquiler unidad remota'),
    ('0', '0013', 'Importe alquiler unidad remota'),
    ('0', '0014', 'Importe cesión contador'),
    ('1', '0014', 'Importe cesión contador'),
    ('2', '0014', 'Importe cesión contador'),
    ('0', '0015', 'Importe Inspección I.R.G. Importe Inspección IRI'),
    ('1', '0015', 'Importe Inspección I.R.G. Importe Inspección IRI'),
    ('2', '0015', 'Importe Inspección I.R.G. Importe Inspección IRI'),
    ('0', '0016', 'Término fijo peaje'),
    ('0', '0017', 'Término variable peaje'),
    ('0', '0330', 'Descuento por Interrupción de Suministro'),
    ('1', '0330', 'Descuento por Interrupción de Suministro'),
    ('0', '0430', 'Intervención-Reparación Instalación'),
    ('1', '0430', 'Intervención-Reparación Instalación'),
    ('0', '0433', 'Operaciones y Servicios'),
    ('1', '0433', 'Operaciones y Servicios'),
    ('1', '0438', 'Visita Faliida'),
    ('0', '0490', 'Reapertura Suministro'),
    ('1', '0490', 'Reapertura Suministro'),
    ('1', '1023', 'COMPLEMENTO DE POTENCIA/CAUDAL'),
    ('1', '1024', 'SUPLEMENTO DE POTENCIA/CAUDAL'),
    ('1', '1031', 'COMP. DISCRIMINACION HORARIA'),
    ('1', '1032', 'COMP. DISCRIMINACION HORARIA *'),
    ('1', '1041', 'COMPLEMENTO INTERRUMPIBILIDAD'),
    ('1', '1042', 'DESCUENTO APORTACION POTENCIA/CAUDAL'),
    ('1', '1051', 'COMPLEMENTO DE ESTACIONALIDAD'),
    ('1', '1052', 'REGULARIZACION TERM. POTENCIA/CAUDAL'),
    ('1', '1053', 'REGULARIZACION COMPL. REACTIVA'),
    ('0', '1070', 'DESCUENTO SEGUN CONTRATO'),
    ('1', '1070', 'DESCUENTO SEGUN CONTRATO'),
    ('1', '1095', 'ALQ.AVISADOR CONSUMO ELECTRICO'),
    ('0', '1101', 'IMPORTE A SUMAR/RESTAR EN BASE IVA-OFI'),
    ('0', '1102', 'IMPORTE A SUMAR/RESTAR EN BASE IVA'),
    ('0', '1103', 'REPERCUSION DE CUOTAS OFICO'),
    ('0', '1104', 'REFACTURACION APLICADA'),
    ('0', '1105', 'IMPORTE REGULARIZADO SIN IVA'),
    ('0', '1106', 'PEAJE'),
    ('1', '1150', 'DESCUENTO POR GESTION DE EXPLOTACION'),
    ('2', '1201', 'ACONDICIONAMIENTO APARATO DE MEDIDA'),
    ('1', '1202', 'COMPROBACION DERIVACION A TIERRA'),
    ('1', '1203', 'REPERCUSION DE GASTOS FINANCIEROS'),
    ('1', '1204', 'INSTALACION CAJA DE FUSIBLES'),
    ('1', '1205', 'INSTALACION CERRADURA EN PL'),
    ('1', '1206', 'INSTALACION DISYUNTOR DIFERENCIAL'),
    ('1', '1207', 'INSTALACION DERIVACION INDIVIDUAL'),
    ('1', '1208', 'INSTALACION DE LAMPARAS'),
    ('1', '1209', 'INSTALACION LINEA REPARTIDORA'),
    ('1', '1210', 'Mantenimiento de instalaciones'),
    ('2', '1211', 'SUSTITUCION CARETA APARATO DE MEDIDA'),
    ('0', '1212', 'Intereses de demora'),
    ('0', '1213', 'CARGO POR ERROR DE FACTURACION'),
    ('0', '1214', 'ABONO POR ERROR DE FACTURACION'),
    ('2', '1215', 'CARGO EQUIPOS MEDIDA'),
    ('2', '1216', 'MODIFICACION MEMORIA APARATO MEDIDA'),
    ('0', '1217', 'ABONO MERCADO LIBERALIZADO'),
    ('0', '1218', 'CARGO MERCADO LIBERALIZADO'),
    ('2', '1219', 'PRECIO FINANCIACION DE INSTALACIONES'),
    ('2', '1220', 'CUOTA FINANCIACION DE INSTALACIONES'),
    ('2', '1221', 'COMPL. CURVA DE CARGA'),
    ('2', '1222', 'COMPL. VOLUMEN DE CONSUMO'),
    ('2', '1223', 'Compl. factor de utilización'),
    ('1', '1224', 'COMPLEMENTOS DE PRECIO'),
    ('1', '1225', 'ABONO EXTRAORDINARIO POR COMPLEMENTOS'),
    ('0', '1301', 'Indemnización'),
    ('1', '1302', 'Canon Finca'),
    ('1', '1303', 'IMPUESTO DE VALOR AÑADIDO'),
    ('0', '1310', 'Indemnización Cortes indebidos'),
    ('0', '1311', 'INDEMNIZACION GASTOS FINANCIEROS'),
    ('0', '1312', 'INDEMNIZACION OTROS COMERCIAL'),
    ('0', '1319', 'Indemnización Distribución'),
    ('1', '1319', 'Indemnización Distribución'),
    ('0', '1320', 'INCUMPLIM.EN CALIDAD DE ATENC. CONSUMIDOR'),
    ('0', '1330', 'INDEM. PRESUPUESTO NUEVOS SUMINISTROS'),
    ('0', '1331', 'INDEM. EJECUCION INSTALACIONES'),
    ('0', '1332', 'INDEM. INSTALACION EQUIPO MEDIDA'),
    ('0', '1333', 'INDEM. ATENCION A RECLAMACIONES'),
    ('0', '1334', 'INDEM. ENGANCHE DESPUES DE CORTE'),
    ('0', '1335', 'INDEM. EJECUCION INDEBIDA CORTE'),
    ('1', '1401', 'Derechos acometida de extensión'),
    ('1', '1402', 'Derechos acometida de acceso'),
    ('1', '1403', 'CARGO POR NO CESION DE LOCAL'),
    ('1', '1501', 'DESCUENTOS POR CESION DE LOCAL PARA CT'),
    ('1', '1502', 'TRABAJOS INSTALACIONES SOLIC POR CLIENTE'),
    ('1', '1503', 'BONIFIC SOBRE TRABAJOS EN INSTALACIONES'),
    ('1', '1601', 'Derechos de enganche'),
    ('1', '1602', 'Derechos de verificación instalaciones'),
    ('1', '1604', 'Devolución de fianza'),
    ('1', '1605', 'Derechos de acometida'),
    ('1', '1606', 'ACONDICIONAMIENTO INSTALACION 2.0N'),
    ('2', '1607', 'ACONDTO. INSTALAC. DOBLE TARIFA'),
    ('2', '1608', 'ACONDTO. INSTALAC. MEDIDA INDIRECTA BT'),
    ('3', '1609', 'Verificación aparato de medida'),
    ('1', '1609', 'Verificación Equipo'),
    ('1', '1611', 'BONIFICACION DERECHOS ACCESO'),
    ('1', '1612', 'BONIFICACION DERECHOS DE EXTENSION'),
    ('1', '1613', 'Fianza'),
    ('3', '1614', 'BONIFICACION ACONDICIONAMIENTO MEDIDA'),
    ('1', '1615', 'ACONDTO. INSTALAC. ST AT'),
    ('1', '1616', 'ACONDTO. INSTALAC. DT/TT AT'),
    ('1', '1617', 'ACONDTO. CAMBIO ST DT/TT AT'),
    ('1', '1618', 'COMPENSACION ART. 15 R.A.E. 2949/1982'),
    ('1', '1701', 'DESPRECINTE'),
    ('2', '1702', 'CAMBIO EMPLAZAMIENTO APARATO DE MEDIDA'),
    ('1', '1703', 'Derechos de reconexión'),
    ('0', '1801', 'CARGO POR SERVICIOS ATENCION TELEFONICA'),
    ('0', '1802', 'CARGO POR SERVICIOS DE SOPORTE COMERCIAL'),
    ('0', '1803', 'CARGO POR COMISIONES A SUMINISTRADORES'),
    ('0', '1804', 'CARGO POR SERVICIOS A CLIENTES'),
    ('3', '1805', 'CARGO POR ARRENDAMIENTO DE EQUIPOS'),
    ('0', '1806', 'Venta de productos y servicios a nivel de Factura'),
    ('1', '1806', 'Venta de productos y servicios a nivel de CUPS'),
    ('2', '1806', 'Venta de productos y servicios a nivel de Unidad de Medida'),
    ('3', '1806', 'Venta de productos y servicios a nivel de '
                  'Aparato de Medida'),
    ('0', '1901', 'Concepto extraordinarios 1 a nivel de Factura'),
    ('1', '1901', 'Concepto extraordinarios 1 a nivel de CUPS'),
    ('2', '1901', 'Concepto extraordinarios 1 a nivel de Unidad de Medida'),
    ('3', '1901', 'Concepto extraordinarios 1 a nivel de Aparato de Medida'),
    ('0', '1902', 'Concepto extraordinarios 2 a nivel de Factura'),
    ('1', '1902', 'Concepto extraordinarios 2 a nivel de CUPS'),
    ('2', '1902', 'Concepto extraordinarios 2 a nivel de Unidad de Medida'),
    ('3', '1902', 'Concepto extraordinarios 2 a nivel de Aparato de Medida'),
    ('0', '1903', 'Concepto extraordinarios 3 a nivel de Factura'),
    ('1', '1903', 'Concepto extraordinarios 3 a nivel de CUPS'),
    ('2', '1903', 'Concepto extraordinarios 3 a nivel de Unidad de Medida'),
    ('3', '1903', 'Concepto extraordinarios 3 a nivel de Aparato de Medida'),
    ('0', '1904', 'CONCEPTO EXTRAORDINARIOS 4'),
    ('1', '1904', 'CONCEPTO EXTRAORDINARIOS 4'),
    ('2', '1904', 'CONCEPTO EXTRAORDINARIOS 4'),
    ('3', '1904', 'CONCEPTO EXTRAORDINARIOS 4'),
    ('0', '1905', 'CONCEPTO EXTRAORDINARIOS 5'),
    ('1', '1905', 'CONCEPTO EXTRAORDINARIOS 5'),
    ('2', '1905', 'CONCEPTO EXTRAORDINARIOS 5'),
    ('3', '1905', 'CONCEPTO EXTRAORDINARIOS 5'),
    ('0', '1906', 'CONCEPTO EXTRAORDINARIOS 6'),
    ('1', '1906', 'CONCEPTO EXTRAORDINARIOS 6'),
    ('2', '1906', 'CONCEPTO EXTRAORDINARIOS 6'),
    ('3', '1906', 'CONCEPTO EXTRAORDINARIOS 6'),
    ('0', '1907', 'Revisión metrológica de equipo '),
    ('1', '1908', 'Gastos Derivados Visitas Inspección Previa Alta'),
    ('1', '1909', 'Gastos Administración'),
    ('1', '1910', 'Derechos de alta'),
    ('1', '1911', 'Canon IRC 1'),
    ('1', '1912', 'Canon IRC 2'),
    ('1', '1913', 'Canon Plan 10'),
    ('0', '1914', 'Impuesto especial sobre hidrocarburos'),
    ('0', '1915', 'Inspección periódica industrial'),
    ('0', '1916', 'Reapertura instalación gas a nivel de Factura'),
    ('1', '1916', 'Reapertura instalación gas a nivel de CUPS'),
    ('2', '1916', 'Reapertura instalación gas '),
    ('3', '1916', 'Reapertura instalación gas '),
    ('0', '1917', 'Reapertura suministro'),
    ('1', '1917', 'Reapertura suministro'),
    ('2', '1917', 'Reapertura suministro'),
    ('3', '1917', 'Reapertura suministro'),
    ('0', '1918', 'Desconexión contador a nivel de Factura'),
    ('1', '1918', 'Desconexión contador a nivel de CUPS'),
    ('2', '1918', 'Desconexión contador '),
    ('3', '1918', 'Desconexión contador '),
    ('0', '1919', 'Cambio contador a nivel de Factura'),
    ('1', '1919', 'Cambio contador a nivel de CUPS'),
    ('2', '1919', 'Cambio contador '),
    ('3', '1919', 'Cambio contador '),
    ('0', '1920', 'Comprobación contador y/o lectura a nivel de Factura'),
    ('1', '1920', 'Comprobación contador y/o lectura a nivel de CUPS'),
    ('2', '1920', 'Comprobación contador y/o lectura '),
    ('3', '1920', 'Comprobación contador y/o lectura'),
    ('0', '1921', 'Reapertura instalación gas con certificado a '
                  'nivel de Factura'),
    ('1', '1921', 'Reapertura instalación gas con certificado a nivel de CUPS'),
    ('2', '1921', 'Reapertura instalación gas con certificado '),
    ('3', '1921', 'Reapertura instalación gas con certificado '),
    ('0', '1922', 'Cierre por falta de pago'),
    ('1', '1922', 'Cierre por falta de pago'),
    ('2', '1922', 'Cierre por falta de pago'),
    ('3', '1922', 'Cierre por falta de pago'),
    ('0', '1923', 'INTERVENCION RAPIDA'),
    ('1', '1923', 'INTERVENCION RAPIDA'),
    ('2', '1923', 'INTERVENCION RAPIDA'),
    ('3', '1923', 'INTERVENCION RAPIDA'),
    ('0', '1924', 'INTERVENCION RAPIDA'),
    ('1', '1924', 'INTERVENCION RAPIDA'),
    ('2', '1924', 'INTERVENCION RAPIDA'),
    ('3', '1924', 'INTERVENCION RAPIDA'),
    ('0', '1925', 'INTERVENCION IRC'),
    ('1', '1925', 'INTERVENCION IRC'),
    ('2', '1925', 'INTERVENCION IRC'),
    ('3', '1925', 'INTERVENCION IRC'),
    ('0', '1926', 'INTERVENCION IRC'),
    ('1', '1926', 'INTERVENCION IRC'),
    ('2', '1926', 'INTERVENCION IRC'),
    ('3', '1926', 'INTERVENCION IRC'),
    ('0', '1927', 'MATERIALES UTILIZADOS EN INTERVENCION'),
    ('1', '1927', 'MATERIALES UTILIZADOS EN INTERVENCION'),
    ('2', '1927', 'MATERIALES UTILIZADOS EN INTERVENCION'),
    ('3', '1927', 'MATERIALES UTILIZADOS EN INTERVENCION'),
    ('1', '1928', 'CANON IRC 3'),
    ('1', '1929', 'INSPECCION PERIÓDICA IRC'),
    ('0', '1930', 'Gastos de gestión de Inspección Periódica de IRI de '
                  'la empresa distribuidora'),
    ('1', '1930', 'Gastos de gestión de Inspección Periódica de IRI de '
                  'la empresa distribuidora'),
    ('0', '1931', 'Gastos de gestión de Inspección Periódica de IRC de '
                  'la empresa distribuidora'),
    ('1', '1931', 'Gastos de gestión de Inspección Periódica de IRC de '
                  'la empresa distribuidora'),
    ('0', '1932', 'Gastos de inspección física de la '
                  'Inspección Periódica de IRI'),
    ('1', '1932', 'Gastos de inspección física de la '
                  'Inspección Periódica de IRI'),
    ('0', '1933', 'Gastos de inspección física de la '
                  'Inspección Periódica de IRC '),
    ('1', '1933', 'Gastos de inspección física de la '
                  'Inspección Periódica de IRC '),
    ('0', '1934', 'Presentación al cobro factura Inspección Periódica de '
                  'IRI realizada por empresa instaladora'),
    ('1', '1934', 'Presentación al cobro factura Inspección Periódica de '
                  'IRI realizada por empresa instaladora'),
    ('0', '1935', 'Presentación al cobro factura Inspección Periódica de '
                  'IRC realizada por empresa instaladora'),
    ('1', '1935', 'Presentación al cobro factura Inspección Periódica de '
                  'IRC realizada por empresa instaladora'),
    ('1', '1936', 'Canon IRC 4'),
]
TAULA_CONCEPTO_FACTURACION = [(a[1], a[2]) for a in TAULA_CONCEPTOS_FACTURACION]

TAULA_MOTIVO_REGULARIZACION_CONSUMO = [
    ('01', 'Verificación equipo de medida'),
    ('02', 'Avería en contador'),
    ('03', 'Avería en corrector'),
    ('04', 'Avería en unidad remota'),
    ('05', 'Avería en trafo de tensión'),
    ('06', 'Avería en trafo de intensidad'),
    ('07', 'Desbordamiento del registrador'),
    ('08', 'Problemas en la sincronización del registrador'),
    ('09', 'Pérdida de alimentación del registrador'),
    ('10', 'Manipulación de equipos'),
    ('11', 'Servicio directo (sin EM)'),
    ('12', 'Punto de medida inaccesible'),
    ('13', 'Punto de medida ilocalizable'),
    ('99', 'Otros'),
]
TAULA_TIPO_DE_IMPUESTO = [
    ('01', 'IVA'),
    ('02', 'Impuesto Especial de Hidrocarburos (IEH)'),
]
TAULA_TIPO_DISCRIMINACIoN_HORARIA = [
    ('00', 'Con discriminación horaria'),
    ('01', 'Sin discriminación horaria'),
]
TAULA_MOTIVO_LECTURA = [
    ('01', 'Lectura Inicio'),
    ('02', 'Lectura Fin'),
    ('03', 'Lectura Intermedia'),
    ('04', 'Lectura Periódica o de Cálculo'),
]
TAULA_PERIODICIDAD_LECTURA_FACTURACION = [
    ('M', 'Mensual'),
    ('B', 'Bimestral'),
    ('A', 'Anual'),
    ('S', 'Semestral'),
    ('D', 'Diaria'),
]
TAULA_TIPO_CIERRE = [
    ('001', 'La Actualización de Datos se ha realizado correctamente'),
    ('002', 'Operación Realizada'),
    ('003', 'Se facilita la información requerida'),
    ('004', 'Se ha gestionado y solucionado la Reclamación'),
    ('005', 'Se acepta Reclamación y se corrige valor'),
    ('006', 'Se acepta Reclamación y se procede al envío del mensaje'),
    ('007', 'Se ha gestionado y se ha vuelto al Concertar Visita'),
    ('008', 'Se ha rectificado Factura y se ha realizado el '
            'extorno correspondiente'),
    ('009', 'Se incorpora Documento aportado'),
    ('010', 'Se remite Documento solicitado'),
    ('011', 'Se ha creado Operación de IP ausente sobre el CUPS solicitado'),
    ('012', 'La Actualización de la Lectura se ha realizado correctamente'),
    ('013', 'La Solicitud recibida no es coherente'),
    ('014', 'No se puede modificar la información recibida'),
    ('015', 'No está autorizado para realizar esta solicitud'),
    ('016', 'Existe solicitud pendiente del mismo tipo en '
            'el punto de suministro'),
    ('017', 'Existe trabajo pendiente incompatible con la operación solicitada'),
    ('018', 'Existe trabajo pendiente del mismo tipo en el punto de suministro'),
    ('019', 'Existe solicitud pendiente incompatible en el punto de suministro'),
    ('020', 'Se ha recibido solicitud de cambio para el mismo CUPS'),
    ('021', 'Operación pendiente concertada'),
    ('022', 'Excedido tiempo máximo de la solicitud.'),
    ('023', 'Anulada por nueva petición de Comercializadora'),
    ('024', 'Anulada a petición de Comercializadora'),
    ('025', 'Se ha recibido solicitud de cese para el mismo CUPS'),
    ('026', 'El cliente está cesado'),
    ('027', 'No se ha podido contactar con el cliente'),
    ('028', 'No realizada por causas imputables al cliente'),
    ('029', 'No realizada por causas imputables al distribuidor'),
    ('030', 'Excedido el número máximo de visitas'),
    ('031', 'Excedido tiempo máximo de concertación'),
    ('032', 'Innecesario'),
    ('033', 'No consta Inspección Periódica para el CUPS indicado'),
    ('034', 'No se dispone del documento solicitado'),
    ('035', 'IP ya realizada'),
    ('036', 'Se envía Mail a Empresa de Inspección para su Reprogramación'),
    ('037', 'Se dispone de una Lectura Posterior'),
    ('038', 'No se dispone de la información solicitada'),
    ('039', 'Debe informar una Fecha/Hora de Reprogramación'),
    ('040', 'Consulte página Web de Distribución'),
    ('041', 'La Reclamación recibida no es responsabilidad de '
            'la Distribuidora'),
    ('042', 'Se ha gestionado la Reclamación pero no se ha detectado ningún '
            'comportamiento erróneo'),
    ('043', 'Rechazo aplicado correctamente'),
    ('044', 'No existe Solicitud para el CUPS y proceso indicados'),
    ('045', 'Se ha aclarado el Rechazo y el cliente queda de acuerdo'),
    ('046', 'Fecha efecto aplicada correctamente'),
    ('047', 'Lectura aplicada correctamente'),
    ('048', 'El peaje aplicado coincide con el solicitado'),
    ('049', 'El Qd aplicado coincide con el solicitado'),
    ('050', 'El Qh aplicado coincide con el solicitado'),
    ('051', 'El proceso ha sido anulado'),
    ('052', 'El mensaje ha sido enviado con anterioridad'),
    ('053', 'No se ha enviado acepto'),
    ('054', 'Activación en Curso con Fecha Efecto Futura'),
    ('055', 'No procede para el Peaje asociado al CUPS'),
    ('056', 'La Visita aún no ha sido concertada'),
    ('057', 'La Concertación inicial ha sido anulada'),
    ('058', 'La Visita se ha Realizado'),
    ('059', 'No se ha realizado la Baja del Contrato'),
    ('060', 'No procede cartel en la Finca'),
    ('061', 'No aplica Tarjeta de Ausencia'),
    ('062', 'Deshabitado'),
    ('063', 'Concertación fallida.'),
    ('064', 'No quiere gas'),
    ('065', 'Quiere gas más adelante.'),
]
TAULA_TIPO_INTERVENCION = [
    ('01', 'Retipificación'),
    ('02', 'Solicitud de Más Información'),
    ('03', 'Operación.'),
    ('04', 'Avance de información por parte de la Distribuidora.'),
    ('05', 'Solicitud de información necesaria para retipificar'),
]
TAULA_TIPOS_DE_SOLICITANTE_RECLAMANTE = [
    ('01', 'Cliente – Usuario final - Titular'),
    ('02', 'Representante legal'),
    ('03', 'Aseguradora'),
    ('04', 'Administraciones/ Organismos Públicos'),
    ('06', 'Comercializador'),
    ('07', 'Juzgados'),
    ('08', 'Afectado no titular ni usuario del punto de suministro'),
    ('09', 'Asociaciones de Consumidores'),
]
TAULA_TIPO_SOLICITANTE = TAULA_TIPOS_DE_SOLICITANTE_RECLAMANTE

TAULA_TIPOS_DE_DOCUMENTO = [
    ('CC', 'Carta de Conformidad'),
    ('01', 'Acta de puesta en marcha'),
    ('02', 'Acta de inspección'),
    ('03', 'Reclamación'),
    ('04', 'Respuesta a Reclamación'),
    ('05', 'Facturas'),
    ('06', 'Otra documentación del cliente'),
    ('99', 'Otros'),
]
TAULA_TIPOS_DOCUMENTOS_ANEXOS = TAULA_TIPOS_DE_DOCUMENTO

TAULA_ORIGEN_INSPECCION = [
    ('0', 'Distribuidor'),
    ('1', 'Comercializador'),
    ('2', 'Otros Instaladores'),
]
TAULA_TIPO_OPERACION = [
    ('A10001', 'Reapertura IRI con certificado. ', 'AMBOS', 'I'),
    ('A10002', 'Reapertura IRI por pago deuda.', 'AMBOS', 'I'),
    ('A10003', 'Puesta en seguridad IRI (levantamiento de contador por obras).', 'AMBOS', 'I'),
    ('A10004', 'Cambio de contador', 'DIS', 'I'),
    ('A10005', 'Comprobar estado contador (comprobar si marca)', 'AMBOS', 'I'),
    ('A10006', 'Reapertura de IRC (sin certificado)', 'DIS', 'I'),
    ('A10007', 'Cierre para Finca', 'DIS', 'I'),
    ('A10008', 'Reapertura por reforma IRC (con certificado)', 'DIS', 'I'),
    ('A10009', 'Inspección periódica', 'DIS', 'I'),
    ('A10010', 'Cierre de suministro inspecciones', 'DIS', 'I'),
    ('A10011', 'Cierre por falta de pago', 'AMBOS', 'I'),
    ('A10012', 'Verificar finca', 'DIS', 'I'),
    ('A10013', 'Abrir finca para urgencias', 'DIS', 'I'),
    ('A10014', 'Verificación acumulación de consumo', 'DIS', 'I'),
    ('A10015', 'Reapertura IRI por Cierre Total consumo', 'DIS', 'I'),
    ('A10016', 'Reapertura IRC por Cierre Total consumo', 'DIS', 'I'),
    ('A10017', 'Op. Urgencias. Apertura piso', 'DIS', 'I'),
    ('A10018', 'Op. Urgencias. Comprobar y abrir', 'DIS', 'I'),
    ('A10019', 'Op. Urgencias. Comprobar instalación', 'DIS', 'I'),
    ('A10020', 'Op. Urgencias. Exceso presión', 'DIS', 'I'),
    ('A10021', 'Op. Urgencias. Fuga interior en domiciliaria', 'DIS', 'I'),
    ('A10022', 'Op. Urgencias. Fuga interior en zona comunitaria', 'DIS', 'I'),
    ('A10023', 'Op. Urgencias. Reapertura por deuda', 'DIS', 'I'),
    ('A10024', 'Op. Urgencias. Incendio explosión', 'DIS', 'I'),
    ('A10025', 'Op. Urgencias. Intoxicación', 'DIS', 'I'),
    ('A10026', 'Op. Urgencias. Otros', 'DIS', 'I'),
    ('A10027', 'Op. Urgencias. Revisión Sistemat. Cambio Contador', 'DIS', 'I'),
    ('A10028', 'Op. Urgencias. Sin gas', 'DIS', 'I'),
    ('A10029', 'Op. Urgencias. Visita sin actuación', 'DIS', 'I'),
    ('A10030', 'Reapertura IRI sin certificado. ', 'AMBOS', 'I'),
    ('A20001', 'Lectura facilitada', 'AMBOS', 'A'),
    ('A20002', 'Comunicación Reapertura por instalador', 'DIS', 'A'),
    ('A20003', 'Modificación en Estimación', 'DIS', 'A'),
    ('A20004', 'Baja de Telemedida', 'AMBOS', 'A'),
    ('A20006', 'Aviso posible fraude', 'DIS', 'A'),
]
TAULA_TIPO_ACTUACION = TAULA_TIPO_OPERACION
TAULA_TIPO_OPERACION_COMER = [(x[0], x[1]) for x in TAULA_TIPO_OPERACION if x[2] == 'AMBOS']
TAULA_TIPO_OPERACION_TODOS = [(x[0], x[1]) for x in TAULA_TIPO_OPERACION]

TAULA_SITUACION_SUMINISTRO = [
    ('00', 'PENDIENTE COMUNICACION DE OBRA CORRIENTE'),
    ('01', 'PENDIENTE DE PRIMERA FACTURACION'),
    ('02', 'EN SERVICIO'),
    ('03', 'EN SERVICIO/FRAUDE'),
    ('04', 'CONTADOR LEVANTADO POR OBRA'),
    ('05', 'CORTE POR FALTA DE PAGO'),
    ('06', 'CIERRE TEMPORAL A PETICION CLIENTE'),
    ('07', 'CIERRE TEMPORAL POR FUERZA MAYOR'),
    ('08', 'CESADO'),
    ('09', 'CERRADO POR CENSO'),
    ('10', 'CERRADO POR TRANSFORMACION'),
    ('11', 'CERRADO POR INSPECCION SISTEMATICA IRI'),
    ('12', 'CERRADO POR DEFECTO RECEPTORA COMUN'),
    ('13', 'CERRADO POR CCAU'),
    ('18', 'CESADO PENDIENTE DE FACTURACION'),
    ('20', 'CERRADO Y PRECINTADO'),
    ('30', 'CERRADO POR FRAUDE Y LEVANTADO'),
    ('50', 'EN SERVICIO POR CLIENTE'),
    ('99', 'POLIZA FICTICIA'),
]
TAULA_SITUACION_SERVICIO = [
    ('00', 'EN SERVICIO'),
    ('01', 'C.PARCIAL IRI POR INSPECCIONES'),
    ('02', 'C.PARCIAL IRI PREV. POR URG.'),
    ('03', 'C.PARCIAL IRI POR URGENCIAS'),
    ('04', 'IRI EN A.U.P POR INSPECCIONES'),
    ('05', 'IRI EN A.U.P PREV. POR URG.'),
    ('06', 'IRI EN A.U.P POR URGENCIAS'),
    ('07', 'C.TOTAL IRI POR INSPECCIONES'),
    ('08', 'C.TOTAL IRI PREV. POR URG.'),
    ('09', 'C.TOTAL IRI POR URGENCIAS'),
    ('10', 'C.TOTAL IRC POR INSPECCIONES'),
    ('11', 'C.TOTAL IRI POR CIERRE IRC IP'),
    ('20', 'C.TOTAL IRC PREV. POR URG.'),
    ('21', 'C.TOTAL IRI POR C.IRC PREV.URG'),
    ('30', 'C.TOTAL IRC POR URGENCIAS'),
    ('31', 'C.TOTAL IRI POR CIERRE IRC URG.'),
    ('40', 'IRC EN A.U.P POR INSP.PERIODICA'),
    ('50', 'IRC EN A.U.P POR URGENCIAS'),
    ('60', 'C.PARCIAL IRC POR INSPECCIONES'),
    ('70', 'C.PARCIAL IRC PREV. POR URG.'),
    ('80', 'C.PARCIAL IRC POR URGENCIAS'),
    ('95', 'ERROR - PSUM-IRC RECIEN CREADO'),
    ('96', 'ERROR EN SIT. SERVICIO (VERIFICAR P.SUM)'),
    ('97', 'PENDIENTE DE CALCULAR EN P.SUM. NUEVO'),
    ('98', 'PUNTO SUM. CON SIT.SERV. NO CONTEMPLADA'),
    ('99', 'SIN SERVICIO'),
]
TAULA_TIPO_DE_RECLAMACION = [
    ('01', 'ATENCIÓN PERSONAL'),
    ('02', 'FACTURACIÓN Y MEDIDA'),
    ('03', 'CONTRATACIÓN'),
    ('04', 'GESTIÓN DE ACOMETIDAS'),
    ('05', 'CALIDAD DE SUMINISTRO'),
    ('06', 'SITUACIÓN DE INSTALACIONES'),
    ('07', 'ATENCION REGLAMENTARIA'),
    ('08', 'OTROS DAÑOS GAS'),
    ('09', 'INSPECCIÓN PERIODICA GAS'),
]
TAULA_SUBTIPO_DE_RECLAMACION = [
    ('RECLAMACIONES', 'ATENCIÓN PERSONAL', 'ATENCION INCORRECTA', 'Quejas sobre la atención del personal propio o contratistas de la distribuidora/ Incumpliendo cita', '001'),
    ('RECLAMACIONES', 'ATENCIÓN PERSONAL', 'PRIVACIDAD DE LOS DATOS', 'reclamaciones del cliente relativas a los derechos establecidos en la Ley Orgánica de Protección de Datos', '002'),
    ('RECLAMACIONES', 'FACTURACIÓN Y MEDIDA', 'INCIDENCIA EN EQUIPOS DE MEDIDA', 'Reclamaciones derivadas de cualquier tipo de incidencia detectada en el Equipo de Medida.', '003'),
    ('RECLAMACIONES', 'FACTURACIÓN Y MEDIDA', 'DAÑOS ORIGINADOS POR EQUIPO DE MEDIDA', 'Reclamaciones con petición de indemnización por daños derivados de cualquier tipo de incidencia originada por el Equipo de Medida.', '004'),
    ('RECLAMACIONES', 'FACTURACIÓN Y MEDIDA', 'CONTADOR EN FACTURA NO CORRESPONDE CON INSTALADO', 'Reclamaciones originadas por posibles contadores mal asignados.', '005'),
    ('RECLAMACIONES', 'FACTURACIÓN Y MEDIDA', 'CONTRATOS ATR/ PEAJE QUE NO SE FACTURAN', 'Reclamaciones sobre suministros con contrato en vigor, en los que se detecta que el proceso de facturación está suspendido por alguna causa imputable a distribuidora.', '006'),
    ('RECLAMACIONES', 'FACTURACIÓN Y MEDIDA', 'CUPS NO PERTENECE A COMERCIALIZADORA O NO VIGENTE EN PERIODO DE FACTURA', 'El CUPS no pertenece o contrato no vigente en la comercializadora en el periodo de la factura (Solo afecta a reclamaciones con origen comercializador)', '007'),
    ('RECLAMACIONES', 'FACTURACIÓN Y MEDIDA', 'DISCONFORMIDAD CON CONCEPTOS FACTURADOS', 'Reclamaciones sobre conceptos repercutidos por la distribuidora (alquiler, derechos, etc.).', '008'),
    ('RECLAMACIONES', 'FACTURACIÓN Y MEDIDA', 'DISCONFORMIDAD CON LECTURA FACTURADA', 'Reclamaciones disconformidad con la lectura facturada. Se aplica también en caso de estimaciones acumuladas o consumos cero que requieren una lectura real, y toda aquella facturación cuyo periodo es superior a un año.', '009'),
    ('RECLAMACIONES', 'FACTURACIÓN Y MEDIDA', 'DISCONFORMIDAD EN FACTURA ANOMALÍA / FRAUDE', 'Reclamaciones por disconformidad en facturaciones complementarias de anomalía / fraude.', '010'),
    ('RECLAMACIONES', 'FACTURACIÓN Y MEDIDA', 'RECLAMACIÓN FACTURA ', 'Reclamación por duplicado de la misma factura o de dos facturas distintas que corresponden al mismo concepto. ', '011'),
    ('RECLAMACIONES', 'FACTURACIÓN Y MEDIDA', 'REFACTURACION NO RECIBIDA', 'Reclamación por no recepción de una rectificación de factura o abono. ', '012'),
    ('RECLAMACIONES', 'CONTRATACIÓN', 'DISCONFORMIDAD CON CAMBIO DE SUMINISTRADOR', 'Reclamaciones por disconformidad con el cambio de comercializador activado.', '013'),
    ('RECLAMACIONES', 'CONTRATACIÓN', 'REQUERIMIENTO DE FIANZA / DEPÓSITO DE GARANTÍA', 'Reclamaciones de clientes relativas al reintegro del importe pagado en su día como fianza al realizar una baja o una baja-alta, por no constar ya como titular del punto de suministro.', '014'),
    ('RECLAMACIONES', 'CONTRATACIÓN', 'RETRASO CORTE DE SUMINISTRO', 'Reclamación por retraso en la ejecución del corte solicitado por la comercializadora.', '015'),
    ('RECLAMACIONES', 'GESTIÓN DE ACOMETIDAS', 'DISCONFORMIDAD CON CRITERIOS ECONÓMICOS / COBROS', 'Disconformidad con el presupuesto o facturación de una solicitud de nuevos suministros.', '018'),
    ('RECLAMACIONES', 'GESTIÓN DE ACOMETIDAS', 'DISCONFORMIDAD CON CRITERIOS TÉCNICOS / OBRA EJECUTADA', 'Disconformidad con los criterios y con la solución técnica indicados en el presupuesto y / o desperfectos y discrepancias en la realización de la acometida/CUI', '019'),
    ('RECLAMACIONES', 'CALIDAD DE SUMINISTRO', 'CON PETICIÓN DE INDEMNIZACIÓN', 'Reclamación por daños producidos por averías técnicas y cortes programados en las redes de distribución.', '021'),
    ('RECLAMACIONES', 'CALIDAD DE SUMINISTRO', 'SIN PETICIÓN DE INDEMNIZACIÓN', 'Reclamación por molestias causadas por averías técnicas y cortes programados en las redes de distribución.', '022'),
    ('RECLAMACIONES', 'CALIDAD DE SUMINISTRO', 'RETRASO EN PAGO INDEMNIZACION', 'Reclamación por el retraso en el pago de indemnización ', '023'),
    ('RECLAMACIONES', 'SITUACIÓN DE INSTALACIONES', 'DAÑOS A TERCEROS POR INSTALACIONES ', 'Reclamaciones por daños ocasionados a bienes materiales o personas derivados de la realización de obras o por la rotura o la caída de elementos de las instalaciones.', '024'),
    ('RECLAMACIONES', 'SITUACIÓN DE INSTALACIONES', 'IMPACTO AMBIENTAL INSTALACIONES', 'Reclamaciones por situaciones que conlleven un posible incumplimiento de la política, gestión, o actuaciones ambientales:', '025'),
    ('RECLAMACIONES', 'SITUACIÓN DE INSTALACIONES', 'RECLAMACIONES SOBRE INSTALACIONES', 'Reclamación que conlleve una intervención en la red de distribución ( por mal estado de la red, riesgo en las instalaciones...) pero que no suponga un peligro inminente para personas o bienes. Estos casos son avisos de incidencias y deben tratarse urgentemente a través del teléfono de averías del distribuidor.', '026'),
    ('RECLAMACIONES', 'ATENCIÓN REGLAMENTARIA', 'DISCONFORMIDAD DESCUENTO SERVICIO INDIVIDUAL ', 'Disconformidad sobre el importe abonado por calidad de suministro o por la falta de abono.', '027'),
    ('RECLAMACIONES', 'ATENCIÓN REGLAMENTARIA', 'EJECUCIÓN INDEBIDA DE CORTE', 'Reclamación por corte incorrecto.', '028'),
    ('RECLAMACIONES', 'ATENCIÓN REGLAMENTARIA', 'RETRASO EN LA ATENCIÓN A RECLAMACIONES ', 'Reclamación por incumplimiento de los plazos legales establecidos reglamentariamente (se indica código de reclamación previa).', '029'),
    ('RECLAMACIONES', 'ATENCIÓN REGLAMENTARIA', 'RETRASO PLAZO DE CONTESTACIÓN NUEVOS SUMINISTROS', 'Reclamación por retraso en la contestación / presentación de presupuesto de una solicitud de nuevo suministro.', '030'),
    ('RECLAMACIONES', 'ATENCIÓN REGLAMENTARIA', 'RETRASO PLAZO DE EJECUCIÓN NUEVO SUMINISTRO', 'Reclamación por retraso en la ejecución de una solicitud de nuevos suministros que el cliente ya ha pagado', '031'),
    ('RECLAMACIONES', 'ATENCIÓN REGLAMENTARIA', 'RETRASO REENGANCHE TRAS CORTE', 'Reclamación por retraso en la ejecución del reenganche solicitado por la comercializadora.', '032'),
    ('RECLAMACIONES', 'OTROS DAÑOS GAS', 'POR URGENCIAS', 'Daños producidos por urgencias (gas)', '033'),
    ('RECLAMACIONES', 'CONTRATACIÓN', 'DISCONFORMIDAD CON CONCEPTOS DE CONTRATACIÓN ATR-PEAJE', 'Reclamaciones por disconformidad con los datos de tarifa/peaje, potencia/caudal, titular PS, dirección PS o fecha de activación (no utilizable para incidencias masivas en formatos de intercambio).', '034'),
    ('RECLAMACIONES', 'CONTRATACIÓN', 'DISCONFORMIDAD RECHAZO SOLICITUD ATR-PEAJE', 'Reclamaciones por disconformidad con el motivo de alegado por la distribuidora para rechazar la solicitud de ATR/Peaje (no utilizable para incidencias masivas en formatos de intercambio).', '035'),
    ('PETICIONES', 'FACTURACIÓN Y MEDIDA', 'PETICIÓN DE REFACTURACIÓN APORTANDO LECTURA', 'Solicitud refacturación por disconformidad con la lectura utilizada en la facturación (aportando lectura). Se incluyen los extornos', '036'),
    ('RECLAMACIONES', 'FACTURACIÓN Y MEDIDA', 'FICHERO XML INCORRECTO', 'Fichero erróneo', '037'),
    ('PETICIONES', 'ATENCIÓN PERSONAL', 'PRIVACIDAD DE LOS DATOS', 'Solicitud de cancelación, rectificación y oposición de los datos de carácter personal.', '038'),
    ('PETICIONES', 'FACTURACIÓN Y MEDIDA', 'SOLICITUD DE DUPLICADO DE FACTURA', 'Petición de duplicados de factura de un periodo.', '040'),
    ('PETICIONES', 'CONTRATACIÓN', 'ACTUALIZACION DIRECCIÓN PUNTO DE SUMINISTRO', 'Requerimientos del Cliente para modificaciones en la dirección del punto de suministro.', '045'),
    ('PETICIONES', 'FACTURACIÓN Y MEDIDA', 'CERTIFICADO DE LECTURA', 'Solicitud del cliente del certificado de lectura', '046'),
    ('PETICIONES', 'CONTRATACIÓN', 'PETICIÓN INFORMACIÓN ADICIONAL RECHAZO ', 'Petición de información adicional sobre un rechazo en una solicitud o tras actuaciones en campo de ATR/ Peaje ', '048'),
    ('RECLAMACIONES', 'FACTURACIÓN Y MEDIDA', 'FALTA FICHERO MEDIDA', 'Falta formato A7 telemedida de gas/ formato Q1 para consumidores con peaje directo (solo para reclamaciones con origen comercializadora) o falta fichero F5D o RF5D', '049'),
    ('RECLAMACIONES', 'INSPECCIÓN PERIÓDICA GAS', 'DESACUERDO FACTURACIÓN', 'Desacuerdo con el concepto facturado por ', '050'),
    ('RECLAMACIONES', 'INSPECCIÓN PERIÓDICA GAS', 'CONDUCTA INADECUADA', 'Cliente muestra disconformidad por la conducta del inspector en la visita de la inspección periódica. Falta de respeto, falta acreditación , presuntos delitos ', '051'),
    ('RECLAMACIONES', 'INSPECCIÓN PERIÓDICA GAS', 'DISCONFORMIDAD TRABAJOS REALIZADOS', 'Desacuerdo con la ejecución de la inspección periódica y/o el resultado de la misma.', '052'),
    ('RECLAMACIONES', 'INSPECCIÓN PERIÓDICA GAS', 'INCUMPLIMIENTO HORA', 'Incumplimiento , demora o vista no atendida de Inspección periódica', '053'),
    ('RECLAMACIONES', 'INSPECCIÓN PERIÓDICA GAS', 'DAÑOS INSPECCIÓN', 'Reclamaciones por daños causados en la inspección', '054'),
    ('RECLAMACIONES', 'FACTURACIÓN Y MEDIDA', 'DISCONFORMIDAD CON EXPEDIENTE DE ANOMALIA Y FRAUDE (sin factura emitida)', 'Disconformidad con el expediente de anomalía y fraude pero sin factura emitida.', '057'),
    ('RECLAMACIONES', 'CONTRATACIÓN', 'RETRASO EN PLAZO ACEPTACIÓN CAMBIO DE COMERCIALIZADOR', 'Reclamación por incumplimiento de plazos de aceptación establecidos legalmente para el cambio de comercializador (se indicará el código de solicitud que se reclama). ', '058'),
    ('RECLAMACIONES', 'CONTRATACIÓN', 'RETRASO EN PLAZO ACTIVACIÓN CAMBIO DE COMERCIALIZADOR ', 'Reclamación por incumplimiento de plazos de activación establecidos legalmente para el cambio de comercializador (se indicará el código de solicitud que se reclama). ', '059'),
    ('RECLAMACIONES', 'CONTRATACIÓN', 'RETRASO EN PLAZO ACEPTACIÓN MODIFICACIÓN CONTRACTUAL', 'Reclamación por incumplimiento de plazos de aceptación establecidos legalmente para las modificaciones contractuales excepto el cambio de comercializador ', '060'),
    ('RECLAMACIONES', 'CONTRATACIÓN', 'RETRASO EN PLAZO ACTIVACIÓN MODIFICACIÓN CONTRACTUAL', 'Reclamación por incumplimiento de plazos de activación establecidos legalmente para las modificaciones contractuales excepto el cambio de comercializador (se indicará el código de solicitud que se reclama). ', '061'),
    ('RECLAMACIONES', 'CONTRATACIÓN', 'RETRASO EN PLAZO ACEPTACIÓN ALTA DE UN SUMINISTRO', 'Reclamación por incumplimiento de plazos de aceptación establecidos legalmente para la alta de un nuevo suministro ', '062'),
    ('RECLAMACIONES', 'CONTRATACIÓN', 'RETRASO EN PLAZO ACTIVACIÓN ALTA DE UN SUMINISTRO', 'Reclamación por incumplimiento de plazos de activación establecidos legalmente para la alta de un nuevo suministro ', '063'),
    ('RECLAMACIONES', 'CONTRATACIÓN', 'RETRASO EN PLAZO ACEPTACIÓN BAJA DE UN SUMINISTRO', 'Reclamación por incumplimiento de plazos de aceptación establecidos legalmente para la baja de un suministro (se indicará el código de solicitud que se reclama). ', '064'),
    ('RECLAMACIONES', 'CONTRATACIÓN', 'RETRASO EN PLAZO ACTIVACIÓN BAJA DE UN SUMINISTRO', 'Reclamación por incumplimiento de plazos de activación establecidos legalmente para la baja de un suministro (se indicará el código de solicitud que se reclama). ', '065'),
    ('PETICIONES', 'CONTRATACIÓN', 'INFORMACIÓN/VALIDACIÓN SOBRE FATOS DEL CONTRATAO ATR/PEAJE', 'Petición de solicitud, aclaración o verificación de información necesaria para poder diagnosticar posibles incidencias en contratos de clientes o ATR/Peaje, cuando se detectan errores en datos de los portales, indisponibilidad de los mismos o cuando los datos consultables a través del portal no son suficientes para realizar un correcto diagnóstico', '066'),
    ('PETICIONES', 'FACTURACIÓN Y MEDIDA', 'VERIFICACIÓN DE CONTADOR', 'Peticiones para solicitar la verificación de un contador o peticion de toma de lectura. Para cotejar que el número de contador es el correcto (el que corresponde en factura).', '067'),
    ('RECLAMACIONES', 'FACTURACIÓN Y MEDIDA', 'RECLAMACIÓN POR APLICACIÓN DEL FACTOR DE CONVERSIÓN O EL PCS', '068'),
]
TAULA_TIPOS_DE_ATENCION_INCORRECTA = [
    ('01', 'Por personal de canales de atención'),
    ('02', 'Por operarios de equipos de medida'),
    ('03', 'Por operarios de nuevos suministros'),
    ('04', 'Por operarios de inspección'),
    ('05', 'Por operaciones'),
    ('06', 'Por operarios de lecturas'),
    ('07', 'Por averías/ urgencias'),
]
TAULA_CONCEPTOS_FACTURADOS = [
    ('02', 'Cálculo penalización telemedida aplicado'),
    ('03', 'Cálculo Qd media / Qd aplicada'),
    ('04', 'General sobre el factor de conversión'),
    ('05', 'Alquiler equipos de medida'),
    ('06', 'Derechos de alta y acometida (acceso enganche y extensión)'),
    ('07', 'Importe de operación facturada'),
    ('08', 'Término fijo'),
    ('09', 'Canon de la IRC'),
    ('10', 'Impuestos'),
    ('11', 'Qf '),
    ('12', 'Verificación equipos de medida'),
    ('13', 'Derechos de corte y reconexión'),
    ('14', 'Refacturaciones regulatorias'),
    ('16', 'Componentes regulados'),
    ('17', 'Abono por calidad individual'),
    ('18', 'Canon individual'),
    ('19', 'Tipo de peaje'),
]
TAULA_CONCEPTOS_DE_CONTRATACION = [
    ('01', 'Fecha de efecto'),
    ('02', 'Peaje (grupo de peaje)'),
    ('03', 'Qd'),
    ('04', 'Qh'),
    ('05', 'Lectura de Traspaso'),
    ('06', 'Titular'),
    ('07', 'Propiedad equipo de medida'),
    ('08', 'Presión'),
    ('09', 'Periodicidad en la facturación'),
    ('10', 'Dirección Punto Suministro'),
]
TAULA_DETALLE_DE_RESOLUCION = [
    ('0010101', 'Se piden disculpas'),
    ('0010201', 'Desacuerdo con la reclamación. '
                'Se adjunta explicación en comentarios'),
    ('0020101', 'Se modifica estado Cliente Robinson/ Cliente'),
    ('0020102', 'Se indemniza al cliente'),
    ('0020201', 'No consta solicitud previa'),
    ('0020202', 'Ajeno a la distribuidora'),
    ('0020203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0030101', 'Equipo incorrecto. Incluye equipo desaparecido.'),
    ('0030102', 'Instalación incorrecta. Incluye relación de transformación'),
    ('0030103', 'Lectura errónea'),
    ('0030201', 'Equipo correcto'),
    ('0030202', 'Instalación correcta'),
    ('0030203', 'Histórico de consumos / lecturas coherente.'),
    ('0030204', 'Detectada anomalía en visita'),
    ('0030205', 'Expediente por anomalía en curso.'),
    ('0030206', 'Elemento externo responsabilidad de cliente'),
    ('0030207', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0030301', 'No se localiza al cliente'),
    ('0030302', 'No corresponde a distribuidora. '),
    ('0030303', 'Cliente no aporta información adicional.'),
    ('0030304', 'Acceso denegado'),
    ('0030305', 'Visita anulada por cliente'),
    ('0040101', 'Favorable'),
    ('0040201', 'Desfavorable con explicación de motivos en texto resultado '),
    ('0040202', 'Sin incidencia'),
    ('0040203', 'Incidencia que no justifica daños'),
    ('0040204', 'Trabajos programados que no justifican daños'),
    ('0040205', 'Avería instalación particular cliente'),
    ('0040206', 'Originada por terceros '),
    ('0040207', 'Tiempo de interrupción no justifica pérdida de perecederos'),
    ('0040208', 'Se reitera la respuesta anterior'),
    ('0040209', 'Detectada anomalía en visita'),
    ('0040210', 'Expediente por anomalía en curso'),
    ('0040301', 'Imposible por documentación pendiente por parte del cliente'),
    ('0040302', 'Imposible llegar a un acuerdo'),
    ('0040303', 'Acceso Impedido'),
    ('0040304', 'Cliente ausente'),
    ('0050101', 'Asignamos correctamente y refacturamos'),
    ('0050102', 'informamos correctamente el nº contador '
                '(no hay que refacturar)'),
    ('0050103', 'Inversión de contadores'),
    ('0050104', 'Corte realizado por distribuidora'),
    ('0050201', 'El contador es correcto'),
    ('0050202', 'Expediente por anomalía en curso'),
    ('0050203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0050301', 'No se localiza al cliente'),
    ('0050302', 'Acceso denegado'),
    ('0050303', 'Visita anulada por cliente'),
    ('0060101', 'Error del Sistema '),
    ('0060102', 'Incidencia: datos Concentrador Secundario /Telemedida '),
    ('0060103', 'Modificaciones contractuales pendientes (fuera de plazo) '),
    ('0060104', 'Contador interior '),
    ('0060105', 'Pendiente trabajo domicilio cliente '
                '(Facturado. Tarea de cliente realizada) '),
    ('0060201', 'No tomada medida real'),
    ('0060202', 'Modificaciones contractuales pendientes (dentro de plazo)'),
    ('0060203', 'Período legal de facturación'),
    ('0060204', 'Contrato Facturado '),
    ('0060205', 'Pendiente trabajo domicilio cliente '
                '(sigue pendiente tarea del cliente) '),
    ('0060206', 'Contrato en baja '),
    ('0060207', 'Contrato con otra comercializadora'),
    ('0060208', 'Cortado por inspección no realizada/ impago'),
    ('0060209', 'CUPS no vigente en periodo de factura'),
    ('0060210', 'Expediente por anomalía/fraude en curso'),
    ('0060211', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0070101', 'Se anula factura'),
    ('0070201', 'Facturación correcta. (incluir explicación en campo '
                'comentarios)'),
    ('0070202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0080101', 'Se refactura el concepto reclamado'),
    ('0080102', 'Se refacturan otros conceptos / varios conceptos'),
    ('0080201', 'Conceptos reclamados correctamente facturados '
                '(incluir explicación en campo comentarios)'),
    ('0080202', 'ICP no instalado'),
    ('0080203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0090101', 'Equipo de Medida con acceso y consumo acumulado más de un '
                'año se refactura '),
    ('0090102', 'Se anula estimación '),
    ('0090103', 'Error Lectura Montaje/Desmontaje '),
    ('0090104', 'Error lectura lector '),
    ('0090105', 'Perfil estimado curva de carga en gráfico factura '),
    ('0090106', 'Error en Telemedida / Telegestión'),
    ('0090107', 'No conforme aplicación reactiva'),
    ('0090108', 'Error cargo/abono realizado'),
    ('0090109', 'Se refactura lectura reclamada'),
    ('0090201', 'Equipo de Medida sin acceso más de un año, facturación '
                'correcta'),
    ('0090202', 'Consumo correcto '),
    ('0090203', 'Estimación correcta '),
    ('0090204', 'Lectura aportada errónea '),
    ('0090205', 'Consumo acumulado '),
    ('0090206', 'Contador interior '),
    ('0090207', 'Lectura real correcta '),
    ('0090208', 'Perfil estimado curva de carga en gráfico factura '),
    ('0090209', 'Aplicación reactiva correcta'),
    ('0090210', 'Cargo/Abono realizado correcto'),
    ('0090211', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0090301', 'Visita fallida '),
    ('0100101', 'Se refactura'),
    ('0100102', 'Se anula la factura'),
    ('0100201', 'Factura correcta según normativa'),
    ('0100202', 'Expediente en curso '),
    ('0100203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0110101', 'Se abona el duplicado'),
    ('0110102', 'Se refactura'),
    ('0110103', 'Se anula la factura'),
    ('0110201', 'Factura correcta'),
    ('0110202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0120101', 'Se refactura'),
    ('0120201', 'Factura ya estaba rectificada'),
    ('0120202', 'No procede la refacturación'),
    ('0120203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0130101', 'Corregido cambio de suministrador realizado'),
    ('0130201', 'Cambio de suministrador realizado correctamente'),
    ('0130202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0130203', 'No existe solicitud'),
    ('0140101', 'Se devuelve fianza'),
    ('0140102', 'Se corrige devolución errónea y se reenvía fianza'),
    ('0140201', 'La devolución se efectuó correctamente'),
    ('0140202', 'No procede devolver'),
    ('0140203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0150101', 'Corte ejecutado'),
    ('0150201', 'Corte ejecutado en plazo'),
    ('0150202', 'Corte ejecutado con retraso imputable a cliente'),
    ('0150203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0150204', 'No existe solicitud'),
    ('0150301', 'Imputable a cliente'),
    ('0150302', 'Requerimiento de la administración judicial / legal '
                '(incluye esencialidad)'),
    ('0180101', 'Se corrigen criterios económicos en presupuesto'),
    ('0180102', 'Se corrige factura emitida (datos de facturación, importe)'),
    ('0180201', 'Factura correcta'),
    ('0180202', 'Criterios económicos correctos'),
    ('0180203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0190101', 'Se modifican criterios técnicos '),
    ('0190102', 'Se reparan desperfectos/se indemnizan daños'),
    ('0190103', 'Licencia de obra/permisos particulares '
                'de obra no solicitados'),
    ('0190104', 'Ejecución incorrecta de obras'),
    ('0190105', 'Asesoramiento técnico erróneo en contestación'),
    ('0190201', 'Criterios técnicos/ejecución obra correctos'),
    ('0190202', 'Petición de suministro no finalizada'),
    ('0190203', 'Plazo correcto'),
    ('0190204', 'Pendiente de documentación del cliente'),
    ('0190205', 'Improcedente. Se adjunta explicación de comentarios'),
    ('0190301', 'Impedido acceso a la instalación por cliente'),
    ('0210101', 'Favorable'),
    ('0210201', 'Desfavorable con explicación de motivos en texto resultado '),
    ('0210202', 'Sin incidencia'),
    ('0210203', 'Incidencia que no justifica daños'),
    ('0210204', 'Trabajos programados que no justifican daños'),
    ('0210205', 'Avería instalación particular cliente'),
    ('0210206', 'Originada por terceros '),
    ('0210207', 'Tiempo de interrupción no justifica pérdida de perecederos'),
    ('0210208', 'Se actúa de acuerdo a la normativa de calidad individual y '
                'zonal vigente'),
    ('0210209', 'Se reitera la respuesta anterior'),
    ('0210210', 'Expediente anomalía/fraude en curso'),
    ('0210301', 'Imposible por documentación pendiente por parte del cliente'),
    ('0210302', 'Imposible llegar a un acuerdo'),
    ('0210303', 'Imposible por falta de acceso al cliente'),
    ('0220101', 'Se corrige situación'),
    ('0220201', 'Desfavorable con explicación de motivos en texto resultado '),
    ('0220202', 'Sin incidencia'),
    ('0220203', 'Trabajos programados'),
    ('0220204', 'Avería instalación particular cliente'),
    ('0220205', 'Originada por terceros '),
    ('0220206', 'Se reitera la respuesta anterior'),
    ('0220207', 'No legitimada. Relación extracontractual.'),
    ('0220208', 'Expediente por anomalía/fraude en curso'),
    ('0220209', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0220301', 'Imposible gestionar por falta de acceso al cliente'),
    ('0230101', 'Favorable'),
    ('0230201', 'Desfavorable con explicación de motivos en texto resultado '),
    ('0230202', 'No legitimada. Relación extracontractual.'),
    ('0230301', 'Imposible localizar al cliente'),
    ('0240101', 'Favorable. Se corrige o resarcen daños.'),
    ('0240201', 'Desfavorable con explicación de motivos en texto resultado '),
    ('0240202', 'No legitimada. Relación extracontractual.'),
    ('0240203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0250101', 'Se corrige la situación'),
    ('0250201', 'Instalación correcta'),
    ('0250202', 'No legitimada. Relación extracontractual'),
    ('0250203', 'Instalación ajena a la distribuidora'),
    ('0250204', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0250301', 'Imposible gestionar por faltar datos'),
    ('0260101', 'Corregimos situación'),
    ('0260201', 'Instalación correcta'),
    ('0260202', 'No legitimada. Relación extracontractual'),
    ('0260203', 'Instalación ajena a la distribuidora'),
    ('0260204', 'Expediente por anomalía/fraude en curso'),
    ('0260205', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0270101', 'Se corrige importe y se traslada al comercializador'),
    ('0270201', 'Cálculo y pago '),
    ('0270202', 'Cálculo correcto. No procede el abono'),
    ('0270203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0280101', 'Se reestablece el suministro'),
    ('0280102', 'Se reestablece el suministro con indemnización'),
    ('0280201', 'Corte correcto por solicitud del comercializador'),
    ('0280202', 'Corte correcto por cualquier motivo reconocido en la '
                'normativa vigente'),
    ('0280203', 'No existe corte realizado'),
    ('0280204', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0290101', 'Se indemniza incumplimiento de calidad de atención en '
                'próxima factura.'),
    ('0290201', 'Reclamación atendida en plazo'),
    ('0290202', 'Retraso imputable cliente/comercializadora'),
    ('0290203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0300101', 'Se indemniza incumplimiento de calidad de atención en '
                'próxima factura.'),
    ('0300201', 'Solicitud de información NNSS atendida en plazo'),
    ('0300202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0310101', 'Se indemniza incumplimiento de calidad de atención en '
                'próxima factura.'),
    ('0310201', 'Ejecución de NNSS atendido en plazo'),
    ('0310202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0320101', 'Se indemniza incumplimiento de calidad de atención en '
                'próxima factura'),
    ('0320201', 'Reconexión atendida en plazo'),
    ('0320202', 'Incumplimiento por causa imputable al cliente '),
    ('0320203', 'Plazo superado por motivos ajenos a la distribuidora '
                '(indicar motivo)'),
    ('0320204', 'Imposible ejecutar reenganche por causa ajena'),
    ('0320205', 'Expediente por anomalía/fraude en curso'),
    ('0320206', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0330101', 'Se indemniza'),
    ('0330201', 'No se han producido daños'),
    ('0330202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0330301', 'No corresponde a distribuidora'),
    ('0330302', 'Cliente no aporta la información necesaria'),
    ('0340101', 'Corregido parámetro '),
    ('0340102', 'Corregido parámetro potencia'),
    ('0340103', 'Corregido parámetro tensión'),
    ('0340104', 'Corregido parámetro tarifa'),
    ('0340105', 'Corregido parámetro caudal'),
    ('0340106', 'Corregido parámetro fecha activación'),
    ('0340107', 'Corregido parámetro dirección'),
    ('0340108', 'Corregido parámetro titular'),
    ('0340201', 'Contratación realizada según solicitud'),
    ('0340202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0340203', 'No existe solicitud'),
    ('0350101', 'Problema resuelto, reenviar solicitud.'),
    ('0350201', 'Solicitud correctamente rechazada.'),
    ('0350202', 'Imposible contactar con cliente'),
    ('0350203', 'Deficiencias en la instalación'),
    ('0350204', 'Falta documentación (CIE)'),
    ('0350205', 'Error de formato'),
    ('0350206', 'Datos ATR/ Peaje incoherentes'),
    ('0350207', 'Error en el cliente/NIF'),
    ('0350208', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0350209', 'No existe solicitud'),
    ('0360101', 'Se refactura con lectura aportada'),
    ('0360201', 'Lectura con integradores incorrectos '),
    ('0360202', 'Lectura anterior a la última real '),
    ('0360203', 'El suministro se liquida con curva de carga'),
    ('0360204', 'Periodo ajeno a esa comercializadora'),
    ('0360205', 'Estimacion superior a un año'),
    ('0360206', 'Lectura aportada adelantada'),
    ('0360207', 'Lectura aportada errónea '),
    ('0360208', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0370101', 'Se republica fichero'),
    ('0370201', 'Fichero correcto'),
    ('0370202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0380101', 'Alta/ baja cliente Robinson. Se modifican datos del cliente'),
    ('0380201', 'Cliente no consta en la base de datos'),
    ('0380202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0400101', 'Se envía duplicado solicitado'),
    ('0400201', 'No es posible enviar duplicado. (motivos en texto resultado)'),
    ('0400202', 'Periodo ajeno a esa comercializadora'),
    ('0400203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0450101', 'Dirección actualizada'),
    ('0450201', 'No procede, explicación en campo resultado'),
    ('0460101', 'Procede'),
    ('0460201', 'No procede, explicación en campo resultado'),
    ('0480101', 'Aclaración enviada'),
    ('0480201', 'No existe rechazo'),
    ('0480202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0480203', 'No existe solicitud'),
    ('0490101', 'Enviado fichero'),
    ('0490201', 'No existe fichero'),
    ('0490202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0500101', 'Se refactura el concepto reclamado'),
    ('0500201', 'Conceptos reclamados correctamente facturados '
                '(incluir explicación en campo comentarios)'),
    ('0500202', 'Inspección realizada'),
    ('0500203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0510101', 'Comportamiento técnico inadecuado'),
    ('0510201', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0520101', 'Inspección incompleta'),
    ('0520102', 'Inspección no realizada correctamente'),
    ('0520201', 'Inspección realizada correctamente'),
    ('0520202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0530101', 'Visita fallida'),
    ('0530102', 'Retraso en visita'),
    ('0530201', 'Visita en horario acordado'),
    ('0530202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0540101', 'Daños ocasionados en la instalación'),
    ('0540201', 'No procede indemnización'),
    ('0540202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0570101', 'Expediente anulado'),
    ('0570102', 'Expediente rectificado'),
    ('0570103', 'El cliente aporta documentación que justifica suministro '
                'sin actividad'),
    ('0570104', 'Error en periodo de recuperación'),
    ('0570105', 'Retraso en contratación con nuevo titular distinto del '
                'titular del expediente.'),
    ('0570201', 'Expediente correcto según normativa'),
    ('0570202', 'La distribuidora aporta prueba que justifican el '
                'expediente abierto'),
    ('0570203', 'No regularizado por impedimento del cliente'),
    ('0570204', 'El cliente no aporta documentación que justifica suministro '
                'sin actividad'),
    ('0570205', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0580101', 'Se gestiona la publicación del paso'),
    ('0580102', 'Movimiento realizado fuera de plazo'),
    ('0580201', 'No existe solicitud'),
    ('0580202', 'Movimiento realizado en plazo'),
    ('0580203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0590101', 'Se gestiona la publicación del paso'),
    ('0590102', 'Movimiento realizado fuera de plazo'),
    ('0590201', 'No existe solicitud'),
    ('0590202', 'Movimiento realizado en plazo'),
    ('0590203', 'Movimiento fuera de plazo imputable al cliente'),
    ('0590204', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0600101', 'Se gestiona la publicación del paso'),
    ('0600102', 'Movimiento realizado fuera de plazo'),
    ('0600201', 'No existe solicitud'),
    ('0600202', 'Movimiento realizado en plazo'),
    ('0600203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0610101', 'Se gestiona la publicación del paso'),
    ('0610102', 'Movimiento realizado fuera de plazo'),
    ('0610201', 'No existe solicitud'),
    ('0610202', 'Movimiento realizado en plazo'),
    ('0610203', 'Movimiento fuera de plazo imputable al cliente'),
    ('0610204', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0620101', 'Se gestiona la publicación del paso'),
    ('0620102', 'Movimiento realizado fuera de plazo'),
    ('0620201', 'No existe solicitud'),
    ('0620202', 'Movimiento realizado en plazo'),
    ('0620203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0630101', 'Se gestiona la publicación del paso'),
    ('0630102', 'Movimiento realizado fuera de plazo'),
    ('0630201', 'No existe solicitud'),
    ('0630202', 'Movimiento realizado en plazo'),
    ('0630203', 'Movimiento fuera de plazo imputable al cliente'),
    ('0630204', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0640101', 'Se gestiona la publicación del paso'),
    ('0640102', 'Movimiento realizado fuera de plazo'),
    ('0640201', 'No existe solicitud'),
    ('0640202', 'Movimiento realizado en plazo'),
    ('0640203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0650101', 'Se gestiona la publicación del paso'),
    ('0650102', 'Movimiento realizado fuera de plazo'),
    ('0650201', 'No existe solicitud'),
    ('0650202', 'Movimiento realizado en plazo'),
    ('0650203', 'Movimiento fuera de plazo imputable al cliente'),
    ('0650204', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0660101', 'Corregido parámetro'),
    ('0660102', 'Corregido parámetro potencia'),
    ('0660103', 'Corregido parámetro tensión'),
    ('0660104', 'Corregido parámetro tarifa'),
    ('0660105', 'Corregido parámetro caudal'),
    ('0660106', 'Corregido parámetro fecha activación'),
    ('0660107', 'Corregido parámetro dirección'),
    ('0660108', 'Corregido parámetro titular'),
    ('0660201', 'Contratación realizada según solicitud'),
    ('0660202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0670101', 'Equipo incorrecto. Incluye equipo desaparecido.'),
    ('0670102', 'Instalación incorrecta. Incluye relación de transformación'),
    ('0670103', 'Lectura errónea'),
    ('0670104', 'Contador parado'),
    ('0670105', 'Error programación EDM'),
    ('0670106', 'ICP inadecuado para la potencia contratada'),
    ('0670201', 'Equipo correcto'),
    ('0670202', 'Instalación correcta'),
    ('0670203', 'Histórico de consumos / lecturas coherente.'),
    ('0670204', 'Detectada anomalía en visita'),
    ('0670205', 'Expediente por anomalía en curso'),
    ('0670206', 'Elemento externo responsabilidad de cliente'),
    ('0670207', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0670301', 'No se localiza al cliente'),
    ('0670302', 'No corresponde a distribuidora. '),
    ('0670303', 'Cliente no aporta información adicional.'),
    ('0670304', 'Acceso denegado'),
    ('0670305', 'Visita anulada por cliente'),
    ('0680101', 'Se factura con PCS corregido'),
    ('0680201', 'PCS reclamado correctamente aplicado. '
                'Se adjunta explicación en comentarios.'),
    ('0680202', 'Improcedente. Se adjunta explicación en comentarios'),
]
TAULA_RESULTADO_RECLAMACION = [
    ('01', 'Procedente / Favorable'),
    ('02', 'Improcedente / Desfavorable'),
    ('03', 'No gestionable'),
    ('05', 'Duplicada'),
]
TAULA_TIPO_INFORMACION_ADICIONAL = [
    ('01', 'Factura reparación'),
    ('02', 'Nuevos Datos de Contacto'),
    ('03', 'Documento oficial'),
    ('04', 'Contacto y documentos'),
    ('05', 'IBAN'),
    ('06', 'Información mínima incoherente'),
]
TAULA_TIPO_VARIABLE_APORTACION_INFORMACION = [
    ('01', 'Nuevo teléfono de contacto'),
    ('02', 'Nueva persona de contacto'),
    ('03', 'Nuevo email de contacto'),
    ('04', 'IBAN'),
]
TAULA_TIPO_INFORMACION_ADICIONAL_APORTADA = [
    ('01', 'A iniciativa del comercializador.'),
    ('02', 'Respuesta a Solicitud de Más Información'),
    ('03', 'Respuesta a Solicitud de información necesaria para retipificar'),
]
TAULA_PRIORIDAD = [
    ('0', 'Prioridad normal.'),
    ('1', 'Prioridad alta. '),
]

REFUND_RECTIFICATIVE_TYPES = ['A', 'B']  # 'R' ?

REQUIRE_REFERENCE_TYPES = [
    'A', 'B', 'R'
]

SIGN = {'N': 1, 'R': 1, 'A': -1, 'B': -1}

TIPUS_CONCEPTES = {
    '0000': 'informacio',
    '0001': 'informacio',
    '0002': 'informacio',
    '0003': 'lloguer',
    # '0004': 'altres',
    # '0005': 'altres',
    # '0006': 'altres',
    '0007': 'informacio',
    '0008': 'impost',
    '0009': 'informacio',
    '0010': 'impost',
    '0011': 'informacio',
    '0012': 'lloguer',
    '0013': 'lloguer',
    '0014': 'lloguer',
    # '0015': 'altres',
    '0016': 'tfixe',
    '0017': 'tvariable',
    '1212': 'demora',  # Es diferent perque no te impostos, s'ha de tractar per separat
    # '****': 'altres'
}

SUBTYPES_A1_48 = SUBTYPES_R101[:]

TAULA_TIPO_COMUNICACION_A12_26 = [
    ('01', "Corrección de errores puntuales"),
    ('05', "Actualización de datos: denominación de las calles, errores en los datos del cliente..."),
    ('06', "Reubicación tarifaria"),
]

TAULA_TIPO_COMUNICACION_A19_45 = [
    ('08', "Comunicación de fecha y resultado de las inspecciones periódicas"),
    ('09', "Comunicación de cortes y reinicios de actuación derivadas de inspección."),
    ('10', "Comunicación de cortes y reinicios de actuaciones en campo derivadas de operaciones de emergencias"),
    ('11', "Comunicación de actuación a petición del consumidor."),
]
