import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVsphereHostConfig extends cdktf.TerraformMetaArguments {
    /**
    * The managed object ID of the datacenter to look for the host in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/host#datacenter_id DataVsphereHost#datacenter_id}
    */
    readonly datacenterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/host#id DataVsphereHost#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the host. This can be a name or path.	If not provided, the default host is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vsphere/d/host#name DataVsphereHost#name}
    */
    readonly name?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vsphere/d/host vsphere_host}
*/
export declare class DataVsphereHost extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vsphere_host";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vsphere/d/host vsphere_host} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVsphereHostConfig
    */
    constructor(scope: Construct, id: string, config: DataVsphereHostConfig);
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    get datacenterIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get resourcePoolId(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
