from setuptools import setup, find_packages
import codecs
import os

here = os.path.abspath(os.path.dirname(__file__))

with codecs.open(os.path.join(here, "README.md"), encoding="utf-8") as fh:
    long_description = "\n" + fh.read()

    VERSION = '0.1.0'
DESCRIPTION = 'This is for detect coordinates parts of the body'

# Setting up
setup(
    name="landmark-detection",
    author="Mahmoud kouwis",
    version=VERSION,
    author_email="<kouwiss.jr@gmail.com>",
    description=DESCRIPTION,
    long_description_content_type="text/markdown",

    packages=find_packages(),
    long_description=long_description,
    install_requires=['mediapipe', 'opencv-python'],
    keywords=['python', 'opencv', 'mediapipe', 'detection', 'landmarks'],
    classifiers=[
        "Development Status :: 1 - Planning",
        "Intended Audience :: Developers",
        "Programming Language :: Python :: 3",
        "Operating System :: Unix",
        "Operating System :: MacOS :: MacOS X",
        "Operating System :: Microsoft :: Windows",
    ]
)
