# coding: utf-8

"""
    dbt Cloud API v2

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 2.0.0a1
    Contact: support@getdbt.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from dbt_cloud_client.api_client import ApiClient


class RunsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def cancel_run_by_id(self, account_id, run_id, **kwargs):  # noqa: E501
        """cancel specific run on account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_run_by_id(account_id, run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: Numeric ID of the account for this run (required)
        :param int run_id: Numeric ID of the run to cancel (required)
        :return: RunResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cancel_run_by_id_with_http_info(account_id, run_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cancel_run_by_id_with_http_info(account_id, run_id, **kwargs)  # noqa: E501
            return data

    def cancel_run_by_id_with_http_info(self, account_id, run_id, **kwargs):  # noqa: E501
        """cancel specific run on account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_run_by_id_with_http_info(account_id, run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: Numeric ID of the account for this run (required)
        :param int run_id: Numeric ID of the run to cancel (required)
        :return: RunResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'run_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_run_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `cancel_run_by_id`")  # noqa: E501
        # verify the required parameter 'run_id' is set
        if ('run_id' not in params or
                params['run_id'] is None):
            raise ValueError("Missing the required parameter `run_id` when calling `cancel_run_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']  # noqa: E501
        if 'run_id' in params:
            path_params['runId'] = params['run_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/accounts/{accountId}/runs/{runId}/cancel/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RunResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_run_by_id(self, account_id, run_id, **kwargs):  # noqa: E501
        """get specific run on account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run_by_id(account_id, run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: Numeric ID of the account to retrieve (required)
        :param int run_id: Numeric ID of the run to retrieve (required)
        :param str include_related: List of related fields to pull with the run. Valid values are  \"trigger\" and \"job\". 
        :return: RunResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_run_by_id_with_http_info(account_id, run_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_run_by_id_with_http_info(account_id, run_id, **kwargs)  # noqa: E501
            return data

    def get_run_by_id_with_http_info(self, account_id, run_id, **kwargs):  # noqa: E501
        """get specific run on account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run_by_id_with_http_info(account_id, run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: Numeric ID of the account to retrieve (required)
        :param int run_id: Numeric ID of the run to retrieve (required)
        :param str include_related: List of related fields to pull with the run. Valid values are  \"trigger\" and \"job\". 
        :return: RunResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'run_id', 'include_related']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_run_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_run_by_id`")  # noqa: E501
        # verify the required parameter 'run_id' is set
        if ('run_id' not in params or
                params['run_id'] is None):
            raise ValueError("Missing the required parameter `run_id` when calling `get_run_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']  # noqa: E501
        if 'run_id' in params:
            path_params['runId'] = params['run_id']  # noqa: E501

        query_params = []
        if 'include_related' in params:
            query_params.append(('include_related', params['include_related']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/accounts/{accountId}/runs/{runId}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RunResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_runs_for_account(self, account_id, include_related, **kwargs):  # noqa: E501
        """search or list runs for an account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_runs_for_account(account_id, include_related, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: Numeric ID of the account to retrieve (required)
        :param str include_related: List of related fields to pull with the run. Valid values are  \"trigger\" and \"job\".  (required)
        :param str order_by: Field to order the result by. Use `-` to indicate reverse order. 
        :return: RunsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_runs_for_account_with_http_info(account_id, include_related, **kwargs)  # noqa: E501
        else:
            (data) = self.list_runs_for_account_with_http_info(account_id, include_related, **kwargs)  # noqa: E501
            return data

    def list_runs_for_account_with_http_info(self, account_id, include_related, **kwargs):  # noqa: E501
        """search or list runs for an account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_runs_for_account_with_http_info(account_id, include_related, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: Numeric ID of the account to retrieve (required)
        :param str include_related: List of related fields to pull with the run. Valid values are  \"trigger\" and \"job\".  (required)
        :param str order_by: Field to order the result by. Use `-` to indicate reverse order. 
        :return: RunsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'include_related', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_runs_for_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_runs_for_account`")  # noqa: E501
        # verify the required parameter 'include_related' is set
        if ('include_related' not in params or
                params['include_related'] is None):
            raise ValueError("Missing the required parameter `include_related` when calling `list_runs_for_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']  # noqa: E501

        query_params = []
        if 'include_related' in params:
            query_params.append(('include_related', params['include_related']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/accounts/{accountId}/runs/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RunsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
