# coding: utf-8

"""
    dbt Cloud API v2

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 2.0.0a1
    Contact: support@getdbt.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from dbt_cloud_client.api_client import ApiClient


class EnvironmentsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_environment(self, account_id, **kwargs):  # noqa: E501
        """create environment on account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_environment(account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: Numeric ID of the Account to create the new Environment in (required)
        :param Environment body:
        :return: EnvironmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_environment_with_http_info(account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_environment_with_http_info(account_id, **kwargs)  # noqa: E501
            return data

    def create_environment_with_http_info(self, account_id, **kwargs):  # noqa: E501
        """create environment on account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_environment_with_http_info(account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: Numeric ID of the Account to create the new Environment in (required)
        :param Environment body:
        :return: EnvironmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_environment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_environment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/accounts/{accountId}/environments/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_environment_by_id(self, account_id, environment_id, **kwargs):  # noqa: E501
        """delete environment on account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_environment_by_id(account_id, environment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: Numeric ID of the Account that the Environment belongs to (required)
        :param int environment_id: Numeric ID of the Environment to delete (required)
        :return: EnvironmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_environment_by_id_with_http_info(account_id, environment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_environment_by_id_with_http_info(account_id, environment_id, **kwargs)  # noqa: E501
            return data

    def delete_environment_by_id_with_http_info(self, account_id, environment_id, **kwargs):  # noqa: E501
        """delete environment on account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_environment_by_id_with_http_info(account_id, environment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: Numeric ID of the Account that the Environment belongs to (required)
        :param int environment_id: Numeric ID of the Environment to delete (required)
        :return: EnvironmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'environment_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_environment_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_environment_by_id`")  # noqa: E501
        # verify the required parameter 'environment_id' is set
        if ('environment_id' not in params or
                params['environment_id'] is None):
            raise ValueError("Missing the required parameter `environment_id` when calling `delete_environment_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']  # noqa: E501
        if 'environment_id' in params:
            path_params['environmentId'] = params['environment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/accounts/{accountId}/environments/{environmentId}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_environment_by_id(self, account_id, environment_id, **kwargs):  # noqa: E501
        """get specific environment on account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_environment_by_id(account_id, environment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: Numeric ID of the account to retrieve (required)
        :param int environment_id: Numeric ID of the run to retrieve (required)
        :return: JobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_environment_by_id_with_http_info(account_id, environment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_environment_by_id_with_http_info(account_id, environment_id, **kwargs)  # noqa: E501
            return data

    def get_environment_by_id_with_http_info(self, account_id, environment_id, **kwargs):  # noqa: E501
        """get specific environment on account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_environment_by_id_with_http_info(account_id, environment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: Numeric ID of the account to retrieve (required)
        :param int environment_id: Numeric ID of the run to retrieve (required)
        :return: JobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'environment_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_environment_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_environment_by_id`")  # noqa: E501
        # verify the required parameter 'environment_id' is set
        if ('environment_id' not in params or
                params['environment_id'] is None):
            raise ValueError("Missing the required parameter `environment_id` when calling `get_environment_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']  # noqa: E501
        if 'environment_id' in params:
            path_params['environmentId'] = params['environment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/accounts/{accountId}/environments/{environmentId}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='JobResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_environments_for_account(self, account_id, **kwargs):  # noqa: E501
        """search or list environments on an account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_environments_for_account(account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: Numeric ID of the account to retrieve (required)
        :param str order_by: Field to order the result by. Use `-` to indicate reverse order. 
        :return: EnvironmentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_environments_for_account_with_http_info(account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_environments_for_account_with_http_info(account_id, **kwargs)  # noqa: E501
            return data

    def list_environments_for_account_with_http_info(self, account_id, **kwargs):  # noqa: E501
        """search or list environments on an account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_environments_for_account_with_http_info(account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: Numeric ID of the account to retrieve (required)
        :param str order_by: Field to order the result by. Use `-` to indicate reverse order. 
        :return: EnvironmentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_environments_for_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_environments_for_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']  # noqa: E501

        query_params = []
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/accounts/{accountId}/environments/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_environment_by_id(self, account_id, environment_id, **kwargs):  # noqa: E501
        """update environment on account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_environment_by_id(account_id, environment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: Numeric ID of the Account that the Environment belongs to (required)
        :param int environment_id: Numeric ID of the Environment to update (required)
        :param Environment body:
        :return: EnvironmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_environment_by_id_with_http_info(account_id, environment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_environment_by_id_with_http_info(account_id, environment_id, **kwargs)  # noqa: E501
            return data

    def update_environment_by_id_with_http_info(self, account_id, environment_id, **kwargs):  # noqa: E501
        """update environment on account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_environment_by_id_with_http_info(account_id, environment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: Numeric ID of the Account that the Environment belongs to (required)
        :param int environment_id: Numeric ID of the Environment to update (required)
        :param Environment body:
        :return: EnvironmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'environment_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_environment_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_environment_by_id`")  # noqa: E501
        # verify the required parameter 'environment_id' is set
        if ('environment_id' not in params or
                params['environment_id'] is None):
            raise ValueError("Missing the required parameter `environment_id` when calling `update_environment_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']  # noqa: E501
        if 'environment_id' in params:
            path_params['environmentId'] = params['environment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/accounts/{accountId}/environments/{environmentId}/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
