# dbt-cloud-python
Python client for dbt cloud

No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 2.0.0a1
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import dbt_cloud_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import dbt_cloud_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import dbt_cloud_client
from dbt_cloud_client.rest import ApiException
from pprint import pprint


# create an instance of the API class
api_instance = dbt_cloud_client.AccountsApi(dbt_cloud_client.ApiClient(configuration))
account_id = 56 # int | Numeric ID of the account to retrieve

try:
    # get account by id
    api_response = api_instance.get_account_by_id(account_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountsApi->get_account_by_id: %s\n" % e)


# create an instance of the API class
api_instance = dbt_cloud_client.AccountsApi(dbt_cloud_client.ApiClient(configuration))

try:
    # search or list accounts
    api_response = api_instance.list_accounts()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountsApi->list_accounts: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://cloud.getdbt.com/api/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountsApi* | [**get_account_by_id**](docs/AccountsApi.md#get_account_by_id) | **GET** /accounts/{accountId}/ | get account by id
*AccountsApi* | [**list_accounts**](docs/AccountsApi.md#list_accounts) | **GET** /accounts/ | search or list accounts
*ConnectionsApi* | [**create_connection**](docs/ConnectionsApi.md#create_connection) | **POST** /accounts/{accountId}/connections/ | create connection on account
*ConnectionsApi* | [**delete_connection_by_id**](docs/ConnectionsApi.md#delete_connection_by_id) | **DELETE** /accounts/{accountId}/connections/{connectionId}/ | delete connection on account
*ConnectionsApi* | [**get_connection_by_id**](docs/ConnectionsApi.md#get_connection_by_id) | **GET** /accounts/{accountId}/connections/{connectionId}/ | get specific connection on account
*ConnectionsApi* | [**list_connections_for_account**](docs/ConnectionsApi.md#list_connections_for_account) | **GET** /accounts/{accountId}/connections/ | search or list connections on an account
*ConnectionsApi* | [**update_connection_by_id**](docs/ConnectionsApi.md#update_connection_by_id) | **POST** /accounts/{accountId}/connections/{connectionId}/ | update connection on account
*CredentialsApi* | [**create_credentials**](docs/CredentialsApi.md#create_credentials) | **POST** /accounts/{accountId}/credentials/ | create credentials on account
*CredentialsApi* | [**list_credentials_for_account**](docs/CredentialsApi.md#list_credentials_for_account) | **GET** /accounts/{accountId}/credentials/ | search or list credentials on an account
*EnvironmentsApi* | [**create_environment**](docs/EnvironmentsApi.md#create_environment) | **POST** /accounts/{accountId}/environments/ | create environment on account
*EnvironmentsApi* | [**delete_environment_by_id**](docs/EnvironmentsApi.md#delete_environment_by_id) | **DELETE** /accounts/{accountId}/environments/{environmentId}/ | delete environment on account
*EnvironmentsApi* | [**get_environment_by_id**](docs/EnvironmentsApi.md#get_environment_by_id) | **GET** /accounts/{accountId}/environments/{environmentId}/ | get specific environment on account
*EnvironmentsApi* | [**list_environments_for_account**](docs/EnvironmentsApi.md#list_environments_for_account) | **GET** /accounts/{accountId}/environments/ | search or list environments on an account
*EnvironmentsApi* | [**update_environment_by_id**](docs/EnvironmentsApi.md#update_environment_by_id) | **POST** /accounts/{accountId}/environments/{environmentId}/ | update environment on account
*JobsApi* | [**create_job**](docs/JobsApi.md#create_job) | **POST** /accounts/{accountId}/jobs/ | create job on account
*JobsApi* | [**delete_job_by_id**](docs/JobsApi.md#delete_job_by_id) | **DELETE** /accounts/{accountId}/jobs/{jobId}/ | delete job on account
*JobsApi* | [**get_job_by_id**](docs/JobsApi.md#get_job_by_id) | **GET** /accounts/{accountId}/jobs/{jobId}/ | get specific job on account
*JobsApi* | [**list_jobs_for_account**](docs/JobsApi.md#list_jobs_for_account) | **GET** /accounts/{accountId}/jobs/ | search or list jobs on an account
*JobsApi* | [**trigger_run**](docs/JobsApi.md#trigger_run) | **POST** /accounts/{accountId}/jobs/{jobId}/run/ | trigger run for job
*JobsApi* | [**update_job_by_id**](docs/JobsApi.md#update_job_by_id) | **POST** /accounts/{accountId}/jobs/{jobId}/ | update job on account
*RepositoriesApi* | [**create_repository**](docs/RepositoriesApi.md#create_repository) | **POST** /accounts/{accountId}/repositories/ | create repository on account
*RepositoriesApi* | [**get_repository_by_id**](docs/RepositoriesApi.md#get_repository_by_id) | **GET** /accounts/{accountId}/repositories/{repositoryId}/ | get specific repository on account
*RepositoriesApi* | [**list_repositories_for_account**](docs/RepositoriesApi.md#list_repositories_for_account) | **GET** /accounts/{accountId}/repositories/ | search or list repositories on an account
*RunsApi* | [**cancel_run_by_id**](docs/RunsApi.md#cancel_run_by_id) | **POST** /accounts/{accountId}/runs/{runId}/cancel/ | cancel specific run on account
*RunsApi* | [**get_run_by_id**](docs/RunsApi.md#get_run_by_id) | **GET** /accounts/{accountId}/runs/{runId}/ | get specific run on account
*RunsApi* | [**list_runs_for_account**](docs/RunsApi.md#list_runs_for_account) | **GET** /accounts/{accountId}/runs/ | search or list runs for an account

## Documentation For Models

 - [Account](docs/Account.md)
 - [AccountResponse](docs/AccountResponse.md)
 - [AccountsResponse](docs/AccountsResponse.md)
 - [BigqueryConnection](docs/BigqueryConnection.md)
 - [BigqueryCredential](docs/BigqueryCredential.md)
 - [Body](docs/Body.md)
 - [Body1](docs/Body1.md)
 - [Body2](docs/Body2.md)
 - [Body3](docs/Body3.md)
 - [Body4](docs/Body4.md)
 - [Connection](docs/Connection.md)
 - [ConnectionResponse](docs/ConnectionResponse.md)
 - [ConnectionsResponse](docs/ConnectionsResponse.md)
 - [CredentialsResponse](docs/CredentialsResponse.md)
 - [Environment](docs/Environment.md)
 - [EnvironmentResponse](docs/EnvironmentResponse.md)
 - [EnvironmentsResponse](docs/EnvironmentsResponse.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [Job](docs/Job.md)
 - [JobResponse](docs/JobResponse.md)
 - [JobSchedule](docs/JobSchedule.md)
 - [JobScheduleDate](docs/JobScheduleDate.md)
 - [JobScheduleTime](docs/JobScheduleTime.md)
 - [JobSettings](docs/JobSettings.md)
 - [JobTriggers](docs/JobTriggers.md)
 - [JobsResponse](docs/JobsResponse.md)
 - [OneOfConnectionResponseData](docs/OneOfConnectionResponseData.md)
 - [OneOfbody](docs/OneOfbody.md)
 - [OneOfbody1](docs/OneOfbody1.md)
 - [OneOfbody2](docs/OneOfbody2.md)
 - [RepositoriesResponse](docs/RepositoriesResponse.md)
 - [Repository](docs/Repository.md)
 - [RepositoryResponse](docs/RepositoryResponse.md)
 - [Run](docs/Run.md)
 - [RunResponse](docs/RunResponse.md)
 - [RunsResponse](docs/RunsResponse.md)
 - [Status](docs/Status.md)
 - [Trigger](docs/Trigger.md)

## Documentation For Authorization


## bearerAuth



## Author

support@getdbt.com
