/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import no.priv.garshol.duke.Link;
import no.priv.garshol.duke.LinkDatabase;
import no.priv.garshol.duke.LinkKind;
import no.priv.garshol.duke.LinkStatus;
import no.priv.garshol.duke.utils.LinkDatabaseUtils;
import no.priv.garshol.duke.utils.LinkFileWriter;
import no.priv.garshol.duke.utils.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class LinkFileWriterTest {
    private File file;
    private FileWriter writer;
    private LinkFileWriter out;
    private LinkDatabase db;
    @Rule
    public TemporaryFolder tmpdir = new TemporaryFolder();

    @Before
    public void setup() throws IOException {
        this.file = this.tmpdir.newFile("links.txt");
        this.writer = new FileWriter(this.file);
        this.out = new LinkFileWriter((Writer)this.writer);
    }

    @Test
    public void testEmpty() throws IOException {
        this.writer.close();
        this.load();
        Assert.assertEquals((String)"shouldn't contain links", (long)0L, (long)this.db.getAllLinks().size());
    }

    @Test
    public void testSingleLink() throws IOException {
        this.out.write("1", "2", true, 0.95);
        this.writer.close();
        this.load();
        Assert.assertEquals((long)1L, (long)this.db.getAllLinks().size());
        Link link = (Link)this.db.getAllLinks().iterator().next();
        TestUtils.verifySame(new Link("1", "2", LinkStatus.ASSERTED, LinkKind.SAME, 0.95), link);
    }

    @Test
    public void testThreeLink() throws IOException {
        this.out.write("1", "2", true, 0.95);
        this.out.write("1", "3", false, 0.2);
        this.out.write("3", "4", true, 0.8);
        this.writer.close();
        this.load();
        Assert.assertEquals((long)3L, (long)this.db.getAllLinks().size());
        Collection links = this.db.getAllLinks();
        Link link = this.find(links, "1", "2");
        TestUtils.verifySame(new Link("1", "2", LinkStatus.ASSERTED, LinkKind.SAME, 0.95), link);
        link = this.find(links, "1", "3");
        TestUtils.verifySame(new Link("1", "3", LinkStatus.ASSERTED, LinkKind.DIFFERENT, 0.2), link);
        link = this.find(links, "3", "4");
        TestUtils.verifySame(new Link("3", "4", LinkStatus.ASSERTED, LinkKind.SAME, 0.8), link);
    }

    private Link find(Collection<Link> links, String id1, String id2) {
        for (Link link : links) {
            if (!link.getID1().equals(id1) || !link.getID2().equals(id2)) continue;
            return link;
        }
        Assert.fail((String)("Couldn't find link " + id1 + " " + id2));
        return null;
    }

    private void load() throws IOException {
        this.db = LinkDatabaseUtils.loadTestFile((String)this.file.getAbsolutePath());
    }
}

