/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.datasources;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Properties;
import no.priv.garshol.duke.Cleaner;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.RecordIterator;
import no.priv.garshol.duke.cleaners.LowerCaseNormalizeCleaner;
import no.priv.garshol.duke.cleaners.RegexpCleaner;
import no.priv.garshol.duke.datasources.Column;
import no.priv.garshol.duke.datasources.JDBCDataSource;
import no.priv.garshol.duke.utils.JDBCUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JDBCDataSourceTest {
    private Statement stmt;
    private JDBCDataSource source;
    private static final String DRIVER = "org.h2.Driver";
    private static final String JDBC_URI = "jdbc:h2:mem:testdb";

    @Before
    public void setUp() {
        this.connect();
        this.perform("drop table if exists testdata");
        this.perform("create table testdata (id int, name varchar)");
        this.source = new JDBCDataSource();
        this.source.setConnectionString(JDBC_URI);
        this.source.setDriverClass(DRIVER);
        this.source.setQuery("select * from testdata order by id");
    }

    @Test
    public void testEmpty() {
        RecordIterator it = this.source.getRecords();
        Assert.assertTrue((!it.hasNext() ? 1 : 0) != 0);
    }

    @Test
    public void testOneRow() {
        this.perform("insert into testdata values (1, 'foo')");
        this.source.addColumn(new Column("ID", null, null, null));
        this.source.addColumn(new Column("NAME", null, null, null));
        RecordIterator it = this.source.getRecords();
        Assert.assertTrue((boolean)it.hasNext());
        Record r = (Record)it.next();
        Assert.assertEquals((Object)"1", (Object)r.getValue("ID"));
        Assert.assertEquals((Object)"foo", (Object)r.getValue("NAME"));
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testOneRowSkipColumn() {
        this.perform("insert into testdata values (1, 'foo')");
        this.source.addColumn(new Column("ID", null, null, null));
        RecordIterator it = this.source.getRecords();
        Assert.assertTrue((boolean)it.hasNext());
        Record r = (Record)it.next();
        Assert.assertEquals((Object)"1", (Object)r.getValue("ID"));
        Assert.assertEquals(null, (Object)r.getValue("NAME"));
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testOneRowMapColumnTwice() {
        this.perform("insert into testdata values (1, 'smith, john')");
        RegexpCleaner givencleaner = new RegexpCleaner();
        givencleaner.setRegexp(", (.+)");
        RegexpCleaner familycleaner = new RegexpCleaner();
        familycleaner.setRegexp("^([^,]+), ");
        this.source.addColumn(new Column("ID", null, null, null));
        this.source.addColumn(new Column("NAME", "GIVENNAME", null, (Cleaner)givencleaner));
        this.source.addColumn(new Column("NAME", "FAMILYNAME", null, (Cleaner)familycleaner));
        RecordIterator it = this.source.getRecords();
        Assert.assertTrue((boolean)it.hasNext());
        Record r = (Record)it.next();
        Assert.assertEquals((Object)"1", (Object)r.getValue("ID"));
        Assert.assertEquals((Object)"john", (Object)r.getValue("GIVENNAME"));
        Assert.assertEquals((Object)"smith", (Object)r.getValue("FAMILYNAME"));
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testNull() {
        this.perform("insert into testdata values (1, NULL)");
        LowerCaseNormalizeCleaner cleaner = new LowerCaseNormalizeCleaner();
        this.source.addColumn(new Column("ID", null, null, null));
        this.source.addColumn(new Column("NAME", "GIVENNAME", null, (Cleaner)cleaner));
        RecordIterator it = this.source.getRecords();
        Assert.assertTrue((boolean)it.hasNext());
        Record r = (Record)it.next();
        Assert.assertEquals((Object)"1", (Object)r.getValue("ID"));
        Assert.assertEquals(null, (Object)r.getValue("GIVENNAME"));
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testSplitting() {
        this.perform("insert into testdata values (1, 'foo bar baz')");
        this.source.addColumn(new Column("ID", null, null, null));
        Column col = new Column("NAME", null, null, null);
        col.setSplitOn(" ");
        this.source.addColumn(col);
        RecordIterator it = this.source.getRecords();
        Assert.assertTrue((boolean)it.hasNext());
        Record r = (Record)it.next();
        Assert.assertEquals((Object)"1", (Object)r.getValue("ID"));
        Collection values = r.getValues("NAME");
        Assert.assertEquals((long)3L, (long)values.size());
        Assert.assertTrue((boolean)values.contains("foo"));
        Assert.assertTrue((boolean)values.contains("bar"));
        Assert.assertTrue((boolean)values.contains("baz"));
        Assert.assertFalse((boolean)it.hasNext());
    }

    private void connect() {
        this.stmt = JDBCUtils.open((String)DRIVER, (String)JDBC_URI, (Properties)new Properties());
    }

    private void perform(String sql) {
        try {
            this.stmt.execute(sql);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

