/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.cleaners;

import no.priv.garshol.duke.Cleaner;
import no.priv.garshol.duke.cleaners.HTMLCleaner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HTMLCleanerTest {
    protected Cleaner cleaner;

    @Before
    public void setUp() {
        this.cleaner = new HTMLCleaner();
    }

    @Test
    public void testEmpty() {
        Assert.assertEquals((Object)"", (Object)this.cleaner.clean(""));
    }

    @Test
    public void testSingleChar() {
        Assert.assertEquals((Object)"a", (Object)this.cleaner.clean("a"));
    }

    @Test
    public void testSingleEntity() {
        Assert.assertEquals((Object)"ralf hartmut g\u00fcting", (Object)this.cleaner.clean("ralf hartmut g&#252;ting"));
    }

    @Test
    public void testFirst() {
        Assert.assertEquals((Object)"ABC", (Object)this.cleaner.clean("&#65;BC"));
    }

    @Test
    public void testLast() {
        Assert.assertEquals((Object)"ABC", (Object)this.cleaner.clean("AB&#67;"));
    }

    @Test
    public void testSingleNamedEntity() {
        Assert.assertEquals((Object)"the vldb journal \u2014 the international journal on very large data bases", (Object)this.cleaner.clean("the vldb journal &mdash; the international journal on very large data bases"));
    }

    @Test
    public void testThreeEntities() {
        Assert.assertEquals((Object)"ricardo jim\u00e9nez-peris, m. pati\u00f1o-mart\u00ednez, gustavo alonso, bettina kemme", (Object)this.cleaner.clean("ricardo jim&#233;nez-peris, m. pati&#241;o-mart&#237;nez, gustavo alonso, bettina kemme"));
    }
}

