/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.datasources;

import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.util.JSON;
import java.net.UnknownHostException;
import java.util.Arrays;
import no.priv.garshol.duke.ConfigWriter;
import no.priv.garshol.duke.DukeException;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.RecordIterator;
import no.priv.garshol.duke.datasources.Column;
import no.priv.garshol.duke.datasources.ColumnarDataSource;
import no.priv.garshol.duke.datasources.RecordBuilder;
import org.xml.sax.helpers.AttributeListImpl;

public class MongoDBDataSource
extends ColumnarDataSource {
    private static int MIN_PORT = 1;
    private static int MAX_PORT = 65535;
    private String mongouri = "localhost";
    private int port = 27017;
    private static String AUTH_ON_ADMIN = "admin";
    private static String AUTH_ON_DB = "true";
    private static String AUTH_FALSE = "false";
    private String auth = AUTH_FALSE;
    private String username;
    private String password;
    private boolean noTimeOut = false;
    private String dbname;
    private String collectionName;
    private String query = "{}";
    private String projection;

    public void setServerAddress(String addr) {
        if (!addr.equals("")) {
            this.mongouri = addr;
        }
    }

    public void setPortNumber(String port) {
        try {
            int parsedPort = Integer.parseInt(port, 10);
            if (parsedPort >= MIN_PORT && parsedPort <= MAX_PORT) {
                this.port = parsedPort;
            }
        }
        catch (NumberFormatException ex) {
            System.out.println("** Invalid port number: " + port);
            throw new DukeException((Throwable)ex);
        }
    }

    public void setDbAuth(String authdb) {
        if (authdb.toLowerCase().equals(AUTH_ON_DB)) {
            this.auth = AUTH_ON_DB;
        } else if (authdb.toLowerCase().equals(AUTH_ON_ADMIN)) {
            this.auth = AUTH_ON_ADMIN;
        }
    }

    public void setUserName(String username) {
        if (!username.equals("")) {
            this.username = username;
        }
    }

    public void setPassword(String password) {
        if (!password.equals("")) {
            this.password = password;
        }
    }

    public void setDatabase(String dbname) {
        if (!dbname.equals("")) {
            this.dbname = dbname;
        }
    }

    public void setCursorNotimeout(String timeout) {
        if (timeout.toLowerCase().equals("true")) {
            this.noTimeOut = true;
        }
    }

    public void setCollection(String collectionName) {
        if (!collectionName.equals("")) {
            this.collectionName = collectionName;
        }
    }

    public void setQuery(String query) {
        if (!query.equals("")) {
            this.query = query;
        }
    }

    public void setProjection(String projection) {
        if (!projection.equals("")) {
            this.projection = projection;
        }
    }

    public String getServerAddress() {
        return this.mongouri;
    }

    public String getPortNumber() {
        return Integer.toString(this.port);
    }

    public String getDbAuth() {
        return this.auth;
    }

    public String getUserName() {
        if (this.username == null) {
            return "";
        }
        return this.username;
    }

    public String getPassword() {
        if (this.password == null) {
            return "";
        }
        return this.password;
    }

    public String getDatabase() {
        return this.dbname;
    }

    public String getCursorNotimeout() {
        if (this.noTimeOut) {
            return "true";
        }
        return "false";
    }

    public String getCollection() {
        return this.collectionName;
    }

    public String getQuery() {
        return this.query;
    }

    public String getProjection() {
        if (this.projection == null) {
            return "";
        }
        return this.projection;
    }

    public RecordIterator getRecords() {
        this.verifyProperty(this.dbname, "database");
        this.verifyProperty(this.collectionName, "collection");
        try {
            DBCursor result;
            MongoClient mongo;
            if (this.auth.equals(AUTH_ON_DB)) {
                this.verifyProperty(this.username, "user-name");
                this.verifyProperty(this.password, "password");
                mongo = new MongoClient(new ServerAddress(this.mongouri, this.port), Arrays.asList(MongoCredential.createMongoCRCredential((String)this.username, (String)this.dbname, (char[])this.password.toCharArray())));
            } else if (this.auth.equals(AUTH_ON_ADMIN)) {
                this.verifyProperty(this.username, "user-name");
                this.verifyProperty(this.password, "password");
                mongo = new MongoClient(new ServerAddress(this.mongouri, this.port), Arrays.asList(MongoCredential.createMongoCRCredential((String)this.username, (String)AUTH_ON_ADMIN, (char[])this.password.toCharArray())));
            } else {
                mongo = new MongoClient(new ServerAddress(this.mongouri, this.port));
            }
            DB database = mongo.getDB(this.dbname);
            DBCollection collection = database.getCollection(this.collectionName);
            DBObject queryDocument = (DBObject)JSON.parse((String)this.query);
            if (this.projection == null) {
                result = collection.find(queryDocument);
            } else {
                DBObject projectionDocument = (DBObject)JSON.parse((String)this.projection);
                result = collection.find(queryDocument, projectionDocument);
            }
            if (this.noTimeOut) {
                result.addOption(16);
            }
            return new MongoDBIterator(result, mongo);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        catch (Exception ex) {
            throw new DukeException((Throwable)ex);
        }
    }

    public void writeConfig(ConfigWriter cw) {
        String name = "data-source";
        String klass = ((Object)((Object)this)).getClass().getName();
        AttributeListImpl attribs = new AttributeListImpl();
        attribs.addAttribute("class", "CDATA", klass);
        cw.writeStartElement("data-source", attribs);
        cw.writeParam("server-address", this.getServerAddress());
        cw.writeParam("port-number", this.getPortNumber());
        cw.writeParam("user-name", this.getUserName());
        cw.writeParam("password", this.getPassword());
        cw.writeParam("db-auth", this.getDbAuth());
        cw.writeParam("database", this.getDatabase());
        cw.writeParam("cursor-notimeout", this.getCursorNotimeout());
        cw.writeParam("collection", this.getCollection());
        cw.writeParam("query", this.getQuery());
        cw.writeParam("projection", this.getProjection());
        cw.writeEndElement("data-source");
    }

    protected String getSourceName() {
        return "MongoDB";
    }

    public class MongoDBIterator
    extends RecordIterator {
        private DBCursor cursor;
        private MongoClient mongoClient;
        private DBObject element;
        private boolean hasNext;
        private RecordBuilder builder;
        private static final String DOT = ".";

        public MongoDBIterator(DBCursor cursor, MongoClient mongoClient) throws MongoException {
            this.mongoClient = mongoClient;
            this.cursor = cursor;
            this.hasNext = cursor.hasNext();
            this.builder = new RecordBuilder((ColumnarDataSource)MongoDBDataSource.this);
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public Record next() {
            try {
                this.element = this.cursor.next();
                this.builder.newRecord();
                for (Column col : MongoDBDataSource.this.getColumns()) {
                    String value = this.getStringValueFromCursorElement(this.element, col.getName());
                    this.builder.addValue(col, value);
                }
                this.hasNext = this.cursor.hasNext();
                return this.builder.getRecord();
            }
            catch (MongoException e) {
                throw new RuntimeException(e);
            }
        }

        private String getStringValueFromCursorElement(DBObject elem, String propName) {
            int dotIndex = propName.indexOf(DOT);
            if (dotIndex == -1) {
                Object value = elem.get(propName);
                if (value instanceof String) {
                    return (String)value;
                }
                if (value == null) {
                    return null;
                }
                return value.toString();
            }
            String propNameSuffix = propName.substring(0, dotIndex);
            DBObject subValue = (DBObject)elem.get(propNameSuffix);
            String subPropName = propName.substring(dotIndex + 1);
            return this.getStringValueFromCursorElement(subValue, subPropName);
        }

        public void close() {
            try {
                this.mongoClient.close();
            }
            catch (Exception e) {
                throw new DukeException((Throwable)e);
            }
        }
    }
}

