/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.comparators;

import no.priv.garshol.duke.Comparator;

public class Levenshtein
implements Comparator {
    @Override
    public double compare(String s1, String s2) {
        int maxlen;
        int len = Math.min(s1.length(), s2.length());
        if ((double)len / (double)(maxlen = Math.max(s1.length(), s2.length())) <= 0.5) {
            return 0.0;
        }
        if (len == maxlen && s1.equals(s2)) {
            return 1.0;
        }
        int dist = Math.min(Levenshtein.compactDistance(s1, s2), len);
        return 1.0 - (double)dist / (double)len;
    }

    @Override
    public boolean isTokenized() {
        return true;
    }

    public static int distance(String s1, String s2) {
        if (s1.length() == 0) {
            return s2.length();
        }
        if (s2.length() == 0) {
            return s1.length();
        }
        int s1len = s1.length();
        int[] matrix = new int[(s1len + 1) * (s2.length() + 1)];
        for (int col = 0; col <= s2.length(); ++col) {
            matrix[col * s1len] = col;
        }
        for (int row = 0; row <= s1len; ++row) {
            matrix[row] = row;
        }
        for (int ix1 = 0; ix1 < s1len; ++ix1) {
            char ch1 = s1.charAt(ix1);
            for (int ix2 = 0; ix2 < s2.length(); ++ix2) {
                int cost = ch1 == s2.charAt(ix2) ? 0 : 1;
                int left = matrix[ix1 + (ix2 + 1) * s1len] + 1;
                int above = matrix[ix1 + 1 + ix2 * s1len] + 1;
                int aboveleft = matrix[ix1 + ix2 * s1len] + cost;
                matrix[ix1 + 1 + (ix2 + 1) * s1len] = Math.min(left, Math.min(above, aboveleft));
            }
        }
        return matrix[s1len + s2.length() * s1len];
    }

    public static int compactDistance(String s1, String s2) {
        if (s1.length() == 0) {
            return s2.length();
        }
        if (s2.length() == 0) {
            return s1.length();
        }
        int maxdist = Math.min(s1.length(), s2.length()) / 2;
        int s1len = s1.length();
        int[] column = new int[s1len + 1];
        int ix2 = 0;
        char ch2 = s2.charAt(ix2);
        column[0] = 1;
        for (int ix1 = 1; ix1 <= s1len; ++ix1) {
            int cost = s1.charAt(ix1 - 1) == ch2 ? 0 : 1;
            column[ix1] = Math.min(column[ix1 - 1], ix1 - 1) + cost;
        }
        int above = 0;
        for (ix2 = 1; ix2 < s2.length(); ++ix2) {
            ch2 = s2.charAt(ix2);
            above = ix2 + 1;
            int smallest = s1len * 2;
            for (int ix1 = 1; ix1 <= s1len; ++ix1) {
                int cost = s1.charAt(ix1 - 1) == ch2 ? 0 : 1;
                int value = Math.min(Math.min(above, column[ix1 - 1]), column[ix1]) + cost;
                column[ix1 - 1] = above;
                above = value;
                smallest = Math.min(smallest, value);
            }
            column[s1len] = above;
            if (smallest <= maxdist) continue;
            return smallest;
        }
        return above;
    }
}

