/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import no.priv.garshol.duke.EquivalenceClassDatabase;

public class InMemoryClassDatabase
implements EquivalenceClassDatabase {
    private Map<String, Integer> recordix = new HashMap<String, Integer>();
    private Map<Integer, Collection<String>> classix = new HashMap<Integer, Collection<String>>();
    private int nextid;

    @Override
    public int getClassCount() {
        return this.classix.size();
    }

    @Override
    public Iterator<Collection<String>> getClasses() {
        return this.classix.values().iterator();
    }

    @Override
    public Collection<String> getClass(String id) {
        Integer cid = this.recordix.get(id);
        if (cid == null) {
            return Collections.EMPTY_SET;
        }
        return this.classix.get(cid);
    }

    @Override
    public void addLink(String id1, String id2) {
        Integer cid1 = this.recordix.get(id1);
        Integer cid2 = this.recordix.get(id2);
        if (cid1 == null && cid2 == null) {
            Integer cid = this.nextid++;
            ArrayList<String> klass = new ArrayList<String>();
            klass.add(id1);
            klass.add(id2);
            this.classix.put(cid, klass);
            this.recordix.put(id1, cid);
            this.recordix.put(id2, cid);
        } else if (cid1 == null || cid2 == null) {
            Integer cid = cid1;
            String id = id2;
            if (cid == null) {
                cid = cid2;
                id = id1;
            }
            Collection<String> klass = this.classix.get(cid);
            klass.add(id);
            this.recordix.put(id, cid);
        } else {
            if (cid1.equals(cid2)) {
                return;
            }
            this.merge(cid1, cid2);
        }
    }

    @Override
    public void commit() {
    }

    private void merge(Integer cid1, Integer cid2) {
        Collection<String> klass1 = this.classix.get(cid1);
        Collection<String> klass2 = this.classix.get(cid2);
        if (klass1.size() < klass2.size()) {
            Collection<String> tmp = klass2;
            klass2 = klass1;
            klass1 = tmp;
            Integer itmp = cid2;
            cid2 = cid1;
            cid1 = itmp;
        }
        for (String id : klass2) {
            klass1.add(id);
            this.recordix.put(id, cid1);
        }
        this.classix.remove(cid2);
    }
}

