from typing import List, Optional

from peltak.commands import click, root_cli, verbose_option


# TODO: Add date filter.
#  It should be possible to only search for todos that are newer than <data>.
#  It should accept '2020-01-15', '2020-01' and '2020'
# TODO: Add granular definition for git files checked
#  Allow passing --staged `--unstaged`, `--changed`, (staged + unstaged), `--untracked` to
#  define which git files should be checked
# TODO: Support passing directory via --file argument
#  Should check all files in the given directory.
@root_cli.command('todos')
@click.option('-u', '--untracked', is_flag=True, default=False)
@click.option('-a', '--author', 'authors', type=str, multiple=True, default=None)
@click.option('--verify-complete', is_flag=True, default=False)
@click.option(
    '-f', '--file', 'file_path',
    type=click.Path(exists=True, dir_okay=False, file_okay=True),
    default=None,
)
@verbose_option
def todos(
    untracked: bool,
    file_path: Optional[str],
    authors: List[str],
    verify_complete: bool,
) -> None:
    from . import logic

    logic.check_todos(untracked, file_path, authors, verify_complete)
