"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Wordpress = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const application_1 = require("./application");
const database_1 = require("./database");
const efs_volume_1 = require("./efs-volume");
class Wordpress extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d, _e;
        super(scope, id);
        const staticContentDomainName = `static.${props.domainName}`;
        const subjectAlternativeNames = (_b = props.subjectAlternativeNames) !== null && _b !== void 0 ? _b : [];
        if (props.offloadStaticContent) {
            subjectAlternativeNames.push(staticContentDomainName);
        }
        const certificate = new aws_cdk_lib_1.aws_certificatemanager.DnsValidatedCertificate(this, 'Certificate', {
            domainName: props.domainName,
            hostedZone: props.domainZone,
            subjectAlternativeNames,
            region: 'us-east-1',
        });
        const vpc = (_c = props.vpc) !== null && _c !== void 0 ? _c : new aws_cdk_lib_1.aws_ec2.Vpc(this, 'Vpc', {
            maxAzs: 2,
        });
        this.volume = (_d = props.volume) !== null && _d !== void 0 ? _d : new efs_volume_1.EfsVolume(this, 'Volume', {
            vpc,
            removalPolicy: props.removalPolicy,
        });
        this.database = (_e = props.database) !== null && _e !== void 0 ? _e : new database_1.Database(this, 'Database', {
            vpc,
            removalPolicy: props.removalPolicy,
        });
        this.application = new application_1.Application(this, 'Application', {
            domainName: props.domainName,
            domainZone: props.domainZone,
            certificate,
            vpc,
            volume: this.volume,
            database: this.database,
            image: props.image,
            serviceName: props.serviceName,
            memoryLimitMiB: props.memoryLimitMiB,
            environment: props.environment,
            secrets: props.secrets,
            logDriver: props.logDriver,
            cloudFrontHashHeader: props.cloudFrontHashHeader,
            removalPolicy: props.removalPolicy,
        });
        this.database.allowDefaultPortFrom(this.application.service);
        this.volume.allowDefaultPortFrom(this.application.service);
        if (props.offloadStaticContent) {
            this.staticContentOffload = this.application.enableStaticContentOffload(staticContentDomainName, certificate);
        }
        if (props.backupPlan) {
            if (props.removalPolicy) {
                props.backupPlan.applyRemovalPolicy(props.removalPolicy);
            }
            props.backupPlan.addSelection('BackupPlanSelection', {
                resources: [aws_cdk_lib_1.aws_backup.BackupResource.fromConstruct(this)],
            });
        }
    }
}
exports.Wordpress = Wordpress;
_a = JSII_RTTI_SYMBOL_1;
Wordpress[_a] = { fqn: "@cloudcomponents/cdk-wordpress.Wordpress", version: "2.0.0" };
//# sourceMappingURL=data:application/json;base64,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