import { RemovalPolicy, aws_backup, aws_ec2, aws_ecs, aws_route53 } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { Application, StaticContentOffload } from './application';
import { Database } from './database';
import { EfsVolume } from './efs-volume';
export interface WordpressProps {
    readonly domainName: string;
    readonly domainZone: aws_route53.IHostedZone;
    readonly subjectAlternativeNames?: string[];
    readonly vpc?: aws_ec2.IVpc;
    readonly volume?: EfsVolume;
    readonly database?: Database;
    readonly image?: aws_ecs.ContainerImage;
    readonly environment?: Record<string, string>;
    readonly secrets?: Record<string, aws_ecs.Secret>;
    readonly serviceName?: string;
    readonly memoryLimitMiB?: number;
    readonly logDriver?: aws_ecs.LogDriver;
    readonly backupPlan?: aws_backup.BackupPlan;
    readonly cloudFrontHashHeader?: string;
    readonly offloadStaticContent?: boolean;
    readonly removalPolicy?: RemovalPolicy;
}
export declare class Wordpress extends Construct {
    readonly application: Application;
    readonly database: Database;
    readonly volume: EfsVolume;
    readonly staticContentOffload?: StaticContentOffload;
    constructor(scope: Construct, id: string, props: WordpressProps);
}
