"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EfsVolume = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class EfsVolume extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        this.fileSystem = new aws_cdk_lib_1.aws_efs.FileSystem(this, 'FileSystem', {
            vpc: props.vpc,
            performanceMode: aws_cdk_lib_1.aws_efs.PerformanceMode.GENERAL_PURPOSE,
            lifecyclePolicy: aws_cdk_lib_1.aws_efs.LifecyclePolicy.AFTER_30_DAYS,
            throughputMode: aws_cdk_lib_1.aws_efs.ThroughputMode.BURSTING,
            encrypted: true,
            removalPolicy: props.removalPolicy,
        });
        const fileSystemAccessPoint = this.fileSystem.addAccessPoint('AccessPoint');
        this.name = (_b = props.name) !== null && _b !== void 0 ? _b : 'efs';
        this.efsVolumeConfiguration = {
            fileSystemId: this.fileSystem.fileSystemId,
            transitEncryption: 'ENABLED',
            authorizationConfig: {
                accessPointId: fileSystemAccessPoint.accessPointId,
            },
        };
    }
    allowDefaultPortFrom(other, description) {
        this.fileSystem.connections.allowDefaultPortFrom(other, description);
    }
}
exports.EfsVolume = EfsVolume;
_a = JSII_RTTI_SYMBOL_1;
EfsVolume[_a] = { fqn: "@cloudcomponents/cdk-wordpress.EfsVolume", version: "2.0.0" };
//# sourceMappingURL=data:application/json;base64,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