import { RemovalPolicy, aws_ec2, aws_ecs } from 'aws-cdk-lib';
import { Construct } from 'constructs';
export interface EfsVolumeProps {
    readonly vpc: aws_ec2.IVpc;
    readonly name?: string;
    readonly removalPolicy?: RemovalPolicy;
}
export declare class EfsVolume extends Construct {
    readonly name: string;
    readonly efsVolumeConfiguration: aws_ecs.EfsVolumeConfiguration;
    private readonly fileSystem;
    constructor(scope: Construct, id: string, props: EfsVolumeProps);
    allowDefaultPortFrom(other: aws_ec2.IConnectable, description?: string): void;
}
