"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Database = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class Database extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d, _e;
        super(scope, id);
        const databaseName = (_b = props.databaseName) !== null && _b !== void 0 ? _b : 'wordpress';
        this.instance = new aws_cdk_lib_1.aws_rds.DatabaseInstance(this, 'Database', {
            databaseName,
            vpc: props.vpc,
            engine: (_c = props.engine) !== null && _c !== void 0 ? _c : aws_cdk_lib_1.aws_rds.DatabaseInstanceEngine.mariaDb({
                version: aws_cdk_lib_1.aws_rds.MariaDbEngineVersion.VER_10_5,
            }),
            allocatedStorage: (_d = props.allocatedStorage) !== null && _d !== void 0 ? _d : 10,
            instanceType: (_e = props.instanceType) !== null && _e !== void 0 ? _e : aws_cdk_lib_1.aws_ec2.InstanceType.of(aws_cdk_lib_1.aws_ec2.InstanceClass.BURSTABLE3, aws_cdk_lib_1.aws_ec2.InstanceSize.MICRO),
            deleteAutomatedBackups: props.removalPolicy === aws_cdk_lib_1.RemovalPolicy.DESTROY,
            removalPolicy: props.removalPolicy,
        });
        this.environment = {
            WORDPRESS_DB_NAME: databaseName,
        };
        this.secrets = {
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            WORDPRESS_DB_HOST: aws_cdk_lib_1.aws_ecs.Secret.fromSecretsManager(this.instance.secret, 'host'),
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            WORDPRESS_DB_USER: aws_cdk_lib_1.aws_ecs.Secret.fromSecretsManager(this.instance.secret, 'username'),
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            WORDPRESS_DB_PASSWORD: aws_cdk_lib_1.aws_ecs.Secret.fromSecretsManager(this.instance.secret, 'password'),
        };
    }
    allowDefaultPortFrom(other, description) {
        this.instance.connections.allowDefaultPortFrom(other, description);
    }
}
exports.Database = Database;
_a = JSII_RTTI_SYMBOL_1;
Database[_a] = { fqn: "@cloudcomponents/cdk-wordpress.Database", version: "2.0.0" };
//# sourceMappingURL=data:application/json;base64,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