import { RemovalPolicy, aws_ec2, aws_ecs, aws_rds } from 'aws-cdk-lib';
import { Construct } from 'constructs';
export interface DatabaseProps {
    readonly vpc: aws_ec2.IVpc;
    readonly databaseName?: string;
    readonly engine?: aws_rds.IInstanceEngine;
    readonly allocatedStorage?: number;
    readonly instanceType?: aws_ec2.InstanceType;
    readonly removalPolicy?: RemovalPolicy;
}
export declare class Database extends Construct {
    readonly environment: Record<string, string>;
    readonly secrets: Record<string, aws_ecs.Secret>;
    private readonly instance;
    constructor(scope: Construct, id: string, props: DatabaseProps);
    allowDefaultPortFrom(other: aws_ec2.IConnectable, description?: string): void;
}
