import { RemovalPolicy, aws_certificatemanager, aws_cloudfront, aws_ec2, aws_ecs, aws_elasticloadbalancingv2, aws_route53 } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { Database } from './database';
import { EfsVolume } from './efs-volume';
export interface ApplicationProps {
    readonly domainName: string;
    readonly domainZone: aws_route53.IHostedZone;
    readonly certificate: aws_certificatemanager.ICertificate;
    readonly vpc: aws_ec2.IVpc;
    readonly volume: EfsVolume;
    readonly database: Database;
    readonly image?: aws_ecs.ContainerImage;
    readonly serviceName?: string;
    readonly memoryLimitMiB?: number;
    readonly environment?: Record<string, string>;
    readonly secrets?: Record<string, aws_ecs.Secret>;
    readonly logDriver?: aws_ecs.LogDriver;
    readonly cloudFrontHashHeader?: string;
    readonly removalPolicy?: RemovalPolicy;
}
export interface StaticContentOffload {
    readonly domainName: string;
    readonly distribution: aws_cloudfront.IDistribution;
}
export declare class Application extends Construct {
    readonly domainName: string;
    readonly domainZone: aws_route53.IHostedZone;
    readonly distribution: aws_cloudfront.IDistribution;
    readonly service: aws_ecs.FargateService;
    readonly targetGroup: aws_elasticloadbalancingv2.ApplicationTargetGroup;
    readonly listener: aws_elasticloadbalancingv2.ApplicationListener;
    private readonly cloudFrontHashHeader;
    private readonly removalPolicy?;
    constructor(scope: Construct, id: string, props: ApplicationProps);
    enableStaticContentOffload(domainName: string, certificate: aws_certificatemanager.ICertificate): StaticContentOffload;
}
