#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# Generated Fri Feb  9 14:26:18 2018 by generateDS.py version 2.29.6.
# Python 2.7.14 (default, Sep 27 2017, 12:15:00)  [GCC 4.2.1 Compatible Apple LLVM 9.0.0 (clang-900.0.37)]
#
# Command line options:
#   ('-o', 'oadr_20b.py')
#
# Command line arguments:
#   oadr_20b.xsd
#
# Command line:
#   /Users/robcalvert/repos/volttron/env/bin/generateds -o "oadr_20b.py" oadr_20b.xsd
#
# Current working directory (os.getcwd()):
#   oadr20b_schema
#
import base64
import datetime as datetime_
import re as re_
import sys
import warnings as warnings_

try:
    from lxml import etree as etree_
except ImportError:
    from xml.etree import ElementTree as etree_


Validate_simpletypes_ = True
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc


def parsexmlstring_(instring, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    element = etree_.fromstring(instring, parser=parser, **kwargs)
    return element


#
# Namespace prefix definition table (and other attributes, too)
#
# The module generatedsnamespaces, if it is importable, must contain
# a dictionary named GeneratedsNamespaceDefs.  This Python dictionary
# should map element type names (strings) to XML schema namespace prefix
# definitions.  The export method for any class for which there is
# a namespace prefix definition, will export that definition in the
# XML representation of that element.  See the export method of
# any generated element type class for a example of the use of this
# table.
# A sample table is:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceDefs = {
#         "ElementtypeA": "http://www.xxx.com/namespaceA",
#         "ElementtypeB": "http://www.xxx.com/namespaceB",
#     }
#

try:
    from generatedsnamespaces import GenerateDSNamespaceDefs as GenerateDSNamespaceDefs_
except ImportError:
    GenerateDSNamespaceDefs_ = {}

#
# The root super-class for element type classes
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r"(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$")

        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name

            def utcoffset(self, dt):
                return self.__offset

            def tzname(self, dt):
                return self.__name

            def dst(self, dt):
                return None

        def gds_format_string(self, input_data, input_name=""):
            return input_data

        def gds_validate_string(self, input_data, node=None, input_name=""):
            if not input_data:
                return ""
            else:
                return input_data

        def gds_format_base64(self, input_data, input_name=""):
            return base64.b64encode(input_data)

        def gds_validate_base64(self, input_data, node=None, input_name=""):
            return input_data

        def gds_format_integer(self, input_data, input_name=""):
            return "%d" % input_data

        def gds_validate_integer(self, input_data, node=None, input_name=""):
            return input_data

        def gds_format_integer_list(self, input_data, input_name=""):
            return "%s" % " ".join(input_data)

        def gds_validate_integer_list(self, input_data, node=None, input_name=""):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, "Requires sequence of integers")
            return values

        def gds_format_float(self, input_data, input_name=""):
            return ("%.15f" % input_data).rstrip("0")

        def gds_validate_float(self, input_data, node=None, input_name=""):
            return input_data

        def gds_format_float_list(self, input_data, input_name=""):
            return "%s" % " ".join(input_data)

        def gds_validate_float_list(self, input_data, node=None, input_name=""):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, "Requires sequence of floats")
            return values

        def gds_format_double(self, input_data, input_name=""):
            return "%e" % input_data

        def gds_validate_double(self, input_data, node=None, input_name=""):
            return input_data

        def gds_format_double_list(self, input_data, input_name=""):
            return "%s" % " ".join(input_data)

        def gds_validate_double_list(self, input_data, node=None, input_name=""):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, "Requires sequence of doubles")
            return values

        def gds_format_boolean(self, input_data, input_name=""):
            return ("%s" % input_data).lower()

        def gds_validate_boolean(self, input_data, node=None, input_name=""):
            return input_data

        def gds_format_boolean_list(self, input_data, input_name=""):
            return "%s" % " ".join(input_data)

        def gds_validate_boolean_list(self, input_data, node=None, input_name=""):
            values = input_data.split()
            for value in values:
                if value not in ("true", "1", "false", "0"):
                    raise_parse_error(
                        node,
                        "Requires sequence of booleans " '("true", "1", "false", "0")',
                    )
            return values

        def gds_validate_datetime(self, input_data, node=None, input_name=""):
            return input_data

        def gds_format_datetime(self, input_data, input_name=""):
            if input_data.microsecond == 0:
                _svalue = "%04d-%02d-%02dT%02d:%02d:%02d" % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = "%04d-%02d-%02dT%02d:%02d:%02d.%s" % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ("%f" % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += "Z"
                    else:
                        if total_seconds < 0:
                            _svalue += "-"
                            total_seconds *= -1
                        else:
                            _svalue += "+"
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += "{0:02d}:{1:02d}".format(hours, minutes)
            return _svalue

        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == "Z":
                tz = GeneratedsSuper._FixedOffsetTZ(0, "UTC")
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(":")
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == "-":
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split(".")
            if len(time_parts) > 1:
                micro_seconds = int(float("0." + time_parts[1]) * 1000000)
                input_data = "%s.%s" % (time_parts[0], micro_seconds)
                dt = datetime_.datetime.strptime(input_data, "%Y-%m-%dT%H:%M:%S.%f")
            else:
                dt = datetime_.datetime.strptime(input_data, "%Y-%m-%dT%H:%M:%S")
            dt = dt.replace(tzinfo=tz)
            return dt

        def gds_validate_date(self, input_data, node=None, input_name=""):
            return input_data

        def gds_format_date(self, input_data, input_name=""):
            _svalue = "%04d-%02d-%02d" % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += "Z"
                        else:
                            if total_seconds < 0:
                                _svalue += "-"
                                total_seconds *= -1
                            else:
                                _svalue += "+"
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += "{0:02d}:{1:02d}".format(hours, minutes)
            except AttributeError:
                pass
            return _svalue

        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == "Z":
                tz = GeneratedsSuper._FixedOffsetTZ(0, "UTC")
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(":")
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == "-":
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, "%Y-%m-%d")
            dt = dt.replace(tzinfo=tz)
            return dt.date()

        def gds_validate_time(self, input_data, node=None, input_name=""):
            return input_data

        def gds_format_time(self, input_data, input_name=""):
            if input_data.microsecond == 0:
                _svalue = "%02d:%02d:%02d" % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = "%02d:%02d:%02d.%s" % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ("%f" % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += "Z"
                    else:
                        if total_seconds < 0:
                            _svalue += "-"
                            total_seconds *= -1
                        else:
                            _svalue += "+"
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += "{0:02d}:{1:02d}".format(hours, minutes)
            return _svalue

        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.  We should:
            # - AND the outer elements
            # - OR the inner elements
            found1 = True
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    if re_.search(patterns2, target) is not None:
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1

        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == "Z":
                tz = GeneratedsSuper._FixedOffsetTZ(0, "UTC")
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(":")
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == "-":
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split(".")) > 1:
                dt = datetime_.datetime.strptime(input_data, "%H:%M:%S.%f")
            else:
                dt = datetime_.datetime.strptime(input_data, "%H:%M:%S")
            dt = dt.replace(tzinfo=tz)
            return dt.time()

        def gds_str_lower(self, instring):
            return instring.lower()

        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = "/".join(path_list)
            return path

        Tag_strip_pattern_ = re_.compile(r"\{.*\}")

        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub("", node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)

        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if "xsi" in node.nsmap:
                classname = node.get("{%s}type" % node.nsmap["xsi"])
                if classname is not None:
                    names = classname.split(":")
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1

        def gds_build_any(self, node, type_name=None):
            return None

        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.iteritems()))

        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                return instring.encode(ExternalEncoding)
            else:
                return instring

        @staticmethod
        def convert_unicode(instring):
            if isinstance(instring, str):
                result = quote_xml(instring)
            elif sys.version_info.major == 2 and isinstance(instring, unicode):
                result = quote_xml(instring).encode("utf8")
            else:
                result = GeneratedsSuper.gds_encode(str(instring))
            return result

        def __eq__(self, other):
            if type(self) != type(other):
                return False
            return self.__dict__ == other.__dict__

        def __ne__(self, other):
            return not self.__eq__(other)

    def getSubclassFromModule_(module, class_):
        """Get the subclass of a class from a specific module."""
        name = class_.__name__ + "Sub"
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = "ascii"
Tag_pattern_ = re_.compile(r"({.*})?(.*)")
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r"{(.*)}(.*)")
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write("    ")


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ""
    s1 = isinstance(inStr, BaseStrType_) and inStr or "%s" % inStr
    s2 = ""
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos : mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start() : mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace("&", "&amp;")
    s1 = s1.replace("<", "&lt;")
    s1 = s1.replace(">", "&gt;")
    return s1


def quote_attrib(inStr):
    s1 = isinstance(inStr, BaseStrType_) and inStr or "%s" % inStr
    s1 = s1.replace("&", "&amp;")
    s1 = s1.replace("<", "&lt;")
    s1 = s1.replace(">", "&gt;")
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find("\n") == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find("\n") == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ""
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(":")
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get("{%s}%s" % (namespace, name))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    msg = "%s (element %s/line %d)" % (msg, node.tag, node.sourceline)
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8

    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value

    def getCategory(self):
        return self.category

    def getContenttype(self, content_type):
        return self.content_type

    def getValue(self):
        return self.value

    def getName(self):
        return self.name

    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:  # category == MixedContainer.CategoryComplex
            self.value.export(
                outfile, level, namespace, name, pretty_print=pretty_print
            )

    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write("<%s>%s</%s>" % (self.name, self.value, self.name))
        elif (
            self.content_type == MixedContainer.TypeInteger
            or self.content_type == MixedContainer.TypeBoolean
        ):
            outfile.write("<%s>%d</%s>" % (self.name, self.value, self.name))
        elif (
            self.content_type == MixedContainer.TypeFloat
            or self.content_type == MixedContainer.TypeDecimal
        ):
            outfile.write("<%s>%f</%s>" % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write("<%s>%g</%s>" % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write(
                "<%s>%s</%s>" % (self.name, base64.b64encode(self.value), self.name)
            )

    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, "%s" % self.name)
            subelement.text = self.to_etree_simple()
        else:  # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)

    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (
            self.content_type == MixedContainer.TypeInteger
            or self.content_type == MixedContainer.TypeBoolean
        ):
            text = "%d" % self.value
        elif (
            self.content_type == MixedContainer.TypeFloat
            or self.content_type == MixedContainer.TypeDecimal
        ):
            text = "%f" % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = "%g" % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = "%s" % base64.b64encode(self.value)
        return text

    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value)
            )
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value)
            )
        else:  # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n'
                % (self.category, self.content_type, self.name)
            )
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(")\n")


class MemberSpec_(object):
    def __init__(
        self,
        name="",
        data_type="",
        container=0,
        optional=0,
        child_attrs=None,
        choice=None,
    ):
        self.name = name
        self.data_type = data_type
        self.container = container
        self.child_attrs = child_attrs
        self.choice = choice
        self.optional = optional

    def set_name(self, name):
        self.name = name

    def get_name(self):
        return self.name

    def set_data_type(self, data_type):
        self.data_type = data_type

    def get_data_type_chain(self):
        return self.data_type

    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return "xs:string"
        else:
            return self.data_type

    def set_container(self, container):
        self.container = container

    def get_container(self):
        return self.container

    def set_child_attrs(self, child_attrs):
        self.child_attrs = child_attrs

    def get_child_attrs(self):
        return self.child_attrs

    def set_choice(self, choice):
        self.choice = choice

    def get_choice(self):
        return self.choice

    def set_optional(self, optional):
        self.optional = optional

    def get_optional(self):
        return self.optional


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)


#
# Data representation classes.
#


class oadrPayload(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, Signature=None, oadrSignedObject=None):
        self.original_tagname_ = None
        self.Signature = Signature
        self.oadrSignedObject = oadrSignedObject

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, oadrPayload)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrPayload.subclass:
            return oadrPayload.subclass(*args_, **kwargs_)
        else:
            return oadrPayload(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Signature(self):
        return self.Signature

    def set_Signature(self, Signature):
        self.Signature = Signature

    def get_oadrSignedObject(self):
        return self.oadrSignedObject

    def set_oadrSignedObject(self, oadrSignedObject):
        self.oadrSignedObject = oadrSignedObject

    def hasContent_(self):
        if self.Signature is not None or self.oadrSignedObject is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrPayload",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrPayload")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="oadrPayload"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrPayload",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="oadr:", name_="oadrPayload"
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrPayload",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.Signature is not None:
            self.Signature.export(
                outfile,
                level,
                namespace_="ds:",
                name_="Signature",
                pretty_print=pretty_print,
            )
        if self.oadrSignedObject is not None:
            self.oadrSignedObject.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrSignedObject",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "Signature":
            obj_ = SignatureType.factory()
            obj_.build(child_)
            self.Signature = obj_
            obj_.original_tagname_ = "Signature"
        elif nodeName_ == "oadrSignedObject":
            obj_ = oadrSignedObject.factory()
            obj_.build(child_)
            self.oadrSignedObject = obj_
            obj_.original_tagname_ = "oadrSignedObject"


# end class oadrPayload


class oadrSignedObject(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self,
        Id=None,
        oadrDistributeEvent=None,
        oadrCreatedEvent=None,
        oadrRequestEvent=None,
        oadrResponse=None,
        oadrCancelOpt=None,
        oadrCanceledOpt=None,
        oadrCreateOpt=None,
        oadrCreatedOpt=None,
        oadrCancelReport=None,
        oadrCanceledReport=None,
        oadrCreateReport=None,
        oadrCreatedReport=None,
        oadrRegisterReport=None,
        oadrRegisteredReport=None,
        oadrUpdateReport=None,
        oadrUpdatedReport=None,
        oadrCancelPartyRegistration=None,
        oadrCanceledPartyRegistration=None,
        oadrCreatePartyRegistration=None,
        oadrCreatedPartyRegistration=None,
        oadrRequestReregistration=None,
        oadrQueryRegistration=None,
        oadrPoll=None,
    ):
        self.original_tagname_ = None
        self.Id = _cast(None, Id)
        self.oadrDistributeEvent = oadrDistributeEvent
        self.oadrCreatedEvent = oadrCreatedEvent
        self.oadrRequestEvent = oadrRequestEvent
        self.oadrResponse = oadrResponse
        self.oadrCancelOpt = oadrCancelOpt
        self.oadrCanceledOpt = oadrCanceledOpt
        self.oadrCreateOpt = oadrCreateOpt
        self.oadrCreatedOpt = oadrCreatedOpt
        self.oadrCancelReport = oadrCancelReport
        self.oadrCanceledReport = oadrCanceledReport
        self.oadrCreateReport = oadrCreateReport
        self.oadrCreatedReport = oadrCreatedReport
        self.oadrRegisterReport = oadrRegisterReport
        self.oadrRegisteredReport = oadrRegisteredReport
        self.oadrUpdateReport = oadrUpdateReport
        self.oadrUpdatedReport = oadrUpdatedReport
        self.oadrCancelPartyRegistration = oadrCancelPartyRegistration
        self.oadrCanceledPartyRegistration = oadrCanceledPartyRegistration
        self.oadrCreatePartyRegistration = oadrCreatePartyRegistration
        self.oadrCreatedPartyRegistration = oadrCreatedPartyRegistration
        self.oadrRequestReregistration = oadrRequestReregistration
        self.oadrQueryRegistration = oadrQueryRegistration
        self.oadrPoll = oadrPoll

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, oadrSignedObject)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrSignedObject.subclass:
            return oadrSignedObject.subclass(*args_, **kwargs_)
        else:
            return oadrSignedObject(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_oadrDistributeEvent(self):
        return self.oadrDistributeEvent

    def set_oadrDistributeEvent(self, oadrDistributeEvent):
        self.oadrDistributeEvent = oadrDistributeEvent

    def get_oadrCreatedEvent(self):
        return self.oadrCreatedEvent

    def set_oadrCreatedEvent(self, oadrCreatedEvent):
        self.oadrCreatedEvent = oadrCreatedEvent

    def get_oadrRequestEvent(self):
        return self.oadrRequestEvent

    def set_oadrRequestEvent(self, oadrRequestEvent):
        self.oadrRequestEvent = oadrRequestEvent

    def get_oadrResponse(self):
        return self.oadrResponse

    def set_oadrResponse(self, oadrResponse):
        self.oadrResponse = oadrResponse

    def get_oadrCancelOpt(self):
        return self.oadrCancelOpt

    def set_oadrCancelOpt(self, oadrCancelOpt):
        self.oadrCancelOpt = oadrCancelOpt

    def get_oadrCanceledOpt(self):
        return self.oadrCanceledOpt

    def set_oadrCanceledOpt(self, oadrCanceledOpt):
        self.oadrCanceledOpt = oadrCanceledOpt

    def get_oadrCreateOpt(self):
        return self.oadrCreateOpt

    def set_oadrCreateOpt(self, oadrCreateOpt):
        self.oadrCreateOpt = oadrCreateOpt

    def get_oadrCreatedOpt(self):
        return self.oadrCreatedOpt

    def set_oadrCreatedOpt(self, oadrCreatedOpt):
        self.oadrCreatedOpt = oadrCreatedOpt

    def get_oadrCancelReport(self):
        return self.oadrCancelReport

    def set_oadrCancelReport(self, oadrCancelReport):
        self.oadrCancelReport = oadrCancelReport

    def get_oadrCanceledReport(self):
        return self.oadrCanceledReport

    def set_oadrCanceledReport(self, oadrCanceledReport):
        self.oadrCanceledReport = oadrCanceledReport

    def get_oadrCreateReport(self):
        return self.oadrCreateReport

    def set_oadrCreateReport(self, oadrCreateReport):
        self.oadrCreateReport = oadrCreateReport

    def get_oadrCreatedReport(self):
        return self.oadrCreatedReport

    def set_oadrCreatedReport(self, oadrCreatedReport):
        self.oadrCreatedReport = oadrCreatedReport

    def get_oadrRegisterReport(self):
        return self.oadrRegisterReport

    def set_oadrRegisterReport(self, oadrRegisterReport):
        self.oadrRegisterReport = oadrRegisterReport

    def get_oadrRegisteredReport(self):
        return self.oadrRegisteredReport

    def set_oadrRegisteredReport(self, oadrRegisteredReport):
        self.oadrRegisteredReport = oadrRegisteredReport

    def get_oadrUpdateReport(self):
        return self.oadrUpdateReport

    def set_oadrUpdateReport(self, oadrUpdateReport):
        self.oadrUpdateReport = oadrUpdateReport

    def get_oadrUpdatedReport(self):
        return self.oadrUpdatedReport

    def set_oadrUpdatedReport(self, oadrUpdatedReport):
        self.oadrUpdatedReport = oadrUpdatedReport

    def get_oadrCancelPartyRegistration(self):
        return self.oadrCancelPartyRegistration

    def set_oadrCancelPartyRegistration(self, oadrCancelPartyRegistration):
        self.oadrCancelPartyRegistration = oadrCancelPartyRegistration

    def get_oadrCanceledPartyRegistration(self):
        return self.oadrCanceledPartyRegistration

    def set_oadrCanceledPartyRegistration(self, oadrCanceledPartyRegistration):
        self.oadrCanceledPartyRegistration = oadrCanceledPartyRegistration

    def get_oadrCreatePartyRegistration(self):
        return self.oadrCreatePartyRegistration

    def set_oadrCreatePartyRegistration(self, oadrCreatePartyRegistration):
        self.oadrCreatePartyRegistration = oadrCreatePartyRegistration

    def get_oadrCreatedPartyRegistration(self):
        return self.oadrCreatedPartyRegistration

    def set_oadrCreatedPartyRegistration(self, oadrCreatedPartyRegistration):
        self.oadrCreatedPartyRegistration = oadrCreatedPartyRegistration

    def get_oadrRequestReregistration(self):
        return self.oadrRequestReregistration

    def set_oadrRequestReregistration(self, oadrRequestReregistration):
        self.oadrRequestReregistration = oadrRequestReregistration

    def get_oadrQueryRegistration(self):
        return self.oadrQueryRegistration

    def set_oadrQueryRegistration(self, oadrQueryRegistration):
        self.oadrQueryRegistration = oadrQueryRegistration

    def get_oadrPoll(self):
        return self.oadrPoll

    def set_oadrPoll(self, oadrPoll):
        self.oadrPoll = oadrPoll

    def get_Id(self):
        return self.Id

    def set_Id(self, Id):
        self.Id = Id

    def hasContent_(self):
        if (
            self.oadrDistributeEvent is not None
            or self.oadrCreatedEvent is not None
            or self.oadrRequestEvent is not None
            or self.oadrResponse is not None
            or self.oadrCancelOpt is not None
            or self.oadrCanceledOpt is not None
            or self.oadrCreateOpt is not None
            or self.oadrCreatedOpt is not None
            or self.oadrCancelReport is not None
            or self.oadrCanceledReport is not None
            or self.oadrCreateReport is not None
            or self.oadrCreatedReport is not None
            or self.oadrRegisterReport is not None
            or self.oadrRegisteredReport is not None
            or self.oadrUpdateReport is not None
            or self.oadrUpdatedReport is not None
            or self.oadrCancelPartyRegistration is not None
            or self.oadrCanceledPartyRegistration is not None
            or self.oadrCreatePartyRegistration is not None
            or self.oadrCreatedPartyRegistration is not None
            or self.oadrRequestReregistration is not None
            or self.oadrQueryRegistration is not None
            or self.oadrPoll is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrSignedObject",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrSignedObject")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="oadrSignedObject"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrSignedObject",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrSignedObject",
    ):
        if self.Id is not None and "Id" not in already_processed:
            already_processed.add("Id")
            outfile.write(
                " Id=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_attrib(self.Id), input_name="Id")
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrSignedObject",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.oadrDistributeEvent is not None:
            self.oadrDistributeEvent.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrDistributeEvent",
                pretty_print=pretty_print,
            )
        if self.oadrCreatedEvent is not None:
            self.oadrCreatedEvent.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrCreatedEvent",
                pretty_print=pretty_print,
            )
        if self.oadrRequestEvent is not None:
            self.oadrRequestEvent.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrRequestEvent",
                pretty_print=pretty_print,
            )
        if self.oadrResponse is not None:
            self.oadrResponse.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrResponse",
                pretty_print=pretty_print,
            )
        if self.oadrCancelOpt is not None:
            self.oadrCancelOpt.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrCancelOpt",
                pretty_print=pretty_print,
            )
        if self.oadrCanceledOpt is not None:
            self.oadrCanceledOpt.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrCanceledOpt",
                pretty_print=pretty_print,
            )
        if self.oadrCreateOpt is not None:
            self.oadrCreateOpt.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrCreateOpt",
                pretty_print=pretty_print,
            )
        if self.oadrCreatedOpt is not None:
            self.oadrCreatedOpt.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrCreatedOpt",
                pretty_print=pretty_print,
            )
        if self.oadrCancelReport is not None:
            self.oadrCancelReport.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrCancelReport",
                pretty_print=pretty_print,
            )
        if self.oadrCanceledReport is not None:
            self.oadrCanceledReport.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrCanceledReport",
                pretty_print=pretty_print,
            )
        if self.oadrCreateReport is not None:
            self.oadrCreateReport.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrCreateReport",
                pretty_print=pretty_print,
            )
        if self.oadrCreatedReport is not None:
            self.oadrCreatedReport.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrCreatedReport",
                pretty_print=pretty_print,
            )
        if self.oadrRegisterReport is not None:
            self.oadrRegisterReport.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrRegisterReport",
                pretty_print=pretty_print,
            )
        if self.oadrRegisteredReport is not None:
            self.oadrRegisteredReport.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrRegisteredReport",
                pretty_print=pretty_print,
            )
        if self.oadrUpdateReport is not None:
            self.oadrUpdateReport.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrUpdateReport",
                pretty_print=pretty_print,
            )
        if self.oadrUpdatedReport is not None:
            self.oadrUpdatedReport.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrUpdatedReport",
                pretty_print=pretty_print,
            )
        if self.oadrCancelPartyRegistration is not None:
            self.oadrCancelPartyRegistration.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrCancelPartyRegistration",
                pretty_print=pretty_print,
            )
        if self.oadrCanceledPartyRegistration is not None:
            self.oadrCanceledPartyRegistration.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrCanceledPartyRegistration",
                pretty_print=pretty_print,
            )
        if self.oadrCreatePartyRegistration is not None:
            self.oadrCreatePartyRegistration.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrCreatePartyRegistration",
                pretty_print=pretty_print,
            )
        if self.oadrCreatedPartyRegistration is not None:
            self.oadrCreatedPartyRegistration.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrCreatedPartyRegistration",
                pretty_print=pretty_print,
            )
        if self.oadrRequestReregistration is not None:
            self.oadrRequestReregistration.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrRequestReregistration",
                pretty_print=pretty_print,
            )
        if self.oadrQueryRegistration is not None:
            self.oadrQueryRegistration.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrQueryRegistration",
                pretty_print=pretty_print,
            )
        if self.oadrPoll is not None:
            self.oadrPoll.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrPoll",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("Id", node)
        if value is not None and "Id" not in already_processed:
            already_processed.add("Id")
            self.Id = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "oadrDistributeEvent":
            obj_ = oadrDistributeEventType.factory()
            obj_.build(child_)
            self.oadrDistributeEvent = obj_
            obj_.original_tagname_ = "oadrDistributeEvent"
        elif nodeName_ == "oadrCreatedEvent":
            obj_ = oadrCreatedEventType.factory()
            obj_.build(child_)
            self.oadrCreatedEvent = obj_
            obj_.original_tagname_ = "oadrCreatedEvent"
        elif nodeName_ == "oadrRequestEvent":
            obj_ = oadrRequestEventType.factory()
            obj_.build(child_)
            self.oadrRequestEvent = obj_
            obj_.original_tagname_ = "oadrRequestEvent"
        elif nodeName_ == "oadrResponse":
            obj_ = oadrResponseType.factory()
            obj_.build(child_)
            self.oadrResponse = obj_
            obj_.original_tagname_ = "oadrResponse"
        elif nodeName_ == "oadrCancelOpt":
            obj_ = oadrCancelOptType.factory()
            obj_.build(child_)
            self.oadrCancelOpt = obj_
            obj_.original_tagname_ = "oadrCancelOpt"
        elif nodeName_ == "oadrCanceledOpt":
            obj_ = oadrCanceledOptType.factory()
            obj_.build(child_)
            self.oadrCanceledOpt = obj_
            obj_.original_tagname_ = "oadrCanceledOpt"
        elif nodeName_ == "oadrCreateOpt":
            obj_ = oadrCreateOptType.factory()
            obj_.build(child_)
            self.oadrCreateOpt = obj_
            obj_.original_tagname_ = "oadrCreateOpt"
        elif nodeName_ == "oadrCreatedOpt":
            obj_ = oadrCreatedOptType.factory()
            obj_.build(child_)
            self.oadrCreatedOpt = obj_
            obj_.original_tagname_ = "oadrCreatedOpt"
        elif nodeName_ == "oadrCancelReport":
            obj_ = oadrCancelReportType.factory()
            obj_.build(child_)
            self.oadrCancelReport = obj_
            obj_.original_tagname_ = "oadrCancelReport"
        elif nodeName_ == "oadrCanceledReport":
            obj_ = oadrCanceledReportType.factory()
            obj_.build(child_)
            self.oadrCanceledReport = obj_
            obj_.original_tagname_ = "oadrCanceledReport"
        elif nodeName_ == "oadrCreateReport":
            obj_ = oadrCreateReportType.factory()
            obj_.build(child_)
            self.oadrCreateReport = obj_
            obj_.original_tagname_ = "oadrCreateReport"
        elif nodeName_ == "oadrCreatedReport":
            obj_ = oadrCreatedReportType.factory()
            obj_.build(child_)
            self.oadrCreatedReport = obj_
            obj_.original_tagname_ = "oadrCreatedReport"
        elif nodeName_ == "oadrRegisterReport":
            obj_ = oadrRegisterReportType.factory()
            obj_.build(child_)
            self.oadrRegisterReport = obj_
            obj_.original_tagname_ = "oadrRegisterReport"
        elif nodeName_ == "oadrRegisteredReport":
            obj_ = oadrRegisteredReportType.factory()
            obj_.build(child_)
            self.oadrRegisteredReport = obj_
            obj_.original_tagname_ = "oadrRegisteredReport"
        elif nodeName_ == "oadrUpdateReport":
            obj_ = oadrUpdateReportType.factory()
            obj_.build(child_)
            self.oadrUpdateReport = obj_
            obj_.original_tagname_ = "oadrUpdateReport"
        elif nodeName_ == "oadrUpdatedReport":
            obj_ = oadrUpdatedReportType.factory()
            obj_.build(child_)
            self.oadrUpdatedReport = obj_
            obj_.original_tagname_ = "oadrUpdatedReport"
        elif nodeName_ == "oadrCancelPartyRegistration":
            obj_ = oadrCancelPartyRegistrationType.factory()
            obj_.build(child_)
            self.oadrCancelPartyRegistration = obj_
            obj_.original_tagname_ = "oadrCancelPartyRegistration"
        elif nodeName_ == "oadrCanceledPartyRegistration":
            obj_ = oadrCanceledPartyRegistrationType.factory()
            obj_.build(child_)
            self.oadrCanceledPartyRegistration = obj_
            obj_.original_tagname_ = "oadrCanceledPartyRegistration"
        elif nodeName_ == "oadrCreatePartyRegistration":
            obj_ = oadrCreatePartyRegistrationType.factory()
            obj_.build(child_)
            self.oadrCreatePartyRegistration = obj_
            obj_.original_tagname_ = "oadrCreatePartyRegistration"
        elif nodeName_ == "oadrCreatedPartyRegistration":
            obj_ = oadrCreatedPartyRegistrationType.factory()
            obj_.build(child_)
            self.oadrCreatedPartyRegistration = obj_
            obj_.original_tagname_ = "oadrCreatedPartyRegistration"
        elif nodeName_ == "oadrRequestReregistration":
            obj_ = oadrRequestReregistrationType.factory()
            obj_.build(child_)
            self.oadrRequestReregistration = obj_
            obj_.original_tagname_ = "oadrRequestReregistration"
        elif nodeName_ == "oadrQueryRegistration":
            obj_ = oadrQueryRegistrationType.factory()
            obj_.build(child_)
            self.oadrQueryRegistration = obj_
            obj_.original_tagname_ = "oadrQueryRegistration"
        elif nodeName_ == "oadrPoll":
            obj_ = oadrPollType.factory()
            obj_.build(child_)
            self.oadrPoll = obj_
            obj_.original_tagname_ = "oadrPoll"


# end class oadrSignedObject


class oadrDistributeEventType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self,
        schemaVersion=None,
        eiResponse=None,
        requestID=None,
        vtnID=None,
        oadrEvent=None,
    ):
        self.original_tagname_ = None
        self.schemaVersion = _cast(None, schemaVersion)
        self.eiResponse = eiResponse
        self.requestID = requestID
        self.vtnID = vtnID
        if oadrEvent is None:
            self.oadrEvent = []
        else:
            self.oadrEvent = oadrEvent

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, oadrDistributeEventType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrDistributeEventType.subclass:
            return oadrDistributeEventType.subclass(*args_, **kwargs_)
        else:
            return oadrDistributeEventType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_eiResponse(self):
        return self.eiResponse

    def set_eiResponse(self, eiResponse):
        self.eiResponse = eiResponse

    def get_requestID(self):
        return self.requestID

    def set_requestID(self, requestID):
        self.requestID = requestID

    def get_vtnID(self):
        return self.vtnID

    def set_vtnID(self, vtnID):
        self.vtnID = vtnID

    def get_oadrEvent(self):
        return self.oadrEvent

    def set_oadrEvent(self, oadrEvent):
        self.oadrEvent = oadrEvent

    def add_oadrEvent(self, value):
        self.oadrEvent.append(value)

    def insert_oadrEvent_at(self, index, value):
        self.oadrEvent.insert(index, value)

    def replace_oadrEvent_at(self, index, value):
        self.oadrEvent[index] = value

    def get_schemaVersion(self):
        return self.schemaVersion

    def set_schemaVersion(self, schemaVersion):
        self.schemaVersion = schemaVersion

    def hasContent_(self):
        if (
            self.eiResponse is not None
            or self.requestID is not None
            or self.vtnID is not None
            or self.oadrEvent
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrDistributeEventType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110"  xmlns:pyld="http://docs.oasis-open.org/ns/energyinterop/201110/payloads" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrDistributeEventType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespace_,
            name_="oadrDistributeEventType",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrDistributeEventType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrDistributeEventType",
    ):
        if self.schemaVersion is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            outfile.write(" schemaVersion=%s" % (quote_attrib(self.schemaVersion),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrDistributeEventType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.eiResponse is not None:
            self.eiResponse.export(
                outfile,
                level,
                namespace_="ei:",
                name_="eiResponse",
                pretty_print=pretty_print,
            )
        if self.requestID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<pyld:requestID>%s</pyld:requestID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.requestID), input_name="requestID"
                        )
                    ),
                    eol_,
                )
            )
        if self.vtnID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:vtnID>%s</ei:vtnID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.vtnID), input_name="vtnID"
                        )
                    ),
                    eol_,
                )
            )
        for oadrEvent_ in self.oadrEvent:
            oadrEvent_.export(
                outfile, level, namespace_, name_="oadrEvent", pretty_print=pretty_print
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("schemaVersion", node)
        if value is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            self.schemaVersion = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "eiResponse":
            obj_ = EiResponseType.factory()
            obj_.build(child_)
            self.eiResponse = obj_
            obj_.original_tagname_ = "eiResponse"
        elif nodeName_ == "requestID":
            requestID_ = child_.text
            requestID_ = self.gds_validate_string(requestID_, node, "requestID")
            self.requestID = requestID_
        elif nodeName_ == "vtnID":
            vtnID_ = child_.text
            vtnID_ = self.gds_validate_string(vtnID_, node, "vtnID")
            self.vtnID = vtnID_
        elif nodeName_ == "oadrEvent":
            obj_ = oadrEventType.factory()
            obj_.build(child_)
            self.oadrEvent.append(obj_)
            obj_.original_tagname_ = "oadrEvent"


# end class oadrDistributeEventType


class oadrCreatedEventType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, schemaVersion=None, eiCreatedEvent=None):
        self.original_tagname_ = None
        self.schemaVersion = _cast(None, schemaVersion)
        self.eiCreatedEvent = eiCreatedEvent

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, oadrCreatedEventType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrCreatedEventType.subclass:
            return oadrCreatedEventType.subclass(*args_, **kwargs_)
        else:
            return oadrCreatedEventType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_eiCreatedEvent(self):
        return self.eiCreatedEvent

    def set_eiCreatedEvent(self, eiCreatedEvent):
        self.eiCreatedEvent = eiCreatedEvent

    def get_schemaVersion(self):
        return self.schemaVersion

    def set_schemaVersion(self, schemaVersion):
        self.schemaVersion = schemaVersion

    def hasContent_(self):
        if self.eiCreatedEvent is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrCreatedEventType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:pyld="http://docs.oasis-open.org/ns/energyinterop/201110/payloads" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrCreatedEventType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="oadrCreatedEventType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrCreatedEventType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrCreatedEventType",
    ):
        if self.schemaVersion is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            outfile.write(" schemaVersion=%s" % (quote_attrib(self.schemaVersion),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrCreatedEventType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.eiCreatedEvent is not None:
            self.eiCreatedEvent.export(
                outfile,
                level,
                namespace_="pyld:",
                name_="eiCreatedEvent",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("schemaVersion", node)
        if value is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            self.schemaVersion = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "eiCreatedEvent":
            obj_ = eiCreatedEvent.factory()
            obj_.build(child_)
            self.eiCreatedEvent = obj_
            obj_.original_tagname_ = "eiCreatedEvent"


# end class oadrCreatedEventType


class oadrRequestEventType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, schemaVersion=None, eiRequestEvent=None):
        self.original_tagname_ = None
        self.schemaVersion = _cast(None, schemaVersion)
        self.eiRequestEvent = eiRequestEvent

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, oadrRequestEventType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrRequestEventType.subclass:
            return oadrRequestEventType.subclass(*args_, **kwargs_)
        else:
            return oadrRequestEventType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_eiRequestEvent(self):
        return self.eiRequestEvent

    def set_eiRequestEvent(self, eiRequestEvent):
        self.eiRequestEvent = eiRequestEvent

    def get_schemaVersion(self):
        return self.schemaVersion

    def set_schemaVersion(self, schemaVersion):
        self.schemaVersion = schemaVersion

    def hasContent_(self):
        if self.eiRequestEvent is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrRequestEventType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:pyld="http://docs.oasis-open.org/ns/energyinterop/201110/payloads" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrRequestEventType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="oadrRequestEventType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrRequestEventType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrRequestEventType",
    ):
        if self.schemaVersion is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            outfile.write(" schemaVersion=%s" % (quote_attrib(self.schemaVersion),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrRequestEventType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.eiRequestEvent is not None:
            self.eiRequestEvent.export(
                outfile,
                level,
                namespace_="pyld:",
                name_="eiRequestEvent",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("schemaVersion", node)
        if value is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            self.schemaVersion = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "eiRequestEvent":
            obj_ = eiRequestEvent.factory()
            obj_.build(child_)
            self.eiRequestEvent = obj_
            obj_.original_tagname_ = "eiRequestEvent"


# end class oadrRequestEventType


class oadrResponseType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, schemaVersion=None, eiResponse=None, venID=None):
        self.original_tagname_ = None
        self.schemaVersion = _cast(None, schemaVersion)
        self.eiResponse = eiResponse
        self.venID = venID

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, oadrResponseType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrResponseType.subclass:
            return oadrResponseType.subclass(*args_, **kwargs_)
        else:
            return oadrResponseType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_eiResponse(self):
        return self.eiResponse

    def set_eiResponse(self, eiResponse):
        self.eiResponse = eiResponse

    def get_venID(self):
        return self.venID

    def set_venID(self, venID):
        self.venID = venID

    def get_schemaVersion(self):
        return self.schemaVersion

    def set_schemaVersion(self, schemaVersion):
        self.schemaVersion = schemaVersion

    def hasContent_(self):
        if self.eiResponse is not None or self.venID is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrResponseType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrResponseType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="oadrResponseType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrResponseType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrResponseType",
    ):
        if self.schemaVersion is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            outfile.write(" schemaVersion=%s" % (quote_attrib(self.schemaVersion),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrResponseType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.eiResponse is not None:
            self.eiResponse.export(
                outfile,
                level,
                namespace_="ei:",
                name_="eiResponse",
                pretty_print=pretty_print,
            )
        if self.venID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:venID>%s</ei:venID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.venID), input_name="venID"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("schemaVersion", node)
        if value is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            self.schemaVersion = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "eiResponse":
            obj_ = EiResponseType.factory()
            obj_.build(child_)
            self.eiResponse = obj_
            obj_.original_tagname_ = "eiResponse"
        elif nodeName_ == "venID":
            venID_ = child_.text
            venID_ = self.gds_validate_string(venID_, node, "venID")
            self.venID = venID_


# end class oadrResponseType


class oadrCancelOptType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, schemaVersion=None, requestID=None, optID=None, venID=None):
        self.original_tagname_ = None
        self.schemaVersion = _cast(None, schemaVersion)
        self.requestID = requestID
        self.optID = optID
        self.venID = venID

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, oadrCancelOptType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrCancelOptType.subclass:
            return oadrCancelOptType.subclass(*args_, **kwargs_)
        else:
            return oadrCancelOptType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_requestID(self):
        return self.requestID

    def set_requestID(self, requestID):
        self.requestID = requestID

    def get_optID(self):
        return self.optID

    def set_optID(self, optID):
        self.optID = optID

    def get_venID(self):
        return self.venID

    def set_venID(self, venID):
        self.venID = venID

    def get_schemaVersion(self):
        return self.schemaVersion

    def set_schemaVersion(self, schemaVersion):
        self.schemaVersion = schemaVersion

    def hasContent_(self):
        if (
            self.requestID is not None
            or self.optID is not None
            or self.venID is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrCancelOptType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:pyld="http://docs.oasis-open.org/ns/energyinterop/201110/payloads"  xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrCancelOptType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="oadrCancelOptType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrCancelOptType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrCancelOptType",
    ):
        if self.schemaVersion is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            outfile.write(" schemaVersion=%s" % (quote_attrib(self.schemaVersion),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrCancelOptType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.requestID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<pyld:requestID>%s</pyld:requestID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.requestID), input_name="requestID"
                        )
                    ),
                    eol_,
                )
            )
        if self.optID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:optID>%s</ei:optID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.optID), input_name="optID"
                        )
                    ),
                    eol_,
                )
            )
        if self.venID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:venID>%s</ei:venID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.venID), input_name="venID"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("schemaVersion", node)
        if value is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            self.schemaVersion = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "requestID":
            requestID_ = child_.text
            requestID_ = self.gds_validate_string(requestID_, node, "requestID")
            self.requestID = requestID_
        elif nodeName_ == "optID":
            optID_ = child_.text
            optID_ = self.gds_validate_string(optID_, node, "optID")
            self.optID = optID_
        elif nodeName_ == "venID":
            venID_ = child_.text
            venID_ = self.gds_validate_string(venID_, node, "venID")
            self.venID = venID_


# end class oadrCancelOptType


class oadrCanceledOptType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, schemaVersion=None, eiResponse=None, optID=None):
        self.original_tagname_ = None
        self.schemaVersion = _cast(None, schemaVersion)
        self.eiResponse = eiResponse
        self.optID = optID

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, oadrCanceledOptType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrCanceledOptType.subclass:
            return oadrCanceledOptType.subclass(*args_, **kwargs_)
        else:
            return oadrCanceledOptType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_eiResponse(self):
        return self.eiResponse

    def set_eiResponse(self, eiResponse):
        self.eiResponse = eiResponse

    def get_optID(self):
        return self.optID

    def set_optID(self, optID):
        self.optID = optID

    def get_schemaVersion(self):
        return self.schemaVersion

    def set_schemaVersion(self, schemaVersion):
        self.schemaVersion = schemaVersion

    def hasContent_(self):
        if self.eiResponse is not None or self.optID is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrCanceledOptType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrCanceledOptType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="oadrCanceledOptType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrCanceledOptType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrCanceledOptType",
    ):
        if self.schemaVersion is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            outfile.write(" schemaVersion=%s" % (quote_attrib(self.schemaVersion),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrCanceledOptType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.eiResponse is not None:
            self.eiResponse.export(
                outfile,
                level,
                namespace_="ei:",
                name_="eiResponse",
                pretty_print=pretty_print,
            )
        if self.optID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:optID>%s</ei:optID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.optID), input_name="optID"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("schemaVersion", node)
        if value is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            self.schemaVersion = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "eiResponse":
            obj_ = EiResponseType.factory()
            obj_.build(child_)
            self.eiResponse = obj_
            obj_.original_tagname_ = "eiResponse"
        elif nodeName_ == "optID":
            optID_ = child_.text
            optID_ = self.gds_validate_string(optID_, node, "optID")
            self.optID = optID_


# end class oadrCanceledOptType


class oadrCreatedOptType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, schemaVersion=None, eiResponse=None, optID=None):
        self.original_tagname_ = None
        self.schemaVersion = _cast(None, schemaVersion)
        self.eiResponse = eiResponse
        self.optID = optID

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, oadrCreatedOptType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrCreatedOptType.subclass:
            return oadrCreatedOptType.subclass(*args_, **kwargs_)
        else:
            return oadrCreatedOptType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_eiResponse(self):
        return self.eiResponse

    def set_eiResponse(self, eiResponse):
        self.eiResponse = eiResponse

    def get_optID(self):
        return self.optID

    def set_optID(self, optID):
        self.optID = optID

    def get_schemaVersion(self):
        return self.schemaVersion

    def set_schemaVersion(self, schemaVersion):
        self.schemaVersion = schemaVersion

    def hasContent_(self):
        if self.eiResponse is not None or self.optID is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrCreatedOptType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrCreatedOptType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="oadrCreatedOptType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrCreatedOptType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrCreatedOptType",
    ):
        if self.schemaVersion is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            outfile.write(" schemaVersion=%s" % (quote_attrib(self.schemaVersion),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrCreatedOptType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.eiResponse is not None:
            self.eiResponse.export(
                outfile,
                level,
                namespace_="ei:",
                name_="eiResponse",
                pretty_print=pretty_print,
            )
        if self.optID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:optID>%s</ei:optID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.optID), input_name="optID"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("schemaVersion", node)
        if value is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            self.schemaVersion = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "eiResponse":
            obj_ = EiResponseType.factory()
            obj_.build(child_)
            self.eiResponse = obj_
            obj_.original_tagname_ = "eiResponse"
        elif nodeName_ == "optID":
            optID_ = child_.text
            optID_ = self.gds_validate_string(optID_, node, "optID")
            self.optID = optID_


# end class oadrCreatedOptType


class oadrCancelReportType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self,
        schemaVersion=None,
        requestID=None,
        reportRequestID=None,
        reportToFollow=None,
        venID=None,
    ):
        self.original_tagname_ = None
        self.schemaVersion = _cast(None, schemaVersion)
        self.requestID = requestID
        if reportRequestID is None:
            self.reportRequestID = []
        else:
            self.reportRequestID = reportRequestID
        self.reportToFollow = reportToFollow
        self.venID = venID

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, oadrCancelReportType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrCancelReportType.subclass:
            return oadrCancelReportType.subclass(*args_, **kwargs_)
        else:
            return oadrCancelReportType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_requestID(self):
        return self.requestID

    def set_requestID(self, requestID):
        self.requestID = requestID

    def get_reportRequestID(self):
        return self.reportRequestID

    def set_reportRequestID(self, reportRequestID):
        self.reportRequestID = reportRequestID

    def add_reportRequestID(self, value):
        self.reportRequestID.append(value)

    def insert_reportRequestID_at(self, index, value):
        self.reportRequestID.insert(index, value)

    def replace_reportRequestID_at(self, index, value):
        self.reportRequestID[index] = value

    def get_reportToFollow(self):
        return self.reportToFollow

    def set_reportToFollow(self, reportToFollow):
        self.reportToFollow = reportToFollow

    def get_venID(self):
        return self.venID

    def set_venID(self, venID):
        self.venID = venID

    def get_schemaVersion(self):
        return self.schemaVersion

    def set_schemaVersion(self, schemaVersion):
        self.schemaVersion = schemaVersion

    def hasContent_(self):
        if (
            self.requestID is not None
            or self.reportRequestID
            or self.reportToFollow is not None
            or self.venID is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrCancelReportType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:pyld="http://docs.oasis-open.org/ns/energyinterop/201110/payloads"  xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrCancelReportType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="oadrCancelReportType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrCancelReportType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrCancelReportType",
    ):
        if self.schemaVersion is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            outfile.write(" schemaVersion=%s" % (quote_attrib(self.schemaVersion),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrCancelReportType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.requestID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<pyld:requestID>%s</pyld:requestID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.requestID), input_name="requestID"
                        )
                    ),
                    eol_,
                )
            )
        for reportRequestID_ in self.reportRequestID:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:reportRequestID>%s</ei:reportRequestID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(reportRequestID_), input_name="reportRequestID"
                        )
                    ),
                    eol_,
                )
            )
        if self.reportToFollow is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<pyld:reportToFollow>%s</pyld:reportToFollow>%s"
                % (
                    self.gds_format_boolean(
                        self.reportToFollow, input_name="reportToFollow"
                    ),
                    eol_,
                )
            )
        if self.venID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:venID>%s</ei:venID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.venID), input_name="venID"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("schemaVersion", node)
        if value is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            self.schemaVersion = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "requestID":
            requestID_ = child_.text
            requestID_ = self.gds_validate_string(requestID_, node, "requestID")
            self.requestID = requestID_
        elif nodeName_ == "reportRequestID":
            reportRequestID_ = child_.text
            reportRequestID_ = self.gds_validate_string(
                reportRequestID_, node, "reportRequestID"
            )
            self.reportRequestID.append(reportRequestID_)
        elif nodeName_ == "reportToFollow":
            sval_ = child_.text
            if sval_ in ("true", "1"):
                ival_ = True
            elif sval_ in ("false", "0"):
                ival_ = False
            else:
                raise_parse_error(child_, "requires boolean")
            ival_ = self.gds_validate_boolean(ival_, node, "reportToFollow")
            self.reportToFollow = ival_
        elif nodeName_ == "venID":
            venID_ = child_.text
            venID_ = self.gds_validate_string(venID_, node, "venID")
            self.venID = venID_


# end class oadrCancelReportType


class oadrCanceledReportType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self, schemaVersion=None, eiResponse=None, oadrPendingReports=None, venID=None
    ):
        self.original_tagname_ = None
        self.schemaVersion = _cast(None, schemaVersion)
        self.eiResponse = eiResponse
        self.oadrPendingReports = oadrPendingReports
        self.venID = venID

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, oadrCanceledReportType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrCanceledReportType.subclass:
            return oadrCanceledReportType.subclass(*args_, **kwargs_)
        else:
            return oadrCanceledReportType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_eiResponse(self):
        return self.eiResponse

    def set_eiResponse(self, eiResponse):
        self.eiResponse = eiResponse

    def get_oadrPendingReports(self):
        return self.oadrPendingReports

    def set_oadrPendingReports(self, oadrPendingReports):
        self.oadrPendingReports = oadrPendingReports

    def get_venID(self):
        return self.venID

    def set_venID(self, venID):
        self.venID = venID

    def get_schemaVersion(self):
        return self.schemaVersion

    def set_schemaVersion(self, schemaVersion):
        self.schemaVersion = schemaVersion

    def hasContent_(self):
        if (
            self.eiResponse is not None
            or self.oadrPendingReports is not None
            or self.venID is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrCanceledReportType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrCanceledReportType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespace_,
            name_="oadrCanceledReportType",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrCanceledReportType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrCanceledReportType",
    ):
        if self.schemaVersion is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            outfile.write(" schemaVersion=%s" % (quote_attrib(self.schemaVersion),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrCanceledReportType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.eiResponse is not None:
            self.eiResponse.export(
                outfile,
                level,
                namespace_="ei:",
                name_="eiResponse",
                pretty_print=pretty_print,
            )
        if self.oadrPendingReports is not None:
            self.oadrPendingReports.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrPendingReports",
                pretty_print=pretty_print,
            )
        if self.venID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:venID>%s</ei:venID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.venID), input_name="venID"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("schemaVersion", node)
        if value is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            self.schemaVersion = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "eiResponse":
            obj_ = EiResponseType.factory()
            obj_.build(child_)
            self.eiResponse = obj_
            obj_.original_tagname_ = "eiResponse"
        elif nodeName_ == "oadrPendingReports":
            obj_ = oadrPendingReportsType.factory()
            obj_.build(child_)
            self.oadrPendingReports = obj_
            obj_.original_tagname_ = "oadrPendingReports"
        elif nodeName_ == "venID":
            venID_ = child_.text
            venID_ = self.gds_validate_string(venID_, node, "venID")
            self.venID = venID_


# end class oadrCanceledReportType


class oadrCreateReportType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self, schemaVersion=None, requestID=None, oadrReportRequest=None, venID=None
    ):
        self.original_tagname_ = None
        self.schemaVersion = _cast(None, schemaVersion)
        self.requestID = requestID
        if oadrReportRequest is None:
            self.oadrReportRequest = []
        else:
            self.oadrReportRequest = oadrReportRequest
        self.venID = venID

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, oadrCreateReportType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrCreateReportType.subclass:
            return oadrCreateReportType.subclass(*args_, **kwargs_)
        else:
            return oadrCreateReportType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_requestID(self):
        return self.requestID

    def set_requestID(self, requestID):
        self.requestID = requestID

    def get_oadrReportRequest(self):
        return self.oadrReportRequest

    def set_oadrReportRequest(self, oadrReportRequest):
        self.oadrReportRequest = oadrReportRequest

    def add_oadrReportRequest(self, value):
        self.oadrReportRequest.append(value)

    def insert_oadrReportRequest_at(self, index, value):
        self.oadrReportRequest.insert(index, value)

    def replace_oadrReportRequest_at(self, index, value):
        self.oadrReportRequest[index] = value

    def get_venID(self):
        return self.venID

    def set_venID(self, venID):
        self.venID = venID

    def get_schemaVersion(self):
        return self.schemaVersion

    def set_schemaVersion(self, schemaVersion):
        self.schemaVersion = schemaVersion

    def hasContent_(self):
        if (
            self.requestID is not None
            or self.oadrReportRequest
            or self.venID is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrCreateReportType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:pyld="http://docs.oasis-open.org/ns/energyinterop/201110/payloads"  xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrCreateReportType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="oadrCreateReportType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrCreateReportType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrCreateReportType",
    ):
        if self.schemaVersion is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            outfile.write(" schemaVersion=%s" % (quote_attrib(self.schemaVersion),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrCreateReportType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.requestID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<pyld:requestID>%s</pyld:requestID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.requestID), input_name="requestID"
                        )
                    ),
                    eol_,
                )
            )
        for oadrReportRequest_ in self.oadrReportRequest:
            oadrReportRequest_.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrReportRequest",
                pretty_print=pretty_print,
            )
        if self.venID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:venID>%s</ei:venID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.venID), input_name="venID"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("schemaVersion", node)
        if value is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            self.schemaVersion = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "requestID":
            requestID_ = child_.text
            requestID_ = self.gds_validate_string(requestID_, node, "requestID")
            self.requestID = requestID_
        elif nodeName_ == "oadrReportRequest":
            obj_ = oadrReportRequestType.factory()
            obj_.build(child_)
            self.oadrReportRequest.append(obj_)
            obj_.original_tagname_ = "oadrReportRequest"
        elif nodeName_ == "venID":
            venID_ = child_.text
            venID_ = self.gds_validate_string(venID_, node, "venID")
            self.venID = venID_


# end class oadrCreateReportType


class oadrCreatedReportType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self, schemaVersion=None, eiResponse=None, oadrPendingReports=None, venID=None
    ):
        self.original_tagname_ = None
        self.schemaVersion = _cast(None, schemaVersion)
        self.eiResponse = eiResponse
        self.oadrPendingReports = oadrPendingReports
        self.venID = venID

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, oadrCreatedReportType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrCreatedReportType.subclass:
            return oadrCreatedReportType.subclass(*args_, **kwargs_)
        else:
            return oadrCreatedReportType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_eiResponse(self):
        return self.eiResponse

    def set_eiResponse(self, eiResponse):
        self.eiResponse = eiResponse

    def get_oadrPendingReports(self):
        return self.oadrPendingReports

    def set_oadrPendingReports(self, oadrPendingReports):
        self.oadrPendingReports = oadrPendingReports

    def get_venID(self):
        return self.venID

    def set_venID(self, venID):
        self.venID = venID

    def get_schemaVersion(self):
        return self.schemaVersion

    def set_schemaVersion(self, schemaVersion):
        self.schemaVersion = schemaVersion

    def hasContent_(self):
        if (
            self.eiResponse is not None
            or self.oadrPendingReports is not None
            or self.venID is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrCreatedReportType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrCreatedReportType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="oadrCreatedReportType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrCreatedReportType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrCreatedReportType",
    ):
        if self.schemaVersion is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            outfile.write(" schemaVersion=%s" % (quote_attrib(self.schemaVersion),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrCreatedReportType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.eiResponse is not None:
            self.eiResponse.export(
                outfile,
                level,
                namespace_="ei:",
                name_="eiResponse",
                pretty_print=pretty_print,
            )
        if self.oadrPendingReports is not None:
            self.oadrPendingReports.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrPendingReports",
                pretty_print=pretty_print,
            )
        if self.venID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:venID>%s</ei:venID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.venID), input_name="venID"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("schemaVersion", node)
        if value is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            self.schemaVersion = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "eiResponse":
            obj_ = EiResponseType.factory()
            obj_.build(child_)
            self.eiResponse = obj_
            obj_.original_tagname_ = "eiResponse"
        elif nodeName_ == "oadrPendingReports":
            obj_ = oadrPendingReportsType.factory()
            obj_.build(child_)
            self.oadrPendingReports = obj_
            obj_.original_tagname_ = "oadrPendingReports"
        elif nodeName_ == "venID":
            venID_ = child_.text
            venID_ = self.gds_validate_string(venID_, node, "venID")
            self.venID = venID_


# end class oadrCreatedReportType


class oadrRegisterReportType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self,
        schemaVersion=None,
        requestID=None,
        oadrReport=None,
        venID=None,
        reportRequestID=None,
    ):
        self.original_tagname_ = None
        self.schemaVersion = _cast(None, schemaVersion)
        self.requestID = requestID
        if oadrReport is None:
            self.oadrReport = []
        else:
            self.oadrReport = oadrReport
        self.venID = venID
        self.reportRequestID = reportRequestID

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, oadrRegisterReportType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrRegisterReportType.subclass:
            return oadrRegisterReportType.subclass(*args_, **kwargs_)
        else:
            return oadrRegisterReportType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_requestID(self):
        return self.requestID

    def set_requestID(self, requestID):
        self.requestID = requestID

    def get_oadrReport(self):
        return self.oadrReport

    def set_oadrReport(self, oadrReport):
        self.oadrReport = oadrReport

    def add_oadrReport(self, value):
        self.oadrReport.append(value)

    def insert_oadrReport_at(self, index, value):
        self.oadrReport.insert(index, value)

    def replace_oadrReport_at(self, index, value):
        self.oadrReport[index] = value

    def get_venID(self):
        return self.venID

    def set_venID(self, venID):
        self.venID = venID

    def get_reportRequestID(self):
        return self.reportRequestID

    def set_reportRequestID(self, reportRequestID):
        self.reportRequestID = reportRequestID

    def get_schemaVersion(self):
        return self.schemaVersion

    def set_schemaVersion(self, schemaVersion):
        self.schemaVersion = schemaVersion

    def hasContent_(self):
        if (
            self.requestID is not None
            or self.oadrReport
            or self.venID is not None
            or self.reportRequestID is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrRegisterReportType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:pyld="http://docs.oasis-open.org/ns/energyinterop/201110/payloads"  xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrRegisterReportType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespace_,
            name_="oadrRegisterReportType",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrRegisterReportType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrRegisterReportType",
    ):
        if self.schemaVersion is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            outfile.write(" schemaVersion=%s" % (quote_attrib(self.schemaVersion),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrRegisterReportType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.requestID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<pyld:requestID>%s</pyld:requestID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.requestID), input_name="requestID"
                        )
                    ),
                    eol_,
                )
            )
        for oadrReport_ in self.oadrReport:
            oadrReport_.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrReport",
                pretty_print=pretty_print,
            )
        if self.venID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:venID>%s</ei:venID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.venID), input_name="venID"
                        )
                    ),
                    eol_,
                )
            )
        if self.reportRequestID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:reportRequestID>%s</ei:reportRequestID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.reportRequestID),
                            input_name="reportRequestID",
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("schemaVersion", node)
        if value is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            self.schemaVersion = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "requestID":
            requestID_ = child_.text
            requestID_ = self.gds_validate_string(requestID_, node, "requestID")
            self.requestID = requestID_
        elif nodeName_ == "oadrReport":
            obj_ = oadrReportType.factory()
            obj_.build(child_)
            self.oadrReport.append(obj_)
            obj_.original_tagname_ = "oadrReport"
        elif nodeName_ == "venID":
            venID_ = child_.text
            venID_ = self.gds_validate_string(venID_, node, "venID")
            self.venID = venID_
        elif nodeName_ == "reportRequestID":
            reportRequestID_ = child_.text
            reportRequestID_ = self.gds_validate_string(
                reportRequestID_, node, "reportRequestID"
            )
            self.reportRequestID = reportRequestID_


# end class oadrRegisterReportType


class oadrRegisteredReportType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self, schemaVersion=None, eiResponse=None, oadrReportRequest=None, venID=None
    ):
        self.original_tagname_ = None
        self.schemaVersion = _cast(None, schemaVersion)
        self.eiResponse = eiResponse
        if oadrReportRequest is None:
            self.oadrReportRequest = []
        else:
            self.oadrReportRequest = oadrReportRequest
        self.venID = venID

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, oadrRegisteredReportType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrRegisteredReportType.subclass:
            return oadrRegisteredReportType.subclass(*args_, **kwargs_)
        else:
            return oadrRegisteredReportType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_eiResponse(self):
        return self.eiResponse

    def set_eiResponse(self, eiResponse):
        self.eiResponse = eiResponse

    def get_oadrReportRequest(self):
        return self.oadrReportRequest

    def set_oadrReportRequest(self, oadrReportRequest):
        self.oadrReportRequest = oadrReportRequest

    def add_oadrReportRequest(self, value):
        self.oadrReportRequest.append(value)

    def insert_oadrReportRequest_at(self, index, value):
        self.oadrReportRequest.insert(index, value)

    def replace_oadrReportRequest_at(self, index, value):
        self.oadrReportRequest[index] = value

    def get_venID(self):
        return self.venID

    def set_venID(self, venID):
        self.venID = venID

    def get_schemaVersion(self):
        return self.schemaVersion

    def set_schemaVersion(self, schemaVersion):
        self.schemaVersion = schemaVersion

    def hasContent_(self):
        if (
            self.eiResponse is not None
            or self.oadrReportRequest
            or self.venID is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrRegisteredReportType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrRegisteredReportType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespace_,
            name_="oadrRegisteredReportType",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrRegisteredReportType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrRegisteredReportType",
    ):
        if self.schemaVersion is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            outfile.write(" schemaVersion=%s" % (quote_attrib(self.schemaVersion),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrRegisteredReportType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.eiResponse is not None:
            self.eiResponse.export(
                outfile,
                level,
                namespace_="ei:",
                name_="eiResponse",
                pretty_print=pretty_print,
            )
        for oadrReportRequest_ in self.oadrReportRequest:
            oadrReportRequest_.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrReportRequest",
                pretty_print=pretty_print,
            )
        if self.venID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:venID>%s</ei:venID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.venID), input_name="venID"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("schemaVersion", node)
        if value is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            self.schemaVersion = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "eiResponse":
            obj_ = EiResponseType.factory()
            obj_.build(child_)
            self.eiResponse = obj_
            obj_.original_tagname_ = "eiResponse"
        elif nodeName_ == "oadrReportRequest":
            obj_ = oadrReportRequestType.factory()
            obj_.build(child_)
            self.oadrReportRequest.append(obj_)
            obj_.original_tagname_ = "oadrReportRequest"
        elif nodeName_ == "venID":
            venID_ = child_.text
            venID_ = self.gds_validate_string(venID_, node, "venID")
            self.venID = venID_


# end class oadrRegisteredReportType


class oadrUpdateReportType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, schemaVersion=None, requestID=None, oadrReport=None, venID=None):
        self.original_tagname_ = None
        self.schemaVersion = _cast(None, schemaVersion)
        self.requestID = requestID
        if oadrReport is None:
            self.oadrReport = []
        else:
            self.oadrReport = oadrReport
        self.venID = venID

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, oadrUpdateReportType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrUpdateReportType.subclass:
            return oadrUpdateReportType.subclass(*args_, **kwargs_)
        else:
            return oadrUpdateReportType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_requestID(self):
        return self.requestID

    def set_requestID(self, requestID):
        self.requestID = requestID

    def get_oadrReport(self):
        return self.oadrReport

    def set_oadrReport(self, oadrReport):
        self.oadrReport = oadrReport

    def add_oadrReport(self, value):
        self.oadrReport.append(value)

    def insert_oadrReport_at(self, index, value):
        self.oadrReport.insert(index, value)

    def replace_oadrReport_at(self, index, value):
        self.oadrReport[index] = value

    def get_venID(self):
        return self.venID

    def set_venID(self, venID):
        self.venID = venID

    def get_schemaVersion(self):
        return self.schemaVersion

    def set_schemaVersion(self, schemaVersion):
        self.schemaVersion = schemaVersion

    def hasContent_(self):
        if self.requestID is not None or self.oadrReport or self.venID is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrUpdateReportType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:pyld="http://docs.oasis-open.org/ns/energyinterop/201110/payloads"  xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrUpdateReportType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="oadrUpdateReportType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrUpdateReportType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrUpdateReportType",
    ):
        if self.schemaVersion is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            outfile.write(" schemaVersion=%s" % (quote_attrib(self.schemaVersion),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrUpdateReportType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.requestID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<pyld:requestID>%s</pyld:requestID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.requestID), input_name="requestID"
                        )
                    ),
                    eol_,
                )
            )
        for oadrReport_ in self.oadrReport:
            oadrReport_.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrReport",
                pretty_print=pretty_print,
            )
        if self.venID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:venID>%s</ei:venID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.venID), input_name="venID"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("schemaVersion", node)
        if value is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            self.schemaVersion = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "requestID":
            requestID_ = child_.text
            requestID_ = self.gds_validate_string(requestID_, node, "requestID")
            self.requestID = requestID_
        elif nodeName_ == "oadrReport":
            obj_ = oadrReportType.factory()
            obj_.build(child_)
            self.oadrReport.append(obj_)
            obj_.original_tagname_ = "oadrReport"
        elif nodeName_ == "venID":
            venID_ = child_.text
            venID_ = self.gds_validate_string(venID_, node, "venID")
            self.venID = venID_


# end class oadrUpdateReportType


class oadrUpdatedReportType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self, schemaVersion=None, eiResponse=None, oadrCancelReport=None, venID=None
    ):
        self.original_tagname_ = None
        self.schemaVersion = _cast(None, schemaVersion)
        self.eiResponse = eiResponse
        self.oadrCancelReport = oadrCancelReport
        self.venID = venID

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, oadrUpdatedReportType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrUpdatedReportType.subclass:
            return oadrUpdatedReportType.subclass(*args_, **kwargs_)
        else:
            return oadrUpdatedReportType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_eiResponse(self):
        return self.eiResponse

    def set_eiResponse(self, eiResponse):
        self.eiResponse = eiResponse

    def get_oadrCancelReport(self):
        return self.oadrCancelReport

    def set_oadrCancelReport(self, oadrCancelReport):
        self.oadrCancelReport = oadrCancelReport

    def get_venID(self):
        return self.venID

    def set_venID(self, venID):
        self.venID = venID

    def get_schemaVersion(self):
        return self.schemaVersion

    def set_schemaVersion(self, schemaVersion):
        self.schemaVersion = schemaVersion

    def hasContent_(self):
        if (
            self.eiResponse is not None
            or self.oadrCancelReport is not None
            or self.venID is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrUpdatedReportType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrUpdatedReportType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="oadrUpdatedReportType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrUpdatedReportType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrUpdatedReportType",
    ):
        if self.schemaVersion is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            outfile.write(" schemaVersion=%s" % (quote_attrib(self.schemaVersion),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrUpdatedReportType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.eiResponse is not None:
            self.eiResponse.export(
                outfile,
                level,
                namespace_="ei:",
                name_="eiResponse",
                pretty_print=pretty_print,
            )
        if self.oadrCancelReport is not None:
            self.oadrCancelReport.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrCancelReport",
                pretty_print=pretty_print,
            )
        if self.venID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:venID>%s</ei:venID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.venID), input_name="venID"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("schemaVersion", node)
        if value is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            self.schemaVersion = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "eiResponse":
            obj_ = EiResponseType.factory()
            obj_.build(child_)
            self.eiResponse = obj_
            obj_.original_tagname_ = "eiResponse"
        elif nodeName_ == "oadrCancelReport":
            obj_ = oadrCancelReportType.factory()
            obj_.build(child_)
            self.oadrCancelReport = obj_
            obj_.original_tagname_ = "oadrCancelReport"
        elif nodeName_ == "venID":
            venID_ = child_.text
            venID_ = self.gds_validate_string(venID_, node, "venID")
            self.venID = venID_


# end class oadrUpdatedReportType


class oadrCancelPartyRegistrationType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self, schemaVersion=None, requestID=None, registrationID=None, venID=None
    ):
        self.original_tagname_ = None
        self.schemaVersion = _cast(None, schemaVersion)
        self.requestID = requestID
        self.registrationID = registrationID
        self.venID = venID

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, oadrCancelPartyRegistrationType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrCancelPartyRegistrationType.subclass:
            return oadrCancelPartyRegistrationType.subclass(*args_, **kwargs_)
        else:
            return oadrCancelPartyRegistrationType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_requestID(self):
        return self.requestID

    def set_requestID(self, requestID):
        self.requestID = requestID

    def get_registrationID(self):
        return self.registrationID

    def set_registrationID(self, registrationID):
        self.registrationID = registrationID

    def get_venID(self):
        return self.venID

    def set_venID(self, venID):
        self.venID = venID

    def get_schemaVersion(self):
        return self.schemaVersion

    def set_schemaVersion(self, schemaVersion):
        self.schemaVersion = schemaVersion

    def hasContent_(self):
        if (
            self.requestID is not None
            or self.registrationID is not None
            or self.venID is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrCancelPartyRegistrationType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:pyld="http://docs.oasis-open.org/ns/energyinterop/201110/payloads"  xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get(
            "oadrCancelPartyRegistrationType"
        )
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespace_,
            name_="oadrCancelPartyRegistrationType",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrCancelPartyRegistrationType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrCancelPartyRegistrationType",
    ):
        if self.schemaVersion is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            outfile.write(" schemaVersion=%s" % (quote_attrib(self.schemaVersion),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrCancelPartyRegistrationType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.requestID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<pyld:requestID>%s</pyld:requestID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.requestID), input_name="requestID"
                        )
                    ),
                    eol_,
                )
            )
        if self.registrationID is not None:
            self.registrationID.export(
                outfile,
                level,
                namespace_="ei:",
                name_="registrationID",
                pretty_print=pretty_print,
            )
        if self.venID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:venID>%s</ei:venID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.venID), input_name="venID"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("schemaVersion", node)
        if value is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            self.schemaVersion = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "requestID":
            requestID_ = child_.text
            requestID_ = self.gds_validate_string(requestID_, node, "requestID")
            self.requestID = requestID_
        elif nodeName_ == "registrationID":
            obj_ = registrationID.factory()
            obj_.build(child_)
            self.registrationID = obj_
            obj_.original_tagname_ = "registrationID"
        elif nodeName_ == "venID":
            venID_ = child_.text
            venID_ = self.gds_validate_string(venID_, node, "venID")
            self.venID = venID_


# end class oadrCancelPartyRegistrationType


class oadrCanceledPartyRegistrationType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self, schemaVersion=None, eiResponse=None, registrationID=None, venID=None
    ):
        self.original_tagname_ = None
        self.schemaVersion = _cast(None, schemaVersion)
        self.eiResponse = eiResponse
        self.registrationID = registrationID
        self.venID = venID

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, oadrCanceledPartyRegistrationType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrCanceledPartyRegistrationType.subclass:
            return oadrCanceledPartyRegistrationType.subclass(*args_, **kwargs_)
        else:
            return oadrCanceledPartyRegistrationType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_eiResponse(self):
        return self.eiResponse

    def set_eiResponse(self, eiResponse):
        self.eiResponse = eiResponse

    def get_registrationID(self):
        return self.registrationID

    def set_registrationID(self, registrationID):
        self.registrationID = registrationID

    def get_venID(self):
        return self.venID

    def set_venID(self, venID):
        self.venID = venID

    def get_schemaVersion(self):
        return self.schemaVersion

    def set_schemaVersion(self, schemaVersion):
        self.schemaVersion = schemaVersion

    def hasContent_(self):
        if (
            self.eiResponse is not None
            or self.registrationID is not None
            or self.venID is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrCanceledPartyRegistrationType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get(
            "oadrCanceledPartyRegistrationType"
        )
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespace_,
            name_="oadrCanceledPartyRegistrationType",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrCanceledPartyRegistrationType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrCanceledPartyRegistrationType",
    ):
        if self.schemaVersion is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            outfile.write(" schemaVersion=%s" % (quote_attrib(self.schemaVersion),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrCanceledPartyRegistrationType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.eiResponse is not None:
            self.eiResponse.export(
                outfile,
                level,
                namespace_="ei:",
                name_="eiResponse",
                pretty_print=pretty_print,
            )
        if self.registrationID is not None:
            self.registrationID.export(
                outfile,
                level,
                namespace_="ei:",
                name_="registrationID",
                pretty_print=pretty_print,
            )
        if self.venID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:venID>%s</ei:venID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.venID), input_name="venID"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("schemaVersion", node)
        if value is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            self.schemaVersion = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "eiResponse":
            obj_ = EiResponseType.factory()
            obj_.build(child_)
            self.eiResponse = obj_
            obj_.original_tagname_ = "eiResponse"
        elif nodeName_ == "registrationID":
            obj_ = registrationID.factory()
            obj_.build(child_)
            self.registrationID = obj_
            obj_.original_tagname_ = "registrationID"
        elif nodeName_ == "venID":
            venID_ = child_.text
            venID_ = self.gds_validate_string(venID_, node, "venID")
            self.venID = venID_


# end class oadrCanceledPartyRegistrationType


class oadrCreatePartyRegistrationType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self,
        schemaVersion=None,
        requestID=None,
        registrationID=None,
        venID=None,
        oadrProfileName=None,
        oadrTransportName=None,
        oadrTransportAddress=None,
        oadrReportOnly=None,
        oadrXmlSignature=None,
        oadrVenName=None,
        oadrHttpPullModel=None,
    ):
        self.original_tagname_ = None
        self.schemaVersion = _cast(None, schemaVersion)
        self.requestID = requestID
        self.registrationID = registrationID
        self.venID = venID
        self.oadrProfileName = oadrProfileName
        self.oadrTransportName = oadrTransportName
        self.oadrTransportAddress = oadrTransportAddress
        self.oadrReportOnly = oadrReportOnly
        self.oadrXmlSignature = oadrXmlSignature
        self.oadrVenName = oadrVenName
        self.oadrHttpPullModel = oadrHttpPullModel

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, oadrCreatePartyRegistrationType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrCreatePartyRegistrationType.subclass:
            return oadrCreatePartyRegistrationType.subclass(*args_, **kwargs_)
        else:
            return oadrCreatePartyRegistrationType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_requestID(self):
        return self.requestID

    def set_requestID(self, requestID):
        self.requestID = requestID

    def get_registrationID(self):
        return self.registrationID

    def set_registrationID(self, registrationID):
        self.registrationID = registrationID

    def get_venID(self):
        return self.venID

    def set_venID(self, venID):
        self.venID = venID

    def get_oadrProfileName(self):
        return self.oadrProfileName

    def set_oadrProfileName(self, oadrProfileName):
        self.oadrProfileName = oadrProfileName

    def get_oadrTransportName(self):
        return self.oadrTransportName

    def set_oadrTransportName(self, oadrTransportName):
        self.oadrTransportName = oadrTransportName

    def get_oadrTransportAddress(self):
        return self.oadrTransportAddress

    def set_oadrTransportAddress(self, oadrTransportAddress):
        self.oadrTransportAddress = oadrTransportAddress

    def get_oadrReportOnly(self):
        return self.oadrReportOnly

    def set_oadrReportOnly(self, oadrReportOnly):
        self.oadrReportOnly = oadrReportOnly

    def get_oadrXmlSignature(self):
        return self.oadrXmlSignature

    def set_oadrXmlSignature(self, oadrXmlSignature):
        self.oadrXmlSignature = oadrXmlSignature

    def get_oadrVenName(self):
        return self.oadrVenName

    def set_oadrVenName(self, oadrVenName):
        self.oadrVenName = oadrVenName

    def get_oadrHttpPullModel(self):
        return self.oadrHttpPullModel

    def set_oadrHttpPullModel(self, oadrHttpPullModel):
        self.oadrHttpPullModel = oadrHttpPullModel

    def get_schemaVersion(self):
        return self.schemaVersion

    def set_schemaVersion(self, schemaVersion):
        self.schemaVersion = schemaVersion

    def hasContent_(self):
        if (
            self.requestID is not None
            or self.registrationID is not None
            or self.venID is not None
            or self.oadrProfileName is not None
            or self.oadrTransportName is not None
            or self.oadrTransportAddress is not None
            or self.oadrReportOnly is not None
            or self.oadrXmlSignature is not None
            or self.oadrVenName is not None
            or self.oadrHttpPullModel is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrCreatePartyRegistrationType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:pyld="http://docs.oasis-open.org/ns/energyinterop/201110/payloads"  xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get(
            "oadrCreatePartyRegistrationType"
        )
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespace_,
            name_="oadrCreatePartyRegistrationType",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrCreatePartyRegistrationType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrCreatePartyRegistrationType",
    ):
        if self.schemaVersion is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            outfile.write(" schemaVersion=%s" % (quote_attrib(self.schemaVersion),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrCreatePartyRegistrationType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.requestID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<pyld:requestID>%s</pyld:requestID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.requestID), input_name="requestID"
                        )
                    ),
                    eol_,
                )
            )
        if self.registrationID is not None:
            self.registrationID.export(
                outfile,
                level,
                namespace_="ei:",
                name_="registrationID",
                pretty_print=pretty_print,
            )
        if self.venID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:venID>%s</ei:venID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.venID), input_name="venID"
                        )
                    ),
                    eol_,
                )
            )
        if self.oadrProfileName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<oadr:oadrProfileName>%s</oadr:oadrProfileName>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.oadrProfileName),
                            input_name="oadrProfileName",
                        )
                    ),
                    eol_,
                )
            )
        if self.oadrTransportName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<oadr:oadrTransportName>%s</oadr:oadrTransportName>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.oadrTransportName),
                            input_name="oadrTransportName",
                        )
                    ),
                    eol_,
                )
            )
        if self.oadrTransportAddress is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<oadr:oadrTransportAddress>%s</oadr:oadrTransportAddress>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.oadrTransportAddress),
                            input_name="oadrTransportAddress",
                        )
                    ),
                    eol_,
                )
            )
        if self.oadrReportOnly is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<oadr:oadrReportOnly>%s</oadr:oadrReportOnly>%s"
                % (
                    self.gds_format_boolean(
                        self.oadrReportOnly, input_name="oadrReportOnly"
                    ),
                    eol_,
                )
            )
        if self.oadrXmlSignature is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<oadr:oadrXmlSignature>%s</oadr:oadrXmlSignature>%s"
                % (
                    self.gds_format_boolean(
                        self.oadrXmlSignature, input_name="oadrXmlSignature"
                    ),
                    eol_,
                )
            )
        if self.oadrVenName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<oadr:oadrVenName>%s</oadr:oadrVenName>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.oadrVenName), input_name="oadrVenName"
                        )
                    ),
                    eol_,
                )
            )
        if self.oadrHttpPullModel is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<oadr:oadrHttpPullModel>%s</oadr:oadrHttpPullModel>%s"
                % (
                    self.gds_format_boolean(
                        self.oadrHttpPullModel, input_name="oadrHttpPullModel"
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("schemaVersion", node)
        if value is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            self.schemaVersion = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "requestID":
            requestID_ = child_.text
            requestID_ = self.gds_validate_string(requestID_, node, "requestID")
            self.requestID = requestID_
        elif nodeName_ == "registrationID":
            obj_ = registrationID.factory()
            obj_.build(child_)
            self.registrationID = obj_
            obj_.original_tagname_ = "registrationID"
        elif nodeName_ == "venID":
            venID_ = child_.text
            venID_ = self.gds_validate_string(venID_, node, "venID")
            self.venID = venID_
        elif nodeName_ == "oadrProfileName":
            oadrProfileName_ = child_.text
            if oadrProfileName_:
                oadrProfileName_ = re_.sub(
                    String_cleanup_pat_, " ", oadrProfileName_
                ).strip()
            else:
                oadrProfileName_ = ""
            oadrProfileName_ = self.gds_validate_string(
                oadrProfileName_, node, "oadrProfileName"
            )
            self.oadrProfileName = oadrProfileName_
        elif nodeName_ == "oadrTransportName":
            oadrTransportName_ = child_.text
            if oadrTransportName_:
                oadrTransportName_ = re_.sub(
                    String_cleanup_pat_, " ", oadrTransportName_
                ).strip()
            else:
                oadrTransportName_ = ""
            oadrTransportName_ = self.gds_validate_string(
                oadrTransportName_, node, "oadrTransportName"
            )
            self.oadrTransportName = oadrTransportName_
        elif nodeName_ == "oadrTransportAddress":
            oadrTransportAddress_ = child_.text
            oadrTransportAddress_ = self.gds_validate_string(
                oadrTransportAddress_, node, "oadrTransportAddress"
            )
            self.oadrTransportAddress = oadrTransportAddress_
        elif nodeName_ == "oadrReportOnly":
            sval_ = child_.text
            if sval_ in ("true", "1"):
                ival_ = True
            elif sval_ in ("false", "0"):
                ival_ = False
            else:
                raise_parse_error(child_, "requires boolean")
            ival_ = self.gds_validate_boolean(ival_, node, "oadrReportOnly")
            self.oadrReportOnly = ival_
        elif nodeName_ == "oadrXmlSignature":
            sval_ = child_.text
            if sval_ in ("true", "1"):
                ival_ = True
            elif sval_ in ("false", "0"):
                ival_ = False
            else:
                raise_parse_error(child_, "requires boolean")
            ival_ = self.gds_validate_boolean(ival_, node, "oadrXmlSignature")
            self.oadrXmlSignature = ival_
        elif nodeName_ == "oadrVenName":
            oadrVenName_ = child_.text
            oadrVenName_ = self.gds_validate_string(oadrVenName_, node, "oadrVenName")
            self.oadrVenName = oadrVenName_
        elif nodeName_ == "oadrHttpPullModel":
            sval_ = child_.text
            if sval_ in ("true", "1"):
                ival_ = True
            elif sval_ in ("false", "0"):
                ival_ = False
            else:
                raise_parse_error(child_, "requires boolean")
            ival_ = self.gds_validate_boolean(ival_, node, "oadrHttpPullModel")
            self.oadrHttpPullModel = ival_


# end class oadrCreatePartyRegistrationType


class oadrCreatedPartyRegistrationType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self,
        schemaVersion=None,
        eiResponse=None,
        registrationID=None,
        venID=None,
        vtnID=None,
        oadrProfiles=None,
        oadrRequestedOadrPollFreq=None,
        oadrServiceSpecificInfo=None,
        oadrExtensions=None,
    ):
        self.original_tagname_ = None
        self.schemaVersion = _cast(None, schemaVersion)
        self.eiResponse = eiResponse
        self.registrationID = registrationID
        self.venID = venID
        self.vtnID = vtnID
        self.oadrProfiles = oadrProfiles
        self.oadrRequestedOadrPollFreq = oadrRequestedOadrPollFreq
        self.oadrServiceSpecificInfo = oadrServiceSpecificInfo
        self.oadrExtensions = oadrExtensions

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, oadrCreatedPartyRegistrationType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrCreatedPartyRegistrationType.subclass:
            return oadrCreatedPartyRegistrationType.subclass(*args_, **kwargs_)
        else:
            return oadrCreatedPartyRegistrationType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_eiResponse(self):
        return self.eiResponse

    def set_eiResponse(self, eiResponse):
        self.eiResponse = eiResponse

    def get_registrationID(self):
        return self.registrationID

    def set_registrationID(self, registrationID):
        self.registrationID = registrationID

    def get_venID(self):
        return self.venID

    def set_venID(self, venID):
        self.venID = venID

    def get_vtnID(self):
        return self.vtnID

    def set_vtnID(self, vtnID):
        self.vtnID = vtnID

    def get_oadrProfiles(self):
        return self.oadrProfiles

    def set_oadrProfiles(self, oadrProfiles):
        self.oadrProfiles = oadrProfiles

    def get_oadrRequestedOadrPollFreq(self):
        return self.oadrRequestedOadrPollFreq

    def set_oadrRequestedOadrPollFreq(self, oadrRequestedOadrPollFreq):
        self.oadrRequestedOadrPollFreq = oadrRequestedOadrPollFreq

    def get_oadrServiceSpecificInfo(self):
        return self.oadrServiceSpecificInfo

    def set_oadrServiceSpecificInfo(self, oadrServiceSpecificInfo):
        self.oadrServiceSpecificInfo = oadrServiceSpecificInfo

    def get_oadrExtensions(self):
        return self.oadrExtensions

    def set_oadrExtensions(self, oadrExtensions):
        self.oadrExtensions = oadrExtensions

    def get_schemaVersion(self):
        return self.schemaVersion

    def set_schemaVersion(self, schemaVersion):
        self.schemaVersion = schemaVersion

    def hasContent_(self):
        if (
            self.eiResponse is not None
            or self.registrationID is not None
            or self.venID is not None
            or self.vtnID is not None
            or self.oadrProfiles is not None
            or self.oadrRequestedOadrPollFreq is not None
            or self.oadrServiceSpecificInfo is not None
            or self.oadrExtensions is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrCreatedPartyRegistrationType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get(
            "oadrCreatedPartyRegistrationType"
        )
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespace_,
            name_="oadrCreatedPartyRegistrationType",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrCreatedPartyRegistrationType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrCreatedPartyRegistrationType",
    ):
        if self.schemaVersion is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            outfile.write(" schemaVersion=%s" % (quote_attrib(self.schemaVersion),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrCreatedPartyRegistrationType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.eiResponse is not None:
            self.eiResponse.export(
                outfile,
                level,
                namespace_="ei:",
                name_="eiResponse",
                pretty_print=pretty_print,
            )
        if self.registrationID is not None:
            self.registrationID.export(
                outfile,
                level,
                namespace_="ei:",
                name_="registrationID",
                pretty_print=pretty_print,
            )
        if self.venID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:venID>%s</ei:venID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.venID), input_name="venID"
                        )
                    ),
                    eol_,
                )
            )
        if self.vtnID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:vtnID>%s</ei:vtnID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.vtnID), input_name="vtnID"
                        )
                    ),
                    eol_,
                )
            )
        if self.oadrProfiles is not None:
            self.oadrProfiles.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrProfiles",
                pretty_print=pretty_print,
            )
        if self.oadrRequestedOadrPollFreq is not None:
            self.oadrRequestedOadrPollFreq.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrRequestedOadrPollFreq",
                pretty_print=pretty_print,
            )
        if self.oadrServiceSpecificInfo is not None:
            self.oadrServiceSpecificInfo.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrServiceSpecificInfo",
                pretty_print=pretty_print,
            )
        if self.oadrExtensions is not None:
            self.oadrExtensions.export(
                outfile,
                level,
                namespace_,
                name_="oadrExtensions",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("schemaVersion", node)
        if value is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            self.schemaVersion = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "eiResponse":
            obj_ = EiResponseType.factory()
            obj_.build(child_)
            self.eiResponse = obj_
            obj_.original_tagname_ = "eiResponse"
        elif nodeName_ == "registrationID":
            obj_ = registrationID.factory()
            obj_.build(child_)
            self.registrationID = obj_
            obj_.original_tagname_ = "registrationID"
        elif nodeName_ == "venID":
            venID_ = child_.text
            venID_ = self.gds_validate_string(venID_, node, "venID")
            self.venID = venID_
        elif nodeName_ == "vtnID":
            vtnID_ = child_.text
            vtnID_ = self.gds_validate_string(vtnID_, node, "vtnID")
            self.vtnID = vtnID_
        elif nodeName_ == "oadrProfiles":
            obj_ = oadrProfiles.factory()
            obj_.build(child_)
            self.oadrProfiles = obj_
            obj_.original_tagname_ = "oadrProfiles"
        elif nodeName_ == "oadrRequestedOadrPollFreq":
            obj_ = DurationPropType.factory()
            obj_.build(child_)
            self.oadrRequestedOadrPollFreq = obj_
            obj_.original_tagname_ = "oadrRequestedOadrPollFreq"
        elif nodeName_ == "oadrServiceSpecificInfo":
            obj_ = oadrServiceSpecificInfo.factory()
            obj_.build(child_)
            self.oadrServiceSpecificInfo = obj_
            obj_.original_tagname_ = "oadrServiceSpecificInfo"
        elif nodeName_ == "oadrExtensions":
            obj_ = oadrExtensionsType.factory()
            obj_.build(child_)
            self.oadrExtensions = obj_
            obj_.original_tagname_ = "oadrExtensions"


# end class oadrCreatedPartyRegistrationType


class oadrRequestReregistrationType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, schemaVersion=None, venID=None):
        self.original_tagname_ = None
        self.schemaVersion = _cast(None, schemaVersion)
        self.venID = venID

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, oadrRequestReregistrationType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrRequestReregistrationType.subclass:
            return oadrRequestReregistrationType.subclass(*args_, **kwargs_)
        else:
            return oadrRequestReregistrationType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_venID(self):
        return self.venID

    def set_venID(self, venID):
        self.venID = venID

    def get_schemaVersion(self):
        return self.schemaVersion

    def set_schemaVersion(self, schemaVersion):
        self.schemaVersion = schemaVersion

    def hasContent_(self):
        if self.venID is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrRequestReregistrationType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrRequestReregistrationType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespace_,
            name_="oadrRequestReregistrationType",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrRequestReregistrationType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrRequestReregistrationType",
    ):
        if self.schemaVersion is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            outfile.write(" schemaVersion=%s" % (quote_attrib(self.schemaVersion),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrRequestReregistrationType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.venID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:venID>%s</ei:venID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.venID), input_name="venID"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("schemaVersion", node)
        if value is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            self.schemaVersion = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "venID":
            venID_ = child_.text
            venID_ = self.gds_validate_string(venID_, node, "venID")
            self.venID = venID_


# end class oadrRequestReregistrationType


class oadrQueryRegistrationType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, schemaVersion=None, requestID=None):
        self.original_tagname_ = None
        self.schemaVersion = _cast(None, schemaVersion)
        self.requestID = requestID

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, oadrQueryRegistrationType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrQueryRegistrationType.subclass:
            return oadrQueryRegistrationType.subclass(*args_, **kwargs_)
        else:
            return oadrQueryRegistrationType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_requestID(self):
        return self.requestID

    def set_requestID(self, requestID):
        self.requestID = requestID

    def get_schemaVersion(self):
        return self.schemaVersion

    def set_schemaVersion(self, schemaVersion):
        self.schemaVersion = schemaVersion

    def hasContent_(self):
        if self.requestID is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrQueryRegistrationType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:pyld="http://docs.oasis-open.org/ns/energyinterop/201110/payloads" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrQueryRegistrationType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespace_,
            name_="oadrQueryRegistrationType",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrQueryRegistrationType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrQueryRegistrationType",
    ):
        if self.schemaVersion is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            outfile.write(" schemaVersion=%s" % (quote_attrib(self.schemaVersion),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrQueryRegistrationType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.requestID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<pyld:requestID>%s</pyld:requestID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.requestID), input_name="requestID"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("schemaVersion", node)
        if value is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            self.schemaVersion = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "requestID":
            requestID_ = child_.text
            requestID_ = self.gds_validate_string(requestID_, node, "requestID")
            self.requestID = requestID_


# end class oadrQueryRegistrationType


class oadrPollType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, schemaVersion=None, venID=None):
        self.original_tagname_ = None
        self.schemaVersion = _cast(None, schemaVersion)
        self.venID = venID

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, oadrPollType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrPollType.subclass:
            return oadrPollType.subclass(*args_, **kwargs_)
        else:
            return oadrPollType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_venID(self):
        return self.venID

    def set_venID(self, venID):
        self.venID = venID

    def get_schemaVersion(self):
        return self.schemaVersion

    def set_schemaVersion(self, schemaVersion):
        self.schemaVersion = schemaVersion

    def hasContent_(self):
        if self.venID is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrPollType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrPollType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="oadrPollType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrPollType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrPollType",
    ):
        if self.schemaVersion is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            outfile.write(" schemaVersion=%s" % (quote_attrib(self.schemaVersion),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrPollType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.venID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:venID>%s</ei:venID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.venID), input_name="venID"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("schemaVersion", node)
        if value is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            self.schemaVersion = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "venID":
            venID_ = child_.text
            venID_ = self.gds_validate_string(venID_, node, "venID")
            self.venID = venID_


# end class oadrPollType


class oadrProfiles(GeneratedsSuper):
    """OpenADR profiles supported by the implementation"""

    subclass = None
    superclass = None

    def __init__(self, oadrProfile=None):
        self.original_tagname_ = None
        if oadrProfile is None:
            self.oadrProfile = []
        else:
            self.oadrProfile = oadrProfile

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, oadrProfiles)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrProfiles.subclass:
            return oadrProfiles.subclass(*args_, **kwargs_)
        else:
            return oadrProfiles(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_oadrProfile(self):
        return self.oadrProfile

    def set_oadrProfile(self, oadrProfile):
        self.oadrProfile = oadrProfile

    def add_oadrProfile(self, value):
        self.oadrProfile.append(value)

    def insert_oadrProfile_at(self, index, value):
        self.oadrProfile.insert(index, value)

    def replace_oadrProfile_at(self, index, value):
        self.oadrProfile[index] = value

    def hasContent_(self):
        if self.oadrProfile:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrProfiles",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrProfiles")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="oadrProfiles"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrProfiles",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrProfiles",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrProfiles",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for oadrProfile_ in self.oadrProfile:
            oadrProfile_.export(
                outfile,
                level,
                namespace_,
                name_="oadrProfile",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "oadrProfile":
            obj_ = oadrProfileType1.factory()
            obj_.build(child_)
            self.oadrProfile.append(obj_)
            obj_.original_tagname_ = "oadrProfile"


# end class oadrProfiles


class oadrTransports(GeneratedsSuper):
    """OpenADR transports supported by implementation"""

    subclass = None
    superclass = None

    def __init__(self, oadrTransport=None):
        self.original_tagname_ = None
        if oadrTransport is None:
            self.oadrTransport = []
        else:
            self.oadrTransport = oadrTransport

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, oadrTransports)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrTransports.subclass:
            return oadrTransports.subclass(*args_, **kwargs_)
        else:
            return oadrTransports(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_oadrTransport(self):
        return self.oadrTransport

    def set_oadrTransport(self, oadrTransport):
        self.oadrTransport = oadrTransport

    def add_oadrTransport(self, value):
        self.oadrTransport.append(value)

    def insert_oadrTransport_at(self, index, value):
        self.oadrTransport.insert(index, value)

    def replace_oadrTransport_at(self, index, value):
        self.oadrTransport[index] = value

    def hasContent_(self):
        if self.oadrTransport:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrTransports",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrTransports")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="oadrTransports"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrTransports",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrTransports",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrTransports",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for oadrTransport_ in self.oadrTransport:
            oadrTransport_.export(
                outfile,
                level,
                namespace_,
                name_="oadrTransport",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "oadrTransport":
            obj_ = oadrTransportType2.factory()
            obj_.build(child_)
            self.oadrTransport.append(obj_)
            obj_.original_tagname_ = "oadrTransport"


# end class oadrTransports


class oadrServiceSpecificInfo(GeneratedsSuper):
    """Service specific registration information"""

    subclass = None
    superclass = None

    def __init__(self, oadrService=None):
        self.original_tagname_ = None
        if oadrService is None:
            self.oadrService = []
        else:
            self.oadrService = oadrService

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, oadrServiceSpecificInfo
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrServiceSpecificInfo.subclass:
            return oadrServiceSpecificInfo.subclass(*args_, **kwargs_)
        else:
            return oadrServiceSpecificInfo(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_oadrService(self):
        return self.oadrService

    def set_oadrService(self, oadrService):
        self.oadrService = oadrService

    def add_oadrService(self, value):
        self.oadrService.append(value)

    def insert_oadrService_at(self, index, value):
        self.oadrService.insert(index, value)

    def replace_oadrService_at(self, index, value):
        self.oadrService[index] = value

    def hasContent_(self):
        if self.oadrService:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrServiceSpecificInfo",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrServiceSpecificInfo")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespace_,
            name_="oadrServiceSpecificInfo",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrServiceSpecificInfo",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrServiceSpecificInfo",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrServiceSpecificInfo",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for oadrService_ in self.oadrService:
            oadrService_.export(
                outfile,
                level,
                namespace_,
                name_="oadrService",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "oadrService":
            obj_ = oadrServiceType.factory()
            obj_.build(child_)
            self.oadrService.append(obj_)
            obj_.original_tagname_ = "oadrService"


# end class oadrServiceSpecificInfo


class oadrInfo(GeneratedsSuper):
    """A key value pair of service specific registration information"""

    subclass = None
    superclass = None

    def __init__(self, oadrKey=None, oadrValue=None):
        self.original_tagname_ = None
        self.oadrKey = oadrKey
        self.oadrValue = oadrValue

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, oadrInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrInfo.subclass:
            return oadrInfo.subclass(*args_, **kwargs_)
        else:
            return oadrInfo(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_oadrKey(self):
        return self.oadrKey

    def set_oadrKey(self, oadrKey):
        self.oadrKey = oadrKey

    def get_oadrValue(self):
        return self.oadrValue

    def set_oadrValue(self, oadrValue):
        self.oadrValue = oadrValue

    def hasContent_(self):
        if self.oadrKey is not None or self.oadrValue is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrInfo",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrInfo")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="oadrInfo"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrInfo",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="oadr:", name_="oadrInfo"
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrInfo",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.oadrKey is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<oadr:oadrKey>%s</oadr:oadrKey>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.oadrKey), input_name="oadrKey"
                        )
                    ),
                    eol_,
                )
            )
        if self.oadrValue is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<oadr:oadrValue>%s</oadr:oadrValue>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.oadrValue), input_name="oadrValue"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "oadrKey":
            oadrKey_ = child_.text
            oadrKey_ = self.gds_validate_string(oadrKey_, node, "oadrKey")
            self.oadrKey = oadrKey_
        elif nodeName_ == "oadrValue":
            oadrValue_ = child_.text
            oadrValue_ = self.gds_validate_string(oadrValue_, node, "oadrValue")
            self.oadrValue = oadrValue_


# end class oadrInfo


class oadrPendingReportsType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, reportRequestID=None):
        self.original_tagname_ = None
        if reportRequestID is None:
            self.reportRequestID = []
        else:
            self.reportRequestID = reportRequestID

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, oadrPendingReportsType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrPendingReportsType.subclass:
            return oadrPendingReportsType.subclass(*args_, **kwargs_)
        else:
            return oadrPendingReportsType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_reportRequestID(self):
        return self.reportRequestID

    def set_reportRequestID(self, reportRequestID):
        self.reportRequestID = reportRequestID

    def add_reportRequestID(self, value):
        self.reportRequestID.append(value)

    def insert_reportRequestID_at(self, index, value):
        self.reportRequestID.insert(index, value)

    def replace_reportRequestID_at(self, index, value):
        self.reportRequestID[index] = value

    def hasContent_(self):
        if self.reportRequestID:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrPendingReportsType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrPendingReportsType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespace_,
            name_="oadrPendingReportsType",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrPendingReportsType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrPendingReportsType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrPendingReportsType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for reportRequestID_ in self.reportRequestID:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:reportRequestID>%s</ei:reportRequestID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(reportRequestID_), input_name="reportRequestID"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "reportRequestID":
            reportRequestID_ = child_.text
            reportRequestID_ = self.gds_validate_string(
                reportRequestID_, node, "reportRequestID"
            )
            self.reportRequestID.append(reportRequestID_)


# end class oadrPendingReportsType


class oadrReportRequestType(GeneratedsSuper):
    """This type is used to request an EiReport"""

    subclass = None
    superclass = None

    def __init__(self, reportRequestID=None, reportSpecifier=None):
        self.original_tagname_ = None
        self.reportRequestID = reportRequestID
        self.reportSpecifier = reportSpecifier

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, oadrReportRequestType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrReportRequestType.subclass:
            return oadrReportRequestType.subclass(*args_, **kwargs_)
        else:
            return oadrReportRequestType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_reportRequestID(self):
        return self.reportRequestID

    def set_reportRequestID(self, reportRequestID):
        self.reportRequestID = reportRequestID

    def get_reportSpecifier(self):
        return self.reportSpecifier

    def set_reportSpecifier(self, reportSpecifier):
        self.reportSpecifier = reportSpecifier

    def hasContent_(self):
        if self.reportRequestID is not None or self.reportSpecifier is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrReportRequestType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrReportRequestType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="oadrReportRequestType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrReportRequestType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrReportRequestType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrReportRequestType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.reportRequestID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:reportRequestID>%s</ei:reportRequestID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.reportRequestID),
                            input_name="reportRequestID",
                        )
                    ),
                    eol_,
                )
            )
        if self.reportSpecifier is not None:
            self.reportSpecifier.export(
                outfile,
                level,
                namespace_="ei:",
                name_="reportSpecifier",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "reportRequestID":
            reportRequestID_ = child_.text
            reportRequestID_ = self.gds_validate_string(
                reportRequestID_, node, "reportRequestID"
            )
            self.reportRequestID = reportRequestID_
        elif nodeName_ == "reportSpecifier":
            obj_ = ReportSpecifierType.factory()
            obj_.build(child_)
            self.reportSpecifier = obj_
            obj_.original_tagname_ = "reportSpecifier"


# end class oadrReportRequestType


class oadrReportDescriptionType(GeneratedsSuper):
    """Describes the subject and attributes of a report."""

    subclass = None
    superclass = None

    def __init__(
        self,
        rID=None,
        reportSubject=None,
        reportDataSource=None,
        reportType=None,
        itemBase=None,
        readingType=None,
        marketContext=None,
        oadrSamplingRate=None,
    ):
        self.original_tagname_ = None
        self.rID = rID
        self.reportSubject = reportSubject
        self.reportDataSource = reportDataSource
        self.reportType = reportType
        self.itemBase = itemBase
        self.readingType = readingType
        self.marketContext = marketContext
        self.oadrSamplingRate = oadrSamplingRate

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, oadrReportDescriptionType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrReportDescriptionType.subclass:
            return oadrReportDescriptionType.subclass(*args_, **kwargs_)
        else:
            return oadrReportDescriptionType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_rID(self):
        return self.rID

    def set_rID(self, rID):
        self.rID = rID

    def get_reportSubject(self):
        return self.reportSubject

    def set_reportSubject(self, reportSubject):
        self.reportSubject = reportSubject

    def get_reportDataSource(self):
        return self.reportDataSource

    def set_reportDataSource(self, reportDataSource):
        self.reportDataSource = reportDataSource

    def get_reportType(self):
        return self.reportType

    def set_reportType(self, reportType):
        self.reportType = reportType

    def get_itemBase(self):
        return self.itemBase

    def set_itemBase(self, itemBase):
        self.itemBase = itemBase

    def get_readingType(self):
        return self.readingType

    def set_readingType(self, readingType):
        self.readingType = readingType

    def get_marketContext(self):
        return self.marketContext

    def set_marketContext(self, marketContext):
        self.marketContext = marketContext

    def get_oadrSamplingRate(self):
        return self.oadrSamplingRate

    def set_oadrSamplingRate(self, oadrSamplingRate):
        self.oadrSamplingRate = oadrSamplingRate

    def hasContent_(self):
        if (
            self.rID is not None
            or self.reportSubject is not None
            or self.reportDataSource is not None
            or self.reportType is not None
            or self.itemBase is not None
            or self.readingType is not None
            or self.marketContext is not None
            or self.oadrSamplingRate is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrReportDescriptionType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110"  xmlns:emix="http://docs.oasis-open.org/ns/emix/2011/06" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrReportDescriptionType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespace_,
            name_="oadrReportDescriptionType",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrReportDescriptionType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrReportDescriptionType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrReportDescriptionType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.rID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:rID>%s</ei:rID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.rID), input_name="rID")
                    ),
                    eol_,
                )
            )
        if self.reportSubject is not None:
            self.reportSubject.export(
                outfile,
                level,
                namespace_="ei:",
                name_="reportSubject",
                pretty_print=pretty_print,
            )
        if self.reportDataSource is not None:
            self.reportDataSource.export(
                outfile,
                level,
                namespace_="ei:",
                name_="reportDataSource",
                pretty_print=pretty_print,
            )
        if self.reportType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:reportType>%s</ei:reportType>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.reportType), input_name="reportType"
                        )
                    ),
                    eol_,
                )
            )
        if self.itemBase is not None:
            self.itemBase.export(outfile, level, namespace_, pretty_print=pretty_print)
        if self.readingType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:readingType>%s</ei:readingType>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.readingType), input_name="readingType"
                        )
                    ),
                    eol_,
                )
            )
        if self.marketContext is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<emix:marketContext>%s</emix:marketContext>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.marketContext), input_name="marketContext"
                        )
                    ),
                    eol_,
                )
            )
        if self.oadrSamplingRate is not None:
            self.oadrSamplingRate.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrSamplingRate",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "rID":
            rID_ = child_.text
            rID_ = self.gds_validate_string(rID_, node, "rID")
            self.rID = rID_
        elif nodeName_ == "reportSubject":
            obj_ = EiTargetType.factory()
            obj_.build(child_)
            self.reportSubject = obj_
            obj_.original_tagname_ = "reportSubject"
        elif nodeName_ == "reportDataSource":
            obj_ = EiTargetType.factory()
            obj_.build(child_)
            self.reportDataSource = obj_
            obj_.original_tagname_ = "reportDataSource"
        elif nodeName_ == "reportType":
            reportType_ = child_.text
            reportType_ = self.gds_validate_string(reportType_, node, "reportType")
            self.reportType = reportType_
        elif nodeName_ == "itemBase":
            type_name_ = child_.attrib.get(
                "{http://www.w3.org/2001/XMLSchema-instance}type"
            )
            if type_name_ is None:
                type_name_ = child_.attrib.get("type")
            if type_name_ is not None:
                type_names_ = type_name_.split(":")
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    "Class not implemented for <itemBase> element"
                )
            self.itemBase = obj_
            obj_.original_tagname_ = "itemBase"
        elif nodeName_ == "customUnit":
            obj_ = BaseUnitType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "customUnit"
        elif nodeName_ == "current":
            obj_ = CurrentType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "current"
        elif nodeName_ == "currency":
            obj_ = currencyType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "currency"
        elif nodeName_ == "currencyPerKWh":
            obj_ = currencyType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "currencyPerKWh"
        elif nodeName_ == "currencyPerKW":
            obj_ = currencyType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "currencyPerKW"
        elif nodeName_ == "currencyPerThm":
            obj_ = currencyType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "currencyPerThm"
        elif nodeName_ == "frequency":
            obj_ = FrequencyType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "frequency"
        elif nodeName_ == "Therm":
            obj_ = ThermType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "Therm"
        elif nodeName_ == "temperature":
            obj_ = temperatureType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "temperature"
        elif nodeName_ == "pulseCount":
            obj_ = pulseCountType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "pulseCount"
        elif nodeName_ == "oadrGBDataDescription":
            obj_ = oadrGBItemBase.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "oadrGBDataDescription"
        elif nodeName_ == "voltage":
            obj_ = VoltageType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "voltage"
        elif nodeName_ == "energyItem":
            type_name_ = child_.attrib.get(
                "{http://www.w3.org/2001/XMLSchema-instance}type"
            )
            if type_name_ is None:
                type_name_ = child_.attrib.get("type")
            if type_name_ is not None:
                type_names_ = type_name_.split(":")
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    "Class not implemented for <energyItem> element"
                )
            self.itemBase = obj_
            obj_.original_tagname_ = "energyItem"
        elif nodeName_ == "powerItem":
            type_name_ = child_.attrib.get(
                "{http://www.w3.org/2001/XMLSchema-instance}type"
            )
            if type_name_ is None:
                type_name_ = child_.attrib.get("type")
            if type_name_ is not None:
                type_names_ = type_name_.split(":")
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    "Class not implemented for <powerItem> element"
                )
            self.itemBase = obj_
            obj_.original_tagname_ = "powerItem"
        elif nodeName_ == "energyApparent":
            obj_ = EnergyApparentType.factory()
            obj_.build(child_)
            self.energyItem = obj_
            obj_.original_tagname_ = "energyApparent"
        elif nodeName_ == "energyReactive":
            obj_ = EnergyReactiveType.factory()
            obj_.build(child_)
            self.energyItem = obj_
            obj_.original_tagname_ = "energyReactive"
        elif nodeName_ == "energyReal":
            obj_ = EnergyRealType.factory()
            obj_.build(child_)
            self.energyItem = obj_
            obj_.original_tagname_ = "energyReal"
        elif nodeName_ == "powerApparent":
            obj_ = PowerApparentType.factory()
            obj_.build(child_)
            self.powerItem = obj_
            obj_.original_tagname_ = "powerApparent"
        elif nodeName_ == "powerReactive":
            obj_ = PowerReactiveType.factory()
            obj_.build(child_)
            self.powerItem = obj_
            obj_.original_tagname_ = "powerReactive"
        elif nodeName_ == "powerReal":
            obj_ = PowerRealType.factory()
            obj_.build(child_)
            self.powerItem = obj_
            obj_.original_tagname_ = "powerReal"
        elif nodeName_ == "readingType":
            readingType_ = child_.text
            readingType_ = self.gds_validate_string(readingType_, node, "readingType")
            self.readingType = readingType_
        elif nodeName_ == "marketContext":
            marketContext_ = child_.text
            marketContext_ = self.gds_validate_string(
                marketContext_, node, "marketContext"
            )
            self.marketContext = marketContext_
        elif nodeName_ == "oadrSamplingRate":
            obj_ = oadrSamplingRateType.factory()
            obj_.build(child_)
            self.oadrSamplingRate = obj_
            obj_.original_tagname_ = "oadrSamplingRate"


# end class oadrReportDescriptionType


class oadrSamplingRateType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, oadrMinPeriod=None, oadrMaxPeriod=None, oadrOnChange=None):
        self.original_tagname_ = None
        self.oadrMinPeriod = oadrMinPeriod
        self.validate_DurationValueType(self.oadrMinPeriod)
        self.oadrMaxPeriod = oadrMaxPeriod
        self.validate_DurationValueType(self.oadrMaxPeriod)
        self.oadrOnChange = oadrOnChange

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, oadrSamplingRateType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrSamplingRateType.subclass:
            return oadrSamplingRateType.subclass(*args_, **kwargs_)
        else:
            return oadrSamplingRateType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_oadrMinPeriod(self):
        return self.oadrMinPeriod

    def set_oadrMinPeriod(self, oadrMinPeriod):
        self.oadrMinPeriod = oadrMinPeriod

    def get_oadrMaxPeriod(self):
        return self.oadrMaxPeriod

    def set_oadrMaxPeriod(self, oadrMaxPeriod):
        self.oadrMaxPeriod = oadrMaxPeriod

    def get_oadrOnChange(self):
        return self.oadrOnChange

    def set_oadrOnChange(self, oadrOnChange):
        self.oadrOnChange = oadrOnChange

    def validate_DurationValueType(self, value):
        # Validate type DurationValueType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_DurationValueType_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (value.encode("utf-8"), self.validate_DurationValueType_patterns_)
                )

    validate_DurationValueType_patterns_ = [
        [
            "^(\\+$|^\\-)?P((\\d+Y)?(\\d+M)?(\\d+D)?T?(\\d+H)?(\\d+M)?(\\d+S)?)$|^(\\d+W)$"
        ]
    ]

    def hasContent_(self):
        if (
            self.oadrMinPeriod is not None
            or self.oadrMaxPeriod is not None
            or self.oadrOnChange is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrSamplingRateType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:xcal="urn:ietf:params:xml:ns:icalendar-2.0" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrSamplingRateType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="oadrSamplingRateType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrSamplingRateType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrSamplingRateType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrSamplingRateType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.oadrMinPeriod is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<oadr:oadrMinPeriod>%s</oadr:oadrMinPeriod>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.oadrMinPeriod), input_name="oadrMinPeriod"
                        )
                    ),
                    eol_,
                )
            )
        if self.oadrMaxPeriod is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<oadr:oadrMaxPeriod>%s</oadr:oadrMaxPeriod>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.oadrMaxPeriod), input_name="oadrMaxPeriod"
                        )
                    ),
                    eol_,
                )
            )
        if self.oadrOnChange is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<oadr:oadrOnChange>%s</oadr:oadrOnChange>%s"
                % (
                    self.gds_format_boolean(
                        self.oadrOnChange, input_name="oadrOnChange"
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "oadrMinPeriod":
            oadrMinPeriod_ = child_.text
            oadrMinPeriod_ = self.gds_validate_string(
                oadrMinPeriod_, node, "oadrMinPeriod"
            )
            self.oadrMinPeriod = oadrMinPeriod_
            # validate type DurationValueType
            self.validate_DurationValueType(self.oadrMinPeriod)
        elif nodeName_ == "oadrMaxPeriod":
            oadrMaxPeriod_ = child_.text
            oadrMaxPeriod_ = self.gds_validate_string(
                oadrMaxPeriod_, node, "oadrMaxPeriod"
            )
            self.oadrMaxPeriod = oadrMaxPeriod_
            # validate type DurationValueType
            self.validate_DurationValueType(self.oadrMaxPeriod)
        elif nodeName_ == "oadrOnChange":
            sval_ = child_.text
            if sval_ in ("true", "1"):
                ival_ = True
            elif sval_ in ("false", "0"):
                ival_ = False
            else:
                raise_parse_error(child_, "requires boolean")
            ival_ = self.gds_validate_boolean(ival_, node, "oadrOnChange")
            self.oadrOnChange = ival_


# end class oadrSamplingRateType


class oadrLoadControlStateType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self,
        oadrCapacity=None,
        oadrLevelOffset=None,
        oadrPercentOffset=None,
        oadrSetPoint=None,
    ):
        self.original_tagname_ = None
        self.oadrCapacity = oadrCapacity
        self.oadrLevelOffset = oadrLevelOffset
        self.oadrPercentOffset = oadrPercentOffset
        self.oadrSetPoint = oadrSetPoint

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, oadrLoadControlStateType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrLoadControlStateType.subclass:
            return oadrLoadControlStateType.subclass(*args_, **kwargs_)
        else:
            return oadrLoadControlStateType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_oadrCapacity(self):
        return self.oadrCapacity

    def set_oadrCapacity(self, oadrCapacity):
        self.oadrCapacity = oadrCapacity

    def get_oadrLevelOffset(self):
        return self.oadrLevelOffset

    def set_oadrLevelOffset(self, oadrLevelOffset):
        self.oadrLevelOffset = oadrLevelOffset

    def get_oadrPercentOffset(self):
        return self.oadrPercentOffset

    def set_oadrPercentOffset(self, oadrPercentOffset):
        self.oadrPercentOffset = oadrPercentOffset

    def get_oadrSetPoint(self):
        return self.oadrSetPoint

    def set_oadrSetPoint(self, oadrSetPoint):
        self.oadrSetPoint = oadrSetPoint

    def hasContent_(self):
        if (
            self.oadrCapacity is not None
            or self.oadrLevelOffset is not None
            or self.oadrPercentOffset is not None
            or self.oadrSetPoint is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrLoadControlStateType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrLoadControlStateType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespace_,
            name_="oadrLoadControlStateType",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrLoadControlStateType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrLoadControlStateType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrLoadControlStateType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.oadrCapacity is not None:
            self.oadrCapacity.export(
                outfile,
                level,
                namespace_,
                name_="oadrCapacity",
                pretty_print=pretty_print,
            )
        if self.oadrLevelOffset is not None:
            self.oadrLevelOffset.export(
                outfile,
                level,
                namespace_,
                name_="oadrLevelOffset",
                pretty_print=pretty_print,
            )
        if self.oadrPercentOffset is not None:
            self.oadrPercentOffset.export(
                outfile,
                level,
                namespace_,
                name_="oadrPercentOffset",
                pretty_print=pretty_print,
            )
        if self.oadrSetPoint is not None:
            self.oadrSetPoint.export(
                outfile,
                level,
                namespace_,
                name_="oadrSetPoint",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "oadrCapacity":
            obj_ = oadrLoadControlStateTypeType.factory()
            obj_.build(child_)
            self.oadrCapacity = obj_
            obj_.original_tagname_ = "oadrCapacity"
        elif nodeName_ == "oadrLevelOffset":
            obj_ = oadrLoadControlStateTypeType.factory()
            obj_.build(child_)
            self.oadrLevelOffset = obj_
            obj_.original_tagname_ = "oadrLevelOffset"
        elif nodeName_ == "oadrPercentOffset":
            obj_ = oadrLoadControlStateTypeType.factory()
            obj_.build(child_)
            self.oadrPercentOffset = obj_
            obj_.original_tagname_ = "oadrPercentOffset"
        elif nodeName_ == "oadrSetPoint":
            obj_ = oadrLoadControlStateTypeType.factory()
            obj_.build(child_)
            self.oadrSetPoint = obj_
            obj_.original_tagname_ = "oadrSetPoint"


# end class oadrLoadControlStateType


class oadrLoadControlStateTypeType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, oadrMin=None, oadrMax=None, oadrCurrent=None, oadrNormal=None):
        self.original_tagname_ = None
        self.oadrMin = oadrMin
        self.oadrMax = oadrMax
        self.oadrCurrent = oadrCurrent
        self.oadrNormal = oadrNormal

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, oadrLoadControlStateTypeType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrLoadControlStateTypeType.subclass:
            return oadrLoadControlStateTypeType.subclass(*args_, **kwargs_)
        else:
            return oadrLoadControlStateTypeType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_oadrMin(self):
        return self.oadrMin

    def set_oadrMin(self, oadrMin):
        self.oadrMin = oadrMin

    def get_oadrMax(self):
        return self.oadrMax

    def set_oadrMax(self, oadrMax):
        self.oadrMax = oadrMax

    def get_oadrCurrent(self):
        return self.oadrCurrent

    def set_oadrCurrent(self, oadrCurrent):
        self.oadrCurrent = oadrCurrent

    def get_oadrNormal(self):
        return self.oadrNormal

    def set_oadrNormal(self, oadrNormal):
        self.oadrNormal = oadrNormal

    def hasContent_(self):
        if (
            self.oadrMin is not None
            or self.oadrMax is not None
            or self.oadrCurrent is not None
            or self.oadrNormal is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrLoadControlStateTypeType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrLoadControlStateTypeType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespace_,
            name_="oadrLoadControlStateTypeType",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrLoadControlStateTypeType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrLoadControlStateTypeType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrLoadControlStateTypeType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.oadrMin is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<oadr:oadrMin>%s</oadr:oadrMin>%s"
                % (self.gds_format_float(self.oadrMin, input_name="oadrMin"), eol_)
            )
        if self.oadrMax is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<oadr:oadrMax>%s</oadr:oadrMax>%s"
                % (self.gds_format_float(self.oadrMax, input_name="oadrMax"), eol_)
            )
        if self.oadrCurrent is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<oadr:oadrCurrent>%s</oadr:oadrCurrent>%s"
                % (
                    self.gds_format_float(self.oadrCurrent, input_name="oadrCurrent"),
                    eol_,
                )
            )
        if self.oadrNormal is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<oadr:oadrNormal>%s</oadr:oadrNormal>%s"
                % (
                    self.gds_format_float(self.oadrNormal, input_name="oadrNormal"),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "oadrMin":
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, "requires float or double: %s" % exp)
            fval_ = self.gds_validate_float(fval_, node, "oadrMin")
            self.oadrMin = fval_
        elif nodeName_ == "oadrMax":
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, "requires float or double: %s" % exp)
            fval_ = self.gds_validate_float(fval_, node, "oadrMax")
            self.oadrMax = fval_
        elif nodeName_ == "oadrCurrent":
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, "requires float or double: %s" % exp)
            fval_ = self.gds_validate_float(fval_, node, "oadrCurrent")
            self.oadrCurrent = fval_
        elif nodeName_ == "oadrNormal":
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, "requires float or double: %s" % exp)
            fval_ = self.gds_validate_float(fval_, node, "oadrNormal")
            self.oadrNormal = fval_


# end class oadrLoadControlStateTypeType


class intervals(GeneratedsSuper):
    """Time intervals during which the DR event is active or report data is
    available"""

    subclass = None
    superclass = None

    def __init__(self, interval=None):
        self.original_tagname_ = None
        if interval is None:
            self.interval = []
        else:
            self.interval = interval

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, intervals)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if intervals.subclass:
            return intervals.subclass(*args_, **kwargs_)
        else:
            return intervals(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_interval(self):
        return self.interval

    def set_interval(self, interval):
        self.interval = interval

    def add_interval(self, value):
        self.interval.append(value)

    def insert_interval_at(self, index, value):
        self.interval.insert(index, value)

    def replace_interval_at(self, index, value):
        self.interval[index] = value

    def hasContent_(self):
        if self.interval:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="strm:",
        name_="intervals",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110"  xmlns:strm="urn:ietf:params:xml:ns:icalendar-2.0:stream"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("intervals")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="intervals"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="strm:",
                name_="intervals",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="strm:", name_="intervals"
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="strm:",
        name_="intervals",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for interval_ in self.interval:
            interval_.export(
                outfile,
                level,
                namespace_="ei:",
                name_="interval",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "interval":
            obj_ = IntervalType.factory()
            obj_.build(child_)
            self.interval.append(obj_)
            obj_.original_tagname_ = "interval"


# end class intervals


class StreamPayloadBaseType(GeneratedsSuper):
    """Abstract class to convey a payload for a stream. When a Stream is
    transformed to or from a WS-Calendar Interval, the contents of
    the Stream Payload defined element are transformed into the
    contents of a WS-Calendar artifactBase."""

    subclass = None
    superclass = None

    def __init__(self, extensiontype_=None):
        self.original_tagname_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, StreamPayloadBaseType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StreamPayloadBaseType.subclass:
            return StreamPayloadBaseType.subclass(*args_, **kwargs_)
        else:
            return StreamPayloadBaseType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_extensiontype_(self):
        return self.extensiontype_

    def set_extensiontype_(self, extensiontype_):
        self.extensiontype_ = extensiontype_

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="strm:",
        name_="StreamPayloadBaseType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:strm="urn:ietf:params:xml:ns:icalendar-2.0:stream"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("StreamPayloadBaseType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="StreamPayloadBaseType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="strm:",
                name_="StreamPayloadBaseType",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="strm:",
        name_="StreamPayloadBaseType",
    ):
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="strm:",
        name_="StreamPayloadBaseType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class StreamPayloadBaseType


class StreamBaseType(GeneratedsSuper):
    """abstract base for communication of schedules for signals and
    observations"""

    subclass = None
    superclass = None

    def __init__(
        self, dtstart=None, duration=None, intervals=None, extensiontype_=None
    ):
        self.original_tagname_ = None
        self.dtstart = dtstart
        self.duration = duration
        self.intervals = intervals
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, StreamBaseType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StreamBaseType.subclass:
            return StreamBaseType.subclass(*args_, **kwargs_)
        else:
            return StreamBaseType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_dtstart(self):
        return self.dtstart

    def set_dtstart(self, dtstart):
        self.dtstart = dtstart

    def get_duration(self):
        return self.duration

    def set_duration(self, duration):
        self.duration = duration

    def get_intervals(self):
        return self.intervals

    def set_intervals(self, intervals):
        self.intervals = intervals

    def get_extensiontype_(self):
        return self.extensiontype_

    def set_extensiontype_(self, extensiontype_):
        self.extensiontype_ = extensiontype_

    def hasContent_(self):
        if (
            self.dtstart is not None
            or self.duration is not None
            or self.intervals is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="strm:",
        name_="StreamBaseType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:xcal="urn:ietf:params:xml:ns:icalendar-2.0"  xmlns:strm="urn:ietf:params:xml:ns:icalendar-2.0:stream" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("StreamBaseType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="StreamBaseType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="strm:",
                name_="StreamBaseType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="strm:",
        name_="StreamBaseType",
    ):
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="strm:",
        name_="StreamBaseType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.dtstart is not None:
            self.dtstart.export(
                outfile,
                level,
                namespace_="xcal:",
                name_="dtstart",
                pretty_print=pretty_print,
            )
        if self.duration is not None:
            self.duration.export(
                outfile,
                level,
                namespace_="xcal:",
                name_="duration",
                pretty_print=pretty_print,
            )
        if self.intervals is not None:
            self.intervals.export(
                outfile,
                level,
                namespace_="strm:",
                name_="intervals",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "dtstart":
            obj_ = dtstart.factory()
            obj_.build(child_)
            self.dtstart = obj_
            obj_.original_tagname_ = "dtstart"
        elif nodeName_ == "duration":
            obj_ = DurationPropType.factory()
            obj_.build(child_)
            self.duration = obj_
            obj_.original_tagname_ = "duration"
        elif nodeName_ == "intervals":
            obj_ = intervals.factory()
            obj_.build(child_)
            self.intervals = obj_
            obj_.original_tagname_ = "intervals"


# end class StreamBaseType


class DurationPropType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, duration=None):
        self.original_tagname_ = None
        self.duration = duration
        self.validate_DurationValueType(self.duration)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, DurationPropType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DurationPropType.subclass:
            return DurationPropType.subclass(*args_, **kwargs_)
        else:
            return DurationPropType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_duration(self):
        return self.duration

    def set_duration(self, duration):
        self.duration = duration

    def validate_DurationValueType(self, value):
        # Validate type DurationValueType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_DurationValueType_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (value.encode("utf-8"), self.validate_DurationValueType_patterns_)
                )

    validate_DurationValueType_patterns_ = [
        [
            "^(\\+$|^\\-)?P((\\d+Y)?(\\d+M)?(\\d+D)?T?(\\d+H)?(\\d+M)?(\\d+S)?)$|^(\\d+W)$"
        ]
    ]

    def hasContent_(self):
        if self.duration is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="xcal:",
        name_="DurationPropType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:xcal="urn:ietf:params:xml:ns:icalendar-2.0" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("DurationPropType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="DurationPropType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="xcal:",
                name_="DurationPropType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="xcal:",
        name_="DurationPropType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="xcal:",
        name_="DurationPropType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.duration is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<xcal:duration>%s</xcal:duration>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.duration), input_name="duration"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "duration":
            duration_ = child_.text
            duration_ = self.gds_validate_string(duration_, node, "duration")
            self.duration = duration_
            # validate type DurationValueType
            self.validate_DurationValueType(self.duration)


# end class DurationPropType


class dtstart(GeneratedsSuper):
    """The starting time for the activity, data, or state change"""

    subclass = None
    superclass = None

    def __init__(self, date_time=None):
        self.original_tagname_ = None
        if isinstance(date_time, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(date_time, "%Y-%m-%dT%H:%M:%S")
        else:
            initvalue_ = date_time
        self.date_time = initvalue_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, dtstart)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if dtstart.subclass:
            return dtstart.subclass(*args_, **kwargs_)
        else:
            return dtstart(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_date_time(self):
        return self.date_time

    def set_date_time(self, date_time):
        self.date_time = date_time

    def hasContent_(self):
        if self.date_time is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="xcal:",
        name_="dtstart",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:xcal="urn:ietf:params:xml:ns:icalendar-2.0" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("dtstart")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="dtstart"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="xcal:",
                name_="dtstart",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="xcal:", name_="dtstart"
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="xcal:",
        name_="dtstart",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.date_time is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<xcal:date-time>%s</xcal:date-time>%s"
                % (
                    self.gds_format_datetime(self.date_time, input_name="date-time"),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "date-time":
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.date_time = dval_


# end class dtstart


class properties(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self,
        dtstart=None,
        duration=None,
        tolerance=None,
        x_eiNotification=None,
        x_eiRampUp=None,
        x_eiRecovery=None,
    ):
        self.original_tagname_ = None
        self.dtstart = dtstart
        self.duration = duration
        self.tolerance = tolerance
        self.x_eiNotification = x_eiNotification
        self.x_eiRampUp = x_eiRampUp
        self.x_eiRecovery = x_eiRecovery

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, properties)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if properties.subclass:
            return properties.subclass(*args_, **kwargs_)
        else:
            return properties(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_dtstart(self):
        return self.dtstart

    def set_dtstart(self, dtstart):
        self.dtstart = dtstart

    def get_duration(self):
        return self.duration

    def set_duration(self, duration):
        self.duration = duration

    def get_tolerance(self):
        return self.tolerance

    def set_tolerance(self, tolerance):
        self.tolerance = tolerance

    def get_x_eiNotification(self):
        return self.x_eiNotification

    def set_x_eiNotification(self, x_eiNotification):
        self.x_eiNotification = x_eiNotification

    def get_x_eiRampUp(self):
        return self.x_eiRampUp

    def set_x_eiRampUp(self, x_eiRampUp):
        self.x_eiRampUp = x_eiRampUp

    def get_x_eiRecovery(self):
        return self.x_eiRecovery

    def set_x_eiRecovery(self, x_eiRecovery):
        self.x_eiRecovery = x_eiRecovery

    def hasContent_(self):
        if (
            self.dtstart is not None
            or self.duration is not None
            or self.tolerance is not None
            or self.x_eiNotification is not None
            or self.x_eiRampUp is not None
            or self.x_eiRecovery is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="xcal:",
        name_="properties",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:xcal="urn:ietf:params:xml:ns:icalendar-2.0"  xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("properties")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="properties"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="xcal:",
                name_="properties",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="xcal:", name_="properties"
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="xcal:",
        name_="properties",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.dtstart is not None:
            self.dtstart.export(
                outfile,
                level,
                namespace_="xcal:",
                name_="dtstart",
                pretty_print=pretty_print,
            )
        if self.duration is not None:
            self.duration.export(
                outfile,
                level,
                namespace_="xcal:",
                name_="duration",
                pretty_print=pretty_print,
            )
        if self.tolerance is not None:
            self.tolerance.export(
                outfile, level, namespace_, name_="tolerance", pretty_print=pretty_print
            )
        if self.x_eiNotification is not None:
            self.x_eiNotification.export(
                outfile,
                level,
                namespace_="ei:",
                name_="x-eiNotification",
                pretty_print=pretty_print,
            )
        if self.x_eiRampUp is not None:
            self.x_eiRampUp.export(
                outfile,
                level,
                namespace_="ei:",
                name_="x-eiRampUp",
                pretty_print=pretty_print,
            )
        if self.x_eiRecovery is not None:
            self.x_eiRecovery.export(
                outfile,
                level,
                namespace_="ei:",
                name_="x-eiRecovery",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "dtstart":
            obj_ = dtstart.factory()
            obj_.build(child_)
            self.dtstart = obj_
            obj_.original_tagname_ = "dtstart"
        elif nodeName_ == "duration":
            obj_ = DurationPropType.factory()
            obj_.build(child_)
            self.duration = obj_
            obj_.original_tagname_ = "duration"
        elif nodeName_ == "tolerance":
            obj_ = toleranceType.factory()
            obj_.build(child_)
            self.tolerance = obj_
            obj_.original_tagname_ = "tolerance"
        elif nodeName_ == "x-eiNotification":
            obj_ = DurationPropType.factory()
            obj_.build(child_)
            self.x_eiNotification = obj_
            obj_.original_tagname_ = "x-eiNotification"
        elif nodeName_ == "x-eiRampUp":
            obj_ = DurationPropType.factory()
            obj_.build(child_)
            self.x_eiRampUp = obj_
            obj_.original_tagname_ = "x-eiRampUp"
        elif nodeName_ == "x-eiRecovery":
            obj_ = DurationPropType.factory()
            obj_.build(child_)
            self.x_eiRecovery = obj_
            obj_.original_tagname_ = "x-eiRecovery"


# end class properties


class components(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self):
        self.original_tagname_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, components)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if components.subclass:
            return components.subclass(*args_, **kwargs_)
        else:
            return components(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="xcal:",
        name_="components",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:xcal="urn:ietf:params:xml:ns:icalendar-2.0"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("components")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="components"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="xcal:",
                name_="components",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="xcal:", name_="components"
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="xcal:",
        name_="components",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class components


class dtend(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, date_time=None):
        self.original_tagname_ = None
        if isinstance(date_time, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(date_time, "%Y-%m-%dT%H:%M:%S")
        else:
            initvalue_ = date_time
        self.date_time = initvalue_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, dtend)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if dtend.subclass:
            return dtend.subclass(*args_, **kwargs_)
        else:
            return dtend(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_date_time(self):
        return self.date_time

    def set_date_time(self, date_time):
        self.date_time = date_time

    def hasContent_(self):
        if self.date_time is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="xcal:",
        name_="dtend",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:xcal="urn:ietf:params:xml:ns:icalendar-2.0" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("dtend")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="dtend"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="xcal:",
                name_="dtend",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="xcal:", name_="dtend"
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="xcal:",
        name_="dtend",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.date_time is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<xcal:date-time>%s</xcal:date-time>%s"
                % (
                    self.gds_format_datetime(self.date_time, input_name="date-time"),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "date-time":
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.date_time = dval_


# end class dtend


class VavailabilityType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, components=None):
        self.original_tagname_ = None
        self.components = components

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, VavailabilityType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if VavailabilityType.subclass:
            return VavailabilityType.subclass(*args_, **kwargs_)
        else:
            return VavailabilityType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_components(self):
        return self.components

    def set_components(self, components):
        self.components = components

    def hasContent_(self):
        if self.components is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="xcal:",
        name_="VavailabilityType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:xcal="urn:ietf:params:xml:ns:icalendar-2.0" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("VavailabilityType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="VavailabilityType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="xcal:",
                name_="VavailabilityType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="xcal:",
        name_="VavailabilityType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="xcal:",
        name_="VavailabilityType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.components is not None:
            self.components.export(
                outfile,
                level,
                namespace_,
                name_="components",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "components":
            obj_ = ArrayOfVavailabilityContainedComponents.factory()
            obj_.build(child_)
            self.components = obj_
            obj_.original_tagname_ = "components"


# end class VavailabilityType


class ArrayOfVavailabilityContainedComponents(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, available=None):
        self.original_tagname_ = None
        if available is None:
            self.available = []
        else:
            self.available = available

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArrayOfVavailabilityContainedComponents
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArrayOfVavailabilityContainedComponents.subclass:
            return ArrayOfVavailabilityContainedComponents.subclass(*args_, **kwargs_)
        else:
            return ArrayOfVavailabilityContainedComponents(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_available(self):
        return self.available

    def set_available(self, available):
        self.available = available

    def add_available(self, value):
        self.available.append(value)

    def insert_available_at(self, index, value):
        self.available.insert(index, value)

    def replace_available_at(self, index, value):
        self.available[index] = value

    def hasContent_(self):
        if self.available:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="xcal:",
        name_="ArrayOfVavailabilityContainedComponents",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:xcal="urn:ietf:params:xml:ns:icalendar-2.0" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get(
            "ArrayOfVavailabilityContainedComponents"
        )
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespace_,
            name_="ArrayOfVavailabilityContainedComponents",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="xcal:",
                name_="ArrayOfVavailabilityContainedComponents",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="xcal:",
        name_="ArrayOfVavailabilityContainedComponents",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="xcal:",
        name_="ArrayOfVavailabilityContainedComponents",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for available_ in self.available:
            available_.export(
                outfile,
                level,
                namespace_="xcal:",
                name_="available",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "available":
            obj_ = AvailableType.factory()
            obj_.build(child_)
            self.available.append(obj_)
            obj_.original_tagname_ = "available"


# end class ArrayOfVavailabilityContainedComponents


class AvailableType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, properties=None):
        self.original_tagname_ = None
        self.properties = properties

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, AvailableType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AvailableType.subclass:
            return AvailableType.subclass(*args_, **kwargs_)
        else:
            return AvailableType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_properties(self):
        return self.properties

    def set_properties(self, properties):
        self.properties = properties

    def hasContent_(self):
        if self.properties is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="xcal:",
        name_="AvailableType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:xcal="urn:ietf:params:xml:ns:icalendar-2.0" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("AvailableType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="AvailableType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="xcal:",
                name_="AvailableType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="xcal:",
        name_="AvailableType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="xcal:",
        name_="AvailableType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.properties is not None:
            self.properties.export(
                outfile,
                level,
                namespace_="xcal:",
                name_="properties",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "properties":
            obj_ = properties.factory()
            obj_.build(child_)
            self.properties = obj_
            obj_.original_tagname_ = "properties"


# end class AvailableType


class WsCalendarIntervalType(GeneratedsSuper):
    """An interval takes no sub-components."""

    subclass = None
    superclass = None

    def __init__(self, properties=None):
        self.original_tagname_ = None
        self.properties = properties

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, WsCalendarIntervalType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if WsCalendarIntervalType.subclass:
            return WsCalendarIntervalType.subclass(*args_, **kwargs_)
        else:
            return WsCalendarIntervalType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_properties(self):
        return self.properties

    def set_properties(self, properties):
        self.properties = properties

    def hasContent_(self):
        if self.properties is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="xcal:",
        name_="WsCalendarIntervalType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:xcal="urn:ietf:params:xml:ns:icalendar-2.0" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("WsCalendarIntervalType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespace_,
            name_="WsCalendarIntervalType",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="xcal:",
                name_="WsCalendarIntervalType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="xcal:",
        name_="WsCalendarIntervalType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="xcal:",
        name_="WsCalendarIntervalType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.properties is not None:
            self.properties.export(
                outfile,
                level,
                namespace_="xcal:",
                name_="properties",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "properties":
            obj_ = properties.factory()
            obj_.build(child_)
            self.properties = obj_
            obj_.original_tagname_ = "properties"


# end class WsCalendarIntervalType


class QualifiedEventIDType(GeneratedsSuper):
    """Fully qualified event ID includes the eventID and the
    modificationNumber."""

    subclass = None
    superclass = None

    def __init__(self, eventID=None, modificationNumber=None):
        self.original_tagname_ = None
        self.eventID = eventID
        self.modificationNumber = modificationNumber

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, QualifiedEventIDType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if QualifiedEventIDType.subclass:
            return QualifiedEventIDType.subclass(*args_, **kwargs_)
        else:
            return QualifiedEventIDType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_eventID(self):
        return self.eventID

    def set_eventID(self, eventID):
        self.eventID = eventID

    def get_modificationNumber(self):
        return self.modificationNumber

    def set_modificationNumber(self, modificationNumber):
        self.modificationNumber = modificationNumber

    def hasContent_(self):
        if self.eventID is not None or self.modificationNumber is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="QualifiedEventIDType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("QualifiedEventIDType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="QualifiedEventIDType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ei:",
                name_="QualifiedEventIDType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="ei:",
        name_="QualifiedEventIDType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="QualifiedEventIDType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.eventID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:eventID>%s</ei:eventID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.eventID), input_name="eventID"
                        )
                    ),
                    eol_,
                )
            )
        if self.modificationNumber is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:modificationNumber>%s</ei:modificationNumber>%s"
                % (
                    self.gds_format_integer(
                        self.modificationNumber, input_name="modificationNumber"
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "eventID":
            eventID_ = child_.text
            eventID_ = self.gds_validate_string(eventID_, node, "eventID")
            self.eventID = eventID_
        elif nodeName_ == "modificationNumber":
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, "requires integer: %s" % exp)
            ival_ = self.gds_validate_integer(ival_, node, "modificationNumber")
            self.modificationNumber = ival_


# end class QualifiedEventIDType


class IntervalType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, dtstart=None, duration=None, uid=None, streamPayloadBase=None):
        self.original_tagname_ = None
        self.dtstart = dtstart
        self.duration = duration
        self.uid = uid
        if streamPayloadBase is None:
            self.streamPayloadBase = []
        else:
            self.streamPayloadBase = streamPayloadBase

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, IntervalType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if IntervalType.subclass:
            return IntervalType.subclass(*args_, **kwargs_)
        else:
            return IntervalType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_dtstart(self):
        return self.dtstart

    def set_dtstart(self, dtstart):
        self.dtstart = dtstart

    def get_duration(self):
        return self.duration

    def set_duration(self, duration):
        self.duration = duration

    def get_uid(self):
        return self.uid

    def set_uid(self, uid):
        self.uid = uid

    def get_streamPayloadBase(self):
        return self.streamPayloadBase

    def set_streamPayloadBase(self, streamPayloadBase):
        self.streamPayloadBase = streamPayloadBase

    def add_streamPayloadBase(self, value):
        self.streamPayloadBase.append(value)

    def insert_streamPayloadBase_at(self, index, value):
        self.streamPayloadBase.insert(index, value)

    def replace_streamPayloadBase_at(self, index, value):
        self.streamPayloadBase[index] = value

    def hasContent_(self):
        if (
            self.dtstart is not None
            or self.duration is not None
            or self.uid is not None
            or self.streamPayloadBase
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="IntervalType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:xcal="urn:ietf:params:xml:ns:icalendar-2.0"  xmlns:strm="urn:ietf:params:xml:ns:icalendar-2.0:stream"  xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("IntervalType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="IntervalType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ei:",
                name_="IntervalType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="ei:", name_="IntervalType"
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="IntervalType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.dtstart is not None:
            self.dtstart.export(
                outfile,
                level,
                namespace_="xcal:",
                name_="dtstart",
                pretty_print=pretty_print,
            )
        if self.duration is not None:
            self.duration.export(
                outfile,
                level,
                namespace_="xcal:",
                name_="duration",
                pretty_print=pretty_print,
            )
        if self.uid is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<xcal:uid>%s</xcal:uid>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.uid), input_name="uid")
                    ),
                    eol_,
                )
            )
        for streamPayloadBase_ in self.streamPayloadBase:
            streamPayloadBase_.export(
                outfile, level, namespace_, pretty_print=pretty_print
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "dtstart":
            obj_ = dtstart.factory()
            obj_.build(child_)
            self.dtstart = obj_
            obj_.original_tagname_ = "dtstart"
        elif nodeName_ == "duration":
            obj_ = DurationPropType.factory()
            obj_.build(child_)
            self.duration = obj_
            obj_.original_tagname_ = "duration"
        elif nodeName_ == "uid":
            uid_ = child_.text
            uid_ = self.gds_validate_string(uid_, node, "uid")
            self.uid = uid_
        elif nodeName_ == "refID":
            obj_ = refID.factory()
            obj_.build(child_)
            self.uid = obj_
            obj_.original_tagname_ = "refID"
        elif nodeName_ == "registrationID":
            obj_ = registrationID.factory()
            obj_.build(child_)
            self.refID = obj_
            obj_.original_tagname_ = "registrationID"
        elif nodeName_ == "streamPayloadBase":
            type_name_ = child_.attrib.get(
                "{http://www.w3.org/2001/XMLSchema-instance}type"
            )
            if type_name_ is None:
                type_name_ = child_.attrib.get("type")
            if type_name_ is not None:
                type_names_ = type_name_.split(":")
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    "Class not implemented for <streamPayloadBase> element"
                )
            self.streamPayloadBase.append(obj_)
            obj_.original_tagname_ = "streamPayloadBase"
        elif nodeName_ == "oadrGBPayload":
            obj_ = oadrGBStreamPayloadBase.factory()
            obj_.build(child_)
            self.streamPayloadBase.append(obj_)
            obj_.original_tagname_ = "oadrGBPayload"
        elif nodeName_ == "oadrReportPayload":
            obj_ = oadrReportPayloadType.factory()
            obj_.build(child_)
            self.streamPayloadBase.append(obj_)
            obj_.original_tagname_ = "oadrReportPayload"
        elif nodeName_ == "signalPayload":
            obj_ = signalPayloadType.factory()
            obj_.build(child_)
            self.streamPayloadBase.append(obj_)
            obj_.original_tagname_ = "signalPayload"


# end class IntervalType


class currentValueType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, payloadFloat=None):
        self.original_tagname_ = None
        self.payloadFloat = payloadFloat

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, currentValueType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if currentValueType.subclass:
            return currentValueType.subclass(*args_, **kwargs_)
        else:
            return currentValueType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_payloadFloat(self):
        return self.payloadFloat

    def set_payloadFloat(self, payloadFloat):
        self.payloadFloat = payloadFloat

    def hasContent_(self):
        if self.payloadFloat is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="currentValueType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("currentValueType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="currentValueType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ei:",
                name_="currentValueType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="ei:",
        name_="currentValueType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="currentValueType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.payloadFloat is not None:
            self.payloadFloat.export(
                outfile,
                level,
                namespace_="ei:",
                name_="payloadFloat",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "payloadFloat":
            obj_ = PayloadFloatType.factory()
            obj_.build(child_)
            self.payloadFloat = obj_
            obj_.original_tagname_ = "payloadFloat"


# end class currentValueType


class PayloadBaseType(GeneratedsSuper):
    """Base for information in signal / baseline / report payloads"""

    subclass = None
    superclass = None

    def __init__(self, extensiontype_=None):
        self.original_tagname_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, PayloadBaseType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PayloadBaseType.subclass:
            return PayloadBaseType.subclass(*args_, **kwargs_)
        else:
            return PayloadBaseType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_extensiontype_(self):
        return self.extensiontype_

    def set_extensiontype_(self, extensiontype_):
        self.extensiontype_ = extensiontype_

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="PayloadBaseType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("PayloadBaseType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="PayloadBaseType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ei:",
                name_="PayloadBaseType",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="ei:",
        name_="PayloadBaseType",
    ):
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="PayloadBaseType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class PayloadBaseType


class PayloadFloatType(PayloadBaseType):
    """This is the payload for signals that require a quantity."""

    subclass = None
    superclass = PayloadBaseType

    def __init__(self, value=None):
        self.original_tagname_ = None
        super(PayloadFloatType, self).__init__()
        self.value = value

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, PayloadFloatType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PayloadFloatType.subclass:
            return PayloadFloatType.subclass(*args_, **kwargs_)
        else:
            return PayloadFloatType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_value(self):
        return self.value

    def set_value(self, value):
        self.value = value

    def hasContent_(self):
        if self.value is not None or super(PayloadFloatType, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="PayloadFloatType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("PayloadFloatType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="PayloadFloatType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ei:",
                name_="PayloadFloatType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="ei:",
        name_="PayloadFloatType",
    ):
        super(PayloadFloatType, self).exportAttributes(
            outfile, level, already_processed, namespace_, name_="PayloadFloatType"
        )

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="PayloadFloatType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(PayloadFloatType, self).exportChildren(
            outfile, level, namespace_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:value>%s</ei:value>%s"
                % (self.gds_format_float(self.value, input_name="value"), eol_)
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(PayloadFloatType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "value":
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, "requires float or double: %s" % exp)
            fval_ = self.gds_validate_float(fval_, node, "value")
            self.value = fval_
        super(PayloadFloatType, self).buildChildren(child_, node, nodeName_, True)


# end class PayloadFloatType


class EiResponseType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, responseCode=None, responseDescription=None, requestID=None):
        self.original_tagname_ = None
        self.responseCode = responseCode
        self.responseDescription = responseDescription
        self.requestID = requestID

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, EiResponseType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if EiResponseType.subclass:
            return EiResponseType.subclass(*args_, **kwargs_)
        else:
            return EiResponseType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_responseCode(self):
        return self.responseCode

    def set_responseCode(self, responseCode):
        self.responseCode = responseCode

    def get_responseDescription(self):
        return self.responseDescription

    def set_responseDescription(self, responseDescription):
        self.responseDescription = responseDescription

    def get_requestID(self):
        return self.requestID

    def set_requestID(self, requestID):
        self.requestID = requestID

    def hasContent_(self):
        if (
            self.responseCode is not None
            or self.responseDescription is not None
            or self.requestID is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="EiResponseType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110"  xmlns:pyld="http://docs.oasis-open.org/ns/energyinterop/201110/payloads" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("EiResponseType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="EiResponseType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ei:",
                name_="EiResponseType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="ei:",
        name_="EiResponseType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="EiResponseType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.responseCode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:responseCode>%s</ei:responseCode>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.responseCode), input_name="responseCode"
                        )
                    ),
                    eol_,
                )
            )
        if self.responseDescription is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:responseDescription>%s</ei:responseDescription>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.responseDescription),
                            input_name="responseDescription",
                        )
                    ),
                    eol_,
                )
            )
        if self.requestID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<pyld:requestID>%s</pyld:requestID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.requestID), input_name="requestID"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "responseCode":
            responseCode_ = child_.text
            responseCode_ = self.gds_validate_string(
                responseCode_, node, "responseCode"
            )
            self.responseCode = responseCode_
        elif nodeName_ == "responseDescription":
            responseDescription_ = child_.text
            responseDescription_ = self.gds_validate_string(
                responseDescription_, node, "responseDescription"
            )
            self.responseDescription = responseDescription_
        elif nodeName_ == "requestID":
            requestID_ = child_.text
            requestID_ = self.gds_validate_string(requestID_, node, "requestID")
            self.requestID = requestID_


# end class EiResponseType


class eventResponses(GeneratedsSuper):
    """optIn or optOut responses for received events"""

    subclass = None
    superclass = None

    def __init__(self, eventResponse=None):
        self.original_tagname_ = None
        if eventResponse is None:
            self.eventResponse = []
        else:
            self.eventResponse = eventResponse

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, eventResponses)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if eventResponses.subclass:
            return eventResponses.subclass(*args_, **kwargs_)
        else:
            return eventResponses(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_eventResponse(self):
        return self.eventResponse

    def set_eventResponse(self, eventResponse):
        self.eventResponse = eventResponse

    def add_eventResponse(self, value):
        self.eventResponse.append(value)

    def insert_eventResponse_at(self, index, value):
        self.eventResponse.insert(index, value)

    def replace_eventResponse_at(self, index, value):
        self.eventResponse[index] = value

    def hasContent_(self):
        if self.eventResponse:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="eventResponses",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("eventResponses")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="eventResponses"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ei:",
                name_="eventResponses",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="ei:",
        name_="eventResponses",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="eventResponses",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for eventResponse_ in self.eventResponse:
            eventResponse_.export(
                outfile,
                level,
                namespace_,
                name_="eventResponse",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "eventResponse":
            obj_ = eventResponseType.factory()
            obj_.build(child_)
            self.eventResponse.append(obj_)
            obj_.original_tagname_ = "eventResponse"


# end class eventResponses


class eiEventType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self,
        eventDescriptor=None,
        eiActivePeriod=None,
        eiEventSignals=None,
        eiTarget=None,
    ):
        self.original_tagname_ = None
        self.eventDescriptor = eventDescriptor
        self.eiActivePeriod = eiActivePeriod
        self.eiEventSignals = eiEventSignals
        self.eiTarget = eiTarget

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, eiEventType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if eiEventType.subclass:
            return eiEventType.subclass(*args_, **kwargs_)
        else:
            return eiEventType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_eventDescriptor(self):
        return self.eventDescriptor

    def set_eventDescriptor(self, eventDescriptor):
        self.eventDescriptor = eventDescriptor

    def get_eiActivePeriod(self):
        return self.eiActivePeriod

    def set_eiActivePeriod(self, eiActivePeriod):
        self.eiActivePeriod = eiActivePeriod

    def get_eiEventSignals(self):
        return self.eiEventSignals

    def set_eiEventSignals(self, eiEventSignals):
        self.eiEventSignals = eiEventSignals

    def get_eiTarget(self):
        return self.eiTarget

    def set_eiTarget(self, eiTarget):
        self.eiTarget = eiTarget

    def hasContent_(self):
        if (
            self.eventDescriptor is not None
            or self.eiActivePeriod is not None
            or self.eiEventSignals is not None
            or self.eiTarget is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="eiEventType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("eiEventType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="eiEventType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ei:",
                name_="eiEventType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="ei:", name_="eiEventType"
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="eiEventType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.eventDescriptor is not None:
            self.eventDescriptor.export(
                outfile,
                level,
                namespace_="ei:",
                name_="eventDescriptor",
                pretty_print=pretty_print,
            )
        if self.eiActivePeriod is not None:
            self.eiActivePeriod.export(
                outfile,
                level,
                namespace_="ei:",
                name_="eiActivePeriod",
                pretty_print=pretty_print,
            )
        if self.eiEventSignals is not None:
            self.eiEventSignals.export(
                outfile,
                level,
                namespace_="ei:",
                name_="eiEventSignals",
                pretty_print=pretty_print,
            )
        if self.eiTarget is not None:
            self.eiTarget.export(
                outfile,
                level,
                namespace_="ei:",
                name_="eiTarget",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "eventDescriptor":
            obj_ = eventDescriptorType.factory()
            obj_.build(child_)
            self.eventDescriptor = obj_
            obj_.original_tagname_ = "eventDescriptor"
        elif nodeName_ == "eiActivePeriod":
            obj_ = eiActivePeriodType.factory()
            obj_.build(child_)
            self.eiActivePeriod = obj_
            obj_.original_tagname_ = "eiActivePeriod"
        elif nodeName_ == "eiEventSignals":
            obj_ = eiEventSignalsType.factory()
            obj_.build(child_)
            self.eiEventSignals = obj_
            obj_.original_tagname_ = "eiEventSignals"
        elif nodeName_ == "eiTarget":
            obj_ = EiTargetType.factory()
            obj_.build(child_)
            self.eiTarget = obj_
            obj_.original_tagname_ = "eiTarget"


# end class eiEventType


class eiActivePeriodType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, properties=None, components=None):
        self.original_tagname_ = None
        self.properties = properties
        self.components = components

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, eiActivePeriodType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if eiActivePeriodType.subclass:
            return eiActivePeriodType.subclass(*args_, **kwargs_)
        else:
            return eiActivePeriodType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_properties(self):
        return self.properties

    def set_properties(self, properties):
        self.properties = properties

    def get_components(self):
        return self.components

    def set_components(self, components):
        self.components = components

    def hasContent_(self):
        if self.properties is not None or self.components is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="eiActivePeriodType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:xcal="urn:ietf:params:xml:ns:icalendar-2.0"  xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("eiActivePeriodType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="eiActivePeriodType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ei:",
                name_="eiActivePeriodType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="ei:",
        name_="eiActivePeriodType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="eiActivePeriodType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.properties is not None:
            self.properties.export(
                outfile,
                level,
                namespace_="xcal:",
                name_="properties",
                pretty_print=pretty_print,
            )
        if self.components is not None:
            self.components.export(
                outfile,
                level,
                namespace_="xcal:",
                name_="components",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "properties":
            obj_ = properties.factory()
            obj_.build(child_)
            self.properties = obj_
            obj_.original_tagname_ = "properties"
        elif nodeName_ == "components":
            obj_ = components.factory()
            obj_.build(child_)
            self.components = obj_
            obj_.original_tagname_ = "components"


# end class eiActivePeriodType


class ArrayofResponses(GeneratedsSuper):
    """Collection of Responses. When a service operation regards multiple
    referenceable items, each referenced item may have its own
    response. Always accompanied by an overall Response Type."""

    subclass = None
    superclass = None

    def __init__(self, response=None):
        self.original_tagname_ = None
        if response is None:
            self.response = []
        else:
            self.response = response

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ArrayofResponses)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArrayofResponses.subclass:
            return ArrayofResponses.subclass(*args_, **kwargs_)
        else:
            return ArrayofResponses(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_response(self):
        return self.response

    def set_response(self, response):
        self.response = response

    def add_response(self, value):
        self.response.append(value)

    def insert_response_at(self, index, value):
        self.response.insert(index, value)

    def replace_response_at(self, index, value):
        self.response[index] = value

    def hasContent_(self):
        if self.response:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="ArrayofResponses",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ArrayofResponses")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="ArrayofResponses"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ei:",
                name_="ArrayofResponses",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="ei:",
        name_="ArrayofResponses",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="ArrayofResponses",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for response_ in self.response:
            response_.export(
                outfile, level, namespace_, name_="response", pretty_print=pretty_print
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "response":
            obj_ = EiResponseType.factory()
            obj_.build(child_)
            self.response.append(obj_)
            obj_.original_tagname_ = "response"


# end class ArrayofResponses


class eventDescriptorType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self,
        eventID=None,
        modificationNumber=None,
        modificationDateTime=None,
        modificationReason=None,
        priority=None,
        eiMarketContext=None,
        createdDateTime=None,
        eventStatus=None,
        testEvent=None,
        vtnComment=None,
    ):
        self.original_tagname_ = None
        self.eventID = eventID
        self.modificationNumber = modificationNumber
        if isinstance(modificationDateTime, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(
                modificationDateTime, "%Y-%m-%dT%H:%M:%S"
            )
        else:
            initvalue_ = modificationDateTime
        self.modificationDateTime = initvalue_
        self.modificationReason = modificationReason
        self.priority = priority
        self.eiMarketContext = eiMarketContext
        if isinstance(createdDateTime, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(
                createdDateTime, "%Y-%m-%dT%H:%M:%S"
            )
        else:
            initvalue_ = createdDateTime
        self.createdDateTime = initvalue_
        self.eventStatus = eventStatus
        self.testEvent = testEvent
        self.vtnComment = vtnComment

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, eventDescriptorType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if eventDescriptorType.subclass:
            return eventDescriptorType.subclass(*args_, **kwargs_)
        else:
            return eventDescriptorType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_eventID(self):
        return self.eventID

    def set_eventID(self, eventID):
        self.eventID = eventID

    def get_modificationNumber(self):
        return self.modificationNumber

    def set_modificationNumber(self, modificationNumber):
        self.modificationNumber = modificationNumber

    def get_modificationDateTime(self):
        return self.modificationDateTime

    def set_modificationDateTime(self, modificationDateTime):
        self.modificationDateTime = modificationDateTime

    def get_modificationReason(self):
        return self.modificationReason

    def set_modificationReason(self, modificationReason):
        self.modificationReason = modificationReason

    def get_priority(self):
        return self.priority

    def set_priority(self, priority):
        self.priority = priority

    def get_eiMarketContext(self):
        return self.eiMarketContext

    def set_eiMarketContext(self, eiMarketContext):
        self.eiMarketContext = eiMarketContext

    def get_createdDateTime(self):
        return self.createdDateTime

    def set_createdDateTime(self, createdDateTime):
        self.createdDateTime = createdDateTime

    def get_eventStatus(self):
        return self.eventStatus

    def set_eventStatus(self, eventStatus):
        self.eventStatus = eventStatus

    def get_testEvent(self):
        return self.testEvent

    def set_testEvent(self, testEvent):
        self.testEvent = testEvent

    def get_vtnComment(self):
        return self.vtnComment

    def set_vtnComment(self, vtnComment):
        self.vtnComment = vtnComment

    def validate_DateTimeType(self, value):
        # Validate type DateTimeType, a restriction on xs:dateTime.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_DateTimeType_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (value.encode("utf-8"), self.validate_DateTimeType_patterns_)
                )

    validate_DateTimeType_patterns_ = [
        ["^(\\-$|^\\+)?\\d{4}\\-\\d{2}\\-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d*)?Z?$"]
    ]

    def hasContent_(self):
        if (
            self.eventID is not None
            or self.modificationNumber is not None
            or self.modificationDateTime is not None
            or self.modificationReason is not None
            or self.priority is not None
            or self.eiMarketContext is not None
            or self.createdDateTime is not None
            or self.eventStatus is not None
            or self.testEvent is not None
            or self.vtnComment is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="eventDescriptorType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110"  xmlns:xcal="urn:ietf:params:xml:ns:icalendar-2.0" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("eventDescriptorType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="eventDescriptorType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ei:",
                name_="eventDescriptorType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="ei:",
        name_="eventDescriptorType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="eventDescriptorType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.eventID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:eventID>%s</ei:eventID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.eventID), input_name="eventID"
                        )
                    ),
                    eol_,
                )
            )
        if self.modificationNumber is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:modificationNumber>%s</ei:modificationNumber>%s"
                % (
                    self.gds_format_integer(
                        self.modificationNumber, input_name="modificationNumber"
                    ),
                    eol_,
                )
            )
        if self.modificationDateTime is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:modificationDateTime>%s</ei:modificationDateTime>%s"
                % (
                    self.gds_format_datetime(
                        self.modificationDateTime, input_name="modificationDateTime"
                    ),
                    eol_,
                )
            )
        if self.modificationReason is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:modificationReason>%s</ei:modificationReason>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.modificationReason),
                            input_name="modificationReason",
                        )
                    ),
                    eol_,
                )
            )
        if self.priority is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:priority>%s</ei:priority>%s"
                % (self.gds_format_integer(self.priority, input_name="priority"), eol_)
            )
        if self.eiMarketContext is not None:
            self.eiMarketContext.export(
                outfile,
                level,
                namespace_,
                name_="eiMarketContext",
                pretty_print=pretty_print,
            )
        if self.createdDateTime is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:createdDateTime>%s</ei:createdDateTime>%s"
                % (
                    self.gds_format_datetime(
                        self.createdDateTime, input_name="createdDateTime"
                    ),
                    eol_,
                )
            )
        if self.eventStatus is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:eventStatus>%s</ei:eventStatus>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.eventStatus), input_name="eventStatus"
                        )
                    ),
                    eol_,
                )
            )
        if self.testEvent is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:testEvent>%s</ei:testEvent>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.testEvent), input_name="testEvent"
                        )
                    ),
                    eol_,
                )
            )
        if self.vtnComment is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:vtnComment>%s</ei:vtnComment>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.vtnComment), input_name="vtnComment"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "eventID":
            eventID_ = child_.text
            eventID_ = self.gds_validate_string(eventID_, node, "eventID")
            self.eventID = eventID_
        elif nodeName_ == "modificationNumber":
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, "requires integer: %s" % exp)
            ival_ = self.gds_validate_integer(ival_, node, "modificationNumber")
            self.modificationNumber = ival_
        elif nodeName_ == "modificationDateTime":
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.modificationDateTime = dval_
            # validate type DateTimeType
            self.validate_DateTimeType(self.modificationDateTime)
        elif nodeName_ == "modificationReason":
            modificationReason_ = child_.text
            modificationReason_ = self.gds_validate_string(
                modificationReason_, node, "modificationReason"
            )
            self.modificationReason = modificationReason_
        elif nodeName_ == "priority":
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, "requires integer: %s" % exp)
            ival_ = self.gds_validate_integer(ival_, node, "priority")
            self.priority = ival_
        elif nodeName_ == "eiMarketContext":
            obj_ = eiMarketContextType.factory()
            obj_.build(child_)
            self.eiMarketContext = obj_
            obj_.original_tagname_ = "eiMarketContext"
        elif nodeName_ == "createdDateTime":
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.createdDateTime = dval_
        elif nodeName_ == "eventStatus":
            eventStatus_ = child_.text
            if eventStatus_:
                eventStatus_ = re_.sub(String_cleanup_pat_, " ", eventStatus_).strip()
            else:
                eventStatus_ = ""
            eventStatus_ = self.gds_validate_string(eventStatus_, node, "eventStatus")
            self.eventStatus = eventStatus_
        elif nodeName_ == "testEvent":
            testEvent_ = child_.text
            testEvent_ = self.gds_validate_string(testEvent_, node, "testEvent")
            self.testEvent = testEvent_
        elif nodeName_ == "vtnComment":
            vtnComment_ = child_.text
            vtnComment_ = self.gds_validate_string(vtnComment_, node, "vtnComment")
            self.vtnComment = vtnComment_


# end class eventDescriptorType


class signalPayloadType(StreamPayloadBaseType):
    subclass = None
    superclass = StreamPayloadBaseType

    def __init__(self, payloadBase=None):
        self.original_tagname_ = None
        super(signalPayloadType, self).__init__()
        self.payloadBase = payloadBase

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, signalPayloadType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if signalPayloadType.subclass:
            return signalPayloadType.subclass(*args_, **kwargs_)
        else:
            return signalPayloadType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_payloadBase(self):
        return self.payloadBase

    def set_payloadBase(self, payloadBase):
        self.payloadBase = payloadBase

    def hasContent_(self):
        if self.payloadBase is not None or super(signalPayloadType, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="signalPayloadType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("signalPayloadType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="signalPayloadType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ei:",
                name_="signalPayloadType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="ei:",
        name_="signalPayloadType",
    ):
        super(signalPayloadType, self).exportAttributes(
            outfile, level, already_processed, namespace_, name_="signalPayloadType"
        )

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="signalPayloadType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(signalPayloadType, self).exportChildren(
            outfile, level, namespace_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.payloadBase is not None:
            self.payloadBase.export(
                outfile, level, namespace_, pretty_print=pretty_print
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(signalPayloadType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "payloadBase":
            type_name_ = child_.attrib.get(
                "{http://www.w3.org/2001/XMLSchema-instance}type"
            )
            if type_name_ is None:
                type_name_ = child_.attrib.get("type")
            if type_name_ is not None:
                type_names_ = type_name_.split(":")
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    "Class not implemented for <payloadBase> element"
                )
            self.payloadBase = obj_
            obj_.original_tagname_ = "payloadBase"
        elif nodeName_ == "oadrPayloadResourceStatus":
            obj_ = oadrPayloadResourceStatusType.factory()
            obj_.build(child_)
            self.payloadBase = obj_
            obj_.original_tagname_ = "oadrPayloadResourceStatus"
        elif nodeName_ == "payloadFloat":
            obj_ = PayloadFloatType.factory()
            obj_.build(child_)
            self.payloadBase = obj_
            obj_.original_tagname_ = "payloadFloat"
        super(signalPayloadType, self).buildChildren(child_, node, nodeName_, True)


# end class signalPayloadType


class EiTargetType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self,
        aggregatedPnode=None,
        endDeviceAsset=None,
        meterAsset=None,
        pnode=None,
        serviceArea=None,
        serviceDeliveryPoint=None,
        serviceLocation=None,
        transportInterface=None,
        groupID=None,
        groupName=None,
        resourceID=None,
        venID=None,
        partyID=None,
    ):
        self.original_tagname_ = None
        if aggregatedPnode is None:
            self.aggregatedPnode = []
        else:
            self.aggregatedPnode = aggregatedPnode
        if endDeviceAsset is None:
            self.endDeviceAsset = []
        else:
            self.endDeviceAsset = endDeviceAsset
        if meterAsset is None:
            self.meterAsset = []
        else:
            self.meterAsset = meterAsset
        if pnode is None:
            self.pnode = []
        else:
            self.pnode = pnode
        if serviceArea is None:
            self.serviceArea = []
        else:
            self.serviceArea = serviceArea
        if serviceDeliveryPoint is None:
            self.serviceDeliveryPoint = []
        else:
            self.serviceDeliveryPoint = serviceDeliveryPoint
        if serviceLocation is None:
            self.serviceLocation = []
        else:
            self.serviceLocation = serviceLocation
        if transportInterface is None:
            self.transportInterface = []
        else:
            self.transportInterface = transportInterface
        if groupID is None:
            self.groupID = []
        else:
            self.groupID = groupID
        if groupName is None:
            self.groupName = []
        else:
            self.groupName = groupName
        if resourceID is None:
            self.resourceID = []
        else:
            self.resourceID = resourceID
        if venID is None:
            self.venID = []
        else:
            self.venID = venID
        if partyID is None:
            self.partyID = []
        else:
            self.partyID = partyID

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, EiTargetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if EiTargetType.subclass:
            return EiTargetType.subclass(*args_, **kwargs_)
        else:
            return EiTargetType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_aggregatedPnode(self):
        return self.aggregatedPnode

    def set_aggregatedPnode(self, aggregatedPnode):
        self.aggregatedPnode = aggregatedPnode

    def add_aggregatedPnode(self, value):
        self.aggregatedPnode.append(value)

    def insert_aggregatedPnode_at(self, index, value):
        self.aggregatedPnode.insert(index, value)

    def replace_aggregatedPnode_at(self, index, value):
        self.aggregatedPnode[index] = value

    def get_endDeviceAsset(self):
        return self.endDeviceAsset

    def set_endDeviceAsset(self, endDeviceAsset):
        self.endDeviceAsset = endDeviceAsset

    def add_endDeviceAsset(self, value):
        self.endDeviceAsset.append(value)

    def insert_endDeviceAsset_at(self, index, value):
        self.endDeviceAsset.insert(index, value)

    def replace_endDeviceAsset_at(self, index, value):
        self.endDeviceAsset[index] = value

    def get_meterAsset(self):
        return self.meterAsset

    def set_meterAsset(self, meterAsset):
        self.meterAsset = meterAsset

    def add_meterAsset(self, value):
        self.meterAsset.append(value)

    def insert_meterAsset_at(self, index, value):
        self.meterAsset.insert(index, value)

    def replace_meterAsset_at(self, index, value):
        self.meterAsset[index] = value

    def get_pnode(self):
        return self.pnode

    def set_pnode(self, pnode):
        self.pnode = pnode

    def add_pnode(self, value):
        self.pnode.append(value)

    def insert_pnode_at(self, index, value):
        self.pnode.insert(index, value)

    def replace_pnode_at(self, index, value):
        self.pnode[index] = value

    def get_serviceArea(self):
        return self.serviceArea

    def set_serviceArea(self, serviceArea):
        self.serviceArea = serviceArea

    def add_serviceArea(self, value):
        self.serviceArea.append(value)

    def insert_serviceArea_at(self, index, value):
        self.serviceArea.insert(index, value)

    def replace_serviceArea_at(self, index, value):
        self.serviceArea[index] = value

    def get_serviceDeliveryPoint(self):
        return self.serviceDeliveryPoint

    def set_serviceDeliveryPoint(self, serviceDeliveryPoint):
        self.serviceDeliveryPoint = serviceDeliveryPoint

    def add_serviceDeliveryPoint(self, value):
        self.serviceDeliveryPoint.append(value)

    def insert_serviceDeliveryPoint_at(self, index, value):
        self.serviceDeliveryPoint.insert(index, value)

    def replace_serviceDeliveryPoint_at(self, index, value):
        self.serviceDeliveryPoint[index] = value

    def get_serviceLocation(self):
        return self.serviceLocation

    def set_serviceLocation(self, serviceLocation):
        self.serviceLocation = serviceLocation

    def add_serviceLocation(self, value):
        self.serviceLocation.append(value)

    def insert_serviceLocation_at(self, index, value):
        self.serviceLocation.insert(index, value)

    def replace_serviceLocation_at(self, index, value):
        self.serviceLocation[index] = value

    def get_transportInterface(self):
        return self.transportInterface

    def set_transportInterface(self, transportInterface):
        self.transportInterface = transportInterface

    def add_transportInterface(self, value):
        self.transportInterface.append(value)

    def insert_transportInterface_at(self, index, value):
        self.transportInterface.insert(index, value)

    def replace_transportInterface_at(self, index, value):
        self.transportInterface[index] = value

    def get_groupID(self):
        return self.groupID

    def set_groupID(self, groupID):
        self.groupID = groupID

    def add_groupID(self, value):
        self.groupID.append(value)

    def insert_groupID_at(self, index, value):
        self.groupID.insert(index, value)

    def replace_groupID_at(self, index, value):
        self.groupID[index] = value

    def get_groupName(self):
        return self.groupName

    def set_groupName(self, groupName):
        self.groupName = groupName

    def add_groupName(self, value):
        self.groupName.append(value)

    def insert_groupName_at(self, index, value):
        self.groupName.insert(index, value)

    def replace_groupName_at(self, index, value):
        self.groupName[index] = value

    def get_resourceID(self):
        return self.resourceID

    def set_resourceID(self, resourceID):
        self.resourceID = resourceID

    def add_resourceID(self, value):
        self.resourceID.append(value)

    def insert_resourceID_at(self, index, value):
        self.resourceID.insert(index, value)

    def replace_resourceID_at(self, index, value):
        self.resourceID[index] = value

    def get_venID(self):
        return self.venID

    def set_venID(self, venID):
        self.venID = venID

    def add_venID(self, value):
        self.venID.append(value)

    def insert_venID_at(self, index, value):
        self.venID.insert(index, value)

    def replace_venID_at(self, index, value):
        self.venID[index] = value

    def get_partyID(self):
        return self.partyID

    def set_partyID(self, partyID):
        self.partyID = partyID

    def add_partyID(self, value):
        self.partyID.append(value)

    def insert_partyID_at(self, index, value):
        self.partyID.insert(index, value)

    def replace_partyID_at(self, index, value):
        self.partyID[index] = value

    def hasContent_(self):
        if (
            self.aggregatedPnode
            or self.endDeviceAsset
            or self.meterAsset
            or self.pnode
            or self.serviceArea
            or self.serviceDeliveryPoint
            or self.serviceLocation
            or self.transportInterface
            or self.groupID
            or self.groupName
            or self.resourceID
            or self.venID
            or self.partyID
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="EiTargetType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:power="http://docs.oasis-open.org/ns/emix/2011/06/power"  xmlns:emix="http://docs.oasis-open.org/ns/emix/2011/06"  xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("EiTargetType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="EiTargetType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ei:",
                name_="EiTargetType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="ei:", name_="EiTargetType"
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="EiTargetType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for aggregatedPnode_ in self.aggregatedPnode:
            aggregatedPnode_.export(
                outfile,
                level,
                namespace_="power:",
                name_="aggregatedPnode",
                pretty_print=pretty_print,
            )
        for endDeviceAsset_ in self.endDeviceAsset:
            endDeviceAsset_.export(
                outfile,
                level,
                namespace_="power:",
                name_="endDeviceAsset",
                pretty_print=pretty_print,
            )
        for meterAsset_ in self.meterAsset:
            meterAsset_.export(
                outfile,
                level,
                namespace_="power:",
                name_="meterAsset",
                pretty_print=pretty_print,
            )
        for pnode_ in self.pnode:
            pnode_.export(
                outfile,
                level,
                namespace_="power:",
                name_="pnode",
                pretty_print=pretty_print,
            )
        for serviceArea_ in self.serviceArea:
            serviceArea_.export(
                outfile,
                level,
                namespace_="emix:",
                name_="serviceArea",
                pretty_print=pretty_print,
            )
        for serviceDeliveryPoint_ in self.serviceDeliveryPoint:
            serviceDeliveryPoint_.export(
                outfile,
                level,
                namespace_="power:",
                name_="serviceDeliveryPoint",
                pretty_print=pretty_print,
            )
        for serviceLocation_ in self.serviceLocation:
            serviceLocation_.export(
                outfile,
                level,
                namespace_="power:",
                name_="serviceLocation",
                pretty_print=pretty_print,
            )
        for transportInterface_ in self.transportInterface:
            transportInterface_.export(
                outfile,
                level,
                namespace_="power:",
                name_="transportInterface",
                pretty_print=pretty_print,
            )
        for groupID_ in self.groupID:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:groupID>%s</ei:groupID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(groupID_), input_name="groupID"
                        )
                    ),
                    eol_,
                )
            )
        for groupName_ in self.groupName:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:groupName>%s</ei:groupName>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(groupName_), input_name="groupName"
                        )
                    ),
                    eol_,
                )
            )
        for resourceID_ in self.resourceID:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:resourceID>%s</ei:resourceID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(resourceID_), input_name="resourceID"
                        )
                    ),
                    eol_,
                )
            )
        for venID_ in self.venID:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:venID>%s</ei:venID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_xml(venID_), input_name="venID")
                    ),
                    eol_,
                )
            )
        for partyID_ in self.partyID:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:partyID>%s</ei:partyID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(partyID_), input_name="partyID"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "aggregatedPnode":
            obj_ = AggregatedPnodeType.factory()
            obj_.build(child_)
            self.aggregatedPnode.append(obj_)
            obj_.original_tagname_ = "aggregatedPnode"
        elif nodeName_ == "endDeviceAsset":
            obj_ = EndDeviceAssetType.factory()
            obj_.build(child_)
            self.endDeviceAsset.append(obj_)
            obj_.original_tagname_ = "endDeviceAsset"
        elif nodeName_ == "meterAsset":
            obj_ = MeterAssetType.factory()
            obj_.build(child_)
            self.meterAsset.append(obj_)
            obj_.original_tagname_ = "meterAsset"
        elif nodeName_ == "pnode":
            obj_ = PnodeType.factory()
            obj_.build(child_)
            self.pnode.append(obj_)
            obj_.original_tagname_ = "pnode"
        elif nodeName_ == "serviceArea":
            obj_ = ServiceAreaType.factory()
            obj_.build(child_)
            self.serviceArea.append(obj_)
            obj_.original_tagname_ = "serviceArea"
        elif nodeName_ == "serviceDeliveryPoint":
            obj_ = ServiceDeliveryPointType.factory()
            obj_.build(child_)
            self.serviceDeliveryPoint.append(obj_)
            obj_.original_tagname_ = "serviceDeliveryPoint"
        elif nodeName_ == "serviceLocation":
            obj_ = ServiceLocationType.factory()
            obj_.build(child_)
            self.serviceLocation.append(obj_)
            obj_.original_tagname_ = "serviceLocation"
        elif nodeName_ == "transportInterface":
            obj_ = TransportInterfaceType.factory()
            obj_.build(child_)
            self.transportInterface.append(obj_)
            obj_.original_tagname_ = "transportInterface"
        elif nodeName_ == "groupID":
            groupID_ = child_.text
            groupID_ = self.gds_validate_string(groupID_, node, "groupID")
            self.groupID.append(groupID_)
        elif nodeName_ == "groupName":
            groupName_ = child_.text
            groupName_ = self.gds_validate_string(groupName_, node, "groupName")
            self.groupName.append(groupName_)
        elif nodeName_ == "resourceID":
            resourceID_ = child_.text
            resourceID_ = self.gds_validate_string(resourceID_, node, "resourceID")
            self.resourceID.append(resourceID_)
        elif nodeName_ == "venID":
            venID_ = child_.text
            venID_ = self.gds_validate_string(venID_, node, "venID")
            self.venID.append(venID_)
        elif nodeName_ == "partyID":
            partyID_ = child_.text
            partyID_ = self.gds_validate_string(partyID_, node, "partyID")
            self.partyID.append(partyID_)


# end class EiTargetType


class eiEventSignalType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self,
        intervals=None,
        eiTarget=None,
        signalName=None,
        signalType=None,
        signalID=None,
        itemBase=None,
        currentValue=None,
    ):
        self.original_tagname_ = None
        self.intervals = intervals
        self.eiTarget = eiTarget
        self.signalName = signalName
        self.signalType = signalType
        self.signalID = signalID
        self.itemBase = itemBase
        self.currentValue = currentValue

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, eiEventSignalType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if eiEventSignalType.subclass:
            return eiEventSignalType.subclass(*args_, **kwargs_)
        else:
            return eiEventSignalType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_intervals(self):
        return self.intervals

    def set_intervals(self, intervals):
        self.intervals = intervals

    def get_eiTarget(self):
        return self.eiTarget

    def set_eiTarget(self, eiTarget):
        self.eiTarget = eiTarget

    def get_signalName(self):
        return self.signalName

    def set_signalName(self, signalName):
        self.signalName = signalName

    def get_signalType(self):
        return self.signalType

    def set_signalType(self, signalType):
        self.signalType = signalType

    def get_signalID(self):
        return self.signalID

    def set_signalID(self, signalID):
        self.signalID = signalID

    def get_itemBase(self):
        return self.itemBase

    def set_itemBase(self, itemBase):
        self.itemBase = itemBase

    def get_currentValue(self):
        return self.currentValue

    def set_currentValue(self, currentValue):
        self.currentValue = currentValue

    def hasContent_(self):
        if (
            self.intervals is not None
            or self.eiTarget is not None
            or self.signalName is not None
            or self.signalType is not None
            or self.signalID is not None
            or self.itemBase is not None
            or self.currentValue is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="eiEventSignalType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:strm="urn:ietf:params:xml:ns:icalendar-2.0:stream"  xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110"  xmlns:emix="http://docs.oasis-open.org/ns/emix/2011/06" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("eiEventSignalType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="eiEventSignalType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ei:",
                name_="eiEventSignalType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="ei:",
        name_="eiEventSignalType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="eiEventSignalType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.intervals is not None:
            self.intervals.export(
                outfile,
                level,
                namespace_="strm:",
                name_="intervals",
                pretty_print=pretty_print,
            )
        if self.eiTarget is not None:
            self.eiTarget.export(
                outfile,
                level,
                namespace_="ei:",
                name_="eiTarget",
                pretty_print=pretty_print,
            )
        if self.signalName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:signalName>%s</ei:signalName>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.signalName), input_name="signalName"
                        )
                    ),
                    eol_,
                )
            )
        if self.signalType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:signalType>%s</ei:signalType>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.signalType), input_name="signalType"
                        )
                    ),
                    eol_,
                )
            )
        if self.signalID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:signalID>%s</ei:signalID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.signalID), input_name="signalID"
                        )
                    ),
                    eol_,
                )
            )
        if self.itemBase is not None:
            self.itemBase.export(outfile, level, namespace_, pretty_print=pretty_print)
        if self.currentValue is not None:
            self.currentValue.export(
                outfile,
                level,
                namespace_="ei:",
                name_="currentValue",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "intervals":
            obj_ = intervals.factory()
            obj_.build(child_)
            self.intervals = obj_
            obj_.original_tagname_ = "intervals"
        elif nodeName_ == "eiTarget":
            obj_ = EiTargetType.factory()
            obj_.build(child_)
            self.eiTarget = obj_
            obj_.original_tagname_ = "eiTarget"
        elif nodeName_ == "signalName":
            signalName_ = child_.text
            signalName_ = self.gds_validate_string(signalName_, node, "signalName")
            self.signalName = signalName_
        elif nodeName_ == "signalType":
            signalType_ = child_.text
            if signalType_:
                signalType_ = re_.sub(String_cleanup_pat_, " ", signalType_).strip()
            else:
                signalType_ = ""
            signalType_ = self.gds_validate_string(signalType_, node, "signalType")
            self.signalType = signalType_
        elif nodeName_ == "signalID":
            signalID_ = child_.text
            signalID_ = self.gds_validate_string(signalID_, node, "signalID")
            self.signalID = signalID_
        elif nodeName_ == "itemBase":
            type_name_ = child_.attrib.get(
                "{http://www.w3.org/2001/XMLSchema-instance}type"
            )
            if type_name_ is None:
                type_name_ = child_.attrib.get("type")
            if type_name_ is not None:
                type_names_ = type_name_.split(":")
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    "Class not implemented for <itemBase> element"
                )
            self.itemBase = obj_
            obj_.original_tagname_ = "itemBase"
        elif nodeName_ == "customUnit":
            obj_ = BaseUnitType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "customUnit"
        elif nodeName_ == "current":
            obj_ = CurrentType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "current"
        elif nodeName_ == "currency":
            obj_ = currencyType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "currency"
        elif nodeName_ == "currencyPerKWh":
            obj_ = currencyType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "currencyPerKWh"
        elif nodeName_ == "currencyPerKW":
            obj_ = currencyType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "currencyPerKW"
        elif nodeName_ == "currencyPerThm":
            obj_ = currencyType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "currencyPerThm"
        elif nodeName_ == "frequency":
            obj_ = FrequencyType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "frequency"
        elif nodeName_ == "Therm":
            obj_ = ThermType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "Therm"
        elif nodeName_ == "temperature":
            obj_ = temperatureType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "temperature"
        elif nodeName_ == "pulseCount":
            obj_ = pulseCountType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "pulseCount"
        elif nodeName_ == "oadrGBDataDescription":
            obj_ = oadrGBItemBase.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "oadrGBDataDescription"
        elif nodeName_ == "voltage":
            obj_ = VoltageType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "voltage"
        elif nodeName_ == "energyItem":
            type_name_ = child_.attrib.get(
                "{http://www.w3.org/2001/XMLSchema-instance}type"
            )
            if type_name_ is None:
                type_name_ = child_.attrib.get("type")
            if type_name_ is not None:
                type_names_ = type_name_.split(":")
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    "Class not implemented for <energyItem> element"
                )
            self.itemBase = obj_
            obj_.original_tagname_ = "energyItem"
        elif nodeName_ == "powerItem":
            type_name_ = child_.attrib.get(
                "{http://www.w3.org/2001/XMLSchema-instance}type"
            )
            if type_name_ is None:
                type_name_ = child_.attrib.get("type")
            if type_name_ is not None:
                type_names_ = type_name_.split(":")
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    "Class not implemented for <powerItem> element"
                )
            self.itemBase = obj_
            obj_.original_tagname_ = "powerItem"
        elif nodeName_ == "energyApparent":
            obj_ = EnergyApparentType.factory()
            obj_.build(child_)
            self.energyItem = obj_
            obj_.original_tagname_ = "energyApparent"
        elif nodeName_ == "energyReactive":
            obj_ = EnergyReactiveType.factory()
            obj_.build(child_)
            self.energyItem = obj_
            obj_.original_tagname_ = "energyReactive"
        elif nodeName_ == "energyReal":
            obj_ = EnergyRealType.factory()
            obj_.build(child_)
            self.energyItem = obj_
            obj_.original_tagname_ = "energyReal"
        elif nodeName_ == "powerApparent":
            obj_ = PowerApparentType.factory()
            obj_.build(child_)
            self.powerItem = obj_
            obj_.original_tagname_ = "powerApparent"
        elif nodeName_ == "powerReactive":
            obj_ = PowerReactiveType.factory()
            obj_.build(child_)
            self.powerItem = obj_
            obj_.original_tagname_ = "powerReactive"
        elif nodeName_ == "powerReal":
            obj_ = PowerRealType.factory()
            obj_.build(child_)
            self.powerItem = obj_
            obj_.original_tagname_ = "powerReal"
        elif nodeName_ == "currentValue":
            obj_ = currentValueType.factory()
            obj_.build(child_)
            self.currentValue = obj_
            obj_.original_tagname_ = "currentValue"


# end class eiEventSignalType


class eiEventSignalsType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, eiEventSignal=None, eiEventBaseline=None):
        self.original_tagname_ = None
        if eiEventSignal is None:
            self.eiEventSignal = []
        else:
            self.eiEventSignal = eiEventSignal
        self.eiEventBaseline = eiEventBaseline

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, eiEventSignalsType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if eiEventSignalsType.subclass:
            return eiEventSignalsType.subclass(*args_, **kwargs_)
        else:
            return eiEventSignalsType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_eiEventSignal(self):
        return self.eiEventSignal

    def set_eiEventSignal(self, eiEventSignal):
        self.eiEventSignal = eiEventSignal

    def add_eiEventSignal(self, value):
        self.eiEventSignal.append(value)

    def insert_eiEventSignal_at(self, index, value):
        self.eiEventSignal.insert(index, value)

    def replace_eiEventSignal_at(self, index, value):
        self.eiEventSignal[index] = value

    def get_eiEventBaseline(self):
        return self.eiEventBaseline

    def set_eiEventBaseline(self, eiEventBaseline):
        self.eiEventBaseline = eiEventBaseline

    def hasContent_(self):
        if self.eiEventSignal or self.eiEventBaseline is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="eiEventSignalsType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("eiEventSignalsType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="eiEventSignalsType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ei:",
                name_="eiEventSignalsType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="ei:",
        name_="eiEventSignalsType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="eiEventSignalsType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for eiEventSignal_ in self.eiEventSignal:
            eiEventSignal_.export(
                outfile,
                level,
                namespace_="ei:",
                name_="eiEventSignal",
                pretty_print=pretty_print,
            )
        if self.eiEventBaseline is not None:
            self.eiEventBaseline.export(
                outfile,
                level,
                namespace_="ei:",
                name_="eiEventBaseline",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "eiEventSignal":
            obj_ = eiEventSignalType.factory()
            obj_.build(child_)
            self.eiEventSignal.append(obj_)
            obj_.original_tagname_ = "eiEventSignal"
        elif nodeName_ == "eiEventBaseline":
            obj_ = eiEventBaselineType.factory()
            obj_.build(child_)
            self.eiEventBaseline = obj_
            obj_.original_tagname_ = "eiEventBaseline"


# end class eiEventSignalsType


class eiEventBaselineType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self,
        dtstart=None,
        duration=None,
        intervals=None,
        baselineID=None,
        resourceID=None,
        baselineName=None,
        itemBase=None,
    ):
        self.original_tagname_ = None
        self.dtstart = dtstart
        self.duration = duration
        self.intervals = intervals
        self.baselineID = baselineID
        if resourceID is None:
            self.resourceID = []
        else:
            self.resourceID = resourceID
        self.baselineName = baselineName
        self.itemBase = itemBase

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, eiEventBaselineType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if eiEventBaselineType.subclass:
            return eiEventBaselineType.subclass(*args_, **kwargs_)
        else:
            return eiEventBaselineType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_dtstart(self):
        return self.dtstart

    def set_dtstart(self, dtstart):
        self.dtstart = dtstart

    def get_duration(self):
        return self.duration

    def set_duration(self, duration):
        self.duration = duration

    def get_intervals(self):
        return self.intervals

    def set_intervals(self, intervals):
        self.intervals = intervals

    def get_baselineID(self):
        return self.baselineID

    def set_baselineID(self, baselineID):
        self.baselineID = baselineID

    def get_resourceID(self):
        return self.resourceID

    def set_resourceID(self, resourceID):
        self.resourceID = resourceID

    def add_resourceID(self, value):
        self.resourceID.append(value)

    def insert_resourceID_at(self, index, value):
        self.resourceID.insert(index, value)

    def replace_resourceID_at(self, index, value):
        self.resourceID[index] = value

    def get_baselineName(self):
        return self.baselineName

    def set_baselineName(self, baselineName):
        self.baselineName = baselineName

    def get_itemBase(self):
        return self.itemBase

    def set_itemBase(self, itemBase):
        self.itemBase = itemBase

    def hasContent_(self):
        if (
            self.dtstart is not None
            or self.duration is not None
            or self.intervals is not None
            or self.baselineID is not None
            or self.resourceID
            or self.baselineName is not None
            or self.itemBase is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="eiEventBaselineType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:xcal="urn:ietf:params:xml:ns:icalendar-2.0"  xmlns:strm="urn:ietf:params:xml:ns:icalendar-2.0:stream"  xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110"  xmlns:emix="http://docs.oasis-open.org/ns/emix/2011/06" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("eiEventBaselineType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="eiEventBaselineType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ei:",
                name_="eiEventBaselineType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="ei:",
        name_="eiEventBaselineType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="eiEventBaselineType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.dtstart is not None:
            self.dtstart.export(
                outfile,
                level,
                namespace_="xcal:",
                name_="dtstart",
                pretty_print=pretty_print,
            )
        if self.duration is not None:
            self.duration.export(
                outfile,
                level,
                namespace_="xcal:",
                name_="duration",
                pretty_print=pretty_print,
            )
        if self.intervals is not None:
            self.intervals.export(
                outfile,
                level,
                namespace_="strm:",
                name_="intervals",
                pretty_print=pretty_print,
            )
        if self.baselineID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:baselineID>%s</ei:baselineID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.baselineID), input_name="baselineID"
                        )
                    ),
                    eol_,
                )
            )
        for resourceID_ in self.resourceID:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:resourceID>%s</ei:resourceID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(resourceID_), input_name="resourceID"
                        )
                    ),
                    eol_,
                )
            )
        if self.baselineName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:baselineName>%s</ei:baselineName>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.baselineName), input_name="baselineName"
                        )
                    ),
                    eol_,
                )
            )
        if self.itemBase is not None:
            self.itemBase.export(outfile, level, namespace_, pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "dtstart":
            obj_ = dtstart.factory()
            obj_.build(child_)
            self.dtstart = obj_
            obj_.original_tagname_ = "dtstart"
        elif nodeName_ == "duration":
            obj_ = DurationPropType.factory()
            obj_.build(child_)
            self.duration = obj_
            obj_.original_tagname_ = "duration"
        elif nodeName_ == "intervals":
            obj_ = intervals.factory()
            obj_.build(child_)
            self.intervals = obj_
            obj_.original_tagname_ = "intervals"
        elif nodeName_ == "baselineID":
            baselineID_ = child_.text
            baselineID_ = self.gds_validate_string(baselineID_, node, "baselineID")
            self.baselineID = baselineID_
        elif nodeName_ == "resourceID":
            resourceID_ = child_.text
            resourceID_ = self.gds_validate_string(resourceID_, node, "resourceID")
            self.resourceID.append(resourceID_)
        elif nodeName_ == "baselineName":
            baselineName_ = child_.text
            baselineName_ = self.gds_validate_string(
                baselineName_, node, "baselineName"
            )
            self.baselineName = baselineName_
        elif nodeName_ == "itemBase":
            type_name_ = child_.attrib.get(
                "{http://www.w3.org/2001/XMLSchema-instance}type"
            )
            if type_name_ is None:
                type_name_ = child_.attrib.get("type")
            if type_name_ is not None:
                type_names_ = type_name_.split(":")
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    "Class not implemented for <itemBase> element"
                )
            self.itemBase = obj_
            obj_.original_tagname_ = "itemBase"
        elif nodeName_ == "customUnit":
            obj_ = BaseUnitType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "customUnit"
        elif nodeName_ == "current":
            obj_ = CurrentType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "current"
        elif nodeName_ == "currency":
            obj_ = currencyType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "currency"
        elif nodeName_ == "currencyPerKWh":
            obj_ = currencyType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "currencyPerKWh"
        elif nodeName_ == "currencyPerKW":
            obj_ = currencyType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "currencyPerKW"
        elif nodeName_ == "currencyPerThm":
            obj_ = currencyType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "currencyPerThm"
        elif nodeName_ == "frequency":
            obj_ = FrequencyType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "frequency"
        elif nodeName_ == "Therm":
            obj_ = ThermType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "Therm"
        elif nodeName_ == "temperature":
            obj_ = temperatureType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "temperature"
        elif nodeName_ == "pulseCount":
            obj_ = pulseCountType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "pulseCount"
        elif nodeName_ == "oadrGBDataDescription":
            obj_ = oadrGBItemBase.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "oadrGBDataDescription"
        elif nodeName_ == "voltage":
            obj_ = VoltageType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "voltage"
        elif nodeName_ == "energyItem":
            type_name_ = child_.attrib.get(
                "{http://www.w3.org/2001/XMLSchema-instance}type"
            )
            if type_name_ is None:
                type_name_ = child_.attrib.get("type")
            if type_name_ is not None:
                type_names_ = type_name_.split(":")
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    "Class not implemented for <energyItem> element"
                )
            self.itemBase = obj_
            obj_.original_tagname_ = "energyItem"
        elif nodeName_ == "powerItem":
            type_name_ = child_.attrib.get(
                "{http://www.w3.org/2001/XMLSchema-instance}type"
            )
            if type_name_ is None:
                type_name_ = child_.attrib.get("type")
            if type_name_ is not None:
                type_names_ = type_name_.split(":")
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    "Class not implemented for <powerItem> element"
                )
            self.itemBase = obj_
            obj_.original_tagname_ = "powerItem"
        elif nodeName_ == "energyApparent":
            obj_ = EnergyApparentType.factory()
            obj_.build(child_)
            self.energyItem = obj_
            obj_.original_tagname_ = "energyApparent"
        elif nodeName_ == "energyReactive":
            obj_ = EnergyReactiveType.factory()
            obj_.build(child_)
            self.energyItem = obj_
            obj_.original_tagname_ = "energyReactive"
        elif nodeName_ == "energyReal":
            obj_ = EnergyRealType.factory()
            obj_.build(child_)
            self.energyItem = obj_
            obj_.original_tagname_ = "energyReal"
        elif nodeName_ == "powerApparent":
            obj_ = PowerApparentType.factory()
            obj_.build(child_)
            self.powerItem = obj_
            obj_.original_tagname_ = "powerApparent"
        elif nodeName_ == "powerReactive":
            obj_ = PowerReactiveType.factory()
            obj_.build(child_)
            self.powerItem = obj_
            obj_.original_tagname_ = "powerReactive"
        elif nodeName_ == "powerReal":
            obj_ = PowerRealType.factory()
            obj_.build(child_)
            self.powerItem = obj_
            obj_.original_tagname_ = "powerReal"


# end class eiEventBaselineType


class EiOptType(GeneratedsSuper):
    """Opts are used by the VEN to temporarily override the pre-existing
    agreement. For example, a VEN may opt in to events during the
    evening, or opt out from events during the world series."""

    subclass = None
    superclass = None

    def __init__(
        self,
        schemaVersion=None,
        optID=None,
        optType=None,
        optReason=None,
        marketContext=None,
        venID=None,
        vavailability=None,
        createdDateTime=None,
        extensiontype_=None,
    ):
        self.original_tagname_ = None
        self.schemaVersion = _cast(None, schemaVersion)
        self.optID = optID
        self.optType = optType
        self.optReason = optReason
        self.marketContext = marketContext
        self.venID = venID
        self.vavailability = vavailability
        if isinstance(createdDateTime, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(
                createdDateTime, "%Y-%m-%dT%H:%M:%S"
            )
        else:
            initvalue_ = createdDateTime
        self.createdDateTime = initvalue_
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, EiOptType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if EiOptType.subclass:
            return EiOptType.subclass(*args_, **kwargs_)
        else:
            return EiOptType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_optID(self):
        return self.optID

    def set_optID(self, optID):
        self.optID = optID

    def get_optType(self):
        return self.optType

    def set_optType(self, optType):
        self.optType = optType

    def get_optReason(self):
        return self.optReason

    def set_optReason(self, optReason):
        self.optReason = optReason

    def get_marketContext(self):
        return self.marketContext

    def set_marketContext(self, marketContext):
        self.marketContext = marketContext

    def get_venID(self):
        return self.venID

    def set_venID(self, venID):
        self.venID = venID

    def get_vavailability(self):
        return self.vavailability

    def set_vavailability(self, vavailability):
        self.vavailability = vavailability

    def get_createdDateTime(self):
        return self.createdDateTime

    def set_createdDateTime(self, createdDateTime):
        self.createdDateTime = createdDateTime

    def get_schemaVersion(self):
        return self.schemaVersion

    def set_schemaVersion(self, schemaVersion):
        self.schemaVersion = schemaVersion

    def get_extensiontype_(self):
        return self.extensiontype_

    def set_extensiontype_(self, extensiontype_):
        self.extensiontype_ = extensiontype_

    def hasContent_(self):
        if (
            self.optID is not None
            or self.optType is not None
            or self.optReason is not None
            or self.marketContext is not None
            or self.venID is not None
            or self.vavailability is not None
            or self.createdDateTime is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="EiOptType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110"  xmlns:emix="http://docs.oasis-open.org/ns/emix/2011/06"  xmlns:xcal="urn:ietf:params:xml:ns:icalendar-2.0" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("EiOptType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="EiOptType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ei:",
                name_="EiOptType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="ei:", name_="EiOptType"
    ):
        if self.schemaVersion is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            outfile.write(" schemaVersion=%s" % (quote_attrib(self.schemaVersion),))
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="EiOptType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.optID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:optID>%s</ei:optID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.optID), input_name="optID"
                        )
                    ),
                    eol_,
                )
            )
        if self.optType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:optType>%s</ei:optType>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.optType), input_name="optType"
                        )
                    ),
                    eol_,
                )
            )
        if self.optReason is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:optReason>%s</ei:optReason>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.optReason), input_name="optReason"
                        )
                    ),
                    eol_,
                )
            )
        if self.marketContext is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<emix:marketContext>%s</emix:marketContext>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.marketContext), input_name="marketContext"
                        )
                    ),
                    eol_,
                )
            )
        if self.venID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:venID>%s</ei:venID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.venID), input_name="venID"
                        )
                    ),
                    eol_,
                )
            )
        if self.vavailability is not None:
            self.vavailability.export(
                outfile,
                level,
                namespace_="xcal:",
                name_="vavailability",
                pretty_print=pretty_print,
            )
        if self.createdDateTime is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:createdDateTime>%s</ei:createdDateTime>%s"
                % (
                    self.gds_format_datetime(
                        self.createdDateTime, input_name="createdDateTime"
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("schemaVersion", node)
        if value is not None and "schemaVersion" not in already_processed:
            already_processed.add("schemaVersion")
            self.schemaVersion = value
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "optID":
            optID_ = child_.text
            optID_ = self.gds_validate_string(optID_, node, "optID")
            self.optID = optID_
        elif nodeName_ == "optType":
            optType_ = child_.text
            if optType_:
                optType_ = re_.sub(String_cleanup_pat_, " ", optType_).strip()
            else:
                optType_ = ""
            optType_ = self.gds_validate_string(optType_, node, "optType")
            self.optType = optType_
        elif nodeName_ == "optReason":
            optReason_ = child_.text
            optReason_ = self.gds_validate_string(optReason_, node, "optReason")
            self.optReason = optReason_
        elif nodeName_ == "marketContext":
            marketContext_ = child_.text
            marketContext_ = self.gds_validate_string(
                marketContext_, node, "marketContext"
            )
            self.marketContext = marketContext_
        elif nodeName_ == "venID":
            venID_ = child_.text
            venID_ = self.gds_validate_string(venID_, node, "venID")
            self.venID = venID_
        elif nodeName_ == "vavailability":
            obj_ = VavailabilityType.factory()
            obj_.build(child_)
            self.vavailability = obj_
            obj_.original_tagname_ = "vavailability"
        elif nodeName_ == "createdDateTime":
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.createdDateTime = dval_


# end class EiOptType


class ReportPayloadType(StreamPayloadBaseType):
    """Report Payload for use in Reports, snaps, and projections."""

    subclass = None
    superclass = StreamPayloadBaseType

    def __init__(
        self,
        rID=None,
        confidence=None,
        accuracy=None,
        payloadBase=None,
        extensiontype_=None,
    ):
        self.original_tagname_ = None
        super(ReportPayloadType, self).__init__(extensiontype_)
        self.rID = rID
        self.confidence = confidence
        self.accuracy = accuracy
        self.payloadBase = payloadBase
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ReportPayloadType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ReportPayloadType.subclass:
            return ReportPayloadType.subclass(*args_, **kwargs_)
        else:
            return ReportPayloadType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_rID(self):
        return self.rID

    def set_rID(self, rID):
        self.rID = rID

    def get_confidence(self):
        return self.confidence

    def set_confidence(self, confidence):
        self.confidence = confidence

    def get_accuracy(self):
        return self.accuracy

    def set_accuracy(self, accuracy):
        self.accuracy = accuracy

    def get_payloadBase(self):
        return self.payloadBase

    def set_payloadBase(self, payloadBase):
        self.payloadBase = payloadBase

    def get_extensiontype_(self):
        return self.extensiontype_

    def set_extensiontype_(self, extensiontype_):
        self.extensiontype_ = extensiontype_

    def hasContent_(self):
        if (
            self.rID is not None
            or self.confidence is not None
            or self.accuracy is not None
            or self.payloadBase is not None
            or super(ReportPayloadType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="ReportPayloadType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ReportPayloadType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="ReportPayloadType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ei:",
                name_="ReportPayloadType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="ei:",
        name_="ReportPayloadType",
    ):
        super(ReportPayloadType, self).exportAttributes(
            outfile, level, already_processed, namespace_, name_="ReportPayloadType"
        )
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="ReportPayloadType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(ReportPayloadType, self).exportChildren(
            outfile, level, namespace_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.rID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:rID>%s</ei:rID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.rID), input_name="rID")
                    ),
                    eol_,
                )
            )
        if self.confidence is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:confidence>%s</ei:confidence>%s"
                % (
                    self.gds_format_integer(self.confidence, input_name="confidence"),
                    eol_,
                )
            )
        if self.accuracy is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:accuracy>%s</ei:accuracy>%s"
                % (self.gds_format_float(self.accuracy, input_name="accuracy"), eol_)
            )
        if self.payloadBase is not None:
            self.payloadBase.export(
                outfile, level, namespace_, pretty_print=pretty_print
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value
        super(ReportPayloadType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "rID":
            rID_ = child_.text
            rID_ = self.gds_validate_string(rID_, node, "rID")
            self.rID = rID_
        elif nodeName_ == "confidence":
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, "requires integer: %s" % exp)
            ival_ = self.gds_validate_integer(ival_, node, "confidence")
            self.confidence = ival_
        elif nodeName_ == "accuracy":
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, "requires float or double: %s" % exp)
            fval_ = self.gds_validate_float(fval_, node, "accuracy")
            self.accuracy = fval_
        elif nodeName_ == "payloadBase":
            type_name_ = child_.attrib.get(
                "{http://www.w3.org/2001/XMLSchema-instance}type"
            )
            if type_name_ is None:
                type_name_ = child_.attrib.get("type")
            if type_name_ is not None:
                type_names_ = type_name_.split(":")
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    "Class not implemented for <payloadBase> element"
                )
            self.payloadBase = obj_
            obj_.original_tagname_ = "payloadBase"
        elif nodeName_ == "oadrPayloadResourceStatus":
            obj_ = oadrPayloadResourceStatusType.factory()
            obj_.build(child_)
            self.payloadBase = obj_
            obj_.original_tagname_ = "oadrPayloadResourceStatus"
        elif nodeName_ == "payloadFloat":
            obj_ = PayloadFloatType.factory()
            obj_.build(child_)
            self.payloadBase = obj_
            obj_.original_tagname_ = "payloadFloat"
        super(ReportPayloadType, self).buildChildren(child_, node, nodeName_, True)


# end class ReportPayloadType


class ReportSpecifierType(GeneratedsSuper):
    """Parameters that define the content of a Report Stream"""

    subclass = None
    superclass = None

    def __init__(
        self,
        reportSpecifierID=None,
        granularity=None,
        reportBackDuration=None,
        reportInterval=None,
        specifierPayload=None,
    ):
        self.original_tagname_ = None
        self.reportSpecifierID = reportSpecifierID
        self.granularity = granularity
        self.reportBackDuration = reportBackDuration
        self.reportInterval = reportInterval
        if specifierPayload is None:
            self.specifierPayload = []
        else:
            self.specifierPayload = specifierPayload

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ReportSpecifierType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ReportSpecifierType.subclass:
            return ReportSpecifierType.subclass(*args_, **kwargs_)
        else:
            return ReportSpecifierType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_reportSpecifierID(self):
        return self.reportSpecifierID

    def set_reportSpecifierID(self, reportSpecifierID):
        self.reportSpecifierID = reportSpecifierID

    def get_granularity(self):
        return self.granularity

    def set_granularity(self, granularity):
        self.granularity = granularity

    def get_reportBackDuration(self):
        return self.reportBackDuration

    def set_reportBackDuration(self, reportBackDuration):
        self.reportBackDuration = reportBackDuration

    def get_reportInterval(self):
        return self.reportInterval

    def set_reportInterval(self, reportInterval):
        self.reportInterval = reportInterval

    def get_specifierPayload(self):
        return self.specifierPayload

    def set_specifierPayload(self, specifierPayload):
        self.specifierPayload = specifierPayload

    def add_specifierPayload(self, value):
        self.specifierPayload.append(value)

    def insert_specifierPayload_at(self, index, value):
        self.specifierPayload.insert(index, value)

    def replace_specifierPayload_at(self, index, value):
        self.specifierPayload[index] = value

    def hasContent_(self):
        if (
            self.reportSpecifierID is not None
            or self.granularity is not None
            or self.reportBackDuration is not None
            or self.reportInterval is not None
            or self.specifierPayload
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="ReportSpecifierType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110"  xmlns:xcal="urn:ietf:params:xml:ns:icalendar-2.0" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ReportSpecifierType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="ReportSpecifierType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ei:",
                name_="ReportSpecifierType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="ei:",
        name_="ReportSpecifierType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="ReportSpecifierType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.reportSpecifierID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:reportSpecifierID>%s</ei:reportSpecifierID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.reportSpecifierID),
                            input_name="reportSpecifierID",
                        )
                    ),
                    eol_,
                )
            )
        if self.granularity is not None:
            self.granularity.export(
                outfile,
                level,
                namespace_="xcal:",
                name_="granularity",
                pretty_print=pretty_print,
            )
        if self.reportBackDuration is not None:
            self.reportBackDuration.export(
                outfile,
                level,
                namespace_,
                name_="reportBackDuration",
                pretty_print=pretty_print,
            )
        if self.reportInterval is not None:
            self.reportInterval.export(
                outfile,
                level,
                namespace_,
                name_="reportInterval",
                pretty_print=pretty_print,
            )
        for specifierPayload_ in self.specifierPayload:
            specifierPayload_.export(
                outfile,
                level,
                namespace_="ei:",
                name_="specifierPayload",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "reportSpecifierID":
            reportSpecifierID_ = child_.text
            reportSpecifierID_ = self.gds_validate_string(
                reportSpecifierID_, node, "reportSpecifierID"
            )
            self.reportSpecifierID = reportSpecifierID_
        elif nodeName_ == "granularity":
            obj_ = DurationPropType.factory()
            obj_.build(child_)
            self.granularity = obj_
            obj_.original_tagname_ = "granularity"
        elif nodeName_ == "reportBackDuration":
            obj_ = DurationPropType.factory()
            obj_.build(child_)
            self.reportBackDuration = obj_
            obj_.original_tagname_ = "reportBackDuration"
        elif nodeName_ == "reportInterval":
            obj_ = WsCalendarIntervalType.factory()
            obj_.build(child_)
            self.reportInterval = obj_
            obj_.original_tagname_ = "reportInterval"
        elif nodeName_ == "specifierPayload":
            obj_ = SpecifierPayloadType.factory()
            obj_.build(child_)
            self.specifierPayload.append(obj_)
            obj_.original_tagname_ = "specifierPayload"


# end class ReportSpecifierType


class SpecifierPayloadType(GeneratedsSuper):
    """Payload for use in Report Specifiers."""

    subclass = None
    superclass = None

    def __init__(self, rID=None, itemBase=None, readingType=None):
        self.original_tagname_ = None
        self.rID = rID
        self.itemBase = itemBase
        self.readingType = readingType

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SpecifierPayloadType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SpecifierPayloadType.subclass:
            return SpecifierPayloadType.subclass(*args_, **kwargs_)
        else:
            return SpecifierPayloadType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_rID(self):
        return self.rID

    def set_rID(self, rID):
        self.rID = rID

    def get_itemBase(self):
        return self.itemBase

    def set_itemBase(self, itemBase):
        self.itemBase = itemBase

    def get_readingType(self):
        return self.readingType

    def set_readingType(self, readingType):
        self.readingType = readingType

    def hasContent_(self):
        if (
            self.rID is not None
            or self.itemBase is not None
            or self.readingType is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="SpecifierPayloadType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110"  xmlns:emix="http://docs.oasis-open.org/ns/emix/2011/06" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SpecifierPayloadType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="SpecifierPayloadType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ei:",
                name_="SpecifierPayloadType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="ei:",
        name_="SpecifierPayloadType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="SpecifierPayloadType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.rID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:rID>%s</ei:rID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.rID), input_name="rID")
                    ),
                    eol_,
                )
            )
        if self.itemBase is not None:
            self.itemBase.export(outfile, level, namespace_, pretty_print=pretty_print)
        if self.readingType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:readingType>%s</ei:readingType>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.readingType), input_name="readingType"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "rID":
            rID_ = child_.text
            rID_ = self.gds_validate_string(rID_, node, "rID")
            self.rID = rID_
        elif nodeName_ == "itemBase":
            type_name_ = child_.attrib.get(
                "{http://www.w3.org/2001/XMLSchema-instance}type"
            )
            if type_name_ is None:
                type_name_ = child_.attrib.get("type")
            if type_name_ is not None:
                type_names_ = type_name_.split(":")
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    "Class not implemented for <itemBase> element"
                )
            self.itemBase = obj_
            obj_.original_tagname_ = "itemBase"
        elif nodeName_ == "customUnit":
            obj_ = BaseUnitType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "customUnit"
        elif nodeName_ == "current":
            obj_ = CurrentType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "current"
        elif nodeName_ == "currency":
            obj_ = currencyType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "currency"
        elif nodeName_ == "currencyPerKWh":
            obj_ = currencyType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "currencyPerKWh"
        elif nodeName_ == "currencyPerKW":
            obj_ = currencyType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "currencyPerKW"
        elif nodeName_ == "currencyPerThm":
            obj_ = currencyType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "currencyPerThm"
        elif nodeName_ == "frequency":
            obj_ = FrequencyType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "frequency"
        elif nodeName_ == "Therm":
            obj_ = ThermType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "Therm"
        elif nodeName_ == "temperature":
            obj_ = temperatureType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "temperature"
        elif nodeName_ == "pulseCount":
            obj_ = pulseCountType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "pulseCount"
        elif nodeName_ == "oadrGBDataDescription":
            obj_ = oadrGBItemBase.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "oadrGBDataDescription"
        elif nodeName_ == "voltage":
            obj_ = VoltageType.factory()
            obj_.build(child_)
            self.itemBase = obj_
            obj_.original_tagname_ = "voltage"
        elif nodeName_ == "energyItem":
            type_name_ = child_.attrib.get(
                "{http://www.w3.org/2001/XMLSchema-instance}type"
            )
            if type_name_ is None:
                type_name_ = child_.attrib.get("type")
            if type_name_ is not None:
                type_names_ = type_name_.split(":")
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    "Class not implemented for <energyItem> element"
                )
            self.itemBase = obj_
            obj_.original_tagname_ = "energyItem"
        elif nodeName_ == "powerItem":
            type_name_ = child_.attrib.get(
                "{http://www.w3.org/2001/XMLSchema-instance}type"
            )
            if type_name_ is None:
                type_name_ = child_.attrib.get("type")
            if type_name_ is not None:
                type_names_ = type_name_.split(":")
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    "Class not implemented for <powerItem> element"
                )
            self.itemBase = obj_
            obj_.original_tagname_ = "powerItem"
        elif nodeName_ == "energyApparent":
            obj_ = EnergyApparentType.factory()
            obj_.build(child_)
            self.energyItem = obj_
            obj_.original_tagname_ = "energyApparent"
        elif nodeName_ == "energyReactive":
            obj_ = EnergyReactiveType.factory()
            obj_.build(child_)
            self.energyItem = obj_
            obj_.original_tagname_ = "energyReactive"
        elif nodeName_ == "energyReal":
            obj_ = EnergyRealType.factory()
            obj_.build(child_)
            self.energyItem = obj_
            obj_.original_tagname_ = "energyReal"
        elif nodeName_ == "powerApparent":
            obj_ = PowerApparentType.factory()
            obj_.build(child_)
            self.powerItem = obj_
            obj_.original_tagname_ = "powerApparent"
        elif nodeName_ == "powerReactive":
            obj_ = PowerReactiveType.factory()
            obj_.build(child_)
            self.powerItem = obj_
            obj_.original_tagname_ = "powerReactive"
        elif nodeName_ == "powerReal":
            obj_ = PowerRealType.factory()
            obj_.build(child_)
            self.powerItem = obj_
            obj_.original_tagname_ = "powerReal"
        elif nodeName_ == "readingType":
            readingType_ = child_.text
            readingType_ = self.gds_validate_string(readingType_, node, "readingType")
            self.readingType = readingType_


# end class SpecifierPayloadType


class registrationID(GeneratedsSuper):
    """Identifier for Registration transaction. Not included in response to
    query registration unless already registered"""

    subclass = None
    superclass = None

    def __init__(self):
        self.original_tagname_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, registrationID)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if registrationID.subclass:
            return registrationID.subclass(*args_, **kwargs_)
        else:
            return registrationID(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="registrationID",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("registrationID")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="registrationID"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ei:",
                name_="registrationID",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="ei:",
        name_="registrationID",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="registrationID",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class registrationID


class refID(GeneratedsSuper):
    """Reference ID for a particular instance, transmittal, or artifact.
    Note: not the same as the native ID of the object being
    transmitted or shared."""

    subclass = None
    superclass = None

    def __init__(self):
        self.original_tagname_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, refID)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if refID.subclass:
            return refID.subclass(*args_, **kwargs_)
        else:
            return refID(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="refID",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("refID")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="refID"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ei:",
                name_="refID",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="ei:", name_="refID"
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ei:",
        name_="refID",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class refID


class EndDeviceAssetType(GeneratedsSuper):
    """The EndDeviceAssets are the physical device or devices which could
    be meters or other types of devices that may be of interest"""

    subclass = None
    superclass = None

    def __init__(self, mrid=None):
        self.original_tagname_ = None
        self.mrid = mrid

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, EndDeviceAssetType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if EndDeviceAssetType.subclass:
            return EndDeviceAssetType.subclass(*args_, **kwargs_)
        else:
            return EndDeviceAssetType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_mrid(self):
        return self.mrid

    def set_mrid(self, mrid):
        self.mrid = mrid

    def hasContent_(self):
        if self.mrid is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="power:",
        name_="EndDeviceAssetType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:power="http://docs.oasis-open.org/ns/emix/2011/06/power" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("EndDeviceAssetType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="EndDeviceAssetType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="power:",
                name_="EndDeviceAssetType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="power:",
        name_="EndDeviceAssetType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="power:",
        name_="EndDeviceAssetType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.mrid is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<power:mrid>%s</power:mrid>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.mrid), input_name="mrid")
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "mrid":
            mrid_ = child_.text
            mrid_ = self.gds_validate_string(mrid_, node, "mrid")
            self.mrid = mrid_


# end class EndDeviceAssetType


class MeterAssetType(GeneratedsSuper):
    """The MeterAsset is the physical device or devices that performs the
    role of the meter"""

    subclass = None
    superclass = None

    def __init__(self, mrid=None):
        self.original_tagname_ = None
        self.mrid = mrid

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, MeterAssetType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if MeterAssetType.subclass:
            return MeterAssetType.subclass(*args_, **kwargs_)
        else:
            return MeterAssetType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_mrid(self):
        return self.mrid

    def set_mrid(self, mrid):
        self.mrid = mrid

    def hasContent_(self):
        if self.mrid is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="power:",
        name_="MeterAssetType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:power="http://docs.oasis-open.org/ns/emix/2011/06/power" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("MeterAssetType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="MeterAssetType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="power:",
                name_="MeterAssetType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="power:",
        name_="MeterAssetType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="power:",
        name_="MeterAssetType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.mrid is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<power:mrid>%s</power:mrid>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.mrid), input_name="mrid")
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "mrid":
            mrid_ = child_.text
            mrid_ = self.gds_validate_string(mrid_, node, "mrid")
            self.mrid = mrid_


# end class MeterAssetType


class PnodeType(GeneratedsSuper):
    """A pricing node is directly associated with a connectivity node. It
    is a pricing location for which market participants submit their
    bids, offers, buy/sell CRRs, and settle."""

    subclass = None
    superclass = None

    def __init__(self, node=None):
        self.original_tagname_ = None
        self.node = node

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, PnodeType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PnodeType.subclass:
            return PnodeType.subclass(*args_, **kwargs_)
        else:
            return PnodeType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_node(self):
        return self.node

    def set_node(self, node):
        self.node = node

    def hasContent_(self):
        if self.node is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="power:",
        name_="PnodeType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:power="http://docs.oasis-open.org/ns/emix/2011/06/power" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("PnodeType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="PnodeType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="power:",
                name_="PnodeType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="power:", name_="PnodeType"
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="power:",
        name_="PnodeType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.node is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<power:node>%s</power:node>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.node), input_name="node")
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "node":
            node_ = child_.text
            node_ = self.gds_validate_string(node_, node, "node")
            self.node = node_


# end class PnodeType


class AggregatedPnodeType(GeneratedsSuper):
    """An aggregated pricing node is a specialized type of pricing node
    used to model items such as System Zone, Default Price Zone,
    Custom Price Zone, Control Area, Aggregated Generation,
    Aggregated Participating Load, Aggregated Non-Participating
    Load, Trading Hub, DCA Zone"""

    subclass = None
    superclass = None

    def __init__(self, node=None):
        self.original_tagname_ = None
        self.node = node

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AggregatedPnodeType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AggregatedPnodeType.subclass:
            return AggregatedPnodeType.subclass(*args_, **kwargs_)
        else:
            return AggregatedPnodeType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_node(self):
        return self.node

    def set_node(self, node):
        self.node = node

    def hasContent_(self):
        if self.node is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="power:",
        name_="AggregatedPnodeType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:power="http://docs.oasis-open.org/ns/emix/2011/06/power" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("AggregatedPnodeType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="AggregatedPnodeType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="power:",
                name_="AggregatedPnodeType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="power:",
        name_="AggregatedPnodeType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="power:",
        name_="AggregatedPnodeType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.node is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<power:node>%s</power:node>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.node), input_name="node")
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "node":
            node_ = child_.text
            node_ = self.gds_validate_string(node_, node, "node")
            self.node = node_


# end class AggregatedPnodeType


class ServiceLocationType(GeneratedsSuper):
    """A customer ServiceLocation has one or more ServiceDeliveryPoint(s),
    which in turn relate to Meters. The location may be a point or a
    polygon, depending on the specific circumstances. For
    distribution, the ServiceLocation is typically the location of
    the utility customer's premise."""

    subclass = None
    superclass = None

    def __init__(self, FeatureCollection=None):
        self.original_tagname_ = None
        self.FeatureCollection = FeatureCollection

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ServiceLocationType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ServiceLocationType.subclass:
            return ServiceLocationType.subclass(*args_, **kwargs_)
        else:
            return ServiceLocationType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_FeatureCollection(self):
        return self.FeatureCollection

    def set_FeatureCollection(self, FeatureCollection):
        self.FeatureCollection = FeatureCollection

    def hasContent_(self):
        if self.FeatureCollection is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="power:",
        name_="ServiceLocationType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:power="http://docs.oasis-open.org/ns/emix/2011/06/power"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ServiceLocationType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="ServiceLocationType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="power:",
                name_="ServiceLocationType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="power:",
        name_="ServiceLocationType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="power:",
        name_="ServiceLocationType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.FeatureCollection is not None:
            self.FeatureCollection.export(
                outfile,
                level,
                namespace_="gml:",
                name_="FeatureCollection",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "FeatureCollection":
            obj_ = FeatureCollection.factory()
            obj_.build(child_)
            self.FeatureCollection = obj_
            obj_.original_tagname_ = "FeatureCollection"


# end class ServiceLocationType


class ServiceDeliveryPointType(GeneratedsSuper):
    """Logical point on the network where the ownership of the service
    changes hands. It is one of potentially many service points
    within a ServiceLocation, delivering service in accordance with
    a CustomerAgreement. Used at the place where a meter may be
    installed."""

    subclass = None
    superclass = None

    def __init__(self, node=None):
        self.original_tagname_ = None
        self.node = node

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ServiceDeliveryPointType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ServiceDeliveryPointType.subclass:
            return ServiceDeliveryPointType.subclass(*args_, **kwargs_)
        else:
            return ServiceDeliveryPointType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_node(self):
        return self.node

    def set_node(self, node):
        self.node = node

    def hasContent_(self):
        if self.node is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="power:",
        name_="ServiceDeliveryPointType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:power="http://docs.oasis-open.org/ns/emix/2011/06/power" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ServiceDeliveryPointType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespace_,
            name_="ServiceDeliveryPointType",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="power:",
                name_="ServiceDeliveryPointType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="power:",
        name_="ServiceDeliveryPointType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="power:",
        name_="ServiceDeliveryPointType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.node is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<power:node>%s</power:node>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.node), input_name="node")
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "node":
            node_ = child_.text
            node_ = self.gds_validate_string(node_, node, "node")
            self.node = node_


# end class ServiceDeliveryPointType


class TransportInterfaceType(GeneratedsSuper):
    """The Transport Interface delineates the edges at either end of a
    transport segment."""

    subclass = None
    superclass = None

    def __init__(self, pointOfReceipt=None, pointOfDelivery=None):
        self.original_tagname_ = None
        self.pointOfReceipt = pointOfReceipt
        self.validate_NodeType(self.pointOfReceipt)
        self.pointOfDelivery = pointOfDelivery
        self.validate_NodeType(self.pointOfDelivery)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TransportInterfaceType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TransportInterfaceType.subclass:
            return TransportInterfaceType.subclass(*args_, **kwargs_)
        else:
            return TransportInterfaceType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_pointOfReceipt(self):
        return self.pointOfReceipt

    def set_pointOfReceipt(self, pointOfReceipt):
        self.pointOfReceipt = pointOfReceipt

    def get_pointOfDelivery(self):
        return self.pointOfDelivery

    def set_pointOfDelivery(self, pointOfDelivery):
        self.pointOfDelivery = pointOfDelivery

    def validate_NodeType(self, value):
        # Validate type NodeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            pass

    def hasContent_(self):
        if self.pointOfReceipt is not None or self.pointOfDelivery is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="power:",
        name_="TransportInterfaceType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:power="http://docs.oasis-open.org/ns/emix/2011/06/power" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("TransportInterfaceType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespace_,
            name_="TransportInterfaceType",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="power:",
                name_="TransportInterfaceType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="power:",
        name_="TransportInterfaceType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="power:",
        name_="TransportInterfaceType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.pointOfReceipt is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<power:pointOfReceipt>%s</power:pointOfReceipt>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.pointOfReceipt), input_name="pointOfReceipt"
                        )
                    ),
                    eol_,
                )
            )
        if self.pointOfDelivery is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<power:pointOfDelivery>%s</power:pointOfDelivery>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.pointOfDelivery),
                            input_name="pointOfDelivery",
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "pointOfReceipt":
            pointOfReceipt_ = child_.text
            pointOfReceipt_ = self.gds_validate_string(
                pointOfReceipt_, node, "pointOfReceipt"
            )
            self.pointOfReceipt = pointOfReceipt_
            # validate type NodeType
            self.validate_NodeType(self.pointOfReceipt)
        elif nodeName_ == "pointOfDelivery":
            pointOfDelivery_ = child_.text
            pointOfDelivery_ = self.gds_validate_string(
                pointOfDelivery_, node, "pointOfDelivery"
            )
            self.pointOfDelivery = pointOfDelivery_
            # validate type NodeType
            self.validate_NodeType(self.pointOfDelivery)


# end class TransportInterfaceType


class EnergyApparentType(GeneratedsSuper):
    """Apparent Energy, measured in volt-ampere hours (VAh)"""

    subclass = None
    superclass = None

    def __init__(self, itemDescription=None, itemUnits=None, siScaleCode=None):
        self.original_tagname_ = None
        self.itemDescription = itemDescription
        self.itemUnits = itemUnits
        self.siScaleCode = siScaleCode

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, EnergyApparentType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if EnergyApparentType.subclass:
            return EnergyApparentType.subclass(*args_, **kwargs_)
        else:
            return EnergyApparentType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_itemDescription(self):
        return self.itemDescription

    def set_itemDescription(self, itemDescription):
        self.itemDescription = itemDescription

    def get_itemUnits(self):
        return self.itemUnits

    def set_itemUnits(self, itemUnits):
        self.itemUnits = itemUnits

    def get_siScaleCode(self):
        return self.siScaleCode

    def set_siScaleCode(self, siScaleCode):
        self.siScaleCode = siScaleCode

    def hasContent_(self):
        if (
            self.itemDescription is not None
            or self.itemUnits is not None
            or self.siScaleCode is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="power:",
        name_="EnergyApparentType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:scale="http://docs.oasis-open.org/ns/emix/2011/06/siscale"  xmlns:power="http://docs.oasis-open.org/ns/emix/2011/06/power"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("EnergyApparentType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="EnergyApparentType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="power:",
                name_="EnergyApparentType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="power:",
        name_="EnergyApparentType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="power:",
        name_="EnergyApparentType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.itemDescription is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<power:itemDescription>%s</power:itemDescription>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.itemDescription),
                            input_name="itemDescription",
                        )
                    ),
                    eol_,
                )
            )
        if self.itemUnits is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<power:itemUnits>%s</power:itemUnits>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.itemUnits), input_name="itemUnits"
                        )
                    ),
                    eol_,
                )
            )
        if self.siScaleCode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<scale:siScaleCode>%s</scale:siScaleCode>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.siScaleCode), input_name="siScaleCode"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "itemDescription":
            itemDescription_ = child_.text
            itemDescription_ = self.gds_validate_string(
                itemDescription_, node, "itemDescription"
            )
            self.itemDescription = itemDescription_
        elif nodeName_ == "itemUnits":
            itemUnits_ = child_.text
            itemUnits_ = self.gds_validate_string(itemUnits_, node, "itemUnits")
            self.itemUnits = itemUnits_
        elif nodeName_ == "siScaleCode":
            siScaleCode_ = child_.text
            siScaleCode_ = self.gds_validate_string(siScaleCode_, node, "siScaleCode")
            self.siScaleCode = siScaleCode_


# end class EnergyApparentType


class EnergyReactiveType(GeneratedsSuper):
    """Reactive Energy, volt-amperes reactive hours (VARh)"""

    subclass = None
    superclass = None

    def __init__(self, itemDescription=None, itemUnits=None, siScaleCode=None):
        self.original_tagname_ = None
        self.itemDescription = itemDescription
        self.itemUnits = itemUnits
        self.siScaleCode = siScaleCode

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, EnergyReactiveType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if EnergyReactiveType.subclass:
            return EnergyReactiveType.subclass(*args_, **kwargs_)
        else:
            return EnergyReactiveType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_itemDescription(self):
        return self.itemDescription

    def set_itemDescription(self, itemDescription):
        self.itemDescription = itemDescription

    def get_itemUnits(self):
        return self.itemUnits

    def set_itemUnits(self, itemUnits):
        self.itemUnits = itemUnits

    def get_siScaleCode(self):
        return self.siScaleCode

    def set_siScaleCode(self, siScaleCode):
        self.siScaleCode = siScaleCode

    def hasContent_(self):
        if (
            self.itemDescription is not None
            or self.itemUnits is not None
            or self.siScaleCode is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="power:",
        name_="EnergyReactiveType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:scale="http://docs.oasis-open.org/ns/emix/2011/06/siscale"  xmlns:power="http://docs.oasis-open.org/ns/emix/2011/06/power"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("EnergyReactiveType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="EnergyReactiveType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="power:",
                name_="EnergyReactiveType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="power:",
        name_="EnergyReactiveType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="power:",
        name_="EnergyReactiveType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.itemDescription is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<power:itemDescription>%s</power:itemDescription>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.itemDescription),
                            input_name="itemDescription",
                        )
                    ),
                    eol_,
                )
            )
        if self.itemUnits is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<power:itemUnits>%s</power:itemUnits>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.itemUnits), input_name="itemUnits"
                        )
                    ),
                    eol_,
                )
            )
        if self.siScaleCode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<scale:siScaleCode>%s</scale:siScaleCode>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.siScaleCode), input_name="siScaleCode"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "itemDescription":
            itemDescription_ = child_.text
            itemDescription_ = self.gds_validate_string(
                itemDescription_, node, "itemDescription"
            )
            self.itemDescription = itemDescription_
        elif nodeName_ == "itemUnits":
            itemUnits_ = child_.text
            itemUnits_ = self.gds_validate_string(itemUnits_, node, "itemUnits")
            self.itemUnits = itemUnits_
        elif nodeName_ == "siScaleCode":
            siScaleCode_ = child_.text
            siScaleCode_ = self.gds_validate_string(siScaleCode_, node, "siScaleCode")
            self.siScaleCode = siScaleCode_


# end class EnergyReactiveType


class EnergyRealType(GeneratedsSuper):
    """Real Energy, Watt Hours (Wh)"""

    subclass = None
    superclass = None

    def __init__(self, itemDescription=None, itemUnits=None, siScaleCode=None):
        self.original_tagname_ = None
        self.itemDescription = itemDescription
        self.itemUnits = itemUnits
        self.siScaleCode = siScaleCode

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, EnergyRealType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if EnergyRealType.subclass:
            return EnergyRealType.subclass(*args_, **kwargs_)
        else:
            return EnergyRealType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_itemDescription(self):
        return self.itemDescription

    def set_itemDescription(self, itemDescription):
        self.itemDescription = itemDescription

    def get_itemUnits(self):
        return self.itemUnits

    def set_itemUnits(self, itemUnits):
        self.itemUnits = itemUnits

    def get_siScaleCode(self):
        return self.siScaleCode

    def set_siScaleCode(self, siScaleCode):
        self.siScaleCode = siScaleCode

    def hasContent_(self):
        if (
            self.itemDescription is not None
            or self.itemUnits is not None
            or self.siScaleCode is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="power:",
        name_="EnergyRealType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:scale="http://docs.oasis-open.org/ns/emix/2011/06/siscale"  xmlns:power="http://docs.oasis-open.org/ns/emix/2011/06/power"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("EnergyRealType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="EnergyRealType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="power:",
                name_="EnergyRealType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="power:",
        name_="EnergyRealType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="power:",
        name_="EnergyRealType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.itemDescription is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<power:itemDescription>%s</power:itemDescription>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.itemDescription),
                            input_name="itemDescription",
                        )
                    ),
                    eol_,
                )
            )
        if self.itemUnits is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<power:itemUnits>%s</power:itemUnits>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.itemUnits), input_name="itemUnits"
                        )
                    ),
                    eol_,
                )
            )
        if self.siScaleCode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<scale:siScaleCode>%s</scale:siScaleCode>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.siScaleCode), input_name="siScaleCode"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "itemDescription":
            itemDescription_ = child_.text
            itemDescription_ = self.gds_validate_string(
                itemDescription_, node, "itemDescription"
            )
            self.itemDescription = itemDescription_
        elif nodeName_ == "itemUnits":
            itemUnits_ = child_.text
            itemUnits_ = self.gds_validate_string(itemUnits_, node, "itemUnits")
            self.itemUnits = itemUnits_
        elif nodeName_ == "siScaleCode":
            siScaleCode_ = child_.text
            siScaleCode_ = self.gds_validate_string(siScaleCode_, node, "siScaleCode")
            self.siScaleCode = siScaleCode_


# end class EnergyRealType


class PowerApparentType(GeneratedsSuper):
    """Apparent Power measured in volt-amperes (VA)"""

    subclass = None
    superclass = None

    def __init__(
        self,
        itemDescription=None,
        itemUnits=None,
        siScaleCode=None,
        powerAttributes=None,
    ):
        self.original_tagname_ = None
        self.itemDescription = itemDescription
        self.itemUnits = itemUnits
        self.siScaleCode = siScaleCode
        self.powerAttributes = powerAttributes

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, PowerApparentType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PowerApparentType.subclass:
            return PowerApparentType.subclass(*args_, **kwargs_)
        else:
            return PowerApparentType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_itemDescription(self):
        return self.itemDescription

    def set_itemDescription(self, itemDescription):
        self.itemDescription = itemDescription

    def get_itemUnits(self):
        return self.itemUnits

    def set_itemUnits(self, itemUnits):
        self.itemUnits = itemUnits

    def get_siScaleCode(self):
        return self.siScaleCode

    def set_siScaleCode(self, siScaleCode):
        self.siScaleCode = siScaleCode

    def get_powerAttributes(self):
        return self.powerAttributes

    def set_powerAttributes(self, powerAttributes):
        self.powerAttributes = powerAttributes

    def hasContent_(self):
        if (
            self.itemDescription is not None
            or self.itemUnits is not None
            or self.siScaleCode is not None
            or self.powerAttributes is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="power:",
        name_="PowerApparentType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:scale="http://docs.oasis-open.org/ns/emix/2011/06/siscale"  xmlns:power="http://docs.oasis-open.org/ns/emix/2011/06/power" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("PowerApparentType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="PowerApparentType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="power:",
                name_="PowerApparentType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="power:",
        name_="PowerApparentType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="power:",
        name_="PowerApparentType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.itemDescription is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<power:itemDescription>%s</power:itemDescription>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.itemDescription),
                            input_name="itemDescription",
                        )
                    ),
                    eol_,
                )
            )
        if self.itemUnits is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<power:itemUnits>%s</power:itemUnits>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.itemUnits), input_name="itemUnits"
                        )
                    ),
                    eol_,
                )
            )
        if self.siScaleCode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<scale:siScaleCode>%s</scale:siScaleCode>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.siScaleCode), input_name="siScaleCode"
                        )
                    ),
                    eol_,
                )
            )
        if self.powerAttributes is not None:
            self.powerAttributes.export(
                outfile,
                level,
                namespace_="power:",
                name_="powerAttributes",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "itemDescription":
            itemDescription_ = child_.text
            itemDescription_ = self.gds_validate_string(
                itemDescription_, node, "itemDescription"
            )
            self.itemDescription = itemDescription_
        elif nodeName_ == "itemUnits":
            itemUnits_ = child_.text
            itemUnits_ = self.gds_validate_string(itemUnits_, node, "itemUnits")
            self.itemUnits = itemUnits_
        elif nodeName_ == "siScaleCode":
            siScaleCode_ = child_.text
            siScaleCode_ = self.gds_validate_string(siScaleCode_, node, "siScaleCode")
            self.siScaleCode = siScaleCode_
        elif nodeName_ == "powerAttributes":
            obj_ = PowerAttributesType.factory()
            obj_.build(child_)
            self.powerAttributes = obj_
            obj_.original_tagname_ = "powerAttributes"


# end class PowerApparentType


class PowerReactiveType(GeneratedsSuper):
    """Reactive power, measured in volt-amperes reactive (VAR)"""

    subclass = None
    superclass = None

    def __init__(
        self,
        itemDescription=None,
        itemUnits=None,
        siScaleCode=None,
        powerAttributes=None,
    ):
        self.original_tagname_ = None
        self.itemDescription = itemDescription
        self.itemUnits = itemUnits
        self.siScaleCode = siScaleCode
        self.powerAttributes = powerAttributes

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, PowerReactiveType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PowerReactiveType.subclass:
            return PowerReactiveType.subclass(*args_, **kwargs_)
        else:
            return PowerReactiveType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_itemDescription(self):
        return self.itemDescription

    def set_itemDescription(self, itemDescription):
        self.itemDescription = itemDescription

    def get_itemUnits(self):
        return self.itemUnits

    def set_itemUnits(self, itemUnits):
        self.itemUnits = itemUnits

    def get_siScaleCode(self):
        return self.siScaleCode

    def set_siScaleCode(self, siScaleCode):
        self.siScaleCode = siScaleCode

    def get_powerAttributes(self):
        return self.powerAttributes

    def set_powerAttributes(self, powerAttributes):
        self.powerAttributes = powerAttributes

    def hasContent_(self):
        if (
            self.itemDescription is not None
            or self.itemUnits is not None
            or self.siScaleCode is not None
            or self.powerAttributes is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="power:",
        name_="PowerReactiveType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:scale="http://docs.oasis-open.org/ns/emix/2011/06/siscale"  xmlns:power="http://docs.oasis-open.org/ns/emix/2011/06/power" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("PowerReactiveType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="PowerReactiveType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="power:",
                name_="PowerReactiveType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="power:",
        name_="PowerReactiveType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="power:",
        name_="PowerReactiveType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.itemDescription is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<power:itemDescription>%s</power:itemDescription>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.itemDescription),
                            input_name="itemDescription",
                        )
                    ),
                    eol_,
                )
            )
        if self.itemUnits is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<power:itemUnits>%s</power:itemUnits>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.itemUnits), input_name="itemUnits"
                        )
                    ),
                    eol_,
                )
            )
        if self.siScaleCode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<scale:siScaleCode>%s</scale:siScaleCode>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.siScaleCode), input_name="siScaleCode"
                        )
                    ),
                    eol_,
                )
            )
        if self.powerAttributes is not None:
            self.powerAttributes.export(
                outfile,
                level,
                namespace_="power:",
                name_="powerAttributes",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "itemDescription":
            itemDescription_ = child_.text
            itemDescription_ = self.gds_validate_string(
                itemDescription_, node, "itemDescription"
            )
            self.itemDescription = itemDescription_
        elif nodeName_ == "itemUnits":
            itemUnits_ = child_.text
            itemUnits_ = self.gds_validate_string(itemUnits_, node, "itemUnits")
            self.itemUnits = itemUnits_
        elif nodeName_ == "siScaleCode":
            siScaleCode_ = child_.text
            siScaleCode_ = self.gds_validate_string(siScaleCode_, node, "siScaleCode")
            self.siScaleCode = siScaleCode_
        elif nodeName_ == "powerAttributes":
            obj_ = PowerAttributesType.factory()
            obj_.build(child_)
            self.powerAttributes = obj_
            obj_.original_tagname_ = "powerAttributes"


# end class PowerReactiveType


class PowerRealType(GeneratedsSuper):
    """Real power measured in Watts (W) or Joules/second (J/s)"""

    subclass = None
    superclass = None

    def __init__(
        self,
        itemDescription=None,
        itemUnits=None,
        siScaleCode=None,
        powerAttributes=None,
    ):
        self.original_tagname_ = None
        self.itemDescription = itemDescription
        self.itemUnits = itemUnits
        self.validate_itemUnitsType(self.itemUnits)
        self.siScaleCode = siScaleCode
        self.powerAttributes = powerAttributes

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, PowerRealType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PowerRealType.subclass:
            return PowerRealType.subclass(*args_, **kwargs_)
        else:
            return PowerRealType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_itemDescription(self):
        return self.itemDescription

    def set_itemDescription(self, itemDescription):
        self.itemDescription = itemDescription

    def get_itemUnits(self):
        return self.itemUnits

    def set_itemUnits(self, itemUnits):
        self.itemUnits = itemUnits

    def get_siScaleCode(self):
        return self.siScaleCode

    def set_siScaleCode(self, siScaleCode):
        self.siScaleCode = siScaleCode

    def get_powerAttributes(self):
        return self.powerAttributes

    def set_powerAttributes(self, powerAttributes):
        self.powerAttributes = powerAttributes

    def validate_itemUnitsType(self, value):
        # Validate type itemUnitsType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ["W", "J/s"]
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn(
                    'Value "%(value)s" does not match xsd enumeration restriction on itemUnitsType'
                    % {"value": value.encode("utf-8")}
                )

    def hasContent_(self):
        if (
            self.itemDescription is not None
            or self.itemUnits is not None
            or self.siScaleCode is not None
            or self.powerAttributes is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="power:",
        name_="PowerRealType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:scale="http://docs.oasis-open.org/ns/emix/2011/06/siscale"  xmlns:power="http://docs.oasis-open.org/ns/emix/2011/06/power" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("PowerRealType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="PowerRealType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="power:",
                name_="PowerRealType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="power:",
        name_="PowerRealType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="power:",
        name_="PowerRealType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.itemDescription is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<power:itemDescription>%s</power:itemDescription>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.itemDescription),
                            input_name="itemDescription",
                        )
                    ),
                    eol_,
                )
            )
        if self.itemUnits is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<power:itemUnits>%s</power:itemUnits>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.itemUnits), input_name="itemUnits"
                        )
                    ),
                    eol_,
                )
            )
        if self.siScaleCode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<scale:siScaleCode>%s</scale:siScaleCode>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.siScaleCode), input_name="siScaleCode"
                        )
                    ),
                    eol_,
                )
            )
        if self.powerAttributes is not None:
            self.powerAttributes.export(
                outfile,
                level,
                namespace_="power:",
                name_="powerAttributes",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "itemDescription":
            itemDescription_ = child_.text
            itemDescription_ = self.gds_validate_string(
                itemDescription_, node, "itemDescription"
            )
            self.itemDescription = itemDescription_
        elif nodeName_ == "itemUnits":
            itemUnits_ = child_.text
            if itemUnits_:
                itemUnits_ = re_.sub(String_cleanup_pat_, " ", itemUnits_).strip()
            else:
                itemUnits_ = ""
            itemUnits_ = self.gds_validate_string(itemUnits_, node, "itemUnits")
            self.itemUnits = itemUnits_
            # validate type itemUnitsType
            self.validate_itemUnitsType(self.itemUnits)
        elif nodeName_ == "siScaleCode":
            siScaleCode_ = child_.text
            siScaleCode_ = self.gds_validate_string(siScaleCode_, node, "siScaleCode")
            self.siScaleCode = siScaleCode_
        elif nodeName_ == "powerAttributes":
            obj_ = PowerAttributesType.factory()
            obj_.build(child_)
            self.powerAttributes = obj_
            obj_.original_tagname_ = "powerAttributes"


# end class PowerRealType


class PowerAttributesType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, hertz=None, voltage=None, ac=None):
        self.original_tagname_ = None
        self.hertz = hertz
        self.voltage = voltage
        self.ac = ac

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PowerAttributesType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PowerAttributesType.subclass:
            return PowerAttributesType.subclass(*args_, **kwargs_)
        else:
            return PowerAttributesType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_hertz(self):
        return self.hertz

    def set_hertz(self, hertz):
        self.hertz = hertz

    def get_voltage(self):
        return self.voltage

    def set_voltage(self, voltage):
        self.voltage = voltage

    def get_ac(self):
        return self.ac

    def set_ac(self, ac):
        self.ac = ac

    def hasContent_(self):
        if self.hertz is not None or self.voltage is not None or self.ac is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="power:",
        name_="PowerAttributesType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:power="http://docs.oasis-open.org/ns/emix/2011/06/power"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("PowerAttributesType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="PowerAttributesType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="power:",
                name_="PowerAttributesType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="power:",
        name_="PowerAttributesType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="power:",
        name_="PowerAttributesType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.hertz is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<power:hertz>%s</power:hertz>%s"
                % (self.gds_format_float(self.hertz, input_name="hertz"), eol_)
            )
        if self.voltage is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<power:voltage>%s</power:voltage>%s"
                % (self.gds_format_float(self.voltage, input_name="voltage"), eol_)
            )
        if self.ac is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<power:ac>%s</power:ac>%s"
                % (self.gds_format_boolean(self.ac, input_name="ac"), eol_)
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "hertz":
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, "requires float or double: %s" % exp)
            fval_ = self.gds_validate_float(fval_, node, "hertz")
            self.hertz = fval_
        elif nodeName_ == "voltage":
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, "requires float or double: %s" % exp)
            fval_ = self.gds_validate_float(fval_, node, "voltage")
            self.voltage = fval_
        elif nodeName_ == "ac":
            sval_ = child_.text
            if sval_ in ("true", "1"):
                ival_ = True
            elif sval_ in ("false", "0"):
                ival_ = False
            else:
                raise_parse_error(child_, "requires boolean")
            ival_ = self.gds_validate_boolean(ival_, node, "ac")
            self.ac = ival_


# end class PowerAttributesType


class FeatureCollection(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, id=None, location=None):
        self.original_tagname_ = None
        self.id = _cast(None, id)
        self.location = location

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, FeatureCollection)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if FeatureCollection.subclass:
            return FeatureCollection.subclass(*args_, **kwargs_)
        else:
            return FeatureCollection(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_location(self):
        return self.location

    def set_location(self, location):
        self.location = location

    def get_id(self):
        return self.id

    def set_id(self, id):
        self.id = id

    def hasContent_(self):
        if self.location is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="gml:",
        name_="FeatureCollection",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:gml="http://www.opengis.net/gml/3.2"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("FeatureCollection")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="FeatureCollection"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="gml:",
                name_="FeatureCollection",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="gml:",
        name_="FeatureCollection",
    ):
        if self.id is not None and "id" not in already_processed:
            already_processed.add("id")
            outfile.write(
                " id=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_attrib(self.id), input_name="id")
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="gml:",
        name_="FeatureCollection",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.location is not None:
            self.location.export(
                outfile, level, namespace_, name_="location", pretty_print=pretty_print
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("id", node)
        if value is not None and "id" not in already_processed:
            already_processed.add("id")
            self.id = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "location":
            obj_ = locationType.factory()
            obj_.build(child_)
            self.location = obj_
            obj_.original_tagname_ = "location"


# end class FeatureCollection


class ServiceAreaType(GeneratedsSuper):
    """The Service Area is the geographic region that is affected by the
    EMIX market condition"""

    subclass = None
    superclass = None

    def __init__(self, FeatureCollection=None):
        self.original_tagname_ = None
        self.FeatureCollection = FeatureCollection

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ServiceAreaType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ServiceAreaType.subclass:
            return ServiceAreaType.subclass(*args_, **kwargs_)
        else:
            return ServiceAreaType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_FeatureCollection(self):
        return self.FeatureCollection

    def set_FeatureCollection(self, FeatureCollection):
        self.FeatureCollection = FeatureCollection

    def hasContent_(self):
        if self.FeatureCollection is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="emix:",
        name_="ServiceAreaType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:emix="http://docs.oasis-open.org/ns/emix/2011/06"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ServiceAreaType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="ServiceAreaType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="emix:",
                name_="ServiceAreaType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="emix:",
        name_="ServiceAreaType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="emix:",
        name_="ServiceAreaType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.FeatureCollection is not None:
            self.FeatureCollection.export(
                outfile,
                level,
                namespace_="gml:",
                name_="FeatureCollection",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "FeatureCollection":
            obj_ = FeatureCollection.factory()
            obj_.build(child_)
            self.FeatureCollection = obj_
            obj_.original_tagname_ = "FeatureCollection"


# end class ServiceAreaType


class ItemBaseType(GeneratedsSuper):
    """Abstract base type for units for EMIX Product delivery, measurement,
    and warrants."""

    subclass = None
    superclass = None

    def __init__(self, extensiontype_=None):
        self.original_tagname_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ItemBaseType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ItemBaseType.subclass:
            return ItemBaseType.subclass(*args_, **kwargs_)
        else:
            return ItemBaseType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_extensiontype_(self):
        return self.extensiontype_

    def set_extensiontype_(self, extensiontype_):
        self.extensiontype_ = extensiontype_

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="emix:",
        name_="ItemBaseType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:emix="http://docs.oasis-open.org/ns/emix/2011/06"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ItemBaseType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="ItemBaseType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="emix:",
                name_="ItemBaseType",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="emix:",
        name_="ItemBaseType",
    ):
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="emix:",
        name_="ItemBaseType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class ItemBaseType


class eiRequestEvent(GeneratedsSuper):
    """Request Event from a VTN in pull mode"""

    subclass = None
    superclass = None

    def __init__(self, requestID=None, venID=None, replyLimit=None):
        self.original_tagname_ = None
        self.requestID = requestID
        self.venID = venID
        self.replyLimit = replyLimit

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, eiRequestEvent)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if eiRequestEvent.subclass:
            return eiRequestEvent.subclass(*args_, **kwargs_)
        else:
            return eiRequestEvent(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_requestID(self):
        return self.requestID

    def set_requestID(self, requestID):
        self.requestID = requestID

    def get_venID(self):
        return self.venID

    def set_venID(self, venID):
        self.venID = venID

    def get_replyLimit(self):
        return self.replyLimit

    def set_replyLimit(self, replyLimit):
        self.replyLimit = replyLimit

    def hasContent_(self):
        if (
            self.requestID is not None
            or self.venID is not None
            or self.replyLimit is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="pyld:",
        name_="eiRequestEvent",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:pyld="http://docs.oasis-open.org/ns/energyinterop/201110/payloads"  xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("eiRequestEvent")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="eiRequestEvent"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="pyld:",
                name_="eiRequestEvent",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="pyld:",
        name_="eiRequestEvent",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="pyld:",
        name_="eiRequestEvent",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.requestID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<pyld:requestID>%s</pyld:requestID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.requestID), input_name="requestID"
                        )
                    ),
                    eol_,
                )
            )
        if self.venID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:venID>%s</ei:venID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.venID), input_name="venID"
                        )
                    ),
                    eol_,
                )
            )
        if self.replyLimit is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<pyld:replyLimit>%s</pyld:replyLimit>%s"
                % (
                    self.gds_format_integer(self.replyLimit, input_name="replyLimit"),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "requestID":
            requestID_ = child_.text
            requestID_ = self.gds_validate_string(requestID_, node, "requestID")
            self.requestID = requestID_
        elif nodeName_ == "venID":
            venID_ = child_.text
            venID_ = self.gds_validate_string(venID_, node, "venID")
            self.venID = venID_
        elif nodeName_ == "replyLimit":
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, "requires integer: %s" % exp)
            ival_ = self.gds_validate_integer(ival_, node, "replyLimit")
            self.replyLimit = ival_


# end class eiRequestEvent


class eiCreatedEvent(GeneratedsSuper):
    """Respond to a DR Event with optIn or optOut"""

    subclass = None
    superclass = None

    def __init__(self, eiResponse=None, eventResponses=None, venID=None):
        self.original_tagname_ = None
        self.eiResponse = eiResponse
        self.eventResponses = eventResponses
        self.venID = venID

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, eiCreatedEvent)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if eiCreatedEvent.subclass:
            return eiCreatedEvent.subclass(*args_, **kwargs_)
        else:
            return eiCreatedEvent(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_eiResponse(self):
        return self.eiResponse

    def set_eiResponse(self, eiResponse):
        self.eiResponse = eiResponse

    def get_eventResponses(self):
        return self.eventResponses

    def set_eventResponses(self, eventResponses):
        self.eventResponses = eventResponses

    def get_venID(self):
        return self.venID

    def set_venID(self, venID):
        self.venID = venID

    def hasContent_(self):
        if (
            self.eiResponse is not None
            or self.eventResponses is not None
            or self.venID is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="pyld:",
        name_="eiCreatedEvent",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110"  xmlns:pyld="http://docs.oasis-open.org/ns/energyinterop/201110/payloads"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("eiCreatedEvent")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="eiCreatedEvent"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="pyld:",
                name_="eiCreatedEvent",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="pyld:",
        name_="eiCreatedEvent",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="pyld:",
        name_="eiCreatedEvent",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.eiResponse is not None:
            self.eiResponse.export(
                outfile,
                level,
                namespace_="ei:",
                name_="eiResponse",
                pretty_print=pretty_print,
            )
        if self.eventResponses is not None:
            self.eventResponses.export(
                outfile,
                level,
                namespace_="ei:",
                name_="eventResponses",
                pretty_print=pretty_print,
            )
        if self.venID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:venID>%s</ei:venID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.venID), input_name="venID"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "eiResponse":
            obj_ = EiResponseType.factory()
            obj_.build(child_)
            self.eiResponse = obj_
            obj_.original_tagname_ = "eiResponse"
        elif nodeName_ == "eventResponses":
            obj_ = eventResponses.factory()
            obj_.build(child_)
            self.eventResponses = obj_
            obj_.original_tagname_ = "eventResponses"
        elif nodeName_ == "venID":
            venID_ = child_.text
            venID_ = self.gds_validate_string(venID_, node, "venID")
            self.venID = venID_


# end class eiCreatedEvent


class Object(GeneratedsSuper):
    """Superclass of all object classes to allow extensions."""

    subclass = None
    superclass = None

    def __init__(self, extension=None):
        self.original_tagname_ = None
        if extension is None:
            self.extension = []
        else:
            self.extension = extension

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Object)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Object.subclass:
            return Object.subclass(*args_, **kwargs_)
        else:
            return Object(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_extension(self):
        return self.extension

    def set_extension(self, extension):
        self.extension = extension

    def add_extension(self, value):
        self.extension.append(value)

    def insert_extension_at(self, index, value):
        self.extension.insert(index, value)

    def replace_extension_at(self, index, value):
        self.extension[index] = value

    def hasContent_(self):
        if self.extension:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="Object",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ds="http://www.w3.org/2000/09/xmldsig#"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Object")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="Object"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ds:",
                name_="Object",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="ds:", name_="Object"
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="Object",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for extension_ in self.extension:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ds:extension>%s</ds:extension>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(extension_), input_name="extension"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "extension":
            extension_ = child_.text
            extension_ = self.gds_validate_string(extension_, node, "extension")
            self.extension.append(extension_)


# end class Object


class ServiceStatus(Object):
    """Contains the current status of the service."""

    subclass = None
    superclass = Object

    def __init__(self, currentStatus=None):
        self.original_tagname_ = None
        super(ServiceStatus, self).__init__()
        self.currentStatus = currentStatus
        self.validate_ESPIServiceStatus(self.currentStatus)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ServiceStatus)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ServiceStatus.subclass:
            return ServiceStatus.subclass(*args_, **kwargs_)
        else:
            return ServiceStatus(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_currentStatus(self):
        return self.currentStatus

    def set_currentStatus(self, currentStatus):
        self.currentStatus = currentStatus

    def validate_ESPIServiceStatus(self, value):
        # Validate type ESPIServiceStatus, a restriction on UInt16.
        pass

    def hasContent_(self):
        if self.currentStatus is not None or super(ServiceStatus, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="ServiceStatus",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ServiceStatus")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="ServiceStatus"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="ServiceStatus",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="ServiceStatus",
    ):
        super(ServiceStatus, self).exportAttributes(
            outfile, level, already_processed, namespace_, name_="ServiceStatus"
        )

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="ServiceStatus",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(ServiceStatus, self).exportChildren(
            outfile, level, namespace_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.currentStatus is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<oadr:currentStatus>%s</oadr:currentStatus>%s"
                % (
                    self.gds_format_integer(
                        self.currentStatus, input_name="currentStatus"
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(ServiceStatus, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "currentStatus":
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, "requires integer: %s" % exp)
            ival_ = self.gds_validate_integer(ival_, node, "currentStatus")
            self.currentStatus = ival_
            # validate type ESPIServiceStatus
            self.validate_ESPIServiceStatus(self.currentStatus)
        super(ServiceStatus, self).buildChildren(child_, node, nodeName_, True)


# end class ServiceStatus


class RationalNumber(GeneratedsSuper):
    """[extension] Rational number = 'numerator' / 'denominator'."""

    subclass = None
    superclass = None

    def __init__(self, numerator=None, denominator=None):
        self.original_tagname_ = None
        self.numerator = numerator
        self.denominator = denominator

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, RationalNumber)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if RationalNumber.subclass:
            return RationalNumber.subclass(*args_, **kwargs_)
        else:
            return RationalNumber(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_numerator(self):
        return self.numerator

    def set_numerator(self, numerator):
        self.numerator = numerator

    def get_denominator(self):
        return self.denominator

    def set_denominator(self, denominator):
        self.denominator = denominator

    def hasContent_(self):
        if self.numerator is not None or self.denominator is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="RationalNumber",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("RationalNumber")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="RationalNumber"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="RationalNumber",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="RationalNumber",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="RationalNumber",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.numerator is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<oadr:numerator>%s</oadr:numerator>%s"
                % (
                    self.gds_format_integer(self.numerator, input_name="numerator"),
                    eol_,
                )
            )
        if self.denominator is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<oadr:denominator>%s</oadr:denominator>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.denominator), input_name="denominator"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "numerator":
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, "requires integer: %s" % exp)
            ival_ = self.gds_validate_integer(ival_, node, "numerator")
            self.numerator = ival_
        elif nodeName_ == "denominator":
            denominator_ = child_.text
            denominator_ = self.gds_validate_string(denominator_, node, "denominator")
            self.denominator = denominator_


# end class RationalNumber


class denominator(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self):
        self.original_tagname_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, denominator)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if denominator.subclass:
            return denominator.subclass(*args_, **kwargs_)
        else:
            return denominator(*args_, **kwargs_)

    factory = staticmethod(factory)

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="denominator",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("denominator")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="denominator"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="denominator",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="oadr:", name_="denominator"
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="denominator",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class denominator


class ReadingInterharmonic(GeneratedsSuper):
    """[extension] Interharmonics are represented as a rational number
    'numerator' / 'denominator', and harmonics are represented using
    the same mechanism and identified by 'denominator'=1."""

    subclass = None
    superclass = None

    def __init__(self, numerator=None, denominator=None):
        self.original_tagname_ = None
        self.numerator = numerator
        self.denominator = denominator

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ReadingInterharmonic
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ReadingInterharmonic.subclass:
            return ReadingInterharmonic.subclass(*args_, **kwargs_)
        else:
            return ReadingInterharmonic(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_numerator(self):
        return self.numerator

    def set_numerator(self, numerator):
        self.numerator = numerator

    def get_denominator(self):
        return self.denominator

    def set_denominator(self, denominator):
        self.denominator = denominator

    def hasContent_(self):
        if self.numerator is not None or self.denominator is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="ReadingInterharmonic",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ReadingInterharmonic")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="ReadingInterharmonic"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="ReadingInterharmonic",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="ReadingInterharmonic",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="ReadingInterharmonic",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.numerator is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<oadr:numerator>%s</oadr:numerator>%s"
                % (
                    self.gds_format_integer(self.numerator, input_name="numerator"),
                    eol_,
                )
            )
        if self.denominator is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<oadr:denominator>%s</oadr:denominator>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.denominator), input_name="denominator"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "numerator":
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, "requires integer: %s" % exp)
            ival_ = self.gds_validate_integer(ival_, node, "numerator")
            self.numerator = ival_
        elif nodeName_ == "denominator":
            denominator_ = child_.text
            denominator_ = self.gds_validate_string(denominator_, node, "denominator")
            self.denominator = denominator_


# end class ReadingInterharmonic


class LineItem(GeneratedsSuper):
    """[extension] Line item of detail for additional cost"""

    subclass = None
    superclass = None

    def __init__(self, amount=None, rounding=None, dateTime=None, note=None):
        self.original_tagname_ = None
        self.amount = amount
        self.validate_Int48(self.amount)
        self.rounding = rounding
        self.validate_Int48(self.rounding)
        self.dateTime = dateTime
        self.validate_TimeType(self.dateTime)
        self.note = note
        self.validate_String256(self.note)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, LineItem)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LineItem.subclass:
            return LineItem.subclass(*args_, **kwargs_)
        else:
            return LineItem(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_amount(self):
        return self.amount

    def set_amount(self, amount):
        self.amount = amount

    def get_rounding(self):
        return self.rounding

    def set_rounding(self, rounding):
        self.rounding = rounding

    def get_dateTime(self):
        return self.dateTime

    def set_dateTime(self, dateTime):
        self.dateTime = dateTime

    def get_note(self):
        return self.note

    def set_note(self, note):
        self.note = note

    def validate_Int48(self, value):
        # Validate type Int48, a restriction on xs:long.
        if value is not None and Validate_simpletypes_:
            if value < -140737488355328:
                warnings_.warn(
                    'Value "%(value)s" does not match xsd minInclusive restriction on Int48'
                    % {"value": value}
                )
            if value > 140737488355328:
                warnings_.warn(
                    'Value "%(value)s" does not match xsd maxInclusive restriction on Int48'
                    % {"value": value}
                )

    def validate_TimeType(self, value):
        # Validate type TimeType, a restriction on xs:long.
        if value is not None and Validate_simpletypes_:
            pass

    def validate_String256(self, value):
        # Validate type String256, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if len(value) > 256:
                warnings_.warn(
                    'Value "%(value)s" does not match xsd maxLength restriction on String256'
                    % {"value": value.encode("utf-8")}
                )

    def hasContent_(self):
        if (
            self.amount is not None
            or self.rounding is not None
            or self.dateTime is not None
            or self.note is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="LineItem",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("LineItem")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="LineItem"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="LineItem",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="oadr:", name_="LineItem"
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="LineItem",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.amount is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<oadr:amount>%s</oadr:amount>%s"
                % (self.gds_format_integer(self.amount, input_name="amount"), eol_)
            )
        if self.rounding is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<oadr:rounding>%s</oadr:rounding>%s"
                % (self.gds_format_integer(self.rounding, input_name="rounding"), eol_)
            )
        if self.dateTime is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<oadr:dateTime>%s</oadr:dateTime>%s"
                % (self.gds_format_integer(self.dateTime, input_name="dateTime"), eol_)
            )
        if self.note is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<oadr:note>%s</oadr:note>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.note), input_name="note")
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "amount":
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, "requires integer: %s" % exp)
            ival_ = self.gds_validate_integer(ival_, node, "amount")
            self.amount = ival_
            # validate type Int48
            self.validate_Int48(self.amount)
        elif nodeName_ == "rounding":
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, "requires integer: %s" % exp)
            ival_ = self.gds_validate_integer(ival_, node, "rounding")
            self.rounding = ival_
            # validate type Int48
            self.validate_Int48(self.rounding)
        elif nodeName_ == "dateTime":
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, "requires integer: %s" % exp)
            ival_ = self.gds_validate_integer(ival_, node, "dateTime")
            self.dateTime = ival_
            # validate type TimeType
            self.validate_TimeType(self.dateTime)
        elif nodeName_ == "note":
            note_ = child_.text
            note_ = self.gds_validate_string(note_, node, "note")
            self.note = note_
            # validate type String256
            self.validate_String256(self.note)


# end class LineItem


class textType(GeneratedsSuper):
    """The Atom text construct is defined in section 3.1 of the format
    spec."""

    subclass = None
    superclass = None

    def __init__(
        self,
        type_=None,
        base=None,
        lang=None,
        anytypeobjs_=None,
        valueOf_=None,
        mixedclass_=None,
        content_=None,
    ):
        self.original_tagname_ = None
        self.type_ = _cast(None, type_)
        self.base = _cast(None, base)
        self.lang = _cast(None, lang)
        self.anytypeobjs_ = anytypeobjs_
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, textType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if textType.subclass:
            return textType.subclass(*args_, **kwargs_)
        else:
            return textType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_anytypeobjs_(self):
        return self.anytypeobjs_

    def set_anytypeobjs_(self, anytypeobjs_):
        self.anytypeobjs_ = anytypeobjs_

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_base(self):
        return self.base

    def set_base(self, base):
        self.base = base

    def get_lang(self):
        return self.lang

    def set_lang(self, lang):
        self.lang = lang

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if self.anytypeobjs_ is not None or (
            1 if type(self.valueOf_) in [int, float] else self.valueOf_
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="atom:",
        name_="textType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:atom="http://www.w3.org/2005/Atom"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("textType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="textType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="atom:",
                name_="textType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="atom:", name_="textType"
    ):
        if self.type_ is not None and "type_" not in already_processed:
            already_processed.add("type_")
            outfile.write(
                " type=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.type_), input_name="type"
                        )
                    ),
                )
            )
        if self.base is not None and "base" not in already_processed:
            already_processed.add("base")
            outfile.write(
                " base=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.base), input_name="base"
                        )
                    ),
                )
            )
        if self.lang is not None and "lang" not in already_processed:
            already_processed.add("lang")
            outfile.write(
                " lang=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.lang), input_name="lang"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="atom:",
        name_="textType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(
                    outfile, level, item_.name, namespace_, pretty_print=pretty_print
                )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.anytypeobjs_ is not None:
            self.anytypeobjs_.export(
                outfile, level, namespace_, pretty_print=pretty_print
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(
                MixedContainer.CategoryText, MixedContainer.TypeNone, "", node.text
            )
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("type", node)
        if value is not None and "type" not in already_processed:
            already_processed.add("type")
            self.type_ = value
            self.type_ = " ".join(self.type_.split())
        value = find_attr_value_("base", node)
        if value is not None and "base" not in already_processed:
            already_processed.add("base")
            self.base = value
        value = find_attr_value_("lang", node)
        if value is not None and "lang" not in already_processed:
            already_processed.add("lang")
            self.lang = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "":
            obj_ = __ANY__.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(
                MixedContainer.CategoryComplex, MixedContainer.TypeNone, "", obj_
            )
            self.content_.append(obj_)
            if hasattr(self, "add_"):
                self.add_(obj_.value)
            elif hasattr(self, "set_"):
                self.set_(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(
                MixedContainer.CategoryText, MixedContainer.TypeNone, "", child_.tail
            )
            self.content_.append(obj_)


# end class textType


class personType(GeneratedsSuper):
    """The Atom person construct is defined in section 3.2 of the format
    spec."""

    subclass = None
    superclass = None

    def __init__(
        self, base=None, lang=None, name=None, uri=None, email=None, anytypeobjs_=None
    ):
        self.original_tagname_ = None
        self.base = _cast(None, base)
        self.lang = _cast(None, lang)
        if name is None:
            self.name = []
        else:
            self.name = name
        if uri is None:
            self.uri = []
        else:
            self.uri = uri
        if email is None:
            self.email = []
        else:
            self.email = email
        self.anytypeobjs_ = anytypeobjs_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, personType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if personType.subclass:
            return personType.subclass(*args_, **kwargs_)
        else:
            return personType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def add_name(self, value):
        self.name.append(value)

    def insert_name_at(self, index, value):
        self.name.insert(index, value)

    def replace_name_at(self, index, value):
        self.name[index] = value

    def get_uri(self):
        return self.uri

    def set_uri(self, uri):
        self.uri = uri

    def add_uri(self, value):
        self.uri.append(value)

    def insert_uri_at(self, index, value):
        self.uri.insert(index, value)

    def replace_uri_at(self, index, value):
        self.uri[index] = value

    def get_email(self):
        return self.email

    def set_email(self, email):
        self.email = email

    def add_email(self, value):
        self.email.append(value)

    def insert_email_at(self, index, value):
        self.email.insert(index, value)

    def replace_email_at(self, index, value):
        self.email[index] = value

    def get_anytypeobjs_(self):
        return self.anytypeobjs_

    def set_anytypeobjs_(self, anytypeobjs_):
        self.anytypeobjs_ = anytypeobjs_

    def get_base(self):
        return self.base

    def set_base(self, base):
        self.base = base

    def get_lang(self):
        return self.lang

    def set_lang(self, lang):
        self.lang = lang

    def validate_emailType(self, value):
        # Validate type emailType, a restriction on xs:normalizedString.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_emailType_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (value.encode("utf-8"), self.validate_emailType_patterns_)
                )

    validate_emailType_patterns_ = [["^\\w+@(\\w+\\.)+\\w+$"]]

    def hasContent_(self):
        if self.name or self.uri or self.email or self.anytypeobjs_ is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="atom:",
        name_="personType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:atom="http://www.w3.org/2005/Atom" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("personType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="personType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="atom:",
                name_="personType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="atom:", name_="personType"
    ):
        if self.base is not None and "base" not in already_processed:
            already_processed.add("base")
            outfile.write(
                " base=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.base), input_name="base"
                        )
                    ),
                )
            )
        if self.lang is not None and "lang" not in already_processed:
            already_processed.add("lang")
            outfile.write(
                " lang=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.lang), input_name="lang"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="atom:",
        name_="personType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for name_ in self.name:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<atom:name>%s</atom:name>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_xml(name_), input_name="name")
                    ),
                    eol_,
                )
            )
        for uri_ in self.uri:
            uri_.export(
                outfile, level, namespace_, name_="uri", pretty_print=pretty_print
            )
        for email_ in self.email:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<atom:email>%s</atom:email>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_xml(email_), input_name="email")
                    ),
                    eol_,
                )
            )
        if self.anytypeobjs_ is not None:
            self.anytypeobjs_.export(
                outfile, level, namespace_, pretty_print=pretty_print
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("base", node)
        if value is not None and "base" not in already_processed:
            already_processed.add("base")
            self.base = value
        value = find_attr_value_("lang", node)
        if value is not None and "lang" not in already_processed:
            already_processed.add("lang")
            self.lang = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "name":
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, "name")
            self.name.append(name_)
        elif nodeName_ == "uri":
            obj_ = uriType.factory()
            obj_.build(child_)
            self.uri.append(obj_)
            obj_.original_tagname_ = "uri"
        elif nodeName_ == "email":
            email_ = child_.text
            email_ = self.gds_validate_string(email_, node, "email")
            self.email.append(email_)
            # validate type emailType
            self.validate_emailType(self.email[-1])
        else:
            obj_ = self.gds_build_any(child_, "personType")
            if obj_ is not None:
                self.set_anytypeobjs_(obj_)


# end class personType


class feedType(GeneratedsSuper):
    """The Atom feed construct is defined in section 4.1.1 of the format
    spec."""

    subclass = None
    superclass = None

    def __init__(
        self,
        base=None,
        lang=None,
        author=None,
        category=None,
        contributor=None,
        generator=None,
        icon=None,
        id=None,
        link=None,
        logo=None,
        rights=None,
        subtitle=None,
        title=None,
        updated=None,
        entry=None,
        anytypeobjs_=None,
    ):
        self.original_tagname_ = None
        self.base = _cast(None, base)
        self.lang = _cast(None, lang)
        if author is None:
            self.author = []
        else:
            self.author = author
        if category is None:
            self.category = []
        else:
            self.category = category
        if contributor is None:
            self.contributor = []
        else:
            self.contributor = contributor
        if generator is None:
            self.generator = []
        else:
            self.generator = generator
        if icon is None:
            self.icon = []
        else:
            self.icon = icon
        if id is None:
            self.id = []
        else:
            self.id = id
        if link is None:
            self.link = []
        else:
            self.link = link
        if logo is None:
            self.logo = []
        else:
            self.logo = logo
        if rights is None:
            self.rights = []
        else:
            self.rights = rights
        if subtitle is None:
            self.subtitle = []
        else:
            self.subtitle = subtitle
        if title is None:
            self.title = []
        else:
            self.title = title
        if updated is None:
            self.updated = []
        else:
            self.updated = updated
        if entry is None:
            self.entry = []
        else:
            self.entry = entry
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, feedType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if feedType.subclass:
            return feedType.subclass(*args_, **kwargs_)
        else:
            return feedType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_author(self):
        return self.author

    def set_author(self, author):
        self.author = author

    def add_author(self, value):
        self.author.append(value)

    def insert_author_at(self, index, value):
        self.author.insert(index, value)

    def replace_author_at(self, index, value):
        self.author[index] = value

    def get_category(self):
        return self.category

    def set_category(self, category):
        self.category = category

    def add_category(self, value):
        self.category.append(value)

    def insert_category_at(self, index, value):
        self.category.insert(index, value)

    def replace_category_at(self, index, value):
        self.category[index] = value

    def get_contributor(self):
        return self.contributor

    def set_contributor(self, contributor):
        self.contributor = contributor

    def add_contributor(self, value):
        self.contributor.append(value)

    def insert_contributor_at(self, index, value):
        self.contributor.insert(index, value)

    def replace_contributor_at(self, index, value):
        self.contributor[index] = value

    def get_generator(self):
        return self.generator

    def set_generator(self, generator):
        self.generator = generator

    def add_generator(self, value):
        self.generator.append(value)

    def insert_generator_at(self, index, value):
        self.generator.insert(index, value)

    def replace_generator_at(self, index, value):
        self.generator[index] = value

    def get_icon(self):
        return self.icon

    def set_icon(self, icon):
        self.icon = icon

    def add_icon(self, value):
        self.icon.append(value)

    def insert_icon_at(self, index, value):
        self.icon.insert(index, value)

    def replace_icon_at(self, index, value):
        self.icon[index] = value

    def get_id(self):
        return self.id

    def set_id(self, id):
        self.id = id

    def add_id(self, value):
        self.id.append(value)

    def insert_id_at(self, index, value):
        self.id.insert(index, value)

    def replace_id_at(self, index, value):
        self.id[index] = value

    def get_link(self):
        return self.link

    def set_link(self, link):
        self.link = link

    def add_link(self, value):
        self.link.append(value)

    def insert_link_at(self, index, value):
        self.link.insert(index, value)

    def replace_link_at(self, index, value):
        self.link[index] = value

    def get_logo(self):
        return self.logo

    def set_logo(self, logo):
        self.logo = logo

    def add_logo(self, value):
        self.logo.append(value)

    def insert_logo_at(self, index, value):
        self.logo.insert(index, value)

    def replace_logo_at(self, index, value):
        self.logo[index] = value

    def get_rights(self):
        return self.rights

    def set_rights(self, rights):
        self.rights = rights

    def add_rights(self, value):
        self.rights.append(value)

    def insert_rights_at(self, index, value):
        self.rights.insert(index, value)

    def replace_rights_at(self, index, value):
        self.rights[index] = value

    def get_subtitle(self):
        return self.subtitle

    def set_subtitle(self, subtitle):
        self.subtitle = subtitle

    def add_subtitle(self, value):
        self.subtitle.append(value)

    def insert_subtitle_at(self, index, value):
        self.subtitle.insert(index, value)

    def replace_subtitle_at(self, index, value):
        self.subtitle[index] = value

    def get_title(self):
        return self.title

    def set_title(self, title):
        self.title = title

    def add_title(self, value):
        self.title.append(value)

    def insert_title_at(self, index, value):
        self.title.insert(index, value)

    def replace_title_at(self, index, value):
        self.title[index] = value

    def get_updated(self):
        return self.updated

    def set_updated(self, updated):
        self.updated = updated

    def add_updated(self, value):
        self.updated.append(value)

    def insert_updated_at(self, index, value):
        self.updated.insert(index, value)

    def replace_updated_at(self, index, value):
        self.updated[index] = value

    def get_entry(self):
        return self.entry

    def set_entry(self, entry):
        self.entry = entry

    def add_entry(self, value):
        self.entry.append(value)

    def insert_entry_at(self, index, value):
        self.entry.insert(index, value)

    def replace_entry_at(self, index, value):
        self.entry[index] = value

    def get_anytypeobjs_(self):
        return self.anytypeobjs_

    def set_anytypeobjs_(self, anytypeobjs_):
        self.anytypeobjs_ = anytypeobjs_

    def add_anytypeobjs_(self, value):
        self.anytypeobjs_.append(value)

    def insert_anytypeobjs_(self, index, value):
        self._anytypeobjs_[index] = value

    def get_base(self):
        return self.base

    def set_base(self, base):
        self.base = base

    def get_lang(self):
        return self.lang

    def set_lang(self, lang):
        self.lang = lang

    def hasContent_(self):
        if (
            self.author
            or self.category
            or self.contributor
            or self.generator
            or self.icon
            or self.id
            or self.link
            or self.logo
            or self.rights
            or self.subtitle
            or self.title
            or self.updated
            or self.entry
            or self.anytypeobjs_
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="atom:",
        name_="feedType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:atom="http://www.w3.org/2005/Atom" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("feedType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="feedType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="atom:",
                name_="feedType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="atom:", name_="feedType"
    ):
        if self.base is not None and "base" not in already_processed:
            already_processed.add("base")
            outfile.write(
                " base=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.base), input_name="base"
                        )
                    ),
                )
            )
        if self.lang is not None and "lang" not in already_processed:
            already_processed.add("lang")
            outfile.write(
                " lang=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.lang), input_name="lang"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="atom:",
        name_="feedType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for author_ in self.author:
            author_.export(
                outfile, level, namespace_, name_="author", pretty_print=pretty_print
            )
        for category_ in self.category:
            category_.export(
                outfile, level, namespace_, name_="category", pretty_print=pretty_print
            )
        for contributor_ in self.contributor:
            contributor_.export(
                outfile,
                level,
                namespace_,
                name_="contributor",
                pretty_print=pretty_print,
            )
        for generator_ in self.generator:
            generator_.export(
                outfile, level, namespace_, name_="generator", pretty_print=pretty_print
            )
        for icon_ in self.icon:
            icon_.export(
                outfile, level, namespace_, name_="icon", pretty_print=pretty_print
            )
        for id_ in self.id:
            id_.export(
                outfile, level, namespace_, name_="id", pretty_print=pretty_print
            )
        for link_ in self.link:
            link_.export(
                outfile, level, namespace_, name_="link", pretty_print=pretty_print
            )
        for logo_ in self.logo:
            logo_.export(
                outfile, level, namespace_, name_="logo", pretty_print=pretty_print
            )
        for rights_ in self.rights:
            rights_.export(
                outfile, level, namespace_, name_="rights", pretty_print=pretty_print
            )
        for subtitle_ in self.subtitle:
            subtitle_.export(
                outfile, level, namespace_, name_="subtitle", pretty_print=pretty_print
            )
        for title_ in self.title:
            title_.export(
                outfile, level, namespace_, name_="title", pretty_print=pretty_print
            )
        for updated_ in self.updated:
            updated_.export(
                outfile, level, namespace_, name_="updated", pretty_print=pretty_print
            )
        for entry_ in self.entry:
            entry_.export(
                outfile, level, namespace_, name_="entry", pretty_print=pretty_print
            )
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("base", node)
        if value is not None and "base" not in already_processed:
            already_processed.add("base")
            self.base = value
        value = find_attr_value_("lang", node)
        if value is not None and "lang" not in already_processed:
            already_processed.add("lang")
            self.lang = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "author":
            obj_ = personType.factory()
            obj_.build(child_)
            self.author.append(obj_)
            obj_.original_tagname_ = "author"
        elif nodeName_ == "category":
            obj_ = categoryType.factory()
            obj_.build(child_)
            self.category.append(obj_)
            obj_.original_tagname_ = "category"
        elif nodeName_ == "contributor":
            obj_ = personType.factory()
            obj_.build(child_)
            self.contributor.append(obj_)
            obj_.original_tagname_ = "contributor"
        elif nodeName_ == "generator":
            obj_ = generatorType.factory()
            obj_.build(child_)
            self.generator.append(obj_)
            obj_.original_tagname_ = "generator"
        elif nodeName_ == "icon":
            obj_ = iconType.factory()
            obj_.build(child_)
            self.icon.append(obj_)
            obj_.original_tagname_ = "icon"
        elif nodeName_ == "id":
            obj_ = idType.factory()
            obj_.build(child_)
            self.id.append(obj_)
            obj_.original_tagname_ = "id"
        elif nodeName_ == "link":
            obj_ = linkType.factory()
            obj_.build(child_)
            self.link.append(obj_)
            obj_.original_tagname_ = "link"
        elif nodeName_ == "logo":
            obj_ = logoType.factory()
            obj_.build(child_)
            self.logo.append(obj_)
            obj_.original_tagname_ = "logo"
        elif nodeName_ == "rights":
            obj_ = textType.factory()
            obj_.build(child_)
            self.rights.append(obj_)
            obj_.original_tagname_ = "rights"
        elif nodeName_ == "subtitle":
            obj_ = textType.factory()
            obj_.build(child_)
            self.subtitle.append(obj_)
            obj_.original_tagname_ = "subtitle"
        elif nodeName_ == "title":
            obj_ = textType.factory()
            obj_.build(child_)
            self.title.append(obj_)
            obj_.original_tagname_ = "title"
        elif nodeName_ == "updated":
            obj_ = dateTimeType.factory()
            obj_.build(child_)
            self.updated.append(obj_)
            obj_.original_tagname_ = "updated"
        elif nodeName_ == "entry":
            obj_ = entryType.factory()
            obj_.build(child_)
            self.entry.append(obj_)
            obj_.original_tagname_ = "entry"
        else:
            obj_ = self.gds_build_any(child_, "feedType")
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)


# end class feedType


class entryType(GeneratedsSuper):
    """The Atom entry construct is defined in section 4.1.2 of the format
    spec."""

    subclass = None
    superclass = None

    def __init__(
        self,
        base=None,
        lang=None,
        author=None,
        category=None,
        content=None,
        contributor=None,
        id=None,
        link=None,
        published=None,
        rights=None,
        source=None,
        summary=None,
        title=None,
        updated=None,
        anytypeobjs_=None,
    ):
        self.original_tagname_ = None
        self.base = _cast(None, base)
        self.lang = _cast(None, lang)
        if author is None:
            self.author = []
        else:
            self.author = author
        if category is None:
            self.category = []
        else:
            self.category = category
        if content is None:
            self.content = []
        else:
            self.content = content
        if contributor is None:
            self.contributor = []
        else:
            self.contributor = contributor
        if id is None:
            self.id = []
        else:
            self.id = id
        if link is None:
            self.link = []
        else:
            self.link = link
        if published is None:
            self.published = []
        else:
            self.published = published
        if rights is None:
            self.rights = []
        else:
            self.rights = rights
        if source is None:
            self.source = []
        else:
            self.source = source
        if summary is None:
            self.summary = []
        else:
            self.summary = summary
        if title is None:
            self.title = []
        else:
            self.title = title
        if updated is None:
            self.updated = []
        else:
            self.updated = updated
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, entryType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if entryType.subclass:
            return entryType.subclass(*args_, **kwargs_)
        else:
            return entryType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_author(self):
        return self.author

    def set_author(self, author):
        self.author = author

    def add_author(self, value):
        self.author.append(value)

    def insert_author_at(self, index, value):
        self.author.insert(index, value)

    def replace_author_at(self, index, value):
        self.author[index] = value

    def get_category(self):
        return self.category

    def set_category(self, category):
        self.category = category

    def add_category(self, value):
        self.category.append(value)

    def insert_category_at(self, index, value):
        self.category.insert(index, value)

    def replace_category_at(self, index, value):
        self.category[index] = value

    def get_content(self):
        return self.content

    def set_content(self, content):
        self.content = content

    def add_content(self, value):
        self.content.append(value)

    def insert_content_at(self, index, value):
        self.content.insert(index, value)

    def replace_content_at(self, index, value):
        self.content[index] = value

    def get_contributor(self):
        return self.contributor

    def set_contributor(self, contributor):
        self.contributor = contributor

    def add_contributor(self, value):
        self.contributor.append(value)

    def insert_contributor_at(self, index, value):
        self.contributor.insert(index, value)

    def replace_contributor_at(self, index, value):
        self.contributor[index] = value

    def get_id(self):
        return self.id

    def set_id(self, id):
        self.id = id

    def add_id(self, value):
        self.id.append(value)

    def insert_id_at(self, index, value):
        self.id.insert(index, value)

    def replace_id_at(self, index, value):
        self.id[index] = value

    def get_link(self):
        return self.link

    def set_link(self, link):
        self.link = link

    def add_link(self, value):
        self.link.append(value)

    def insert_link_at(self, index, value):
        self.link.insert(index, value)

    def replace_link_at(self, index, value):
        self.link[index] = value

    def get_published(self):
        return self.published

    def set_published(self, published):
        self.published = published

    def add_published(self, value):
        self.published.append(value)

    def insert_published_at(self, index, value):
        self.published.insert(index, value)

    def replace_published_at(self, index, value):
        self.published[index] = value

    def get_rights(self):
        return self.rights

    def set_rights(self, rights):
        self.rights = rights

    def add_rights(self, value):
        self.rights.append(value)

    def insert_rights_at(self, index, value):
        self.rights.insert(index, value)

    def replace_rights_at(self, index, value):
        self.rights[index] = value

    def get_source(self):
        return self.source

    def set_source(self, source):
        self.source = source

    def add_source(self, value):
        self.source.append(value)

    def insert_source_at(self, index, value):
        self.source.insert(index, value)

    def replace_source_at(self, index, value):
        self.source[index] = value

    def get_summary(self):
        return self.summary

    def set_summary(self, summary):
        self.summary = summary

    def add_summary(self, value):
        self.summary.append(value)

    def insert_summary_at(self, index, value):
        self.summary.insert(index, value)

    def replace_summary_at(self, index, value):
        self.summary[index] = value

    def get_title(self):
        return self.title

    def set_title(self, title):
        self.title = title

    def add_title(self, value):
        self.title.append(value)

    def insert_title_at(self, index, value):
        self.title.insert(index, value)

    def replace_title_at(self, index, value):
        self.title[index] = value

    def get_updated(self):
        return self.updated

    def set_updated(self, updated):
        self.updated = updated

    def add_updated(self, value):
        self.updated.append(value)

    def insert_updated_at(self, index, value):
        self.updated.insert(index, value)

    def replace_updated_at(self, index, value):
        self.updated[index] = value

    def get_anytypeobjs_(self):
        return self.anytypeobjs_

    def set_anytypeobjs_(self, anytypeobjs_):
        self.anytypeobjs_ = anytypeobjs_

    def add_anytypeobjs_(self, value):
        self.anytypeobjs_.append(value)

    def insert_anytypeobjs_(self, index, value):
        self._anytypeobjs_[index] = value

    def get_base(self):
        return self.base

    def set_base(self, base):
        self.base = base

    def get_lang(self):
        return self.lang

    def set_lang(self, lang):
        self.lang = lang

    def hasContent_(self):
        if (
            self.author
            or self.category
            or self.content
            or self.contributor
            or self.id
            or self.link
            or self.published
            or self.rights
            or self.source
            or self.summary
            or self.title
            or self.updated
            or self.anytypeobjs_
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="atom:",
        name_="entryType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:atom="http://www.w3.org/2005/Atom" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("entryType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="entryType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="atom:",
                name_="entryType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="atom:", name_="entryType"
    ):
        if self.base is not None and "base" not in already_processed:
            already_processed.add("base")
            outfile.write(
                " base=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.base), input_name="base"
                        )
                    ),
                )
            )
        if self.lang is not None and "lang" not in already_processed:
            already_processed.add("lang")
            outfile.write(
                " lang=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.lang), input_name="lang"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="atom:",
        name_="entryType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for author_ in self.author:
            author_.export(
                outfile, level, namespace_, name_="author", pretty_print=pretty_print
            )
        for category_ in self.category:
            category_.export(
                outfile, level, namespace_, name_="category", pretty_print=pretty_print
            )
        for content_ in self.content:
            content_.export(
                outfile, level, namespace_, name_="content", pretty_print=pretty_print
            )
        for contributor_ in self.contributor:
            contributor_.export(
                outfile,
                level,
                namespace_,
                name_="contributor",
                pretty_print=pretty_print,
            )
        for id_ in self.id:
            id_.export(
                outfile, level, namespace_, name_="id", pretty_print=pretty_print
            )
        for link_ in self.link:
            link_.export(
                outfile, level, namespace_, name_="link", pretty_print=pretty_print
            )
        for published_ in self.published:
            published_.export(
                outfile, level, namespace_, name_="published", pretty_print=pretty_print
            )
        for rights_ in self.rights:
            rights_.export(
                outfile, level, namespace_, name_="rights", pretty_print=pretty_print
            )
        for source_ in self.source:
            source_.export(
                outfile, level, namespace_, name_="source", pretty_print=pretty_print
            )
        for summary_ in self.summary:
            summary_.export(
                outfile, level, namespace_, name_="summary", pretty_print=pretty_print
            )
        for title_ in self.title:
            title_.export(
                outfile, level, namespace_, name_="title", pretty_print=pretty_print
            )
        for updated_ in self.updated:
            updated_.export(
                outfile, level, namespace_, name_="updated", pretty_print=pretty_print
            )
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("base", node)
        if value is not None and "base" not in already_processed:
            already_processed.add("base")
            self.base = value
        value = find_attr_value_("lang", node)
        if value is not None and "lang" not in already_processed:
            already_processed.add("lang")
            self.lang = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "author":
            obj_ = personType.factory()
            obj_.build(child_)
            self.author.append(obj_)
            obj_.original_tagname_ = "author"
        elif nodeName_ == "category":
            obj_ = categoryType.factory()
            obj_.build(child_)
            self.category.append(obj_)
            obj_.original_tagname_ = "category"
        elif nodeName_ == "content":
            obj_ = contentType.factory()
            obj_.build(child_)
            self.content.append(obj_)
            obj_.original_tagname_ = "content"
        elif nodeName_ == "contributor":
            obj_ = personType.factory()
            obj_.build(child_)
            self.contributor.append(obj_)
            obj_.original_tagname_ = "contributor"
        elif nodeName_ == "id":
            obj_ = idType.factory()
            obj_.build(child_)
            self.id.append(obj_)
            obj_.original_tagname_ = "id"
        elif nodeName_ == "link":
            obj_ = linkType.factory()
            obj_.build(child_)
            self.link.append(obj_)
            obj_.original_tagname_ = "link"
        elif nodeName_ == "published":
            obj_ = dateTimeType.factory()
            obj_.build(child_)
            self.published.append(obj_)
            obj_.original_tagname_ = "published"
        elif nodeName_ == "rights":
            obj_ = textType.factory()
            obj_.build(child_)
            self.rights.append(obj_)
            obj_.original_tagname_ = "rights"
        elif nodeName_ == "source":
            obj_ = textType.factory()
            obj_.build(child_)
            self.source.append(obj_)
            obj_.original_tagname_ = "source"
        elif nodeName_ == "summary":
            obj_ = textType.factory()
            obj_.build(child_)
            self.summary.append(obj_)
            obj_.original_tagname_ = "summary"
        elif nodeName_ == "title":
            obj_ = textType.factory()
            obj_.build(child_)
            self.title.append(obj_)
            obj_.original_tagname_ = "title"
        elif nodeName_ == "updated":
            obj_ = dateTimeType.factory()
            obj_.build(child_)
            self.updated.append(obj_)
            obj_.original_tagname_ = "updated"
        else:
            obj_ = self.gds_build_any(child_, "entryType")
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)


# end class entryType


class contentType(GeneratedsSuper):
    """The Atom content construct is defined in section 4.1.3 of the format
    spec."""

    subclass = None
    superclass = None

    def __init__(
        self,
        type_=None,
        src=None,
        base=None,
        lang=None,
        anytypeobjs_=None,
        valueOf_=None,
        mixedclass_=None,
        content_=None,
    ):
        self.original_tagname_ = None
        self.type_ = _cast(None, type_)
        self.src = _cast(None, src)
        self.base = _cast(None, base)
        self.lang = _cast(None, lang)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, contentType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if contentType.subclass:
            return contentType.subclass(*args_, **kwargs_)
        else:
            return contentType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_anytypeobjs_(self):
        return self.anytypeobjs_

    def set_anytypeobjs_(self, anytypeobjs_):
        self.anytypeobjs_ = anytypeobjs_

    def add_anytypeobjs_(self, value):
        self.anytypeobjs_.append(value)

    def insert_anytypeobjs_(self, index, value):
        self._anytypeobjs_[index] = value

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_src(self):
        return self.src

    def set_src(self, src):
        self.src = src

    def get_base(self):
        return self.base

    def set_base(self, base):
        self.base = base

    def get_lang(self):
        return self.lang

    def set_lang(self, lang):
        self.lang = lang

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if self.anytypeobjs_ or (
            1 if type(self.valueOf_) in [int, float] else self.valueOf_
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="atom:",
        name_="contentType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:atom="http://www.w3.org/2005/Atom"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("contentType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="contentType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="atom:",
                name_="contentType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="atom:", name_="contentType"
    ):
        if self.type_ is not None and "type_" not in already_processed:
            already_processed.add("type_")
            outfile.write(
                " type=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.type_), input_name="type"
                        )
                    ),
                )
            )
        if self.src is not None and "src" not in already_processed:
            already_processed.add("src")
            outfile.write(
                " src=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_attrib(self.src), input_name="src")
                    ),
                )
            )
        if self.base is not None and "base" not in already_processed:
            already_processed.add("base")
            outfile.write(
                " base=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.base), input_name="base"
                        )
                    ),
                )
            )
        if self.lang is not None and "lang" not in already_processed:
            already_processed.add("lang")
            outfile.write(
                " lang=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.lang), input_name="lang"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="atom:",
        name_="contentType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(
                    outfile, level, item_.name, namespace_, pretty_print=pretty_print
                )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(
                MixedContainer.CategoryText, MixedContainer.TypeNone, "", node.text
            )
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("type", node)
        if value is not None and "type" not in already_processed:
            already_processed.add("type")
            self.type_ = value
        value = find_attr_value_("src", node)
        if value is not None and "src" not in already_processed:
            already_processed.add("src")
            self.src = value
        value = find_attr_value_("base", node)
        if value is not None and "base" not in already_processed:
            already_processed.add("base")
            self.base = value
        value = find_attr_value_("lang", node)
        if value is not None and "lang" not in already_processed:
            already_processed.add("lang")
            self.lang = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "":
            obj_ = __ANY__.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(
                MixedContainer.CategoryComplex, MixedContainer.TypeNone, "", obj_
            )
            self.content_.append(obj_)
            if hasattr(self, "add_"):
                self.add_(obj_.value)
            elif hasattr(self, "set_"):
                self.set_(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(
                MixedContainer.CategoryText, MixedContainer.TypeNone, "", child_.tail
            )
            self.content_.append(obj_)


# end class contentType


class categoryType(GeneratedsSuper):
    """The Atom category construct is defined in section 4.2.2 of the
    format spec."""

    subclass = None
    superclass = None

    def __init__(self, term=None, scheme=None, label=None, base=None, lang=None):
        self.original_tagname_ = None
        self.term = _cast(None, term)
        self.scheme = _cast(None, scheme)
        self.label = _cast(None, label)
        self.base = _cast(None, base)
        self.lang = _cast(None, lang)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, categoryType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if categoryType.subclass:
            return categoryType.subclass(*args_, **kwargs_)
        else:
            return categoryType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_term(self):
        return self.term

    def set_term(self, term):
        self.term = term

    def get_scheme(self):
        return self.scheme

    def set_scheme(self, scheme):
        self.scheme = scheme

    def get_label(self):
        return self.label

    def set_label(self, label):
        self.label = label

    def get_base(self):
        return self.base

    def set_base(self, base):
        self.base = base

    def get_lang(self):
        return self.lang

    def set_lang(self, lang):
        self.lang = lang

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="atom:",
        name_="categoryType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:atom="http://www.w3.org/2005/Atom"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("categoryType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="categoryType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="atom:",
                name_="categoryType",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="atom:",
        name_="categoryType",
    ):
        if self.term is not None and "term" not in already_processed:
            already_processed.add("term")
            outfile.write(
                " term=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.term), input_name="term"
                        )
                    ),
                )
            )
        if self.scheme is not None and "scheme" not in already_processed:
            already_processed.add("scheme")
            outfile.write(
                " scheme=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.scheme), input_name="scheme"
                        )
                    ),
                )
            )
        if self.label is not None and "label" not in already_processed:
            already_processed.add("label")
            outfile.write(
                " label=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.label), input_name="label"
                        )
                    ),
                )
            )
        if self.base is not None and "base" not in already_processed:
            already_processed.add("base")
            outfile.write(
                " base=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.base), input_name="base"
                        )
                    ),
                )
            )
        if self.lang is not None and "lang" not in already_processed:
            already_processed.add("lang")
            outfile.write(
                " lang=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.lang), input_name="lang"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="atom:",
        name_="categoryType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("term", node)
        if value is not None and "term" not in already_processed:
            already_processed.add("term")
            self.term = value
        value = find_attr_value_("scheme", node)
        if value is not None and "scheme" not in already_processed:
            already_processed.add("scheme")
            self.scheme = value
        value = find_attr_value_("label", node)
        if value is not None and "label" not in already_processed:
            already_processed.add("label")
            self.label = value
        value = find_attr_value_("base", node)
        if value is not None and "base" not in already_processed:
            already_processed.add("base")
            self.base = value
        value = find_attr_value_("lang", node)
        if value is not None and "lang" not in already_processed:
            already_processed.add("lang")
            self.lang = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class categoryType


class generatorType(GeneratedsSuper):
    """The Atom generator element is defined in section 4.2.4 of the format
    spec."""

    subclass = None
    superclass = None

    def __init__(self, uri=None, version=None, base=None, lang=None, valueOf_=None):
        self.original_tagname_ = None
        self.uri = _cast(None, uri)
        self.version = _cast(None, version)
        self.base = _cast(None, base)
        self.lang = _cast(None, lang)
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, generatorType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if generatorType.subclass:
            return generatorType.subclass(*args_, **kwargs_)
        else:
            return generatorType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_uri(self):
        return self.uri

    def set_uri(self, uri):
        self.uri = uri

    def get_version(self):
        return self.version

    def set_version(self, version):
        self.version = version

    def get_base(self):
        return self.base

    def set_base(self, base):
        self.base = base

    def get_lang(self):
        return self.lang

    def set_lang(self, lang):
        self.lang = lang

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if 1 if type(self.valueOf_) in [int, float] else self.valueOf_:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="atom:",
        name_="generatorType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:atom="http://www.w3.org/2005/Atom"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("generatorType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="generatorType"
        )
        if self.hasContent_():
            outfile.write(">")
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="atom:",
                name_="generatorType",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="atom:",
        name_="generatorType",
    ):
        if self.uri is not None and "uri" not in already_processed:
            already_processed.add("uri")
            outfile.write(
                " uri=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_attrib(self.uri), input_name="uri")
                    ),
                )
            )
        if self.version is not None and "version" not in already_processed:
            already_processed.add("version")
            outfile.write(
                " version=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.version), input_name="version"
                        )
                    ),
                )
            )
        if self.base is not None and "base" not in already_processed:
            already_processed.add("base")
            outfile.write(
                " base=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.base), input_name="base"
                        )
                    ),
                )
            )
        if self.lang is not None and "lang" not in already_processed:
            already_processed.add("lang")
            outfile.write(
                " lang=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.lang), input_name="lang"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="atom:",
        name_="generatorType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("uri", node)
        if value is not None and "uri" not in already_processed:
            already_processed.add("uri")
            self.uri = value
        value = find_attr_value_("version", node)
        if value is not None and "version" not in already_processed:
            already_processed.add("version")
            self.version = value
        value = find_attr_value_("base", node)
        if value is not None and "base" not in already_processed:
            already_processed.add("base")
            self.base = value
        value = find_attr_value_("lang", node)
        if value is not None and "lang" not in already_processed:
            already_processed.add("lang")
            self.lang = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class generatorType


class iconType(GeneratedsSuper):
    """The Atom icon construct is defined in section 4.2.5 of the format
    spec."""

    subclass = None
    superclass = None

    def __init__(self, base=None, lang=None, valueOf_=None):
        self.original_tagname_ = None
        self.base = _cast(None, base)
        self.lang = _cast(None, lang)
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, iconType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if iconType.subclass:
            return iconType.subclass(*args_, **kwargs_)
        else:
            return iconType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_base(self):
        return self.base

    def set_base(self, base):
        self.base = base

    def get_lang(self):
        return self.lang

    def set_lang(self, lang):
        self.lang = lang

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if 1 if type(self.valueOf_) in [int, float] else self.valueOf_:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="atom:",
        name_="iconType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:atom="http://www.w3.org/2005/Atom"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("iconType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="iconType"
        )
        if self.hasContent_():
            outfile.write(">")
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="atom:",
                name_="iconType",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="atom:", name_="iconType"
    ):
        if self.base is not None and "base" not in already_processed:
            already_processed.add("base")
            outfile.write(
                " base=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.base), input_name="base"
                        )
                    ),
                )
            )
        if self.lang is not None and "lang" not in already_processed:
            already_processed.add("lang")
            outfile.write(
                " lang=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.lang), input_name="lang"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="atom:",
        name_="iconType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("base", node)
        if value is not None and "base" not in already_processed:
            already_processed.add("base")
            self.base = value
        value = find_attr_value_("lang", node)
        if value is not None and "lang" not in already_processed:
            already_processed.add("lang")
            self.lang = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class iconType


class idType(GeneratedsSuper):
    """The Atom id construct is defined in section 4.2.6 of the format
    spec."""

    subclass = None
    superclass = None

    def __init__(self, base=None, lang=None, valueOf_=None):
        self.original_tagname_ = None
        self.base = _cast(None, base)
        self.lang = _cast(None, lang)
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, idType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if idType.subclass:
            return idType.subclass(*args_, **kwargs_)
        else:
            return idType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_base(self):
        return self.base

    def set_base(self, base):
        self.base = base

    def get_lang(self):
        return self.lang

    def set_lang(self, lang):
        self.lang = lang

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if 1 if type(self.valueOf_) in [int, float] else self.valueOf_:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="atom:",
        name_="idType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:atom="http://www.w3.org/2005/Atom"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("idType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="idType"
        )
        if self.hasContent_():
            outfile.write(">")
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="atom:",
                name_="idType",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="atom:", name_="idType"
    ):
        if self.base is not None and "base" not in already_processed:
            already_processed.add("base")
            outfile.write(
                " base=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.base), input_name="base"
                        )
                    ),
                )
            )
        if self.lang is not None and "lang" not in already_processed:
            already_processed.add("lang")
            outfile.write(
                " lang=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.lang), input_name="lang"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="atom:",
        name_="idType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("base", node)
        if value is not None and "base" not in already_processed:
            already_processed.add("base")
            self.base = value
        value = find_attr_value_("lang", node)
        if value is not None and "lang" not in already_processed:
            already_processed.add("lang")
            self.lang = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class idType


class linkType(GeneratedsSuper):
    """The Atom link construct is defined in section 3.4 of the format
    spec."""

    subclass = None
    superclass = None

    def __init__(
        self,
        href=None,
        rel=None,
        type_=None,
        hreflang=None,
        title=None,
        length=None,
        base=None,
        lang=None,
        valueOf_=None,
        mixedclass_=None,
        content_=None,
    ):
        self.original_tagname_ = None
        self.href = _cast(None, href)
        self.rel = _cast(None, rel)
        self.type_ = _cast(None, type_)
        self.hreflang = _cast(None, hreflang)
        self.title = _cast(None, title)
        self.length = _cast(int, length)
        self.base = _cast(None, base)
        self.lang = _cast(None, lang)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, linkType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if linkType.subclass:
            return linkType.subclass(*args_, **kwargs_)
        else:
            return linkType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_href(self):
        return self.href

    def set_href(self, href):
        self.href = href

    def get_rel(self):
        return self.rel

    def set_rel(self, rel):
        self.rel = rel

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_hreflang(self):
        return self.hreflang

    def set_hreflang(self, hreflang):
        self.hreflang = hreflang

    def get_title(self):
        return self.title

    def set_title(self, title):
        self.title = title

    def get_length(self):
        return self.length

    def set_length(self, length):
        self.length = length

    def get_base(self):
        return self.base

    def set_base(self, base):
        self.base = base

    def get_lang(self):
        return self.lang

    def set_lang(self, lang):
        self.lang = lang

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if 1 if type(self.valueOf_) in [int, float] else self.valueOf_:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="atom:",
        name_="linkType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:atom="http://www.w3.org/2005/Atom"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("linkType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="linkType"
        )
        outfile.write(">")
        self.exportChildren(
            outfile, level + 1, namespace_, name_, pretty_print=pretty_print
        )
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write("</%s%s>%s" % (namespace_, name_, eol_))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="atom:", name_="linkType"
    ):
        if self.href is not None and "href" not in already_processed:
            already_processed.add("href")
            outfile.write(
                " href=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.href), input_name="href"
                        )
                    ),
                )
            )
        if self.rel is not None and "rel" not in already_processed:
            already_processed.add("rel")
            outfile.write(
                " rel=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_attrib(self.rel), input_name="rel")
                    ),
                )
            )
        if self.type_ is not None and "type_" not in already_processed:
            already_processed.add("type_")
            outfile.write(
                " type=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.type_), input_name="type"
                        )
                    ),
                )
            )
        if self.hreflang is not None and "hreflang" not in already_processed:
            already_processed.add("hreflang")
            outfile.write(
                " hreflang=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.hreflang), input_name="hreflang"
                        )
                    ),
                )
            )
        if self.title is not None and "title" not in already_processed:
            already_processed.add("title")
            outfile.write(
                " title=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.title), input_name="title"
                        )
                    ),
                )
            )
        if self.length is not None and "length" not in already_processed:
            already_processed.add("length")
            outfile.write(
                ' length="%s"'
                % self.gds_format_integer(self.length, input_name="length")
            )
        if self.base is not None and "base" not in already_processed:
            already_processed.add("base")
            outfile.write(
                " base=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.base), input_name="base"
                        )
                    ),
                )
            )
        if self.lang is not None and "lang" not in already_processed:
            already_processed.add("lang")
            outfile.write(
                " lang=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.lang), input_name="lang"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="atom:",
        name_="linkType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(
                MixedContainer.CategoryText, MixedContainer.TypeNone, "", node.text
            )
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("href", node)
        if value is not None and "href" not in already_processed:
            already_processed.add("href")
            self.href = value
        value = find_attr_value_("rel", node)
        if value is not None and "rel" not in already_processed:
            already_processed.add("rel")
            self.rel = value
        value = find_attr_value_("type", node)
        if value is not None and "type" not in already_processed:
            already_processed.add("type")
            self.type_ = value
        value = find_attr_value_("hreflang", node)
        if value is not None and "hreflang" not in already_processed:
            already_processed.add("hreflang")
            self.hreflang = value
        value = find_attr_value_("title", node)
        if value is not None and "title" not in already_processed:
            already_processed.add("title")
            self.title = value
        value = find_attr_value_("length", node)
        if value is not None and "length" not in already_processed:
            already_processed.add("length")
            try:
                self.length = int(value)
            except ValueError as exp:
                raise_parse_error(node, "Bad integer attribute: %s" % exp)
            if self.length <= 0:
                raise_parse_error(node, "Invalid PositiveInteger")
        value = find_attr_value_("base", node)
        if value is not None and "base" not in already_processed:
            already_processed.add("base")
            self.base = value
        value = find_attr_value_("lang", node)
        if value is not None and "lang" not in already_processed:
            already_processed.add("lang")
            self.lang = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(
                MixedContainer.CategoryText, MixedContainer.TypeNone, "", child_.tail
            )
            self.content_.append(obj_)
        pass


# end class linkType


class logoType(GeneratedsSuper):
    """The Atom logo construct is defined in section 4.2.8 of the format
    spec."""

    subclass = None
    superclass = None

    def __init__(self, base=None, lang=None, valueOf_=None):
        self.original_tagname_ = None
        self.base = _cast(None, base)
        self.lang = _cast(None, lang)
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, logoType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if logoType.subclass:
            return logoType.subclass(*args_, **kwargs_)
        else:
            return logoType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_base(self):
        return self.base

    def set_base(self, base):
        self.base = base

    def get_lang(self):
        return self.lang

    def set_lang(self, lang):
        self.lang = lang

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if 1 if type(self.valueOf_) in [int, float] else self.valueOf_:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="atom:",
        name_="logoType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:atom="http://www.w3.org/2005/Atom"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("logoType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="logoType"
        )
        if self.hasContent_():
            outfile.write(">")
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="atom:",
                name_="logoType",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="atom:", name_="logoType"
    ):
        if self.base is not None and "base" not in already_processed:
            already_processed.add("base")
            outfile.write(
                " base=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.base), input_name="base"
                        )
                    ),
                )
            )
        if self.lang is not None and "lang" not in already_processed:
            already_processed.add("lang")
            outfile.write(
                " lang=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.lang), input_name="lang"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="atom:",
        name_="logoType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("base", node)
        if value is not None and "base" not in already_processed:
            already_processed.add("base")
            self.base = value
        value = find_attr_value_("lang", node)
        if value is not None and "lang" not in already_processed:
            already_processed.add("lang")
            self.lang = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class logoType


class sourceType(GeneratedsSuper):
    """The Atom source construct is defined in section 4.2.11 of the format
    spec."""

    subclass = None
    superclass = None

    def __init__(
        self,
        base=None,
        lang=None,
        author=None,
        category=None,
        contributor=None,
        generator=None,
        icon=None,
        id=None,
        link=None,
        logo=None,
        rights=None,
        subtitle=None,
        title=None,
        updated=None,
        anytypeobjs_=None,
    ):
        self.original_tagname_ = None
        self.base = _cast(None, base)
        self.lang = _cast(None, lang)
        if author is None:
            self.author = []
        else:
            self.author = author
        if category is None:
            self.category = []
        else:
            self.category = category
        if contributor is None:
            self.contributor = []
        else:
            self.contributor = contributor
        if generator is None:
            self.generator = []
        else:
            self.generator = generator
        if icon is None:
            self.icon = []
        else:
            self.icon = icon
        if id is None:
            self.id = []
        else:
            self.id = id
        if link is None:
            self.link = []
        else:
            self.link = link
        if logo is None:
            self.logo = []
        else:
            self.logo = logo
        if rights is None:
            self.rights = []
        else:
            self.rights = rights
        if subtitle is None:
            self.subtitle = []
        else:
            self.subtitle = subtitle
        if title is None:
            self.title = []
        else:
            self.title = title
        if updated is None:
            self.updated = []
        else:
            self.updated = updated
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, sourceType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if sourceType.subclass:
            return sourceType.subclass(*args_, **kwargs_)
        else:
            return sourceType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_author(self):
        return self.author

    def set_author(self, author):
        self.author = author

    def add_author(self, value):
        self.author.append(value)

    def insert_author_at(self, index, value):
        self.author.insert(index, value)

    def replace_author_at(self, index, value):
        self.author[index] = value

    def get_category(self):
        return self.category

    def set_category(self, category):
        self.category = category

    def add_category(self, value):
        self.category.append(value)

    def insert_category_at(self, index, value):
        self.category.insert(index, value)

    def replace_category_at(self, index, value):
        self.category[index] = value

    def get_contributor(self):
        return self.contributor

    def set_contributor(self, contributor):
        self.contributor = contributor

    def add_contributor(self, value):
        self.contributor.append(value)

    def insert_contributor_at(self, index, value):
        self.contributor.insert(index, value)

    def replace_contributor_at(self, index, value):
        self.contributor[index] = value

    def get_generator(self):
        return self.generator

    def set_generator(self, generator):
        self.generator = generator

    def add_generator(self, value):
        self.generator.append(value)

    def insert_generator_at(self, index, value):
        self.generator.insert(index, value)

    def replace_generator_at(self, index, value):
        self.generator[index] = value

    def get_icon(self):
        return self.icon

    def set_icon(self, icon):
        self.icon = icon

    def add_icon(self, value):
        self.icon.append(value)

    def insert_icon_at(self, index, value):
        self.icon.insert(index, value)

    def replace_icon_at(self, index, value):
        self.icon[index] = value

    def get_id(self):
        return self.id

    def set_id(self, id):
        self.id = id

    def add_id(self, value):
        self.id.append(value)

    def insert_id_at(self, index, value):
        self.id.insert(index, value)

    def replace_id_at(self, index, value):
        self.id[index] = value

    def get_link(self):
        return self.link

    def set_link(self, link):
        self.link = link

    def add_link(self, value):
        self.link.append(value)

    def insert_link_at(self, index, value):
        self.link.insert(index, value)

    def replace_link_at(self, index, value):
        self.link[index] = value

    def get_logo(self):
        return self.logo

    def set_logo(self, logo):
        self.logo = logo

    def add_logo(self, value):
        self.logo.append(value)

    def insert_logo_at(self, index, value):
        self.logo.insert(index, value)

    def replace_logo_at(self, index, value):
        self.logo[index] = value

    def get_rights(self):
        return self.rights

    def set_rights(self, rights):
        self.rights = rights

    def add_rights(self, value):
        self.rights.append(value)

    def insert_rights_at(self, index, value):
        self.rights.insert(index, value)

    def replace_rights_at(self, index, value):
        self.rights[index] = value

    def get_subtitle(self):
        return self.subtitle

    def set_subtitle(self, subtitle):
        self.subtitle = subtitle

    def add_subtitle(self, value):
        self.subtitle.append(value)

    def insert_subtitle_at(self, index, value):
        self.subtitle.insert(index, value)

    def replace_subtitle_at(self, index, value):
        self.subtitle[index] = value

    def get_title(self):
        return self.title

    def set_title(self, title):
        self.title = title

    def add_title(self, value):
        self.title.append(value)

    def insert_title_at(self, index, value):
        self.title.insert(index, value)

    def replace_title_at(self, index, value):
        self.title[index] = value

    def get_updated(self):
        return self.updated

    def set_updated(self, updated):
        self.updated = updated

    def add_updated(self, value):
        self.updated.append(value)

    def insert_updated_at(self, index, value):
        self.updated.insert(index, value)

    def replace_updated_at(self, index, value):
        self.updated[index] = value

    def get_anytypeobjs_(self):
        return self.anytypeobjs_

    def set_anytypeobjs_(self, anytypeobjs_):
        self.anytypeobjs_ = anytypeobjs_

    def add_anytypeobjs_(self, value):
        self.anytypeobjs_.append(value)

    def insert_anytypeobjs_(self, index, value):
        self._anytypeobjs_[index] = value

    def get_base(self):
        return self.base

    def set_base(self, base):
        self.base = base

    def get_lang(self):
        return self.lang

    def set_lang(self, lang):
        self.lang = lang

    def hasContent_(self):
        if (
            self.author
            or self.category
            or self.contributor
            or self.generator
            or self.icon
            or self.id
            or self.link
            or self.logo
            or self.rights
            or self.subtitle
            or self.title
            or self.updated
            or self.anytypeobjs_
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="atom:",
        name_="sourceType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:atom="http://www.w3.org/2005/Atom" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("sourceType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="sourceType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="atom:",
                name_="sourceType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="atom:", name_="sourceType"
    ):
        if self.base is not None and "base" not in already_processed:
            already_processed.add("base")
            outfile.write(
                " base=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.base), input_name="base"
                        )
                    ),
                )
            )
        if self.lang is not None and "lang" not in already_processed:
            already_processed.add("lang")
            outfile.write(
                " lang=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.lang), input_name="lang"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="atom:",
        name_="sourceType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for author_ in self.author:
            author_.export(
                outfile, level, namespace_, name_="author", pretty_print=pretty_print
            )
        for category_ in self.category:
            category_.export(
                outfile, level, namespace_, name_="category", pretty_print=pretty_print
            )
        for contributor_ in self.contributor:
            contributor_.export(
                outfile,
                level,
                namespace_,
                name_="contributor",
                pretty_print=pretty_print,
            )
        for generator_ in self.generator:
            generator_.export(
                outfile, level, namespace_, name_="generator", pretty_print=pretty_print
            )
        for icon_ in self.icon:
            icon_.export(
                outfile, level, namespace_, name_="icon", pretty_print=pretty_print
            )
        for id_ in self.id:
            id_.export(
                outfile, level, namespace_, name_="id", pretty_print=pretty_print
            )
        for link_ in self.link:
            link_.export(
                outfile, level, namespace_, name_="link", pretty_print=pretty_print
            )
        for logo_ in self.logo:
            logo_.export(
                outfile, level, namespace_, name_="logo", pretty_print=pretty_print
            )
        for rights_ in self.rights:
            rights_.export(
                outfile, level, namespace_, name_="rights", pretty_print=pretty_print
            )
        for subtitle_ in self.subtitle:
            subtitle_.export(
                outfile, level, namespace_, name_="subtitle", pretty_print=pretty_print
            )
        for title_ in self.title:
            title_.export(
                outfile, level, namespace_, name_="title", pretty_print=pretty_print
            )
        for updated_ in self.updated:
            updated_.export(
                outfile, level, namespace_, name_="updated", pretty_print=pretty_print
            )
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("base", node)
        if value is not None and "base" not in already_processed:
            already_processed.add("base")
            self.base = value
        value = find_attr_value_("lang", node)
        if value is not None and "lang" not in already_processed:
            already_processed.add("lang")
            self.lang = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "author":
            obj_ = personType.factory()
            obj_.build(child_)
            self.author.append(obj_)
            obj_.original_tagname_ = "author"
        elif nodeName_ == "category":
            obj_ = categoryType.factory()
            obj_.build(child_)
            self.category.append(obj_)
            obj_.original_tagname_ = "category"
        elif nodeName_ == "contributor":
            obj_ = personType.factory()
            obj_.build(child_)
            self.contributor.append(obj_)
            obj_.original_tagname_ = "contributor"
        elif nodeName_ == "generator":
            obj_ = generatorType.factory()
            obj_.build(child_)
            self.generator.append(obj_)
            obj_.original_tagname_ = "generator"
        elif nodeName_ == "icon":
            obj_ = iconType.factory()
            obj_.build(child_)
            self.icon.append(obj_)
            obj_.original_tagname_ = "icon"
        elif nodeName_ == "id":
            obj_ = idType.factory()
            obj_.build(child_)
            self.id.append(obj_)
            obj_.original_tagname_ = "id"
        elif nodeName_ == "link":
            obj_ = linkType.factory()
            obj_.build(child_)
            self.link.append(obj_)
            obj_.original_tagname_ = "link"
        elif nodeName_ == "logo":
            obj_ = logoType.factory()
            obj_.build(child_)
            self.logo.append(obj_)
            obj_.original_tagname_ = "logo"
        elif nodeName_ == "rights":
            obj_ = textType.factory()
            obj_.build(child_)
            self.rights.append(obj_)
            obj_.original_tagname_ = "rights"
        elif nodeName_ == "subtitle":
            obj_ = textType.factory()
            obj_.build(child_)
            self.subtitle.append(obj_)
            obj_.original_tagname_ = "subtitle"
        elif nodeName_ == "title":
            obj_ = textType.factory()
            obj_.build(child_)
            self.title.append(obj_)
            obj_.original_tagname_ = "title"
        elif nodeName_ == "updated":
            obj_ = dateTimeType.factory()
            obj_.build(child_)
            self.updated.append(obj_)
            obj_.original_tagname_ = "updated"
        else:
            obj_ = self.gds_build_any(child_, "sourceType")
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)


# end class sourceType


class uriType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, base=None, lang=None, valueOf_=None):
        self.original_tagname_ = None
        self.base = _cast(None, base)
        self.lang = _cast(None, lang)
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, uriType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if uriType.subclass:
            return uriType.subclass(*args_, **kwargs_)
        else:
            return uriType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_base(self):
        return self.base

    def set_base(self, base):
        self.base = base

    def get_lang(self):
        return self.lang

    def set_lang(self, lang):
        self.lang = lang

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if 1 if type(self.valueOf_) in [int, float] else self.valueOf_:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="atom:",
        name_="uriType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:atom="http://www.w3.org/2005/Atom"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("uriType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="uriType"
        )
        if self.hasContent_():
            outfile.write(">")
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="atom:",
                name_="uriType",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="atom:", name_="uriType"
    ):
        if self.base is not None and "base" not in already_processed:
            already_processed.add("base")
            outfile.write(
                " base=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.base), input_name="base"
                        )
                    ),
                )
            )
        if self.lang is not None and "lang" not in already_processed:
            already_processed.add("lang")
            outfile.write(
                " lang=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.lang), input_name="lang"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="atom:",
        name_="uriType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("base", node)
        if value is not None and "base" not in already_processed:
            already_processed.add("base")
            self.base = value
        value = find_attr_value_("lang", node)
        if value is not None and "lang" not in already_processed:
            already_processed.add("lang")
            self.lang = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class uriType


class dateTimeType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, base=None, lang=None, valueOf_=None):
        self.original_tagname_ = None
        self.base = _cast(None, base)
        self.lang = _cast(None, lang)
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, dateTimeType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if dateTimeType.subclass:
            return dateTimeType.subclass(*args_, **kwargs_)
        else:
            return dateTimeType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_base(self):
        return self.base

    def set_base(self, base):
        self.base = base

    def get_lang(self):
        return self.lang

    def set_lang(self, lang):
        self.lang = lang

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if 1 if type(self.valueOf_) in [int, float] else self.valueOf_:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="atom:",
        name_="dateTimeType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:atom="http://www.w3.org/2005/Atom"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("dateTimeType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="dateTimeType"
        )
        if self.hasContent_():
            outfile.write(">")
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="atom:",
                name_="dateTimeType",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="atom:",
        name_="dateTimeType",
    ):
        if self.base is not None and "base" not in already_processed:
            already_processed.add("base")
            outfile.write(
                " base=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.base), input_name="base"
                        )
                    ),
                )
            )
        if self.lang is not None and "lang" not in already_processed:
            already_processed.add("lang")
            outfile.write(
                " lang=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.lang), input_name="lang"
                        )
                    ),
                )
            )

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="atom:",
        name_="dateTimeType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("base", node)
        if value is not None and "base" not in already_processed:
            already_processed.add("base")
            self.base = value
        value = find_attr_value_("lang", node)
        if value is not None and "lang" not in already_processed:
            already_processed.add("lang")
            self.lang = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class dateTimeType


class ECKeyValueType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, Id=None, ECParameters=None, NamedCurve=None, PublicKey=None):
        self.original_tagname_ = None
        self.Id = _cast(None, Id)
        self.ECParameters = ECParameters
        self.NamedCurve = NamedCurve
        self.PublicKey = PublicKey
        self.validate_ECPointType(self.PublicKey)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ECKeyValueType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ECKeyValueType.subclass:
            return ECKeyValueType.subclass(*args_, **kwargs_)
        else:
            return ECKeyValueType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ECParameters(self):
        return self.ECParameters

    def set_ECParameters(self, ECParameters):
        self.ECParameters = ECParameters

    def get_NamedCurve(self):
        return self.NamedCurve

    def set_NamedCurve(self, NamedCurve):
        self.NamedCurve = NamedCurve

    def get_PublicKey(self):
        return self.PublicKey

    def set_PublicKey(self, PublicKey):
        self.PublicKey = PublicKey

    def get_Id(self):
        return self.Id

    def set_Id(self, Id):
        self.Id = Id

    def validate_ECPointType(self, value):
        # Validate type ECPointType, a restriction on ds:CryptoBinary.
        if value is not None and Validate_simpletypes_:
            pass

    def hasContent_(self):
        if (
            self.ECParameters is not None
            or self.NamedCurve is not None
            or self.PublicKey is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="dsig11:",
        name_="ECKeyValueType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:dsig11="http://www.w3.org/2009/xmldsig11#" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ECKeyValueType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="ECKeyValueType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="dsig11:",
                name_="ECKeyValueType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="dsig11:",
        name_="ECKeyValueType",
    ):
        if self.Id is not None and "Id" not in already_processed:
            already_processed.add("Id")
            outfile.write(" Id=%s" % (quote_attrib(self.Id),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="dsig11:",
        name_="ECKeyValueType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.ECParameters is not None:
            self.ECParameters.export(
                outfile,
                level,
                namespace_,
                name_="ECParameters",
                pretty_print=pretty_print,
            )
        if self.NamedCurve is not None:
            self.NamedCurve.export(
                outfile,
                level,
                namespace_,
                name_="NamedCurve",
                pretty_print=pretty_print,
            )
        if self.PublicKey is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<dsig11:PublicKey>%s</dsig11:PublicKey>%s"
                % (self.gds_format_base64(self.PublicKey, input_name="PublicKey"), eol_)
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("Id", node)
        if value is not None and "Id" not in already_processed:
            already_processed.add("Id")
            self.Id = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "ECParameters":
            obj_ = ECParametersType.factory()
            obj_.build(child_)
            self.ECParameters = obj_
            obj_.original_tagname_ = "ECParameters"
        elif nodeName_ == "NamedCurve":
            obj_ = NamedCurveType.factory()
            obj_.build(child_)
            self.NamedCurve = obj_
            obj_.original_tagname_ = "NamedCurve"
        elif nodeName_ == "PublicKey":
            sval_ = child_.text
            if sval_ is not None:
                try:
                    bval_ = base64.b64decode(sval_)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(
                        child_, "requires base64 encoded string: %s" % exp
                    )
                bval_ = self.gds_validate_base64(bval_, node, "PublicKey")
            else:
                bval_ = None
            self.PublicKey = bval_
            # validate type ECPointType
            self.validate_ECPointType(self.PublicKey)


# end class ECKeyValueType


class NamedCurveType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, URI=None):
        self.original_tagname_ = None
        self.URI = _cast(None, URI)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, NamedCurveType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NamedCurveType.subclass:
            return NamedCurveType.subclass(*args_, **kwargs_)
        else:
            return NamedCurveType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_URI(self):
        return self.URI

    def set_URI(self, URI):
        self.URI = URI

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="dsig11:",
        name_="NamedCurveType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:dsig11="http://www.w3.org/2009/xmldsig11#"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("NamedCurveType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="NamedCurveType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="dsig11:",
                name_="NamedCurveType",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="dsig11:",
        name_="NamedCurveType",
    ):
        if self.URI is not None and "URI" not in already_processed:
            already_processed.add("URI")
            outfile.write(" URI=%s" % (quote_attrib(self.URI),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="dsig11:",
        name_="NamedCurveType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("URI", node)
        if value is not None and "URI" not in already_processed:
            already_processed.add("URI")
            self.URI = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class NamedCurveType


class ECParametersType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self,
        FieldID=None,
        Curve=None,
        Base=None,
        Order=None,
        CoFactor=None,
        ValidationData=None,
    ):
        self.original_tagname_ = None
        self.FieldID = FieldID
        self.Curve = Curve
        self.Base = Base
        self.validate_ECPointType(self.Base)
        self.Order = Order
        self.validate_CryptoBinary(self.Order)
        self.CoFactor = CoFactor
        self.ValidationData = ValidationData

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ECParametersType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ECParametersType.subclass:
            return ECParametersType.subclass(*args_, **kwargs_)
        else:
            return ECParametersType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_FieldID(self):
        return self.FieldID

    def set_FieldID(self, FieldID):
        self.FieldID = FieldID

    def get_Curve(self):
        return self.Curve

    def set_Curve(self, Curve):
        self.Curve = Curve

    def get_Base(self):
        return self.Base

    def set_Base(self, Base):
        self.Base = Base

    def get_Order(self):
        return self.Order

    def set_Order(self, Order):
        self.Order = Order

    def get_CoFactor(self):
        return self.CoFactor

    def set_CoFactor(self, CoFactor):
        self.CoFactor = CoFactor

    def get_ValidationData(self):
        return self.ValidationData

    def set_ValidationData(self, ValidationData):
        self.ValidationData = ValidationData

    def validate_ECPointType(self, value):
        # Validate type ECPointType, a restriction on ds:CryptoBinary.
        if value is not None and Validate_simpletypes_:
            pass

    def validate_CryptoBinary(self, value):
        # Validate type CryptoBinary, a restriction on base64Binary.
        if value is not None and Validate_simpletypes_:
            pass

    def hasContent_(self):
        if (
            self.FieldID is not None
            or self.Curve is not None
            or self.Base is not None
            or self.Order is not None
            or self.CoFactor is not None
            or self.ValidationData is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="dsig11:",
        name_="ECParametersType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:dsig11="http://www.w3.org/2009/xmldsig11#"  xmlns:ds="http://www.w3.org/2000/09/xmldsig#" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ECParametersType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="ECParametersType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="dsig11:",
                name_="ECParametersType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="dsig11:",
        name_="ECParametersType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="dsig11:",
        name_="ECParametersType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.FieldID is not None:
            self.FieldID.export(
                outfile, level, namespace_, name_="FieldID", pretty_print=pretty_print
            )
        if self.Curve is not None:
            self.Curve.export(
                outfile, level, namespace_, name_="Curve", pretty_print=pretty_print
            )
        if self.Base is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<dsig11:Base>%s</dsig11:Base>%s"
                % (self.gds_format_base64(self.Base, input_name="Base"), eol_)
            )
        if self.Order is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<dsig11:Order>%s</dsig11:Order>%s"
                % (self.gds_format_base64(self.Order, input_name="Order"), eol_)
            )
        if self.CoFactor is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<dsig11:CoFactor>%s</dsig11:CoFactor>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.CoFactor), input_name="CoFactor"
                        )
                    ),
                    eol_,
                )
            )
        if self.ValidationData is not None:
            self.ValidationData.export(
                outfile,
                level,
                namespace_,
                name_="ValidationData",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "FieldID":
            obj_ = FieldIDType.factory()
            obj_.build(child_)
            self.FieldID = obj_
            obj_.original_tagname_ = "FieldID"
        elif nodeName_ == "Curve":
            obj_ = CurveType.factory()
            obj_.build(child_)
            self.Curve = obj_
            obj_.original_tagname_ = "Curve"
        elif nodeName_ == "Base":
            sval_ = child_.text
            if sval_ is not None:
                try:
                    bval_ = base64.b64decode(sval_)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(
                        child_, "requires base64 encoded string: %s" % exp
                    )
                bval_ = self.gds_validate_base64(bval_, node, "Base")
            else:
                bval_ = None
            self.Base = bval_
            # validate type ECPointType
            self.validate_ECPointType(self.Base)
        elif nodeName_ == "Order":
            sval_ = child_.text
            if sval_ is not None:
                try:
                    bval_ = base64.b64decode(sval_)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(
                        child_, "requires base64 encoded string: %s" % exp
                    )
                bval_ = self.gds_validate_base64(bval_, node, "Order")
            else:
                bval_ = None
            self.Order = bval_
            # validate type CryptoBinary
            self.validate_CryptoBinary(self.Order)
        elif nodeName_ == "CoFactor":
            CoFactor_ = child_.text
            CoFactor_ = self.gds_validate_string(CoFactor_, node, "CoFactor")
            self.CoFactor = CoFactor_
        elif nodeName_ == "ValidationData":
            obj_ = ECValidationDataType.factory()
            obj_.build(child_)
            self.ValidationData = obj_
            obj_.original_tagname_ = "ValidationData"


# end class ECParametersType


class FieldIDType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, Prime=None, TnB=None, PnB=None, GnB=None, anytypeobjs_=None):
        self.original_tagname_ = None
        self.Prime = Prime
        self.TnB = TnB
        self.PnB = PnB
        self.GnB = GnB
        self.anytypeobjs_ = anytypeobjs_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, FieldIDType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if FieldIDType.subclass:
            return FieldIDType.subclass(*args_, **kwargs_)
        else:
            return FieldIDType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Prime(self):
        return self.Prime

    def set_Prime(self, Prime):
        self.Prime = Prime

    def get_TnB(self):
        return self.TnB

    def set_TnB(self, TnB):
        self.TnB = TnB

    def get_PnB(self):
        return self.PnB

    def set_PnB(self, PnB):
        self.PnB = PnB

    def get_GnB(self):
        return self.GnB

    def set_GnB(self, GnB):
        self.GnB = GnB

    def get_anytypeobjs_(self):
        return self.anytypeobjs_

    def set_anytypeobjs_(self, anytypeobjs_):
        self.anytypeobjs_ = anytypeobjs_

    def hasContent_(self):
        if (
            self.Prime is not None
            or self.TnB is not None
            or self.PnB is not None
            or self.GnB is not None
            or self.anytypeobjs_ is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="dsig11:",
        name_="FieldIDType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:dsig11="http://www.w3.org/2009/xmldsig11#" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("FieldIDType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="FieldIDType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="dsig11:",
                name_="FieldIDType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="dsig11:",
        name_="FieldIDType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="dsig11:",
        name_="FieldIDType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.Prime is not None:
            self.Prime.export(
                outfile,
                level,
                namespace_="dsig11:",
                name_="Prime",
                pretty_print=pretty_print,
            )
        if self.TnB is not None:
            self.TnB.export(
                outfile,
                level,
                namespace_="dsig11:",
                name_="TnB",
                pretty_print=pretty_print,
            )
        if self.PnB is not None:
            self.PnB.export(
                outfile,
                level,
                namespace_="dsig11:",
                name_="PnB",
                pretty_print=pretty_print,
            )
        if self.GnB is not None:
            self.GnB.export(
                outfile,
                level,
                namespace_="dsig11:",
                name_="GnB",
                pretty_print=pretty_print,
            )
        if self.anytypeobjs_ is not None:
            self.anytypeobjs_.export(
                outfile, level, namespace_, pretty_print=pretty_print
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "Prime":
            obj_ = PrimeFieldParamsType.factory()
            obj_.build(child_)
            self.Prime = obj_
            obj_.original_tagname_ = "Prime"
        elif nodeName_ == "TnB":
            obj_ = TnBFieldParamsType.factory()
            obj_.build(child_)
            self.TnB = obj_
            obj_.original_tagname_ = "TnB"
        elif nodeName_ == "PnB":
            obj_ = PnBFieldParamsType.factory()
            obj_.build(child_)
            self.PnB = obj_
            obj_.original_tagname_ = "PnB"
        elif nodeName_ == "GnB":
            class_obj_ = self.get_class_obj_(child_, CharTwoFieldParamsType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.GnB = obj_
            obj_.original_tagname_ = "GnB"
        else:
            obj_ = self.gds_build_any(child_, "FieldIDType")
            if obj_ is not None:
                self.set_anytypeobjs_(obj_)


# end class FieldIDType


class CurveType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, A=None, B=None):
        self.original_tagname_ = None
        self.A = A
        self.validate_CryptoBinary(self.A)
        self.B = B
        self.validate_CryptoBinary(self.B)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, CurveType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CurveType.subclass:
            return CurveType.subclass(*args_, **kwargs_)
        else:
            return CurveType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_A(self):
        return self.A

    def set_A(self, A):
        self.A = A

    def get_B(self):
        return self.B

    def set_B(self, B):
        self.B = B

    def validate_CryptoBinary(self, value):
        # Validate type CryptoBinary, a restriction on base64Binary.
        if value is not None and Validate_simpletypes_:
            pass

    def hasContent_(self):
        if self.A is not None or self.B is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="dsig11:",
        name_="CurveType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ds="http://www.w3.org/2000/09/xmldsig#"  xmlns:dsig11="http://www.w3.org/2009/xmldsig11#"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("CurveType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="CurveType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="dsig11:",
                name_="CurveType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="dsig11:", name_="CurveType"
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="dsig11:",
        name_="CurveType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.A is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<dsig11:A>%s</dsig11:A>%s"
                % (self.gds_format_base64(self.A, input_name="A"), eol_)
            )
        if self.B is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<dsig11:B>%s</dsig11:B>%s"
                % (self.gds_format_base64(self.B, input_name="B"), eol_)
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "A":
            sval_ = child_.text
            if sval_ is not None:
                try:
                    bval_ = base64.b64decode(sval_)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(
                        child_, "requires base64 encoded string: %s" % exp
                    )
                bval_ = self.gds_validate_base64(bval_, node, "A")
            else:
                bval_ = None
            self.A = bval_
            # validate type CryptoBinary
            self.validate_CryptoBinary(self.A)
        elif nodeName_ == "B":
            sval_ = child_.text
            if sval_ is not None:
                try:
                    bval_ = base64.b64decode(sval_)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(
                        child_, "requires base64 encoded string: %s" % exp
                    )
                bval_ = self.gds_validate_base64(bval_, node, "B")
            else:
                bval_ = None
            self.B = bval_
            # validate type CryptoBinary
            self.validate_CryptoBinary(self.B)


# end class CurveType


class ECValidationDataType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, hashAlgorithm=None, seed=None):
        self.original_tagname_ = None
        self.hashAlgorithm = _cast(None, hashAlgorithm)
        self.seed = seed
        self.validate_CryptoBinary(self.seed)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ECValidationDataType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ECValidationDataType.subclass:
            return ECValidationDataType.subclass(*args_, **kwargs_)
        else:
            return ECValidationDataType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_seed(self):
        return self.seed

    def set_seed(self, seed):
        self.seed = seed

    def get_hashAlgorithm(self):
        return self.hashAlgorithm

    def set_hashAlgorithm(self, hashAlgorithm):
        self.hashAlgorithm = hashAlgorithm

    def validate_CryptoBinary(self, value):
        # Validate type CryptoBinary, a restriction on base64Binary.
        if value is not None and Validate_simpletypes_:
            pass

    def hasContent_(self):
        if self.seed is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="dsig11:",
        name_="ECValidationDataType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ds="http://www.w3.org/2000/09/xmldsig#"  xmlns:dsig11="http://www.w3.org/2009/xmldsig11#"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ECValidationDataType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="ECValidationDataType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="dsig11:",
                name_="ECValidationDataType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="dsig11:",
        name_="ECValidationDataType",
    ):
        if self.hashAlgorithm is not None and "hashAlgorithm" not in already_processed:
            already_processed.add("hashAlgorithm")
            outfile.write(" hashAlgorithm=%s" % (quote_attrib(self.hashAlgorithm),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="dsig11:",
        name_="ECValidationDataType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.seed is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<dsig11:seed>%s</dsig11:seed>%s"
                % (self.gds_format_base64(self.seed, input_name="seed"), eol_)
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("hashAlgorithm", node)
        if value is not None and "hashAlgorithm" not in already_processed:
            already_processed.add("hashAlgorithm")
            self.hashAlgorithm = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "seed":
            sval_ = child_.text
            if sval_ is not None:
                try:
                    bval_ = base64.b64decode(sval_)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(
                        child_, "requires base64 encoded string: %s" % exp
                    )
                bval_ = self.gds_validate_base64(bval_, node, "seed")
            else:
                bval_ = None
            self.seed = bval_
            # validate type CryptoBinary
            self.validate_CryptoBinary(self.seed)


# end class ECValidationDataType


class PrimeFieldParamsType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, P=None):
        self.original_tagname_ = None
        self.P = P
        self.validate_CryptoBinary(self.P)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PrimeFieldParamsType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PrimeFieldParamsType.subclass:
            return PrimeFieldParamsType.subclass(*args_, **kwargs_)
        else:
            return PrimeFieldParamsType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_P(self):
        return self.P

    def set_P(self, P):
        self.P = P

    def validate_CryptoBinary(self, value):
        # Validate type CryptoBinary, a restriction on base64Binary.
        if value is not None and Validate_simpletypes_:
            pass

    def hasContent_(self):
        if self.P is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="dsig11:",
        name_="PrimeFieldParamsType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ds="http://www.w3.org/2000/09/xmldsig#"  xmlns:dsig11="http://www.w3.org/2009/xmldsig11#"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("PrimeFieldParamsType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="PrimeFieldParamsType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="dsig11:",
                name_="PrimeFieldParamsType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="dsig11:",
        name_="PrimeFieldParamsType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="dsig11:",
        name_="PrimeFieldParamsType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.P is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<dsig11:P>%s</dsig11:P>%s"
                % (self.gds_format_base64(self.P, input_name="P"), eol_)
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "P":
            sval_ = child_.text
            if sval_ is not None:
                try:
                    bval_ = base64.b64decode(sval_)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(
                        child_, "requires base64 encoded string: %s" % exp
                    )
                bval_ = self.gds_validate_base64(bval_, node, "P")
            else:
                bval_ = None
            self.P = bval_
            # validate type CryptoBinary
            self.validate_CryptoBinary(self.P)


# end class PrimeFieldParamsType


class CharTwoFieldParamsType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, M=None, extensiontype_=None):
        self.original_tagname_ = None
        self.M = M
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CharTwoFieldParamsType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CharTwoFieldParamsType.subclass:
            return CharTwoFieldParamsType.subclass(*args_, **kwargs_)
        else:
            return CharTwoFieldParamsType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_M(self):
        return self.M

    def set_M(self, M):
        self.M = M

    def get_extensiontype_(self):
        return self.extensiontype_

    def set_extensiontype_(self, extensiontype_):
        self.extensiontype_ = extensiontype_

    def hasContent_(self):
        if self.M is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="dsig11:",
        name_="CharTwoFieldParamsType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:dsig11="http://www.w3.org/2009/xmldsig11#"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("CharTwoFieldParamsType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespace_,
            name_="CharTwoFieldParamsType",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="dsig11:",
                name_="CharTwoFieldParamsType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="dsig11:",
        name_="CharTwoFieldParamsType",
    ):
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="dsig11:",
        name_="CharTwoFieldParamsType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.M is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<dsig11:M>%s</dsig11:M>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.M), input_name="M")
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "M":
            M_ = child_.text
            M_ = self.gds_validate_string(M_, node, "M")
            self.M = M_


# end class CharTwoFieldParamsType


class TnBFieldParamsType(CharTwoFieldParamsType):
    subclass = None
    superclass = CharTwoFieldParamsType

    def __init__(self, M=None, K=None):
        self.original_tagname_ = None
        super(TnBFieldParamsType, self).__init__(M)
        self.K = K

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TnBFieldParamsType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TnBFieldParamsType.subclass:
            return TnBFieldParamsType.subclass(*args_, **kwargs_)
        else:
            return TnBFieldParamsType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_K(self):
        return self.K

    def set_K(self, K):
        self.K = K

    def hasContent_(self):
        if self.K is not None or super(TnBFieldParamsType, self).hasContent_():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="dsig11:",
        name_="TnBFieldParamsType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:dsig11="http://www.w3.org/2009/xmldsig11#"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("TnBFieldParamsType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="TnBFieldParamsType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="dsig11:",
                name_="TnBFieldParamsType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="dsig11:",
        name_="TnBFieldParamsType",
    ):
        super(TnBFieldParamsType, self).exportAttributes(
            outfile, level, already_processed, namespace_, name_="TnBFieldParamsType"
        )

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="dsig11:",
        name_="TnBFieldParamsType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(TnBFieldParamsType, self).exportChildren(
            outfile, level, namespace_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.K is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<dsig11:K>%s</dsig11:K>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.K), input_name="K")
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(TnBFieldParamsType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "K":
            K_ = child_.text
            K_ = self.gds_validate_string(K_, node, "K")
            self.K = K_
        super(TnBFieldParamsType, self).buildChildren(child_, node, nodeName_, True)


# end class TnBFieldParamsType


class PnBFieldParamsType(CharTwoFieldParamsType):
    subclass = None
    superclass = CharTwoFieldParamsType

    def __init__(self, M=None, K1=None, K2=None, K3=None):
        self.original_tagname_ = None
        super(PnBFieldParamsType, self).__init__(M)
        self.K1 = K1
        self.K2 = K2
        self.K3 = K3

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PnBFieldParamsType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PnBFieldParamsType.subclass:
            return PnBFieldParamsType.subclass(*args_, **kwargs_)
        else:
            return PnBFieldParamsType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_K1(self):
        return self.K1

    def set_K1(self, K1):
        self.K1 = K1

    def get_K2(self):
        return self.K2

    def set_K2(self, K2):
        self.K2 = K2

    def get_K3(self):
        return self.K3

    def set_K3(self, K3):
        self.K3 = K3

    def hasContent_(self):
        if (
            self.K1 is not None
            or self.K2 is not None
            or self.K3 is not None
            or super(PnBFieldParamsType, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="dsig11:",
        name_="PnBFieldParamsType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:dsig11="http://www.w3.org/2009/xmldsig11#"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("PnBFieldParamsType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="PnBFieldParamsType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="dsig11:",
                name_="PnBFieldParamsType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="dsig11:",
        name_="PnBFieldParamsType",
    ):
        super(PnBFieldParamsType, self).exportAttributes(
            outfile, level, already_processed, namespace_, name_="PnBFieldParamsType"
        )

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="dsig11:",
        name_="PnBFieldParamsType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(PnBFieldParamsType, self).exportChildren(
            outfile, level, namespace_, name_, True, pretty_print=pretty_print
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.K1 is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<dsig11:K1>%s</dsig11:K1>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.K1), input_name="K1")
                    ),
                    eol_,
                )
            )
        if self.K2 is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<dsig11:K2>%s</dsig11:K2>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.K2), input_name="K2")
                    ),
                    eol_,
                )
            )
        if self.K3 is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<dsig11:K3>%s</dsig11:K3>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_xml(self.K3), input_name="K3")
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        super(PnBFieldParamsType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "K1":
            K1_ = child_.text
            K1_ = self.gds_validate_string(K1_, node, "K1")
            self.K1 = K1_
        elif nodeName_ == "K2":
            K2_ = child_.text
            K2_ = self.gds_validate_string(K2_, node, "K2")
            self.K2 = K2_
        elif nodeName_ == "K3":
            K3_ = child_.text
            K3_ = self.gds_validate_string(K3_, node, "K3")
            self.K3 = K3_
        super(PnBFieldParamsType, self).buildChildren(child_, node, nodeName_, True)


# end class PnBFieldParamsType


class DEREncodedKeyValueType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, Id=None, valueOf_=None):
        self.original_tagname_ = None
        self.Id = _cast(None, Id)
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DEREncodedKeyValueType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DEREncodedKeyValueType.subclass:
            return DEREncodedKeyValueType.subclass(*args_, **kwargs_)
        else:
            return DEREncodedKeyValueType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Id(self):
        return self.Id

    def set_Id(self, Id):
        self.Id = Id

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if 1 if type(self.valueOf_) in [int, float] else self.valueOf_:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="dsig11:",
        name_="DEREncodedKeyValueType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:dsig11="http://www.w3.org/2009/xmldsig11#"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("DEREncodedKeyValueType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespace_,
            name_="DEREncodedKeyValueType",
        )
        if self.hasContent_():
            outfile.write(">")
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="dsig11:",
                name_="DEREncodedKeyValueType",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="dsig11:",
        name_="DEREncodedKeyValueType",
    ):
        if self.Id is not None and "Id" not in already_processed:
            already_processed.add("Id")
            outfile.write(" Id=%s" % (quote_attrib(self.Id),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="dsig11:",
        name_="DEREncodedKeyValueType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("Id", node)
        if value is not None and "Id" not in already_processed:
            already_processed.add("Id")
            self.Id = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class DEREncodedKeyValueType


class KeyInfoReferenceType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, URI=None, Id=None):
        self.original_tagname_ = None
        self.URI = _cast(None, URI)
        self.Id = _cast(None, Id)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, KeyInfoReferenceType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if KeyInfoReferenceType.subclass:
            return KeyInfoReferenceType.subclass(*args_, **kwargs_)
        else:
            return KeyInfoReferenceType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_URI(self):
        return self.URI

    def set_URI(self, URI):
        self.URI = URI

    def get_Id(self):
        return self.Id

    def set_Id(self, Id):
        self.Id = Id

    def hasContent_(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="dsig11:",
        name_="KeyInfoReferenceType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:dsig11="http://www.w3.org/2009/xmldsig11#"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("KeyInfoReferenceType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="KeyInfoReferenceType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="dsig11:",
                name_="KeyInfoReferenceType",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="dsig11:",
        name_="KeyInfoReferenceType",
    ):
        if self.URI is not None and "URI" not in already_processed:
            already_processed.add("URI")
            outfile.write(" URI=%s" % (quote_attrib(self.URI),))
        if self.Id is not None and "Id" not in already_processed:
            already_processed.add("Id")
            outfile.write(" Id=%s" % (quote_attrib(self.Id),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="dsig11:",
        name_="KeyInfoReferenceType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("URI", node)
        if value is not None and "URI" not in already_processed:
            already_processed.add("URI")
            self.URI = value
        value = find_attr_value_("Id", node)
        if value is not None and "Id" not in already_processed:
            already_processed.add("Id")
            self.Id = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class KeyInfoReferenceType


class X509DigestType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, Algorithm=None, valueOf_=None):
        self.original_tagname_ = None
        self.Algorithm = _cast(None, Algorithm)
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, X509DigestType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if X509DigestType.subclass:
            return X509DigestType.subclass(*args_, **kwargs_)
        else:
            return X509DigestType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Algorithm(self):
        return self.Algorithm

    def set_Algorithm(self, Algorithm):
        self.Algorithm = Algorithm

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if 1 if type(self.valueOf_) in [int, float] else self.valueOf_:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="dsig11:",
        name_="X509DigestType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:dsig11="http://www.w3.org/2009/xmldsig11#"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("X509DigestType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="X509DigestType"
        )
        if self.hasContent_():
            outfile.write(">")
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="dsig11:",
                name_="X509DigestType",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="dsig11:",
        name_="X509DigestType",
    ):
        if self.Algorithm is not None and "Algorithm" not in already_processed:
            already_processed.add("Algorithm")
            outfile.write(" Algorithm=%s" % (quote_attrib(self.Algorithm),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="dsig11:",
        name_="X509DigestType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("Algorithm", node)
        if value is not None and "Algorithm" not in already_processed:
            already_processed.add("Algorithm")
            self.Algorithm = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class X509DigestType


class SignatureType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self, Id=None, SignedInfo=None, SignatureValue=None, KeyInfo=None, Object=None
    ):
        self.original_tagname_ = None
        self.Id = _cast(None, Id)
        self.SignedInfo = SignedInfo
        self.SignatureValue = SignatureValue
        self.KeyInfo = KeyInfo
        if Object is None:
            self.Object = []
        else:
            self.Object = Object

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, SignatureType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SignatureType.subclass:
            return SignatureType.subclass(*args_, **kwargs_)
        else:
            return SignatureType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_SignedInfo(self):
        return self.SignedInfo

    def set_SignedInfo(self, SignedInfo):
        self.SignedInfo = SignedInfo

    def get_SignatureValue(self):
        return self.SignatureValue

    def set_SignatureValue(self, SignatureValue):
        self.SignatureValue = SignatureValue

    def get_KeyInfo(self):
        return self.KeyInfo

    def set_KeyInfo(self, KeyInfo):
        self.KeyInfo = KeyInfo

    def get_Object(self):
        return self.Object

    def set_Object(self, Object):
        self.Object = Object

    def add_Object(self, value):
        self.Object.append(value)

    def insert_Object_at(self, index, value):
        self.Object.insert(index, value)

    def replace_Object_at(self, index, value):
        self.Object[index] = value

    def get_Id(self):
        return self.Id

    def set_Id(self, Id):
        self.Id = Id

    def hasContent_(self):
        if (
            self.SignedInfo is not None
            or self.SignatureValue is not None
            or self.KeyInfo is not None
            or self.Object
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="SignatureType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SignatureType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="SignatureType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ds:",
                name_="SignatureType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="ds:", name_="SignatureType"
    ):
        if self.Id is not None and "Id" not in already_processed:
            already_processed.add("Id")
            outfile.write(" Id=%s" % (quote_attrib(self.Id),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="SignatureType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.SignedInfo is not None:
            self.SignedInfo.export(
                outfile,
                level,
                namespace_="ds:",
                name_="SignedInfo",
                pretty_print=pretty_print,
            )
        if self.SignatureValue is not None:
            self.SignatureValue.export(
                outfile,
                level,
                namespace_="ds:",
                name_="SignatureValue",
                pretty_print=pretty_print,
            )
        if self.KeyInfo is not None:
            self.KeyInfo.export(
                outfile,
                level,
                namespace_="ds:",
                name_="KeyInfo",
                pretty_print=pretty_print,
            )
        for Object_ in self.Object:
            Object_.export(
                outfile,
                level,
                namespace_="ds:",
                name_="Object",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("Id", node)
        if value is not None and "Id" not in already_processed:
            already_processed.add("Id")
            self.Id = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "SignedInfo":
            obj_ = SignedInfoType.factory()
            obj_.build(child_)
            self.SignedInfo = obj_
            obj_.original_tagname_ = "SignedInfo"
        elif nodeName_ == "SignatureValue":
            obj_ = SignatureValueType.factory()
            obj_.build(child_)
            self.SignatureValue = obj_
            obj_.original_tagname_ = "SignatureValue"
        elif nodeName_ == "KeyInfo":
            obj_ = KeyInfoType.factory()
            obj_.build(child_)
            self.KeyInfo = obj_
            obj_.original_tagname_ = "KeyInfo"
        elif nodeName_ == "Object":
            obj_ = ObjectType.factory()
            obj_.build(child_)
            self.Object.append(obj_)
            obj_.original_tagname_ = "Object"


# end class SignatureType


class SignatureValueType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, Id=None, valueOf_=None):
        self.original_tagname_ = None
        self.Id = _cast(None, Id)
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SignatureValueType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SignatureValueType.subclass:
            return SignatureValueType.subclass(*args_, **kwargs_)
        else:
            return SignatureValueType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Id(self):
        return self.Id

    def set_Id(self, Id):
        self.Id = Id

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if 1 if type(self.valueOf_) in [int, float] else self.valueOf_:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="SignatureValueType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ds="http://www.w3.org/2000/09/xmldsig#"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SignatureValueType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="SignatureValueType"
        )
        if self.hasContent_():
            outfile.write(">")
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ds:",
                name_="SignatureValueType",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="ds:",
        name_="SignatureValueType",
    ):
        if self.Id is not None and "Id" not in already_processed:
            already_processed.add("Id")
            outfile.write(" Id=%s" % (quote_attrib(self.Id),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="SignatureValueType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("Id", node)
        if value is not None and "Id" not in already_processed:
            already_processed.add("Id")
            self.Id = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass


# end class SignatureValueType


class SignedInfoType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self, Id=None, CanonicalizationMethod=None, SignatureMethod=None, Reference=None
    ):
        self.original_tagname_ = None
        self.Id = _cast(None, Id)
        self.CanonicalizationMethod = CanonicalizationMethod
        self.SignatureMethod = SignatureMethod
        if Reference is None:
            self.Reference = []
        else:
            self.Reference = Reference

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, SignedInfoType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SignedInfoType.subclass:
            return SignedInfoType.subclass(*args_, **kwargs_)
        else:
            return SignedInfoType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_CanonicalizationMethod(self):
        return self.CanonicalizationMethod

    def set_CanonicalizationMethod(self, CanonicalizationMethod):
        self.CanonicalizationMethod = CanonicalizationMethod

    def get_SignatureMethod(self):
        return self.SignatureMethod

    def set_SignatureMethod(self, SignatureMethod):
        self.SignatureMethod = SignatureMethod

    def get_Reference(self):
        return self.Reference

    def set_Reference(self, Reference):
        self.Reference = Reference

    def add_Reference(self, value):
        self.Reference.append(value)

    def insert_Reference_at(self, index, value):
        self.Reference.insert(index, value)

    def replace_Reference_at(self, index, value):
        self.Reference[index] = value

    def get_Id(self):
        return self.Id

    def set_Id(self, Id):
        self.Id = Id

    def hasContent_(self):
        if (
            self.CanonicalizationMethod is not None
            or self.SignatureMethod is not None
            or self.Reference
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="SignedInfoType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SignedInfoType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="SignedInfoType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ds:",
                name_="SignedInfoType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="ds:",
        name_="SignedInfoType",
    ):
        if self.Id is not None and "Id" not in already_processed:
            already_processed.add("Id")
            outfile.write(" Id=%s" % (quote_attrib(self.Id),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="SignedInfoType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.CanonicalizationMethod is not None:
            self.CanonicalizationMethod.export(
                outfile,
                level,
                namespace_="ds:",
                name_="CanonicalizationMethod",
                pretty_print=pretty_print,
            )
        if self.SignatureMethod is not None:
            self.SignatureMethod.export(
                outfile,
                level,
                namespace_="ds:",
                name_="SignatureMethod",
                pretty_print=pretty_print,
            )
        for Reference_ in self.Reference:
            Reference_.export(
                outfile,
                level,
                namespace_="ds:",
                name_="Reference",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("Id", node)
        if value is not None and "Id" not in already_processed:
            already_processed.add("Id")
            self.Id = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "CanonicalizationMethod":
            obj_ = CanonicalizationMethodType.factory()
            obj_.build(child_)
            self.CanonicalizationMethod = obj_
            obj_.original_tagname_ = "CanonicalizationMethod"
        elif nodeName_ == "SignatureMethod":
            obj_ = SignatureMethodType.factory()
            obj_.build(child_)
            self.SignatureMethod = obj_
            obj_.original_tagname_ = "SignatureMethod"
        elif nodeName_ == "Reference":
            obj_ = ReferenceType.factory()
            obj_.build(child_)
            self.Reference.append(obj_)
            obj_.original_tagname_ = "Reference"


# end class SignedInfoType


class CanonicalizationMethodType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self,
        Algorithm=None,
        anytypeobjs_=None,
        valueOf_=None,
        mixedclass_=None,
        content_=None,
    ):
        self.original_tagname_ = None
        self.Algorithm = _cast(None, Algorithm)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CanonicalizationMethodType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CanonicalizationMethodType.subclass:
            return CanonicalizationMethodType.subclass(*args_, **kwargs_)
        else:
            return CanonicalizationMethodType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_anytypeobjs_(self):
        return self.anytypeobjs_

    def set_anytypeobjs_(self, anytypeobjs_):
        self.anytypeobjs_ = anytypeobjs_

    def add_anytypeobjs_(self, value):
        self.anytypeobjs_.append(value)

    def insert_anytypeobjs_(self, index, value):
        self._anytypeobjs_[index] = value

    def get_Algorithm(self):
        return self.Algorithm

    def set_Algorithm(self, Algorithm):
        self.Algorithm = Algorithm

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if self.anytypeobjs_ or (
            1 if type(self.valueOf_) in [int, float] else self.valueOf_
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="CanonicalizationMethodType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ds="http://www.w3.org/2000/09/xmldsig#"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("CanonicalizationMethodType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespace_,
            name_="CanonicalizationMethodType",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ds:",
                name_="CanonicalizationMethodType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="ds:",
        name_="CanonicalizationMethodType",
    ):
        if self.Algorithm is not None and "Algorithm" not in already_processed:
            already_processed.add("Algorithm")
            outfile.write(" Algorithm=%s" % (quote_attrib(self.Algorithm),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="CanonicalizationMethodType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(
                    outfile, level, item_.name, namespace_, pretty_print=pretty_print
                )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(
                MixedContainer.CategoryText, MixedContainer.TypeNone, "", node.text
            )
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("Algorithm", node)
        if value is not None and "Algorithm" not in already_processed:
            already_processed.add("Algorithm")
            self.Algorithm = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "":
            obj_ = __ANY__.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(
                MixedContainer.CategoryComplex, MixedContainer.TypeNone, "", obj_
            )
            self.content_.append(obj_)
            if hasattr(self, "add_"):
                self.add_(obj_.value)
            elif hasattr(self, "set_"):
                self.set_(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(
                MixedContainer.CategoryText, MixedContainer.TypeNone, "", child_.tail
            )
            self.content_.append(obj_)


# end class CanonicalizationMethodType


class SignatureMethodType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self,
        Algorithm=None,
        HMACOutputLength=None,
        anytypeobjs_=None,
        valueOf_=None,
        mixedclass_=None,
        content_=None,
    ):
        self.original_tagname_ = None
        self.Algorithm = _cast(None, Algorithm)
        self.HMACOutputLength = HMACOutputLength
        self.validate_HMACOutputLengthType(self.HMACOutputLength)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SignatureMethodType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SignatureMethodType.subclass:
            return SignatureMethodType.subclass(*args_, **kwargs_)
        else:
            return SignatureMethodType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_HMACOutputLength(self):
        return self.HMACOutputLength

    def set_HMACOutputLength(self, HMACOutputLength):
        self.HMACOutputLength = HMACOutputLength

    def get_anytypeobjs_(self):
        return self.anytypeobjs_

    def set_anytypeobjs_(self, anytypeobjs_):
        self.anytypeobjs_ = anytypeobjs_

    def add_anytypeobjs_(self, value):
        self.anytypeobjs_.append(value)

    def insert_anytypeobjs_(self, index, value):
        self._anytypeobjs_[index] = value

    def get_Algorithm(self):
        return self.Algorithm

    def set_Algorithm(self, Algorithm):
        self.Algorithm = Algorithm

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def validate_HMACOutputLengthType(self, value):
        # Validate type HMACOutputLengthType, a restriction on integer.
        if value is not None and Validate_simpletypes_:
            pass

    def hasContent_(self):
        if (
            self.HMACOutputLength is not None
            or self.anytypeobjs_
            or (1 if type(self.valueOf_) in [int, float] else self.valueOf_)
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="SignatureMethodType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SignatureMethodType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="SignatureMethodType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ds:",
                name_="SignatureMethodType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="ds:",
        name_="SignatureMethodType",
    ):
        if self.Algorithm is not None and "Algorithm" not in already_processed:
            already_processed.add("Algorithm")
            outfile.write(" Algorithm=%s" % (quote_attrib(self.Algorithm),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="SignatureMethodType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(
                    outfile, level, item_.name, namespace_, pretty_print=pretty_print
                )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.HMACOutputLength is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ds:HMACOutputLength>%s</ds:HMACOutputLength>%s"
                % (
                    self.gds_format_integer(
                        self.HMACOutputLength, input_name="HMACOutputLength"
                    ),
                    eol_,
                )
            )
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(
                MixedContainer.CategoryText, MixedContainer.TypeNone, "", node.text
            )
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("Algorithm", node)
        if value is not None and "Algorithm" not in already_processed:
            already_processed.add("Algorithm")
            self.Algorithm = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "HMACOutputLength" and child_.text is not None:
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, "requires integer: %s" % exp)
            obj_ = self.mixedclass_(
                MixedContainer.CategorySimple,
                MixedContainer.TypeInteger,
                "HMACOutputLength",
                ival_,
            )
            self.content_.append(obj_)
        elif nodeName_ == "":
            obj_ = __ANY__.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(
                MixedContainer.CategoryComplex, MixedContainer.TypeNone, "", obj_
            )
            self.content_.append(obj_)
            if hasattr(self, "add_"):
                self.add_(obj_.value)
            elif hasattr(self, "set_"):
                self.set_(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(
                MixedContainer.CategoryText, MixedContainer.TypeNone, "", child_.tail
            )
            self.content_.append(obj_)


# end class SignatureMethodType


class ReferenceType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self,
        Id=None,
        URI=None,
        Type=None,
        Transforms=None,
        DigestMethod=None,
        DigestValue=None,
    ):
        self.original_tagname_ = None
        self.Id = _cast(None, Id)
        self.URI = _cast(None, URI)
        self.Type = _cast(None, Type)
        self.Transforms = Transforms
        self.DigestMethod = DigestMethod
        self.DigestValue = DigestValue

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ReferenceType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ReferenceType.subclass:
            return ReferenceType.subclass(*args_, **kwargs_)
        else:
            return ReferenceType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Transforms(self):
        return self.Transforms

    def set_Transforms(self, Transforms):
        self.Transforms = Transforms

    def get_DigestMethod(self):
        return self.DigestMethod

    def set_DigestMethod(self, DigestMethod):
        self.DigestMethod = DigestMethod

    def get_DigestValue(self):
        return self.DigestValue

    def set_DigestValue(self, DigestValue):
        self.DigestValue = DigestValue

    def get_Id(self):
        return self.Id

    def set_Id(self, Id):
        self.Id = Id

    def get_URI(self):
        return self.URI

    def set_URI(self, URI):
        self.URI = URI

    def get_Type(self):
        return self.Type

    def set_Type(self, Type):
        self.Type = Type

    def hasContent_(self):
        if (
            self.Transforms is not None
            or self.DigestMethod is not None
            or self.DigestValue is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="ReferenceType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ReferenceType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="ReferenceType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ds:",
                name_="ReferenceType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="ds:", name_="ReferenceType"
    ):
        if self.Id is not None and "Id" not in already_processed:
            already_processed.add("Id")
            outfile.write(" Id=%s" % (quote_attrib(self.Id),))
        if self.URI is not None and "URI" not in already_processed:
            already_processed.add("URI")
            outfile.write(" URI=%s" % (quote_attrib(self.URI),))
        if self.Type is not None and "Type" not in already_processed:
            already_processed.add("Type")
            outfile.write(" Type=%s" % (quote_attrib(self.Type),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="ReferenceType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.Transforms is not None:
            self.Transforms.export(
                outfile,
                level,
                namespace_="ds:",
                name_="Transforms",
                pretty_print=pretty_print,
            )
        if self.DigestMethod is not None:
            self.DigestMethod.export(
                outfile,
                level,
                namespace_="ds:",
                name_="DigestMethod",
                pretty_print=pretty_print,
            )
        if self.DigestValue is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ds:DigestValue>%s</ds:DigestValue>%s"
                % (
                    self.gds_format_base64(self.DigestValue, input_name="DigestValue"),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("Id", node)
        if value is not None and "Id" not in already_processed:
            already_processed.add("Id")
            self.Id = value
        value = find_attr_value_("URI", node)
        if value is not None and "URI" not in already_processed:
            already_processed.add("URI")
            self.URI = value
        value = find_attr_value_("Type", node)
        if value is not None and "Type" not in already_processed:
            already_processed.add("Type")
            self.Type = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "Transforms":
            obj_ = TransformsType.factory()
            obj_.build(child_)
            self.Transforms = obj_
            obj_.original_tagname_ = "Transforms"
        elif nodeName_ == "DigestMethod":
            obj_ = DigestMethodType.factory()
            obj_.build(child_)
            self.DigestMethod = obj_
            obj_.original_tagname_ = "DigestMethod"
        elif nodeName_ == "DigestValue":
            sval_ = child_.text
            if sval_ is not None:
                try:
                    bval_ = base64.b64decode(sval_)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(
                        child_, "requires base64 encoded string: %s" % exp
                    )
                bval_ = self.gds_validate_base64(bval_, node, "DigestValue")
            else:
                bval_ = None
            self.DigestValue = bval_


# end class ReferenceType


class TransformsType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, Transform=None):
        self.original_tagname_ = None
        if Transform is None:
            self.Transform = []
        else:
            self.Transform = Transform

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, TransformsType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TransformsType.subclass:
            return TransformsType.subclass(*args_, **kwargs_)
        else:
            return TransformsType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Transform(self):
        return self.Transform

    def set_Transform(self, Transform):
        self.Transform = Transform

    def add_Transform(self, value):
        self.Transform.append(value)

    def insert_Transform_at(self, index, value):
        self.Transform.insert(index, value)

    def replace_Transform_at(self, index, value):
        self.Transform[index] = value

    def hasContent_(self):
        if self.Transform:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="TransformsType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("TransformsType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="TransformsType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ds:",
                name_="TransformsType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="ds:",
        name_="TransformsType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="TransformsType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for Transform_ in self.Transform:
            Transform_.export(
                outfile,
                level,
                namespace_="ds:",
                name_="Transform",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "Transform":
            obj_ = TransformType.factory()
            obj_.build(child_)
            self.Transform.append(obj_)
            obj_.original_tagname_ = "Transform"


# end class TransformsType


class TransformType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self,
        Algorithm=None,
        anytypeobjs_=None,
        XPath=None,
        valueOf_=None,
        mixedclass_=None,
        content_=None,
    ):
        self.original_tagname_ = None
        self.Algorithm = _cast(None, Algorithm)
        self.anytypeobjs_ = anytypeobjs_
        if XPath is None:
            self.XPath = []
        else:
            self.XPath = XPath
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, TransformType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TransformType.subclass:
            return TransformType.subclass(*args_, **kwargs_)
        else:
            return TransformType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_anytypeobjs_(self):
        return self.anytypeobjs_

    def set_anytypeobjs_(self, anytypeobjs_):
        self.anytypeobjs_ = anytypeobjs_

    def get_XPath(self):
        return self.XPath

    def set_XPath(self, XPath):
        self.XPath = XPath

    def add_XPath(self, value):
        self.XPath.append(value)

    def insert_XPath_at(self, index, value):
        self.XPath.insert(index, value)

    def replace_XPath_at(self, index, value):
        self.XPath[index] = value

    def get_Algorithm(self):
        return self.Algorithm

    def set_Algorithm(self, Algorithm):
        self.Algorithm = Algorithm

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if (
            self.anytypeobjs_ is not None
            or self.XPath
            or (1 if type(self.valueOf_) in [int, float] else self.valueOf_)
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="TransformType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ds="http://www.w3.org/2000/09/xmldsig#"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("TransformType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="TransformType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ds:",
                name_="TransformType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="ds:", name_="TransformType"
    ):
        if self.Algorithm is not None and "Algorithm" not in already_processed:
            already_processed.add("Algorithm")
            outfile.write(" Algorithm=%s" % (quote_attrib(self.Algorithm),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="TransformType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(
                    outfile, level, item_.name, namespace_, pretty_print=pretty_print
                )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for XPath_ in self.XPath:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ds:XPath>%s</ds:XPath>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_xml(XPath_), input_name="XPath")
                    ),
                    eol_,
                )
            )
        if self.anytypeobjs_ is not None:
            self.anytypeobjs_.export(
                outfile, level, namespace_, pretty_print=pretty_print
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(
                MixedContainer.CategoryText, MixedContainer.TypeNone, "", node.text
            )
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("Algorithm", node)
        if value is not None and "Algorithm" not in already_processed:
            already_processed.add("Algorithm")
            self.Algorithm = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "":
            obj_ = __ANY__.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(
                MixedContainer.CategoryComplex, MixedContainer.TypeNone, "", obj_
            )
            self.content_.append(obj_)
            if hasattr(self, "add_"):
                self.add_(obj_.value)
            elif hasattr(self, "set_"):
                self.set_(obj_.value)
        elif nodeName_ == "XPath" and child_.text is not None:
            valuestr_ = child_.text
            obj_ = self.mixedclass_(
                MixedContainer.CategorySimple,
                MixedContainer.TypeString,
                "XPath",
                valuestr_,
            )
            self.content_.append(obj_)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(
                MixedContainer.CategoryText, MixedContainer.TypeNone, "", child_.tail
            )
            self.content_.append(obj_)


# end class TransformType


class DigestMethodType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self,
        Algorithm=None,
        anytypeobjs_=None,
        valueOf_=None,
        mixedclass_=None,
        content_=None,
    ):
        self.original_tagname_ = None
        self.Algorithm = _cast(None, Algorithm)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, DigestMethodType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DigestMethodType.subclass:
            return DigestMethodType.subclass(*args_, **kwargs_)
        else:
            return DigestMethodType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_anytypeobjs_(self):
        return self.anytypeobjs_

    def set_anytypeobjs_(self, anytypeobjs_):
        self.anytypeobjs_ = anytypeobjs_

    def add_anytypeobjs_(self, value):
        self.anytypeobjs_.append(value)

    def insert_anytypeobjs_(self, index, value):
        self._anytypeobjs_[index] = value

    def get_Algorithm(self):
        return self.Algorithm

    def set_Algorithm(self, Algorithm):
        self.Algorithm = Algorithm

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if self.anytypeobjs_ or (
            1 if type(self.valueOf_) in [int, float] else self.valueOf_
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="DigestMethodType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ds="http://www.w3.org/2000/09/xmldsig#"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("DigestMethodType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="DigestMethodType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ds:",
                name_="DigestMethodType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="ds:",
        name_="DigestMethodType",
    ):
        if self.Algorithm is not None and "Algorithm" not in already_processed:
            already_processed.add("Algorithm")
            outfile.write(" Algorithm=%s" % (quote_attrib(self.Algorithm),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="DigestMethodType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(
                    outfile, level, item_.name, namespace_, pretty_print=pretty_print
                )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(
                MixedContainer.CategoryText, MixedContainer.TypeNone, "", node.text
            )
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("Algorithm", node)
        if value is not None and "Algorithm" not in already_processed:
            already_processed.add("Algorithm")
            self.Algorithm = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "":
            obj_ = __ANY__.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(
                MixedContainer.CategoryComplex, MixedContainer.TypeNone, "", obj_
            )
            self.content_.append(obj_)
            if hasattr(self, "add_"):
                self.add_(obj_.value)
            elif hasattr(self, "set_"):
                self.set_(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(
                MixedContainer.CategoryText, MixedContainer.TypeNone, "", child_.tail
            )
            self.content_.append(obj_)


# end class DigestMethodType


class KeyInfoType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self,
        Id=None,
        KeyName=None,
        KeyValue=None,
        RetrievalMethod=None,
        X509Data=None,
        PGPData=None,
        SPKIData=None,
        MgmtData=None,
        anytypeobjs_=None,
        valueOf_=None,
        mixedclass_=None,
        content_=None,
    ):
        self.original_tagname_ = None
        self.Id = _cast(None, Id)
        if KeyName is None:
            self.KeyName = []
        else:
            self.KeyName = KeyName
        if KeyValue is None:
            self.KeyValue = []
        else:
            self.KeyValue = KeyValue
        if RetrievalMethod is None:
            self.RetrievalMethod = []
        else:
            self.RetrievalMethod = RetrievalMethod
        if X509Data is None:
            self.X509Data = []
        else:
            self.X509Data = X509Data
        if PGPData is None:
            self.PGPData = []
        else:
            self.PGPData = PGPData
        if SPKIData is None:
            self.SPKIData = []
        else:
            self.SPKIData = SPKIData
        if MgmtData is None:
            self.MgmtData = []
        else:
            self.MgmtData = MgmtData
        self.anytypeobjs_ = anytypeobjs_
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, KeyInfoType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if KeyInfoType.subclass:
            return KeyInfoType.subclass(*args_, **kwargs_)
        else:
            return KeyInfoType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_KeyName(self):
        return self.KeyName

    def set_KeyName(self, KeyName):
        self.KeyName = KeyName

    def add_KeyName(self, value):
        self.KeyName.append(value)

    def insert_KeyName_at(self, index, value):
        self.KeyName.insert(index, value)

    def replace_KeyName_at(self, index, value):
        self.KeyName[index] = value

    def get_KeyValue(self):
        return self.KeyValue

    def set_KeyValue(self, KeyValue):
        self.KeyValue = KeyValue

    def add_KeyValue(self, value):
        self.KeyValue.append(value)

    def insert_KeyValue_at(self, index, value):
        self.KeyValue.insert(index, value)

    def replace_KeyValue_at(self, index, value):
        self.KeyValue[index] = value

    def get_RetrievalMethod(self):
        return self.RetrievalMethod

    def set_RetrievalMethod(self, RetrievalMethod):
        self.RetrievalMethod = RetrievalMethod

    def add_RetrievalMethod(self, value):
        self.RetrievalMethod.append(value)

    def insert_RetrievalMethod_at(self, index, value):
        self.RetrievalMethod.insert(index, value)

    def replace_RetrievalMethod_at(self, index, value):
        self.RetrievalMethod[index] = value

    def get_X509Data(self):
        return self.X509Data

    def set_X509Data(self, X509Data):
        self.X509Data = X509Data

    def add_X509Data(self, value):
        self.X509Data.append(value)

    def insert_X509Data_at(self, index, value):
        self.X509Data.insert(index, value)

    def replace_X509Data_at(self, index, value):
        self.X509Data[index] = value

    def get_PGPData(self):
        return self.PGPData

    def set_PGPData(self, PGPData):
        self.PGPData = PGPData

    def add_PGPData(self, value):
        self.PGPData.append(value)

    def insert_PGPData_at(self, index, value):
        self.PGPData.insert(index, value)

    def replace_PGPData_at(self, index, value):
        self.PGPData[index] = value

    def get_SPKIData(self):
        return self.SPKIData

    def set_SPKIData(self, SPKIData):
        self.SPKIData = SPKIData

    def add_SPKIData(self, value):
        self.SPKIData.append(value)

    def insert_SPKIData_at(self, index, value):
        self.SPKIData.insert(index, value)

    def replace_SPKIData_at(self, index, value):
        self.SPKIData[index] = value

    def get_MgmtData(self):
        return self.MgmtData

    def set_MgmtData(self, MgmtData):
        self.MgmtData = MgmtData

    def add_MgmtData(self, value):
        self.MgmtData.append(value)

    def insert_MgmtData_at(self, index, value):
        self.MgmtData.insert(index, value)

    def replace_MgmtData_at(self, index, value):
        self.MgmtData[index] = value

    def get_anytypeobjs_(self):
        return self.anytypeobjs_

    def set_anytypeobjs_(self, anytypeobjs_):
        self.anytypeobjs_ = anytypeobjs_

    def get_Id(self):
        return self.Id

    def set_Id(self, Id):
        self.Id = Id

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if (
            self.KeyName
            or self.KeyValue
            or self.RetrievalMethod
            or self.X509Data
            or self.PGPData
            or self.SPKIData
            or self.MgmtData
            or self.anytypeobjs_ is not None
            or (1 if type(self.valueOf_) in [int, float] else self.valueOf_)
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="KeyInfoType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("KeyInfoType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="KeyInfoType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ds:",
                name_="KeyInfoType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="ds:", name_="KeyInfoType"
    ):
        if self.Id is not None and "Id" not in already_processed:
            already_processed.add("Id")
            outfile.write(" Id=%s" % (quote_attrib(self.Id),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="KeyInfoType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(
                    outfile, level, item_.name, namespace_, pretty_print=pretty_print
                )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for KeyName_ in self.KeyName:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ds:KeyName>%s</ds:KeyName>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(KeyName_), input_name="KeyName"
                        )
                    ),
                    eol_,
                )
            )
        for KeyValue_ in self.KeyValue:
            KeyValue_.export(
                outfile,
                level,
                namespace_="ds:",
                name_="KeyValue",
                pretty_print=pretty_print,
            )
        for RetrievalMethod_ in self.RetrievalMethod:
            RetrievalMethod_.export(
                outfile,
                level,
                namespace_="ds:",
                name_="RetrievalMethod",
                pretty_print=pretty_print,
            )
        for X509Data_ in self.X509Data:
            X509Data_.export(
                outfile,
                level,
                namespace_="ds:",
                name_="X509Data",
                pretty_print=pretty_print,
            )
        for PGPData_ in self.PGPData:
            PGPData_.export(
                outfile,
                level,
                namespace_="ds:",
                name_="PGPData",
                pretty_print=pretty_print,
            )
        for SPKIData_ in self.SPKIData:
            SPKIData_.export(
                outfile,
                level,
                namespace_="ds:",
                name_="SPKIData",
                pretty_print=pretty_print,
            )
        for MgmtData_ in self.MgmtData:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ds:MgmtData>%s</ds:MgmtData>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(MgmtData_), input_name="MgmtData"
                        )
                    ),
                    eol_,
                )
            )
        if self.anytypeobjs_ is not None:
            self.anytypeobjs_.export(
                outfile, level, namespace_, pretty_print=pretty_print
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(
                MixedContainer.CategoryText, MixedContainer.TypeNone, "", node.text
            )
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("Id", node)
        if value is not None and "Id" not in already_processed:
            already_processed.add("Id")
            self.Id = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "KeyName" and child_.text is not None:
            valuestr_ = child_.text
            obj_ = self.mixedclass_(
                MixedContainer.CategorySimple,
                MixedContainer.TypeString,
                "KeyName",
                valuestr_,
            )
            self.content_.append(obj_)
        elif nodeName_ == "KeyValue":
            obj_ = KeyValueType.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(
                MixedContainer.CategoryComplex,
                MixedContainer.TypeNone,
                "KeyValue",
                obj_,
            )
            self.content_.append(obj_)
            if hasattr(self, "add_KeyValue"):
                self.add_KeyValue(obj_.value)
            elif hasattr(self, "set_KeyValue"):
                self.set_KeyValue(obj_.value)
        elif nodeName_ == "RetrievalMethod":
            obj_ = RetrievalMethodType.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(
                MixedContainer.CategoryComplex,
                MixedContainer.TypeNone,
                "RetrievalMethod",
                obj_,
            )
            self.content_.append(obj_)
            if hasattr(self, "add_RetrievalMethod"):
                self.add_RetrievalMethod(obj_.value)
            elif hasattr(self, "set_RetrievalMethod"):
                self.set_RetrievalMethod(obj_.value)
        elif nodeName_ == "X509Data":
            obj_ = X509DataType.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(
                MixedContainer.CategoryComplex,
                MixedContainer.TypeNone,
                "X509Data",
                obj_,
            )
            self.content_.append(obj_)
            if hasattr(self, "add_X509Data"):
                self.add_X509Data(obj_.value)
            elif hasattr(self, "set_X509Data"):
                self.set_X509Data(obj_.value)
        elif nodeName_ == "PGPData":
            obj_ = PGPDataType.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(
                MixedContainer.CategoryComplex, MixedContainer.TypeNone, "PGPData", obj_
            )
            self.content_.append(obj_)
            if hasattr(self, "add_PGPData"):
                self.add_PGPData(obj_.value)
            elif hasattr(self, "set_PGPData"):
                self.set_PGPData(obj_.value)
        elif nodeName_ == "SPKIData":
            obj_ = SPKIDataType.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(
                MixedContainer.CategoryComplex,
                MixedContainer.TypeNone,
                "SPKIData",
                obj_,
            )
            self.content_.append(obj_)
            if hasattr(self, "add_SPKIData"):
                self.add_SPKIData(obj_.value)
            elif hasattr(self, "set_SPKIData"):
                self.set_SPKIData(obj_.value)
        elif nodeName_ == "MgmtData" and child_.text is not None:
            valuestr_ = child_.text
            obj_ = self.mixedclass_(
                MixedContainer.CategorySimple,
                MixedContainer.TypeString,
                "MgmtData",
                valuestr_,
            )
            self.content_.append(obj_)
        elif nodeName_ == "":
            obj_ = __ANY__.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(
                MixedContainer.CategoryComplex, MixedContainer.TypeNone, "", obj_
            )
            self.content_.append(obj_)
            if hasattr(self, "add_"):
                self.add_(obj_.value)
            elif hasattr(self, "set_"):
                self.set_(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(
                MixedContainer.CategoryText, MixedContainer.TypeNone, "", child_.tail
            )
            self.content_.append(obj_)


# end class KeyInfoType


class KeyValueType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self,
        DSAKeyValue=None,
        RSAKeyValue=None,
        anytypeobjs_=None,
        valueOf_=None,
        mixedclass_=None,
        content_=None,
    ):
        self.original_tagname_ = None
        self.DSAKeyValue = DSAKeyValue
        self.RSAKeyValue = RSAKeyValue
        self.anytypeobjs_ = anytypeobjs_
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, KeyValueType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if KeyValueType.subclass:
            return KeyValueType.subclass(*args_, **kwargs_)
        else:
            return KeyValueType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_DSAKeyValue(self):
        return self.DSAKeyValue

    def set_DSAKeyValue(self, DSAKeyValue):
        self.DSAKeyValue = DSAKeyValue

    def get_RSAKeyValue(self):
        return self.RSAKeyValue

    def set_RSAKeyValue(self, RSAKeyValue):
        self.RSAKeyValue = RSAKeyValue

    def get_anytypeobjs_(self):
        return self.anytypeobjs_

    def set_anytypeobjs_(self, anytypeobjs_):
        self.anytypeobjs_ = anytypeobjs_

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if (
            self.DSAKeyValue is not None
            or self.RSAKeyValue is not None
            or self.anytypeobjs_ is not None
            or (1 if type(self.valueOf_) in [int, float] else self.valueOf_)
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="KeyValueType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("KeyValueType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="KeyValueType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ds:",
                name_="KeyValueType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="ds:", name_="KeyValueType"
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="KeyValueType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(
                    outfile, level, item_.name, namespace_, pretty_print=pretty_print
                )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.DSAKeyValue is not None:
            self.DSAKeyValue.export(
                outfile,
                level,
                namespace_="ds:",
                name_="DSAKeyValue",
                pretty_print=pretty_print,
            )
        if self.RSAKeyValue is not None:
            self.RSAKeyValue.export(
                outfile,
                level,
                namespace_="ds:",
                name_="RSAKeyValue",
                pretty_print=pretty_print,
            )
        if self.anytypeobjs_ is not None:
            self.anytypeobjs_.export(
                outfile, level, namespace_, pretty_print=pretty_print
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(
                MixedContainer.CategoryText, MixedContainer.TypeNone, "", node.text
            )
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "DSAKeyValue":
            obj_ = DSAKeyValueType.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(
                MixedContainer.CategoryComplex,
                MixedContainer.TypeNone,
                "DSAKeyValue",
                obj_,
            )
            self.content_.append(obj_)
            if hasattr(self, "add_DSAKeyValue"):
                self.add_DSAKeyValue(obj_.value)
            elif hasattr(self, "set_DSAKeyValue"):
                self.set_DSAKeyValue(obj_.value)
        elif nodeName_ == "RSAKeyValue":
            obj_ = RSAKeyValueType.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(
                MixedContainer.CategoryComplex,
                MixedContainer.TypeNone,
                "RSAKeyValue",
                obj_,
            )
            self.content_.append(obj_)
            if hasattr(self, "add_RSAKeyValue"):
                self.add_RSAKeyValue(obj_.value)
            elif hasattr(self, "set_RSAKeyValue"):
                self.set_RSAKeyValue(obj_.value)
        elif nodeName_ == "":
            obj_ = __ANY__.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(
                MixedContainer.CategoryComplex, MixedContainer.TypeNone, "", obj_
            )
            self.content_.append(obj_)
            if hasattr(self, "add_"):
                self.add_(obj_.value)
            elif hasattr(self, "set_"):
                self.set_(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(
                MixedContainer.CategoryText, MixedContainer.TypeNone, "", child_.tail
            )
            self.content_.append(obj_)


# end class KeyValueType


class RetrievalMethodType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, URI=None, Type=None, Transforms=None):
        self.original_tagname_ = None
        self.URI = _cast(None, URI)
        self.Type = _cast(None, Type)
        self.Transforms = Transforms

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, RetrievalMethodType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if RetrievalMethodType.subclass:
            return RetrievalMethodType.subclass(*args_, **kwargs_)
        else:
            return RetrievalMethodType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Transforms(self):
        return self.Transforms

    def set_Transforms(self, Transforms):
        self.Transforms = Transforms

    def get_URI(self):
        return self.URI

    def set_URI(self, URI):
        self.URI = URI

    def get_Type(self):
        return self.Type

    def set_Type(self, Type):
        self.Type = Type

    def hasContent_(self):
        if self.Transforms is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="RetrievalMethodType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("RetrievalMethodType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="RetrievalMethodType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ds:",
                name_="RetrievalMethodType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="ds:",
        name_="RetrievalMethodType",
    ):
        if self.URI is not None and "URI" not in already_processed:
            already_processed.add("URI")
            outfile.write(" URI=%s" % (quote_attrib(self.URI),))
        if self.Type is not None and "Type" not in already_processed:
            already_processed.add("Type")
            outfile.write(" Type=%s" % (quote_attrib(self.Type),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="RetrievalMethodType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.Transforms is not None:
            self.Transforms.export(
                outfile,
                level,
                namespace_="ds:",
                name_="Transforms",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("URI", node)
        if value is not None and "URI" not in already_processed:
            already_processed.add("URI")
            self.URI = value
        value = find_attr_value_("Type", node)
        if value is not None and "Type" not in already_processed:
            already_processed.add("Type")
            self.Type = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "Transforms":
            obj_ = TransformsType.factory()
            obj_.build(child_)
            self.Transforms = obj_
            obj_.original_tagname_ = "Transforms"


# end class RetrievalMethodType


class X509DataType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self,
        X509IssuerSerial=None,
        X509SKI=None,
        X509SubjectName=None,
        X509Certificate=None,
        X509CRL=None,
        anytypeobjs_=None,
    ):
        self.original_tagname_ = None
        if X509IssuerSerial is None:
            self.X509IssuerSerial = []
        else:
            self.X509IssuerSerial = X509IssuerSerial
        if X509SKI is None:
            self.X509SKI = []
        else:
            self.X509SKI = X509SKI
        if X509SubjectName is None:
            self.X509SubjectName = []
        else:
            self.X509SubjectName = X509SubjectName
        if X509Certificate is None:
            self.X509Certificate = []
        else:
            self.X509Certificate = X509Certificate
        if X509CRL is None:
            self.X509CRL = []
        else:
            self.X509CRL = X509CRL
        self.anytypeobjs_ = anytypeobjs_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, X509DataType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if X509DataType.subclass:
            return X509DataType.subclass(*args_, **kwargs_)
        else:
            return X509DataType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_X509IssuerSerial(self):
        return self.X509IssuerSerial

    def set_X509IssuerSerial(self, X509IssuerSerial):
        self.X509IssuerSerial = X509IssuerSerial

    def add_X509IssuerSerial(self, value):
        self.X509IssuerSerial.append(value)

    def insert_X509IssuerSerial_at(self, index, value):
        self.X509IssuerSerial.insert(index, value)

    def replace_X509IssuerSerial_at(self, index, value):
        self.X509IssuerSerial[index] = value

    def get_X509SKI(self):
        return self.X509SKI

    def set_X509SKI(self, X509SKI):
        self.X509SKI = X509SKI

    def add_X509SKI(self, value):
        self.X509SKI.append(value)

    def insert_X509SKI_at(self, index, value):
        self.X509SKI.insert(index, value)

    def replace_X509SKI_at(self, index, value):
        self.X509SKI[index] = value

    def get_X509SubjectName(self):
        return self.X509SubjectName

    def set_X509SubjectName(self, X509SubjectName):
        self.X509SubjectName = X509SubjectName

    def add_X509SubjectName(self, value):
        self.X509SubjectName.append(value)

    def insert_X509SubjectName_at(self, index, value):
        self.X509SubjectName.insert(index, value)

    def replace_X509SubjectName_at(self, index, value):
        self.X509SubjectName[index] = value

    def get_X509Certificate(self):
        return self.X509Certificate

    def set_X509Certificate(self, X509Certificate):
        self.X509Certificate = X509Certificate

    def add_X509Certificate(self, value):
        self.X509Certificate.append(value)

    def insert_X509Certificate_at(self, index, value):
        self.X509Certificate.insert(index, value)

    def replace_X509Certificate_at(self, index, value):
        self.X509Certificate[index] = value

    def get_X509CRL(self):
        return self.X509CRL

    def set_X509CRL(self, X509CRL):
        self.X509CRL = X509CRL

    def add_X509CRL(self, value):
        self.X509CRL.append(value)

    def insert_X509CRL_at(self, index, value):
        self.X509CRL.insert(index, value)

    def replace_X509CRL_at(self, index, value):
        self.X509CRL[index] = value

    def get_anytypeobjs_(self):
        return self.anytypeobjs_

    def set_anytypeobjs_(self, anytypeobjs_):
        self.anytypeobjs_ = anytypeobjs_

    def hasContent_(self):
        if (
            self.X509IssuerSerial
            or self.X509SKI
            or self.X509SubjectName
            or self.X509Certificate
            or self.X509CRL
            or self.anytypeobjs_ is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="X509DataType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("X509DataType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="X509DataType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ds:",
                name_="X509DataType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="ds:", name_="X509DataType"
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="X509DataType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for X509IssuerSerial_ in self.X509IssuerSerial:
            X509IssuerSerial_.export(
                outfile,
                level,
                namespace_,
                name_="X509IssuerSerial",
                pretty_print=pretty_print,
            )
        for X509SKI_ in self.X509SKI:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ds:X509SKI>%s</ds:X509SKI>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(X509SKI_), input_name="X509SKI"
                        )
                    ),
                    eol_,
                )
            )
        for X509SubjectName_ in self.X509SubjectName:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ds:X509SubjectName>%s</ds:X509SubjectName>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(X509SubjectName_), input_name="X509SubjectName"
                        )
                    ),
                    eol_,
                )
            )
        for X509Certificate_ in self.X509Certificate:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ds:X509Certificate>%s</ds:X509Certificate>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(X509Certificate_), input_name="X509Certificate"
                        )
                    ),
                    eol_,
                )
            )
        for X509CRL_ in self.X509CRL:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ds:X509CRL>%s</ds:X509CRL>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(X509CRL_), input_name="X509CRL"
                        )
                    ),
                    eol_,
                )
            )
        if self.anytypeobjs_ is not None:
            self.anytypeobjs_.export(
                outfile, level, namespace_, pretty_print=pretty_print
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "X509IssuerSerial":
            obj_ = X509IssuerSerialType.factory()
            obj_.build(child_)
            self.X509IssuerSerial.append(obj_)
            obj_.original_tagname_ = "X509IssuerSerial"
        elif nodeName_ == "X509SKI":
            X509SKI_ = child_.text
            X509SKI_ = self.gds_validate_string(X509SKI_, node, "X509SKI")
            self.X509SKI.append(X509SKI_)
        elif nodeName_ == "X509SubjectName":
            X509SubjectName_ = child_.text
            X509SubjectName_ = self.gds_validate_string(
                X509SubjectName_, node, "X509SubjectName"
            )
            self.X509SubjectName.append(X509SubjectName_)
        elif nodeName_ == "X509Certificate":
            X509Certificate_ = child_.text
            X509Certificate_ = self.gds_validate_string(
                X509Certificate_, node, "X509Certificate"
            )
            self.X509Certificate.append(X509Certificate_)
        elif nodeName_ == "X509CRL":
            X509CRL_ = child_.text
            X509CRL_ = self.gds_validate_string(X509CRL_, node, "X509CRL")
            self.X509CRL.append(X509CRL_)
        else:
            obj_ = self.gds_build_any(child_, "X509DataType")
            if obj_ is not None:
                self.set_anytypeobjs_(obj_)


# end class X509DataType


class X509IssuerSerialType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, X509IssuerName=None, X509SerialNumber=None):
        self.original_tagname_ = None
        self.X509IssuerName = X509IssuerName
        self.X509SerialNumber = X509SerialNumber

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, X509IssuerSerialType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if X509IssuerSerialType.subclass:
            return X509IssuerSerialType.subclass(*args_, **kwargs_)
        else:
            return X509IssuerSerialType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_X509IssuerName(self):
        return self.X509IssuerName

    def set_X509IssuerName(self, X509IssuerName):
        self.X509IssuerName = X509IssuerName

    def get_X509SerialNumber(self):
        return self.X509SerialNumber

    def set_X509SerialNumber(self, X509SerialNumber):
        self.X509SerialNumber = X509SerialNumber

    def hasContent_(self):
        if self.X509IssuerName is not None or self.X509SerialNumber is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="X509IssuerSerialType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ds="http://www.w3.org/2000/09/xmldsig#"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("X509IssuerSerialType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="X509IssuerSerialType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ds:",
                name_="X509IssuerSerialType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="ds:",
        name_="X509IssuerSerialType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="X509IssuerSerialType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.X509IssuerName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ds:X509IssuerName>%s</ds:X509IssuerName>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.X509IssuerName), input_name="X509IssuerName"
                        )
                    ),
                    eol_,
                )
            )
        if self.X509SerialNumber is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ds:X509SerialNumber>%s</ds:X509SerialNumber>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.X509SerialNumber),
                            input_name="X509SerialNumber",
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "X509IssuerName":
            X509IssuerName_ = child_.text
            X509IssuerName_ = self.gds_validate_string(
                X509IssuerName_, node, "X509IssuerName"
            )
            self.X509IssuerName = X509IssuerName_
        elif nodeName_ == "X509SerialNumber":
            X509SerialNumber_ = child_.text
            X509SerialNumber_ = self.gds_validate_string(
                X509SerialNumber_, node, "X509SerialNumber"
            )
            self.X509SerialNumber = X509SerialNumber_


# end class X509IssuerSerialType


class PGPDataType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, PGPKeyID=None, PGPKeyPacket=None, anytypeobjs_=None):
        self.original_tagname_ = None
        self.PGPKeyID = PGPKeyID
        self.PGPKeyPacket = PGPKeyPacket
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, PGPDataType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PGPDataType.subclass:
            return PGPDataType.subclass(*args_, **kwargs_)
        else:
            return PGPDataType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_PGPKeyID(self):
        return self.PGPKeyID

    def set_PGPKeyID(self, PGPKeyID):
        self.PGPKeyID = PGPKeyID

    def get_PGPKeyPacket(self):
        return self.PGPKeyPacket

    def set_PGPKeyPacket(self, PGPKeyPacket):
        self.PGPKeyPacket = PGPKeyPacket

    def get_anytypeobjs_(self):
        return self.anytypeobjs_

    def set_anytypeobjs_(self, anytypeobjs_):
        self.anytypeobjs_ = anytypeobjs_

    def add_anytypeobjs_(self, value):
        self.anytypeobjs_.append(value)

    def insert_anytypeobjs_(self, index, value):
        self._anytypeobjs_[index] = value

    def hasContent_(self):
        if (
            self.PGPKeyID is not None
            or self.PGPKeyPacket is not None
            or self.anytypeobjs_
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="PGPDataType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ds="http://www.w3.org/2000/09/xmldsig#"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("PGPDataType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="PGPDataType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ds:",
                name_="PGPDataType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="ds:", name_="PGPDataType"
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="PGPDataType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.PGPKeyID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ds:PGPKeyID>%s</ds:PGPKeyID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.PGPKeyID), input_name="PGPKeyID"
                        )
                    ),
                    eol_,
                )
            )
        if self.PGPKeyPacket is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ds:PGPKeyPacket>%s</ds:PGPKeyPacket>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.PGPKeyPacket), input_name="PGPKeyPacket"
                        )
                    ),
                    eol_,
                )
            )
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "PGPKeyID":
            PGPKeyID_ = child_.text
            PGPKeyID_ = self.gds_validate_string(PGPKeyID_, node, "PGPKeyID")
            self.PGPKeyID = PGPKeyID_
        elif nodeName_ == "PGPKeyPacket":
            PGPKeyPacket_ = child_.text
            PGPKeyPacket_ = self.gds_validate_string(
                PGPKeyPacket_, node, "PGPKeyPacket"
            )
            self.PGPKeyPacket = PGPKeyPacket_
        else:
            obj_ = self.gds_build_any(child_, "PGPDataType")
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)


# end class PGPDataType


class SPKIDataType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, SPKISexp=None, anytypeobjs_=None):
        self.original_tagname_ = None
        if SPKISexp is None:
            self.SPKISexp = []
        else:
            self.SPKISexp = SPKISexp
        self.anytypeobjs_ = anytypeobjs_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, SPKIDataType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SPKIDataType.subclass:
            return SPKIDataType.subclass(*args_, **kwargs_)
        else:
            return SPKIDataType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_SPKISexp(self):
        return self.SPKISexp

    def set_SPKISexp(self, SPKISexp):
        self.SPKISexp = SPKISexp

    def add_SPKISexp(self, value):
        self.SPKISexp.append(value)

    def insert_SPKISexp_at(self, index, value):
        self.SPKISexp.insert(index, value)

    def replace_SPKISexp_at(self, index, value):
        self.SPKISexp[index] = value

    def get_anytypeobjs_(self):
        return self.anytypeobjs_

    def set_anytypeobjs_(self, anytypeobjs_):
        self.anytypeobjs_ = anytypeobjs_

    def hasContent_(self):
        if self.SPKISexp or self.anytypeobjs_ is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="SPKIDataType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ds="http://www.w3.org/2000/09/xmldsig#"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SPKIDataType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="SPKIDataType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ds:",
                name_="SPKIDataType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="ds:", name_="SPKIDataType"
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="SPKIDataType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for SPKISexp_ in self.SPKISexp:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ds:SPKISexp>%s</ds:SPKISexp>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(SPKISexp_), input_name="SPKISexp"
                        )
                    ),
                    eol_,
                )
            )
        if self.anytypeobjs_ is not None:
            self.anytypeobjs_.export(
                outfile, level, namespace_, pretty_print=pretty_print
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "SPKISexp":
            SPKISexp_ = child_.text
            SPKISexp_ = self.gds_validate_string(SPKISexp_, node, "SPKISexp")
            self.SPKISexp.append(SPKISexp_)
        else:
            obj_ = self.gds_build_any(child_, "SPKIDataType")
            if obj_ is not None:
                self.set_anytypeobjs_(obj_)


# end class SPKIDataType


class ObjectType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self,
        Id=None,
        MimeType=None,
        Encoding=None,
        anytypeobjs_=None,
        valueOf_=None,
        mixedclass_=None,
        content_=None,
    ):
        self.original_tagname_ = None
        self.Id = _cast(None, Id)
        self.MimeType = _cast(None, MimeType)
        self.Encoding = _cast(None, Encoding)
        self.anytypeobjs_ = anytypeobjs_
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ObjectType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ObjectType.subclass:
            return ObjectType.subclass(*args_, **kwargs_)
        else:
            return ObjectType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_anytypeobjs_(self):
        return self.anytypeobjs_

    def set_anytypeobjs_(self, anytypeobjs_):
        self.anytypeobjs_ = anytypeobjs_

    def get_Id(self):
        return self.Id

    def set_Id(self, Id):
        self.Id = Id

    def get_MimeType(self):
        return self.MimeType

    def set_MimeType(self, MimeType):
        self.MimeType = MimeType

    def get_Encoding(self):
        return self.Encoding

    def set_Encoding(self, Encoding):
        self.Encoding = Encoding

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if self.anytypeobjs_ is not None or (
            1 if type(self.valueOf_) in [int, float] else self.valueOf_
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="ObjectType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ds="http://www.w3.org/2000/09/xmldsig#"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ObjectType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="ObjectType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ds:",
                name_="ObjectType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="ds:", name_="ObjectType"
    ):
        if self.Id is not None and "Id" not in already_processed:
            already_processed.add("Id")
            outfile.write(" Id=%s" % (quote_attrib(self.Id),))
        if self.MimeType is not None and "MimeType" not in already_processed:
            already_processed.add("MimeType")
            outfile.write(" MimeType=%s" % (quote_attrib(self.MimeType),))
        if self.Encoding is not None and "Encoding" not in already_processed:
            already_processed.add("Encoding")
            outfile.write(" Encoding=%s" % (quote_attrib(self.Encoding),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="ObjectType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(
                    outfile, level, item_.name, namespace_, pretty_print=pretty_print
                )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.anytypeobjs_ is not None:
            self.anytypeobjs_.export(
                outfile, level, namespace_, pretty_print=pretty_print
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(
                MixedContainer.CategoryText, MixedContainer.TypeNone, "", node.text
            )
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("Id", node)
        if value is not None and "Id" not in already_processed:
            already_processed.add("Id")
            self.Id = value
        value = find_attr_value_("MimeType", node)
        if value is not None and "MimeType" not in already_processed:
            already_processed.add("MimeType")
            self.MimeType = value
        value = find_attr_value_("Encoding", node)
        if value is not None and "Encoding" not in already_processed:
            already_processed.add("Encoding")
            self.Encoding = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "":
            obj_ = __ANY__.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(
                MixedContainer.CategoryComplex, MixedContainer.TypeNone, "", obj_
            )
            self.content_.append(obj_)
            if hasattr(self, "add_"):
                self.add_(obj_.value)
            elif hasattr(self, "set_"):
                self.set_(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(
                MixedContainer.CategoryText, MixedContainer.TypeNone, "", child_.tail
            )
            self.content_.append(obj_)


# end class ObjectType


class ManifestType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, Id=None, Reference=None):
        self.original_tagname_ = None
        self.Id = _cast(None, Id)
        if Reference is None:
            self.Reference = []
        else:
            self.Reference = Reference

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ManifestType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ManifestType.subclass:
            return ManifestType.subclass(*args_, **kwargs_)
        else:
            return ManifestType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Reference(self):
        return self.Reference

    def set_Reference(self, Reference):
        self.Reference = Reference

    def add_Reference(self, value):
        self.Reference.append(value)

    def insert_Reference_at(self, index, value):
        self.Reference.insert(index, value)

    def replace_Reference_at(self, index, value):
        self.Reference[index] = value

    def get_Id(self):
        return self.Id

    def set_Id(self, Id):
        self.Id = Id

    def hasContent_(self):
        if self.Reference:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="ManifestType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ManifestType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="ManifestType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ds:",
                name_="ManifestType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self, outfile, level, already_processed, namespace_="ds:", name_="ManifestType"
    ):
        if self.Id is not None and "Id" not in already_processed:
            already_processed.add("Id")
            outfile.write(" Id=%s" % (quote_attrib(self.Id),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="ManifestType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for Reference_ in self.Reference:
            Reference_.export(
                outfile,
                level,
                namespace_="ds:",
                name_="Reference",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("Id", node)
        if value is not None and "Id" not in already_processed:
            already_processed.add("Id")
            self.Id = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "Reference":
            obj_ = ReferenceType.factory()
            obj_.build(child_)
            self.Reference.append(obj_)
            obj_.original_tagname_ = "Reference"


# end class ManifestType


class SignaturePropertiesType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, Id=None, SignatureProperty=None):
        self.original_tagname_ = None
        self.Id = _cast(None, Id)
        if SignatureProperty is None:
            self.SignatureProperty = []
        else:
            self.SignatureProperty = SignatureProperty

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SignaturePropertiesType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SignaturePropertiesType.subclass:
            return SignaturePropertiesType.subclass(*args_, **kwargs_)
        else:
            return SignaturePropertiesType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_SignatureProperty(self):
        return self.SignatureProperty

    def set_SignatureProperty(self, SignatureProperty):
        self.SignatureProperty = SignatureProperty

    def add_SignatureProperty(self, value):
        self.SignatureProperty.append(value)

    def insert_SignatureProperty_at(self, index, value):
        self.SignatureProperty.insert(index, value)

    def replace_SignatureProperty_at(self, index, value):
        self.SignatureProperty[index] = value

    def get_Id(self):
        return self.Id

    def set_Id(self, Id):
        self.Id = Id

    def hasContent_(self):
        if self.SignatureProperty:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="SignaturePropertiesType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SignaturePropertiesType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile,
            level,
            already_processed,
            namespace_,
            name_="SignaturePropertiesType",
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ds:",
                name_="SignaturePropertiesType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="ds:",
        name_="SignaturePropertiesType",
    ):
        if self.Id is not None and "Id" not in already_processed:
            already_processed.add("Id")
            outfile.write(" Id=%s" % (quote_attrib(self.Id),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="SignaturePropertiesType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for SignatureProperty_ in self.SignatureProperty:
            SignatureProperty_.export(
                outfile,
                level,
                namespace_="ds:",
                name_="SignatureProperty",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("Id", node)
        if value is not None and "Id" not in already_processed:
            already_processed.add("Id")
            self.Id = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "SignatureProperty":
            obj_ = SignaturePropertyType.factory()
            obj_.build(child_)
            self.SignatureProperty.append(obj_)
            obj_.original_tagname_ = "SignatureProperty"


# end class SignaturePropertiesType


class SignaturePropertyType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self,
        Target=None,
        Id=None,
        anytypeobjs_=None,
        valueOf_=None,
        mixedclass_=None,
        content_=None,
    ):
        self.original_tagname_ = None
        self.Target = _cast(None, Target)
        self.Id = _cast(None, Id)
        self.anytypeobjs_ = anytypeobjs_
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SignaturePropertyType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SignaturePropertyType.subclass:
            return SignaturePropertyType.subclass(*args_, **kwargs_)
        else:
            return SignaturePropertyType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_anytypeobjs_(self):
        return self.anytypeobjs_

    def set_anytypeobjs_(self, anytypeobjs_):
        self.anytypeobjs_ = anytypeobjs_

    def get_Target(self):
        return self.Target

    def set_Target(self, Target):
        self.Target = Target

    def get_Id(self):
        return self.Id

    def set_Id(self, Id):
        self.Id = Id

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if self.anytypeobjs_ is not None or (
            1 if type(self.valueOf_) in [int, float] else self.valueOf_
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="SignaturePropertyType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ds="http://www.w3.org/2000/09/xmldsig#"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SignaturePropertyType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="SignaturePropertyType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ds:",
                name_="SignaturePropertyType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="ds:",
        name_="SignaturePropertyType",
    ):
        if self.Target is not None and "Target" not in already_processed:
            already_processed.add("Target")
            outfile.write(" Target=%s" % (quote_attrib(self.Target),))
        if self.Id is not None and "Id" not in already_processed:
            already_processed.add("Id")
            outfile.write(" Id=%s" % (quote_attrib(self.Id),))

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="SignaturePropertyType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(
                    outfile, level, item_.name, namespace_, pretty_print=pretty_print
                )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.anytypeobjs_ is not None:
            self.anytypeobjs_.export(
                outfile, level, namespace_, pretty_print=pretty_print
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(
                MixedContainer.CategoryText, MixedContainer.TypeNone, "", node.text
            )
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("Target", node)
        if value is not None and "Target" not in already_processed:
            already_processed.add("Target")
            self.Target = value
        value = find_attr_value_("Id", node)
        if value is not None and "Id" not in already_processed:
            already_processed.add("Id")
            self.Id = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "":
            obj_ = __ANY__.factory()
            obj_.build(child_)
            obj_ = self.mixedclass_(
                MixedContainer.CategoryComplex, MixedContainer.TypeNone, "", obj_
            )
            self.content_.append(obj_)
            if hasattr(self, "add_"):
                self.add_(obj_.value)
            elif hasattr(self, "set_"):
                self.set_(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(
                MixedContainer.CategoryText, MixedContainer.TypeNone, "", child_.tail
            )
            self.content_.append(obj_)


# end class SignaturePropertyType


class DSAKeyValueType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self, P=None, Q=None, G=None, Y=None, J=None, Seed=None, PgenCounter=None
    ):
        self.original_tagname_ = None
        self.P = P
        self.validate_CryptoBinary(self.P)
        self.Q = Q
        self.validate_CryptoBinary(self.Q)
        self.G = G
        self.validate_CryptoBinary(self.G)
        self.Y = Y
        self.validate_CryptoBinary(self.Y)
        self.J = J
        self.validate_CryptoBinary(self.J)
        self.Seed = Seed
        self.validate_CryptoBinary(self.Seed)
        self.PgenCounter = PgenCounter
        self.validate_CryptoBinary(self.PgenCounter)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, DSAKeyValueType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DSAKeyValueType.subclass:
            return DSAKeyValueType.subclass(*args_, **kwargs_)
        else:
            return DSAKeyValueType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_P(self):
        return self.P

    def set_P(self, P):
        self.P = P

    def get_Q(self):
        return self.Q

    def set_Q(self, Q):
        self.Q = Q

    def get_G(self):
        return self.G

    def set_G(self, G):
        self.G = G

    def get_Y(self):
        return self.Y

    def set_Y(self, Y):
        self.Y = Y

    def get_J(self):
        return self.J

    def set_J(self, J):
        self.J = J

    def get_Seed(self):
        return self.Seed

    def set_Seed(self, Seed):
        self.Seed = Seed

    def get_PgenCounter(self):
        return self.PgenCounter

    def set_PgenCounter(self, PgenCounter):
        self.PgenCounter = PgenCounter

    def validate_CryptoBinary(self, value):
        # Validate type CryptoBinary, a restriction on base64Binary.
        if value is not None and Validate_simpletypes_:
            pass

    def hasContent_(self):
        if (
            self.P is not None
            or self.Q is not None
            or self.G is not None
            or self.Y is not None
            or self.J is not None
            or self.Seed is not None
            or self.PgenCounter is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="DSAKeyValueType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("DSAKeyValueType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="DSAKeyValueType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ds:",
                name_="DSAKeyValueType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="ds:",
        name_="DSAKeyValueType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="DSAKeyValueType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.P is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ds:P>%s</ds:P>%s"
                % (self.gds_format_base64(self.P, input_name="P"), eol_)
            )
        if self.Q is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ds:Q>%s</ds:Q>%s"
                % (self.gds_format_base64(self.Q, input_name="Q"), eol_)
            )
        if self.G is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ds:G>%s</ds:G>%s"
                % (self.gds_format_base64(self.G, input_name="G"), eol_)
            )
        if self.Y is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ds:Y>%s</ds:Y>%s"
                % (self.gds_format_base64(self.Y, input_name="Y"), eol_)
            )
        if self.J is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ds:J>%s</ds:J>%s"
                % (self.gds_format_base64(self.J, input_name="J"), eol_)
            )
        if self.Seed is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ds:Seed>%s</ds:Seed>%s"
                % (self.gds_format_base64(self.Seed, input_name="Seed"), eol_)
            )
        if self.PgenCounter is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ds:PgenCounter>%s</ds:PgenCounter>%s"
                % (
                    self.gds_format_base64(self.PgenCounter, input_name="PgenCounter"),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "P":
            sval_ = child_.text
            if sval_ is not None:
                try:
                    bval_ = base64.b64decode(sval_)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(
                        child_, "requires base64 encoded string: %s" % exp
                    )
                bval_ = self.gds_validate_base64(bval_, node, "P")
            else:
                bval_ = None
            self.P = bval_
            # validate type CryptoBinary
            self.validate_CryptoBinary(self.P)
        elif nodeName_ == "Q":
            sval_ = child_.text
            if sval_ is not None:
                try:
                    bval_ = base64.b64decode(sval_)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(
                        child_, "requires base64 encoded string: %s" % exp
                    )
                bval_ = self.gds_validate_base64(bval_, node, "Q")
            else:
                bval_ = None
            self.Q = bval_
            # validate type CryptoBinary
            self.validate_CryptoBinary(self.Q)
        elif nodeName_ == "G":
            sval_ = child_.text
            if sval_ is not None:
                try:
                    bval_ = base64.b64decode(sval_)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(
                        child_, "requires base64 encoded string: %s" % exp
                    )
                bval_ = self.gds_validate_base64(bval_, node, "G")
            else:
                bval_ = None
            self.G = bval_
            # validate type CryptoBinary
            self.validate_CryptoBinary(self.G)
        elif nodeName_ == "Y":
            sval_ = child_.text
            if sval_ is not None:
                try:
                    bval_ = base64.b64decode(sval_)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(
                        child_, "requires base64 encoded string: %s" % exp
                    )
                bval_ = self.gds_validate_base64(bval_, node, "Y")
            else:
                bval_ = None
            self.Y = bval_
            # validate type CryptoBinary
            self.validate_CryptoBinary(self.Y)
        elif nodeName_ == "J":
            sval_ = child_.text
            if sval_ is not None:
                try:
                    bval_ = base64.b64decode(sval_)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(
                        child_, "requires base64 encoded string: %s" % exp
                    )
                bval_ = self.gds_validate_base64(bval_, node, "J")
            else:
                bval_ = None
            self.J = bval_
            # validate type CryptoBinary
            self.validate_CryptoBinary(self.J)
        elif nodeName_ == "Seed":
            sval_ = child_.text
            if sval_ is not None:
                try:
                    bval_ = base64.b64decode(sval_)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(
                        child_, "requires base64 encoded string: %s" % exp
                    )
                bval_ = self.gds_validate_base64(bval_, node, "Seed")
            else:
                bval_ = None
            self.Seed = bval_
            # validate type CryptoBinary
            self.validate_CryptoBinary(self.Seed)
        elif nodeName_ == "PgenCounter":
            sval_ = child_.text
            if sval_ is not None:
                try:
                    bval_ = base64.b64decode(sval_)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(
                        child_, "requires base64 encoded string: %s" % exp
                    )
                bval_ = self.gds_validate_base64(bval_, node, "PgenCounter")
            else:
                bval_ = None
            self.PgenCounter = bval_
            # validate type CryptoBinary
            self.validate_CryptoBinary(self.PgenCounter)


# end class DSAKeyValueType


class RSAKeyValueType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, Modulus=None, Exponent=None):
        self.original_tagname_ = None
        self.Modulus = Modulus
        self.validate_CryptoBinary(self.Modulus)
        self.Exponent = Exponent
        self.validate_CryptoBinary(self.Exponent)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, RSAKeyValueType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if RSAKeyValueType.subclass:
            return RSAKeyValueType.subclass(*args_, **kwargs_)
        else:
            return RSAKeyValueType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Modulus(self):
        return self.Modulus

    def set_Modulus(self, Modulus):
        self.Modulus = Modulus

    def get_Exponent(self):
        return self.Exponent

    def set_Exponent(self, Exponent):
        self.Exponent = Exponent

    def validate_CryptoBinary(self, value):
        # Validate type CryptoBinary, a restriction on base64Binary.
        if value is not None and Validate_simpletypes_:
            pass

    def hasContent_(self):
        if self.Modulus is not None or self.Exponent is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="RSAKeyValueType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("RSAKeyValueType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="RSAKeyValueType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="ds:",
                name_="RSAKeyValueType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="ds:",
        name_="RSAKeyValueType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="ds:",
        name_="RSAKeyValueType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.Modulus is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ds:Modulus>%s</ds:Modulus>%s"
                % (self.gds_format_base64(self.Modulus, input_name="Modulus"), eol_)
            )
        if self.Exponent is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ds:Exponent>%s</ds:Exponent>%s"
                % (self.gds_format_base64(self.Exponent, input_name="Exponent"), eol_)
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "Modulus":
            sval_ = child_.text
            if sval_ is not None:
                try:
                    bval_ = base64.b64decode(sval_)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(
                        child_, "requires base64 encoded string: %s" % exp
                    )
                bval_ = self.gds_validate_base64(bval_, node, "Modulus")
            else:
                bval_ = None
            self.Modulus = bval_
            # validate type CryptoBinary
            self.validate_CryptoBinary(self.Modulus)
        elif nodeName_ == "Exponent":
            sval_ = child_.text
            if sval_ is not None:
                try:
                    bval_ = base64.b64decode(sval_)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(
                        child_, "requires base64 encoded string: %s" % exp
                    )
                bval_ = self.gds_validate_base64(bval_, node, "Exponent")
            else:
                bval_ = None
            self.Exponent = bval_
            # validate type CryptoBinary
            self.validate_CryptoBinary(self.Exponent)


# end class RSAKeyValueType


class oadrEventType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, eiEvent=None, oadrResponseRequired=None):
        self.original_tagname_ = None
        self.eiEvent = eiEvent
        self.oadrResponseRequired = oadrResponseRequired
        self.validate_ResponseRequiredType(self.oadrResponseRequired)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, oadrEventType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrEventType.subclass:
            return oadrEventType.subclass(*args_, **kwargs_)
        else:
            return oadrEventType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_eiEvent(self):
        return self.eiEvent

    def set_eiEvent(self, eiEvent):
        self.eiEvent = eiEvent

    def get_oadrResponseRequired(self):
        return self.oadrResponseRequired

    def set_oadrResponseRequired(self, oadrResponseRequired):
        self.oadrResponseRequired = oadrResponseRequired

    def validate_ResponseRequiredType(self, value):
        # Validate type ResponseRequiredType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ["always", "never"]
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn(
                    'Value "%(value)s" does not match xsd enumeration restriction on ResponseRequiredType'
                    % {"value": value.encode("utf-8")}
                )

    def hasContent_(self):
        if self.eiEvent is not None or self.oadrResponseRequired is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrEventType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrEventType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="oadrEventType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrEventType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrEventType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrEventType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.eiEvent is not None:
            self.eiEvent.export(
                outfile,
                level,
                namespace_="ei:",
                name_="eiEvent",
                pretty_print=pretty_print,
            )
        if self.oadrResponseRequired is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<oadr:oadrResponseRequired>%s</oadr:oadrResponseRequired>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.oadrResponseRequired),
                            input_name="oadrResponseRequired",
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "eiEvent":
            obj_ = eiEventType.factory()
            obj_.build(child_)
            self.eiEvent = obj_
            obj_.original_tagname_ = "eiEvent"
        elif nodeName_ == "oadrResponseRequired":
            oadrResponseRequired_ = child_.text
            oadrResponseRequired_ = self.gds_validate_string(
                oadrResponseRequired_, node, "oadrResponseRequired"
            )
            self.oadrResponseRequired = oadrResponseRequired_
            # validate type ResponseRequiredType
            self.validate_ResponseRequiredType(self.oadrResponseRequired)


# end class oadrEventType


class oadrExtensionsType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, oadrExtension=None):
        self.original_tagname_ = None
        if oadrExtension is None:
            self.oadrExtension = []
        else:
            self.oadrExtension = oadrExtension

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, oadrExtensionsType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrExtensionsType.subclass:
            return oadrExtensionsType.subclass(*args_, **kwargs_)
        else:
            return oadrExtensionsType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_oadrExtension(self):
        return self.oadrExtension

    def set_oadrExtension(self, oadrExtension):
        self.oadrExtension = oadrExtension

    def add_oadrExtension(self, value):
        self.oadrExtension.append(value)

    def insert_oadrExtension_at(self, index, value):
        self.oadrExtension.insert(index, value)

    def replace_oadrExtension_at(self, index, value):
        self.oadrExtension[index] = value

    def hasContent_(self):
        if self.oadrExtension:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrExtensionsType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrExtensionsType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="oadrExtensionsType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrExtensionsType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrExtensionsType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrExtensionsType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for oadrExtension_ in self.oadrExtension:
            oadrExtension_.export(
                outfile,
                level,
                namespace_,
                name_="oadrExtension",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "oadrExtension":
            obj_ = oadrExtensionType.factory()
            obj_.build(child_)
            self.oadrExtension.append(obj_)
            obj_.original_tagname_ = "oadrExtension"


# end class oadrExtensionsType


class oadrExtensionType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, oadrExtensionName=None, oadrInfo=None):
        self.original_tagname_ = None
        self.oadrExtensionName = oadrExtensionName
        if oadrInfo is None:
            self.oadrInfo = []
        else:
            self.oadrInfo = oadrInfo

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, oadrExtensionType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrExtensionType.subclass:
            return oadrExtensionType.subclass(*args_, **kwargs_)
        else:
            return oadrExtensionType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_oadrExtensionName(self):
        return self.oadrExtensionName

    def set_oadrExtensionName(self, oadrExtensionName):
        self.oadrExtensionName = oadrExtensionName

    def get_oadrInfo(self):
        return self.oadrInfo

    def set_oadrInfo(self, oadrInfo):
        self.oadrInfo = oadrInfo

    def add_oadrInfo(self, value):
        self.oadrInfo.append(value)

    def insert_oadrInfo_at(self, index, value):
        self.oadrInfo.insert(index, value)

    def replace_oadrInfo_at(self, index, value):
        self.oadrInfo[index] = value

    def hasContent_(self):
        if self.oadrExtensionName is not None or self.oadrInfo:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrExtensionType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrExtensionType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="oadrExtensionType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrExtensionType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrExtensionType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrExtensionType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.oadrExtensionName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<oadr:oadrExtensionName>%s</oadr:oadrExtensionName>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.oadrExtensionName),
                            input_name="oadrExtensionName",
                        )
                    ),
                    eol_,
                )
            )
        for oadrInfo_ in self.oadrInfo:
            oadrInfo_.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrInfo",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "oadrExtensionName":
            oadrExtensionName_ = child_.text
            oadrExtensionName_ = self.gds_validate_string(
                oadrExtensionName_, node, "oadrExtensionName"
            )
            self.oadrExtensionName = oadrExtensionName_
        elif nodeName_ == "oadrInfo":
            obj_ = oadrInfo.factory()
            obj_.build(child_)
            self.oadrInfo.append(obj_)
            obj_.original_tagname_ = "oadrInfo"


# end class oadrExtensionType


class oadrProfileType1(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, oadrProfileName=None, oadrTransports=None):
        self.original_tagname_ = None
        self.oadrProfileName = oadrProfileName
        self.validate_oadrProfileType(self.oadrProfileName)
        self.oadrTransports = oadrTransports

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, oadrProfileType1)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrProfileType1.subclass:
            return oadrProfileType1.subclass(*args_, **kwargs_)
        else:
            return oadrProfileType1(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_oadrProfileName(self):
        return self.oadrProfileName

    def set_oadrProfileName(self, oadrProfileName):
        self.oadrProfileName = oadrProfileName

    def get_oadrTransports(self):
        return self.oadrTransports

    def set_oadrTransports(self, oadrTransports):
        self.oadrTransports = oadrTransports

    def validate_oadrProfileType(self, value):
        # Validate type oadrProfileType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ["2.0a", "2.0b"]
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn(
                    'Value "%(value)s" does not match xsd enumeration restriction on oadrProfileType'
                    % {"value": value.encode("utf-8")}
                )

    def hasContent_(self):
        if self.oadrProfileName is not None or self.oadrTransports is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrProfileType1",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrProfileType1")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="oadrProfileType1"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrProfileType1",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrProfileType1",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrProfileType1",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.oadrProfileName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<oadr:oadrProfileName>%s</oadr:oadrProfileName>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.oadrProfileName),
                            input_name="oadrProfileName",
                        )
                    ),
                    eol_,
                )
            )
        if self.oadrTransports is not None:
            self.oadrTransports.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrTransports",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "oadrProfileName":
            oadrProfileName_ = child_.text
            if oadrProfileName_:
                oadrProfileName_ = re_.sub(
                    String_cleanup_pat_, " ", oadrProfileName_
                ).strip()
            else:
                oadrProfileName_ = ""
            oadrProfileName_ = self.gds_validate_string(
                oadrProfileName_, node, "oadrProfileName"
            )
            self.oadrProfileName = oadrProfileName_
            # validate type oadrProfileType
            self.validate_oadrProfileType(self.oadrProfileName)
        elif nodeName_ == "oadrTransports":
            obj_ = oadrTransports.factory()
            obj_.build(child_)
            self.oadrTransports = obj_
            obj_.original_tagname_ = "oadrTransports"


# end class oadrProfileType1


class oadrTransportType2(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, oadrTransportName=None):
        self.original_tagname_ = None
        self.oadrTransportName = oadrTransportName
        self.validate_oadrTransportType(self.oadrTransportName)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, oadrTransportType2
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrTransportType2.subclass:
            return oadrTransportType2.subclass(*args_, **kwargs_)
        else:
            return oadrTransportType2(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_oadrTransportName(self):
        return self.oadrTransportName

    def set_oadrTransportName(self, oadrTransportName):
        self.oadrTransportName = oadrTransportName

    def validate_oadrTransportType(self, value):
        # Validate type oadrTransportType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ["simpleHttp", "xmpp"]
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn(
                    'Value "%(value)s" does not match xsd enumeration restriction on oadrTransportType'
                    % {"value": value.encode("utf-8")}
                )

    def hasContent_(self):
        if self.oadrTransportName is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrTransportType2",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrTransportType2")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="oadrTransportType2"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrTransportType2",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrTransportType2",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrTransportType2",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.oadrTransportName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<oadr:oadrTransportName>%s</oadr:oadrTransportName>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.oadrTransportName),
                            input_name="oadrTransportName",
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "oadrTransportName":
            oadrTransportName_ = child_.text
            if oadrTransportName_:
                oadrTransportName_ = re_.sub(
                    String_cleanup_pat_, " ", oadrTransportName_
                ).strip()
            else:
                oadrTransportName_ = ""
            oadrTransportName_ = self.gds_validate_string(
                oadrTransportName_, node, "oadrTransportName"
            )
            self.oadrTransportName = oadrTransportName_
            # validate type oadrTransportType
            self.validate_oadrTransportType(self.oadrTransportName)


# end class oadrTransportType2


class oadrServiceType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, oadrServiceName=None, oadrInfo=None):
        self.original_tagname_ = None
        self.oadrServiceName = oadrServiceName
        self.validate_oadrServiceNameType(self.oadrServiceName)
        if oadrInfo is None:
            self.oadrInfo = []
        else:
            self.oadrInfo = oadrInfo

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, oadrServiceType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oadrServiceType.subclass:
            return oadrServiceType.subclass(*args_, **kwargs_)
        else:
            return oadrServiceType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_oadrServiceName(self):
        return self.oadrServiceName

    def set_oadrServiceName(self, oadrServiceName):
        self.oadrServiceName = oadrServiceName

    def get_oadrInfo(self):
        return self.oadrInfo

    def set_oadrInfo(self, oadrInfo):
        self.oadrInfo = oadrInfo

    def add_oadrInfo(self, value):
        self.oadrInfo.append(value)

    def insert_oadrInfo_at(self, index, value):
        self.oadrInfo.insert(index, value)

    def replace_oadrInfo_at(self, index, value):
        self.oadrInfo[index] = value

    def validate_oadrServiceNameType(self, value):
        # Validate type oadrServiceNameType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = [
                "EiEvent",
                "EiOpt",
                "EiReport",
                "EiRegisterParty",
                "OadrPoll",
            ]
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn(
                    'Value "%(value)s" does not match xsd enumeration restriction on oadrServiceNameType'
                    % {"value": value.encode("utf-8")}
                )

    def hasContent_(self):
        if self.oadrServiceName is not None or self.oadrInfo:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrServiceType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("oadrServiceType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="oadrServiceType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="oadrServiceType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="oadrServiceType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="oadrServiceType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.oadrServiceName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<oadr:oadrServiceName>%s</oadr:oadrServiceName>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.oadrServiceName),
                            input_name="oadrServiceName",
                        )
                    ),
                    eol_,
                )
            )
        for oadrInfo_ in self.oadrInfo:
            oadrInfo_.export(
                outfile,
                level,
                namespace_="oadr:",
                name_="oadrInfo",
                pretty_print=pretty_print,
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "oadrServiceName":
            oadrServiceName_ = child_.text
            if oadrServiceName_:
                oadrServiceName_ = re_.sub(
                    String_cleanup_pat_, " ", oadrServiceName_
                ).strip()
            else:
                oadrServiceName_ = ""
            oadrServiceName_ = self.gds_validate_string(
                oadrServiceName_, node, "oadrServiceName"
            )
            self.oadrServiceName = oadrServiceName_
            # validate type oadrServiceNameType
            self.validate_oadrServiceNameType(self.oadrServiceName)
        elif nodeName_ == "oadrInfo":
            obj_ = oadrInfo.factory()
            obj_.build(child_)
            self.oadrInfo.append(obj_)
            obj_.original_tagname_ = "oadrInfo"


# end class oadrServiceType


class toleranceType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, tolerate=None):
        self.original_tagname_ = None
        self.tolerate = tolerate

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, toleranceType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if toleranceType.subclass:
            return toleranceType.subclass(*args_, **kwargs_)
        else:
            return toleranceType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_tolerate(self):
        return self.tolerate

    def set_tolerate(self, tolerate):
        self.tolerate = tolerate

    def hasContent_(self):
        if self.tolerate is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="toleranceType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("toleranceType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="toleranceType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="toleranceType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="toleranceType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="toleranceType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.tolerate is not None:
            self.tolerate.export(
                outfile, level, namespace_, name_="tolerate", pretty_print=pretty_print
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "tolerate":
            obj_ = tolerateType.factory()
            obj_.build(child_)
            self.tolerate = obj_
            obj_.original_tagname_ = "tolerate"


# end class toleranceType


class tolerateType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, startafter=None):
        self.original_tagname_ = None
        self.startafter = startafter
        self.validate_DurationValueType(self.startafter)

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, tolerateType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if tolerateType.subclass:
            return tolerateType.subclass(*args_, **kwargs_)
        else:
            return tolerateType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_startafter(self):
        return self.startafter

    def set_startafter(self, startafter):
        self.startafter = startafter

    def validate_DurationValueType(self, value):
        # Validate type DurationValueType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                self.validate_DurationValueType_patterns_, value
            ):
                warnings_.warn(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (value.encode("utf-8"), self.validate_DurationValueType_patterns_)
                )

    validate_DurationValueType_patterns_ = [
        [
            "^(\\+$|^\\-)?P((\\d+Y)?(\\d+M)?(\\d+D)?T?(\\d+H)?(\\d+M)?(\\d+S)?)$|^(\\d+W)$"
        ]
    ]

    def hasContent_(self):
        if self.startafter is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="tolerateType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:xcal="urn:ietf:params:xml:ns:icalendar-2.0" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("tolerateType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="tolerateType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="tolerateType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="tolerateType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="tolerateType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.startafter is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<oadr:startafter>%s</oadr:startafter>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.startafter), input_name="startafter"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "startafter":
            startafter_ = child_.text
            startafter_ = self.gds_validate_string(startafter_, node, "startafter")
            self.startafter = startafter_
            # validate type DurationValueType
            self.validate_DurationValueType(self.startafter)


# end class tolerateType


class eventResponseType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(
        self,
        responseCode=None,
        responseDescription=None,
        requestID=None,
        qualifiedEventID=None,
        optType=None,
    ):
        self.original_tagname_ = None
        self.responseCode = responseCode
        self.responseDescription = responseDescription
        self.requestID = requestID
        self.qualifiedEventID = qualifiedEventID
        self.optType = optType

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, eventResponseType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if eventResponseType.subclass:
            return eventResponseType.subclass(*args_, **kwargs_)
        else:
            return eventResponseType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_responseCode(self):
        return self.responseCode

    def set_responseCode(self, responseCode):
        self.responseCode = responseCode

    def get_responseDescription(self):
        return self.responseDescription

    def set_responseDescription(self, responseDescription):
        self.responseDescription = responseDescription

    def get_requestID(self):
        return self.requestID

    def set_requestID(self, requestID):
        self.requestID = requestID

    def get_qualifiedEventID(self):
        return self.qualifiedEventID

    def set_qualifiedEventID(self, qualifiedEventID):
        self.qualifiedEventID = qualifiedEventID

    def get_optType(self):
        return self.optType

    def set_optType(self, optType):
        self.optType = optType

    def hasContent_(self):
        if (
            self.responseCode is not None
            or self.responseDescription is not None
            or self.requestID is not None
            or self.qualifiedEventID is not None
            or self.optType is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="eventResponseType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:ei="http://docs.oasis-open.org/ns/energyinterop/201110"  xmlns:pyld="http://docs.oasis-open.org/ns/energyinterop/201110/payloads" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("eventResponseType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="eventResponseType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="eventResponseType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="eventResponseType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="eventResponseType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.responseCode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:responseCode>%s</ei:responseCode>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.responseCode), input_name="responseCode"
                        )
                    ),
                    eol_,
                )
            )
        if self.responseDescription is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:responseDescription>%s</ei:responseDescription>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.responseDescription),
                            input_name="responseDescription",
                        )
                    ),
                    eol_,
                )
            )
        if self.requestID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<pyld:requestID>%s</pyld:requestID>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.requestID), input_name="requestID"
                        )
                    ),
                    eol_,
                )
            )
        if self.qualifiedEventID is not None:
            self.qualifiedEventID.export(
                outfile,
                level,
                namespace_="ei:",
                name_="qualifiedEventID",
                pretty_print=pretty_print,
            )
        if self.optType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<ei:optType>%s</ei:optType>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.optType), input_name="optType"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "responseCode":
            responseCode_ = child_.text
            responseCode_ = self.gds_validate_string(
                responseCode_, node, "responseCode"
            )
            self.responseCode = responseCode_
        elif nodeName_ == "responseDescription":
            responseDescription_ = child_.text
            responseDescription_ = self.gds_validate_string(
                responseDescription_, node, "responseDescription"
            )
            self.responseDescription = responseDescription_
        elif nodeName_ == "requestID":
            requestID_ = child_.text
            requestID_ = self.gds_validate_string(requestID_, node, "requestID")
            self.requestID = requestID_
        elif nodeName_ == "qualifiedEventID":
            obj_ = QualifiedEventIDType.factory()
            obj_.build(child_)
            self.qualifiedEventID = obj_
            obj_.original_tagname_ = "qualifiedEventID"
        elif nodeName_ == "optType":
            optType_ = child_.text
            if optType_:
                optType_ = re_.sub(String_cleanup_pat_, " ", optType_).strip()
            else:
                optType_ = ""
            optType_ = self.gds_validate_string(optType_, node, "optType")
            self.optType = optType_


# end class eventResponseType


class eiMarketContextType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, marketContext=None):
        self.original_tagname_ = None
        self.marketContext = marketContext

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, eiMarketContextType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if eiMarketContextType.subclass:
            return eiMarketContextType.subclass(*args_, **kwargs_)
        else:
            return eiMarketContextType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_marketContext(self):
        return self.marketContext

    def set_marketContext(self, marketContext):
        self.marketContext = marketContext

    def hasContent_(self):
        if self.marketContext is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="eiMarketContextType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07" xmlns:emix="http://docs.oasis-open.org/ns/emix/2011/06" ',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("eiMarketContextType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="eiMarketContextType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="eiMarketContextType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="eiMarketContextType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="eiMarketContextType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.marketContext is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<emix:marketContext>%s</emix:marketContext>%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.marketContext), input_name="marketContext"
                        )
                    ),
                    eol_,
                )
            )

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == "marketContext":
            marketContext_ = child_.text
            marketContext_ = self.gds_validate_string(
                marketContext_, node, "marketContext"
            )
            self.marketContext = marketContext_


# end class eiMarketContextType


class locationType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, Polygon=None):
        self.original_tagname_ = None
        self.Polygon = Polygon

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, locationType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if locationType.subclass:
            return locationType.subclass(*args_, **kwargs_)
        else:
            return locationType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_Polygon(self):
        return self.Polygon

    def set_Polygon(self, Polygon):
        self.Polygon = Polygon

    def hasContent_(self):
        if self.Polygon is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="locationType",
        namespacedef_='xmlns:oadr="http://openadr.org/oadr-2.0b/2012/07"',
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("locationType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s" % (namespace_, name_, namespacedef_ and " " + namespacedef_ or "")
        )
        already_processed = set()
        self.exportAttributes(
            outfile, level, already_processed, namespace_, name_="locationType"
        )
        if self.hasContent_():
            outfile.write(">%s" % (eol_,))
            self.exportChildren(
                outfile,
                level + 1,
                namespace_="oadr:",
                name_="locationType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespace_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespace_="oadr:",
        name_="locationType",
    ):
        pass

    def exportChildren(
        self,
        outfile,
        level,
        namespace_="oadr:",
        name_="locationType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
     