# Copyright 2025 IQM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from . import common_pb2 as common__pb2
from . import qc_pb2 as qc__pb2


class QuantumComputersStub(object):
    """
    Quantum Computer management APIs.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.GetQuantumComputerV1 = channel.unary_unary(
                '/iqm.server.QuantumComputers/GetQuantumComputerV1',
                request_serializer=qc__pb2.QuantumComputerLookupV1.SerializeToString,
                response_deserializer=qc__pb2.QuantumComputerV1.FromString,
                )
        self.ListQuantumComputersV1 = channel.unary_unary(
                '/iqm.server.QuantumComputers/ListQuantumComputersV1',
                request_serializer=qc__pb2.ListQuantumComputerFiltersV1.SerializeToString,
                response_deserializer=qc__pb2.QuantumComputersListV1.FromString,
                )
        self.GetQuantumComputerResourceV1 = channel.unary_stream(
                '/iqm.server.QuantumComputers/GetQuantumComputerResourceV1',
                request_serializer=qc__pb2.QuantumComputerResourceLookupV1.SerializeToString,
                response_deserializer=common__pb2.DataChunk.FromString,
                )


class QuantumComputersServicer(object):
    """
    Quantum Computer management APIs.
    """

    def GetQuantumComputerV1(self, request, context):
        """
        Returns the details for the requested quantum computer. The quantum computer
        can be queried by its id or alias. If the given lookup does not match any
        existing quantum computer, the RPC call returns an error with a GRPC status
        `NOT_FOUND`.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListQuantumComputersV1(self, request, context):
        """
        Returns a list of quantum computers matching the given filters.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetQuantumComputerResourceV1(self, request, context):
        """*
        Returns the contents of a given resource by name and QC id (e.g. chip design record, static architecture, etc).
        See the full list of available resources at `app/backend/lib/iqm-core-client/src/station_control_http_client/resources.rs`.
        Each resource is an opaque binary blob, the interpretation of which is up to the client.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_QuantumComputersServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'GetQuantumComputerV1': grpc.unary_unary_rpc_method_handler(
                    servicer.GetQuantumComputerV1,
                    request_deserializer=qc__pb2.QuantumComputerLookupV1.FromString,
                    response_serializer=qc__pb2.QuantumComputerV1.SerializeToString,
            ),
            'ListQuantumComputersV1': grpc.unary_unary_rpc_method_handler(
                    servicer.ListQuantumComputersV1,
                    request_deserializer=qc__pb2.ListQuantumComputerFiltersV1.FromString,
                    response_serializer=qc__pb2.QuantumComputersListV1.SerializeToString,
            ),
            'GetQuantumComputerResourceV1': grpc.unary_stream_rpc_method_handler(
                    servicer.GetQuantumComputerResourceV1,
                    request_deserializer=qc__pb2.QuantumComputerResourceLookupV1.FromString,
                    response_serializer=common__pb2.DataChunk.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'iqm.server.QuantumComputers', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class QuantumComputers(object):
    """
    Quantum Computer management APIs.
    """

    @staticmethod
    def GetQuantumComputerV1(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/iqm.server.QuantumComputers/GetQuantumComputerV1',
            qc__pb2.QuantumComputerLookupV1.SerializeToString,
            qc__pb2.QuantumComputerV1.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListQuantumComputersV1(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/iqm.server.QuantumComputers/ListQuantumComputersV1',
            qc__pb2.ListQuantumComputerFiltersV1.SerializeToString,
            qc__pb2.QuantumComputersListV1.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetQuantumComputerResourceV1(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/iqm.server.QuantumComputers/GetQuantumComputerResourceV1',
            qc__pb2.QuantumComputerResourceLookupV1.SerializeToString,
            common__pb2.DataChunk.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
