# Copyright 2025 IQM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from . import common_pb2 as common__pb2
from . import job_pb2 as job__pb2


class JobsStub(object):
    """
    User job management APIs.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.SubmitJobV1 = channel.unary_unary(
                '/iqm.server.Jobs/SubmitJobV1',
                request_serializer=job__pb2.SubmitJobRequestV1.SerializeToString,
                response_deserializer=job__pb2.JobV1.FromString,
                )
        self.GetJobV1 = channel.unary_unary(
                '/iqm.server.Jobs/GetJobV1',
                request_serializer=job__pb2.JobLookupV1.SerializeToString,
                response_deserializer=job__pb2.JobV1.FromString,
                )
        self.SubscribeToJobV1 = channel.unary_stream(
                '/iqm.server.Jobs/SubscribeToJobV1',
                request_serializer=job__pb2.JobLookupV1.SerializeToString,
                response_deserializer=job__pb2.JobEventV1.FromString,
                )
        self.GetJobPayloadV1 = channel.unary_stream(
                '/iqm.server.Jobs/GetJobPayloadV1',
                request_serializer=job__pb2.JobLookupV1.SerializeToString,
                response_deserializer=common__pb2.DataChunk.FromString,
                )
        self.GetJobResultsV1 = channel.unary_stream(
                '/iqm.server.Jobs/GetJobResultsV1',
                request_serializer=job__pb2.JobLookupV1.SerializeToString,
                response_deserializer=common__pb2.DataChunk.FromString,
                )
        self.CancelJobV1 = channel.unary_unary(
                '/iqm.server.Jobs/CancelJobV1',
                request_serializer=job__pb2.JobLookupV1.SerializeToString,
                response_deserializer=job__pb2.JobV1.FromString,
                )


class JobsServicer(object):
    """
    User job management APIs.
    """

    def SubmitJobV1(self, request, context):
        """
        Submits a new job to the quantum computer. If the submit succeeds, returns
        the handle for the submitted job.

        ## Errors
        In case of an error, a GRPC error status is returned with some optional additional
        details. The possible error cases are described below:

        ### Invalid payload
        This error is returned if the given job payload is not accepted by the
        target quantum computer. Note that different quantum computers might
        accept different payloads.
        ```
        Code = "INVALID_ARGUMENT"
        Metadata.error_code = "invalid_payload"
        Details = https://protobuf.dev/reference/protobuf/google.protobuf/#value
        {
        "errors": [<list-of-error-messages>]
        }
        ```

        ### Job type not supported
        This error is returned if the target quantum computer does not support the
        given job type (circuit, pulse).
        ```
        Code = "INVALID_ARGUMENT"
        Metadata.error_code = "job_type_not_supported"
        ```

        ### User job quota exceeded
        This error is returned if the user has already submitted the maximum allowed
        amount of jobs to the queue. Quota can be freed by either waiting for existing
        jobs to finish or manually cancelling them (either via the API or the web).
        ```
        Code = "RESOURCE_EXHAUSTED"
        Metadata.error_code = "quota_exceeded"
        ```

        ### Account does not have any active or upcoming timeslots
        This error is returned if the job is submitted with the `use_timeslot` flag enabled,
        but the user's account does not have active or upcoming timeslots booked.
        ```
        Code = "FAILED_PRECONDITION"
        Metadata.error_code = "no_booked_timeslots"
        ```

        ### Timeslot is required to execute job
        This error is returned if the target quantum computer requires timeslot to execute
        jobs but `use_timeslot` was unset (or set to `false`).
        ```
        Code = "FAILED_PRECONDITION"
        Metadata.error_code = "timeslot_required"
        ```

        ### Quantum computer not found
        This error is returned if the `qc_id` does not match any existing quantum computer.
        ```
        Code = "NOT_FOUND"
        Metadata.error_code = "not_found"
        ```
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetJobV1(self, request, context):
        """
        Get job details by JobLookup. Returns the job if the user job exists.
        User needs to be authorised to access the job data, i.e. the job must be created by the user.

        ## Errors
        In case of an error, a GRPC error status is returned with some optional additional
        details. The possible error cases are described below:

        ### Job not found
        This error is returned if the JobLookup does not match any existing job.
        ```
        Code = "NOT_FOUND"
        Metadata.error_code = "not_found"
        ```

        ### Quantum computer not found
        This error is returned if quantum computer associated with the job does not match any existing quantum computer.
        ```
        Code = "NOT_FOUND"
        Metadata.error_code = "not_found"
        ```
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SubscribeToJobV1(self, request, context):
        """
        Subscribes to the job changes. Returns a stream that emits the job at subscription
        moment and after that the changed job every time when the job state changes. The stream
        will end automatically when the job is considered as "final" and won't be updated
        anymore in the future (cancelled, interrupted, failed, completed).

        The stream may also emit empty `Keepalive` messages to indicate that job is still being
        processed but hasn't been updated. Clients may ignore these keepalive messages.

        ## Errors

        ### Job not found
        If the job does not exist with the given lookup, the following error is
        returned upon the subscription.
        ```
        Code = "NOT_FOUND"
        Metadata.error_code = "not_found"
        ```

        ### Job deleted during the subscription
        If the job gets deleted during the open subscription, the subscription stream will
        emit the following error and close immediately after that.
        ```
        Code = "ABORTED"
        Metadata.error_code = "job_deleted"
        ```

        ### Server cancellation
        If server wants to cancel the subscription (e.g. due to restarts or maintenance), the
        subscription stream will emit the following error and close immediately after that.
        ```
        Code = "ABORTED"
        Metadata.error_code = "server_cancel"
        ```
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetJobPayloadV1(self, request, context):
        """
        Get job payload as GRPC data chunk streams by JobLookup . Returns the job input data if the user job exists.
        User needs to be authorised to access the job.

        ## Errors
        In case of an error, a GRPC error status is returned with some optional additional
        details. The possible error cases are described below:

        ### Job not found
        This error is returned if the JobLookup does not match any existing job.
        ```
        Code = "NOT_FOUND"
        Metadata.error_code = "not_found"
        ```

        ### Job payload not found
        This error is returned if the job payload is not found.
        ```
        Code = "NOT_FOUND"
        Metadata.error_code = "not_found"
        ```
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetJobResultsV1(self, request, context):
        """
        Get job result as GRPC data chunk streams by JobLookup. Returns the job measurements data if the user job exists.
        User needs to be authorised to access the job.

        ## Errors
        In case of an error, a GRPC error status is returned with some optional additional
        details. The possible error cases are described below:

        ### Job not found
        This error is returned if the JobLookup does not match any existing job.
        ```
        Code = "NOT_FOUND"
        Metadata.error_code = "not_found"
        ```

        ### Job results not found
        This error is returned if the job results is not found.
        ```
        Code = "NOT_FOUND"
        Metadata.error_code = "not_found"
        ```
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def CancelJobV1(self, request, context):
        """
        Cancel a queued job by JobLookup. Returns the updated job when cancelled.
        User needs to be authorised to access the job.

        ## Errors
        In case of an error, a GRPC error status is returned with some optional additional
        details. The possible error cases are described below:

        ### Job not found
        This error is returned if the JobLookup does not match any existing user job.
        ```
        Code = "NOT_FOUND"
        Metadata.error_code = "not_found"
        ```

        ### Can't cancel job from QC because it's already in final state
        This error is returned if the job measurements is not found.
        ```
        Code = "FAILED_PRECONDITION"
        Metadata.error_code = "job_not_submitted_to_qc"
        ```

        ### Quantum computer not found
        This error is returned if quantum computer associated with the job does not match any existing quantum computer.
        ```
        Code = "NOT_FOUND"
        Metadata.error_code = "not_found"
        ```
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_JobsServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'SubmitJobV1': grpc.unary_unary_rpc_method_handler(
                    servicer.SubmitJobV1,
                    request_deserializer=job__pb2.SubmitJobRequestV1.FromString,
                    response_serializer=job__pb2.JobV1.SerializeToString,
            ),
            'GetJobV1': grpc.unary_unary_rpc_method_handler(
                    servicer.GetJobV1,
                    request_deserializer=job__pb2.JobLookupV1.FromString,
                    response_serializer=job__pb2.JobV1.SerializeToString,
            ),
            'SubscribeToJobV1': grpc.unary_stream_rpc_method_handler(
                    servicer.SubscribeToJobV1,
                    request_deserializer=job__pb2.JobLookupV1.FromString,
                    response_serializer=job__pb2.JobEventV1.SerializeToString,
            ),
            'GetJobPayloadV1': grpc.unary_stream_rpc_method_handler(
                    servicer.GetJobPayloadV1,
                    request_deserializer=job__pb2.JobLookupV1.FromString,
                    response_serializer=common__pb2.DataChunk.SerializeToString,
            ),
            'GetJobResultsV1': grpc.unary_stream_rpc_method_handler(
                    servicer.GetJobResultsV1,
                    request_deserializer=job__pb2.JobLookupV1.FromString,
                    response_serializer=common__pb2.DataChunk.SerializeToString,
            ),
            'CancelJobV1': grpc.unary_unary_rpc_method_handler(
                    servicer.CancelJobV1,
                    request_deserializer=job__pb2.JobLookupV1.FromString,
                    response_serializer=job__pb2.JobV1.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'iqm.server.Jobs', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class Jobs(object):
    """
    User job management APIs.
    """

    @staticmethod
    def SubmitJobV1(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/iqm.server.Jobs/SubmitJobV1',
            job__pb2.SubmitJobRequestV1.SerializeToString,
            job__pb2.JobV1.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetJobV1(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/iqm.server.Jobs/GetJobV1',
            job__pb2.JobLookupV1.SerializeToString,
            job__pb2.JobV1.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SubscribeToJobV1(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/iqm.server.Jobs/SubscribeToJobV1',
            job__pb2.JobLookupV1.SerializeToString,
            job__pb2.JobEventV1.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetJobPayloadV1(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/iqm.server.Jobs/GetJobPayloadV1',
            job__pb2.JobLookupV1.SerializeToString,
            common__pb2.DataChunk.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetJobResultsV1(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/iqm.server.Jobs/GetJobResultsV1',
            job__pb2.JobLookupV1.SerializeToString,
            common__pb2.DataChunk.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def CancelJobV1(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/iqm.server.Jobs/CancelJobV1',
            job__pb2.JobLookupV1.SerializeToString,
            job__pb2.JobV1.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
