# Copyright 2025 IQM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from . import calibration_pb2 as calibration__pb2
from . import common_pb2 as common__pb2


class CalibrationsStub(object):
    """Missing associated documentation comment in .proto file."""

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.GetLatestQuantumComputerCalibrationV1 = channel.unary_unary(
                '/iqm.server.Calibrations/GetLatestQuantumComputerCalibrationV1',
                request_serializer=calibration__pb2.LatestQuantumComputerCalibrationLookupV1.SerializeToString,
                response_deserializer=calibration__pb2.CalibrationMetadataV1.FromString,
                )
        self.GetCalibrationV1 = channel.unary_unary(
                '/iqm.server.Calibrations/GetCalibrationV1',
                request_serializer=calibration__pb2.CalibrationLookupV1.SerializeToString,
                response_deserializer=calibration__pb2.CalibrationMetadataV1.FromString,
                )
        self.GetFullCalibrationDataV1 = channel.unary_stream(
                '/iqm.server.Calibrations/GetFullCalibrationDataV1',
                request_serializer=calibration__pb2.CalibrationLookupV1.SerializeToString,
                response_deserializer=common__pb2.DataChunk.FromString,
                )


class CalibrationsServicer(object):
    """Missing associated documentation comment in .proto file."""

    def GetLatestQuantumComputerCalibrationV1(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetCalibrationV1(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetFullCalibrationDataV1(self, request, context):
        """*
        Get the calibration set for a given QC.

        The calibration set is returned as bytes data that contains the JSON
        representation of the calibration set data. If the calibration set is
        not found, a `NOT_FOUND` error status is returned.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_CalibrationsServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'GetLatestQuantumComputerCalibrationV1': grpc.unary_unary_rpc_method_handler(
                    servicer.GetLatestQuantumComputerCalibrationV1,
                    request_deserializer=calibration__pb2.LatestQuantumComputerCalibrationLookupV1.FromString,
                    response_serializer=calibration__pb2.CalibrationMetadataV1.SerializeToString,
            ),
            'GetCalibrationV1': grpc.unary_unary_rpc_method_handler(
                    servicer.GetCalibrationV1,
                    request_deserializer=calibration__pb2.CalibrationLookupV1.FromString,
                    response_serializer=calibration__pb2.CalibrationMetadataV1.SerializeToString,
            ),
            'GetFullCalibrationDataV1': grpc.unary_stream_rpc_method_handler(
                    servicer.GetFullCalibrationDataV1,
                    request_deserializer=calibration__pb2.CalibrationLookupV1.FromString,
                    response_serializer=common__pb2.DataChunk.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'iqm.server.Calibrations', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class Calibrations(object):
    """Missing associated documentation comment in .proto file."""

    @staticmethod
    def GetLatestQuantumComputerCalibrationV1(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/iqm.server.Calibrations/GetLatestQuantumComputerCalibrationV1',
            calibration__pb2.LatestQuantumComputerCalibrationLookupV1.SerializeToString,
            calibration__pb2.CalibrationMetadataV1.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetCalibrationV1(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/iqm.server.Calibrations/GetCalibrationV1',
            calibration__pb2.CalibrationLookupV1.SerializeToString,
            calibration__pb2.CalibrationMetadataV1.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetFullCalibrationDataV1(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/iqm.server.Calibrations/GetFullCalibrationDataV1',
            calibration__pb2.CalibrationLookupV1.SerializeToString,
            common__pb2.DataChunk.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
