'''
exceptions.py: exceptions defined by PubArchiver

Authors
-------

Michael Hucka <mhucka@caltech.edu> -- Caltech Library

Copyright
---------

Copyright (c) 2019-2022 by the California Institute of Technology.  This code
is open-source software released under a 3-clause BSD license.  Please see the
file "LICENSE" for more information.
'''


# Base class.
# .............................................................................
# The base class makes it possible to use a single test to distinguish between
# exceptions generated by PubArchiver & those generated by something else.

class PubArchiverException(Exception):
    '''Base class for PubArchiver exceptions.'''
    pass


# Exception classes.
# .............................................................................

class InternalError(Exception):
    '''Unrecoverable problem involving PubArchiver itself.'''
    pass


class ServerError(Exception):
    '''Unrecoverable problem involving a server contacted by PubArchiver.'''
    pass
