# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class WfmBuScheduleTopicLocalDate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        WfmBuScheduleTopicLocalDate - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'year': 'int',
            'month': 'int',
            'day': 'int',
            'leap_year': 'bool'
        }

        self.attribute_map = {
            'year': 'year',
            'month': 'month',
            'day': 'day',
            'leap_year': 'leapYear'
        }

        self._year = None
        self._month = None
        self._day = None
        self._leap_year = None

    @property
    def year(self):
        """
        Gets the year of this WfmBuScheduleTopicLocalDate.


        :return: The year of this WfmBuScheduleTopicLocalDate.
        :rtype: int
        """
        return self._year

    @year.setter
    def year(self, year):
        """
        Sets the year of this WfmBuScheduleTopicLocalDate.


        :param year: The year of this WfmBuScheduleTopicLocalDate.
        :type: int
        """
        
        self._year = year

    @property
    def month(self):
        """
        Gets the month of this WfmBuScheduleTopicLocalDate.


        :return: The month of this WfmBuScheduleTopicLocalDate.
        :rtype: int
        """
        return self._month

    @month.setter
    def month(self, month):
        """
        Sets the month of this WfmBuScheduleTopicLocalDate.


        :param month: The month of this WfmBuScheduleTopicLocalDate.
        :type: int
        """
        
        self._month = month

    @property
    def day(self):
        """
        Gets the day of this WfmBuScheduleTopicLocalDate.


        :return: The day of this WfmBuScheduleTopicLocalDate.
        :rtype: int
        """
        return self._day

    @day.setter
    def day(self, day):
        """
        Sets the day of this WfmBuScheduleTopicLocalDate.


        :param day: The day of this WfmBuScheduleTopicLocalDate.
        :type: int
        """
        
        self._day = day

    @property
    def leap_year(self):
        """
        Gets the leap_year of this WfmBuScheduleTopicLocalDate.


        :return: The leap_year of this WfmBuScheduleTopicLocalDate.
        :rtype: bool
        """
        return self._leap_year

    @leap_year.setter
    def leap_year(self, leap_year):
        """
        Sets the leap_year of this WfmBuScheduleTopicLocalDate.


        :param leap_year: The leap_year of this WfmBuScheduleTopicLocalDate.
        :type: bool
        """
        
        self._leap_year = leap_year

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

