# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['nonebot_plugin_naturel_gpt']

package_data = \
{'': ['*']}

install_requires = \
['nonebot-adapter-onebot>=2.2.1,<3.0.0',
 'nonebot2>=2.0.0rc3,<3.0.0',
 'openai>=0.26.4,<0.27.0',
 'transformers>=4.26.0,<5.0.0']

setup_kwargs = {
    'name': 'nonebot-plugin-naturel-gpt',
    'version': '1.1.3',
    'description': '一个基于NoneBot框架的Ai聊天插件，对接OpenAi文本生成接口',
    'long_description': '<div align="center">\n  <a href="https://v2.nonebot.dev/store"><img src="./image/README/nbp_logo.png" width="180" height="180" alt="NoneBotPluginLogo"></a>\n  <br>\n  <p><img src="./image/README/NoneBotPlugin.svg" width="240" alt="NoneBotPluginText"></p>\n</div>\n\n<div align="center">\n    ✨ 更人性化(拟人)的GPT聊天Ai插件! ✨<br/>\n    🧬 支持多个人格自定义 / 切换 | 尽情发挥你的想象力吧！ ⚙️<br/>\n    <a href="./LICENSE">\n        <img src="https://img.shields.io/badge/license-Apache 2.0-6cg.svg" alt="license">\n    </a>\n    <a href="https://pypi.python.org/pypi/nonebot-plugin-naturel-gpt">\n        <img src="https://img.shields.io/pypi/v/nonebot-plugin-naturel-gpt.svg" alt="pypi">\n    </a>\n    <img src="https://img.shields.io/badge/python-3.8+-6a9.svg" alt="python">\n    <a href="https://jq.qq.com/?_wv=1027&k=71t9iCT7">\n        <img src="https://img.shields.io/badge/加入交流群-636925153-c42.svg" alt="python">\n    </a>\n</div>\n\n## 💡功能列表\n\n* [X] 自动切换api_key: 支持同时使用多个openai_api_key，失效时自动切换\n* [X] 自定义人格预设: 可自定义的人格预设，打造属于你的个性化的TA\n* [X] 聊天基本上下文关联: 群聊场景短期记忆上下文关联，尽力避免聊天出戏\n* [X] 聊天记录总结记忆: 自动总结聊天记忆，具有一定程度的长期记忆能力\n* [X] 用户印象记忆: 每个人格对每个用户单独记忆印象，让TA能够记住你\n* [X] 人格切换: 可随时切换不同人格\n* [X] 数据持久化存储: 保存用户对话信息（使用pickle）\n* [X] 新增/编辑人格: 使用指令进行人格预设的编辑\n* [ ] 潜在人格唤醒机制: 一定条件下，潜在人格会被主动唤醒\n* [ ] 主动聊天参与逻辑: 尽力模仿人类的聊天参与逻辑，目标是让TA能够真正融入你的群组\n* [ ] 回忆录生成: 记录你们之间的点点滴滴，获取你与TA的专属回忆\n* [ ] 记忆编辑功能: 不小心让TA记住了奇怪的事情？要不还是忘了吧\n\n## 📕使用方式\n\n1. 安装本插件并启用，详见NoneBot关于插件安装的说明\n2. 加载插件并启动一次NoneBot服务\n3. 查看自动生成的 `config/naturel_gpt.config.yml` ，并填入你的OpenAi_Api_key\n4. 在机器人所在的群组或者私聊窗口@TA或者 `提到`TA当前的 `人格名` 即开始聊天\n5. 使用命令 `rg / 人格设定 / 人格 / identity` 即可查看bot信息和相关指令\n6. 启用后bot会开始监听所有消息并适时作出记录和回应，如果你不希望bot处理某条消息，请在消息前加上忽视符（默认为 `#` ，可在配置文件中修改）\n\n## 🛠️参数说明 — `config/naturel_gpt.config.yml`\n\n| 参数名                        | 类型  | 释义                                       | 默认值              | 编辑建议                                   |\n| ----------------------------- | ----- | ------------------------------------------ | ------------------- | ------------------------------------------ |\n| OPENAI_API_KEYS               | array | OpenAi的 `Api_Key，以字符串数组方式填入    | [\'\']                |                                            |\n| CHAT_HISTORY_MAX_TOKENS       | int   | 聊天记录最大token数                        | 2048                |                                            |\n| CHAT_MAX_SUMMARY_TOKENS       | int   | 聊天记录总结最大token数                    | 512                 |                                            |\n| CHAT_MEMORY_MAX_LENGTH        | int   | 聊天记忆最大条数                           | 12                  | 超出此长度后会进行记忆总结并删除更早的记录 |\n| CHAT_MEMORY_SHORT_LENGTH      | int   | 短期聊天记忆参考条数                       | 8                   |                                            |\n| CHAT_MODEL                    | str   | 聊天生成的语言模型                         | text-davinci-003    |                                            |\n| CHAT_FREQUENCY_PENALTY        | float | 聊天频率重复惩罚                           | 0.4                 |                                            |\n| CHAT_PRESENCE_PENALTY         | float | 聊天主题重复惩罚                           | 0.6                 |                                            |\n| CHAT_TEMPERATURE              | float | 聊天生成温度: 越高越随机                   | 0.6                 |                                            |\n| CHAT_TOP_P                    | float | 聊天信息采样率                             | 1                   |                                            |\n| IGNORE_PREFIX                 | str   | 忽略前置修饰：添加此修饰的聊天信息将被忽略 | #                   |                                            |\n| REPLY_MAX_TOKENS              | int   | 生成回复的最大token数                      | 1024                |                                            |\n| REQ_MAX_TOKENS                | int   | 发起请求的最大token数（即请求+回复）       | 2048                |                                            |\n| USER_MEMORY_SUMMARY_THRESHOLD | int   | 用户聊天印象总结触发阈值                   | 12                  | 越小触发越频繁，推荐10-20                  |\n| REPLY_ON_AT                   | bool  | 在被 `@TA` 时回复                        | True                |                                            |\n| REPLY_ON_NAME_MENTION         | bool  | 在被 `提及` 时回复                       | True                | `提及` 即用户发言中含有当前bot人格名     |\n| PRESETS                       | dict  | 人格预设集合                               |                     | 默认有四个预设，详见生成的配置文件         |\n| NG_DATA_PATH                  | str   | 数据文件目录                               | ./data/naturel_gpt/ | 保存实现数据持久化                         |\n| ADMIN_USERID                  | array | 管理员id，以字符串数组方式填入             | [\'\']                | 只有管理员可删除预设                       |\n| \\_\\_DEBUG\\_\\_                 | bool  | 是否开启DEBUG输出                          | False               | 开启可查看prompt模板输出                   |\n\n## 🤖行为逻辑QA\n\nQ: 如何区分会话？\n\nA: 根据群组(群聊场景)、私聊(个人)区分会话，即同一群组内共享一个会话，私聊窗口独占一个会话；不同人格的会话和记忆完全独立\n\n---\n\nQ: TA是如何产生回复的？\n\nA: TA会根据 对话上下文(即最近几条聊天记录 不论是否与TA相关)、过往记忆(过去聊天记录的总结)、发起 `@`或 `提及`的用户印象(根据与该用户的聊天记录总结) 生成prompt模板，然后通过 OpenAi 的接口产生对应的回复发送，并且把产生的回复再填加入相应的聊天记录中\n\n---\n\nQ: TA如何记忆用户印象？\n\nA: TA根据用户的id(通常是qq号)的 对TA发起 `@`或 `提及`的聊天记录、响应和历史印象 自动总结产生bot对每个用户的印象，该印象记录与会话无关(即多个会话共享)，但各个人格之间信息相互独立\n\n---\n\nQ: 如何实现记录持久化保存？\n\nA: 由于本项目的记忆保存与人格预设存在一定耦合，故使用了pickle直接对程序中使用的数据信息进行序列化后保存为本地文件，然后在程序启动的时候使用pickle加载，这样做的好处是代码实现简便，但由于运行过程数据信息几乎都保存在内存中，如果您的bot活跃用户过多(>1k)、或者人格预设过多(>100)，可能会造成一定的性能负担，敬请见谅！\n\n---\n\nQ: 为什么我在编辑了配置文件中的人格预设信息后重载插件，编辑没有生效？\n\nA: 由于用户数据信息与人格预设信息高度绑定，如果已经生成过pickle文件后程序不会再响应配置文件中人格预设的修改，而是会直接读取已有的pickle文件中的信息，您可以尝试使用 `!rg` 指令根据响应提示直接进行编辑，或者直接删除数据目录中的 `.pkl` 文件(注意：会造成bot记忆丢失)后重载程序重新生成\n\n## ❔已知问题\n\n- 程序在计算对话token数消耗时长过长，甚至高于生成回复的耗时，正在寻找更好的计算token数方案(但是过快的回复速度同时也会使bot表现不自然，导致bot拟人效果变差)\n\n## 🎢更新日志\n\n### [2023/2/6] v1.1.3\n\n> 注意：本次更新需要删除原bot记忆文件重新生成(即./data/naturel_gpt文件夹)，否则可能产生无法预计的错误\n\n- 修复了bot记忆串线的问题(多个群组同时使用场景下记忆混乱)\n- 优化bot生成记忆和摘要的逻辑，小幅提高了bot回复的速度\n- 优化了控制台输出\n\n### [2023/2/5] v1.1.2\n\n- 新增了人格预设的 锁定/解锁 功能，锁定后非管理员无法编辑该预设\n- 更新README文档\n- 优化rg命令显示格式\n- 微调了 `config.py` 中的一些默认参数\n- 修复本插件拦截其它插件响应的问题，降低了本插件的响应优先级\n- 更新了交流群信息(见本文档开头)，欢迎各路大佬加入互相学习、一同探讨更新方向、分享更多玩法等\n\n### [2023/2/2] v1.1.1\n\n- 修复查询人格错误的问题\n\n### [2023/2/2] v1.1.0\n\n> 注意：本次更新需要删除原bot记忆文件重新生成(即./data/naturel_gpt文件夹)，否则可能产生无法预计的错误\n\n- 新增了预设编辑功能\n- 新增自定义管理员id功能，管理员可以删除预设 / 修改锁定的预设\n- 增加debug开关控制生成文本时的控制台输出（默认关闭）\n',
    'author': 'KroMiose',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
