# This an autogenerated file
# 
# Generated with ReynoldItem
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.reynolditem import ReynoldItemBlueprint
from typing import Dict
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue
from sima.windturbine.airfoilitem import AirFoilItem
from sima.windturbine.stallpoint import StallPoint

class ReynoldItem(MOAO):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    reynoldsNumber : float
         Reynold number for given airfoil regime(default 0.0)
    items : List[AirFoilItem]
    stallPoint : StallPoint
    """

    def __init__(self , name="", description="", _id="", reynoldsNumber=0.0, **kwargs):
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self._id = _id
        self.scriptableValues = list()
        self.reynoldsNumber = reynoldsNumber
        self.items = list()
        self.stallPoint = None
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return ReynoldItemBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def reynoldsNumber(self) -> float:
        """Reynold number for given airfoil regime"""
        return self.__reynoldsNumber

    @reynoldsNumber.setter
    def reynoldsNumber(self, value: float):
        """Set reynoldsNumber"""
        self.__reynoldsNumber = float(value)

    @property
    def items(self) -> List[AirFoilItem]:
        """"""
        return self.__items

    @items.setter
    def items(self, value: List[AirFoilItem]):
        """Set items"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__items = value

    @property
    def stallPoint(self) -> StallPoint:
        """"""
        return self.__stallPoint

    @stallPoint.setter
    def stallPoint(self, value: StallPoint):
        """Set stallPoint"""
        self.__stallPoint = value
