# This an autogenerated file
# 
# Generated with SIMOBody
from __future__ import annotations
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.simobody import SIMOBodyBlueprint
from typing import Dict
from sima.hydro.diffractedwavefield import DiffractedWaveField
from sima.hydro.firstordermotiontransferfunction import FirstOrderMotionTransferFunction
from sima.hydro.firstorderwaveforcetransferfunction import FirstOrderWaveForceTransferFunction
from sima.hydro.gdfgeometry import GDFGeometry
from sima.hydro.hydrostaticstiffnessdata import HydrostaticStiffnessData
from sima.hydro.linearcurrentcoefficient import LinearCurrentCoefficient
from sima.hydro.lineardampingmatrix import LinearDampingMatrix
from sima.hydro.quadraticcurrentcoefficient import QuadraticCurrentCoefficient
from sima.hydro.quadraticdampingmatrix import QuadraticDampingMatrix
from sima.hydro.quadraticwindcoefficient import QuadraticWindCoefficient
from sima.hydro.radiationdatagroup import RadiationDataGroup
from sima.hydro.simplifiedwavedriftdamping import SimplifiedWaveDriftDamping
from sima.hydro.sparseqtf import SparseQTF
from sima.hydro.structuralmass import StructuralMass
from sima.hydro.wavedriftdamping import WaveDriftDamping
from sima.hydro.wavedriftforce import WaveDriftForce
from sima.sima.appearance import Appearance
from sima.sima.body import Body
from sima.sima.bodyviewpoint import BodyViewpoint
from sima.sima.point3 import Point3
from sima.sima.position import Position
from sima.sima.scriptablevalue import ScriptableValue
from sima.simo.articulatedstructuredata import ArticulatedStructureData
from sima.simo.ballastsystem import BallastSystem
from sima.simo.bodyshapedata import BodyShapeData
from sima.simo.bodyslendersystemconnection import BodySlenderSystemConnection
from sima.simo.bodytype import BodyType
from sima.simo.bumperdata import BumperData
from sima.simo.catenarysystem import CatenarySystem
from sima.simo.dockingconepositioning import DockingConePositioning
from sima.simo.externalcontrolsystem import ExternalControlSystem
from sima.simo.externaldllforce import ExternalDLLForce
from sima.simo.externalforcefromfile import ExternalForceFromFile
from sima.simo.externalhlaforce import ExternalHLAForce
from sima.simo.fixedbodyelement import FixedBodyElement
from sima.simo.fixedforceelongation import FixedForceElongation
from sima.simo.genericexternalcontrolsystem import GenericExternalControlSystem
from sima.simo.horizontalaxiswindturbine import HorizontalAxisWindTurbine
from sima.simo.hydrodynamicseparationmethod import HydrodynamicSeparationMethod
from sima.simo.ithruster import IThruster
from sima.simo.liftanddragforce import LiftAndDragForce
from sima.simo.nonlinearbuoyancycorrection import NonlinearBuoyancyCorrection
from sima.simo.nonlinearhydrostaticstiffness import NonLinearHydrostaticStiffness
from sima.simo.pointberthingfender import PointBerthingFender
from sima.simo.positionsimporttype import PositionsImportType
from sima.simo.rollerberthingfender import RollerBerthingFender
from sima.simo.simobodypoint import SIMOBodyPoint
from sima.simo.simolineardampingmatrix import SIMOLinearDampingMatrix
from sima.simo.simoquadraticdampingmatrix import SIMOQuadraticDampingMatrix
from sima.simo.slenderelement import SlenderElement
from sima.simo.smallbodyhydrodynamicdata import SmallBodyHydrodynamicData
from sima.simo.specifiedforce import SpecifiedForce
from sima.simo.specifiedmoment import SpecifiedMoment
from sima.simo.timedependentpointmass import TimeDependentPointMass
from sima.simo.timedependentvolumemass import TimeDependentVolumeMass
from sima.simo.verticalaxiswindturbine import VerticalAxisWindTurbine
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from sima.simo.controlsystem import ControlSystem

class SIMOBody(Body):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    length : float
         Length(default 10.0)
    width : float
         Width(default 5.0)
    height : float
         Height(default 5.0)
    appearance : Appearance
    initialPosition : Position
    viewpoints : List[BodyViewpoint]
    _type : BodyType
         Body type
    positionsImportType : PositionsImportType
         Type of import for positions
    positionsFileName : str
         File name for body positions(default "")
    positionsHLAObjectName : str
         HLA object name for body(default "")
    applyGravityForce : bool
         Should gravity force be included(default False)
    bodyPoints : List[SIMOBodyPoint]
    catenarySystem : CatenarySystem
    structuralMass : StructuralMass
    linearDamping : LinearDampingMatrix
    quadraticDamping : QuadraticDampingMatrix
    linearDampingMatrices : List[SIMOLinearDampingMatrix]
    quadraticDampingMatrices : List[SIMOQuadraticDampingMatrix]
    hydrostaticStiffnessData : HydrostaticStiffnessData
    nonLinearHydrostaticStiffness : NonLinearHydrostaticStiffness
    nonlinearBuoyancyCorrection : NonlinearBuoyancyCorrection
    firstOrderMotionTransferFunction : FirstOrderMotionTransferFunction
    firstOrderWaveForceTransferFunction : FirstOrderWaveForceTransferFunction
    waveDriftForce : WaveDriftForce
    waveDriftDamping : WaveDriftDamping
    simplifiedWaveDriftDamping : SimplifiedWaveDriftDamping
    quadraticWindCoefficients : QuadraticWindCoefficient
    linearCurrentCoefficients : LinearCurrentCoefficient
    quadraticCurrentCoefficients : QuadraticCurrentCoefficient
    diffractedWaveField : DiffractedWaveField
    smallBodyHydrodynamicalData : SmallBodyHydrodynamicData
    radiationData : RadiationDataGroup
    specifiedForces : List[SpecifiedForce]
    specifiedMoments : List[SpecifiedMoment]
    thrusters : List[IThruster]
    controlSystem : ControlSystem
    slenderElements : List[SlenderElement]
    externalDLLForces : List[ExternalDLLForce]
    externalHLAForces : List[ExternalHLAForce]
    externalForcesFromFile : List[ExternalForceFromFile]
    fixedBodyElements : List[FixedBodyElement]
    timeDependentPointMasses : List[TimeDependentPointMass]
    timeDependentVolumeMasses : List[TimeDependentVolumeMass]
    slenderSystemConnection : BodySlenderSystemConnection
    gdfGeometry : GDFGeometry
    fixedForceElongations : List[FixedForceElongation]
    accCOG : Point3
    liftAndDragForces : List[LiftAndDragForce]
    articulatedStructure : ArticulatedStructureData
    externalControlSystem : ExternalControlSystem
    dockingConePositionings : List[DockingConePositioning]
    pointBerthingFenders : List[PointBerthingFender]
    rollerBerthingFenders : List[RollerBerthingFender]
    bumperDatas : List[BumperData]
    horizontalAxisWindTurbine : HorizontalAxisWindTurbine
    verticalAxisWindTurbine : VerticalAxisWindTurbine
    genericExternalControlSystems : List[GenericExternalControlSystem]
    ballastSystem : BallastSystem
    hydrodynamicSeparationMethod : HydrodynamicSeparationMethod
         Method for estimating low frequency motions
    hydrodynamicFilterCutOffPeriod : float
         Cut off period used to estimate low ferquency motion from total motion(default 0.0)
    bodyShapeData : BodyShapeData
    qtf : SparseQTF
    """

    def __init__(self , name="", description="", _id="", length=10.0, width=5.0, height=5.0, _type=BodyType.SIX_DOF_TIME_DOMAIN, positionsImportType=PositionsImportType.FIXED_POSITION, positionsFileName="", positionsHLAObjectName="", applyGravityForce=False, hydrodynamicSeparationMethod=HydrodynamicSeparationMethod.BW2_FILTERING, hydrodynamicFilterCutOffPeriod=0.0, **kwargs):
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self._id = _id
        self.scriptableValues = list()
        self.length = length
        self.width = width
        self.height = height
        self.appearance = None
        self.initialPosition = None
        self.viewpoints = list()
        self._type = _type
        self.positionsImportType = positionsImportType
        self.positionsFileName = positionsFileName
        self.positionsHLAObjectName = positionsHLAObjectName
        self.applyGravityForce = applyGravityForce
        self.bodyPoints = list()
        self.catenarySystem = None
        self.structuralMass = None
        self.linearDamping = None
        self.quadraticDamping = None
        self.linearDampingMatrices = list()
        self.quadraticDampingMatrices = list()
        self.hydrostaticStiffnessData = None
        self.nonLinearHydrostaticStiffness = None
        self.nonlinearBuoyancyCorrection = None
        self.firstOrderMotionTransferFunction = None
        self.firstOrderWaveForceTransferFunction = None
        self.waveDriftForce = None
        self.waveDriftDamping = None
        self.simplifiedWaveDriftDamping = None
        self.quadraticWindCoefficients = None
        self.linearCurrentCoefficients = None
        self.quadraticCurrentCoefficients = None
        self.diffractedWaveField = None
        self.smallBodyHydrodynamicalData = None
        self.radiationData = None
        self.specifiedForces = list()
        self.specifiedMoments = list()
        self.thrusters = list()
        self.controlSystem = None
        self.slenderElements = list()
        self.externalDLLForces = list()
        self.externalHLAForces = list()
        self.externalForcesFromFile = list()
        self.fixedBodyElements = list()
        self.timeDependentPointMasses = list()
        self.timeDependentVolumeMasses = list()
        self.slenderSystemConnection = None
        self.gdfGeometry = None
        self.fixedForceElongations = list()
        self.accCOG = None
        self.liftAndDragForces = list()
        self.articulatedStructure = None
        self.externalControlSystem = None
        self.dockingConePositionings = list()
        self.pointBerthingFenders = list()
        self.rollerBerthingFenders = list()
        self.bumperDatas = list()
        self.horizontalAxisWindTurbine = None
        self.verticalAxisWindTurbine = None
        self.genericExternalControlSystems = list()
        self.ballastSystem = None
        self.hydrodynamicSeparationMethod = hydrodynamicSeparationMethod
        self.hydrodynamicFilterCutOffPeriod = hydrodynamicFilterCutOffPeriod
        self.bodyShapeData = None
        self.qtf = None
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return SIMOBodyBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def length(self) -> float:
        """Length"""
        return self.__length

    @length.setter
    def length(self, value: float):
        """Set length"""
        self.__length = float(value)

    @property
    def width(self) -> float:
        """Width"""
        return self.__width

    @width.setter
    def width(self, value: float):
        """Set width"""
        self.__width = float(value)

    @property
    def height(self) -> float:
        """Height"""
        return self.__height

    @height.setter
    def height(self, value: float):
        """Set height"""
        self.__height = float(value)

    @property
    def appearance(self) -> Appearance:
        """"""
        return self.__appearance

    @appearance.setter
    def appearance(self, value: Appearance):
        """Set appearance"""
        self.__appearance = value

    @property
    def initialPosition(self) -> Position:
        """"""
        return self.__initialPosition

    @initialPosition.setter
    def initialPosition(self, value: Position):
        """Set initialPosition"""
        self.__initialPosition = value

    @property
    def viewpoints(self) -> List[BodyViewpoint]:
        """"""
        return self.__viewpoints

    @viewpoints.setter
    def viewpoints(self, value: List[BodyViewpoint]):
        """Set viewpoints"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__viewpoints = value

    @property
    def _type(self) -> BodyType:
        """Body type"""
        return self.___type

    @_type.setter
    def _type(self, value: BodyType):
        """Set _type"""
        self.___type = value

    @property
    def positionsImportType(self) -> PositionsImportType:
        """Type of import for positions"""
        return self.__positionsImportType

    @positionsImportType.setter
    def positionsImportType(self, value: PositionsImportType):
        """Set positionsImportType"""
        self.__positionsImportType = value

    @property
    def positionsFileName(self) -> str:
        """File name for body positions"""
        return self.__positionsFileName

    @positionsFileName.setter
    def positionsFileName(self, value: str):
        """Set positionsFileName"""
        self.__positionsFileName = str(value)

    @property
    def positionsHLAObjectName(self) -> str:
        """HLA object name for body"""
        return self.__positionsHLAObjectName

    @positionsHLAObjectName.setter
    def positionsHLAObjectName(self, value: str):
        """Set positionsHLAObjectName"""
        self.__positionsHLAObjectName = str(value)

    @property
    def applyGravityForce(self) -> bool:
        """Should gravity force be included"""
        return self.__applyGravityForce

    @applyGravityForce.setter
    def applyGravityForce(self, value: bool):
        """Set applyGravityForce"""
        self.__applyGravityForce = bool(value)

    @property
    def bodyPoints(self) -> List[SIMOBodyPoint]:
        """"""
        return self.__bodyPoints

    @bodyPoints.setter
    def bodyPoints(self, value: List[SIMOBodyPoint]):
        """Set bodyPoints"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__bodyPoints = value

    @property
    def catenarySystem(self) -> CatenarySystem:
        """"""
        return self.__catenarySystem

    @catenarySystem.setter
    def catenarySystem(self, value: CatenarySystem):
        """Set catenarySystem"""
        self.__catenarySystem = value

    @property
    def structuralMass(self) -> StructuralMass:
        """"""
        return self.__structuralMass

    @structuralMass.setter
    def structuralMass(self, value: StructuralMass):
        """Set structuralMass"""
        self.__structuralMass = value

    @property
    def linearDamping(self) -> LinearDampingMatrix:
        """"""
        return self.__linearDamping

    @linearDamping.setter
    def linearDamping(self, value: LinearDampingMatrix):
        """Set linearDamping"""
        self.__linearDamping = value

    @property
    def quadraticDamping(self) -> QuadraticDampingMatrix:
        """"""
        return self.__quadraticDamping

    @quadraticDamping.setter
    def quadraticDamping(self, value: QuadraticDampingMatrix):
        """Set quadraticDamping"""
        self.__quadraticDamping = value

    @property
    def linearDampingMatrices(self) -> List[SIMOLinearDampingMatrix]:
        """"""
        return self.__linearDampingMatrices

    @linearDampingMatrices.setter
    def linearDampingMatrices(self, value: List[SIMOLinearDampingMatrix]):
        """Set linearDampingMatrices"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__linearDampingMatrices = value

    @property
    def quadraticDampingMatrices(self) -> List[SIMOQuadraticDampingMatrix]:
        """"""
        return self.__quadraticDampingMatrices

    @quadraticDampingMatrices.setter
    def quadraticDampingMatrices(self, value: List[SIMOQuadraticDampingMatrix]):
        """Set quadraticDampingMatrices"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__quadraticDampingMatrices = value

    @property
    def hydrostaticStiffnessData(self) -> HydrostaticStiffnessData:
        """"""
        return self.__hydrostaticStiffnessData

    @hydrostaticStiffnessData.setter
    def hydrostaticStiffnessData(self, value: HydrostaticStiffnessData):
        """Set hydrostaticStiffnessData"""
        self.__hydrostaticStiffnessData = value

    @property
    def nonLinearHydrostaticStiffness(self) -> NonLinearHydrostaticStiffness:
        """"""
        return self.__nonLinearHydrostaticStiffness

    @nonLinearHydrostaticStiffness.setter
    def nonLinearHydrostaticStiffness(self, value: NonLinearHydrostaticStiffness):
        """Set nonLinearHydrostaticStiffness"""
        self.__nonLinearHydrostaticStiffness = value

    @property
    def nonlinearBuoyancyCorrection(self) -> NonlinearBuoyancyCorrection:
        """"""
        return self.__nonlinearBuoyancyCorrection

    @nonlinearBuoyancyCorrection.setter
    def nonlinearBuoyancyCorrection(self, value: NonlinearBuoyancyCorrection):
        """Set nonlinearBuoyancyCorrection"""
        self.__nonlinearBuoyancyCorrection = value

    @property
    def firstOrderMotionTransferFunction(self) -> FirstOrderMotionTransferFunction:
        """"""
        return self.__firstOrderMotionTransferFunction

    @firstOrderMotionTransferFunction.setter
    def firstOrderMotionTransferFunction(self, value: FirstOrderMotionTransferFunction):
        """Set firstOrderMotionTransferFunction"""
        self.__firstOrderMotionTransferFunction = value

    @property
    def firstOrderWaveForceTransferFunction(self) -> FirstOrderWaveForceTransferFunction:
        """"""
        return self.__firstOrderWaveForceTransferFunction

    @firstOrderWaveForceTransferFunction.setter
    def firstOrderWaveForceTransferFunction(self, value: FirstOrderWaveForceTransferFunction):
        """Set firstOrderWaveForceTransferFunction"""
        self.__firstOrderWaveForceTransferFunction = value

    @property
    def waveDriftForce(self) -> WaveDriftForce:
        """"""
        return self.__waveDriftForce

    @waveDriftForce.setter
    def waveDriftForce(self, value: WaveDriftForce):
        """Set waveDriftForce"""
        self.__waveDriftForce = value

    @property
    def waveDriftDamping(self) -> WaveDriftDamping:
        """"""
        return self.__waveDriftDamping

    @waveDriftDamping.setter
    def waveDriftDamping(self, value: WaveDriftDamping):
        """Set waveDriftDamping"""
        self.__waveDriftDamping = value

    @property
    def simplifiedWaveDriftDamping(self) -> SimplifiedWaveDriftDamping:
        """"""
        return self.__simplifiedWaveDriftDamping

    @simplifiedWaveDriftDamping.setter
    def simplifiedWaveDriftDamping(self, value: SimplifiedWaveDriftDamping):
        """Set simplifiedWaveDriftDamping"""
        self.__simplifiedWaveDriftDamping = value

    @property
    def quadraticWindCoefficients(self) -> QuadraticWindCoefficient:
        """"""
        return self.__quadraticWindCoefficients

    @quadraticWindCoefficients.setter
    def quadraticWindCoefficients(self, value: QuadraticWindCoefficient):
        """Set quadraticWindCoefficients"""
        self.__quadraticWindCoefficients = value

    @property
    def linearCurrentCoefficients(self) -> LinearCurrentCoefficient:
        """"""
        return self.__linearCurrentCoefficients

    @linearCurrentCoefficients.setter
    def linearCurrentCoefficients(self, value: LinearCurrentCoefficient):
        """Set linearCurrentCoefficients"""
        self.__linearCurrentCoefficients = value

    @property
    def quadraticCurrentCoefficients(self) -> QuadraticCurrentCoefficient:
        """"""
        return self.__quadraticCurrentCoefficients

    @quadraticCurrentCoefficients.setter
    def quadraticCurrentCoefficients(self, value: QuadraticCurrentCoefficient):
        """Set quadraticCurrentCoefficients"""
        self.__quadraticCurrentCoefficients = value

    @property
    def diffractedWaveField(self) -> DiffractedWaveField:
        """"""
        return self.__diffractedWaveField

    @diffractedWaveField.setter
    def diffractedWaveField(self, value: DiffractedWaveField):
        """Set diffractedWaveField"""
        self.__diffractedWaveField = value

    @property
    def smallBodyHydrodynamicalData(self) -> SmallBodyHydrodynamicData:
        """"""
        return self.__smallBodyHydrodynamicalData

    @smallBodyHydrodynamicalData.setter
    def smallBodyHydrodynamicalData(self, value: SmallBodyHydrodynamicData):
        """Set smallBodyHydrodynamicalData"""
        self.__smallBodyHydrodynamicalData = value

    @property
    def radiationData(self) -> RadiationDataGroup:
        """"""
        return self.__radiationData

    @radiationData.setter
    def radiationData(self, value: RadiationDataGroup):
        """Set radiationData"""
        self.__radiationData = value

    @property
    def specifiedForces(self) -> List[SpecifiedForce]:
        """"""
        return self.__specifiedForces

    @specifiedForces.setter
    def specifiedForces(self, value: List[SpecifiedForce]):
        """Set specifiedForces"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__specifiedForces = value

    @property
    def specifiedMoments(self) -> List[SpecifiedMoment]:
        """"""
        return self.__specifiedMoments

    @specifiedMoments.setter
    def specifiedMoments(self, value: List[SpecifiedMoment]):
        """Set specifiedMoments"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__specifiedMoments = value

    @property
    def thrusters(self) -> List[IThruster]:
        """"""
        return self.__thrusters

    @thrusters.setter
    def thrusters(self, value: List[IThruster]):
        """Set thrusters"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__thrusters = value

    @property
    def controlSystem(self) -> ControlSystem:
        """"""
        return self.__controlSystem

    @controlSystem.setter
    def controlSystem(self, value: ControlSystem):
        """Set controlSystem"""
        self.__controlSystem = value

    @property
    def slenderElements(self) -> List[SlenderElement]:
        """"""
        return self.__slenderElements

    @slenderElements.setter
    def slenderElements(self, value: List[SlenderElement]):
        """Set slenderElements"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__slenderElements = value

    @property
    def externalDLLForces(self) -> List[ExternalDLLForce]:
        """"""
        return self.__externalDLLForces

    @externalDLLForces.setter
    def externalDLLForces(self, value: List[ExternalDLLForce]):
        """Set externalDLLForces"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__externalDLLForces = value

    @property
    def externalHLAForces(self) -> List[ExternalHLAForce]:
        """"""
        return self.__externalHLAForces

    @externalHLAForces.setter
    def externalHLAForces(self, value: List[ExternalHLAForce]):
        """Set externalHLAForces"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__externalHLAForces = value

    @property
    def externalForcesFromFile(self) -> List[ExternalForceFromFile]:
        """"""
        return self.__externalForcesFromFile

    @externalForcesFromFile.setter
    def externalForcesFromFile(self, value: List[ExternalForceFromFile]):
        """Set externalForcesFromFile"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__externalForcesFromFile = value

    @property
    def fixedBodyElements(self) -> List[FixedBodyElement]:
        """"""
        return self.__fixedBodyElements

    @fixedBodyElements.setter
    def fixedBodyElements(self, value: List[FixedBodyElement]):
        """Set fixedBodyElements"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__fixedBodyElements = value

    @property
    def timeDependentPointMasses(self) -> List[TimeDependentPointMass]:
        """"""
        return self.__timeDependentPointMasses

    @timeDependentPointMasses.setter
    def timeDependentPointMasses(self, value: List[TimeDependentPointMass]):
        """Set timeDependentPointMasses"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__timeDependentPointMasses = value

    @property
    def timeDependentVolumeMasses(self) -> List[TimeDependentVolumeMass]:
        """"""
        return self.__timeDependentVolumeMasses

    @timeDependentVolumeMasses.setter
    def timeDependentVolumeMasses(self, value: List[TimeDependentVolumeMass]):
        """Set timeDependentVolumeMasses"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__timeDependentVolumeMasses = value

    @property
    def slenderSystemConnection(self) -> BodySlenderSystemConnection:
        """"""
        return self.__slenderSystemConnection

    @slenderSystemConnection.setter
    def slenderSystemConnection(self, value: BodySlenderSystemConnection):
        """Set slenderSystemConnection"""
        self.__slenderSystemConnection = value

    @property
    def gdfGeometry(self) -> GDFGeometry:
        """"""
        return self.__gdfGeometry

    @gdfGeometry.setter
    def gdfGeometry(self, value: GDFGeometry):
        """Set gdfGeometry"""
        self.__gdfGeometry = value

    @property
    def fixedForceElongations(self) -> List[FixedForceElongation]:
        """"""
        return self.__fixedForceElongations

    @fixedForceElongations.setter
    def fixedForceElongations(self, value: List[FixedForceElongation]):
        """Set fixedForceElongations"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__fixedForceElongations = value

    @property
    def accCOG(self) -> Point3:
        """"""
        return self.__accCOG

    @accCOG.setter
    def accCOG(self, value: Point3):
        """Set accCOG"""
        self.__accCOG = value

    @property
    def liftAndDragForces(self) -> List[LiftAndDragForce]:
        """"""
        return self.__liftAndDragForces

    @liftAndDragForces.setter
    def liftAndDragForces(self, value: List[LiftAndDragForce]):
        """Set liftAndDragForces"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__liftAndDragForces = value

    @property
    def articulatedStructure(self) -> ArticulatedStructureData:
        """"""
        return self.__articulatedStructure

    @articulatedStructure.setter
    def articulatedStructure(self, value: ArticulatedStructureData):
        """Set articulatedStructure"""
        self.__articulatedStructure = value

    @property
    def externalControlSystem(self) -> ExternalControlSystem:
        """"""
        return self.__externalControlSystem

    @externalControlSystem.setter
    def externalControlSystem(self, value: ExternalControlSystem):
        """Set externalControlSystem"""
        self.__externalControlSystem = value

    @property
    def dockingConePositionings(self) -> List[DockingConePositioning]:
        """"""
        return self.__dockingConePositionings

    @dockingConePositionings.setter
    def dockingConePositionings(self, value: List[DockingConePositioning]):
        """Set dockingConePositionings"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__dockingConePositionings = value

    @property
    def pointBerthingFenders(self) -> List[PointBerthingFender]:
        """"""
        return self.__pointBerthingFenders

    @pointBerthingFenders.setter
    def pointBerthingFenders(self, value: List[PointBerthingFender]):
        """Set pointBerthingFenders"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__pointBerthingFenders = value

    @property
    def rollerBerthingFenders(self) -> List[RollerBerthingFender]:
        """"""
        return self.__rollerBerthingFenders

    @rollerBerthingFenders.setter
    def rollerBerthingFenders(self, value: List[RollerBerthingFender]):
        """Set rollerBerthingFenders"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__rollerBerthingFenders = value

    @property
    def bumperDatas(self) -> List[BumperData]:
        """"""
        return self.__bumperDatas

    @bumperDatas.setter
    def bumperDatas(self, value: List[BumperData]):
        """Set bumperDatas"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__bumperDatas = value

    @property
    def horizontalAxisWindTurbine(self) -> HorizontalAxisWindTurbine:
        """"""
        return self.__horizontalAxisWindTurbine

    @horizontalAxisWindTurbine.setter
    def horizontalAxisWindTurbine(self, value: HorizontalAxisWindTurbine):
        """Set horizontalAxisWindTurbine"""
        self.__horizontalAxisWindTurbine = value

    @property
    def verticalAxisWindTurbine(self) -> VerticalAxisWindTurbine:
        """"""
        return self.__verticalAxisWindTurbine

    @verticalAxisWindTurbine.setter
    def verticalAxisWindTurbine(self, value: VerticalAxisWindTurbine):
        """Set verticalAxisWindTurbine"""
        self.__verticalAxisWindTurbine = value

    @property
    def genericExternalControlSystems(self) -> List[GenericExternalControlSystem]:
        """"""
        return self.__genericExternalControlSystems

    @genericExternalControlSystems.setter
    def genericExternalControlSystems(self, value: List[GenericExternalControlSystem]):
        """Set genericExternalControlSystems"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__genericExternalControlSystems = value

    @property
    def ballastSystem(self) -> BallastSystem:
        """"""
        return self.__ballastSystem

    @ballastSystem.setter
    def ballastSystem(self, value: BallastSystem):
        """Set ballastSystem"""
        self.__ballastSystem = value

    @property
    def hydrodynamicSeparationMethod(self) -> HydrodynamicSeparationMethod:
        """Method for estimating low frequency motions"""
        return self.__hydrodynamicSeparationMethod

    @hydrodynamicSeparationMethod.setter
    def hydrodynamicSeparationMethod(self, value: HydrodynamicSeparationMethod):
        """Set hydrodynamicSeparationMethod"""
        self.__hydrodynamicSeparationMethod = value

    @property
    def hydrodynamicFilterCutOffPeriod(self) -> float:
        """Cut off period used to estimate low ferquency motion from total motion"""
        return self.__hydrodynamicFilterCutOffPeriod

    @hydrodynamicFilterCutOffPeriod.setter
    def hydrodynamicFilterCutOffPeriod(self, value: float):
        """Set hydrodynamicFilterCutOffPeriod"""
        self.__hydrodynamicFilterCutOffPeriod = float(value)

    @property
    def bodyShapeData(self) -> BodyShapeData:
        """"""
        return self.__bodyShapeData

    @bodyShapeData.setter
    def bodyShapeData(self, value: BodyShapeData):
        """Set bodyShapeData"""
        self.__bodyShapeData = value

    @property
    def qtf(self) -> SparseQTF:
        """"""
        return self.__qtf

    @qtf.setter
    def qtf(self, value: SparseQTF):
        """Set qtf"""
        self.__qtf = value
