# This an autogenerated file
# 
# Generated with TextFile
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.textfile import TextFileBlueprint
from typing import Dict
from sima.report.reportitem import ReportItem
from sima.sima.scriptablevalue import ScriptableValue

class TextFile(ReportItem):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    path : str
         Absolute path to the text file to be read in.(default "")
    plainText : bool
         Whether or not the text file contains Wiki markup code to be parsed.(default False)
    """

    def __init__(self , name="", description="", _id="", path="", plainText=False, **kwargs):
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self._id = _id
        self.scriptableValues = list()
        self.path = path
        self.plainText = plainText
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return TextFileBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def path(self) -> str:
        """Absolute path to the text file to be read in."""
        return self.__path

    @path.setter
    def path(self, value: str):
        """Set path"""
        self.__path = str(value)

    @property
    def plainText(self) -> bool:
        """Whether or not the text file contains Wiki markup code to be parsed."""
        return self.__plainText

    @plainText.setter
    def plainText(self, value: bool):
        """Set plainText"""
        self.__plainText = bool(value)
