# This an autogenerated file
# 
# Generated with QuadraticWindCoefficient
from typing import Dict,Sequence,List
from dmt.entity import Entity
from dmt.blueprint import Blueprint
from .blueprints.quadraticwindcoefficient import QuadraticWindCoefficientBlueprint
from typing import Dict
from sima.hydro.coefficienttype import CoefficientType
from sima.hydro.directionsymmetry import DirectionSymmetry
from sima.hydro.quadraticwindcoefficientitem import QuadraticWindCoefficientItem
from sima.sima.moao import MOAO
from sima.sima.scriptablevalue import ScriptableValue

class QuadraticWindCoefficient(MOAO):
    """
    Keyword arguments
    -----------------
    name : str
         (default "")
    description : str
         (default "")
    _id : str
         (default "")
    scriptableValues : List[ScriptableValue]
    symmetry : DirectionSymmetry
    windArea : float
         (default 2000.0)
    referenceHeight : float
         Reference height for wind velocity(default 10.0)
    items : List[QuadraticWindCoefficientItem]
    _type : CoefficientType
         Wind coefficient type
    fileName : str
         Text file containing the wind coefficients. The force coefficents in the file must be specified in [kN/(m/s)] for translational degrees of freedom and [kN.s] for rotational degrees of freedom.(default "")
    """

    def __init__(self , name="", description="", _id="", symmetry=DirectionSymmetry.NO_SYMMETRY, windArea=2000.0, referenceHeight=10.0, _type=CoefficientType.CLASSIC, fileName="", **kwargs):
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self._id = _id
        self.scriptableValues = list()
        self.symmetry = symmetry
        self.windArea = windArea
        self.referenceHeight = referenceHeight
        self.items = list()
        self._type = _type
        self.fileName = fileName
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return QuadraticWindCoefficientBlueprint()


    @property
    def name(self) -> str:
        """"""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = str(value)

    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = str(value)

    @property
    def _id(self) -> str:
        """"""
        return self.___id

    @_id.setter
    def _id(self, value: str):
        """Set _id"""
        self.___id = str(value)

    @property
    def scriptableValues(self) -> List[ScriptableValue]:
        """"""
        return self.__scriptableValues

    @scriptableValues.setter
    def scriptableValues(self, value: List[ScriptableValue]):
        """Set scriptableValues"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__scriptableValues = value

    @property
    def symmetry(self) -> DirectionSymmetry:
        """"""
        return self.__symmetry

    @symmetry.setter
    def symmetry(self, value: DirectionSymmetry):
        """Set symmetry"""
        self.__symmetry = value

    @property
    def windArea(self) -> float:
        """"""
        return self.__windArea

    @windArea.setter
    def windArea(self, value: float):
        """Set windArea"""
        self.__windArea = float(value)

    @property
    def referenceHeight(self) -> float:
        """Reference height for wind velocity"""
        return self.__referenceHeight

    @referenceHeight.setter
    def referenceHeight(self, value: float):
        """Set referenceHeight"""
        self.__referenceHeight = float(value)

    @property
    def items(self) -> List[QuadraticWindCoefficientItem]:
        """"""
        return self.__items

    @items.setter
    def items(self, value: List[QuadraticWindCoefficientItem]):
        """Set items"""
        if not isinstance(value, Sequence):
            raise Exception("Expected sequense, but was " , type(value))
        self.__items = value

    @property
    def _type(self) -> CoefficientType:
        """Wind coefficient type"""
        return self.___type

    @_type.setter
    def _type(self, value: CoefficientType):
        """Set _type"""
        self.___type = value

    @property
    def fileName(self) -> str:
        """Text file containing the wind coefficients. The force coefficents in the file must be specified in [kN/(m/s)] for translational degrees of freedom and [kN.s] for rotational degrees of freedom."""
        return self.__fileName

    @fileName.setter
    def fileName(self, value: str):
        """Set fileName"""
        self.__fileName = str(value)
