import subprocess
import markdown
import os

def do_markdown(input_filepath, output_filepath, output_ext, filter_args):
    with open(input_filepath, 'r') as i_f:
        with open(output_filepath, 'w') as o_f:
            html = markdown.markdown(i_f.read(), **filter_args)
            o_f.write(html)
    assert os.path.exists(output_filepath)

def do_xhtml2pdf(input_filepath, output_filepath, output_ext, filter_args):
    from xhtml2pdf import pisa
    with open(input_filepath, 'r') as i_f:
        with open(output_filepath, 'wb') as o_f:
            pisa.CreatePDF(i_f.read(), dest=o_f)

def do_weasyprint(input_filepath, output_filepath, output_ext, filter_args):
    from weasyprint import HTML
    HTML(input_filepath).write_pdf(output_filepath)

def do_pandoc(input_filepath, output_filepath, output_ext, filter_args):
    subprocess.run(['/opt/local/bin/pandoc', input_filepath, '-o', output_filepath] + filter_args,
            capture_output=True, check=True)
