/*
 * Decompiled with CFR 0.152.
 */
package org.sbfc.converter.sbml2xpp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sbfc.converter.GeneralConverter;
import org.sbfc.converter.exceptions.ConversionException;
import org.sbfc.converter.exceptions.ReadModelException;
import org.sbfc.converter.models.GeneralModel;
import org.sbfc.converter.models.SBMLModel;
import org.sbfc.converter.models.XPPModel;
import org.sbfc.converter.sbml2xpp.XPPID;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.AlgebraicRule;
import org.sbml.jsbml.CVTerm;
import org.sbml.jsbml.Compartment;
import org.sbml.jsbml.Delay;
import org.sbml.jsbml.Event;
import org.sbml.jsbml.EventAssignment;
import org.sbml.jsbml.ExplicitRule;
import org.sbml.jsbml.FunctionDefinition;
import org.sbml.jsbml.KineticLaw;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.LocalParameter;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.Parameter;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.Rule;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.SpeciesReference;
import org.sbml.jsbml.StoichiometryMath;
import org.sbml.jsbml.Trigger;
import org.sbml.jsbml.Variable;
import org.sbml.jsbml.util.compilers.ASTNodeCompiler;
import org.sbml.jsbml.util.compilers.FormulaCompilerNoPiecewise;

public class SBML2XPP
extends GeneralConverter {
    private String xppModel;
    private HashMap<Species, String> speciesFluxMap = new HashMap();
    private HashMap<Species, Boolean> isHasSubstanceUnits = new HashMap();
    Vector<String> mathOperators;
    ListOf<SpeciesReference> products;
    ListOf<SpeciesReference> reactants;
    private int nbParameters = 0;
    public static final Pattern idPattern = Pattern.compile("(_|[a-z]|[A-Z])(_|[a-z]|[A-Z]|[0-9])*");
    public static final Pattern plusMinusPattern = Pattern.compile("(\\+\\ \\-)");
    Model sbmlModel;
    private FormulaCompilerNoPiecewise xppFormulaCompiler = new FormulaCompilerNoPiecewise();

    private String createHeader() {
        String xppModel = "\n#\n# This file is automatically generated with \n# the System Biology Format Converter (http://sbfc.sourceforge.net/)\n# from an SBML file.\n#\n";
        String modelName = this.sbmlModel.getName();
        if (modelName == null || modelName.trim().length() == 0) {
            modelName = this.sbmlModel.getId();
        }
        xppModel = xppModel + "\n#\n# Model name = " + modelName + "\n#\n";
        for (CVTerm cvTerm : this.sbmlModel.getCVTerms()) {
            if (!cvTerm.isModelQualifier()) continue;
            for (String uri : cvTerm.getResources()) {
                xppModel = xppModel + "# " + cvTerm.getModelQualifierType().getElementNameEquivalent() + " " + uri + "\n";
            }
        }
        xppModel = xppModel + "#\n";
        return xppModel;
    }

    public XPPModel xppExport(SBMLModel sbmlmodel) throws SBMLException, ConversionException, ReadModelException {
        System.out.println("SBML2XPP : xppExport : Export in progress...");
        this.sbmlModel = sbmlmodel.getModel();
        if (this.sbmlModel == null) {
            throw new SBMLException("SBML2XPP: Input file is not a regular SBML file.");
        }
        this.xppModel = this.createHeader();
        this.xppModel = this.xppModel + "\n# some function definitions that are allowed in SBML but not valid in xpp\n";
        this.xppModel = this.xppModel + "ceil(x)=flr(1+x)\n";
        this.xppModel = this.xppModel + "\n@delay=50\n";
        ListOf functiondefinitions = this.sbmlModel.getListOfFunctionDefinitions();
        ListOf compartments = this.sbmlModel.getListOfCompartments();
        ListOf listOfSpecies = this.sbmlModel.getListOfSpecies();
        ListOf parameters = this.sbmlModel.getListOfParameters();
        ListOf rules = this.sbmlModel.getListOfRules();
        ListOf reactions = this.sbmlModel.getListOfReactions();
        ListOf events = this.sbmlModel.getListOfEvents();
        this.mathOperators = new Vector();
        this.mathOperators.add("exp");
        this.mathOperators.add("pow");
        this.mathOperators.add("root");
        this.mathOperators.add("sqrt");
        this.mathOperators.add("eq");
        this.mathOperators.add("neq");
        this.mathOperators.add("gt");
        this.mathOperators.add("geq");
        this.mathOperators.add("lt");
        this.mathOperators.add("leq");
        this.mathOperators.add("sin");
        this.mathOperators.add("cos");
        this.mathOperators.add("tan");
        this.mathOperators.add("atan2");
        this.mathOperators.add("asin");
        this.mathOperators.add("acos");
        this.mathOperators.add("atan");
        this.mathOperators.add("sinh");
        this.mathOperators.add("cosh");
        this.mathOperators.add("tanh");
        this.mathOperators.add("log");
        this.mathOperators.add("log10");
        this.mathOperators.add("ln");
        this.mathOperators.add("abs");
        this.mathOperators.add("pi");
        this.mathOperators.add("time");
        this.mathOperators.add("Time");
        this.mathOperators.add("delay");
        this.mathOperators.add("ceil");
        this.mathOperators.add("flr");
        this.mathOperators.add("e");
        this.mathOperators.add("E");
        this.mathOperators.add("t");
        this.mathOperators.add("if");
        this.mathOperators.add("then");
        this.mathOperators.add("else");
        this.xppModel = this.xppModel + "\n";
        try {
            for (FunctionDefinition functiondefinition : functiondefinitions) {
                this.buildIdMap((SBase)functiondefinition);
                String funcdefin = this.printFunctionDefinition(functiondefinition);
                this.xppModel = this.xppModel + "\n# FunctionDefinition id = " + functiondefinition.getId();
                this.xppModel = functiondefinition.isSetName() ? this.xppModel + ", name = " + functiondefinition.getName() + "\n" : this.xppModel + "\n";
                if (funcdefin == null) {
                    System.out.println("Inconsistent mathML operators in Function Definition");
                    this.xppModel = this.xppModel + "# Inconsistent mathML operators in Function Definition, function ignored";
                    continue;
                }
                this.xppModel = this.xppModel + funcdefin + "\n\n";
            }
            for (Compartment compartment : compartments) {
                this.buildIdMap((SBase)compartment);
                if (compartment.isConstant()) {
                    ++this.nbParameters;
                    this.xppModel = this.xppModel + "\n";
                    this.xppModel = this.xppModel + this.printConstantCompartment(compartment);
                    continue;
                }
                this.xppModel = this.xppModel + this.printCompartment(compartment);
            }
            for (Parameter parameter : parameters) {
                this.buildIdMap((SBase)parameter);
                if (parameter.isConstant()) {
                    ++this.nbParameters;
                    this.xppModel = this.xppModel + this.printConstantParameter(parameter);
                    continue;
                }
                this.xppModel = this.xppModel + this.printParameter(parameter);
            }
            for (Species species : listOfSpecies) {
                this.buildIdMap((SBase)species);
                if (!species.isHasOnlySubstanceUnits()) {
                    if (species.getCompartmentInstance().getSpatialDimensions() > 0.0) {
                        this.isHasSubstanceUnits.put(species, false);
                    }
                    if (species.getCompartmentInstance().getSpatialDimensions() != 0.0) continue;
                    this.isHasSubstanceUnits.put(species, true);
                    continue;
                }
                if (!species.isHasOnlySubstanceUnits()) continue;
                this.isHasSubstanceUnits.put(species, true);
            }
            for (Reaction reaction : reactions) {
                this.buildIdMap((SBase)reaction);
            }
            for (Rule rule : rules) {
                String rulemath = null;
                rulemath = rule instanceof AlgebraicRule ? this.printAlgebraicRule(rule) : this.printRule((ExplicitRule)rule);
                if (rulemath == null) {
                    System.out.println("Inconsistent mathML operators in Rule : " + rule.toString());
                    continue;
                }
                this.xppModel = this.xppModel + rulemath;
            }
            for (Reaction reaction : reactions) {
                StoichiometryMath stoichiometryMath;
                double stoichiometry;
                String stoichiometryStr;
                String speciesFlux;
                Species species;
                String reactionmath = this.printReaction(reaction);
                if (reactionmath == null) {
                    System.out.println("Inconsistent mathML operators in Reaction " + reaction.getId());
                    this.xppModel = this.xppModel + "# Inconsistent mathML operators in Reaction " + reaction.getId();
                } else {
                    this.xppModel = this.xppModel + reactionmath;
                }
                this.products = reaction.getListOfProducts();
                this.reactants = reaction.getListOfReactants();
                for (SpeciesReference reactant : this.reactants) {
                    species = reactant.getSpeciesInstance();
                    speciesFlux = this.speciesFluxMap.get(species);
                    stoichiometryStr = "1";
                    stoichiometry = reactant.getStoichiometry();
                    stoichiometryMath = reactant.getStoichiometryMath();
                    if (stoichiometryMath != null && stoichiometryMath.isSetMath()) {
                        stoichiometryStr = stoichiometryMath.getMath().toFormula();
                    } else if (stoichiometry != 0.0) {
                        stoichiometryStr = Double.toString(stoichiometry);
                    }
                    if (speciesFlux == null) {
                        speciesFlux = new String();
                    }
                    if (speciesFlux.length() != 0) {
                        speciesFlux = speciesFlux + " + ";
                    }
                    speciesFlux = speciesFlux + "(-" + stoichiometryStr + " * " + XPPID.getXPPId(reaction.getId()) + ")";
                    this.speciesFluxMap.put(species, speciesFlux);
                    System.out.println("Reactant flux map : id = " + species.getId());
                }
                for (SpeciesReference product : this.products) {
                    species = product.getSpeciesInstance();
                    speciesFlux = this.speciesFluxMap.get(species);
                    stoichiometryStr = "1";
                    stoichiometry = product.getStoichiometry();
                    stoichiometryMath = product.getStoichiometryMath();
                    if (stoichiometryMath != null && stoichiometryMath.isSetMath()) {
                        stoichiometryStr = stoichiometryMath.getMath().toFormula();
                    } else if (stoichiometry != 0.0) {
                        stoichiometryStr = Double.toString(stoichiometry);
                    }
                    if (speciesFlux == null) {
                        speciesFlux = new String();
                    }
                    if (speciesFlux.length() != 0) {
                        speciesFlux = speciesFlux + " + ";
                    }
                    speciesFlux = speciesFlux + "( " + stoichiometryStr + " * " + XPPID.getXPPId(reaction.getId()) + ")";
                    this.speciesFluxMap.put(species, speciesFlux);
                }
            }
            for (Species species : listOfSpecies) {
                if (species.isConstant()) {
                    ++this.nbParameters;
                    this.xppModel = this.xppModel + this.printConstantSpecies(species);
                    continue;
                }
                String speciesmath = this.printSpecies(species);
                if (speciesmath == null) {
                    System.out.println("Inconsistent mathML operator in species " + species.getId());
                    continue;
                }
                this.xppModel = this.xppModel + speciesmath;
            }
            int i = 1;
            for (Event event : events) {
                this.xppModel = this.xppModel + "\n";
                String eventId = event.getId();
                if (eventId == null || eventId.trim().length() == 0 || !idPattern.matcher(eventId).matches()) {
                    eventId = "event" + i;
                    event.setId(eventId);
                }
                this.xppModel = this.xppModel + "# event : " + eventId + "\n";
                this.buildIdMap((SBase)event);
                ++i;
                Delay delay = event.getDelay();
                Trigger trigger = event.getTrigger();
                ASTNode astTrigger = trigger.getMath();
                String infixASTTrigger = astTrigger.toFormula();
                infixASTTrigger = this.replaceIdInsideFormula(infixASTTrigger);
                if (trigger == null || !trigger.isSetMath()) {
                    this.xppModel = this.xppModel + "# the trigger of this event is null !!!\n";
                    this.xppModel = this.xppModel + "# event ignored.\n";
                    continue;
                }
                if (infixASTTrigger == null) {
                    this.xppModel = this.xppModel + "# the trigger contain some unsupported math elements.\n";
                    this.xppModel = this.xppModel + "# event ignored.\n\n";
                    continue;
                }
                if (delay != null && delay.isSetMath()) {
                    this.xppModel = this.xppModel + "# unable to handle events with delays currently.\n";
                    this.xppModel = this.xppModel + "# event ignored.\n\n";
                    continue;
                }
                this.xppModel = this.xppModel + XPPID.getXPPId(eventId) + "=if (" + infixASTTrigger + ") then (1.5) else (0.2)\n";
                this.xppModel = this.xppModel + "global 1 {" + XPPID.getXPPId(eventId) + " - 1.1} {";
                int j = 1;
                int eventAssignmentSize = event.getNumEventAssignments();
                boolean invalidMath = false;
                for (EventAssignment eventAssignment : event.getListOfEventAssignments()) {
                    String eventAssignmentMath = eventAssignment.getMath().toFormula();
                    if ((eventAssignmentMath = this.replaceIdInsideFormula(eventAssignmentMath)) == null) {
                        invalidMath = true;
                        if (j < eventAssignmentSize) continue;
                        this.xppModel = this.xppModel + "}\n";
                        continue;
                    }
                    this.xppModel = this.xppModel + eventAssignment.getVariable() + "=" + eventAssignmentMath;
                    this.xppModel = j < eventAssignmentSize ? this.xppModel + ";" : this.xppModel + "}\n";
                    ++j;
                }
                if (eventAssignmentSize == 0) {
                    this.xppModel = this.xppModel + "}\n";
                }
                if (!invalidMath) continue;
                this.xppModel = this.xppModel + "# some eventAssignment contained some unsupported math elements.\n";
                this.xppModel = this.xppModel + "# the eventAssignment(s) was(were) ignored.\n\n";
            }
            if (this.xppFormulaCompiler.getPiecewiseMap().size() > 0) {
                this.xppModel = this.xppModel + "\n\n# Piecewise functions : the mathML piecewise element is transformed into if/then/else expression\n\n";
                for (String piecewiseId : this.xppFormulaCompiler.getPiecewiseMap().keySet()) {
                    String ifThenElseFormula = (String)this.xppFormulaCompiler.getPiecewiseMap().get(piecewiseId);
                    ifThenElseFormula = this.replaceIdInsideFormula(ifThenElseFormula);
                    System.out.println(" " + piecewiseId + " = " + (String)this.xppFormulaCompiler.getPiecewiseMap().get(piecewiseId));
                    if (ifThenElseFormula != null) {
                        this.xppModel = this.xppModel + piecewiseId + "=" + ifThenElseFormula + "\n\n";
                        continue;
                    }
                    this.xppModel = this.xppModel + "# Inconsistent mathML operators found in piecewise \n";
                    this.xppModel = this.xppModel + "# formula is : " + ifThenElseFormula + " \n";
                }
            }
            this.xppModel = this.xppModel + "\n@ meth=cvode, tol=1e-6, atol=1e-8\n# @ maxstor=1e6\n@ bound=40000, total=200\ndone\n";
        }
        catch (AssertionError err) {
            this.xppModel = this.createHeader();
            this.xppModel = this.xppModel + "\n#\n# " + ((Throwable)((Object)err)).getMessage() + "\n#\n";
        }
        XPPModel xppReturnModel = new XPPModel();
        xppReturnModel.setModelFromString(this.xppModel);
        return xppReturnModel;
    }

    private String translatePiecewise(String infixFormula, ASTNode astNode) {
        int indexPiecewise = (infixFormula = infixFormula.trim()).indexOf("piecewise");
        if (indexPiecewise != -1) {
            System.out.println("SBML2XPP : translatePiecewise : initial formula = " + infixFormula);
            try {
                infixFormula = astNode.compile((ASTNodeCompiler)this.xppFormulaCompiler).toString();
            }
            catch (SBMLException e) {
                e.printStackTrace();
            }
            System.out.println("SBML2XPP : translatePiecewise : translated formula = \n" + infixFormula);
        }
        return infixFormula;
    }

    private String printFunctionDefinition(FunctionDefinition functiondefinition) throws SBMLException {
        String inputformula = functiondefinition.getMath().toFormula();
        System.out.println("SBML2XPP : printFunctionDefinition : jsbml original math = " + inputformula);
        inputformula = inputformula.replace("lambda(", "");
        ArrayList<String> functionParameters = new ArrayList<String>();
        StringTokenizer stcomma = new StringTokenizer(inputformula, ",");
        StringBuilder funcDef = new StringBuilder();
        StringBuilder formula = new StringBuilder();
        formula.append("(");
        int count = 0;
        int stCommaNb = stcomma.countTokens();
        while (stcomma.hasMoreTokens()) {
            String read = stcomma.nextToken().trim();
            ++count;
            if (read.contains(" ") || read.contains(" * ") || read.contains("/") || read.contains(")") || read.contains("(")) {
                formula.append(read);
                if (count >= stCommaNb) continue;
                formula.append(",");
                continue;
            }
            functionParameters.add(read);
        }
        String functionname = functiondefinition.getId();
        String xppid = XPPID.getXPPId(functionname);
        funcDef.append(xppid + "(");
        for (int i = 0; i < functionParameters.size(); ++i) {
            if (i < functionParameters.size() - 1) {
                funcDef.append((String)functionParameters.get(i) + ",");
                continue;
            }
            funcDef.append((String)functionParameters.get(i));
        }
        String formulaStr = this.replaceIdInsideFormula(formula.toString());
        funcDef.append(")=" + formulaStr);
        System.out.println("FunctionDefinition : id = " + functiondefinition.getId());
        System.out.println("FunctionDefinition : xpp version = " + funcDef.toString());
        if (this.matchMath(formulaStr, functionParameters, funcDef)) {
            return funcDef.toString();
        }
        String error = null;
        return error;
    }

    private boolean matchMath(String formula, ArrayList<String> additionalValidNames, StringBuilder xppSB) {
        boolean support = true;
        Matcher mathMatcher = idPattern.matcher(formula);
        ArrayList<String> checkoperator = new ArrayList<String>();
        while (mathMatcher.find()) {
            checkoperator.add(mathMatcher.group());
        }
        for (String check : checkoperator) {
            if (XPPID.getSBMLId(check) != null || this.mathOperators.contains(check) || check.startsWith("piecew") || additionalValidNames != null && additionalValidNames.contains(check)) continue;
            System.out.println("SBML2XPP : matchMath : the operator " + check + " is not supported by xpp");
            System.out.println("SBML2XPP : matchMath : the formula is : " + formula);
            xppSB.append("# the operator " + check + " is not supported by xpp\n");
            xppSB.append("# the formula is : " + formula + "\n");
            support = false;
        }
        return support;
    }

    private boolean matchMath(String formula, StringBuilder xppSB) {
        boolean support = true;
        Matcher mathMatcher = idPattern.matcher(formula);
        ArrayList<String> checkoperators = new ArrayList<String>();
        while (mathMatcher.find()) {
            checkoperators.add(mathMatcher.group());
        }
        for (String check : checkoperators) {
            if (XPPID.getSBMLId(check) != null || this.mathOperators.contains(check) || check.startsWith("piecew")) continue;
            System.out.println("SBML2XPP : matchMath : the operator " + check + " is not supported by xpp");
            System.out.println("SBML2XPP : matchMath : the formula is : " + formula);
            xppSB.append("# the operator " + check + " is not supported by xpp\n");
            xppSB.append("# the formula is : " + formula + "\n");
            support = false;
        }
        return support;
    }

    private String printReaction(Reaction reaction) throws SBMLException {
        StringBuilder reactionStr = new StringBuilder();
        String reactionId = reaction.getId();
        reactionStr.append("\n# Reaction: id = " + reactionId);
        if (reaction.getName() != null && reaction.getName().trim().length() != 0) {
            reactionStr.append(", name = " + reaction.getName());
        }
        reactionStr.append("\n");
        KineticLaw kineticLaw = reaction.getKineticLaw();
        String kineticLawStr = "";
        if (kineticLaw != null) {
            kineticLawStr = kineticLaw.getMath().toFormula();
            ListOf localParameters = kineticLaw.getListOfParameters();
            for (LocalParameter parameter : localParameters) {
                this.buildIdMap(parameter, reaction);
                String parameterId = parameter.getId();
                String localParameterId = parameterId + "_" + reactionId;
                if (parameter.isSetValue()) {
                    ++this.nbParameters;
                    reactionStr.append(this.printLocalParameter(parameter, localParameterId));
                } else {
                    System.out.println("Warning !! the local parameter " + localParameterId + " is not constant !!");
                }
                kineticLawStr = this.replaceIdInsideFormula(kineticLawStr, parameterId, localParameterId);
            }
        } else {
            throw new AssertionError((Object)"The model cannot be converted as there are some kineticLaw undefined.");
        }
        kineticLawStr = this.replaceIdInsideFormula(kineticLawStr);
        kineticLawStr = this.translatePiecewise(kineticLawStr, kineticLaw.getMath());
        kineticLawStr = this.replacePlusMinusInsideFormula(kineticLawStr);
        reactionStr.append("\n" + XPPID.getXPPId(reaction.getId()) + "=" + kineticLawStr + "\n");
        System.out.println("Reaction : id = " + reactionId);
        if (this.matchMath(kineticLawStr.toString(), reactionStr)) {
            return reactionStr.toString();
        }
        return null;
    }

    private String replaceIdInsideFormula(String formula, String oldId, String newId) {
        StringBuffer formulaWithIdsBuffer = new StringBuffer();
        Matcher formulaMatcher = idPattern.matcher(formula);
        while (formulaMatcher.find()) {
            String id = formulaMatcher.group().trim();
            if (id.equals(oldId)) {
                id = newId;
            }
            formulaMatcher.appendReplacement(formulaWithIdsBuffer, id);
        }
        formulaMatcher.appendTail(formulaWithIdsBuffer);
        return formulaWithIdsBuffer.toString();
    }

    private String replaceIdInsideFormula(String formula) {
        StringBuffer formulaWithIdsBuffer = new StringBuffer();
        Matcher formulaMatcher = idPattern.matcher(formula);
        while (formulaMatcher.find()) {
            String id = formulaMatcher.group().trim();
            String newId = XPPID.getXPPId(id);
            if (newId == null) continue;
            formulaMatcher.appendReplacement(formulaWithIdsBuffer, newId);
        }
        formulaMatcher.appendTail(formulaWithIdsBuffer);
        return formulaWithIdsBuffer.toString();
    }

    private String replacePlusMinusInsideFormula(String formula) {
        StringBuffer formulaWithIdsBuffer = new StringBuffer();
        Matcher formulaMatcher = plusMinusPattern.matcher(formula);
        while (formulaMatcher.find()) {
            formulaMatcher.appendReplacement(formulaWithIdsBuffer, "- ");
        }
        formulaMatcher.appendTail(formulaWithIdsBuffer);
        return formulaWithIdsBuffer.toString();
    }

    private String printLocalParameter(LocalParameter parameter, String id) {
        StringBuilder paramStr = new StringBuilder();
        paramStr.append(this.printLocalParameterComment(parameter));
        String xppId = XPPID.getXPPId(id);
        paramStr.append("par " + xppId + "=" + parameter.getValue() + "\n\n");
        return paramStr.toString();
    }

    private String printRule(ExplicitRule rule) throws SBMLException {
        StringBuilder ruleStr = new StringBuilder();
        String variableId = rule.getVariable();
        Variable variable = rule.getVariableInstance();
        String xppId = XPPID.getXPPId(variableId);
        String mathMLStr = rule.getMath().toFormula();
        mathMLStr = this.replaceIdInsideFormula(mathMLStr);
        mathMLStr = this.translatePiecewise(mathMLStr, rule.getMath());
        System.out.println("Rule : variable = " + variableId);
        ruleStr.append("\n# " + rule.getElementName() + ": variable = " + variableId + "\n");
        if (this.matchMath(mathMLStr, ruleStr)) {
            if (variable.isSetValue() && rule.isRate()) {
                String initialValue = "" + variable.getValue();
                ruleStr.append("init " + xppId + "=" + initialValue + "\n");
            }
            if (rule.isRate()) {
                ruleStr.append("d" + xppId + "/dt=" + mathMLStr + "\n");
            } else if (rule.isAssignment()) {
                ruleStr.append("" + xppId + "=" + mathMLStr + "\n");
                ruleStr.append("aux " + xppId + "=" + xppId + "\n");
            }
        } else {
            System.out.println("Rule " + variableId + " ignored : there are some unsupported functions !!");
            ruleStr.append("#Rule ignored : there are some unsupported functions !!\n");
        }
        return ruleStr.toString();
    }

    private String printAlgebraicRule(Rule rule) throws SBMLException {
        StringBuilder ruleStr = new StringBuilder();
        String mathMLStr = rule.getMath().toFormula();
        mathMLStr = this.replaceIdInsideFormula(mathMLStr);
        System.out.println("Algebraic Rule");
        if (this.matchMath(mathMLStr, ruleStr)) {
            ruleStr.append("# " + rule.getElementName() + "\n");
            ruleStr.append("# Warning, " + rule.getElementName() + " are not supported at the moment.\n");
            ruleStr.append("# " + mathMLStr + " = 0\n");
            return ruleStr.toString();
        }
        return null;
    }

    private String printSpecies(Species species) {
        StringBuilder speciesStr = new StringBuilder();
        String checkmath = null;
        speciesStr.append(this.printSpeciesComment(species));
        String id = species.getId();
        boolean isAffectedByRule = false;
        boolean needInit = true;
        boolean auxDeclaration = false;
        for (Rule rule : this.sbmlModel.getListOfRules()) {
            if (!(rule instanceof ExplicitRule) || !id.equals(((ExplicitRule)rule).getVariable())) continue;
            isAffectedByRule = true;
            needInit = false;
        }
        id = XPPID.getXPPId(species.getId());
        String xppModifier = "init ";
        if (!isAffectedByRule && (!this.hasReaction(id) || this.hasReaction(id) && species.isBoundaryCondition())) {
            xppModifier = "par ";
            auxDeclaration = true;
        }
        if (needInit) {
            if (species.isSetInitialAmount() && species.isSetInitialConcentration()) {
                throw new AssertionError((Object)"Error in model, both Initial concentration and Initial amount defined");
            }
            if (species.isSetInitialAmount()) {
                speciesStr.append(xppModifier + id + "=" + species.getInitialAmount() + "\n");
            } else if (species.isSetInitialConcentration()) {
                speciesStr.append(xppModifier + id + "=" + species.getInitialConcentration() + "\n");
            } else {
                speciesStr.append("#WARNING : no initial state for this species\n");
                speciesStr.append(xppModifier + id + "=0\n");
            }
        }
        if (auxDeclaration) {
            speciesStr.append("aux " + id + "=" + id + "\n");
        }
        if (species.isBoundaryCondition()) {
            if (!isAffectedByRule && !this.hasEvent(species.getId())) {
                speciesStr.append("#WARNING speciesID: " + species.getId() + ", constant= false " + " , boundaryCondition = " + species.isBoundaryCondition() + " but is not involved in assignmentRule, rateRule or events !" + "\n");
            }
        } else if (!species.isBoundaryCondition() && !isAffectedByRule) {
            if (this.speciesFluxMap.get(species) != null && !this.isHasSubstanceUnits.get(species).booleanValue()) {
                String sbmlId = species.getCompartmentInstance().getId();
                String xppId = XPPID.getXPPId(sbmlId);
                checkmath = " (1/(" + xppId + "))*(" + this.speciesFluxMap.get(species) + ")";
                speciesStr.append("d" + id + "/dt=" + "(1/(" + xppId + "))*(" + this.speciesFluxMap.get(species) + ")\n");
            } else if (this.speciesFluxMap.get(species) != null) {
                speciesStr.append("d" + id + "/dt=" + this.speciesFluxMap.get(species) + "\n");
            }
        }
        if (checkmath != null) {
            if (this.matchMath(checkmath, speciesStr)) {
                return speciesStr.toString();
            }
            return null;
        }
        return speciesStr.toString();
    }

    private boolean hasRule(String id) {
        for (Rule rule : this.sbmlModel.getListOfRules()) {
            if (!(rule instanceof ExplicitRule) || !id.equals(((ExplicitRule)rule).getVariable())) continue;
            return true;
        }
        return false;
    }

    private boolean hasEvent(String id) {
        for (Event event : this.sbmlModel.getListOfEvents()) {
            for (EventAssignment eventAssgnt : event.getListOfEventAssignments()) {
                if (!eventAssgnt.getVariable().equals(id)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasReaction(String id) {
        for (Reaction reaction : this.sbmlModel.getListOfReactions()) {
            for (SpeciesReference speciesRef : reaction.getListOfReactants()) {
                if (!speciesRef.getSpecies().equals(id)) continue;
                return true;
            }
            for (SpeciesReference speciesRef : reaction.getListOfProducts()) {
                if (!speciesRef.getSpecies().equals(id)) continue;
                return true;
            }
        }
        return false;
    }

    private String printConstantSpecies(Species species) {
        StringBuilder speciesStr = new StringBuilder();
        speciesStr.append(this.printSpeciesComment(species));
        String id = XPPID.getXPPId(species.getId());
        if (species.isSetInitialAmount() && species.isSetInitialConcentration()) {
            throw new AssertionError((Object)"Error in model, both Initial concentration and Initial amount defined");
        }
        if (species.isSetInitialAmount()) {
            speciesStr.append("par " + id + "=" + species.getInitialAmount() + "\n\n");
        } else if (species.isSetInitialConcentration()) {
            speciesStr.append("par " + id + "=" + species.getInitialConcentration() + "\n\n");
        }
        return speciesStr.toString();
    }

    private String printSpeciesComment(Species species) {
        StringBuilder commentStr = new StringBuilder();
        String id = species.getId();
        String name = species.getName();
        if (name == null || name.trim().length() == 0) {
            name = id;
        }
        commentStr.append("\n# Species: ");
        commentStr.append("  id = " + id);
        commentStr.append(", name = " + name);
        if (species.isConstant()) {
            commentStr.append(", constant");
        } else {
            if (species.isBoundaryCondition()) {
                if (this.hasRule(id)) {
                    commentStr.append(", involved in a rule ");
                } else if (!this.hasRule(id)) {
                    // empty if block
                }
            } else if (!species.isBoundaryCondition()) {
                if (this.hasRule(id)) {
                    commentStr.append(", defined in a rule ");
                } else if (this.speciesFluxMap.get(species) != null) {
                    commentStr.append(", affected by kineticLaw\n");
                } else {
                    commentStr.append("\n# Warning species is not changed by either rules or reactions\n");
                }
            }
            int nbEvent = this.getNbAffectingEvent((SBase)species);
            if (nbEvent > 0) {
                commentStr.append("# Species is changed by " + nbEvent + " event(s)");
            }
        }
        commentStr.append("\n");
        return commentStr.toString();
    }

    private int getNbAffectingEvent(SBase element) {
        int n = 0;
        if (element instanceof NamedSBase) {
            String elementId = ((NamedSBase)element).getId();
            block0: for (Event event : this.sbmlModel.getListOfEvents()) {
                for (EventAssignment eventAssignment : event.getListOfEventAssignments()) {
                    if (!elementId.equals(eventAssignment.getVariable())) continue;
                    ++n;
                    continue block0;
                }
            }
        }
        return n;
    }

    private String printParameter(Parameter parameter) {
        StringBuilder paramStr = new StringBuilder();
        paramStr.append(this.printParameterComment(parameter));
        boolean hasRule = this.hasRule(parameter.getId());
        if (!hasRule && !this.hasEvent(parameter.getId())) {
            paramStr.append("# Warning parameter " + parameter.getId() + " is not constant, it should be controled by a Rule and/or events" + "\n");
        }
        if (!hasRule) {
            String id = XPPID.getXPPId(parameter.getId());
            paramStr.append("par " + id + "=" + parameter.getValue() + "\n");
        }
        return paramStr.toString();
    }

    private String printConstantParameter(Parameter parameter) {
        StringBuilder paramStr = new StringBuilder();
        paramStr.append(this.printParameterComment(parameter));
        String id = XPPID.getXPPId(parameter.getId());
        paramStr.append("par " + id + "=" + parameter.getValue() + "\n");
        return paramStr.toString();
    }

    private String printParameterComment(Parameter parameter) {
        StringBuilder commentStr = new StringBuilder();
        String id = parameter.getId();
        String name = parameter.getName();
        if (name == null || name.trim().length() == 0) {
            name = id;
        }
        commentStr.append("\n# Parameter: ");
        commentStr.append("  id =  " + id);
        commentStr.append(", name = " + name);
        if (parameter.isConstant()) {
            commentStr.append(", constant");
        }
        if (this.hasRule(id)) {
            commentStr.append(", defined by a Rule");
        }
        commentStr.append("\n");
        return commentStr.toString();
    }

    private String printLocalParameterComment(LocalParameter parameter) {
        StringBuilder commentStr = new StringBuilder();
        String id = parameter.getId();
        String name = parameter.getName();
        if (name == null || name.trim().length() == 0) {
            name = id;
        }
        commentStr.append("# Local Parameter: ");
        commentStr.append("  id =  " + id);
        commentStr.append(", name = " + name);
        commentStr.append("\n");
        return commentStr.toString();
    }

    private String printCompartment(Compartment compartment) {
        StringBuilder compStr = new StringBuilder();
        compStr.append(this.printCompartmentComment(compartment));
        if (!this.hasRule(compartment.getId())) {
            compStr.append("# Warning compartment " + compartment.getId() + " has no rule and is not constant" + "\n");
        }
        return compStr.toString();
    }

    private String printCompartmentComment(Compartment compartment) {
        StringBuilder compCommentStr = new StringBuilder();
        String id = compartment.getId();
        String name = compartment.getName();
        if (name == null || name.trim().length() == 0) {
            name = id;
        }
        compCommentStr.append("# Compartment: id = " + id + ", name = " + name);
        if (compartment.isConstant()) {
            compCommentStr.append(", constant");
        } else if (this.hasRule(id)) {
            compCommentStr.append(", defined by a Rule");
        }
        compCommentStr.append("\n");
        return compCommentStr.toString();
    }

    private String printConstantCompartment(Compartment compartment) {
        StringBuilder compStr = new StringBuilder();
        compStr.append(this.printCompartmentComment(compartment));
        String id = XPPID.getXPPId(compartment.getId());
        compStr.append("par " + id + "=" + compartment.getSize() + "\n");
        return compStr.toString();
    }

    private void buildIdMap(SBase element) {
        String id = ((NamedSBase)element).getId();
        XPPID xppId = new XPPID(id);
        xppId.checkXPPId();
    }

    private void buildIdMap(LocalParameter parameter, Reaction reaction) {
        String id = parameter.getId();
        XPPID xppId = new XPPID(id, reaction.getId());
        xppId.checkXPPId();
    }

    @Override
    public GeneralModel convert(GeneralModel model) throws ConversionException, ReadModelException {
        try {
            this.inputModel = model;
            return this.xppExport((SBMLModel)model);
        }
        catch (SBMLException e) {
            throw new ReadModelException(e);
        }
        catch (ReadModelException e) {
            throw e;
        }
        catch (ConversionException e) {
            throw e;
        }
    }

    @Override
    public String getResultExtension() {
        return ".xpp";
    }

    @Override
    public String getName() {
        return "SBML2XPP";
    }

    @Override
    public String getDescription() {
        return "It converts a model format from SBML to XPP";
    }

    @Override
    public String getHtmlDescription() {
        return "It converts a model format from SBML to XPP";
    }
}

