/*
 * Decompiled with CFR 0.152.
 */
package org.sbfc.converter.sbml2sbml;

import org.sbfc.converter.GeneralConverter;
import org.sbfc.converter.exceptions.ConversionException;
import org.sbfc.converter.exceptions.ReadModelException;
import org.sbfc.converter.exceptions.WriteModelException;
import org.sbfc.converter.models.GeneralModel;
import org.sbfc.converter.models.SBMLModel;
import org.sbml.libsbml.SBMLDocument;
import org.sbml.libsbml.SBMLReader;
import org.sbml.libsbml.SBMLWriter;

public class SBML2SBML
extends GeneralConverter {
    int targetLevel = -1;
    int targetVersion = -1;
    private static boolean isLibSBMLAvailable = false;

    @Override
    public GeneralModel convert(GeneralModel model) throws ConversionException, ReadModelException {
        if (!(model instanceof SBMLModel)) {
            return null;
        }
        this.inputModel = model;
        SBMLModel sbmlModel = (SBMLModel)model;
        org.sbml.jsbml.SBMLDocument sbmlDocument = sbmlModel.getSBMLDocument();
        int currentLevel = sbmlDocument.getLevel();
        int currentVersion = sbmlDocument.getVersion();
        try {
            this.targetLevel = Integer.parseInt((String)this.options.get("sbml.target.level"));
            this.targetVersion = Integer.parseInt((String)this.options.get("sbml.target.version"));
        }
        catch (NumberFormatException e) {
            System.out.println("SBML2SBML : cannot read the target level and version : " + e.getMessage());
            return null;
        }
        if (this.targetLevel != currentLevel || this.targetVersion != currentVersion) {
            String currentSBML;
            try {
                currentSBML = sbmlModel.modelToString();
                System.out.println("SBML2SBML : current model size = " + currentSBML.length());
            }
            catch (WriteModelException e1) {
                e1.printStackTrace();
                return null;
            }
            if (isLibSBMLAvailable) {
                SBMLReader libSBMLReader = new SBMLReader();
                SBMLDocument libSBMLdoc = libSBMLReader.readSBMLFromString(currentSBML);
                System.out.println("SBML2SBML : trying to convert to SBML level " + this.targetLevel + " version " + this.targetVersion);
                System.out.println("SBML2SBML : L1V2 compatibility = " + libSBMLdoc.checkL1Compatibility());
                boolean isSetLVSuccesfull = libSBMLdoc.setLevelAndVersion((long)this.targetLevel, (long)this.targetVersion);
                System.out.println("SBML2SBML : setLevelAndVersion worked = " + isSetLVSuccesfull);
                if (!isSetLVSuccesfull) {
                    System.out.println("SBML2SBML - Conversion was not possible, here are the errors returned by libSBML:");
                    libSBMLdoc.printErrors();
                }
                SBMLWriter libSBMLWriter = new SBMLWriter();
                String targetSBML = libSBMLWriter.writeSBMLToString(libSBMLdoc);
                SBMLModel targetModel = new SBMLModel();
                try {
                    targetModel.modelFromString(targetSBML);
                    return targetModel;
                }
                catch (ReadModelException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return null;
        }
        return model;
    }

    @Override
    public String getResultExtension() {
        return "-L" + this.targetLevel + "V" + this.targetVersion + ".xml";
    }

    @Override
    public String getName() {
        return "SBML2SBML";
    }

    @Override
    public String getDescription() {
        return "Converts an SBML model format to another with different Level/Version";
    }

    @Override
    public String getHtmlDescription() {
        return "Converts an SBML model format to another with different Level/Version";
    }

    static {
        try {
            System.loadLibrary("sbmlj");
            Class.forName("org.sbml.libsbml.libsbml");
            isLibSBMLAvailable = true;
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (UnsatisfiedLinkError e) {
            throw new RuntimeException("You need to install libsbml before being able to use the SBML2SBML converter.", e);
        }
        catch (ClassNotFoundException e) {
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            System.out.println("Could not load libsbml.\n Control that the libsbmlj.jar that you are using is synchronized with your current libSBML installation.");
        }
    }
}

