/*
 * Decompiled with CFR 0.152.
 */
package org.sbfc.converter.sbml2sbml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.identifiers.registry.RegistryLocalProvider;
import org.identifiers.registry.RegistryUtilities;
import org.sbml.jsbml.CVTerm;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.xml.stax.SBMLReader;
import org.sbml.jsbml.xml.stax.SBMLWriter;

public class IdentifiersUtil {
    private static final String EC_CODE_NAME = "Enzyme Nomenclature";
    private static String urnPrefix = "urn:miriam";
    private static String urlPrefix = "http://identifiers.org";
    private static RegistryLocalProvider link = new RegistryLocalProvider();

    private static void sBaseAnnotationsUpdate(SBase sbase, String annotationPrefix) {
        if (sbase.getCVTermCount() > 0) {
            boolean urn2url = false;
            boolean url2urn = false;
            boolean update = false;
            if (annotationPrefix == null) {
                update = true;
            } else if (annotationPrefix.equals(urlPrefix)) {
                urn2url = true;
            } else if (annotationPrefix.equals(urnPrefix)) {
                url2urn = true;
            }
            for (CVTerm cvTerm : sbase.getCVTerms()) {
                List uris = cvTerm.getResources();
                ArrayList<String> updatedUris = new ArrayList<String>();
                boolean updated = false;
                Iterator iterator = uris.iterator();
                while (iterator.hasNext()) {
                    String annotationString;
                    String newURI = annotationString = (String)iterator.next();
                    String databaseId = RegistryUtilities.getElementPart((String)annotationString);
                    String databasePart = RegistryUtilities.getDataPart((String)annotationString);
                    String databaseName = link.getName(databasePart);
                    boolean deleteAnnotation = false;
                    if ((databaseId == null || databaseId.trim().length() == 0) && databaseName != null && databaseName.equals(EC_CODE_NAME)) {
                        updated = true;
                        deleteAnnotation = true;
                        System.out.println("Error : the uri '" + annotationString + "' does not contain any identifier !!");
                    }
                    if (databaseName != null && databaseName.equals(EC_CODE_NAME) && !deleteAnnotation) {
                        if (databaseId.matches("[0-9]+")) {
                            System.out.print("Warning : adding '.-' to the ec-code uri '" + annotationString + "'.");
                            annotationString = annotationString + ".-.-.-";
                            System.out.println(" ==> '" + annotationString + "'.");
                        } else if (databaseId.matches("[0-9]+\\.[0-9]+")) {
                            System.out.print("Warning : adding '.-' to the ec-code uri '" + annotationString + "'.");
                            annotationString = annotationString + ".-.-";
                            System.out.println(" ==> '" + annotationString + "'.");
                        } else if (databaseId.matches("[0-9]+\\.[0-9]+\\.[0-9]+")) {
                            System.out.print("Warning : adding '.-' to the ec-code uri '" + annotationString + "'.");
                            annotationString = annotationString + ".-";
                            System.out.println(" ==> '" + annotationString + "'.");
                        } else if (databaseId.matches("[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9A-Z]+") && !databaseId.matches("[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+")) {
                            System.out.print("Warning : adding '.-' to the ec-code uri '" + annotationString + "'.");
                            annotationString = annotationString.substring(0, annotationString.lastIndexOf(".")) + ".-";
                            System.out.println(" ==> '" + annotationString + "'.");
                        }
                    }
                    if (url2urn || urn2url && !annotationString.startsWith(annotationPrefix)) {
                        if (url2urn) {
                            newURI = link.convertURL(annotationString);
                        } else if (urn2url) {
                            newURI = link.convertURN(annotationString);
                        }
                    } else if (update || annotationString.startsWith(annotationPrefix)) {
                        newURI = link.getMiriamURI(annotationString);
                    }
                    if (newURI == null && !deleteAnnotation) {
                        System.out.println("Error : the uri '" + annotationString + "' is not recognized by miriamws !!");
                        newURI = annotationString;
                    } else if (!deleteAnnotation && !newURI.equals(annotationString)) {
                        updated = true;
                    }
                    if (deleteAnnotation) continue;
                    updatedUris.add(newURI);
                }
                if (!updated) continue;
                uris.clear();
                uris.addAll(updatedUris);
            }
        }
        if (sbase.getChildCount() > 0) {
            for (Object treeNode : Collections.list(sbase.children())) {
                if (!(treeNode instanceof SBase)) continue;
                IdentifiersUtil.sBaseAnnotationsUpdate((SBase)treeNode, annotationPrefix);
            }
        }
    }

    public static SBMLDocument urnToUrl(SBMLDocument doc) {
        return IdentifiersUtil.documentAnnotationsUpdate(doc, urlPrefix);
    }

    public static SBMLDocument urlToUrn(SBMLDocument doc) {
        return IdentifiersUtil.documentAnnotationsUpdate(doc, urnPrefix);
    }

    public static SBMLDocument updateAnnotations(SBMLDocument doc) {
        return IdentifiersUtil.documentAnnotationsUpdate(doc, null);
    }

    private static SBMLDocument documentAnnotationsUpdate(SBMLDocument doc, String annotationPrefix) {
        IdentifiersUtil.sBaseAnnotationsUpdate((SBase)doc, annotationPrefix);
        Model model = doc.getModel();
        IdentifiersUtil.sBaseAnnotationsUpdate((SBase)model, annotationPrefix);
        return doc;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage : java org.sbfc.converter.sbml2sbml.IdentifiersUtil [-m|-i|-u] sbmlFileName [suffix]");
            System.out.println("\n\t\tThe order of the options is important.");
            System.out.println("\n\t\t-m will update the given sbml file to use miriam urn-uris");
            System.out.println("\n\t\t-i will update the given sbml file to use miriam url-uris (identifiers.org urls)");
            System.out.println("\n\t\t-u will update the given sbml file to the correct and up-to-date miriam urn-uris");
            System.exit(1);
        }
        long init = Calendar.getInstance().getTimeInMillis();
        System.out.println(Calendar.getInstance().getTime());
        String annoPrefixOption = args[0];
        String annotationPrefix = urlPrefix;
        String fileName = args[1];
        String fileNameSuffix = "-identifiers.org";
        if (annoPrefixOption.equals("-m")) {
            fileNameSuffix = "-miriam-urn";
            annotationPrefix = urnPrefix;
        } else if (annoPrefixOption.equals("-u")) {
            fileNameSuffix = "-updated-annotations";
            annotationPrefix = null;
        }
        if (args.length >= 3) {
            fileNameSuffix = args[2];
        }
        String jsbmlWriteFileName = fileName.replaceFirst(".xml", fileNameSuffix + ".xml");
        System.out.printf("Reading %s and writing %s\n", fileName, jsbmlWriteFileName);
        long afterRead = 0L;
        long afterAnnoUpdate = 0L;
        try {
            SBMLDocument testDocument = new SBMLReader().readSBMLFile(fileName);
            System.out.printf("Reading done\n", new Object[0]);
            System.out.println(Calendar.getInstance().getTime());
            afterRead = Calendar.getInstance().getTimeInMillis();
            IdentifiersUtil.documentAnnotationsUpdate(testDocument, annotationPrefix);
            afterAnnoUpdate = Calendar.getInstance().getTimeInMillis();
            System.out.printf("Starting writing\n", new Object[0]);
            new SBMLWriter().write(testDocument, jsbmlWriteFileName);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(Calendar.getInstance().getTime());
        long end = Calendar.getInstance().getTimeInMillis();
        long nbSecondes = (end - init) / 1000L;
        long nbSecondesRead = (afterRead - init) / 1000L;
        long nbSecondesAnnoUpdate = (afterAnnoUpdate - afterRead) / 1000L;
        long nbSecondesWrite = (end - afterAnnoUpdate) / 1000L;
        if (nbSecondes > 120L) {
            System.out.println("It took " + nbSecondes / 60L + " minutes.");
        } else {
            System.out.println("It took " + nbSecondes + " secondes.");
        }
        System.out.println("Reading : " + nbSecondesRead + " secondes.");
        System.out.println("Writing : " + nbSecondesWrite + " secondes, AnnoUpdate : " + nbSecondesAnnoUpdate + " secondes.");
    }

    public static String anyStringAnnotationsUpdate(String anyURI) {
        return link.getMiriamURI(anyURI);
    }
}

