/*
 * Decompiled with CFR 0.152.
 */
package org.sbfc.converter.sbml2sbgnml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.sbfc.converter.GeneralConverter;
import org.sbfc.converter.exceptions.ConversionException;
import org.sbfc.converter.exceptions.ReadModelException;
import org.sbfc.converter.models.GeneralModel;
import org.sbfc.converter.models.SBGNModel;
import org.sbfc.converter.models.SBMLModel;
import org.sbfc.converter.utils.sbgn.SBGNUtils;
import org.sbgn.SbgnUtil;
import org.sbgn.SbgnVersionFinder;
import org.sbgn.bindings.Arc;
import org.sbgn.bindings.Bbox;
import org.sbgn.bindings.Glyph;
import org.sbgn.bindings.Label;
import org.sbgn.bindings.Map;
import org.sbgn.bindings.Port;
import org.sbgn.bindings.SBGNBase;
import org.sbgn.bindings.Sbgn;
import org.sbml.jsbml.Annotation;
import org.sbml.jsbml.CVTerm;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.ModifierSpeciesReference;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBMLReader;
import org.sbml.jsbml.SBO;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.SpeciesReference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SBML2SBGNML
extends GeneralConverter {
    private static final String SBFCANNO_PREFIX = "sbfcanno";
    public static final String SBFC_ANNO_NAMESPACE = "http://www.sbfc.org/sbfcanno";
    private static final int SPECIES_CARDINALITY_MAX = 4;
    private static int SBGNML_MILESTONE = 2;
    private static Logger logger = Logger.getLogger(SBML2SBGNML.class);
    private Model sbmlModel;
    private static SBGNUtils sbu = new SBGNUtils("sbgnml");
    private java.util.Map<String, Integer> speciesCardinalityMap = new HashMap<String, Integer>();
    private static Properties pro;
    private static HashMap<Integer, String> SBOCloneMap;

    private boolean canBeCloned(Reaction reaction) {
        boolean canBeCloned = false;
        Integer sboTerm = reaction.getSBOTerm();
        if (sboTerm == null) {
            String SBGNclass = SBGNUtils.getSBGNClass((SBase)reaction);
            sboTerm = 0;
            if (pro.containsValue(SBGNclass)) {
                for (Object keyObj : pro.keySet()) {
                    String key = (String)keyObj;
                    logger.debug((Object)("key of properties file = " + key));
                    if (SBGNclass != pro.getProperty(key)) continue;
                    sboTerm = SBO.stringToInt((String)pro.getProperty(key));
                    break;
                }
            } else {
                logger.warn((Object)"impossible to get SBO term to determine whether it can be cloned or not");
                return false;
            }
        }
        if (sboTerm == null || sboTerm == 0) {
            return false;
        }
        if (!SBO.isChildOf((int)sboTerm, (int)375)) {
            return false;
        }
        canBeCloned = true;
        if (reaction.getNumReactants() > 0) {
            for (SpeciesReference sp : reaction.getListOfReactants()) {
                if (this.canBeCloned(sp.getSpeciesInstance())) continue;
                return false;
            }
        }
        if (reaction.getNumProducts() > 0) {
            for (SpeciesReference sp : reaction.getListOfProducts()) {
                if (this.canBeCloned(sp.getSpeciesInstance())) continue;
                return false;
            }
        }
        return canBeCloned;
    }

    private boolean canBeCloned(Species species) {
        boolean hasToBeCloned = false;
        Integer specieSBOterm = species.getSBOTerm();
        if (specieSBOterm == null) {
            String SBGNclass = SBGNUtils.getSBGNClass((SBase)species);
            specieSBOterm = 0;
            if (pro.containsValue(SBGNclass)) {
                while (pro.keys().hasMoreElements()) {
                    String key = (String)pro.keys().nextElement();
                    logger.debug((Object)("key of properties file = " + key));
                    if (SBGNclass != pro.getProperty(key)) continue;
                    specieSBOterm = SBO.stringToInt((String)pro.getProperty(key));
                    break;
                }
            } else {
                logger.warn((Object)"impossible to get SBO term to determine whether it can be cloned or not");
                return false;
            }
        }
        if (specieSBOterm == null) {
            return false;
        }
        if (this.speciesCardinalityMap.get(species.getId()) == null) {
            this.speciesCardinalityMap.put(species.getId(), 0);
        }
        if (this.speciesCardinalityMap.get(species.getId()) > 4) {
            hasToBeCloned = true;
        }
        if (hasToBeCloned) {
            if (SBOCloneMap.get(specieSBOterm) != null) {
                return true;
            }
            for (Map.Entry<Integer, String> entry : SBOCloneMap.entrySet()) {
                Integer sboTerm = entry.getKey();
                if (!SBO.isChildOf((int)specieSBOterm, (int)sboTerm)) continue;
                return true;
            }
        }
        return false;
    }

    public Sbgn convertSBGNML(SBMLDocument sbmlDocument) throws SBMLException {
        Sbgn sbgnObject = new Sbgn();
        Map map = new Map();
        sbgnObject.setMap(map);
        try {
            this.sbmlModel = sbmlDocument.getModel();
        }
        catch (Exception e) {
            throw new SBMLException("SBML2SBGN: Input file is not a regular SBML file.");
        }
        ListOf listOfSpecies = this.sbmlModel.getListOfSpecies();
        ListOf listOfReactions = this.sbmlModel.getListOfReactions();
        this.speciesCardinalityMap = SBML2SBGNML.getSpeciesCardinalityMap((ListOf<Reaction>)listOfReactions);
        this.createGlyphs((ListOf<Species>)listOfSpecies, map);
        this.createGlyphProcessNodes((ListOf<Reaction>)listOfReactions, map);
        this.createArcs((ListOf<Reaction>)listOfReactions, map);
        return sbgnObject;
    }

    private static ListOf<Species> getComplexComponents(Species species, ListOf<Species> listOfSpecies) {
        Integer size = null;
        ListOf complexComponent = null;
        logger.debug((Object)("number of cvterms = " + species.getNumCVTerms()));
        if (species.filterCVTerms(CVTerm.Qualifier.BQB_HAS_PART).size() <= 0) {
            return null;
        }
        CVTerm cvterm = (CVTerm)species.filterCVTerms(CVTerm.Qualifier.BQB_HAS_PART).get(0);
        if (cvterm == null || cvterm.getResources() == null) {
            logger.debug((Object)"cvterm.getResources() ==  null");
            return null;
        }
        for (String pattern : cvterm.getResources()) {
            logger.debug((Object)("the pattern is = " + pattern));
            if (listOfSpecies == null) {
                logger.debug((Object)"listOfSpecies == null");
            }
            for (Species sp : listOfSpecies) {
                List isCVTerm = sp.getAnnotation().filterCVTerms(CVTerm.Qualifier.BQB_IS, pattern);
                logger.debug((Object)("isCVTerm.size() = " + isCVTerm.size()));
                if (isCVTerm.size() != 1) continue;
                logger.debug((Object)"in the complex component loop");
                complexComponent = new ListOf(species.getLevel(), species.getVersion());
                complexComponent.add((SBase)sp);
                size = complexComponent.size();
            }
        }
        if (size == null) {
            logger.debug((Object)"size == null");
            return null;
        }
        if (size.intValue() != cvterm.getResources().size()) {
            logger.warn((Object)("A complex " + species.getName() + " has not its components in the model."));
            return null;
        }
        return complexComponent;
    }

    public static String getName(NamedSBase specie) {
        String displayName = specie.getName();
        if (displayName == null || displayName.trim().length() == 0) {
            displayName = specie.getId();
        }
        return displayName;
    }

    public static Boolean isAComplex(Species species) {
        if (species.getSBOTerm() == 253) {
            return true;
        }
        if (species.getAnnotation().getNumCVTerms() > 0) {
            for (CVTerm cvTerm : species.getAnnotation().getListOfCVTerms()) {
                if (!cvTerm.isBiologicalQualifier() || !cvTerm.getBiologicalQualifierType().equals((Object)CVTerm.Qualifier.BQB_HAS_PART)) continue;
                return true;
            }
        }
        return false;
    }

    public SBMLDocument getSBMLDocument(String sbmlFileName) {
        SBMLDocument document = null;
        SBMLReader reader = new SBMLReader();
        try {
            document = reader.readSBML(sbmlFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        return document;
    }

    private static HashMap<String, Integer> getSpeciesCardinalityMap(ListOf<Reaction> lor) {
        HashMap<String, Integer> idCardTable = new HashMap<String, Integer>();
        logger.debug((Object)("in getSpeciesCardinalityMap = " + lor.size()));
        if (lor.size() != 0) {
            for (Reaction reac : lor) {
                Integer card;
                ListOf reactant = reac.getListOfReactants();
                ListOf product = reac.getListOfProducts();
                ListOf modifier = reac.getListOfModifiers();
                for (SpeciesReference sp : reactant) {
                    card = idCardTable.get(sp.getSpecies());
                    if (card != null) {
                        idCardTable.put(sp.getSpecies(), card + 1);
                        logger.debug((Object)("name = " + sp.getSpecies() + " ## card = " + idCardTable.get(sp.getSpecies())));
                        continue;
                    }
                    idCardTable.put(sp.getSpecies(), 1);
                }
                for (SpeciesReference pr : product) {
                    card = idCardTable.get(pr.getSpecies());
                    if (card != null) {
                        idCardTable.put(pr.getSpecies(), card + 1);
                        logger.debug((Object)("name = " + pr.getSpecies() + " ## card = " + idCardTable.get(pr.getSpecies())));
                        continue;
                    }
                    idCardTable.put(pr.getSpecies(), 1);
                }
                for (ModifierSpeciesReference mod : modifier) {
                    card = idCardTable.get(mod.getSpecies());
                    if (card != null) {
                        idCardTable.put(mod.getSpecies(), card + 1);
                        logger.debug((Object)("name = " + mod.getSpecies() + " ## card = " + idCardTable.get(mod.getSpecies())));
                        continue;
                    }
                    idCardTable.put(mod.getSpecies(), 1);
                }
            }
        }
        return idCardTable;
    }

    private void createArcs(ListOf<Reaction> listOfReaction, Map map) {
        Glyph hackSource = new Glyph();
        Glyph hackTarget = new Glyph();
        for (Reaction reaction : listOfReaction) {
            String glyphProcessId = reaction.getId();
            String glyphProcessIdPort1 = reaction.getId() + ".1";
            String glyphProcessIdPort2 = reaction.getId() + ".2";
            logger.debug((Object)("reaction.getID = " + reaction.getId()));
            if (reaction.getNumReactants() > 0) {
                for (SpeciesReference reactant : reaction.getListOfReactants()) {
                    hackSource = new Glyph();
                    hackSource.setId(reactant.getSpecies());
                    hackTarget = new Glyph();
                    hackTarget.setId(glyphProcessIdPort1);
                    this.createOneArc((SBase)reaction, "consumption", hackSource, hackTarget, map);
                }
            }
            if (reaction.getNumProducts() > 0) {
                for (SpeciesReference product : reaction.getListOfProducts()) {
                    hackSource = new Glyph();
                    hackSource.setId(glyphProcessIdPort2);
                    hackTarget = new Glyph();
                    hackTarget.setId(product.getSpecies());
                    this.createOneArc((SBase)reaction, "production", hackSource, hackTarget, map);
                }
            }
            if (reaction.getNumModifiers() <= 0) continue;
            for (ModifierSpeciesReference modifier : reaction.getListOfModifiers()) {
                hackSource = new Glyph();
                hackSource.setId(modifier.getSpecies());
                hackTarget = new Glyph();
                hackTarget.setId(glyphProcessId);
                this.createOneArc((SBase)reaction, "modulation", hackSource, hackTarget, map);
            }
        }
    }

    private void createGlyphProcessNodes(ListOf<Reaction> listOfReaction, Map map) {
        for (Reaction reaction : listOfReaction) {
            this.createOneGlyph(reaction, map);
        }
    }

    private void createGlyphs(ListOf<Species> listOfSpecies, Map map) {
        for (Species species : listOfSpecies) {
            ListOf<Species> listFromSpecie = SBML2SBGNML.getComplexComponents(species, listOfSpecies);
            if (SBML2SBGNML.isAComplex(species).booleanValue() && listFromSpecie != null && listFromSpecie.size() > 1) {
                Glyph glyphOfSpecies = new Glyph();
                glyphOfSpecies.setId(species.getId());
                glyphOfSpecies.setClazz("complex");
                map.getGlyph().add(glyphOfSpecies);
                this.createGlyphs(listFromSpecie, map);
                continue;
            }
            this.createOneGlyph(species, map);
        }
    }

    private void createOneArc(SBase reaction, String defaultSBGNClass, Glyph source, Glyph target, Map map) {
        Arc arc = new Arc();
        map.getArc().add(arc);
        arc.setClazz(sbu.getOutputFromClass(reaction, defaultSBGNClass));
        arc.setTarget(target);
        arc.setSource(source);
        arc.setId(source.getId() + "_" + target.getId());
        Arc.Start s = new Arc.Start();
        s.setX(0.0f);
        s.setY(0.0f);
        arc.setStart(s);
        Arc.End e = new Arc.End();
        e.setX(0.0f);
        e.setY(0.0f);
        arc.setEnd(e);
    }

    private void createVoidBBox(Glyph g) {
        Bbox bbox = new Bbox();
        bbox.setX(0.0f);
        bbox.setY(0.0f);
        bbox.setH(0.0f);
        bbox.setW(0.0f);
        g.setBbox(bbox);
    }

    private void createOneGlyph(Species species, Map map) {
        Annotation ann;
        SBML2SBGNML stsML;
        Glyph glyph = new Glyph();
        glyph.setId(species.getId());
        glyph.setClazz(sbu.getOutputFromClass((SBase)species, "unspecified entity"));
        map.getGlyph().add(glyph);
        Label lab = new Label();
        lab.setText(SBML2SBGNML.getName((NamedSBase)species));
        glyph.setLabel(lab);
        if (sbu.getOutputFromClass((SBase)species, "unspecified entity").equals("compartment")) {
            this.createVoidBBox(glyph);
        }
        if ((stsML = new SBML2SBGNML()).canBeCloned(species)) {
            Glyph.Clone c = new Glyph.Clone();
            glyph.setClone(c);
        }
        this.createVoidBBox(glyph);
        if (SBGNML_MILESTONE == 2 && species.getAnnotation() != null && !(ann = species.getAnnotation()).equals((Object)"")) {
            try {
                SBML2SBGNML.addAnnotationInExtension(glyph, ann);
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
        }
    }

    private static void addAnnotationInExtension(SBGNBase base, Annotation anno) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder constructeur = factory.newDocumentBuilder();
        Document document = constructeur.newDocument();
        Element annotation = document.createElement("sbfcanno:annotation");
        annotation.setAttribute("xmlns:sbfcanno", SBFC_ANNO_NAMESPACE);
        for (CVTerm cvt : anno.getListOfCVTerms()) {
            String cvtermName = cvt.isBiologicalQualifier() ? cvt.getBiologicalQualifierType().getElementNameEquivalent() : cvt.getModelQualifierType().getElementNameEquivalent();
            Element cvterm = document.createElement("sbfcanno:" + cvtermName);
            annotation.appendChild(cvterm);
            for (String urn : cvt.getResources()) {
                Element resource = document.createElement("sbfcanno:resource");
                resource.setAttribute("sbfcanno:urn", urn);
                cvterm.appendChild(resource);
            }
        }
        SBGNBase.Extension ex = new SBGNBase.Extension();
        if (base.getExtension() != null) {
            ex = base.getExtension();
        }
        ex.getAny().add(annotation);
        base.setExtension(ex);
    }

    private static void addExtensionElement(SBGNBase base, String elementString) {
        SBGNBase.Extension ex = new SBGNBase.Extension();
        if (base.getExtension() != null) {
            ex = base.getExtension();
        }
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(false);
        builderFactory.setValidating(false);
        builderFactory.setIgnoringElementContentWhitespace(false);
        DocumentBuilder builder = null;
        try {
            builder = builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException exception) {
            exception.printStackTrace();
        }
        Document xmlDoc = null;
        try {
            xmlDoc = builder.parse(new InputSource(new StringReader(elementString)));
        }
        catch (SAXException exception) {
            exception.printStackTrace();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        Element e = xmlDoc.getDocumentElement();
        ex.getAny().add(e);
        base.setExtension(ex);
    }

    private void createOneGlyph(Reaction reaction, Map map) {
        Glyph glyph = new Glyph();
        glyph.setId(reaction.getId());
        glyph.setClazz(sbu.getOutputFromClass((SBase)reaction, "process"));
        map.getGlyph().add(glyph);
        if (SBGNML_MILESTONE == 2 && reaction.getKineticLaw() != null) {
            String math = reaction.getKineticLaw().getMathMLString();
            SBML2SBGNML.addExtensionElement(glyph, math);
        }
        if (SBGNML_MILESTONE == 2 && reaction.getAnnotation() != null) {
            Annotation ann = reaction.getAnnotation();
            try {
                SBML2SBGNML.addAnnotationInExtension(glyph, ann);
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
        }
        if (this.canBeCloned(reaction)) {
            Glyph.Clone c = new Glyph.Clone();
            glyph.setClone(c);
        }
        this.createVoidBBox(glyph);
        Port p1 = new Port();
        p1.setId(reaction.getId() + ".1");
        p1.setX(0.0f);
        p1.setY(0.0f);
        glyph.getPort().add(p1);
        Port p2 = new Port();
        p2.setId(reaction.getId() + ".2");
        p2.setX(0.0f);
        p2.setY(0.0f);
        glyph.getPort().add(p2);
    }

    public static void main(String[] args) throws FileNotFoundException, SAXException, IOException {
        String sbmlFileNameInput;
        SBML2SBGNML sbml;
        SBMLDocument sbmlDocument;
        BasicConfigurator.configure();
        if (args.length < 1 || args.length > 3) {
            System.out.println("usage: java org.sbfc.converter.sbml2sbgnml.SBML2SBGN <SBML filename> [SBGNML milestone for output file]");
            return;
        }
        if (args.length == 2) {
            SBGNML_MILESTONE = Integer.parseInt(args[1]);
        }
        if ((sbmlDocument = (sbml = new SBML2SBGNML()).getSBMLDocument(sbmlFileNameInput = args[0])) == null) {
            System.exit(1);
        }
        String outputFilePath = sbmlFileNameInput.replaceAll("[_A-Za-z0-9-]+.xml$", "");
        String outputFile = outputFilePath + "SBGN-ML_" + sbmlFileNameInput.replaceAll("^.*/", "");
        Sbgn sbgnObject = sbml.convertSBGNML(sbmlDocument);
        File f = new File(outputFile);
        try {
            SbgnUtil.writeToFile(sbgnObject, f);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        System.out.println("output file at: " + outputFile);
        System.out.println("conversion into SBGN-ML done");
        File f2 = new File(outputFile);
        try {
            SbgnUtil.readFromFile(f2);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        int version = SbgnVersionFinder.getVersion(f2);
        System.out.println("The version of the created SBGN-ML file is '" + version + "'");
        if (version == 1) {
            f2 = File.createTempFile(f2.getName(), ".sbgn");
            System.out.println("Converted to " + f2);
        }
    }

    @Override
    public GeneralModel convert(GeneralModel model) throws ConversionException, ReadModelException {
        try {
            this.inputModel = model;
            SBMLDocument doc = ((SBMLModel)model).getSBMLDocument();
            Sbgn sbgnObj = this.convertSBGNML(doc);
            SBGNModel outputModel = new SBGNModel(sbgnObj);
            return outputModel;
        }
        catch (SBMLException e) {
            e.printStackTrace();
            throw new ConversionException(e.getMessage());
        }
    }

    @Override
    public String getResultExtension() {
        return ".sbgn";
    }

    @Override
    public String getName() {
        return "SBML2SBGNML";
    }

    @Override
    public String getDescription() {
        return "It converts a model format from SBML to SBGN-ML";
    }

    @Override
    public String getHtmlDescription() {
        return "It converts a model format from SBML to SBGN-ML";
    }

    static {
        SBOCloneMap = new HashMap(12);
        pro = SBGNUtils.readProperties();
        String scm = "simpleCloneMarker";
        SBOCloneMap.put(247, scm);
        SBOCloneMap.put(285, scm);
        SBOCloneMap.put(405, scm);
        SBOCloneMap.put(358, scm);
        SBOCloneMap.put(421, scm);
        String lcm = "labeledCloneMarker";
        SBOCloneMap.put(245, lcm);
        SBOCloneMap.put(253, lcm);
        SBOCloneMap.put(354, lcm);
        SBOCloneMap.put(420, lcm);
        SBOCloneMap.put(418, lcm);
        SBOCloneMap.put(419, lcm);
        String ncm = "noneCloneMarker";
        SBOCloneMap.put(237, ncm);
    }
}

