/*
 * Decompiled with CFR 0.152.
 */
package org.sbfc.converter.sbml2octave;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sbfc.converter.GeneralConverter;
import org.sbfc.converter.exceptions.ConversionException;
import org.sbfc.converter.exceptions.ReadModelException;
import org.sbfc.converter.models.GeneralModel;
import org.sbfc.converter.models.OctaveModel;
import org.sbfc.converter.models.SBMLModel;
import org.sbfc.converter.sbml2octave.OctaveID;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.AbstractSBase;
import org.sbml.jsbml.AlgebraicRule;
import org.sbml.jsbml.AssignmentRule;
import org.sbml.jsbml.CVTerm;
import org.sbml.jsbml.Compartment;
import org.sbml.jsbml.Event;
import org.sbml.jsbml.EventAssignment;
import org.sbml.jsbml.FunctionDefinition;
import org.sbml.jsbml.KineticLaw;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.LocalParameter;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.ModifierSpeciesReference;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.Parameter;
import org.sbml.jsbml.RateRule;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.Rule;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.SpeciesReference;
import org.sbml.jsbml.StoichiometryMath;
import org.sbml.jsbml.Trigger;

public class SBML2Octave
extends GeneralConverter {
    private HashMap<Species, String> speciesFluxMap = new HashMap();
    private HashMap<Species, Boolean> isHasSubstanceUnits = new HashMap();
    Vector<String> mathOperators;
    ListOf<SpeciesReference> products;
    ListOf<SpeciesReference> reactants;
    ListOf<ModifierSpeciesReference> modifiers;
    private int nbParameters = 0;
    private int nbEquaDiff = 0;
    public static final Pattern idPattern = Pattern.compile("(_|[a-z]|[A-Z])(_|[a-z]|[A-Z]|[0-9])*");
    public static final Pattern idOctavePattern = Pattern.compile("(_|[a-z]|[A-Z])(_|[a-z]|[A-Z]|[0-9])*\\((_|[a-z]|[A-Z]|[0-9]|,)*\\)");
    public static final Pattern plusMinusPattern = Pattern.compile("(\\+\\ \\-)|(\\+\\-)");
    Model sbmlModel;
    ArrayList<EquaDiff> xdot = new ArrayList();

    protected String headerString() {
        return "% This file works with OCTAVE and is automatically generated with \n% the System Biology Format Converter (http://sbfc.sourceforge.net/)\n% from an SBML file.\n% To run this file with Matlab you must edit the comments providing\n% the definition of the ode solver and the signature for the \n% xdot function.\n%\n% The conversion system has the following limitations:\n%  - You may have to re order some reactions and Assignment Rules definition\n%  - Delays are not taken into account\n%  - You should change the lsode parameters (start, end, steps) to get better results\n%\n\n";
    }

    protected String xdotFunctionSignature() {
        return "% Depending on whether you are using Octave or Matlab,\n% you should comment / uncomment one of the following blocks.\n% This should also be done for the definition of the function f below.\n% Start Matlab code\n%function xdot=f(t,x)\n% End Matlab code\n\n% Start Octave code\nfunction xdot=f(x,t)\n% End Octave code\n\n";
    }

    protected String odeSolverCode() {
        return "% Depending on whether you are using Octave or Matlab,\n% you should comment / uncomment one of the following blocks.\n% This should also be done for the definition of the function f below.\n% Start Matlab code\n%\ttspan=[0:0.01:100];\n%\topts = odeset('AbsTol',1e-3);\n%\t[t,x]=ode23tb(@f,tspan,x0,opts);\n% End Matlab code\n\n% Start Octave code\n\tt=linspace(0,100,100);\n\tx=lsode('f',x0,t);\n% End Octave code\n\n";
    }

    private String createHeader() {
        String octaveModel = this.headerString();
        String modelName = this.sbmlModel.getName();
        if (modelName == null || modelName.trim().length() == 0) {
            modelName = this.sbmlModel.getId();
        }
        octaveModel = octaveModel + "%\n% Model name = " + modelName + "\n%\n";
        for (CVTerm cvTerm : this.sbmlModel.getCVTerms()) {
            if (!cvTerm.isModelQualifier()) continue;
            for (String uri : cvTerm.getResources()) {
                octaveModel = octaveModel + "% " + cvTerm.getModelQualifierType().getElementNameEquivalent() + " " + uri + "\n";
            }
        }
        octaveModel = octaveModel + "%\n";
        return octaveModel;
    }

    public OctaveModel octaveExport(SBMLModel sbfcSBMLModel) throws SBMLException {
        System.out.println("SBML2Octave : Export in progress...");
        this.sbmlModel = sbfcSBMLModel.getModel();
        if (this.sbmlModel == null) {
            throw new SBMLException("SBML2Octave: Input file is not a regular SBML file.");
        }
        String octaveModel = this.createHeader();
        try {
            ListOf functiondefinitions = this.sbmlModel.getListOfFunctionDefinitions();
            ListOf compartments = this.sbmlModel.getListOfCompartments();
            ListOf listOfSpecies = this.sbmlModel.getListOfSpecies();
            ListOf parameters = this.sbmlModel.getListOfParameters();
            ListOf rules = this.sbmlModel.getListOfRules();
            ListOf reactions = this.sbmlModel.getListOfReactions();
            ListOf events = this.sbmlModel.getListOfEvents();
            this.mathOperators = new Vector();
            this.mathOperators.add("exp");
            this.mathOperators.add("pow");
            this.mathOperators.add("root");
            this.mathOperators.add("sqrt");
            this.mathOperators.add("eq");
            this.mathOperators.add("neq");
            this.mathOperators.add("gt");
            this.mathOperators.add("geq");
            this.mathOperators.add("lt");
            this.mathOperators.add("leq");
            this.mathOperators.add("sin");
            this.mathOperators.add("cos");
            this.mathOperators.add("tan");
            this.mathOperators.add("atan2");
            this.mathOperators.add("asin");
            this.mathOperators.add("acos");
            this.mathOperators.add("atan");
            this.mathOperators.add("sinh");
            this.mathOperators.add("cosh");
            this.mathOperators.add("tanh");
            this.mathOperators.add("log");
            this.mathOperators.add("log10");
            this.mathOperators.add("ln");
            this.mathOperators.add("abs");
            this.mathOperators.add("pi");
            this.mathOperators.add("time");
            this.mathOperators.add("Time");
            this.mathOperators.add("delay");
            this.mathOperators.add("ceil");
            this.mathOperators.add("flr");
            this.mathOperators.add("e");
            this.mathOperators.add("E");
            this.mathOperators.add("t");
            String mainBookmark = "MAIN_FUNCTION_BOOKMARK";
            octaveModel = octaveModel + "\n\n" + mainBookmark + "\n\n";
            octaveModel = octaveModel + this.xdotFunctionSignature();
            for (Compartment compartment : compartments) {
                this.buildIdMap((SBase)compartment, "compartment_" + compartment.getId());
                if (compartment.isConstant()) {
                    ++this.nbParameters;
                    octaveModel = octaveModel + this.printConstantCompartment(compartment);
                    continue;
                }
                octaveModel = octaveModel + this.printCompartment(compartment);
            }
            for (Object species : listOfSpecies) {
                if (species.isConstant()) {
                    this.buildIdMap((SBase)species, "const_species_" + species.getId());
                } else {
                    ++this.nbEquaDiff;
                    this.buildIdMap((SBase)species, "x(" + this.nbEquaDiff + ")");
                }
                if (!species.isHasOnlySubstanceUnits()) {
                    if (species.getCompartmentInstance().getSpatialDimensions() > 0.0) {
                        this.isHasSubstanceUnits.put((Species)species, false);
                    }
                    if (species.getCompartmentInstance().getSpatialDimensions() != 0.0) continue;
                    this.isHasSubstanceUnits.put((Species)species, true);
                    continue;
                }
                if (!species.isHasOnlySubstanceUnits()) continue;
                this.isHasSubstanceUnits.put((Species)species, true);
            }
            for (Parameter parameter : parameters) {
                this.buildIdMap((SBase)parameter, "global_par_" + parameter.getId());
                if (parameter.isConstant()) {
                    ++this.nbParameters;
                    octaveModel = octaveModel + this.printConstantParameter(parameter);
                    continue;
                }
                octaveModel = octaveModel + this.printParameter(parameter);
            }
            for (Reaction reaction : reactions) {
                this.buildIdMap((SBase)reaction, "reaction_" + reaction.getId());
            }
            for (Rule rule : rules) {
                String rulemath = null;
                rulemath = rule instanceof AlgebraicRule ? this.printAlgebraicRule(rule) : this.printRule(rule);
                if (rulemath == null) {
                    System.out.println("Inconsistent mathML operators in Rules");
                    continue;
                }
                octaveModel = octaveModel + rulemath;
            }
            for (Reaction reaction : reactions) {
                StoichiometryMath stoichiometryMath;
                double stoichiometry;
                String stoichiometryStr;
                String speciesFlux;
                Species species;
                this.products = reaction.getListOfProducts();
                this.reactants = reaction.getListOfReactants();
                this.modifiers = reaction.getListOfModifiers();
                String reactionmath = this.printReaction(reaction);
                if (reactionmath == null) {
                    System.out.println("Inconsistent mathML operators in Reaction");
                } else {
                    octaveModel = octaveModel + reactionmath;
                }
                for (SpeciesReference reactant : this.reactants) {
                    species = reactant.getSpeciesInstance();
                    speciesFlux = this.speciesFluxMap.get(species);
                    stoichiometryStr = "1";
                    stoichiometry = reactant.getStoichiometry();
                    stoichiometryMath = reactant.getStoichiometryMath();
                    if (stoichiometryMath != null && stoichiometryMath.isSetMath()) {
                        stoichiometryStr = stoichiometryMath.getMath().toFormula();
                    } else if (stoichiometry != 0.0) {
                        stoichiometryStr = Double.toString(stoichiometry);
                    }
                    if (speciesFlux == null) {
                        speciesFlux = new String();
                    }
                    if (speciesFlux.length() != 0) {
                        speciesFlux = speciesFlux + " + ";
                    }
                    speciesFlux = speciesFlux + "(-" + stoichiometryStr + " * " + OctaveID.getOctaveId(reaction.getId()) + ")";
                    this.speciesFluxMap.put(species, speciesFlux);
                    System.out.println("Reactant flux map : id = " + species.getId());
                }
                for (SpeciesReference product : this.products) {
                    species = product.getSpeciesInstance();
                    speciesFlux = this.speciesFluxMap.get(species);
                    stoichiometryStr = "1";
                    stoichiometry = product.getStoichiometry();
                    stoichiometryMath = product.getStoichiometryMath();
                    if (stoichiometryMath != null && stoichiometryMath.isSetMath()) {
                        stoichiometryStr = stoichiometryMath.getMath().toFormula();
                    } else if (stoichiometry != 0.0) {
                        stoichiometryStr = Double.toString(stoichiometry);
                    }
                    if (speciesFlux == null) {
                        speciesFlux = new String();
                    }
                    if (speciesFlux.length() != 0) {
                        speciesFlux = speciesFlux + " + ";
                    }
                    speciesFlux = speciesFlux + "( " + stoichiometryStr + " * " + OctaveID.getOctaveId(reaction.getId()) + ")";
                    this.speciesFluxMap.put(species, speciesFlux);
                }
            }
            for (Object species : listOfSpecies) {
                if (species.isConstant()) {
                    ++this.nbParameters;
                    octaveModel = octaveModel + this.printConstantSpecies((Species)species);
                    continue;
                }
                String speciesmath = this.printSpecies((Species)species);
                if (speciesmath != null) continue;
                System.out.println("Inconsistent mathML operators ");
            }
            int i = 1;
            for (Event event : events) {
                String eventId = event.getId();
                System.out.println("Debug : Event id = " + eventId + ", " + event.getId());
                this.buildIdMap((SBase)event, "event_" + eventId);
                ++i;
                Trigger trigger = event.getTrigger();
                if (trigger == null || !trigger.isSetMath()) {
                    octaveModel = octaveModel + "%WARNING : No trigger defined for event id=" + eventId + "; event ignored\n\n";
                    continue;
                }
                String infixTrigger = trigger.getMath().toFormula();
                ASTNode astTrigger = trigger.getMath();
                String infixASTTrigger = astTrigger.toFormula();
                System.out.println("Debug : Event trigger = " + infixTrigger);
                System.out.println("Debug : Event trigger = " + infixASTTrigger);
                octaveModel = octaveModel + "\n%Event: id=" + eventId + "\n";
                octaveModel = octaveModel + "\t" + OctaveID.getOctaveId(eventId) + "=" + this.replaceIdInsideFormula(infixASTTrigger) + ";\n\n" + "\tif(" + OctaveID.getOctaveId(eventId) + ") \n";
                int j = 1;
                int eventAssignmentSize = event.getNumEventAssignments();
                for (EventAssignment eventAssignment : event.getListOfEventAssignments()) {
                    octaveModel = octaveModel + "\t\t" + OctaveID.getOctaveId(eventAssignment.getVariable()) + "=" + this.replaceIdInsideFormula(eventAssignment.getMath().toFormula());
                    octaveModel = j < eventAssignmentSize ? octaveModel + ";\n" : octaveModel + ";\n\tend\n";
                    ++j;
                }
            }
            octaveModel = octaveModel + "\n\txdot=zeros(" + this.xdot.size() + ",1);\n";
            for (EquaDiff equa : this.xdot) {
                octaveModel = octaveModel + "\t" + equa.getComment();
                octaveModel = octaveModel + "\txdot(" + equa.getEquaNumber() + ") = " + equa.getEqua() + ";\n";
            }
            octaveModel = octaveModel + "end\n\n";
            StringBuilder main = new StringBuilder();
            main.append("function main()\n");
            main.append("%Initial conditions vector\n");
            main.append("\tx0=zeros(" + this.xdot.size() + ",1);\n");
            for (EquaDiff equa : this.xdot) {
                main.append("\tx0(" + equa.getEquaNumber() + ") = " + equa.getInit() + ";\n");
            }
            main.append("\n\n" + this.odeSolverCode() + "\n");
            main.append("\tplot(t,x);\n");
            main.append("end\n\n");
            octaveModel = octaveModel.replaceFirst(mainBookmark, main.toString());
            for (FunctionDefinition functiondefinition : functiondefinitions) {
                this.buildIdMap((SBase)functiondefinition, functiondefinition.getId());
                String funcdefin = this.printFunctionDefinition(functiondefinition);
                if (funcdefin == null) {
                    System.out.println("Inconsistent mathML operators in Function Definition");
                    continue;
                }
                octaveModel = octaveModel + funcdefin;
            }
            octaveModel = octaveModel + "% adding few functions representing operators used in SBML but not present directly \n";
            octaveModel = octaveModel + "% in either matlab or octave. \n";
            octaveModel = octaveModel + "function z=pow(x,y),z=x^y;end\nfunction z=root(x,y),z=y^(1/x);end\n";
            octaveModel = octaveModel + "function z = piecewise(varargin)\n\tnumArgs = nargin;\n\tresult = 0;\n\tfoundResult = 0;\n\tfor k=1:2: numArgs-1\n\t\tif varargin{k+1} == 1\n\t\t\tresult = varargin{k};\n\t\t\tfoundResult = 1;\n\t\t\tbreak;\n\t\tend\n\tend\n\tif foundResult == 0\n\t\tresult = varargin{numArgs};\n\tend\n\tz = result;\nend\n\n";
        }
        catch (AssertionError err) {
            octaveModel = this.createHeader();
            octaveModel = octaveModel + "\n%\n% " + ((Throwable)((Object)err)).getMessage() + "\n%\n";
        }
        OctaveModel octaveReturnModel = new OctaveModel();
        try {
            octaveReturnModel.setModelFromString(octaveModel);
        }
        catch (ReadModelException e) {
            e.printStackTrace();
            return null;
        }
        return octaveReturnModel;
    }

    private String printFunctionDefinition(FunctionDefinition functiondefinition) {
        String inputformula = null;
        try {
            inputformula = functiondefinition.getMath().toFormula();
        }
        catch (SBMLException e) {
            e.printStackTrace();
        }
        inputformula = inputformula.replace("lambda(", "");
        ArrayList<String> tempal = new ArrayList<String>();
        StringTokenizer stcomma = new StringTokenizer(inputformula, ",");
        StringBuilder funcDef = new StringBuilder();
        StringBuilder formula = new StringBuilder();
        formula.append("(");
        int count = 0;
        int stCommaNb = stcomma.countTokens();
        while (stcomma.hasMoreTokens()) {
            String read = stcomma.nextToken().trim();
            ++count;
            if (read.contains(" ") || read.contains(" * ") || read.contains("/") || read.contains(")")) {
                formula.append(read);
                if (count >= stCommaNb) continue;
                formula.append(",");
                continue;
            }
            tempal.add(read);
        }
        String functionname = functiondefinition.getId();
        String octaveid = OctaveID.getOctaveId(functionname);
        funcDef.append("function z=" + octaveid + "(");
        for (int i = 0; i < tempal.size(); ++i) {
            if (i < tempal.size() - 1) {
                funcDef.append((String)tempal.get(i) + ",");
                continue;
            }
            funcDef.append((String)tempal.get(i));
        }
        funcDef.append("), z=" + formula + ";end\n\n");
        System.out.println("FunctionDefinition : id = " + functiondefinition.getId());
        if (this.matchMath(formula.toString(), tempal)) {
            return funcDef.toString();
        }
        String error = null;
        return error;
    }

    private boolean matchMath(String formula, ArrayList<String> additionalValidNames) {
        boolean support = true;
        Matcher mathMatcher = idPattern.matcher(formula);
        ArrayList<String> checkoperator = new ArrayList<String>();
        while (mathMatcher.find()) {
            checkoperator.add(mathMatcher.group());
        }
        for (String check : checkoperator) {
            if (OctaveID.getSBMLId(check) != null || this.mathOperators.contains(check) || additionalValidNames != null && additionalValidNames.contains(check)) continue;
            System.out.println("SBML2Octave : matchMath : the operator " + check + " is not supported by octave");
            System.out.println("SBML2Octave : matchMath : the formula is : " + formula);
            support = false;
        }
        return support;
    }

    private boolean matchMath(String formula) {
        boolean support = true;
        System.out.println(formula);
        Matcher mathMatcher = idOctavePattern.matcher(formula);
        ArrayList<String> checkoperators = new ArrayList<String>();
        while (mathMatcher.find()) {
            checkoperators.add(mathMatcher.group());
        }
        for (String check : checkoperators) {
            if (OctaveID.getSBMLId(check) != null || this.mathOperators.contains(check)) continue;
            System.out.println("SBML2Octave : matchMath : the operator " + check + " is not supported by Octave");
            System.out.println("SBML2Octave : matchMath : the formula is : " + formula);
            support = false;
        }
        return support;
    }

    private String printReaction(Reaction reaction) throws SBMLException {
        StringBuilder reactionStr = new StringBuilder();
        String reactionId = reaction.getId();
        reactionStr.append("\n% Reaction: id = " + reactionId);
        if (reaction.getName() != null && reaction.getName().trim().length() != 0) {
            reactionStr.append(", name = " + reaction.getName());
        }
        KineticLaw kineticLaw = reaction.getKineticLaw();
        String kineticLawStr = "";
        if (kineticLaw != null) {
            kineticLawStr = kineticLaw.getMath().toFormula();
            ListOf localParameters = kineticLaw.getListOfParameters();
            for (LocalParameter parameter : localParameters) {
                this.buildIdMap((SBase)parameter, OctaveID.getOctaveId(reactionId) + "_" + parameter.getId());
                String parameterId = parameter.getId();
                String localParameterId = OctaveID.getOctaveId(parameterId);
                if (parameter.isSetValue()) {
                    ++this.nbParameters;
                    reactionStr.append(this.printLocalParameter(parameter, localParameterId));
                    parameter.setId(localParameterId);
                } else {
                    System.out.println("Warning !! the local parameter " + localParameterId + " is not constant !!");
                }
                kineticLawStr = this.replaceIdInsideFormula(kineticLawStr, parameterId, localParameterId);
            }
        } else {
            throw new AssertionError((Object)"The model cannot be converted as there are some kineticLaw undefined.");
        }
        kineticLawStr = this.replaceIdInsideFormula(kineticLawStr);
        kineticLawStr = this.replacePlusMinusInsideFormula(kineticLawStr);
        reactionStr.append("\n\t" + OctaveID.getOctaveId(reaction.getId()) + "=" + kineticLawStr + ";\n");
        System.out.println("Reaction : id = " + reactionId);
        if (this.matchMath(kineticLawStr.toString())) {
            return reactionStr.toString();
        }
        return null;
    }

    private String replaceIdInsideFormula(String formula, String oldId, String newId) {
        StringBuffer formulaWithIdsBuffer = new StringBuffer();
        Matcher formulaMatcher = idPattern.matcher(formula);
        while (formulaMatcher.find()) {
            String id = formulaMatcher.group().trim();
            if (id.equals(oldId)) {
                id = newId;
            }
            formulaMatcher.appendReplacement(formulaWithIdsBuffer, id);
        }
        formulaMatcher.appendTail(formulaWithIdsBuffer);
        return formulaWithIdsBuffer.toString();
    }

    private String replaceIdInsideFormula(String formula) {
        StringBuffer formulaWithIdsBuffer = new StringBuffer();
        Matcher formulaMatcher = idPattern.matcher(formula);
        while (formulaMatcher.find()) {
            String id = formulaMatcher.group().trim();
            String newId = OctaveID.getOctaveId(id);
            if (newId == null) continue;
            formulaMatcher.appendReplacement(formulaWithIdsBuffer, newId);
        }
        formulaMatcher.appendTail(formulaWithIdsBuffer);
        return formulaWithIdsBuffer.toString();
    }

    private String replacePlusMinusInsideFormula(String formula) {
        StringBuffer formulaWithIdsBuffer = new StringBuffer();
        Matcher formulaMatcher = plusMinusPattern.matcher(formula);
        while (formulaMatcher.find()) {
            formulaMatcher.appendReplacement(formulaWithIdsBuffer, "- ");
        }
        formulaMatcher.appendTail(formulaWithIdsBuffer);
        return formulaWithIdsBuffer.toString();
    }

    private String printLocalParameter(LocalParameter parameter, String id) {
        StringBuilder paramStr = new StringBuilder();
        paramStr.append(this.printLocalParameterComment(parameter));
        paramStr.append("\t" + id + "=" + parameter.getValue() + ";\n");
        return paramStr.toString();
    }

    private String printRule(Rule rule) throws SBMLException {
        String ruleStr = "";
        String variableId = null;
        if (rule.isRate()) {
            variableId = ((RateRule)rule).getVariable();
        } else if (rule.isAssignment()) {
            variableId = ((AssignmentRule)rule).getVariable();
        }
        String octaveId = OctaveID.getOctaveId(variableId);
        String mathMLStr = rule.getMath().toFormula();
        mathMLStr = this.replaceIdInsideFormula(mathMLStr);
        System.out.println("Rule : variable = " + variableId);
        if (this.matchMath(mathMLStr)) {
            String ruleComment = "% " + rule.getElementName() + ": variable = " + variableId + "\n";
            if (rule.isRate()) {
                RateRule variable = (RateRule)rule;
                String initialValue = "TODO";
                if (variable.getVariableInstance() instanceof Compartment) {
                    initialValue = "" + ((Compartment)variable.getVariableInstance()).getSize();
                } else if (variable.getVariableInstance() instanceof Species) {
                    Species s = (Species)variable.getVariableInstance();
                    initialValue = s.isSetInitialAmount() ? "" + s.getInitialAmount() : (s.isSetInitialConcentration() ? "" + s.getInitialConcentration() : "NaN");
                } else if (variable.getVariableInstance() instanceof Parameter) {
                    initialValue = "" + ((Parameter)variable.getVariableInstance()).getValue();
                }
                ruleStr = ruleStr + ruleComment;
                ++this.nbEquaDiff;
                ruleStr = ruleStr + octaveId + " = x(" + this.nbEquaDiff + ");\n";
                String equaNum = Integer.toString(this.nbEquaDiff);
                this.xdot.add(new EquaDiff(initialValue, mathMLStr, octaveId, ruleComment, equaNum));
            } else if (rule.isAssignment()) {
                ruleStr = ruleStr + ruleComment;
                ruleStr = ruleStr + "\t" + octaveId + "=" + mathMLStr + ";\n";
            }
            return ruleStr;
        }
        return null;
    }

    private String printAlgebraicRule(Rule rule) throws SBMLException {
        StringBuilder ruleStr = new StringBuilder();
        String mathMLStr = rule.getMath().toFormula();
        mathMLStr = this.replaceIdInsideFormula(mathMLStr);
        System.out.println("Algebraic Rule");
        if (this.matchMath(mathMLStr)) {
            ruleStr.append("% " + rule.getElementName() + "\n");
            ruleStr.append("% Warning, " + rule.getElementName() + " are not supported at the moment.\n");
            ruleStr.append("% " + mathMLStr + " = 0\n");
            return ruleStr.toString();
        }
        return null;
    }

    private String printSpecies(Species species) {
        StringBuilder speciesStr = new StringBuilder();
        String checkmath = null;
        String speciesComment = this.printSpeciesComment(species);
        String id = OctaveID.getOctaveId(species.getId());
        boolean needInit = true;
        for (Rule rule : this.sbmlModel.getListOfRules()) {
            if (rule.isAlgebraic() || (!rule.isRate() || !id.equals(((RateRule)rule).getVariableInstance().getId())) && (!rule.isAssignment() || !id.equals(((AssignmentRule)rule).getVariableInstance().getId())) || !(rule instanceof AssignmentRule)) continue;
            needInit = false;
        }
        String init = "0";
        if (needInit) {
            if (species.isSetInitialAmount() && species.isSetInitialConcentration()) {
                throw new AssertionError((Object)"Error in model, both Initial concentration and Initial amount defined");
            }
            if (species.isSetInitialAmount()) {
                init = "" + species.getInitialAmount();
            } else if (species.isSetInitialConcentration()) {
                init = "" + species.getInitialConcentration();
            }
        }
        if (species.isBoundaryCondition()) {
            if (!this.hasRule(species.getId()) && !this.hasEvent(species.getId())) {
                speciesStr.append("0.0");
                speciesComment = speciesComment + "\n%WARNING speciesID: " + species.getId() + ", constant= false " + " , boundaryCondition = " + species.isBoundaryCondition() + " but is not involved in assignmentRule, rateRule or events !" + "\n";
            }
        } else if (!species.isBoundaryCondition() && !this.hasRule(species.getId())) {
            if (this.speciesFluxMap.get(species) != null && !this.isHasSubstanceUnits.get(species).booleanValue()) {
                String sbmlId = species.getCompartmentInstance().getId();
                String octaveId = OctaveID.getOctaveId(sbmlId);
                checkmath = " (1/(" + octaveId + "))*(" + this.speciesFluxMap.get(species) + ")";
                speciesStr.append("(1/(" + octaveId + "))*(" + this.speciesFluxMap.get(species) + ")");
            } else if (this.speciesFluxMap.get(species) != null) {
                speciesStr.append(this.speciesFluxMap.get(species));
            }
        }
        System.out.println(this.hasRule(species.getId()));
        if (this.hasRule(species.getId())) {
            String octaveId = OctaveID.getOctaveId(species.getId());
            speciesStr.append(octaveId);
            checkmath = octaveId;
        }
        System.out.println("Species : id = " + species.getId());
        String equaNum = id.substring(id.lastIndexOf("(") + 1, id.lastIndexOf(")"));
        if (checkmath != null) {
            if (this.matchMath(checkmath)) {
                this.xdot.add(new EquaDiff(init, speciesStr.toString(), id, speciesComment, equaNum));
                return speciesStr.toString();
            }
            return null;
        }
        if (!this.hasRule(species.getId())) {
            this.xdot.add(new EquaDiff(init, speciesStr.toString(), id, speciesComment, equaNum));
            return speciesStr.toString();
        }
        return null;
    }

    private boolean hasRule(String id) {
        for (Rule rule : this.sbmlModel.getListOfRules()) {
            if (rule.isAlgebraic() || (!rule.isRate() || !id.equals(((RateRule)rule).getVariableInstance().getId())) && (!rule.isAssignment() || !id.equals(((AssignmentRule)rule).getVariableInstance().getId()))) continue;
            return true;
        }
        return false;
    }

    private boolean hasEvent(String id) {
        for (Event event : this.sbmlModel.getListOfEvents()) {
            for (EventAssignment eventAssgnt : event.getListOfEventAssignments()) {
                if (!eventAssgnt.getVariable().equals(id)) continue;
                return true;
            }
        }
        return false;
    }

    private String printConstantSpecies(Species species) {
        StringBuilder speciesStr = new StringBuilder();
        speciesStr.append(this.printSpeciesComment(species));
        String id = OctaveID.getOctaveId(species.getId());
        if (species.isSetInitialAmount() && species.isSetInitialConcentration()) {
            throw new AssertionError((Object)"Error in model, both Initial concentration and Initial amount defined");
        }
        if (species.isSetInitialAmount()) {
            speciesStr.append("\t" + id + "=" + species.getInitialAmount() + ";\n");
        } else if (species.isSetInitialConcentration()) {
            speciesStr.append("\t" + id + "=" + species.getInitialConcentration() + ";\n");
        }
        return speciesStr.toString();
    }

    private String printSpeciesComment(Species species) {
        StringBuilder commentStr = new StringBuilder();
        String id = species.getId();
        String name = species.getName();
        if (name == null || name.trim().length() == 0) {
            name = id;
        }
        commentStr.append("\n% Species: ");
        commentStr.append("  id = " + id);
        commentStr.append(", name = " + name);
        if (species.isConstant()) {
            commentStr.append(", constant");
        } else {
            if (species.isBoundaryCondition()) {
                if (this.hasRule(id)) {
                    commentStr.append(", involved in a rule ");
                } else if (!this.hasRule(id)) {
                    // empty if block
                }
            } else if (!species.isBoundaryCondition()) {
                if (this.hasRule(id)) {
                    commentStr.append(", defined in a rule ");
                } else if (this.speciesFluxMap.get(species) != null) {
                    commentStr.append(", affected by kineticLaw\n");
                } else {
                    commentStr.append("\n% Warning species is not changed by either rules or reactions\n");
                }
            }
            int nbEvent = this.getNbAffectingEvent((SBase)species);
            if (nbEvent > 0) {
                commentStr.append("% Species is changed by " + nbEvent + " event(s)");
            }
        }
        return commentStr.toString();
    }

    private int getNbAffectingEvent(SBase element) {
        int n = 0;
        if (!(element instanceof AbstractSBase)) {
            String elementId = ((NamedSBase)element).getId();
            block0: for (Event event : this.sbmlModel.getListOfEvents()) {
                for (EventAssignment eventAssignment : event.getListOfEventAssignments()) {
                    if (!elementId.equals(eventAssignment.getVariable())) continue;
                    ++n;
                    continue block0;
                }
            }
        }
        return n;
    }

    private String printParameter(Parameter parameter) {
        StringBuilder paramStr = new StringBuilder();
        paramStr.append(this.printParameterComment(parameter));
        boolean hasRule = this.hasRule(parameter.getId());
        if (!hasRule && !this.hasEvent(parameter.getId())) {
            paramStr.append("% Warning parameter " + parameter.getId() + " is not constant, it should be controlled by a Rule and/or events" + "\n");
        }
        if (!hasRule) {
            String id = OctaveID.getOctaveId(parameter.getId());
            paramStr.append("\t" + id + "=" + parameter.getValue() + ";\n");
        }
        return paramStr.toString();
    }

    private String printConstantParameter(Parameter parameter) {
        StringBuilder paramStr = new StringBuilder();
        paramStr.append(this.printParameterComment(parameter));
        String id = OctaveID.getOctaveId(parameter.getId());
        paramStr.append("\t" + id + "=" + parameter.getValue() + ";\n");
        return paramStr.toString();
    }

    private String printParameterComment(Parameter parameter) {
        StringBuilder commentStr = new StringBuilder();
        String id = parameter.getId();
        String name = parameter.getName();
        if (name == null || name.trim().length() == 0) {
            name = id;
        }
        commentStr.append("% Parameter: ");
        commentStr.append("  id =  " + id);
        commentStr.append(", name = " + name);
        commentStr.append("\n");
        return commentStr.toString();
    }

    private String printLocalParameterComment(LocalParameter parameter) {
        StringBuilder commentStr = new StringBuilder();
        String id = parameter.getId();
        String name = parameter.getName();
        if (name == null || name.trim().length() == 0) {
            name = id;
        }
        commentStr.append("\t% Local Parameter: ");
        commentStr.append("  id =  " + id);
        commentStr.append(", name = " + name);
        commentStr.append("\n");
        return commentStr.toString();
    }

    private String printCompartment(Compartment compartment) {
        StringBuilder compStr = new StringBuilder();
        compStr.append(this.printCompartmentComment(compartment));
        if (!this.hasRule(compartment.getId())) {
            compStr.append("% Warning compartment " + compartment.getId() + " has no rule and is not constant" + "\n");
        }
        return compStr.toString();
    }

    private String printCompartmentComment(Compartment compartment) {
        StringBuilder compCommentStr = new StringBuilder();
        String id = compartment.getId();
        String name = compartment.getName();
        if (name == null || name.trim().length() == 0) {
            name = id;
        }
        compCommentStr.append("% Compartment: id = " + id + ", name = " + name);
        if (compartment.isConstant()) {
            compCommentStr.append(", constant");
        } else if (this.hasRule(id)) {
            compCommentStr.append(", defined by a Rule");
        }
        compCommentStr.append("\n");
        return compCommentStr.toString();
    }

    private String printConstantCompartment(Compartment compartment) {
        StringBuilder compStr = new StringBuilder();
        compStr.append(this.printCompartmentComment(compartment));
        String id = OctaveID.getOctaveId(compartment.getId());
        compStr.append("\t" + id + "=" + compartment.getSize() + ";\n");
        return compStr.toString();
    }

    private void buildIdMap(SBase element, String wantedOctaveId) {
        String id = ((NamedSBase)element).getId();
        OctaveID octaveId = new OctaveID(id, wantedOctaveId, true);
        octaveId.checkOctaveId();
    }

    @Override
    public GeneralModel convert(GeneralModel model) throws ConversionException, ReadModelException {
        try {
            this.inputModel = model;
            return this.octaveExport((SBMLModel)model);
        }
        catch (SBMLException e) {
            e.printStackTrace();
            throw new ReadModelException(e.getMessage());
        }
    }

    @Override
    public String getResultExtension() {
        return ".m";
    }

    @Override
    public String getName() {
        return "SBML2OCTAVE";
    }

    @Override
    public String getDescription() {
        return "It converts a model format from SBML to Octave";
    }

    @Override
    public String getHtmlDescription() {
        return "It converts a model format from SBML to Octave";
    }

    class EquaDiff {
        private String init;
        private String equa;
        private String octaveId;
        private String comment;
        private String equaNumber;

        public EquaDiff(String init, String equa, String octaveId, String comment, String equaNum) {
            this.init = init;
            this.equa = equa;
            this.octaveId = octaveId;
            this.comment = comment;
            this.equaNumber = equaNum;
        }

        public String getInit() {
            return this.init;
        }

        public String getEqua() {
            return this.equa;
        }

        public String getOctaveId() {
            return this.octaveId;
        }

        public String getComment() {
            return this.comment;
        }

        public void setEqua(String equa) {
            this.equa = equa;
        }

        public String getEquaNumber() {
            return this.equaNumber;
        }

        public void setEquaNumber(String equaNumber) {
            this.equaNumber = equaNumber;
        }
    }
}

