/*
 * Decompiled with CFR 0.152.
 */
package org.sbfc.converter.sbml2matlab;

import org.sbfc.converter.sbml2octave.SBML2Octave;

public class SBML2Matlab
extends SBML2Octave {
    @Override
    protected String headerString() {
        return "% This file works with MATLAB and is automatically generated with \n% the System Biology Format Converter (http://sbfc.sourceforge.net/)\n% from an SBML file. \n% To run this file with Octave you must edit the comments providing\n% the definition of the ode solver and the signature for the \n% xdot function.\n%\n% The conversion system has the following limitations:\n%  - You may have to re order some reactions and Assignment Rules definition\n%  - Delays are not taken into account\n%  - You should change the lsode parameters (start, end, steps) to get better results\n%\n\n";
    }

    @Override
    protected String xdotFunctionSignature() {
        return "% Depending on whether you are using Octave or Matlab,\n% you should comment / uncomment one of the following blocks.\n% This should also be done for the definition of the function f below.\n% Start Matlab code\nfunction xdot=f(t,x)\n% End Matlab code\n\n% Start Octave code\n%function xdot=f(x,t)\n% End Octave code\n\n";
    }

    @Override
    protected String odeSolverCode() {
        return "% Depending on whether you are using Octave or Matlab,\n% you should comment / uncomment one of the following blocks.\n% This should also be done for the definition of the function f below.\n% Start Matlab code\n\ttspan=[0:0.01:100];\n\topts = odeset('AbsTol',1e-3);\n\t[t,x]=ode23tb(@f,tspan,x0,opts);\n% End Matlab code\n\n% Start Octave code\n%\tt=linspace(0,100,100);\n%\tx=lsode('f',x0,t);\n% End Octave code\n\n";
    }

    @Override
    public String getName() {
        return "SBML2MATLAB";
    }

    @Override
    public String getDescription() {
        return "It converts a model format from SBML to Matlab";
    }

    @Override
    public String getHtmlDescription() {
        return "It converts a model format from SBML to Matlab";
    }
}

