/*
 * Decompiled with CFR 0.152.
 */
package org.sbfc.converter.sbml2dot;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.identifiers.registry.RegistryLocalProvider;
import org.sbfc.converter.utils.sbgn.SBGNUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConstraintFileReader {
    public static final String MIRIAM_WS_URL = "http://www.ebi.ac.uk/compneur-srv/miriamws-main/MiriamWebServices";
    public static RegistryLocalProvider miriamWS;
    public static HashMap<String, String> officialURIs;
    public static HashMap<String, String> checkedURIs;
    private static Logger logger;

    public static void parseSBML2SBGNConfigFile(Hashtable<String, String> annotationSpecies) {
    }

    public static void parseSBML2SBGNConfigFile(Hashtable<String, String> annotationSpecies, Hashtable<String, String> publicationModel, Hashtable<String, String> speciesAnnotationMAP, Hashtable<String, String> taxonomyMap, String attributeClass) {
        String configFile = "SBML2SBGNConstraintFile.xml";
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder constructor = factory.newDocumentBuilder();
            BufferedInputStream xml = new BufferedInputStream(SBGNUtils.class.getResourceAsStream(configFile));
            Document document = constructor.parse(xml);
            Element root = document.getDocumentElement();
            Node annotationParameterNode = ConstraintFileReader.getChild(root, "constraints");
            Node publicationModelNode = ConstraintFileReader.getChild(annotationParameterNode, "publicationModel");
            Vector<Node> publicationList = ConstraintFileReader.getChildList(publicationModelNode, "publication");
            for (Node node : publicationList) {
                String publication = node.getTextContent();
                ConstraintFileReader.annotationMIRIAMName(miriamWS, publication, publicationModel, miriamWS.getName(publication));
            }
            Node speciesAnnotationMapNode = ConstraintFileReader.getChild(annotationParameterNode, "speciesAnnotationMap");
            Vector<Node> speciesList = ConstraintFileReader.getChildList(speciesAnnotationMapNode, "species");
            for (int i = 0; i < speciesList.size(); ++i) {
                String species = speciesList.get(i).getTextContent();
                ConstraintFileReader.annotationMIRIAMName(miriamWS, species, speciesAnnotationMAP, miriamWS.getName(species));
            }
            Node taxonomyMapNode = ConstraintFileReader.getChild(annotationParameterNode, "taxonomyMap");
            Vector<Node> taxonomyList = ConstraintFileReader.getChildList(taxonomyMapNode, "taxonomy");
            for (int i = 0; i < taxonomyList.size(); ++i) {
                String taxonomy = taxonomyList.get(i).getTextContent();
                ConstraintFileReader.annotationMIRIAMName(miriamWS, taxonomy, taxonomyMap, miriamWS.getName(taxonomy));
            }
            Node annotationSpeciesNode = ConstraintFileReader.getChild(annotationParameterNode, "annotationSpecies");
            Vector<Node> physicalEntityList = ConstraintFileReader.getChildList(annotationSpeciesNode, "physicalEntity");
            for (Node physicalEntityNode : physicalEntityList) {
                String classOfEntity = ((Element)physicalEntityNode).getAttribute(attributeClass);
                logger.debug((Object)("\nConstraintFileReader : parse : " + attributeClass + " = " + classOfEntity));
                Vector<Node> physicalEntitySpecies = ConstraintFileReader.getChildList(physicalEntityNode, "species");
                for (Node speciesNode : physicalEntitySpecies) {
                    String species = speciesNode.getTextContent();
                    ConstraintFileReader.annotationMIRIAM(miriamWS, species, annotationSpecies, classOfEntity);
                }
                logger.debug((Object)"ConstraintFileReader : parse config file : official constraints :");
                Vector<Node> physicalEntityConstraintList = ConstraintFileReader.getChildList(physicalEntityNode, "constraint");
                for (Node physicalEntityConstraintNode : physicalEntityConstraintList) {
                    String constraint = physicalEntityConstraintNode.getTextContent();
                    logger.debug((Object)(" file constraint URI = " + constraint));
                    String officialConstraintURI = miriamWS.getMiriamURI(constraint);
                    logger.debug((Object)(" official constraint URI : " + officialConstraintURI + " = " + classOfEntity));
                    if (officialConstraintURI == null) {
                        officialConstraintURI = constraint;
                    }
                    annotationSpecies.put(officialConstraintURI, classOfEntity);
                }
            }
        }
        catch (ParserConfigurationException pce) {
            System.err.println("DOM parser configuration error, while the call factory.newDocumentBuilder();");
        }
        catch (SAXException se) {
            System.err.println("Error during the document parsing, while the call construtor.parse(xml)");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.err.println("Input/Output Error, while the call construtor.parse(xml)\nCheck that the project contain the SBML2BioPAXconfigFile.xml");
        }
    }

    public static Node getChild(Node node, String pattern) {
        int i;
        NodeList nodeList = node.getChildNodes();
        Node child = null;
        for (i = 0; i < nodeList.getLength() && !nodeList.item(i).getNodeName().equals(pattern); ++i) {
        }
        if (i < nodeList.getLength()) {
            child = nodeList.item(i);
        }
        return child;
    }

    public static Vector<Node> getChildList(Node node, String pattern) {
        NodeList nodeList = node.getChildNodes();
        Vector<Node> childlist = new Vector<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).getNodeName().equals(pattern)) continue;
            childlist.add(nodeList.item(i));
        }
        return childlist;
    }

    public static void annotationMIRIAM(RegistryLocalProvider linkMiriam, String URI2, Hashtable<String, String> table, String type) {
        if (checkedURIs.get(URI2) != null) {
            return;
        }
        checkedURIs.put(URI2, "done");
        String name = linkMiriam.getName(URI2);
        String officialURN = linkMiriam.getOfficialDataTypeURI(URI2);
        officialURIs.put(URI2, officialURN);
        if (name.equals("")) {
            logger.debug((Object)(URI2 + " URI is not contain in MIRIAM database, no answer possible"));
        } else {
            String[] URIs = linkMiriam.getDataTypeURIs(name);
            for (int i = 0; i < URIs.length; ++i) {
                table.put(URIs[i], type);
                logger.debug((Object)("key: ." + URIs[i] + ".   value: " + type));
            }
        }
    }

    public static void annotationMIRIAMName(RegistryLocalProvider linkMiriam, String URI2, Hashtable<String, String> table, String miriamName) {
        String name = linkMiriam.getName(URI2);
        String officialURN = linkMiriam.getOfficialDataTypeURI(URI2);
        officialURIs.put(URI2, officialURN);
        if (name.equals("")) {
            logger.debug((Object)(URI2 + " URI is not contain in MIRIAM database, no answer possible"));
        } else {
            String[] URIs = linkMiriam.getDataTypeURIs(name);
            for (int i = 0; i < URIs.length; ++i) {
                table.put(URIs[i], miriamName);
            }
        }
    }

    static {
        officialURIs = new HashMap();
        checkedURIs = new HashMap();
        logger = Logger.getLogger(ConstraintFileReader.class);
        miriamWS = new RegistryLocalProvider();
    }
}

