/*
 * Decompiled with CFR 0.152.
 */
package org.sbfc.converter.sbml2biopax;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.identifiers.registry.RegistryLocalProvider;
import org.identifiers.registry.RegistryUtilities;
import org.sbfc.converter.sbml2biopax.SBML2BioPAX;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SBML2BioPAXannotationParameter {
    public static void parseSBML2BioPAXConfigFile(Hashtable<String, String> annotationSpecies, Hashtable<String, String> publicationModel, Hashtable<String, String> speciesAnnotationMAP, Hashtable<String, String> taxonomyMap) {
        String configFile = "SBML2BioPAXconfigFile_withConstraints.xml";
        RegistryLocalProvider linkMiriam = SBML2BioPAX.link;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder constructor = factory.newDocumentBuilder();
            BufferedInputStream xml = new BufferedInputStream(SBML2BioPAXannotationParameter.class.getResourceAsStream(configFile));
            Document document = constructor.parse(xml);
            Element root = document.getDocumentElement();
            Node annotationParameterNode = SBML2BioPAXannotationParameter.getChild(root, "sbml2biopaxAnnotationParameter");
            Node publicationModelNode = SBML2BioPAXannotationParameter.getChild(annotationParameterNode, "publicationModel");
            Vector<Node> publicationList = SBML2BioPAXannotationParameter.getChildList(publicationModelNode, "publication");
            for (Node node : publicationList) {
                String publication = node.getTextContent();
                SBML2BioPAXannotationParameter.annotationMIRIAM(linkMiriam, publication, publicationModel, linkMiriam.getName(publication));
            }
            Node speciesAnnotationMapNode = SBML2BioPAXannotationParameter.getChild(annotationParameterNode, "speciesAnnotationMap");
            Vector<Node> speciesList = SBML2BioPAXannotationParameter.getChildList(speciesAnnotationMapNode, "species");
            for (int i = 0; i < speciesList.size(); ++i) {
                String species = speciesList.get(i).getTextContent();
                SBML2BioPAXannotationParameter.annotationMIRIAM(linkMiriam, species, speciesAnnotationMAP, linkMiriam.getName(species));
            }
            Node taxonomyMapNode = SBML2BioPAXannotationParameter.getChild(annotationParameterNode, "taxonomyMap");
            Vector<Node> taxonomyList = SBML2BioPAXannotationParameter.getChildList(taxonomyMapNode, "taxonomy");
            for (int i = 0; i < taxonomyList.size(); ++i) {
                String taxonomy = taxonomyList.get(i).getTextContent();
                SBML2BioPAXannotationParameter.annotationMIRIAM(linkMiriam, taxonomy, taxonomyMap, linkMiriam.getName(taxonomy));
            }
            Node annotationSpeciesNode = SBML2BioPAXannotationParameter.getChild(annotationParameterNode, "annotationSpecies");
            Vector<Node> physicalEntityList = SBML2BioPAXannotationParameter.getChildList(annotationSpeciesNode, "physicalEntity");
            for (Node physicalEntityNode : physicalEntityList) {
                String classBioPAX = physicalEntityNode.getAttributes().item(0).getNodeValue();
                Vector<Node> physicalEntitySpecies = SBML2BioPAXannotationParameter.getChildList(physicalEntityNode, "species");
                for (Node speciesNode : physicalEntitySpecies) {
                    String species = speciesNode.getTextContent();
                    SBML2BioPAXannotationParameter.annotationMIRIAM(linkMiriam, species, annotationSpecies, classBioPAX);
                }
                Vector<Node> physicalEntityConstraintList = SBML2BioPAXannotationParameter.getChildList(physicalEntityNode, "constraint");
                for (Node physicalEntityConstraintNode : physicalEntityConstraintList) {
                    String constraint = physicalEntityConstraintNode.getTextContent();
                    String officialConstraint = linkMiriam.getMiriamURI(constraint);
                    if (officialConstraint != null) {
                        annotationSpecies.put(officialConstraint, classBioPAX);
                        continue;
                    }
                    officialConstraint = RegistryUtilities.convertURN((String)constraint);
                    annotationSpecies.put(officialConstraint, classBioPAX);
                }
            }
        }
        catch (ParserConfigurationException pce) {
            System.err.println("DOM parser configuration error, while the call factory.newDocumentBuilder();");
        }
        catch (SAXException se) {
            System.err.println("Error during the document parsing, while the call construtor.parse(xml)");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.err.println("Input/Output Error, while the call construtor.parse(xml)\nCheck that the project contain the SBML2BioPAXconfigFile.xml");
        }
    }

    public static Node getChild(Node node, String pattern) {
        int i;
        NodeList nodeList = node.getChildNodes();
        Node child = null;
        for (i = 0; i < nodeList.getLength() && !nodeList.item(i).getNodeName().equals(pattern); ++i) {
        }
        if (i < nodeList.getLength()) {
            child = nodeList.item(i);
        }
        return child;
    }

    public static Vector<Node> getChildList(Node node, String pattern) {
        NodeList nodeList = node.getChildNodes();
        Vector<Node> childlist = new Vector<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).getNodeName().equals(pattern)) continue;
            childlist.add(nodeList.item(i));
        }
        return childlist;
    }

    public static void annotationMIRIAM(RegistryLocalProvider linkMiriam, String URI2, Hashtable<String, String> table, String type) {
        String name = linkMiriam.getName(URI2);
        String officialURI = linkMiriam.getOfficialDataTypeURI(URI2);
        SBML2BioPAX.officialURIs.put(URI2, officialURI);
        SBML2BioPAX.officialNames.put(URI2, name);
        SBML2BioPAX.officialNames.put(officialURI, name);
        if (name.equals("")) {
            System.out.println(URI2 + " URI is not contain in MIRIAM database, no answer possible");
        } else {
            String[] URIs = linkMiriam.getDataTypeURIs(name);
            for (int i = 0; i < URIs.length; ++i) {
                table.put(URIs[i], type);
            }
        }
    }
}

