/*
 * Decompiled with CFR 0.152.
 */
package org.sbfc.converter.sbml2biopax;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXFactory;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.Catalysis;
import org.biopax.paxtools.model.level3.CellularLocationVocabulary;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.ControlType;
import org.biopax.paxtools.model.level3.ControlledVocabulary;
import org.biopax.paxtools.model.level3.Controller;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.ConversionDirectionType;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.Level3Element;
import org.biopax.paxtools.model.level3.Named;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.paxtools.model.level3.Provenance;
import org.biopax.paxtools.model.level3.Stoichiometry;
import org.biopax.paxtools.model.level3.XReferrable;
import org.biopax.paxtools.model.level3.Xref;
import org.identifiers.registry.RegistryLocalProvider;
import org.identifiers.registry.RegistryUtilities;
import org.sbfc.converter.GeneralConverter;
import org.sbfc.converter.exceptions.ConversionException;
import org.sbfc.converter.exceptions.ReadModelException;
import org.sbfc.converter.models.BioPAXModel;
import org.sbfc.converter.models.GeneralModel;
import org.sbfc.converter.models.SBMLModel;
import org.sbfc.converter.sbml2biopax.SBML2BioPAXannotationParameter;
import org.sbfc.converter.utils.sbml.sbmlannotation.MiriamAnnotation;
import org.sbml.jsbml.CVTerm;
import org.sbml.jsbml.Compartment;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBO;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.SpeciesReference;

public abstract class SBML2BioPAX
extends GeneralConverter {
    protected String PHYSICAL_ENTITY = "PhysicalEntity";
    protected String CELLULAR_LOCATION_VOCABULARY = "CellularLocationVocabulary";
    protected String PROVENANCE_CLASS_NAME = "Provenance";
    protected String BIO_SOURCE = "BioSource";
    protected String PATHWAY_CLASS_NAME = "Pathway";
    protected String CONTROL = "Control";
    protected String BIOCHEMICAL_REACTION = "BiochemicalReaction";
    protected String COMPLEX_DIS_ASSEMBLY = "ComplexDisAssembly";
    protected String COMPLEX_ASSEMBLY = "ComplexAssembly";
    protected String TRANSPORT = "Transport";
    protected String LEFT_OF_REACTION = "LEFT";
    protected String RIGHT_OF_REACTION = "RIGHT";
    protected String PUBLICATION_XREF_CLASS_NAME = "PublicationXref";
    protected String UNIFICATION_XREF_CLASS_NAME = "UnificationXref";
    protected String PHYSICAL_ENTITY_PARTICIPANT = "PhysicalEntity";
    protected String INTERACTION = "Interaction";
    protected String CATALYSIS = "Catalysis";
    protected static final String EC_CODE_URI = "http://identifiers.org/ec-code";
    protected static final String BIOMODELS_URI = "http://identifiers.org/biomodels.db/";
    public static String VERSION = "3.1";
    public static final String MIRIAM_WS_URL = "http://www.ebi.ac.uk/miriamws/main/MiriamWebServices";
    public static RegistryLocalProvider link;
    public static HashMap<String, String> officialURIs;
    public static HashMap<String, String> officialNames;
    protected int biopaxLevel = 3;

    public BioPAXModel biopaxexport(SBMLModel sbmlmodel) throws SBMLException {
        String annotationDB;
        MiriamAnnotation miriamAnnotation;
        BioPAXElement xref;
        BioPAXFactory bioPAXFactory;
        Hashtable<String, String> annotationSpecies = new Hashtable<String, String>();
        Hashtable<String, String> publicationModel = new Hashtable<String, String>();
        Hashtable<String, String> speciesAnnotationMap = new Hashtable<String, String>();
        Hashtable<String, String> taxonomyMap = new Hashtable<String, String>();
        Hashtable<String, BioPAXElement> annotationXMLId = new Hashtable<String, BioPAXElement>();
        int nbDatasource = 0;
        int nbBiosource = 0;
        boolean biomodelsCommentAdded = false;
        SBML2BioPAXannotationParameter.parseSBML2BioPAXConfigFile(annotationSpecies, publicationModel, speciesAnnotationMap, taxonomyMap);
        BioPAXFactory elementFactory = bioPAXFactory = this.getBioPaxFactory();
        BioPAXModel bioPaxModelGen = new BioPAXModel(bioPAXFactory.createModel());
        Model bioPaxModel = bioPaxModelGen.getModel();
        org.sbml.jsbml.Model sbmlModel = sbmlmodel.getModel();
        if (sbmlModel == null) {
            throw new SBMLException("SBML2BioPAX: Input file is not a regular SBML file.");
        }
        String idmodel = new String();
        idmodel = sbmlModel.isSetId() ? sbmlModel.getId() : (sbmlModel.isSetName() ? sbmlModel.getName() : "BioModel");
        BioPAXElement pathway = elementFactory.create(this.PATHWAY_CLASS_NAME, idmodel);
        this.addComment(pathway, "This BioPAX Level" + this.biopaxLevel + " file was automatically generated on " + DateFormat.getDateInstance().format(new Date()) + " by SBML2BioPAX-" + VERSION + ", BioModels.net, EMBL-EBI.");
        bioPaxModel.add(pathway);
        for (CVTerm cvterm : sbmlModel.getAnnotation().getListOfCVTerms()) {
            for (Object annotationURI : cvterm.getResources()) {
                MiriamAnnotation miriamAnnotation2 = this.parseMiriamAnnotation(this.updatedAnnotation((String)annotationURI));
                if (miriamAnnotation2 != null) {
                    BioPAXElement xref2;
                    Iterator annotationDB2 = miriamAnnotation2.getUri();
                    String annotationIdentifier = miriamAnnotation2.getId();
                    String rdfId = miriamAnnotation2.getIdentifiers_orgURI();
                    if (rdfId == null) {
                        SBML2BioPAX.debug("Could not create a proper miriamAnnotation for " + (String)annotationURI);
                        continue;
                    }
                    if (publicationModel.containsKey(annotationDB2)) {
                        String annotationDBname = publicationModel.get(annotationDB2);
                        xref = (BioPAXElement)annotationXMLId.get(rdfId);
                        if (xref == null) {
                            xref = elementFactory.create(this.PUBLICATION_XREF_CLASS_NAME, rdfId);
                            this.setXrefDb(xref, annotationDBname);
                            this.setXrefId(xref, annotationIdentifier);
                            annotationXMLId.put(rdfId, xref);
                            bioPaxModel.add(xref);
                        }
                        this.addXref(pathway, xref);
                        continue;
                    }
                    if (taxonomyMap.containsKey(annotationDB2)) {
                        xref2 = (BioPAXElement)annotationXMLId.get(rdfId);
                        if (xref2 == null) {
                            xref2 = elementFactory.create(this.UNIFICATION_XREF_CLASS_NAME, rdfId);
                            this.setXrefId(xref2, annotationIdentifier);
                            this.setXrefDb(xref2, taxonomyMap.get(annotationDB2));
                            annotationXMLId.put(rdfId, xref2);
                            bioPaxModel.add(xref2);
                        }
                        BioPAXElement biosource = elementFactory.create(this.BIO_SOURCE, "biosource_" + ++nbBiosource);
                        this.addXref(biosource, xref2);
                        this.setOrganismToPathway(pathway, biosource);
                        bioPaxModel.add(biosource);
                        continue;
                    }
                    xref2 = (BioPAXElement)annotationXMLId.get(rdfId);
                    if (xref2 == null) {
                        xref2 = elementFactory.create(this.UNIFICATION_XREF_CLASS_NAME, rdfId);
                        this.setXrefId(xref2, annotationIdentifier);
                        String db = speciesAnnotationMap.get(annotationDB2);
                        if (db == null) {
                            SBML2BioPAX.debug("The database " + annotationDB2 + " is not in the speciesAnnotation Map");
                            db = this.getDatatypeName((String)((Object)annotationDB2));
                        }
                        this.setXrefDb(xref2, db);
                        annotationXMLId.put(rdfId, xref2);
                        bioPaxModel.add(xref2);
                    }
                    this.addXref(pathway, xref2);
                    if (!((String)((Object)annotationDB2)).equals(BIOMODELS_URI) || !cvterm.isModelQualifier() || !cvterm.getModelQualifierType().equals((Object)CVTerm.Qualifier.BQM_IS)) continue;
                    if (!biomodelsCommentAdded) {
                        this.addComment(pathway, "The original model, '" + sbmlModel.getId() + "', was published in BioModels Database (http://www.ebi.ac.uk/biomodels/).");
                        biomodelsCommentAdded = true;
                    }
                    BioPAXElement datasource = elementFactory.create(this.PROVENANCE_CLASS_NAME, "datasource_" + ++nbDatasource);
                    this.addName(datasource, "BioModels Database");
                    this.setDisplayName(datasource, "BioModels Database");
                    this.addXref(datasource, xref2);
                    bioPaxModel.add(datasource);
                    this.addDataSource(pathway, datasource);
                    continue;
                }
                SBML2BioPAX.debug("Could not create a proper miriamAnnotation for " + (String)annotationURI);
            }
        }
        for (Compartment compartment : sbmlModel.getListOfCompartments()) {
            BioPAXElement vocab = elementFactory.create(this.CELLULAR_LOCATION_VOCABULARY, compartment.getId());
            bioPaxModel.add(vocab);
            if (compartment.isSetName()) {
                this.addTerm(vocab, compartment.getName());
            } else {
                this.addTerm(vocab, compartment.getId());
            }
            for (CVTerm cvterm : compartment.getAnnotation().getListOfCVTerms()) {
                for (String annotation : cvterm.getResources()) {
                    MiriamAnnotation miriamAnnotation3 = this.parseMiriamAnnotation(this.updatedAnnotation(annotation));
                    if (miriamAnnotation3 == null) {
                        SBML2BioPAX.debug("Could not create a proper miriamAnnotation for " + annotation);
                        continue;
                    }
                    Object annotationDB3 = miriamAnnotation3.getUri();
                    String annotationIdentifier = miriamAnnotation3.getId();
                    String rdfId = miriamAnnotation3.getIdentifiers_orgURI();
                    if (speciesAnnotationMap.containsKey(annotationDB3)) {
                        annotationDB3 = speciesAnnotationMap.get(annotationDB3);
                    } else {
                        SBML2BioPAX.debug("The database " + (String)annotationDB3 + " is not in the speciesAnnotation Map");
                        annotationDB3 = this.getDatatypeName((String)annotationDB3);
                    }
                    BioPAXElement xref3 = (BioPAXElement)annotationXMLId.get(rdfId);
                    if (xref3 == null) {
                        xref3 = elementFactory.create(this.UNIFICATION_XREF_CLASS_NAME, rdfId);
                        this.setXrefId(xref3, annotationIdentifier);
                        this.setXrefDb(xref3, (String)annotationDB3);
                        annotationXMLId.put(rdfId, xref3);
                    }
                    this.addXref(vocab, xref3);
                    if (bioPaxModel.getByID(rdfId) != null) continue;
                    bioPaxModel.add(xref3);
                }
            }
        }
        for (Species species : sbmlModel.getListOfSpecies()) {
            String physicalEntityType = this.PHYSICAL_ENTITY;
            boolean isAComplex = false;
            ArrayList<MiriamAnnotation> speciesAnnotationList = new ArrayList<MiriamAnnotation>();
            for (CVTerm cvterm : species.getAnnotation().getListOfCVTerms()) {
                CVTerm.Qualifier cvTermQualifier = CVTerm.Qualifier.BQB_UNKNOWN;
                if (cvterm.isBiologicalQualifier()) {
                    cvTermQualifier = cvterm.getBiologicalQualifierType();
                }
                if (cvTermQualifier.equals((Object)CVTerm.Qualifier.BQB_HAS_PART)) {
                    isAComplex = true;
                }
                for (String annotation : cvterm.getResources()) {
                    miriamAnnotation = this.parseMiriamAnnotation(this.updatedAnnotation(annotation));
                    if (miriamAnnotation == null) {
                        SBML2BioPAX.debug("Could not create a proper miriamAnnotation for " + annotation);
                        continue;
                    }
                    annotationDB = miriamAnnotation.getUri();
                    String annotationTestEnsembl = "";
                    String annotationTestEnsembl2 = "";
                    speciesAnnotationList.add(miriamAnnotation);
                    String officialAnnotation = miriamAnnotation.getFullURI();
                    if (annotationDB.length() + 8 < officialAnnotation.length()) {
                        annotationTestEnsembl = officialAnnotation.substring(0, officialAnnotation.lastIndexOf("/") + 8);
                        annotationTestEnsembl2 = officialAnnotation.substring(0, officialAnnotation.lastIndexOf("/") + 5);
                    }
                    if (annotationSpecies.containsKey(annotationDB)) {
                        if (annotationSpecies.get(annotationDB).equals("complex")) {
                            isAComplex = true;
                        }
                        physicalEntityType = annotationSpecies.get(annotationDB);
                        if (!annotationSpecies.containsKey(officialAnnotation)) continue;
                        physicalEntityType = annotationSpecies.get(officialAnnotation);
                        continue;
                    }
                    if (annotationSpecies.containsKey(annotationTestEnsembl) || annotationSpecies.containsKey(annotationTestEnsembl2)) {
                        if (annotationSpecies.containsKey(annotationTestEnsembl)) {
                            physicalEntityType = annotationSpecies.get(annotationTestEnsembl);
                            continue;
                        }
                        physicalEntityType = annotationSpecies.get(annotationTestEnsembl2);
                        continue;
                    }
                    if (!annotationSpecies.containsKey(officialAnnotation)) continue;
                    physicalEntityType = annotationSpecies.get(officialAnnotation);
                }
                if (!isAComplex) continue;
                physicalEntityType = "Complex";
            }
            if (this.biopaxLevel == 2) {
                physicalEntityType = physicalEntityType.substring(0, 1).toLowerCase() + physicalEntityType.substring(1);
            }
            BioPAXElement physicalEntity = elementFactory.create(physicalEntityType, species.getId());
            if (species.isSetName()) {
                this.setDisplayName(physicalEntity, species.getName());
                this.addName(physicalEntity, species.getName());
            } else {
                this.setDisplayName(physicalEntity, species.getId());
            }
            for (int l = 0; l < speciesAnnotationList.size(); ++l) {
                MiriamAnnotation miriamAnno = (MiriamAnnotation)speciesAnnotationList.get(l);
                String rdfId = miriamAnno.getIdentifiers_orgURI();
                if (rdfId == null) {
                    SBML2BioPAX.debug("Could not create a proper miriamAnnotation for '" + ((MiriamAnnotation)speciesAnnotationList.get(l)).getUri() + "' : '" + ((MiriamAnnotation)speciesAnnotationList.get(l)).getId());
                    continue;
                }
                xref = (BioPAXElement)annotationXMLId.get(rdfId);
                if (xref == null) {
                    xref = elementFactory.create(this.UNIFICATION_XREF_CLASS_NAME, rdfId);
                    this.setXrefId(xref, miriamAnno.getId());
                    this.setXrefDb(xref, officialNames.get(miriamAnno.getUri()));
                    annotationXMLId.put(rdfId, xref);
                }
                this.addXref(physicalEntity, xref);
                if (bioPaxModel.getByID(rdfId) != null) continue;
                bioPaxModel.add(xref);
            }
            bioPaxModel.add(physicalEntity);
        }
        for (Reaction reaction : sbmlModel.getListOfReactions()) {
            int i;
            BioPAXElement bioReaction;
            String conversionId = "conversion_" + reaction.getId();
            String interactionType = this.INTERACTION;
            String reactionType = this.findReactionType(reaction, bioPaxModel);
            if (reactionType.equals(this.COMPLEX_DIS_ASSEMBLY) || reactionType.equals(this.COMPLEX_ASSEMBLY)) {
                bioReaction = elementFactory.create(this.COMPLEX_ASSEMBLY, conversionId);
                this.setSpontaneous(bioReaction, true);
                if (reactionType.equals(this.COMPLEX_ASSEMBLY)) {
                    this.setConversionDirection(bioReaction, ConversionDirectionType.LEFT_TO_RIGHT);
                } else {
                    this.setConversionDirection(bioReaction, ConversionDirectionType.RIGHT_TO_LEFT);
                }
            } else {
                bioReaction = elementFactory.create(reactionType, conversionId);
            }
            if (reaction.isSetName()) {
                this.setDisplayName(bioReaction, reaction.getName());
                this.addName(bioReaction, reaction.getName());
            } else {
                this.setDisplayName(bioReaction, reaction.getId());
            }
            for (CVTerm cvterm : reaction.getAnnotation().getListOfCVTerms()) {
                for (String annotation : cvterm.getResources()) {
                    String ECcodeName;
                    miriamAnnotation = this.parseMiriamAnnotation(annotation);
                    if (miriamAnnotation == null) {
                        SBML2BioPAX.debug("Could not create a proper miriamAnnotation for " + annotation);
                        continue;
                    }
                    annotationDB = miriamAnnotation.getUri();
                    String annotationIdentifier = miriamAnnotation.getId();
                    String rdfId = miriamAnnotation.getIdentifiers_orgURI();
                    String datatypeName = officialNames.get(annotationDB);
                    BioPAXElement xref4 = (BioPAXElement)annotationXMLId.get(rdfId);
                    if (datatypeName == null) {
                        datatypeName = this.getDatatypeName(annotationDB);
                        officialNames.put(annotationDB, datatypeName);
                    }
                    if (xref4 == null) {
                        xref4 = elementFactory.create(this.UNIFICATION_XREF_CLASS_NAME, rdfId);
                        this.setXrefId(xref4, annotationIdentifier);
                        this.setXrefDb(xref4, datatypeName);
                        annotationXMLId.put(rdfId, xref4);
                    }
                    this.addXref(bioReaction, xref4);
                    if (bioPaxModel.getByID(rdfId) == null) {
                        bioPaxModel.add(xref4);
                    }
                    if (!datatypeName.equals(ECcodeName = officialNames.get(EC_CODE_URI))) continue;
                    interactionType = this.CATALYSIS;
                }
            }
            for (i = 0; i < reaction.getReactantCount(); ++i) {
                this.addReactant(bioPaxModel, bioReaction, elementFactory, reaction.getReactant(i), i);
            }
            for (i = 0; i < reaction.getProductCount(); ++i) {
                this.addProduct(bioPaxModel, bioReaction, elementFactory, reaction.getProduct(i), i);
            }
            if (reaction.getModifierCount() > 0) {
                String interactionId = "interaction_" + reaction.getId();
                Set<? extends BioPAXElement> setOfInteraction = this.getListOfControl(bioReaction);
                for (int i2 = 0; i2 < reaction.getModifierCount(); ++i2) {
                    Species speciesInstance = reaction.getModifier(i2).getSpeciesInstance();
                    BioPAXElement reacInteraction = SBO.isInhibitor((int)reaction.getSBOTerm()) || SBO.isChildOf((int)reaction.getSBOTerm(), (int)459) ? elementFactory.create(this.CATALYSIS, interactionId + "_" + speciesInstance.getId() + "_" + i2) : elementFactory.create(this.INTERACTION, interactionId + "_" + speciesInstance.getId() + "_" + i2);
                    if (reacInteraction instanceof Control) {
                        BioPAXElement newPEP = elementFactory.create(this.PHYSICAL_ENTITY_PARTICIPANT, "PEP" + i2 + "_" + interactionId + speciesInstance.getId());
                        this.setDisplayName(newPEP, speciesInstance.getId());
                        this.setCellularLocation(newPEP, bioPaxModel.getByID(speciesInstance.getCompartment()));
                        this.addMemberPhysicalEntity(newPEP, bioPaxModel.getByID(speciesInstance.getId()));
                        this.addController(reacInteraction, newPEP);
                        this.addControlled(reacInteraction, bioReaction);
                        bioPaxModel.add(newPEP);
                    }
                    this.setInteractionType(reacInteraction, reaction);
                    this.addControl(setOfInteraction, reacInteraction);
                    bioPaxModel.add(reacInteraction);
                }
            }
            this.addPathwayComponent(pathway, bioReaction);
            bioPaxModel.add(bioReaction);
        }
        return bioPaxModelGen;
    }

    private String updatedAnnotation(String annotationURI) {
        String updateAnnotation = link.getMiriamURI(annotationURI);
        if (updateAnnotation != null) {
            return updateAnnotation;
        }
        System.out.println("Annotation '" + annotationURI + "' was not recognized by miriam !!");
        return annotationURI;
    }

    protected void setInteractionType(BioPAXElement reacInteraction, Reaction reaction) {
        if (reacInteraction instanceof Catalysis) {
            ControlType bioPaxControlType = null;
            if (SBO.isInhibitor((int)reaction.getSBOTerm())) {
                bioPaxControlType = ControlType.INHIBITION;
            } else if (SBO.isChildOf((int)reaction.getSBOTerm(), (int)459)) {
                bioPaxControlType = ControlType.ACTIVATION;
            }
            if (bioPaxControlType != null) {
                ((Control)reacInteraction).setControlType(bioPaxControlType);
            }
        }
    }

    protected void addControlled(BioPAXElement reacControl, BioPAXElement bioReaction) {
        if (reacControl instanceof Control && bioReaction instanceof Process) {
            ((Control)reacControl).addControlled((Process)bioReaction);
        }
    }

    protected void addController(BioPAXElement reacControl, BioPAXElement physicalEntityParticipant) {
        if (reacControl instanceof Control && physicalEntityParticipant instanceof PhysicalEntity) {
            ((Control)reacControl).addController((Controller)physicalEntityParticipant);
        }
    }

    protected void addControl(Set<? extends BioPAXElement> setOfcontrol, BioPAXElement reacControl) {
        if (reacControl instanceof Control) {
            setOfcontrol.add((BioPAXElement)((Control)reacControl));
        } else {
            SBML2BioPAX.println("addControl problem !! " + reacControl);
        }
    }

    protected Set<? extends BioPAXElement> getListOfControl(BioPAXElement bioReaction) {
        if (bioReaction instanceof Control) {
            return ((Control)bioReaction).getControlledOf();
        }
        SBML2BioPAX.println("getListOfControl problem !! " + bioReaction);
        return null;
    }

    protected Set<? extends BioPAXElement> getListOfConversion(BioPAXElement bioReaction) {
        if (bioReaction instanceof Conversion) {
            return ((Conversion)bioReaction).getControlledOf();
        }
        SBML2BioPAX.println("getListOfConversion problem !! " + bioReaction);
        return null;
    }

    protected Set<? extends BioPAXElement> getListOfInteraction(BioPAXElement bioReaction) {
        if (bioReaction instanceof Interaction) {
            return ((Interaction)bioReaction).getControlledOf();
        }
        SBML2BioPAX.println("getListOfConversion problem !! " + bioReaction);
        return null;
    }

    protected void setConversionDirection(BioPAXElement bioReaction, ConversionDirectionType direction) {
        if (bioReaction instanceof Conversion) {
            ((Conversion)bioReaction).setConversionDirection(direction);
        }
    }

    protected void setSpontaneous(BioPAXElement bioReaction, boolean spontaneous) {
        if (bioReaction instanceof Conversion) {
            ((Conversion)bioReaction).setSpontaneous(Boolean.valueOf(spontaneous));
        }
    }

    protected void addTerm(BioPAXElement vocab, String term) {
        if (vocab instanceof ControlledVocabulary) {
            ((ControlledVocabulary)vocab).addTerm(term);
        }
    }

    protected void addDataSource(BioPAXElement pathway, BioPAXElement datasource) {
        if (pathway instanceof Pathway && datasource instanceof Provenance) {
            ((Pathway)pathway).addDataSource((Provenance)datasource);
        }
    }

    protected void setDisplayName(BioPAXElement named, String displayName) {
        if (named instanceof Named) {
            ((Named)named).setDisplayName(displayName);
        }
    }

    protected void addName(BioPAXElement named, String name) {
        if (named instanceof Named) {
            ((Named)named).addName(name);
        }
    }

    protected void setXrefId(BioPAXElement xref, String annotationIdentifier) {
        if (xref instanceof Xref) {
            ((Xref)xref).setId(annotationIdentifier);
        }
    }

    protected void setXrefDb(BioPAXElement xref, String annotationDBname) {
        if (xref instanceof Xref) {
            ((Xref)xref).setDb(annotationDBname);
        }
    }

    protected void addPathwayComponent(BioPAXElement pathway, BioPAXElement bioReaction) {
        if (pathway instanceof Pathway && bioReaction instanceof Process) {
            ((Pathway)pathway).addPathwayComponent((Process)bioReaction);
        }
    }

    protected void setOrganismToPathway(BioPAXElement pathway, BioPAXElement biosource) {
        if (pathway instanceof Pathway && biosource instanceof BioSource) {
            ((Pathway)pathway).setOrganism((BioSource)biosource);
        }
    }

    protected void addXref(BioPAXElement biopaxElement, BioPAXElement xref) {
        if (biopaxElement instanceof XReferrable && xref instanceof Xref) {
            ((XReferrable)biopaxElement).addXref((Xref)xref);
        }
    }

    protected void addComment(BioPAXElement biopaxElement, String commentString) {
        if (biopaxElement instanceof Level3Element) {
            ((Level3Element)biopaxElement).addComment(commentString);
        }
    }

    protected BioPAXFactory getBioPaxFactory() {
        if (this.biopaxLevel == 3) {
            return BioPAXLevel.L3.getDefaultFactory();
        }
        if (this.biopaxLevel == 2) {
            return BioPAXLevel.L2.getDefaultFactory();
        }
        return null;
    }

    private void addProduct(Model bioPaxModel, BioPAXElement bioReaction, BioPAXFactory elementFactory, SpeciesReference sr, int index) {
        this.addSpeciesReference(bioPaxModel, bioReaction, elementFactory, sr, this.RIGHT_OF_REACTION, index);
    }

    private void addReactant(Model bioPaxModel, BioPAXElement bioReaction, BioPAXFactory elementFactory, SpeciesReference sr, int index) {
        this.addSpeciesReference(bioPaxModel, bioReaction, elementFactory, sr, this.LEFT_OF_REACTION, index);
    }

    private void addSpeciesReference(Model bioPaxModel, BioPAXElement bioReaction, BioPAXFactory elementFactory, SpeciesReference speciesReferenceObj, String direction, int index) {
        String speciesReference = speciesReferenceObj.getSpecies();
        Species speciesInstance = speciesReferenceObj.getSpeciesInstance();
        BioPAXElement newPEP = elementFactory.create(this.PHYSICAL_ENTITY_PARTICIPANT, direction + "_" + index + "_" + bioReaction.getRDFId() + "_" + speciesReference);
        this.setDisplayName(newPEP, speciesReference);
        this.addMemberPhysicalEntity(newPEP, bioPaxModel.getByID(speciesReference));
        this.setCellularLocation(newPEP, bioPaxModel.getByID(speciesInstance.getCompartment()));
        double stoichiometry = speciesReferenceObj.getStoichiometry();
        BioPAXElement stoichio = this.setStoichiometry(bioReaction, newPEP, stoichiometry, direction + "_" + index + "_" + bioReaction.getRDFId() + "_" + speciesReference + "_STOICHIOMETRY", elementFactory);
        if (direction.equals(this.LEFT_OF_REACTION)) {
            this.addLeft(bioReaction, newPEP);
        } else if (direction.equals(this.RIGHT_OF_REACTION)) {
            this.addRight(bioReaction, newPEP);
        }
        bioPaxModel.add(newPEP);
        if (this.biopaxLevel == 3 && stoichio != null) {
            bioPaxModel.add(stoichio);
        }
    }

    protected void addRight(BioPAXElement bioReaction, BioPAXElement physicalEntityParticipant) {
        if (bioReaction instanceof Conversion && physicalEntityParticipant instanceof PhysicalEntity) {
            ((Conversion)bioReaction).addRight((PhysicalEntity)physicalEntityParticipant);
        }
    }

    protected void addLeft(BioPAXElement bioReaction, BioPAXElement physicalEntityParticipant) {
        if (bioReaction instanceof Conversion && physicalEntityParticipant instanceof PhysicalEntity) {
            ((Conversion)bioReaction).addLeft((PhysicalEntity)physicalEntityParticipant);
        }
    }

    protected BioPAXElement setStoichiometry(BioPAXElement bioReaction, BioPAXElement physicalEntityParticipant, double stoichiometry, String stochiometryId, BioPAXFactory elementFactory) {
        if (bioReaction instanceof Conversion && physicalEntityParticipant instanceof PhysicalEntity) {
            Stoichiometry stoichio = (Stoichiometry)elementFactory.create(Stoichiometry.class, stochiometryId);
            stoichio.setStoichiometricCoefficient((float)stoichiometry);
            stoichio.setPhysicalEntity((PhysicalEntity)physicalEntityParticipant);
            ((Conversion)bioReaction).addParticipantStoichiometry(stoichio);
            return stoichio;
        }
        SBML2BioPAX.println("setStoichiometry problem !! " + physicalEntityParticipant + "; " + bioReaction);
        return null;
    }

    protected void addMemberPhysicalEntity(BioPAXElement physicalEntityParticipant, BioPAXElement physicalEntity) {
        if (physicalEntityParticipant instanceof PhysicalEntity && physicalEntity instanceof PhysicalEntity) {
            ((PhysicalEntity)physicalEntityParticipant).addMemberPhysicalEntity((PhysicalEntity)physicalEntity);
        } else {
            SBML2BioPAX.println("addMemberPhysicalEntity problem !! " + physicalEntityParticipant + "; " + physicalEntity);
        }
    }

    protected void setCellularLocation(BioPAXElement physicalEntityParticipant, BioPAXElement cellularLocation) {
        if (physicalEntityParticipant instanceof PhysicalEntity && cellularLocation instanceof CellularLocationVocabulary) {
            ((PhysicalEntity)physicalEntityParticipant).setCellularLocation((CellularLocationVocabulary)cellularLocation);
        } else {
            SBML2BioPAX.println("setCellularLocation problem !! " + physicalEntityParticipant + "; " + cellularLocation);
        }
    }

    private String findReactionType(Reaction reaction, Model bioPaxModel) {
        ListOf listReactants = reaction.getListOfReactants();
        ListOf listProducts = reaction.getListOfProducts();
        int complexBalance = 0;
        for (SpeciesReference speciesReferenceReac : listReactants) {
            if (!this.isComplex(bioPaxModel, speciesReferenceReac.getSpecies())) continue;
            --complexBalance;
        }
        for (SpeciesReference speciesReferenceProd : listProducts) {
            if (!this.isComplex(bioPaxModel, speciesReferenceProd.getSpecies())) continue;
            ++complexBalance;
        }
        boolean isTransport = false;
        for (SpeciesReference speciesReferenceReac : listReactants) {
            String compartmentProd = "";
            String compartmentReac = speciesReferenceReac.getSpeciesInstance().getCompartment();
            for (SpeciesReference speciesReferenceProd : listProducts) {
                compartmentProd = speciesReferenceProd.getSpeciesInstance().getCompartment();
                if (compartmentProd.equals(compartmentReac)) continue;
                isTransport = true;
                break;
            }
            if (!isTransport) continue;
            break;
        }
        String reactionTypeReturn = isTransport ? this.TRANSPORT : (complexBalance > 0 ? this.COMPLEX_ASSEMBLY : (complexBalance < 0 ? this.COMPLEX_DIS_ASSEMBLY : this.BIOCHEMICAL_REACTION));
        return reactionTypeReturn;
    }

    protected boolean isComplex(Model bioPaxModel, String species) {
        return bioPaxModel.getByID(species) instanceof Complex;
    }

    private MiriamAnnotation parseMiriamAnnotation(String annotation) {
        String uri = link.getMiriamURI(annotation);
        String id = RegistryUtilities.getElementPart((String)uri);
        if (uri != null && id != null) {
            return new MiriamAnnotation(id, RegistryUtilities.getDataPart((String)uri), uri);
        }
        SBML2BioPAX.println("WARNING : the annotation '" + annotation + "' could not be handled correctly !!!");
        return null;
    }

    private String getDatatypeName(String uri) {
        return link.getName(uri);
    }

    private String checkDBname(String db) {
        db = db.replace(" ", "_").replace(":", "_").replace("/", "_").replace("(", "_").replace(")", "_");
        return db;
    }

    static void println(String msg) {
        System.out.println(msg);
    }

    static void println(boolean msg) {
        System.out.println(msg);
    }

    static void println(int msg) {
        System.out.println(msg);
    }

    static void println(double msg) {
        System.out.println(msg);
    }

    static void debug(String mesg) {
        System.out.println("DEBUG : " + mesg);
    }

    @Override
    public GeneralModel convert(GeneralModel model) throws ConversionException, ReadModelException {
        try {
            this.inputModel = model;
            return this.biopaxexport((SBMLModel)model);
        }
        catch (SBMLException e) {
            throw new ReadModelException(e);
        }
    }

    @Override
    public String getResultExtension() {
        return "-biopax" + this.biopaxLevel + ".owl";
    }

    @Override
    public String getName() {
        return "SBML2BioPAX";
    }

    @Override
    public String getDescription() {
        return "It converts a model format from SBML to BioPAX";
    }

    @Override
    public String getHtmlDescription() {
        return "It converts a model format from SBML to BioPAX";
    }

    static {
        officialURIs = new HashMap();
        officialNames = new HashMap();
        link = new RegistryLocalProvider();
    }
}

