/*
 * Decompiled with CFR 0.152.
 */
package org.sbfc.converter.sbml2apm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sbfc.converter.GeneralConverter;
import org.sbfc.converter.exceptions.ConversionException;
import org.sbfc.converter.exceptions.ReadModelException;
import org.sbfc.converter.models.APMModel;
import org.sbfc.converter.models.GeneralModel;
import org.sbfc.converter.models.SBMLModel;
import org.sbfc.converter.sbml2apm.APMFormulaCompilerNoPiecewise;
import org.sbfc.converter.sbml2apm.APMFormulaCompilerNoStepFunction;
import org.sbfc.converter.sbml2apm.APMID;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.AlgebraicRule;
import org.sbml.jsbml.AssignmentRule;
import org.sbml.jsbml.CVTerm;
import org.sbml.jsbml.Compartment;
import org.sbml.jsbml.Delay;
import org.sbml.jsbml.Event;
import org.sbml.jsbml.EventAssignment;
import org.sbml.jsbml.ExplicitRule;
import org.sbml.jsbml.FunctionDefinition;
import org.sbml.jsbml.KineticLaw;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.LocalParameter;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.Parameter;
import org.sbml.jsbml.RateRule;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.Rule;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.SpeciesReference;
import org.sbml.jsbml.StoichiometryMath;
import org.sbml.jsbml.Trigger;
import org.sbml.jsbml.util.compilers.ASTNodeCompiler;

public class SBML2APM
extends GeneralConverter {
    private String apmModel;
    private HashMap<Species, String> speciesFluxMap = new HashMap();
    private HashMap<Species, Boolean> isHasSubstanceUnits = new HashMap();
    Vector<String> mathOperators;
    ListOf<SpeciesReference> products;
    ListOf<SpeciesReference> reactants;
    private int nbParameters = 0;
    public static final Pattern idPattern = Pattern.compile("(_|[a-z]|[A-Z])(_|[a-z]|[A-Z]|[0-9])*");
    public static final Pattern plusMinusPattern = Pattern.compile("(\\+\\ \\-)");
    Model sbmlModel;
    private APMFormulaCompilerNoPiecewise apmFormulaCompiler = new APMFormulaCompilerNoPiecewise();
    private APMFormulaCompilerNoStepFunction apmStepFuncCompiler = new APMFormulaCompilerNoStepFunction();

    private String createHeader() {
        String apmModel = "\n!\n! This file is automatically generated with \n! the System Biology Format Converter (http://sbfc.sourceforge.net/)\n! from an SBML file.\n!\n";
        String modelName = this.sbmlModel.getName();
        if (modelName == null || modelName.trim().length() == 0) {
            modelName = this.sbmlModel.getId();
        }
        apmModel = apmModel + "\n!\n! Model name = " + modelName + "\n!\n";
        for (CVTerm cvTerm : this.sbmlModel.getCVTerms()) {
            if (!cvTerm.isModelQualifier()) continue;
            for (String uri : cvTerm.getResources()) {
                apmModel = apmModel + "! " + cvTerm.getModelQualifierType().getElementNameEquivalent() + " " + uri + "\n";
            }
        }
        apmModel = apmModel + "!\n";
        return apmModel;
    }

    public APMModel apmExport(SBMLModel sbmlmodel) throws SBMLException, ConversionException, ReadModelException {
        System.out.println("SBML2APM : apmExport : Export in progress...");
        this.sbmlModel = sbmlmodel.getModel();
        this.apmModel = this.createHeader();
        int varCount = 0;
        int eqCount = 0;
        int interCount = 0;
        ListOf functiondefinitions = this.sbmlModel.getListOfFunctionDefinitions();
        ListOf compartments = this.sbmlModel.getListOfCompartments();
        ListOf listOfSpecies = this.sbmlModel.getListOfSpecies();
        ListOf parameters = this.sbmlModel.getListOfParameters();
        ListOf rules = this.sbmlModel.getListOfRules();
        ListOf reactions = this.sbmlModel.getListOfReactions();
        ListOf events = this.sbmlModel.getListOfEvents();
        this.mathOperators = new Vector();
        this.mathOperators.add("exp");
        this.mathOperators.add("pow");
        this.mathOperators.add("root");
        this.mathOperators.add("sqrt");
        this.mathOperators.add("eq");
        this.mathOperators.add("neq");
        this.mathOperators.add("gt");
        this.mathOperators.add("geq");
        this.mathOperators.add("lt");
        this.mathOperators.add("leq");
        this.mathOperators.add("sin");
        this.mathOperators.add("cos");
        this.mathOperators.add("tan");
        this.mathOperators.add("atan2");
        this.mathOperators.add("asin");
        this.mathOperators.add("acos");
        this.mathOperators.add("atan");
        this.mathOperators.add("sinh");
        this.mathOperators.add("cosh");
        this.mathOperators.add("tanh");
        this.mathOperators.add("log");
        this.mathOperators.add("log10");
        this.mathOperators.add("ln");
        this.mathOperators.add("abs");
        this.mathOperators.add("pi");
        this.mathOperators.add("time");
        this.mathOperators.add("Time");
        this.mathOperators.add("delay");
        this.mathOperators.add("ceil");
        this.mathOperators.add("flr");
        this.mathOperators.add("e");
        this.mathOperators.add("E");
        this.mathOperators.add("t");
        this.mathOperators.add("if");
        this.mathOperators.add("then");
        this.mathOperators.add("else");
        try {
            String parameterVariable;
            String ruleVariable;
            System.out.println("Building ID maps...");
            for (Parameter parameter : parameters) {
                this.buildIdMap((SBase)parameter);
            }
            for (Compartment compartment : compartments) {
                this.buildIdMap((SBase)compartment);
            }
            for (Species species : listOfSpecies) {
                this.buildIdMap((SBase)species);
                if (!species.isHasOnlySubstanceUnits()) {
                    if (species.getCompartmentInstance().getSpatialDimensions() > 0.0) {
                        this.isHasSubstanceUnits.put(species, false);
                    }
                    if (species.getCompartmentInstance().getSpatialDimensions() != 0.0) continue;
                    this.isHasSubstanceUnits.put(species, true);
                    continue;
                }
                if (!species.isHasOnlySubstanceUnits()) continue;
                this.isHasSubstanceUnits.put(species, true);
            }
            for (Reaction reaction : reactions) {
                StoichiometryMath stoichiometryMath;
                double stoichiometry;
                String stoichiometryStr;
                String speciesFlux;
                Species species;
                this.buildIdMap((SBase)reaction);
                this.products = reaction.getListOfProducts();
                this.reactants = reaction.getListOfReactants();
                for (SpeciesReference reactant : this.reactants) {
                    species = reactant.getSpeciesInstance();
                    speciesFlux = this.speciesFluxMap.get(species);
                    stoichiometryStr = "1";
                    stoichiometry = reactant.getStoichiometry();
                    stoichiometryMath = reactant.getStoichiometryMath();
                    if (stoichiometryMath != null && stoichiometryMath.isSetMath()) {
                        stoichiometryStr = stoichiometryMath.getMath().toFormula();
                    } else if (stoichiometry != 0.0) {
                        stoichiometryStr = Double.toString(stoichiometry);
                    }
                    if (speciesFlux == null) {
                        speciesFlux = new String();
                    }
                    if (speciesFlux.length() != 0) {
                        speciesFlux = speciesFlux + " + ";
                    }
                    speciesFlux = speciesFlux + "(-" + stoichiometryStr + " * " + APMID.getAPMId(reaction.getId()) + ")";
                    this.speciesFluxMap.put(species, speciesFlux);
                }
                for (SpeciesReference product : this.products) {
                    species = product.getSpeciesInstance();
                    speciesFlux = this.speciesFluxMap.get(species);
                    stoichiometryStr = "1";
                    stoichiometry = product.getStoichiometry();
                    stoichiometryMath = product.getStoichiometryMath();
                    if (stoichiometryMath != null && stoichiometryMath.isSetMath()) {
                        stoichiometryStr = stoichiometryMath.getMath().toFormula();
                    } else if (stoichiometry != 0.0) {
                        stoichiometryStr = Double.toString(stoichiometry);
                    }
                    if (speciesFlux == null) {
                        speciesFlux = new String();
                    }
                    if (speciesFlux.length() != 0) {
                        speciesFlux = speciesFlux + " + ";
                    }
                    speciesFlux = speciesFlux + "( " + stoichiometryStr + " * " + APMID.getAPMId(reaction.getId()) + ")";
                    this.speciesFluxMap.put(species, speciesFlux);
                }
            }
            for (FunctionDefinition functiondefinition : functiondefinitions) {
                this.buildIdMap((SBase)functiondefinition);
            }
            this.apmModel = this.apmModel + "\nModel \n";
            for (FunctionDefinition functiondefinition : functiondefinitions) {
                String funcdefin = this.printFunctionDefinition(functiondefinition);
                this.apmModel = this.apmModel + "\n! FunctionDefinition id = " + functiondefinition.getId();
                this.apmModel = functiondefinition.isSetName() ? this.apmModel + ", name = " + functiondefinition.getName() + "\n" : this.apmModel + "\n";
                if (funcdefin == null) {
                    System.out.println("Inconsistent mathML operators in Function Definition");
                    this.apmModel = this.apmModel + "! Inconsistent mathML operators in Function Definition, function ignored";
                    continue;
                }
                this.apmModel = this.apmModel + "\t!" + funcdefin + "\n";
            }
            this.apmModel = this.apmModel + "! Compartments\n";
            for (Compartment compartment : compartments) {
                if (compartment.isConstant()) {
                    this.apmModel = this.apmModel + "!" + this.printConstantCompartment(compartment);
                    continue;
                }
                this.apmModel = this.apmModel + "!" + this.printCompartment(compartment);
            }
            this.apmModel = this.apmModel + "! End Compartments\n";
            this.apmModel = this.apmModel + " Parameters \n";
            System.out.println("Parameters...");
            for (Rule rule : rules) {
                ruleVariable = null;
                if (rule instanceof AlgebraicRule) {
                    // empty if block
                }
                if (ruleVariable == null) continue;
                ++this.nbParameters;
                this.apmModel = this.apmModel + ruleVariable;
            }
            for (Parameter parameter : parameters) {
                parameterVariable = null;
                parameterVariable = parameter.isConstant() ? this.printParameterConstant(parameter) : this.printParameter(parameter);
                if (parameterVariable == null) continue;
                this.apmModel = this.apmModel + parameterVariable;
                ++this.nbParameters;
            }
            this.apmModel = this.apmModel + " End Parameters \n\n";
            this.apmModel = this.apmModel + " Variables\n";
            System.out.println("Variables...");
            for (Parameter parameter : parameters) {
                parameterVariable = null;
                if (!parameter.isConstant()) {
                    parameterVariable = this.printParameter(parameter);
                }
                if (parameterVariable != null) continue;
            }
            for (Rule rule : rules) {
                ruleVariable = null;
                if (!(rule instanceof AlgebraicRule)) {
                    ruleVariable = this.printRuleVariable(rule);
                }
                if (ruleVariable == null) continue;
                this.apmModel = this.apmModel + ruleVariable;
                ++varCount;
            }
            for (Species species : listOfSpecies) {
                if (species.isConstant()) {
                    this.apmModel = this.apmModel + this.printConstantSpecies(species);
                    ++varCount;
                    continue;
                }
                String speciesVariable = this.printSpeciesVariable(species);
                if (speciesVariable == null) continue;
                this.apmModel = this.apmModel + speciesVariable;
                ++varCount;
            }
            this.apmModel = this.apmModel + " End Variables\n\n";
            System.out.println("Intermediates...");
            this.apmModel = this.apmModel + " Intermediates\n";
            for (Rule rule : rules) {
                ruleVariable = null;
                if (!(rule instanceof AlgebraicRule)) {
                    ruleVariable = this.printRuleIntermediate(rule);
                }
                if (ruleVariable == null) continue;
                this.apmModel = this.apmModel + ruleVariable;
                ++interCount;
            }
            for (Reaction reaction : reactions) {
                String reactionmath = this.printReaction(reaction);
                if (reactionmath == null) {
                    this.apmModel = this.apmModel + "! Inconsistent mathML operators in Reaction " + reaction.getId();
                    continue;
                }
                this.apmModel = this.apmModel + reactionmath;
                ++interCount;
            }
            this.apmModel = this.apmModel + "\n End Intermediates\n\n";
            System.out.println("Equations...");
            this.apmModel = this.apmModel + " Equations\n";
            for (Rule rule : rules) {
                String rulemath = null;
                rulemath = rule instanceof AlgebraicRule ? this.printAlgebraicRule(rule) : this.printRule(rule);
                if (rulemath == null) continue;
                this.apmModel = this.apmModel + rulemath;
                ++eqCount;
            }
            for (Species species : listOfSpecies) {
                String speciesmath;
                if (species.isConstant() || (speciesmath = this.printSpecies(species)) == null) continue;
                this.apmModel = this.apmModel + speciesmath;
                ++eqCount;
            }
            this.apmModel = this.apmModel + " End Equations\n\n";
            int i = 1;
            for (Event event : events) {
                this.apmModel = this.apmModel + "\n";
                String eventId = event.getId();
                if (eventId == null || eventId.trim().length() == 0 || !idPattern.matcher(eventId).matches()) {
                    eventId = "event" + i;
                    event.setId(eventId);
                }
                this.apmModel = this.apmModel + "! event : " + eventId + "\n";
                this.buildIdMap((SBase)event);
                ++i;
                Delay delay = event.getDelay();
                Trigger trigger = event.getTrigger();
                ASTNode astTrigger = trigger.getMath();
                String infixASTTrigger = astTrigger.toFormula();
                infixASTTrigger = this.replaceIdInsideFormula(infixASTTrigger);
                if (trigger == null || !trigger.isSetMath()) {
                    this.apmModel = this.apmModel + "! the trigger of this event is null !!!\n";
                    this.apmModel = this.apmModel + "! event ignored.\n";
                    continue;
                }
                if (infixASTTrigger == null) {
                    this.apmModel = this.apmModel + "! the trigger contain some unsupported math elements.\n";
                    this.apmModel = this.apmModel + "! event ignored.\n\n";
                    continue;
                }
                if (delay != null && delay.isSetMath()) {
                    this.apmModel = this.apmModel + "! unable to handle events with delays currently.\n";
                    this.apmModel = this.apmModel + "! event ignored.\n\n";
                    continue;
                }
                this.apmModel = this.apmModel + APMID.getAPMId(eventId) + "=if (" + infixASTTrigger + ") then (1.5) else (0.2)\n";
                this.apmModel = this.apmModel + "global 1 {" + APMID.getAPMId(eventId) + " - 1.1} {";
                int j = 1;
                int eventAssignmentSize = event.getNumEventAssignments();
                boolean invalidMath = false;
                for (EventAssignment eventAssignment : event.getListOfEventAssignments()) {
                    String eventAssignmentMath = eventAssignment.getMath().toFormula();
                    if ((eventAssignmentMath = this.replaceIdInsideFormula(eventAssignmentMath)) == null) {
                        invalidMath = true;
                        if (j < eventAssignmentSize) continue;
                        this.apmModel = this.apmModel + "}\n";
                        continue;
                    }
                    this.apmModel = this.apmModel + eventAssignment.getVariable() + "=" + eventAssignmentMath;
                    this.apmModel = j < eventAssignmentSize ? this.apmModel + ";" : this.apmModel + "}\n";
                    ++j;
                }
                if (eventAssignmentSize == 0) {
                    this.apmModel = this.apmModel + "}\n";
                }
                if (!invalidMath) continue;
                this.apmModel = this.apmModel + "! some eventAssignment contained some unsupported math elements.\n";
                this.apmModel = this.apmModel + "! the eventAssignment(s) was(were) ignored.\n\n";
            }
            this.apmModel = this.apmModel + "\nEnd Model\n";
            this.apmModel = this.apmModel + "!Parameter Count:" + this.nbParameters + "\n";
            this.apmModel = this.apmModel + "!Variable Count:" + varCount + "\n";
            this.apmModel = this.apmModel + "!Intermediate Count:" + interCount + "\n";
            this.apmModel = this.apmModel + "!Equation Count:" + eqCount + "\n";
        }
        catch (AssertionError err) {
            this.apmModel = this.createHeader();
            this.apmModel = this.apmModel + "\n!\n! " + ((Throwable)((Object)err)).getMessage() + "\n!\n";
        }
        APMModel apmReturnModel = new APMModel();
        apmReturnModel.setModelFromString(this.apmModel);
        return apmReturnModel;
    }

    private String translatePiecewise(String infixFormula, ASTNode astNode) {
        int indexPiecewise = (infixFormula = infixFormula.trim()).indexOf("piecewise");
        if (indexPiecewise != -1) {
            try {
                infixFormula = astNode.compile((ASTNodeCompiler)this.apmFormulaCompiler).toString();
                infixFormula = this.replaceIdInsideFormula(infixFormula);
            }
            catch (SBMLException e) {
                e.printStackTrace();
            }
        }
        return infixFormula;
    }

    private String translateStepFunc(String infixFormula, ASTNode astNode) {
        int indexPiecewise = (infixFormula = infixFormula.trim()).indexOf("stepfunc");
        if (indexPiecewise != -1) {
            try {
                infixFormula = astNode.compile((ASTNodeCompiler)this.apmStepFuncCompiler).toString();
                infixFormula = this.replaceIdInsideFormula(infixFormula);
            }
            catch (SBMLException e) {
                e.printStackTrace();
            }
        }
        return infixFormula;
    }

    private String printFunctionDefinition(FunctionDefinition functiondefinition) throws SBMLException {
        String inputformula = functiondefinition.getMath().toFormula();
        inputformula = inputformula.replace("lambda(", "");
        ArrayList<String> functionParameters = new ArrayList<String>();
        StringTokenizer stcomma = new StringTokenizer(inputformula, ",");
        StringBuilder funcDef = new StringBuilder();
        StringBuilder formula = new StringBuilder();
        formula.append("(");
        int count = 0;
        int stCommaNb = stcomma.countTokens();
        while (stcomma.hasMoreTokens()) {
            String read = stcomma.nextToken().trim();
            ++count;
            if (read.contains(" ") || read.contains(" * ") || read.contains("/") || read.contains(")") || read.contains("(")) {
                formula.append(read);
                if (count >= stCommaNb) continue;
                formula.append(",");
                continue;
            }
            functionParameters.add(read);
        }
        String functionname = functiondefinition.getId();
        String apmid = APMID.getAPMId(functionname);
        funcDef.append(apmid + "(");
        for (int i = 0; i < functionParameters.size(); ++i) {
            if (i < functionParameters.size() - 1) {
                funcDef.append((String)functionParameters.get(i) + ",");
                continue;
            }
            funcDef.append((String)functionParameters.get(i));
        }
        String formulaStr = this.replaceIdInsideFormula(formula.toString());
        int piecewiseSize = this.apmFormulaCompiler.getPiecewiseMap().size();
        String formulaFunction = "";
        formulaFunction = this.translatePiecewise(functiondefinition.getMath().toFormula(), functiondefinition.getMath());
        String piecewiseId = "";
        if (this.apmFormulaCompiler.getPiecewiseMap().size() - piecewiseSize > 0) {
            int i = 1;
            for (String piecewiseID : this.apmFormulaCompiler.getPiecewiseMap().keySet()) {
                if (i == this.apmFormulaCompiler.getPiecewiseMap().size()) {
                    piecewiseId = this.apmFormulaCompiler.getPiecewiseMap().get(piecewiseID);
                }
                ++i;
            }
        }
        funcDef.append(")=" + formulaStr + "! " + formulaFunction + piecewiseId);
        if (this.matchMath(formulaStr, functionParameters, funcDef)) {
            return funcDef.toString();
        }
        String error = functiondefinition.getMath().toFormula();
        funcDef.append("!FunctionDef: " + error);
        return funcDef.toString();
    }

    private boolean matchMath(String formula, ArrayList<String> additionalValidNames, StringBuilder apmSB) {
        boolean support = true;
        Matcher mathMatcher = idPattern.matcher(formula);
        ArrayList<String> checkoperator = new ArrayList<String>();
        while (mathMatcher.find()) {
            checkoperator.add(mathMatcher.group());
        }
        for (String check : checkoperator) {
            if (APMID.getSBMLId(check) != null || this.mathOperators.contains(check) || check.startsWith("piecew") || additionalValidNames != null && additionalValidNames.contains(check)) continue;
            apmSB.append("! the operator " + check + " is not supported by apm\n");
            apmSB.append("! the formula is : " + formula + "\n");
            support = false;
        }
        return support;
    }

    private boolean matchMath(String formula, StringBuilder apmSB) {
        boolean support = true;
        Matcher mathMatcher = idPattern.matcher(formula);
        ArrayList<String> checkoperators = new ArrayList<String>();
        while (mathMatcher.find()) {
            checkoperators.add(mathMatcher.group());
        }
        for (String check : checkoperators) {
            if (APMID.getSBMLId(check) != null || this.mathOperators.contains(check) || check.startsWith("piecew")) continue;
            apmSB.append("! the operator " + check + " is not supported by apm\n");
            apmSB.append("! the formula is : " + formula + "\n");
            support = false;
        }
        return support;
    }

    private String printReaction(Reaction reaction) throws SBMLException {
        StringBuilder reactionStr = new StringBuilder();
        String reactionId = reaction.getId();
        KineticLaw kineticLaw = reaction.getKineticLaw();
        String kineticLawStr = "";
        if (kineticLaw != null) {
            kineticLawStr = kineticLaw.getMath().toFormula();
            ListOf localParameters = kineticLaw.getListOfParameters();
            for (LocalParameter parameter : localParameters) {
                this.buildIdMap(parameter, reaction);
                String parameterId = parameter.getId();
                String localParameterId = parameterId + "_" + reactionId;
                if (parameter.isSetValue()) {
                    // empty if block
                }
                kineticLawStr = this.replaceIdInsideFormula(kineticLawStr, parameterId, localParameterId);
            }
        } else {
            throw new AssertionError((Object)"!The model cannot be converted as there are some kineticLaw undefined.");
        }
        kineticLawStr = this.replaceIdInsideFormula(kineticLawStr);
        kineticLawStr = this.translatePiecewise(kineticLawStr, kineticLaw.getMath());
        kineticLawStr = this.replacePlusMinusInsideFormula(kineticLawStr);
        reactionStr.append("\n\t" + APMID.getAPMId(reaction.getId()) + "=" + kineticLawStr + "");
        reactionStr.append("\t! Reaction: id = " + reactionId);
        if (reaction.getName() != null && reaction.getName().trim().length() != 0) {
            reactionStr.append("\t! name = " + reaction.getName());
        }
        if (this.matchMath(kineticLawStr.toString(), reactionStr)) {
            return reactionStr.toString();
        }
        return null;
    }

    private String replaceIdInsideFormula(String formula, String oldId, String newId) {
        StringBuffer formulaWithIdsBuffer = new StringBuffer();
        Matcher formulaMatcher = idPattern.matcher(formula);
        while (formulaMatcher.find()) {
            String id = formulaMatcher.group().trim();
            if (id.equals(oldId)) {
                id = newId;
            }
            formulaMatcher.appendReplacement(formulaWithIdsBuffer, id);
        }
        formulaMatcher.appendTail(formulaWithIdsBuffer);
        return formulaWithIdsBuffer.toString();
    }

    private String replaceIdInsideFormula(String formula) {
        StringBuffer formulaWithIdsBuffer = new StringBuffer();
        Matcher formulaMatcher = idPattern.matcher(formula);
        while (formulaMatcher.find()) {
            String id = formulaMatcher.group().trim();
            String newId = APMID.getAPMId(id);
            if (newId == null) continue;
            formulaMatcher.appendReplacement(formulaWithIdsBuffer, newId);
        }
        formulaMatcher.appendTail(formulaWithIdsBuffer);
        return formulaWithIdsBuffer.toString();
    }

    private String replacePlusMinusInsideFormula(String formula) {
        StringBuffer formulaWithIdsBuffer = new StringBuffer();
        Matcher formulaMatcher = plusMinusPattern.matcher(formula);
        while (formulaMatcher.find()) {
            formulaMatcher.appendReplacement(formulaWithIdsBuffer, "- ");
        }
        formulaMatcher.appendTail(formulaWithIdsBuffer);
        return formulaWithIdsBuffer.toString();
    }

    private String printLocalParameter(LocalParameter parameter, String id) {
        StringBuilder paramStr = new StringBuilder();
        String apmId = APMID.getAPMId(id);
        paramStr.append("\t" + apmId + "=" + parameter.getValue() + "\n\n");
        paramStr.append(this.printLocalParameterComment(parameter));
        return paramStr.toString();
    }

    private String printRule(Rule rule) throws SBMLException {
        StringBuilder ruleStr = new StringBuilder();
        String variableId = null;
        if (rule.isRate()) {
            variableId = ((RateRule)rule).getVariable();
        } else if (rule.isAssignment()) {
            variableId = ((AssignmentRule)rule).getVariable();
        }
        String apmId = APMID.getAPMId(variableId);
        String mathMLStr = rule.getMath().toFormula();
        mathMLStr = this.replaceIdInsideFormula(mathMLStr);
        int piecewiseSize = this.apmFormulaCompiler.getPiecewiseMap().size();
        mathMLStr = this.translatePiecewise(mathMLStr, rule.getMath());
        String piecewiseId = "";
        if (this.apmFormulaCompiler.getPiecewiseMap().size() - piecewiseSize > 0) {
            int i = 1;
            for (String piecewiseID : this.apmFormulaCompiler.getPiecewiseMap().keySet()) {
                if (i == this.apmFormulaCompiler.getPiecewiseMap().size()) {
                    piecewiseId = this.apmFormulaCompiler.getPiecewiseMap().get(piecewiseID);
                }
                ++i;
            }
        }
        if (this.matchMath(mathMLStr, ruleStr)) {
            if (rule.isRate()) {
                RateRule variable = (RateRule)rule;
                String initialValue = "TODO";
                if (variable.getVariableInstance() instanceof Compartment) {
                    initialValue = "" + ((Compartment)variable.getVariableInstance()).getSize();
                } else if (variable.getVariableInstance() instanceof Species) {
                    initialValue = "" + ((Species)variable.getVariableInstance()).getInitialAmount();
                } else if (variable.getVariableInstance() instanceof Parameter) {
                    initialValue = "" + ((Parameter)variable.getVariableInstance()).getValue();
                }
                ruleStr.append("\t$" + apmId + "=" + mathMLStr + "");
            } else if (rule.isAssignment()) {
                return null;
            }
        } else {
            ruleStr.append("!Rule ignored : there are some unsupported functions !!\n");
        }
        ruleStr.append("\t! " + rule.getElementName() + ": variable = " + variableId + " " + piecewiseId + "\n");
        return ruleStr.toString();
    }

    private String printRuleIntermediate(Rule rule) throws SBMLException {
        StringBuilder ruleStr = new StringBuilder();
        String variableId = null;
        if (rule.isRate()) {
            variableId = ((RateRule)rule).getVariable();
        } else if (rule.isAssignment()) {
            variableId = ((AssignmentRule)rule).getVariable();
        }
        String apmId = APMID.getAPMId(variableId);
        String mathMLStr = rule.getMath().toFormula();
        String stepFunctionFormula = mathMLStr = this.replaceIdInsideFormula(mathMLStr);
        mathMLStr = this.translateStepFunc(mathMLStr, rule.getMath());
        if (this.matchMath(mathMLStr, ruleStr)) {
            if (rule.isRate()) {
                return null;
            }
            if (rule.isAssignment()) {
                AssignmentRule variable = (AssignmentRule)rule;
                String initialValue = "TODO";
                initialValue = variable.getVariableInstance() instanceof Compartment ? "=" + ((Compartment)variable.getVariableInstance()).getSize() : (variable.getVariableInstance() instanceof Species ? "=" + ((Species)variable.getVariableInstance()).getInitialAmount() : (variable.getVariableInstance() instanceof Parameter ? "=" + ((Parameter)variable.getVariableInstance()).getValue() : ""));
                ruleStr.append("\t" + apmId + "=" + mathMLStr + "");
            }
        } else {
            ruleStr.append("!Rule ignored : there are some unsupported functions !!" + mathMLStr + "");
        }
        ruleStr.append("\t!" + rule.getElementName() + ": Variable = " + variableId);
        int indexPiecewise = stepFunctionFormula.indexOf("stepfunc");
        if (indexPiecewise != -1) {
            ruleStr.append("\t!" + stepFunctionFormula);
        }
        ruleStr.append("\n");
        return ruleStr.toString();
    }

    private String printRuleParameter(Rule rule) throws SBMLException {
        StringBuilder ruleStr = new StringBuilder();
        String variableId = null;
        if (rule.isRate()) {
            variableId = ((RateRule)rule).getVariable();
        } else if (rule.isAssignment()) {
            variableId = ((AssignmentRule)rule).getVariable();
        }
        String apmId = APMID.getAPMId(variableId);
        String mathMLStr = rule.getMath().toFormula();
        mathMLStr = this.replaceIdInsideFormula(mathMLStr);
        if (this.matchMath(mathMLStr, ruleStr)) {
            if (rule.isRate()) {
                return null;
            }
            if (rule.isAssignment()) {
                double ruleParameterValue;
                AssignmentRule variable = (AssignmentRule)rule;
                String initialValue = "TODO";
                initialValue = variable.getVariableInstance() instanceof Compartment ? "=" + ((Compartment)variable.getVariableInstance()).getSize() : (variable.getVariableInstance() instanceof Species ? "=" + ((Species)variable.getVariableInstance()).getInitialAmount() : (variable.getVariableInstance() instanceof Parameter ? (Double.isNaN(ruleParameterValue = ((Parameter)variable.getVariableInstance()).getValue()) ? "\t! Not assigned" : "=" + ruleParameterValue) : ""));
                ruleStr.append("\t" + apmId + initialValue);
            }
        } else {
            ruleStr.append("!Rule ignored : there are some unsupported functions !!\n");
        }
        ruleStr.append("\t!RuleParameter " + rule.getElementName() + ": variable = " + variableId + "\n");
        return ruleStr.toString();
    }

    private String printRuleVariable(Rule rule) throws SBMLException {
        StringBuilder ruleStr = new StringBuilder();
        String variableId = null;
        if (rule.isRate()) {
            variableId = ((RateRule)rule).getVariable();
        } else if (rule.isAssignment()) {
            variableId = ((AssignmentRule)rule).getVariable();
        }
        String apmId = APMID.getAPMId(variableId);
        String mathMLStr = rule.getMath().toFormula();
        mathMLStr = this.replaceIdInsideFormula(mathMLStr);
        if (this.matchMath(mathMLStr, ruleStr)) {
            if (rule.isRate()) {
                RateRule variable = (RateRule)rule;
                String initialValue = "TODO";
                if (variable.getVariableInstance() instanceof Compartment) {
                    initialValue = "" + ((Compartment)variable.getVariableInstance()).getSize();
                } else if (variable.getVariableInstance() instanceof Species) {
                    initialValue = "" + ((Species)variable.getVariableInstance()).getInitialAmount();
                } else if (variable.getVariableInstance() instanceof Parameter) {
                    initialValue = "" + ((Parameter)variable.getVariableInstance()).getValue();
                }
                ruleStr.append("\t" + apmId + "=" + initialValue + "!Variable-From Rule\n");
            } else {
                return null;
            }
        }
        return ruleStr.toString();
    }

    private String printAlgebraicRule(Rule rule) throws SBMLException {
        StringBuilder ruleStr = new StringBuilder();
        String mathMLStr = rule.getMath().toFormula();
        if (this.matchMath(mathMLStr = this.replaceIdInsideFormula(mathMLStr), ruleStr)) {
            ruleStr.append("! " + rule.getElementName() + "\n");
            ruleStr.append("! Warning-Algebraic Rule, " + rule.getElementName() + " are not supported at the moment.\n");
            ruleStr.append("! " + mathMLStr + " = 0\n");
            return ruleStr.toString();
        }
        return null;
    }

    private String printSpecies(Species species) {
        StringBuilder speciesStr = new StringBuilder();
        String checkmath = null;
        String id = species.getId();
        boolean isAffectedByRule = false;
        boolean needInit = true;
        boolean auxDeclaration = false;
        for (Rule rule : this.sbmlModel.getListOfRules()) {
            if (!(rule instanceof ExplicitRule) || !id.equals(((ExplicitRule)rule).getVariable())) continue;
            isAffectedByRule = true;
            needInit = false;
        }
        id = APMID.getAPMId(species.getId());
        String apmModifier = "init ";
        if (!isAffectedByRule && (!this.hasReaction(id) || this.hasReaction(id) && species.isBoundaryCondition())) {
            apmModifier = "\t";
            auxDeclaration = true;
        }
        if (species.isBoundaryCondition()) {
            if (!isAffectedByRule && !this.hasEvent(species.getId())) {
                speciesStr.append("\t$" + id + "=0" + "\t");
                speciesStr.append("!WARNING speciesID: " + species.getId() + ", constant= false " + " , boundaryCondition = " + species.isBoundaryCondition() + " but is not involved in assignmentRule, rateRule or events !" + "\n");
            }
        } else if (!species.isBoundaryCondition() && !isAffectedByRule) {
            if (this.speciesFluxMap.get(species) != null && !this.isHasSubstanceUnits.get(species).booleanValue()) {
                String sbmlId = species.getCompartmentInstance().getId();
                String apmId = APMID.getAPMId(sbmlId);
                checkmath = " (1/(" + apmId + "))*(" + this.speciesFluxMap.get(species) + ")";
                speciesStr.append("\t$" + id + "=" + "(1/(" + apmId + "))*(" + this.speciesFluxMap.get(species) + ")\n");
            } else if (this.speciesFluxMap.get(species) != null) {
                speciesStr.append("\t$" + id + "=" + this.speciesFluxMap.get(species) + "\n");
            }
        }
        if (checkmath != null) {
            if (this.matchMath(checkmath, speciesStr)) {
                return speciesStr.toString();
            }
            return null;
        }
        return speciesStr.toString();
    }

    private String printSpeciesVariable(Species species) {
        StringBuilder speciesStr = new StringBuilder();
        Object checkmath = null;
        String id = species.getId();
        boolean isAffectedByRule = false;
        boolean needInit = true;
        boolean auxDeclaration = false;
        for (Rule rule : this.sbmlModel.getListOfRules()) {
            if (!(rule instanceof ExplicitRule) || !id.equals(((ExplicitRule)rule).getVariable())) continue;
            isAffectedByRule = true;
            needInit = false;
        }
        id = APMID.getAPMId(species.getId());
        String apmModifier = "init ";
        if (!isAffectedByRule && (!this.hasReaction(id) || this.hasReaction(id) && species.isBoundaryCondition())) {
            apmModifier = "Is not affected by rule or reaction";
            auxDeclaration = true;
        }
        if (needInit) {
            if (species.isSetInitialAmount() && species.isSetInitialConcentration()) {
                throw new AssertionError((Object)"!Error in model, both Initial concentration and Initial amount defined");
            }
            if (species.isSetInitialAmount()) {
                speciesStr.append("\t" + id + "=" + species.getInitialAmount() + "\t!" + apmModifier + "");
            } else if (species.isSetInitialConcentration()) {
                speciesStr.append("\t" + id + "=" + species.getInitialConcentration() + "\t!" + apmModifier + "");
            }
        }
        speciesStr.append(this.printSpeciesComment(species));
        return speciesStr.toString();
    }

    private boolean hasRule(String id) {
        for (Rule rule : this.sbmlModel.getListOfRules()) {
            if (!(rule instanceof ExplicitRule) || !id.equals(((ExplicitRule)rule).getVariable())) continue;
            return true;
        }
        return false;
    }

    private boolean hasEvent(String id) {
        for (Event event : this.sbmlModel.getListOfEvents()) {
            for (EventAssignment eventAssgnt : event.getListOfEventAssignments()) {
                if (!eventAssgnt.getVariable().equals(id)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasReaction(String id) {
        for (Reaction reaction : this.sbmlModel.getListOfReactions()) {
            for (SpeciesReference speciesRef : reaction.getListOfReactants()) {
                if (!speciesRef.getSpecies().equals(id)) continue;
                return true;
            }
            for (SpeciesReference speciesRef : reaction.getListOfProducts()) {
                if (!speciesRef.getSpecies().equals(id)) continue;
                return true;
            }
        }
        return false;
    }

    private String printConstantSpecies(Species species) {
        StringBuilder speciesStr = new StringBuilder();
        String id = APMID.getAPMId(species.getId());
        if (species.isSetInitialAmount() && species.isSetInitialConcentration()) {
            throw new AssertionError((Object)"Error in model, both Initial concentration and Initial amount defined");
        }
        if (species.isSetInitialAmount()) {
            speciesStr.append("\t" + id + "=" + species.getInitialAmount() + "\n\n");
        } else if (species.isSetInitialConcentration()) {
            speciesStr.append("\t" + id + "=" + species.getInitialConcentration() + "\n\n");
        }
        speciesStr.append(this.printSpeciesComment(species));
        return speciesStr.toString();
    }

    private String printSpeciesComment(Species species) {
        StringBuilder commentStr = new StringBuilder();
        String id = species.getId();
        String name = species.getName();
        if (name == null || name.trim().length() == 0) {
            name = id;
        }
        commentStr.append("\t! Species: ");
        commentStr.append("  id = " + id);
        commentStr.append(", name = " + name);
        if (species.getCompartment() != null) {
            commentStr.append("; Compartment:" + species.getCompartment());
        }
        if (species.isConstant()) {
            commentStr.append(", constant");
        } else {
            if (species.isBoundaryCondition()) {
                if (this.hasRule(id)) {
                    commentStr.append(", involved in a rule ");
                } else if (!this.hasRule(id)) {
                    // empty if block
                }
            } else if (!species.isBoundaryCondition()) {
                if (this.hasRule(id)) {
                    commentStr.append(", defined in a rule ");
                } else if (this.speciesFluxMap.get(species) != null) {
                    commentStr.append(", affected by kineticLaw");
                } else {
                    commentStr.append("\n! Warning species is not changed by either rules or reactions\n");
                }
            }
            int nbEvent = this.getNbAffectingEvent((SBase)species);
            if (nbEvent > 0) {
                commentStr.append("! Species is changed by " + nbEvent + " event(s)");
            }
        }
        commentStr.append("\n");
        return commentStr.toString();
    }

    private int getNbAffectingEvent(SBase element) {
        int n = 0;
        if (element instanceof NamedSBase) {
            String elementId = ((NamedSBase)element).getId();
            block0: for (Event event : this.sbmlModel.getListOfEvents()) {
                for (EventAssignment eventAssignment : event.getListOfEventAssignments()) {
                    if (!elementId.equals(eventAssignment.getVariable())) continue;
                    ++n;
                    continue block0;
                }
            }
        }
        return n;
    }

    private String printParameter(Parameter parameter) {
        StringBuilder paramStr = new StringBuilder();
        boolean hasRule = this.hasRule(parameter.getId());
        if (hasRule) {
            return null;
        }
        String id = APMID.getAPMId(parameter.getId());
        paramStr.append("\t" + id + "=" + parameter.getValue() + "");
        paramStr.append(this.printParameterComment(parameter));
        return paramStr.toString();
    }

    private String printParameterConstant(Parameter parameter) {
        StringBuilder paramStr = new StringBuilder();
        String id = APMID.getAPMId(parameter.getId());
        paramStr.append("\t" + id + "=" + parameter.getValue());
        paramStr.append(this.printParameterComment(parameter));
        return paramStr.toString();
    }

    private String printParameterComment(Parameter parameter) {
        StringBuilder commentStr = new StringBuilder();
        String id = parameter.getId();
        String name = parameter.getName();
        if (name == null || name.trim().length() == 0) {
            name = id;
        }
        commentStr.append("\t! Parameter: ");
        commentStr.append("  id =  " + id);
        commentStr.append(", name = " + name);
        if (parameter.isConstant()) {
            commentStr.append(", constant");
        }
        if (this.hasRule(id)) {
            commentStr.append(", defined by a Rule");
        }
        commentStr.append("\n");
        return commentStr.toString();
    }

    private String printLocalParameterComment(LocalParameter parameter) {
        StringBuilder commentStr = new StringBuilder();
        String id = parameter.getId();
        String name = parameter.getName();
        if (name == null || name.trim().length() == 0) {
            name = id;
        }
        commentStr.append("\t! Local Parameter: ");
        commentStr.append("  id =  " + id);
        commentStr.append(", name = " + name);
        commentStr.append("\n");
        return commentStr.toString();
    }

    private String printCompartment(Compartment compartment) {
        StringBuilder compStr = new StringBuilder();
        compStr.append(this.printCompartmentComment(compartment));
        if (!this.hasRule(compartment.getId())) {
            compStr.append("! Warning compartment " + compartment.getId() + " has no rule and is not constant" + "\n");
        }
        return compStr.toString();
    }

    private String printCompartmentComment(Compartment compartment) {
        StringBuilder compCommentStr = new StringBuilder();
        String id = compartment.getId();
        String name = compartment.getName();
        if (name == null || name.trim().length() == 0) {
            name = id;
        }
        compCommentStr.append("! Compartment: id = " + id + ", name = " + name);
        if (compartment.isConstant()) {
            compCommentStr.append(", constant");
        } else if (this.hasRule(id)) {
            compCommentStr.append(", defined by a Rule");
        }
        compCommentStr.append("\n");
        return compCommentStr.toString();
    }

    private String printConstantCompartment(Compartment compartment) {
        StringBuilder compStr = new StringBuilder();
        String id = APMID.getAPMId(compartment.getId());
        compStr.append("\t" + id + "=" + compartment.getSize());
        compStr.append(this.printCompartmentComment(compartment));
        return compStr.toString();
    }

    private void buildIdMap(SBase element) {
        String id = ((NamedSBase)element).getId();
        APMID apmId = new APMID(id);
        apmId.checkAPMId();
    }

    private void buildIdMap(LocalParameter parameter, Reaction reaction) {
        String id = parameter.getId();
        APMID apmId = new APMID(id, reaction.getId());
        apmId.checkAPMId();
    }

    @Override
    public GeneralModel convert(GeneralModel model) throws ConversionException, ReadModelException {
        try {
            this.inputModel = model;
            return this.apmExport((SBMLModel)model);
        }
        catch (SBMLException e) {
            throw new ReadModelException(e);
        }
        catch (ReadModelException e) {
            throw e;
        }
        catch (ConversionException e) {
            throw e;
        }
    }

    @Override
    public String getResultExtension() {
        return ".apm";
    }

    @Override
    public String getName() {
        return "SBML2APM";
    }

    @Override
    public String getDescription() {
        return "It converts a model format from SBML to APM";
    }

    @Override
    public String getHtmlDescription() {
        return "It converts a model format from SBML to APM";
    }
}

