/*
 * Decompiled with CFR 0.152.
 */
package org.sbfc.converter.sbml2apm;

import java.util.HashMap;

public class APMID {
    private static HashMap<String, APMID> apmIdMap = new HashMap();
    private static HashMap<String, Integer> apmIdReduceMap = new HashMap();
    private static HashMap<String, APMID> sbmlIdMap = new HashMap();
    private String sbmlId;
    private String apmId;
    private String apmIdUpercase;

    public APMID(String sbmlId) {
        this.sbmlId = sbmlId;
        this.apmId = sbmlId;
        if (this.apmId.equalsIgnoreCase("time")) {
            this.apmId = "t";
        } else if (this.apmId.equalsIgnoreCase("floor")) {
            this.apmId = "flr";
        } else if (this.apmId.equalsIgnoreCase("t")) {
            this.apmId = sbmlId + "_renamed";
        } else if (this.apmId.equalsIgnoreCase("pi")) {
            this.apmId = sbmlId + "_ren";
        }
        this.apmIdUpercase = sbmlId.toUpperCase();
    }

    public APMID(String sbmlId, String sbmlReactionId) {
        this.sbmlId = sbmlId + "_" + sbmlReactionId;
        this.apmId = sbmlId;
        this.apmIdUpercase = this.apmId.toUpperCase();
    }

    public void checkAPMId() {
        if (this.apmId.length() > 9) {
            this.apmId = this.apmId.substring(0, 9);
            this.apmIdUpercase = this.apmId.toUpperCase();
        }
        boolean isUnique = false;
        Integer idNb = apmIdReduceMap.get(this.apmIdUpercase);
        int i = 1;
        if (idNb != null) {
            i = idNb;
        }
        while (!isUnique) {
            APMID conflictingId = apmIdMap.get(this.apmIdUpercase);
            if (conflictingId == null) {
                isUnique = true;
                break;
            }
            this.reduceId(i);
            ++i;
        }
        this.apmIdUpercase = this.apmId.toUpperCase();
        apmIdMap.put(this.apmIdUpercase, this);
        apmIdReduceMap.put(this.apmIdUpercase, i);
        sbmlIdMap.put(this.sbmlId, this);
    }

    private void reduceId(int i) {
        if (i < 10) {
            if (this.apmId.length() > 7) {
                this.apmId = this.apmId.substring(0, 7);
            }
            this.apmId = this.apmId + "_" + i;
        } else if (i < 100) {
            if (this.apmId.length() > 6) {
                this.apmId = this.apmId.substring(0, 6);
            }
            this.apmId = this.apmId + "_" + i;
        } else {
            if (this.apmId.length() > 4) {
                this.apmId = this.apmId.substring(0, 4);
            }
            this.apmId = this.apmId + "_" + i;
        }
        this.apmIdUpercase = this.apmId.toUpperCase();
    }

    public boolean equals(Object obj) {
        if (obj instanceof APMID) {
            return ((APMID)obj).getXppId().equalsIgnoreCase(this.apmId);
        }
        if (obj instanceof String) {
            return ((String)obj).equalsIgnoreCase(this.apmId);
        }
        return false;
    }

    public int hashCode() {
        return this.apmIdUpercase.hashCode();
    }

    public String toString() {
        return this.apmId;
    }

    public String getSbmlId() {
        return this.sbmlId;
    }

    public String getXppId() {
        return this.apmId;
    }

    public String getXppIdUpercase() {
        return this.apmIdUpercase;
    }

    public static String getSBMLId(String apmId) {
        APMID id = apmIdMap.get(apmId.toUpperCase());
        if (id == null) {
            return null;
        }
        return id.getSbmlId();
    }

    public static String getAPMId(String sbmlId) {
        APMID id = sbmlIdMap.get(sbmlId);
        if (id == null) {
            return null;
        }
        return id.getXppId();
    }

    static {
        sbmlIdMap.put("time", new APMID("time"));
        sbmlIdMap.put("Time", new APMID("time"));
        sbmlIdMap.put("floor", new APMID("floor"));
    }
}

