/*
 * Decompiled with CFR 0.152.
 */
package org.sbfc.converter.models;

import java.io.File;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.pathvisio.core.util.RootElementFinder;
import org.sbfc.converter.exceptions.ReadModelException;
import org.sbfc.converter.exceptions.WriteModelException;
import org.sbfc.converter.models.GeneralModel;
import org.sbml.jsbml.JSBML;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.TidySBMLWriter;

public class SBMLModel
implements GeneralModel {
    private SBMLDocument document;
    private String fileName;

    public SBMLModel() {
    }

    public SBMLModel(SBMLDocument value) {
        this.document = value;
    }

    public Model getModel() {
        if (this.document != null) {
            return this.document.getModel();
        }
        return null;
    }

    public SBMLDocument getSBMLDocument() {
        if (this.document != null) {
            return this.document;
        }
        return null;
    }

    @Override
    public void setModelFromFile(String fileName) throws ReadModelException {
        this.document = this.modelFromFile(fileName);
    }

    @Override
    public void setModelFromString(String modelString) throws ReadModelException {
        this.document = this.modelFromString(modelString);
    }

    @Override
    public String[] getExtensions() {
        return new String[]{".xml", ".sbml"};
    }

    @Override
    public void modelToFile(String fileName) throws WriteModelException {
        try {
            new TidySBMLWriter().writeSBMLToFile(this.document, fileName);
        }
        catch (XMLStreamException e) {
            throw new WriteModelException(e);
        }
        catch (IOException e) {
            throw new WriteModelException(e);
        }
        catch (SBMLException e) {
            throw new WriteModelException(e);
        }
    }

    public SBMLDocument modelFromFile(String fileName) throws ReadModelException {
        try {
            this.document = JSBML.readSBML((String)fileName);
            this.fileName = fileName;
        }
        catch (XMLStreamException e) {
            throw new ReadModelException(e);
        }
        catch (IOException e) {
            throw new ReadModelException(e);
        }
        return this.document;
    }

    public SBMLDocument modelFromString(String modelString) throws ReadModelException {
        try {
            this.document = JSBML.readSBMLFromString((String)modelString);
            this.fileName = null;
        }
        catch (XMLStreamException e) {
            throw new ReadModelException(e);
        }
        return this.document;
    }

    @Override
    public String modelToString() throws WriteModelException {
        String reString = null;
        try {
            reString = new TidySBMLWriter().writeSBMLToString(this.document);
        }
        catch (XMLStreamException e) {
            throw new WriteModelException(e);
        }
        catch (SBMLException e) {
            throw new WriteModelException(e);
        }
        return reString;
    }

    public String getModelFileName() {
        return this.fileName;
    }

    @Override
    public boolean isCorrectType(File f) {
        try {
            String uri = "" + RootElementFinder.getRootUri((File)f);
            return uri.startsWith("http://www.sbml.org/");
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getURI() {
        return "http://identifiers.org/combine.specifications/sbml";
    }
}

